(ns
 pandect.algo.ripemd256
 "RipeMD256 algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol G__1262 (compute-ripemd2561260 [data1261]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1262 #'compute-ripemd2561260]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1262
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-ripemd2561260
    [data1261]
    (clojure.core/let
     [md__682__auto__
      (java.security.MessageDigest/getInstance "RipeMD256")]
     (.digest md__682__auto__ data1261)))
   java.lang.String
   (compute-ripemd2561260
    [data1261]
    (clojure.core/let
     [data1261 (.getBytes data1261 "UTF-8")]
     (clojure.core/let
      [md__682__auto__
       (java.security.MessageDigest/getInstance "RipeMD256")]
      (.digest md__682__auto__ data1261)))))
  (clojure.core/extend-protocol
   G__1262
   java.io.InputStream
   (compute-ripemd2561260
    [data1261]
    (clojure.core/let
     [md__683__auto__
      (java.security.MessageDigest/getInstance "RipeMD256")
      c__684__auto__
      (clojure.core/int *buffer-size*)
      buf__685__auto__
      (clojure.core/byte-array c__684__auto__)
      s__686__auto__
      data1261]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__687__auto__
        (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__687__auto__ -1)
        (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
        (recur))))
     (.digest md__683__auto__)))
   java.io.File
   (compute-ripemd2561260
    [data1261]
    (clojure.core/with-open
     [data1261 (clojure.java.io/input-stream data1261)]
     (clojure.core/let
      [md__683__auto__
       (java.security.MessageDigest/getInstance "RipeMD256")
       c__684__auto__
       (clojure.core/int *buffer-size*)
       buf__685__auto__
       (clojure.core/byte-array c__684__auto__)
       s__686__auto__
       data1261]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__687__auto__
         (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__687__auto__ -1)
         (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
         (recur))))
      (.digest md__683__auto__)))))
  'G__1262)
 (do
  (clojure.core/defn
   ripemd256*
   "[Hash] RipeMD256 (raw value)"
   [x]
   (compute-ripemd2561260 x))
  (clojure.core/defn
   ripemd256-file*
   "[Hash] RipeMD256 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd2561260 x)))
  (clojure.core/defn
   ripemd256-bytes
   "[Hash] RipeMD256 (value -> byte array)"
   [x]
   (compute-ripemd2561260 x))
  (clojure.core/defn
   ripemd256-file-bytes
   "[Hash] RipeMD256 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd2561260 x)))
  (clojure.core/defn
   ripemd256
   "[Hash] RipeMD256 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-ripemd2561260 x)))
  (clojure.core/defn
   ripemd256-file
   "[Hash] RipeMD256 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-ripemd2561260 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1288
   (compute-ripemd2561285 [data1286 key1287]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1288 #'compute-ripemd2561285]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1288
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-ripemd2561285
    [data1286 key1287]
    (clojure.core/let
     [mac__557__auto__
      (javax.crypto.Mac/getInstance "Hmac-RipeMD256")
      msg__558__auto__
      (clojure.core/bytes data1286)
      k__559__auto__
      (javax.crypto.spec.SecretKeySpec. key1287 "Hmac-RipeMD256")]
     (clojure.core/->
      (clojure.core/doto
       mac__557__auto__
       (.init k__559__auto__)
       (.update msg__558__auto__))
      (.doFinal))))
   java.lang.String
   (compute-ripemd2561285
    [data1286 key1287]
    (clojure.core/let
     [data1286 (.getBytes data1286 "UTF-8")]
     (clojure.core/let
      [mac__557__auto__
       (javax.crypto.Mac/getInstance "Hmac-RipeMD256")
       msg__558__auto__
       (clojure.core/bytes data1286)
       k__559__auto__
       (javax.crypto.spec.SecretKeySpec. key1287 "Hmac-RipeMD256")]
      (clojure.core/->
       (clojure.core/doto
        mac__557__auto__
        (.init k__559__auto__)
        (.update msg__558__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1288
   java.io.InputStream
   (compute-ripemd2561285
    [data1286 key1287]
    (clojure.core/let
     [mac__560__auto__
      (javax.crypto.Mac/getInstance "Hmac-RipeMD256")
      k__561__auto__
      (javax.crypto.spec.SecretKeySpec. key1287 "Hmac-RipeMD256")
      c__562__auto__
      (clojure.core/int *buffer-size*)
      buf__563__auto__
      (clojure.core/byte-array c__562__auto__)
      s__564__auto__
      data1286]
     (.init mac__560__auto__ k__561__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__565__auto__
        (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__565__auto__ -1)
        (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
        (recur))))
     (.doFinal mac__560__auto__)))
   java.io.File
   (compute-ripemd2561285
    [data1286 key1287]
    (clojure.core/with-open
     [data1286 (clojure.java.io/input-stream data1286)]
     (clojure.core/let
      [mac__560__auto__
       (javax.crypto.Mac/getInstance "Hmac-RipeMD256")
       k__561__auto__
       (javax.crypto.spec.SecretKeySpec. key1287 "Hmac-RipeMD256")
       c__562__auto__
       (clojure.core/int *buffer-size*)
       buf__563__auto__
       (clojure.core/byte-array c__562__auto__)
       s__564__auto__
       data1286]
      (.init mac__560__auto__ k__561__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__565__auto__
         (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__565__auto__ -1)
         (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
         (recur))))
      (.doFinal mac__560__auto__)))))
  'G__1288)
 (do
  (clojure.core/defn
   ripemd256-hmac*
   "[HMAC] Hmac-RipeMD256 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-ripemd2561285
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   ripemd256-hmac-file*
   "[HMAC] Hmac-RipeMD256 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd2561285
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   ripemd256-hmac-bytes
   "[HMAC] Hmac-RipeMD256 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-ripemd2561285
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   ripemd256-hmac-file-bytes
   "[HMAC] Hmac-RipeMD256 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd2561285
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   ripemd256-hmac
   "[HMAC] Hmac-RipeMD256 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-ripemd2561285
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   ripemd256-hmac-file
   "[HMAC] Hmac-RipeMD256 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-ripemd2561285
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
