(ns
 pandect.algo.sha256
 "SHA-256 algorithm implementation"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]))
(do
 (do
  (clojure.core/defprotocol G__1305 (compute-sha2561303 [data1304]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1305 #'compute-sha2561303]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1305
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha2561303
    [data1304]
    (clojure.core/let
     [md__682__auto__
      (java.security.MessageDigest/getInstance "SHA-256")]
     (.digest md__682__auto__ data1304)))
   java.lang.String
   (compute-sha2561303
    [data1304]
    (clojure.core/let
     [data1304 (.getBytes data1304 "UTF-8")]
     (clojure.core/let
      [md__682__auto__
       (java.security.MessageDigest/getInstance "SHA-256")]
      (.digest md__682__auto__ data1304)))))
  (clojure.core/extend-protocol
   G__1305
   java.io.InputStream
   (compute-sha2561303
    [data1304]
    (clojure.core/let
     [md__683__auto__
      (java.security.MessageDigest/getInstance "SHA-256")
      c__684__auto__
      (clojure.core/int *buffer-size*)
      buf__685__auto__
      (clojure.core/byte-array c__684__auto__)
      s__686__auto__
      data1304]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__687__auto__
        (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__687__auto__ -1)
        (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
        (recur))))
     (.digest md__683__auto__)))
   java.io.File
   (compute-sha2561303
    [data1304]
    (clojure.core/with-open
     [data1304 (clojure.java.io/input-stream data1304)]
     (clojure.core/let
      [md__683__auto__
       (java.security.MessageDigest/getInstance "SHA-256")
       c__684__auto__
       (clojure.core/int *buffer-size*)
       buf__685__auto__
       (clojure.core/byte-array c__684__auto__)
       s__686__auto__
       data1304]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__687__auto__
         (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__687__auto__ -1)
         (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
         (recur))))
      (.digest md__683__auto__)))))
  'G__1305)
 (do
  (clojure.core/defn
   sha256*
   "[Hash] SHA-256 (raw value)"
   [x]
   (compute-sha2561303 x))
  (clojure.core/defn
   sha256-file*
   "[Hash] SHA-256 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha2561303 x)))
  (clojure.core/defn
   sha256-bytes
   "[Hash] SHA-256 (value -> byte array)"
   [x]
   (compute-sha2561303 x))
  (clojure.core/defn
   sha256-file-bytes
   "[Hash] SHA-256 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha2561303 x)))
  (clojure.core/defn
   sha256
   "[Hash] SHA-256 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-sha2561303 x)))
  (clojure.core/defn
   sha256-file
   "[Hash] SHA-256 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-sha2561303 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1328
   (compute-sha2561325 [data1326 key1327]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1328 #'compute-sha2561325]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1328
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha2561325
    [data1326 key1327]
    (clojure.core/let
     [mac__557__auto__
      (javax.crypto.Mac/getInstance "HmacSHA256")
      msg__558__auto__
      (clojure.core/bytes data1326)
      k__559__auto__
      (javax.crypto.spec.SecretKeySpec. key1327 "HmacSHA256")]
     (clojure.core/->
      (clojure.core/doto
       mac__557__auto__
       (.init k__559__auto__)
       (.update msg__558__auto__))
      (.doFinal))))
   java.lang.String
   (compute-sha2561325
    [data1326 key1327]
    (clojure.core/let
     [data1326 (.getBytes data1326 "UTF-8")]
     (clojure.core/let
      [mac__557__auto__
       (javax.crypto.Mac/getInstance "HmacSHA256")
       msg__558__auto__
       (clojure.core/bytes data1326)
       k__559__auto__
       (javax.crypto.spec.SecretKeySpec. key1327 "HmacSHA256")]
      (clojure.core/->
       (clojure.core/doto
        mac__557__auto__
        (.init k__559__auto__)
        (.update msg__558__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1328
   java.io.InputStream
   (compute-sha2561325
    [data1326 key1327]
    (clojure.core/let
     [mac__560__auto__
      (javax.crypto.Mac/getInstance "HmacSHA256")
      k__561__auto__
      (javax.crypto.spec.SecretKeySpec. key1327 "HmacSHA256")
      c__562__auto__
      (clojure.core/int *buffer-size*)
      buf__563__auto__
      (clojure.core/byte-array c__562__auto__)
      s__564__auto__
      data1326]
     (.init mac__560__auto__ k__561__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__565__auto__
        (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__565__auto__ -1)
        (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
        (recur))))
     (.doFinal mac__560__auto__)))
   java.io.File
   (compute-sha2561325
    [data1326 key1327]
    (clojure.core/with-open
     [data1326 (clojure.java.io/input-stream data1326)]
     (clojure.core/let
      [mac__560__auto__
       (javax.crypto.Mac/getInstance "HmacSHA256")
       k__561__auto__
       (javax.crypto.spec.SecretKeySpec. key1327 "HmacSHA256")
       c__562__auto__
       (clojure.core/int *buffer-size*)
       buf__563__auto__
       (clojure.core/byte-array c__562__auto__)
       s__564__auto__
       data1326]
      (.init mac__560__auto__ k__561__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__565__auto__
         (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__565__auto__ -1)
         (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
         (recur))))
      (.doFinal mac__560__auto__)))))
  'G__1328)
 (do
  (clojure.core/defn
   sha256-hmac*
   "[HMAC] HmacSHA256 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-sha2561325
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   sha256-hmac-file*
   "[HMAC] HmacSHA256 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha2561325
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha256-hmac-bytes
   "[HMAC] HmacSHA256 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-sha2561325
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   sha256-hmac-file-bytes
   "[HMAC] HmacSHA256 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha2561325
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha256-hmac
   "[HMAC] HmacSHA256 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-sha2561325
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha256-hmac-file
   "[HMAC] HmacSHA256 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-sha2561325
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
(do
 (do
  (clojure.core/defprotocol
   G__1358
   (compute-sha2561354 [data1355 key1357])
   (compute-sha2561354-verify [data1355 sig1356 key1357]))
  (clojure.core/doseq
   [v__198__auto__
    [#'G__1358 #'compute-sha2561354 #'compute-sha2561354-verify]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1358
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha2561354
    [data1355 key1357]
    (clojure.core/let
     [signer__861__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "SHA256withRSA")
       (.initSign key1357)
       (.update (clojure.core/bytes data1355)))]
     (.sign signer__861__auto__)))
   (compute-sha2561354-verify
    [data1355 sig1356 key1357]
    (clojure.core/let
     [signer__862__auto__
      (java.security.Signature/getInstance "SHA256withRSA")
      key__863__auto__
      (pandect.utils.convert/as-public-key key1357)]
     (.initVerify signer__862__auto__ key__863__auto__)
     (.update signer__862__auto__ (clojure.core/bytes data1355))
     (.verify signer__862__auto__ (clojure.core/bytes sig1356))))
   java.lang.String
   (compute-sha2561354
    [data1355 key1357]
    (clojure.core/let
     [data1355 (.getBytes data1355 "UTF-8")]
     (clojure.core/let
      [signer__861__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "SHA256withRSA")
        (.initSign key1357)
        (.update (clojure.core/bytes data1355)))]
      (.sign signer__861__auto__))))
   (compute-sha2561354-verify
    [data1355 sig1356 key1357]
    (clojure.core/let
     [data1355 (.getBytes data1355 "UTF-8")]
     (clojure.core/let
      [signer__862__auto__
       (java.security.Signature/getInstance "SHA256withRSA")
       key__863__auto__
       (pandect.utils.convert/as-public-key key1357)]
      (.initVerify signer__862__auto__ key__863__auto__)
      (.update signer__862__auto__ (clojure.core/bytes data1355))
      (.verify signer__862__auto__ (clojure.core/bytes sig1356))))))
  (clojure.core/extend-protocol
   G__1358
   java.io.InputStream
   (compute-sha2561354
    [data1355 key1357]
    (clojure.core/let
     [signer__864__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "SHA256withRSA")
       (.initSign key1357))
      c__865__auto__
      (clojure.core/int *buffer-size*)
      buf__866__auto__
      (clojure.core/byte-array c__865__auto__)
      s__867__auto__
      data1355]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__868__auto__
        (.read s__867__auto__ buf__866__auto__ 0 c__865__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__868__auto__ -1)
        (.update signer__864__auto__ buf__866__auto__ 0 r__868__auto__)
        (recur))))
     (.sign signer__864__auto__)))
   (compute-sha2561354-verify
    [data1355 sig1356 key1357]
    (clojure.core/let
     [signer__869__auto__
      (java.security.Signature/getInstance "SHA256withRSA")
      c__870__auto__
      (clojure.core/int *buffer-size*)
      buf__871__auto__
      (clojure.core/byte-array c__870__auto__)
      s__872__auto__
      data1355
      key__873__auto__
      (pandect.utils.convert/as-public-key key1357)]
     (.initVerify signer__869__auto__ key__873__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__874__auto__
        (.read s__872__auto__ buf__871__auto__ 0 c__870__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__874__auto__ -1)
        (.update signer__869__auto__ buf__871__auto__ 0 r__874__auto__)
        (recur))))
     (.verify signer__869__auto__ (clojure.core/bytes sig1356))))
   java.io.File
   (compute-sha2561354
    [data1355 key1357]
    (clojure.core/with-open
     [data1355 (clojure.java.io/input-stream data1355)]
     (clojure.core/let
      [signer__864__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "SHA256withRSA")
        (.initSign key1357))
       c__865__auto__
       (clojure.core/int *buffer-size*)
       buf__866__auto__
       (clojure.core/byte-array c__865__auto__)
       s__867__auto__
       data1355]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__868__auto__
         (.read s__867__auto__ buf__866__auto__ 0 c__865__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__868__auto__ -1)
         (.update
          signer__864__auto__
          buf__866__auto__
          0
          r__868__auto__)
         (recur))))
      (.sign signer__864__auto__))))
   (compute-sha2561354-verify
    [data1355 sig1356 key1357]
    (clojure.core/with-open
     [data1355 (clojure.java.io/input-stream data1355)]
     (clojure.core/let
      [signer__869__auto__
       (java.security.Signature/getInstance "SHA256withRSA")
       c__870__auto__
       (clojure.core/int *buffer-size*)
       buf__871__auto__
       (clojure.core/byte-array c__870__auto__)
       s__872__auto__
       data1355
       key__873__auto__
       (pandect.utils.convert/as-public-key key1357)]
      (.initVerify signer__869__auto__ key__873__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__874__auto__
         (.read s__872__auto__ buf__871__auto__ 0 c__870__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__874__auto__ -1)
         (.update
          signer__869__auto__
          buf__871__auto__
          0
          r__874__auto__)
         (recur))))
      (.verify signer__869__auto__ (clojure.core/bytes sig1356))))))
  'G__1358)
 (do
  (clojure.core/defn
   sha256-rsa*
   "[Signature] SHA256withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-sha2561354 x private-key))
  (clojure.core/defn
   sha256-rsa-file*
   "[Signature] SHA256withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha2561354 x private-key)))
  (clojure.core/defn
   sha256-rsa-bytes
   "[Signature] SHA256withRSA (value -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-sha2561354 x private-key))
  (clojure.core/defn
   sha256-rsa-file-bytes
   "[Signature] SHA256withRSA (file path -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha2561354 x private-key)))
  (clojure.core/defn
   sha256-rsa
   "[Signature] SHA256withRSA (value -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (pandect.utils.convert/bytes->hex
    (compute-sha2561354 x private-key)))
  (clojure.core/defn
   sha256-rsa-file
   "[Signature] SHA256withRSA (file path -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-sha2561354 x private-key))))
  (clojure.core/defn
   sha256-rsa-verify
   "[Signature] SHA256withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (compute-sha2561354-verify
    x
    (pandect.utils.convert/convert-signature-to-byte-array signature)
    (pandect.utils.convert/convert-to-public-key public-key)))
  (clojure.core/defn
   sha256-rsa-verify-file
   "[Signature] SHA256withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha2561354-verify
     x
     (pandect.utils.convert/convert-signature-to-byte-array signature)
     (pandect.utils.convert/convert-to-public-key public-key))))))
