(ns
 pandect.algo.crc32
 "CRC-32 algorithm implementation"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]))
(do
 (do
  (clojure.core/defprotocol G__1200 (compute-crc321198 [data1199]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1200 #'compute-crc321198]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1200
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-crc321198
    [data1199]
    (clojure.core/let
     [buf__916__auto__
      (clojure.core/bytes data1199)
      a__917__auto__
      (new java.util.zip.CRC32)]
     (.update
      a__917__auto__
      buf__916__auto__
      0
      (clojure.core/alength buf__916__auto__))
     (.getValue a__917__auto__)))
   java.lang.String
   (compute-crc321198
    [data1199]
    (clojure.core/let
     [data1199 (.getBytes data1199 "UTF-8")]
     (clojure.core/let
      [buf__916__auto__
       (clojure.core/bytes data1199)
       a__917__auto__
       (new java.util.zip.CRC32)]
      (.update
       a__917__auto__
       buf__916__auto__
       0
       (clojure.core/alength buf__916__auto__))
      (.getValue a__917__auto__)))))
  (clojure.core/extend-protocol
   G__1200
   java.io.InputStream
   (compute-crc321198
    [data1199]
    (clojure.core/let
     [s__918__auto__
      data1199
      c__919__auto__
      (clojure.core/int *buffer-size*)
      buf__920__auto__
      (clojure.core/byte-array c__919__auto__)
      a__921__auto__
      (new java.util.zip.CRC32)]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__922__auto__
        (.read s__918__auto__ buf__920__auto__ 0 c__919__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__922__auto__ -1)
        (.update a__921__auto__ buf__920__auto__ 0 r__922__auto__)
        (recur))))
     (.getValue a__921__auto__)))
   java.io.File
   (compute-crc321198
    [data1199]
    (clojure.core/with-open
     [data1199 (clojure.java.io/input-stream data1199)]
     (clojure.core/let
      [s__918__auto__
       data1199
       c__919__auto__
       (clojure.core/int *buffer-size*)
       buf__920__auto__
       (clojure.core/byte-array c__919__auto__)
       a__921__auto__
       (new java.util.zip.CRC32)]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__922__auto__
         (.read s__918__auto__ buf__920__auto__ 0 c__919__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__922__auto__ -1)
         (.update a__921__auto__ buf__920__auto__ 0 r__922__auto__)
         (recur))))
      (.getValue a__921__auto__)))))
  'G__1200)
 (do
  (clojure.core/defn
   crc32*
   "[Hash] CRC-32 (raw value)"
   [x]
   (compute-crc321198 x))
  (clojure.core/defn
   crc32-file*
   "[Hash] CRC-32 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-crc321198 x)))
  (clojure.core/defn
   crc32-bytes
   "[Hash] CRC-32 (value -> byte array)"
   [x]
   (pandect.utils.convert/long->4-bytes (compute-crc321198 x)))
  (clojure.core/defn
   crc32-file-bytes
   "[Hash] CRC-32 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/long->4-bytes (compute-crc321198 x))))
  (clojure.core/defn
   crc32
   "[Hash] CRC-32 (value -> string)"
   [x]
   (pandect.utils.convert/long->hex (compute-crc321198 x)))
  (clojure.core/defn
   crc32-file
   "[Hash] CRC-32 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/long->hex (compute-crc321198 x))))))
