(ns
 pandect.algo.keccak-512
 "Keccak-512 algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol
   G__1209
   (compute-keccak-5121207 [data1208]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1209 #'compute-keccak-5121207]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1209
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-keccak-5121207
    [data1208]
    (clojure.core/let
     [md__682__auto__
      (java.security.MessageDigest/getInstance "Keccak-512")]
     (.digest md__682__auto__ data1208)))
   java.lang.String
   (compute-keccak-5121207
    [data1208]
    (clojure.core/let
     [data1208 (.getBytes data1208 "UTF-8")]
     (clojure.core/let
      [md__682__auto__
       (java.security.MessageDigest/getInstance "Keccak-512")]
      (.digest md__682__auto__ data1208)))))
  (clojure.core/extend-protocol
   G__1209
   java.io.InputStream
   (compute-keccak-5121207
    [data1208]
    (clojure.core/let
     [md__683__auto__
      (java.security.MessageDigest/getInstance "Keccak-512")
      c__684__auto__
      (clojure.core/int *buffer-size*)
      buf__685__auto__
      (clojure.core/byte-array c__684__auto__)
      s__686__auto__
      data1208]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__687__auto__
        (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__687__auto__ -1)
        (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
        (recur))))
     (.digest md__683__auto__)))
   java.io.File
   (compute-keccak-5121207
    [data1208]
    (clojure.core/with-open
     [data1208 (clojure.java.io/input-stream data1208)]
     (clojure.core/let
      [md__683__auto__
       (java.security.MessageDigest/getInstance "Keccak-512")
       c__684__auto__
       (clojure.core/int *buffer-size*)
       buf__685__auto__
       (clojure.core/byte-array c__684__auto__)
       s__686__auto__
       data1208]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__687__auto__
         (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__687__auto__ -1)
         (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
         (recur))))
      (.digest md__683__auto__)))))
  'G__1209)
 (do
  (clojure.core/defn
   keccak-512*
   "[Hash] Keccak-512 (raw value)"
   [x]
   (compute-keccak-5121207 x))
  (clojure.core/defn
   keccak-512-file*
   "[Hash] Keccak-512 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-5121207 x)))
  (clojure.core/defn
   keccak-512-bytes
   "[Hash] Keccak-512 (value -> byte array)"
   [x]
   (compute-keccak-5121207 x))
  (clojure.core/defn
   keccak-512-file-bytes
   "[Hash] Keccak-512 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-5121207 x)))
  (clojure.core/defn
   keccak-512
   "[Hash] Keccak-512 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-keccak-5121207 x)))
  (clojure.core/defn
   keccak-512-file
   "[Hash] Keccak-512 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-keccak-5121207 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1242
   (compute-keccak-5121239 [data1240 key1241]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1242 #'compute-keccak-5121239]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1242
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-keccak-5121239
    [data1240 key1241]
    (clojure.core/let
     [mac__557__auto__
      (javax.crypto.Mac/getInstance "Hmac-Keccak512")
      msg__558__auto__
      (clojure.core/bytes data1240)
      k__559__auto__
      (javax.crypto.spec.SecretKeySpec. key1241 "Hmac-Keccak512")]
     (clojure.core/->
      (clojure.core/doto
       mac__557__auto__
       (.init k__559__auto__)
       (.update msg__558__auto__))
      (.doFinal))))
   java.lang.String
   (compute-keccak-5121239
    [data1240 key1241]
    (clojure.core/let
     [data1240 (.getBytes data1240 "UTF-8")]
     (clojure.core/let
      [mac__557__auto__
       (javax.crypto.Mac/getInstance "Hmac-Keccak512")
       msg__558__auto__
       (clojure.core/bytes data1240)
       k__559__auto__
       (javax.crypto.spec.SecretKeySpec. key1241 "Hmac-Keccak512")]
      (clojure.core/->
       (clojure.core/doto
        mac__557__auto__
        (.init k__559__auto__)
        (.update msg__558__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1242
   java.io.InputStream
   (compute-keccak-5121239
    [data1240 key1241]
    (clojure.core/let
     [mac__560__auto__
      (javax.crypto.Mac/getInstance "Hmac-Keccak512")
      k__561__auto__
      (javax.crypto.spec.SecretKeySpec. key1241 "Hmac-Keccak512")
      c__562__auto__
      (clojure.core/int *buffer-size*)
      buf__563__auto__
      (clojure.core/byte-array c__562__auto__)
      s__564__auto__
      data1240]
     (.init mac__560__auto__ k__561__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__565__auto__
        (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__565__auto__ -1)
        (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
        (recur))))
     (.doFinal mac__560__auto__)))
   java.io.File
   (compute-keccak-5121239
    [data1240 key1241]
    (clojure.core/with-open
     [data1240 (clojure.java.io/input-stream data1240)]
     (clojure.core/let
      [mac__560__auto__
       (javax.crypto.Mac/getInstance "Hmac-Keccak512")
       k__561__auto__
       (javax.crypto.spec.SecretKeySpec. key1241 "Hmac-Keccak512")
       c__562__auto__
       (clojure.core/int *buffer-size*)
       buf__563__auto__
       (clojure.core/byte-array c__562__auto__)
       s__564__auto__
       data1240]
      (.init mac__560__auto__ k__561__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__565__auto__
         (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__565__auto__ -1)
         (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
         (recur))))
      (.doFinal mac__560__auto__)))))
  'G__1242)
 (do
  (clojure.core/defn
   keccak-512-hmac*
   "[HMAC] Hmac-Keccak512 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-keccak-5121239
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   keccak-512-hmac-file*
   "[HMAC] Hmac-Keccak512 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-5121239
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   keccak-512-hmac-bytes
   "[HMAC] Hmac-Keccak512 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-keccak-5121239
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   keccak-512-hmac-file-bytes
   "[HMAC] Hmac-Keccak512 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-5121239
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   keccak-512-hmac
   "[HMAC] Hmac-Keccak512 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-keccak-5121239
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   keccak-512-hmac-file
   "[HMAC] Hmac-Keccak512 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-keccak-5121239
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
