(ns
 pandect.algo.md5
 "MD5 algorithm implementation"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]))
(do
 (do
  (clojure.core/defprotocol G__1268 (compute-md51266 [data1267]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1268 #'compute-md51266]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1268
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-md51266
    [data1267]
    (clojure.core/let
     [md__682__auto__ (java.security.MessageDigest/getInstance "MD5")]
     (.digest md__682__auto__ data1267)))
   java.lang.String
   (compute-md51266
    [data1267]
    (clojure.core/let
     [data1267 (.getBytes data1267 "UTF-8")]
     (clojure.core/let
      [md__682__auto__ (java.security.MessageDigest/getInstance "MD5")]
      (.digest md__682__auto__ data1267)))))
  (clojure.core/extend-protocol
   G__1268
   java.io.InputStream
   (compute-md51266
    [data1267]
    (clojure.core/let
     [md__683__auto__
      (java.security.MessageDigest/getInstance "MD5")
      c__684__auto__
      (clojure.core/int *buffer-size*)
      buf__685__auto__
      (clojure.core/byte-array c__684__auto__)
      s__686__auto__
      data1267]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__687__auto__
        (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__687__auto__ -1)
        (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
        (recur))))
     (.digest md__683__auto__)))
   java.io.File
   (compute-md51266
    [data1267]
    (clojure.core/with-open
     [data1267 (clojure.java.io/input-stream data1267)]
     (clojure.core/let
      [md__683__auto__
       (java.security.MessageDigest/getInstance "MD5")
       c__684__auto__
       (clojure.core/int *buffer-size*)
       buf__685__auto__
       (clojure.core/byte-array c__684__auto__)
       s__686__auto__
       data1267]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__687__auto__
         (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__687__auto__ -1)
         (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
         (recur))))
      (.digest md__683__auto__)))))
  'G__1268)
 (do
  (clojure.core/defn
   md5*
   "[Hash] MD5 (raw value)"
   [x]
   (compute-md51266 x))
  (clojure.core/defn
   md5-file*
   "[Hash] MD5 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md51266 x)))
  (clojure.core/defn
   md5-bytes
   "[Hash] MD5 (value -> byte array)"
   [x]
   (compute-md51266 x))
  (clojure.core/defn
   md5-file-bytes
   "[Hash] MD5 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md51266 x)))
  (clojure.core/defn
   md5
   "[Hash] MD5 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-md51266 x)))
  (clojure.core/defn
   md5-file
   "[Hash] MD5 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-md51266 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1300
   (compute-md51297 [data1298 key1299]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1300 #'compute-md51297]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1300
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-md51297
    [data1298 key1299]
    (clojure.core/let
     [mac__557__auto__
      (javax.crypto.Mac/getInstance "HmacMD5")
      msg__558__auto__
      (clojure.core/bytes data1298)
      k__559__auto__
      (javax.crypto.spec.SecretKeySpec. key1299 "HmacMD5")]
     (clojure.core/->
      (clojure.core/doto
       mac__557__auto__
       (.init k__559__auto__)
       (.update msg__558__auto__))
      (.doFinal))))
   java.lang.String
   (compute-md51297
    [data1298 key1299]
    (clojure.core/let
     [data1298 (.getBytes data1298 "UTF-8")]
     (clojure.core/let
      [mac__557__auto__
       (javax.crypto.Mac/getInstance "HmacMD5")
       msg__558__auto__
       (clojure.core/bytes data1298)
       k__559__auto__
       (javax.crypto.spec.SecretKeySpec. key1299 "HmacMD5")]
      (clojure.core/->
       (clojure.core/doto
        mac__557__auto__
        (.init k__559__auto__)
        (.update msg__558__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1300
   java.io.InputStream
   (compute-md51297
    [data1298 key1299]
    (clojure.core/let
     [mac__560__auto__
      (javax.crypto.Mac/getInstance "HmacMD5")
      k__561__auto__
      (javax.crypto.spec.SecretKeySpec. key1299 "HmacMD5")
      c__562__auto__
      (clojure.core/int *buffer-size*)
      buf__563__auto__
      (clojure.core/byte-array c__562__auto__)
      s__564__auto__
      data1298]
     (.init mac__560__auto__ k__561__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__565__auto__
        (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__565__auto__ -1)
        (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
        (recur))))
     (.doFinal mac__560__auto__)))
   java.io.File
   (compute-md51297
    [data1298 key1299]
    (clojure.core/with-open
     [data1298 (clojure.java.io/input-stream data1298)]
     (clojure.core/let
      [mac__560__auto__
       (javax.crypto.Mac/getInstance "HmacMD5")
       k__561__auto__
       (javax.crypto.spec.SecretKeySpec. key1299 "HmacMD5")
       c__562__auto__
       (clojure.core/int *buffer-size*)
       buf__563__auto__
       (clojure.core/byte-array c__562__auto__)
       s__564__auto__
       data1298]
      (.init mac__560__auto__ k__561__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__565__auto__
         (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__565__auto__ -1)
         (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
         (recur))))
      (.doFinal mac__560__auto__)))))
  'G__1300)
 (do
  (clojure.core/defn
   md5-hmac*
   "[HMAC] HmacMD5 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-md51297
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   md5-hmac-file*
   "[HMAC] HmacMD5 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md51297
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   md5-hmac-bytes
   "[HMAC] HmacMD5 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-md51297
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   md5-hmac-file-bytes
   "[HMAC] HmacMD5 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md51297
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   md5-hmac
   "[HMAC] HmacMD5 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-md51297
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   md5-hmac-file
   "[HMAC] HmacMD5 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-md51297
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
(do
 (do
  (clojure.core/defprotocol
   G__1314
   (compute-md51310 [data1311 key1313])
   (compute-md51310-verify [data1311 sig1312 key1313]))
  (clojure.core/doseq
   [v__198__auto__
    [#'G__1314 #'compute-md51310 #'compute-md51310-verify]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1314
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-md51310
    [data1311 key1313]
    (clojure.core/let
     [signer__861__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "MD5withRSA")
       (.initSign key1313)
       (.update (clojure.core/bytes data1311)))]
     (.sign signer__861__auto__)))
   (compute-md51310-verify
    [data1311 sig1312 key1313]
    (clojure.core/let
     [signer__862__auto__
      (java.security.Signature/getInstance "MD5withRSA")
      key__863__auto__
      (pandect.utils.convert/as-public-key key1313)]
     (.initVerify signer__862__auto__ key__863__auto__)
     (.update signer__862__auto__ (clojure.core/bytes data1311))
     (.verify signer__862__auto__ (clojure.core/bytes sig1312))))
   java.lang.String
   (compute-md51310
    [data1311 key1313]
    (clojure.core/let
     [data1311 (.getBytes data1311 "UTF-8")]
     (clojure.core/let
      [signer__861__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "MD5withRSA")
        (.initSign key1313)
        (.update (clojure.core/bytes data1311)))]
      (.sign signer__861__auto__))))
   (compute-md51310-verify
    [data1311 sig1312 key1313]
    (clojure.core/let
     [data1311 (.getBytes data1311 "UTF-8")]
     (clojure.core/let
      [signer__862__auto__
       (java.security.Signature/getInstance "MD5withRSA")
       key__863__auto__
       (pandect.utils.convert/as-public-key key1313)]
      (.initVerify signer__862__auto__ key__863__auto__)
      (.update signer__862__auto__ (clojure.core/bytes data1311))
      (.verify signer__862__auto__ (clojure.core/bytes sig1312))))))
  (clojure.core/extend-protocol
   G__1314
   java.io.InputStream
   (compute-md51310
    [data1311 key1313]
    (clojure.core/let
     [signer__864__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "MD5withRSA")
       (.initSign key1313))
      c__865__auto__
      (clojure.core/int *buffer-size*)
      buf__866__auto__
      (clojure.core/byte-array c__865__auto__)
      s__867__auto__
      data1311]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__868__auto__
        (.read s__867__auto__ buf__866__auto__ 0 c__865__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__868__auto__ -1)
        (.update signer__864__auto__ buf__866__auto__ 0 r__868__auto__)
        (recur))))
     (.sign signer__864__auto__)))
   (compute-md51310-verify
    [data1311 sig1312 key1313]
    (clojure.core/let
     [signer__869__auto__
      (java.security.Signature/getInstance "MD5withRSA")
      c__870__auto__
      (clojure.core/int *buffer-size*)
      buf__871__auto__
      (clojure.core/byte-array c__870__auto__)
      s__872__auto__
      data1311
      key__873__auto__
      (pandect.utils.convert/as-public-key key1313)]
     (.initVerify signer__869__auto__ key__873__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__874__auto__
        (.read s__872__auto__ buf__871__auto__ 0 c__870__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__874__auto__ -1)
        (.update signer__869__auto__ buf__871__auto__ 0 r__874__auto__)
        (recur))))
     (.verify signer__869__auto__ (clojure.core/bytes sig1312))))
   java.io.File
   (compute-md51310
    [data1311 key1313]
    (clojure.core/with-open
     [data1311 (clojure.java.io/input-stream data1311)]
     (clojure.core/let
      [signer__864__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "MD5withRSA")
        (.initSign key1313))
       c__865__auto__
       (clojure.core/int *buffer-size*)
       buf__866__auto__
       (clojure.core/byte-array c__865__auto__)
       s__867__auto__
       data1311]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__868__auto__
         (.read s__867__auto__ buf__866__auto__ 0 c__865__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__868__auto__ -1)
         (.update
          signer__864__auto__
          buf__866__auto__
          0
          r__868__auto__)
         (recur))))
      (.sign signer__864__auto__))))
   (compute-md51310-verify
    [data1311 sig1312 key1313]
    (clojure.core/with-open
     [data1311 (clojure.java.io/input-stream data1311)]
     (clojure.core/let
      [signer__869__auto__
       (java.security.Signature/getInstance "MD5withRSA")
       c__870__auto__
       (clojure.core/int *buffer-size*)
       buf__871__auto__
       (clojure.core/byte-array c__870__auto__)
       s__872__auto__
       data1311
       key__873__auto__
       (pandect.utils.convert/as-public-key key1313)]
      (.initVerify signer__869__auto__ key__873__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__874__auto__
         (.read s__872__auto__ buf__871__auto__ 0 c__870__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__874__auto__ -1)
         (.update
          signer__869__auto__
          buf__871__auto__
          0
          r__874__auto__)
         (recur))))
      (.verify signer__869__auto__ (clojure.core/bytes sig1312))))))
  'G__1314)
 (do
  (clojure.core/defn
   md5-rsa*
   "[Signature] MD5withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-md51310 x private-key))
  (clojure.core/defn
   md5-rsa-file*
   "[Signature] MD5withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md51310 x private-key)))
  (clojure.core/defn
   md5-rsa-bytes
   "[Signature] MD5withRSA (value -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-md51310 x private-key))
  (clojure.core/defn
   md5-rsa-file-bytes
   "[Signature] MD5withRSA (file path -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md51310 x private-key)))
  (clojure.core/defn
   md5-rsa
   "[Signature] MD5withRSA (value -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (pandect.utils.convert/bytes->hex (compute-md51310 x private-key)))
  (clojure.core/defn
   md5-rsa-file
   "[Signature] MD5withRSA (file path -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-md51310 x private-key))))
  (clojure.core/defn
   md5-rsa-verify
   "[Signature] MD5withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (compute-md51310-verify
    x
    (pandect.utils.convert/convert-signature-to-byte-array signature)
    (pandect.utils.convert/convert-to-public-key public-key)))
  (clojure.core/defn
   md5-rsa-verify-file
   "[Signature] MD5withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md51310-verify
     x
     (pandect.utils.convert/convert-signature-to-byte-array signature)
     (pandect.utils.convert/convert-to-public-key public-key))))))
