(ns
 pandect.algo.ripemd128
 "RipeMD128 algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol G__1261 (compute-ripemd1281257 [data1259]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1261 #'compute-ripemd1281257]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1261
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-ripemd1281257
    [data1259]
    (clojure.core/let
     [md__682__auto__
      (java.security.MessageDigest/getInstance "RipeMD128")]
     (.digest md__682__auto__ data1259)))
   java.lang.String
   (compute-ripemd1281257
    [data1259]
    (clojure.core/let
     [data1259 (.getBytes data1259 "UTF-8")]
     (clojure.core/let
      [md__682__auto__
       (java.security.MessageDigest/getInstance "RipeMD128")]
      (.digest md__682__auto__ data1259)))))
  (clojure.core/extend-protocol
   G__1261
   java.io.InputStream
   (compute-ripemd1281257
    [data1259]
    (clojure.core/let
     [md__683__auto__
      (java.security.MessageDigest/getInstance "RipeMD128")
      c__684__auto__
      (clojure.core/int *buffer-size*)
      buf__685__auto__
      (clojure.core/byte-array c__684__auto__)
      s__686__auto__
      data1259]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__687__auto__
        (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__687__auto__ -1)
        (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
        (recur))))
     (.digest md__683__auto__)))
   java.io.File
   (compute-ripemd1281257
    [data1259]
    (clojure.core/with-open
     [data1259 (clojure.java.io/input-stream data1259)]
     (clojure.core/let
      [md__683__auto__
       (java.security.MessageDigest/getInstance "RipeMD128")
       c__684__auto__
       (clojure.core/int *buffer-size*)
       buf__685__auto__
       (clojure.core/byte-array c__684__auto__)
       s__686__auto__
       data1259]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__687__auto__
         (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__687__auto__ -1)
         (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
         (recur))))
      (.digest md__683__auto__)))))
  'G__1261)
 (do
  (clojure.core/defn
   ripemd128*
   "[Hash] RipeMD128 (raw value)"
   [x]
   (compute-ripemd1281257 x))
  (clojure.core/defn
   ripemd128-file*
   "[Hash] RipeMD128 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd1281257 x)))
  (clojure.core/defn
   ripemd128-bytes
   "[Hash] RipeMD128 (value -> byte array)"
   [x]
   (compute-ripemd1281257 x))
  (clojure.core/defn
   ripemd128-file-bytes
   "[Hash] RipeMD128 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd1281257 x)))
  (clojure.core/defn
   ripemd128
   "[Hash] RipeMD128 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-ripemd1281257 x)))
  (clojure.core/defn
   ripemd128-file
   "[Hash] RipeMD128 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-ripemd1281257 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1292
   (compute-ripemd1281289 [data1290 key1291]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1292 #'compute-ripemd1281289]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1292
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-ripemd1281289
    [data1290 key1291]
    (clojure.core/let
     [mac__557__auto__
      (javax.crypto.Mac/getInstance "Hmac-RipeMD128")
      msg__558__auto__
      (clojure.core/bytes data1290)
      k__559__auto__
      (javax.crypto.spec.SecretKeySpec. key1291 "Hmac-RipeMD128")]
     (clojure.core/->
      (clojure.core/doto
       mac__557__auto__
       (.init k__559__auto__)
       (.update msg__558__auto__))
      (.doFinal))))
   java.lang.String
   (compute-ripemd1281289
    [data1290 key1291]
    (clojure.core/let
     [data1290 (.getBytes data1290 "UTF-8")]
     (clojure.core/let
      [mac__557__auto__
       (javax.crypto.Mac/getInstance "Hmac-RipeMD128")
       msg__558__auto__
       (clojure.core/bytes data1290)
       k__559__auto__
       (javax.crypto.spec.SecretKeySpec. key1291 "Hmac-RipeMD128")]
      (clojure.core/->
       (clojure.core/doto
        mac__557__auto__
        (.init k__559__auto__)
        (.update msg__558__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1292
   java.io.InputStream
   (compute-ripemd1281289
    [data1290 key1291]
    (clojure.core/let
     [mac__560__auto__
      (javax.crypto.Mac/getInstance "Hmac-RipeMD128")
      k__561__auto__
      (javax.crypto.spec.SecretKeySpec. key1291 "Hmac-RipeMD128")
      c__562__auto__
      (clojure.core/int *buffer-size*)
      buf__563__auto__
      (clojure.core/byte-array c__562__auto__)
      s__564__auto__
      data1290]
     (.init mac__560__auto__ k__561__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__565__auto__
        (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__565__auto__ -1)
        (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
        (recur))))
     (.doFinal mac__560__auto__)))
   java.io.File
   (compute-ripemd1281289
    [data1290 key1291]
    (clojure.core/with-open
     [data1290 (clojure.java.io/input-stream data1290)]
     (clojure.core/let
      [mac__560__auto__
       (javax.crypto.Mac/getInstance "Hmac-RipeMD128")
       k__561__auto__
       (javax.crypto.spec.SecretKeySpec. key1291 "Hmac-RipeMD128")
       c__562__auto__
       (clojure.core/int *buffer-size*)
       buf__563__auto__
       (clojure.core/byte-array c__562__auto__)
       s__564__auto__
       data1290]
      (.init mac__560__auto__ k__561__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__565__auto__
         (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__565__auto__ -1)
         (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
         (recur))))
      (.doFinal mac__560__auto__)))))
  'G__1292)
 (do
  (clojure.core/defn
   ripemd128-hmac*
   "[HMAC] Hmac-RipeMD128 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-ripemd1281289
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   ripemd128-hmac-file*
   "[HMAC] Hmac-RipeMD128 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd1281289
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   ripemd128-hmac-bytes
   "[HMAC] Hmac-RipeMD128 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-ripemd1281289
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   ripemd128-hmac-file-bytes
   "[HMAC] Hmac-RipeMD128 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd1281289
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   ripemd128-hmac
   "[HMAC] Hmac-RipeMD128 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-ripemd1281289
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   ripemd128-hmac-file
   "[HMAC] Hmac-RipeMD128 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-ripemd1281289
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
