(ns
 pandect.algo.ripemd320
 "RipeMD320 algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol G__1279 (compute-ripemd3201277 [data1278]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1279 #'compute-ripemd3201277]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1279
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-ripemd3201277
    [data1278]
    (clojure.core/let
     [md__682__auto__
      (java.security.MessageDigest/getInstance "RipeMD320")]
     (.digest md__682__auto__ data1278)))
   java.lang.String
   (compute-ripemd3201277
    [data1278]
    (clojure.core/let
     [data1278 (.getBytes data1278 "UTF-8")]
     (clojure.core/let
      [md__682__auto__
       (java.security.MessageDigest/getInstance "RipeMD320")]
      (.digest md__682__auto__ data1278)))))
  (clojure.core/extend-protocol
   G__1279
   java.io.InputStream
   (compute-ripemd3201277
    [data1278]
    (clojure.core/let
     [md__683__auto__
      (java.security.MessageDigest/getInstance "RipeMD320")
      c__684__auto__
      (clojure.core/int *buffer-size*)
      buf__685__auto__
      (clojure.core/byte-array c__684__auto__)
      s__686__auto__
      data1278]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__687__auto__
        (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__687__auto__ -1)
        (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
        (recur))))
     (.digest md__683__auto__)))
   java.io.File
   (compute-ripemd3201277
    [data1278]
    (clojure.core/with-open
     [data1278 (clojure.java.io/input-stream data1278)]
     (clojure.core/let
      [md__683__auto__
       (java.security.MessageDigest/getInstance "RipeMD320")
       c__684__auto__
       (clojure.core/int *buffer-size*)
       buf__685__auto__
       (clojure.core/byte-array c__684__auto__)
       s__686__auto__
       data1278]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__687__auto__
         (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__687__auto__ -1)
         (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
         (recur))))
      (.digest md__683__auto__)))))
  'G__1279)
 (do
  (clojure.core/defn
   ripemd320*
   "[Hash] RipeMD320 (raw value)"
   [x]
   (compute-ripemd3201277 x))
  (clojure.core/defn
   ripemd320-file*
   "[Hash] RipeMD320 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd3201277 x)))
  (clojure.core/defn
   ripemd320-bytes
   "[Hash] RipeMD320 (value -> byte array)"
   [x]
   (compute-ripemd3201277 x))
  (clojure.core/defn
   ripemd320-file-bytes
   "[Hash] RipeMD320 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd3201277 x)))
  (clojure.core/defn
   ripemd320
   "[Hash] RipeMD320 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-ripemd3201277 x)))
  (clojure.core/defn
   ripemd320-file
   "[Hash] RipeMD320 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-ripemd3201277 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1296
   (compute-ripemd3201293 [data1294 key1295]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1296 #'compute-ripemd3201293]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1296
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-ripemd3201293
    [data1294 key1295]
    (clojure.core/let
     [mac__557__auto__
      (javax.crypto.Mac/getInstance "Hmac-RipeMD320")
      msg__558__auto__
      (clojure.core/bytes data1294)
      k__559__auto__
      (javax.crypto.spec.SecretKeySpec. key1295 "Hmac-RipeMD320")]
     (clojure.core/->
      (clojure.core/doto
       mac__557__auto__
       (.init k__559__auto__)
       (.update msg__558__auto__))
      (.doFinal))))
   java.lang.String
   (compute-ripemd3201293
    [data1294 key1295]
    (clojure.core/let
     [data1294 (.getBytes data1294 "UTF-8")]
     (clojure.core/let
      [mac__557__auto__
       (javax.crypto.Mac/getInstance "Hmac-RipeMD320")
       msg__558__auto__
       (clojure.core/bytes data1294)
       k__559__auto__
       (javax.crypto.spec.SecretKeySpec. key1295 "Hmac-RipeMD320")]
      (clojure.core/->
       (clojure.core/doto
        mac__557__auto__
        (.init k__559__auto__)
        (.update msg__558__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1296
   java.io.InputStream
   (compute-ripemd3201293
    [data1294 key1295]
    (clojure.core/let
     [mac__560__auto__
      (javax.crypto.Mac/getInstance "Hmac-RipeMD320")
      k__561__auto__
      (javax.crypto.spec.SecretKeySpec. key1295 "Hmac-RipeMD320")
      c__562__auto__
      (clojure.core/int *buffer-size*)
      buf__563__auto__
      (clojure.core/byte-array c__562__auto__)
      s__564__auto__
      data1294]
     (.init mac__560__auto__ k__561__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__565__auto__
        (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__565__auto__ -1)
        (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
        (recur))))
     (.doFinal mac__560__auto__)))
   java.io.File
   (compute-ripemd3201293
    [data1294 key1295]
    (clojure.core/with-open
     [data1294 (clojure.java.io/input-stream data1294)]
     (clojure.core/let
      [mac__560__auto__
       (javax.crypto.Mac/getInstance "Hmac-RipeMD320")
       k__561__auto__
       (javax.crypto.spec.SecretKeySpec. key1295 "Hmac-RipeMD320")
       c__562__auto__
       (clojure.core/int *buffer-size*)
       buf__563__auto__
       (clojure.core/byte-array c__562__auto__)
       s__564__auto__
       data1294]
      (.init mac__560__auto__ k__561__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__565__auto__
         (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__565__auto__ -1)
         (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
         (recur))))
      (.doFinal mac__560__auto__)))))
  'G__1296)
 (do
  (clojure.core/defn
   ripemd320-hmac*
   "[HMAC] Hmac-RipeMD320 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-ripemd3201293
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   ripemd320-hmac-file*
   "[HMAC] Hmac-RipeMD320 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd3201293
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   ripemd320-hmac-bytes
   "[HMAC] Hmac-RipeMD320 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-ripemd3201293
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   ripemd320-hmac-file-bytes
   "[HMAC] Hmac-RipeMD320 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-ripemd3201293
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   ripemd320-hmac
   "[HMAC] Hmac-RipeMD320 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-ripemd3201293
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   ripemd320-hmac-file
   "[HMAC] Hmac-RipeMD320 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-ripemd3201293
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
