(ns
 pandect.algo.sha224
 "SHA-224 algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol G__1317 (compute-sha2241315 [data1316]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1317 #'compute-sha2241315]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1317
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha2241315
    [data1316]
    (clojure.core/let
     [md__682__auto__
      (java.security.MessageDigest/getInstance "SHA-224")]
     (.digest md__682__auto__ data1316)))
   java.lang.String
   (compute-sha2241315
    [data1316]
    (clojure.core/let
     [data1316 (.getBytes data1316 "UTF-8")]
     (clojure.core/let
      [md__682__auto__
       (java.security.MessageDigest/getInstance "SHA-224")]
      (.digest md__682__auto__ data1316)))))
  (clojure.core/extend-protocol
   G__1317
   java.io.InputStream
   (compute-sha2241315
    [data1316]
    (clojure.core/let
     [md__683__auto__
      (java.security.MessageDigest/getInstance "SHA-224")
      c__684__auto__
      (clojure.core/int *buffer-size*)
      buf__685__auto__
      (clojure.core/byte-array c__684__auto__)
      s__686__auto__
      data1316]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__687__auto__
        (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__687__auto__ -1)
        (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
        (recur))))
     (.digest md__683__auto__)))
   java.io.File
   (compute-sha2241315
    [data1316]
    (clojure.core/with-open
     [data1316 (clojure.java.io/input-stream data1316)]
     (clojure.core/let
      [md__683__auto__
       (java.security.MessageDigest/getInstance "SHA-224")
       c__684__auto__
       (clojure.core/int *buffer-size*)
       buf__685__auto__
       (clojure.core/byte-array c__684__auto__)
       s__686__auto__
       data1316]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__687__auto__
         (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__687__auto__ -1)
         (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
         (recur))))
      (.digest md__683__auto__)))))
  'G__1317)
 (do
  (clojure.core/defn
   sha224*
   "[Hash] SHA-224 (raw value)"
   [x]
   (compute-sha2241315 x))
  (clojure.core/defn
   sha224-file*
   "[Hash] SHA-224 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha2241315 x)))
  (clojure.core/defn
   sha224-bytes
   "[Hash] SHA-224 (value -> byte array)"
   [x]
   (compute-sha2241315 x))
  (clojure.core/defn
   sha224-file-bytes
   "[Hash] SHA-224 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha2241315 x)))
  (clojure.core/defn
   sha224
   "[Hash] SHA-224 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-sha2241315 x)))
  (clojure.core/defn
   sha224-file
   "[Hash] SHA-224 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-sha2241315 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1339
   (compute-sha2241336 [data1337 key1338]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1339 #'compute-sha2241336]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1339
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha2241336
    [data1337 key1338]
    (clojure.core/let
     [mac__557__auto__
      (javax.crypto.Mac/getInstance "Hmac-SHA224")
      msg__558__auto__
      (clojure.core/bytes data1337)
      k__559__auto__
      (javax.crypto.spec.SecretKeySpec. key1338 "Hmac-SHA224")]
     (clojure.core/->
      (clojure.core/doto
       mac__557__auto__
       (.init k__559__auto__)
       (.update msg__558__auto__))
      (.doFinal))))
   java.lang.String
   (compute-sha2241336
    [data1337 key1338]
    (clojure.core/let
     [data1337 (.getBytes data1337 "UTF-8")]
     (clojure.core/let
      [mac__557__auto__
       (javax.crypto.Mac/getInstance "Hmac-SHA224")
       msg__558__auto__
       (clojure.core/bytes data1337)
       k__559__auto__
       (javax.crypto.spec.SecretKeySpec. key1338 "Hmac-SHA224")]
      (clojure.core/->
       (clojure.core/doto
        mac__557__auto__
        (.init k__559__auto__)
        (.update msg__558__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1339
   java.io.InputStream
   (compute-sha2241336
    [data1337 key1338]
    (clojure.core/let
     [mac__560__auto__
      (javax.crypto.Mac/getInstance "Hmac-SHA224")
      k__561__auto__
      (javax.crypto.spec.SecretKeySpec. key1338 "Hmac-SHA224")
      c__562__auto__
      (clojure.core/int *buffer-size*)
      buf__563__auto__
      (clojure.core/byte-array c__562__auto__)
      s__564__auto__
      data1337]
     (.init mac__560__auto__ k__561__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__565__auto__
        (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__565__auto__ -1)
        (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
        (recur))))
     (.doFinal mac__560__auto__)))
   java.io.File
   (compute-sha2241336
    [data1337 key1338]
    (clojure.core/with-open
     [data1337 (clojure.java.io/input-stream data1337)]
     (clojure.core/let
      [mac__560__auto__
       (javax.crypto.Mac/getInstance "Hmac-SHA224")
       k__561__auto__
       (javax.crypto.spec.SecretKeySpec. key1338 "Hmac-SHA224")
       c__562__auto__
       (clojure.core/int *buffer-size*)
       buf__563__auto__
       (clojure.core/byte-array c__562__auto__)
       s__564__auto__
       data1337]
      (.init mac__560__auto__ k__561__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__565__auto__
         (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__565__auto__ -1)
         (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
         (recur))))
      (.doFinal mac__560__auto__)))))
  'G__1339)
 (do
  (clojure.core/defn
   sha224-hmac*
   "[HMAC] Hmac-SHA224 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-sha2241336
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   sha224-hmac-file*
   "[HMAC] Hmac-SHA224 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha2241336
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha224-hmac-bytes
   "[HMAC] Hmac-SHA224 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-sha2241336
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   sha224-hmac-file-bytes
   "[HMAC] Hmac-SHA224 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha2241336
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha224-hmac
   "[HMAC] Hmac-SHA224 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-sha2241336
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha224-hmac-file
   "[HMAC] Hmac-SHA224 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-sha2241336
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
