(ns
 pandect.algo.blake2b-512
 "BLAKE2B-512 algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol
   G__1203
   (compute-blake2b-5121201 [data1202]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1203 #'compute-blake2b-5121201]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1203
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-blake2b-5121201
    [data1202]
    (clojure.core/let
     [md__682__auto__
      (java.security.MessageDigest/getInstance "BLAKE2B-512")]
     (.digest md__682__auto__ data1202)))
   java.lang.String
   (compute-blake2b-5121201
    [data1202]
    (clojure.core/let
     [data1202 (.getBytes data1202 "UTF-8")]
     (clojure.core/let
      [md__682__auto__
       (java.security.MessageDigest/getInstance "BLAKE2B-512")]
      (.digest md__682__auto__ data1202)))))
  (clojure.core/extend-protocol
   G__1203
   java.io.InputStream
   (compute-blake2b-5121201
    [data1202]
    (clojure.core/let
     [md__683__auto__
      (java.security.MessageDigest/getInstance "BLAKE2B-512")
      c__684__auto__
      (clojure.core/int *buffer-size*)
      buf__685__auto__
      (clojure.core/byte-array c__684__auto__)
      s__686__auto__
      data1202]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__687__auto__
        (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__687__auto__ -1)
        (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
        (recur))))
     (.digest md__683__auto__)))
   java.io.File
   (compute-blake2b-5121201
    [data1202]
    (clojure.core/with-open
     [data1202 (clojure.java.io/input-stream data1202)]
     (clojure.core/let
      [md__683__auto__
       (java.security.MessageDigest/getInstance "BLAKE2B-512")
       c__684__auto__
       (clojure.core/int *buffer-size*)
       buf__685__auto__
       (clojure.core/byte-array c__684__auto__)
       s__686__auto__
       data1202]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__687__auto__
         (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__687__auto__ -1)
         (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
         (recur))))
      (.digest md__683__auto__)))))
  'G__1203)
 (do
  (clojure.core/defn
   blake2b-512*
   "[Hash] BLAKE2B-512 (raw value)"
   [x]
   (compute-blake2b-5121201 x))
  (clojure.core/defn
   blake2b-512-file*
   "[Hash] BLAKE2B-512 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-blake2b-5121201 x)))
  (clojure.core/defn
   blake2b-512-bytes
   "[Hash] BLAKE2B-512 (value -> byte array)"
   [x]
   (compute-blake2b-5121201 x))
  (clojure.core/defn
   blake2b-512-file-bytes
   "[Hash] BLAKE2B-512 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-blake2b-5121201 x)))
  (clojure.core/defn
   blake2b-512
   "[Hash] BLAKE2B-512 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-blake2b-5121201 x)))
  (clojure.core/defn
   blake2b-512-file
   "[Hash] BLAKE2B-512 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-blake2b-5121201 x))))))
