(ns
 pandect.algo.md4
 "MD4 algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol G__1265 (compute-md41263 [data1264]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1265 #'compute-md41263]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1265
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-md41263
    [data1264]
    (clojure.core/let
     [md__682__auto__ (java.security.MessageDigest/getInstance "MD4")]
     (.digest md__682__auto__ data1264)))
   java.lang.String
   (compute-md41263
    [data1264]
    (clojure.core/let
     [data1264 (.getBytes data1264 "UTF-8")]
     (clojure.core/let
      [md__682__auto__ (java.security.MessageDigest/getInstance "MD4")]
      (.digest md__682__auto__ data1264)))))
  (clojure.core/extend-protocol
   G__1265
   java.io.InputStream
   (compute-md41263
    [data1264]
    (clojure.core/let
     [md__683__auto__
      (java.security.MessageDigest/getInstance "MD4")
      c__684__auto__
      (clojure.core/int *buffer-size*)
      buf__685__auto__
      (clojure.core/byte-array c__684__auto__)
      s__686__auto__
      data1264]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__687__auto__
        (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__687__auto__ -1)
        (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
        (recur))))
     (.digest md__683__auto__)))
   java.io.File
   (compute-md41263
    [data1264]
    (clojure.core/with-open
     [data1264 (clojure.java.io/input-stream data1264)]
     (clojure.core/let
      [md__683__auto__
       (java.security.MessageDigest/getInstance "MD4")
       c__684__auto__
       (clojure.core/int *buffer-size*)
       buf__685__auto__
       (clojure.core/byte-array c__684__auto__)
       s__686__auto__
       data1264]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__687__auto__
         (.read s__686__auto__ buf__685__auto__ 0 c__684__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__687__auto__ -1)
         (.update md__683__auto__ buf__685__auto__ 0 r__687__auto__)
         (recur))))
      (.digest md__683__auto__)))))
  'G__1265)
 (do
  (clojure.core/defn
   md4*
   "[Hash] MD4 (raw value)"
   [x]
   (compute-md41263 x))
  (clojure.core/defn
   md4-file*
   "[Hash] MD4 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md41263 x)))
  (clojure.core/defn
   md4-bytes
   "[Hash] MD4 (value -> byte array)"
   [x]
   (compute-md41263 x))
  (clojure.core/defn
   md4-file-bytes
   "[Hash] MD4 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md41263 x)))
  (clojure.core/defn
   md4
   "[Hash] MD4 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-md41263 x)))
  (clojure.core/defn
   md4-file
   "[Hash] MD4 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-md41263 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1280
   (compute-md41277 [data1278 key1279]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1280 #'compute-md41277]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1280
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-md41277
    [data1278 key1279]
    (clojure.core/let
     [mac__557__auto__
      (javax.crypto.Mac/getInstance "Hmac-MD4")
      msg__558__auto__
      (clojure.core/bytes data1278)
      k__559__auto__
      (javax.crypto.spec.SecretKeySpec. key1279 "Hmac-MD4")]
     (clojure.core/->
      (clojure.core/doto
       mac__557__auto__
       (.init k__559__auto__)
       (.update msg__558__auto__))
      (.doFinal))))
   java.lang.String
   (compute-md41277
    [data1278 key1279]
    (clojure.core/let
     [data1278 (.getBytes data1278 "UTF-8")]
     (clojure.core/let
      [mac__557__auto__
       (javax.crypto.Mac/getInstance "Hmac-MD4")
       msg__558__auto__
       (clojure.core/bytes data1278)
       k__559__auto__
       (javax.crypto.spec.SecretKeySpec. key1279 "Hmac-MD4")]
      (clojure.core/->
       (clojure.core/doto
        mac__557__auto__
        (.init k__559__auto__)
        (.update msg__558__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1280
   java.io.InputStream
   (compute-md41277
    [data1278 key1279]
    (clojure.core/let
     [mac__560__auto__
      (javax.crypto.Mac/getInstance "Hmac-MD4")
      k__561__auto__
      (javax.crypto.spec.SecretKeySpec. key1279 "Hmac-MD4")
      c__562__auto__
      (clojure.core/int *buffer-size*)
      buf__563__auto__
      (clojure.core/byte-array c__562__auto__)
      s__564__auto__
      data1278]
     (.init mac__560__auto__ k__561__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__565__auto__
        (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__565__auto__ -1)
        (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
        (recur))))
     (.doFinal mac__560__auto__)))
   java.io.File
   (compute-md41277
    [data1278 key1279]
    (clojure.core/with-open
     [data1278 (clojure.java.io/input-stream data1278)]
     (clojure.core/let
      [mac__560__auto__
       (javax.crypto.Mac/getInstance "Hmac-MD4")
       k__561__auto__
       (javax.crypto.spec.SecretKeySpec. key1279 "Hmac-MD4")
       c__562__auto__
       (clojure.core/int *buffer-size*)
       buf__563__auto__
       (clojure.core/byte-array c__562__auto__)
       s__564__auto__
       data1278]
      (.init mac__560__auto__ k__561__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__565__auto__
         (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__565__auto__ -1)
         (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
         (recur))))
      (.doFinal mac__560__auto__)))))
  'G__1280)
 (do
  (clojure.core/defn
   md4-hmac*
   "[HMAC] Hmac-MD4 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-md41277
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   md4-hmac-file*
   "[HMAC] Hmac-MD4 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md41277
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   md4-hmac-bytes
   "[HMAC] Hmac-MD4 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-md41277
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   md4-hmac-file-bytes
   "[HMAC] Hmac-MD4 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md41277
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   md4-hmac
   "[HMAC] Hmac-MD4 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-md41277
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   md4-hmac-file
   "[HMAC] Hmac-MD4 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-md41277
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
