(ns
 pandect.algo.siphash48
 "Siphash-4-8 algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol
   G__1376
   (compute-siphash481373 [data1374 key1375]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1376 #'compute-siphash481373]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1376
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-siphash481373
    [data1374 key1375]
    (clojure.core/let
     [mac__557__auto__
      (javax.crypto.Mac/getInstance "Siphash-4-8")
      msg__558__auto__
      (clojure.core/bytes data1374)
      k__559__auto__
      (javax.crypto.spec.SecretKeySpec. key1375 "Siphash-4-8")]
     (clojure.core/->
      (clojure.core/doto
       mac__557__auto__
       (.init k__559__auto__)
       (.update msg__558__auto__))
      (.doFinal))))
   java.lang.String
   (compute-siphash481373
    [data1374 key1375]
    (clojure.core/let
     [data1374 (.getBytes data1374 "UTF-8")]
     (clojure.core/let
      [mac__557__auto__
       (javax.crypto.Mac/getInstance "Siphash-4-8")
       msg__558__auto__
       (clojure.core/bytes data1374)
       k__559__auto__
       (javax.crypto.spec.SecretKeySpec. key1375 "Siphash-4-8")]
      (clojure.core/->
       (clojure.core/doto
        mac__557__auto__
        (.init k__559__auto__)
        (.update msg__558__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1376
   java.io.InputStream
   (compute-siphash481373
    [data1374 key1375]
    (clojure.core/let
     [mac__560__auto__
      (javax.crypto.Mac/getInstance "Siphash-4-8")
      k__561__auto__
      (javax.crypto.spec.SecretKeySpec. key1375 "Siphash-4-8")
      c__562__auto__
      (clojure.core/int *buffer-size*)
      buf__563__auto__
      (clojure.core/byte-array c__562__auto__)
      s__564__auto__
      data1374]
     (.init mac__560__auto__ k__561__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__565__auto__
        (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__565__auto__ -1)
        (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
        (recur))))
     (.doFinal mac__560__auto__)))
   java.io.File
   (compute-siphash481373
    [data1374 key1375]
    (clojure.core/with-open
     [data1374 (clojure.java.io/input-stream data1374)]
     (clojure.core/let
      [mac__560__auto__
       (javax.crypto.Mac/getInstance "Siphash-4-8")
       k__561__auto__
       (javax.crypto.spec.SecretKeySpec. key1375 "Siphash-4-8")
       c__562__auto__
       (clojure.core/int *buffer-size*)
       buf__563__auto__
       (clojure.core/byte-array c__562__auto__)
       s__564__auto__
       data1374]
      (.init mac__560__auto__ k__561__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__565__auto__
         (.read s__564__auto__ buf__563__auto__ 0 c__562__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__565__auto__ -1)
         (.update mac__560__auto__ buf__563__auto__ 0 r__565__auto__)
         (recur))))
      (.doFinal mac__560__auto__)))))
  'G__1376)
 (do
  (clojure.core/defn
   siphash48*
   "[HMAC] Siphash-4-8 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-siphash481373
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   siphash48-file*
   "[HMAC] Siphash-4-8 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-siphash481373
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   siphash48-bytes
   "[HMAC] Siphash-4-8 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-siphash481373
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   siphash48-file-bytes
   "[HMAC] Siphash-4-8 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-siphash481373
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   siphash48
   "[HMAC] Siphash-4-8 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-siphash481373
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   siphash48-file
   "[HMAC] Siphash-4-8 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-siphash481373
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
