(ns com.edocu.help.db.redis
  (:require [com.stuartsierra.component :as component]
            [clojure.tools.logging :as log]
            [environ.core :as e]
            [com.edocu.help.sentry :as sentry])
  (:import [org.redisson.config Config]
           [org.redisson Redisson]
           [org.redisson.codec FstCodec]))

(defprotocol Client
  (client [this] "Return redisson client"))

(defrecord RedissonClient [client]
  component/Lifecycle
  (start [this]
    (log/trace "Starting RedissonClient")
    (assoc this
      :client (delay
                (try
                  (let [^Config redis-config (Config.)]
                    (.. redis-config
                        (setCodec (FstCodec.))
                        (useSingleServer)
                        (setAddress (e/env :redis-uri)))
                    (Redisson/create redis-config))
                  (catch Exception e
                    (sentry/put-in-mdc {:address (e/env :redis-uri)})
                    (log/error e "RedissonClient")
                    nil)))))
  (stop [this]
    (log/trace "Stopping RedissonClient")
    (dissoc this :client))

  Client
  (client [this]
    @client))

(defn ->redisson-client
  "Return component for redisson"
  []
  (map->RedissonClient {}))
