(ns cljs-material-ui.icons
  (:refer-clojure :exclude [filter list loop print remove repeat shuffle sort update])
  (:require-macros [cljs-material-ui.icons :as mi])
  (:require [cljs-material-ui.core :as m]
            [material-ui-icons]))

(def ^:private create-mui-icon (partial m/create-mui-cmp js/MaterialUIIcons))

(defn ac-unit [& args] (create-mui-icon "AcUnit" args))
(defn access-alarm [& args] (create-mui-icon "AccessAlarm" args))
(defn access-alarms [& args] (create-mui-icon "AccessAlarms" args))
(defn access-time [& args] (create-mui-icon "AccessTime" args))
(defn accessibility [& args] (create-mui-icon "Accessibility" args))
(defn accessible [& args] (create-mui-icon "Accessible" args))
(defn account-balance [& args] (create-mui-icon "AccountBalance" args))
(defn account-balance-wallet [& args] (create-mui-icon "AccountBalanceWallet" args))
(defn account-box [& args] (create-mui-icon "AccountBox" args))
(defn account-circle [& args] (create-mui-icon "AccountCircle" args))
(defn adb [& args] (create-mui-icon "Adb" args))
(defn add [& args] (create-mui-icon "Add" args))
(defn add-photo [& args] (create-mui-icon "AddAPhoto" args))
(defn add-alarm [& args] (create-mui-icon "AddAlarm" args))
(defn add-alert [& args] (create-mui-icon "AddAlert" args))
(defn add-box [& args] (create-mui-icon "AddBox" args))
(defn add-circle [& args] (create-mui-icon "AddCircle" args))
(defn add-circle-outline [& args] (create-mui-icon "AddCircleOutline" args))
(defn add-location [& args] (create-mui-icon "AddLocation" args))
(defn add-shopping-cart [& args] (create-mui-icon "AddShoppingCart" args))
(defn add-to-photos [& args] (create-mui-icon "AddToPhotos" args))
(defn add-to-queue [& args] (create-mui-icon "AddToQueue" args))
(defn adjust [& args] (create-mui-icon "Adjust" args))
(defn airline-seat-flat [& args] (create-mui-icon "AirlineSeatFlat" args))
(defn airline-seat-flat-angled [& args] (create-mui-icon "AirlineSeatFlatAngled" args))
(defn airline-seat-individual-suite [& args] (create-mui-icon "AirlineSeatIndividualSuite" args))
(defn airline-seat-legroom-extra [& args] (create-mui-icon "AirlineSeatLegroomExtra" args))
(defn airline-seat-legroom-normal [& args] (create-mui-icon "AirlineSeatLegroomNormal" args))
(defn airline-seat-legroom-reduced [& args] (create-mui-icon "AirlineSeatLegroomReduced" args))
(defn airline-seat-recline-extra [& args] (create-mui-icon "AirlineSeatReclineExtra" args))
(defn airline-seat-recline-normal [& args] (create-mui-icon "AirlineSeatReclineNormal" args))
(defn airplanemode-active [& args] (create-mui-icon "AirplanemodeActive" args))
(defn airplanemode-inactive [& args] (create-mui-icon "AirplanemodeInactive" args))
(defn airplay [& args] (create-mui-icon "Airplay" args))
(defn airport-shuttle [& args] (create-mui-icon "AirportShuttle" args))
(defn alarm [& args] (create-mui-icon "Alarm" args))
(defn alarm-add [& args] (create-mui-icon "AlarmAdd" args))
(defn alarm-off [& args] (create-mui-icon "AlarmOff" args))
(defn alarm-on [& args] (create-mui-icon "AlarmOn" args))
(defn album [& args] (create-mui-icon "Album" args))
(defn all-inclusive [& args] (create-mui-icon "AllInclusive" args))
(defn all-out [& args] (create-mui-icon "AllOut" args))
(defn android [& args] (create-mui-icon "Android" args))
(defn announcement [& args] (create-mui-icon "Announcement" args))
(defn apps [& args] (create-mui-icon "Apps" args))
(defn archive [& args] (create-mui-icon "Archive" args))
(defn arrow-back [& args] (create-mui-icon "ArrowBack" args))
(defn arrow-downward [& args] (create-mui-icon "ArrowDownward" args))
(defn arrow-drop-down [& args] (create-mui-icon "ArrowDropDown" args))
(defn arrow-drop-down-circle [& args] (create-mui-icon "ArrowDropDownCircle" args))
(defn arrow-drop-up [& args] (create-mui-icon "ArrowDropUp" args))
(defn arrow-forward [& args] (create-mui-icon "ArrowForward" args))
(defn arrow-upward [& args] (create-mui-icon "ArrowUpward" args))
(defn art-track [& args] (create-mui-icon "ArtTrack" args))
(defn aspect-ratio [& args] (create-mui-icon "AspectRatio" args))
(defn assessment [& args] (create-mui-icon "Assessment" args))
(defn assignment [& args] (create-mui-icon "Assignment" args))
(defn assignment-ind [& args] (create-mui-icon "AssignmentInd" args))
(defn assignment-late [& args] (create-mui-icon "AssignmentLate" args))
(defn assignment-return [& args] (create-mui-icon "AssignmentReturn" args))
(defn assignment-returned [& args] (create-mui-icon "AssignmentReturned" args))
(defn assignment-turned-in [& args] (create-mui-icon "AssignmentTurnedIn" args))
(defn assistant [& args] (create-mui-icon "Assistant" args))
(defn assistant-photo [& args] (create-mui-icon "AssistantPhoto" args))
(defn attach-file [& args] (create-mui-icon "AttachFile" args))
(defn attach-money [& args] (create-mui-icon "AttachMoney" args))
(defn attachment [& args] (create-mui-icon "Attachment" args))
(defn audiotrack [& args] (create-mui-icon "Audiotrack" args))
(defn autorenew [& args] (create-mui-icon "Autorenew" args))
(defn av-timer [& args] (create-mui-icon "AvTimer" args))
(defn backspace [& args] (create-mui-icon "Backspace" args))
(defn backup [& args] (create-mui-icon "Backup" args))
(defn battery-20 [& args] (create-mui-icon "Battery20" args))
(defn battery-30 [& args] (create-mui-icon "Battery30" args))
(defn battery-50 [& args] (create-mui-icon "Battery50" args))
(defn battery-60 [& args] (create-mui-icon "Battery60" args))
(defn battery-80 [& args] (create-mui-icon "Battery80" args))
(defn battery-90 [& args] (create-mui-icon "Battery90" args))
(defn battery-alert [& args] (create-mui-icon "BatteryAlert" args))
(defn battery-charging-20 [& args] (create-mui-icon "BatteryCharging20" args))
(defn battery-charging-30 [& args] (create-mui-icon "BatteryCharging30" args))
(defn battery-charging-50 [& args] (create-mui-icon "BatteryCharging50" args))
(defn battery-charging-60 [& args] (create-mui-icon "BatteryCharging60" args))
(defn battery-charging-80 [& args] (create-mui-icon "BatteryCharging80" args))
(defn battery-charging-90 [& args] (create-mui-icon "BatteryCharging90" args))
(defn battery-charging-full [& args] (create-mui-icon "BatteryChargingFull" args))
(defn battery-full [& args] (create-mui-icon "BatteryFull" args))
(defn battery-std [& args] (create-mui-icon "BatteryStd" args))
(defn battery-unknown [& args] (create-mui-icon "BatteryUnknown" args))
(defn beach-access [& args] (create-mui-icon "BeachAccess" args))
(defn beenhere [& args] (create-mui-icon "Beenhere" args))
(defn block [& args] (create-mui-icon "Block" args))
(defn bluetooth [& args] (create-mui-icon "Bluetooth" args))
(defn bluetooth-audio [& args] (create-mui-icon "BluetoothAudio" args))
(defn bluetooth-connected [& args] (create-mui-icon "BluetoothConnected" args))
(defn bluetooth-disabled [& args] (create-mui-icon "BluetoothDisabled" args))
(defn bluetooth-searching [& args] (create-mui-icon "BluetoothSearching" args))
(defn blur-circular [& args] (create-mui-icon "BlurCircular" args))
(defn blur-linear [& args] (create-mui-icon "BlurLinear" args))
(defn blur-off [& args] (create-mui-icon "BlurOff" args))
(defn blur-on [& args] (create-mui-icon "BlurOn" args))
(defn book [& args] (create-mui-icon "Book" args))
(defn bookmark [& args] (create-mui-icon "Bookmark" args))
(defn bookmark-border [& args] (create-mui-icon "BookmarkBorder" args))
(defn border-all [& args] (create-mui-icon "BorderAll" args))
(defn border-bottom [& args] (create-mui-icon "BorderBottom" args))
(defn border-clear [& args] (create-mui-icon "BorderClear" args))
(defn border-color [& args] (create-mui-icon "BorderColor" args))
(defn border-horizontal [& args] (create-mui-icon "BorderHorizontal" args))
(defn border-inner [& args] (create-mui-icon "BorderInner" args))
(defn border-left [& args] (create-mui-icon "BorderLeft" args))
(defn border-outer [& args] (create-mui-icon "BorderOuter" args))
(defn border-right [& args] (create-mui-icon "BorderRight" args))
(defn border-style [& args] (create-mui-icon "BorderStyle" args))
(defn border-top [& args] (create-mui-icon "BorderTop" args))
(defn border-vertical [& args] (create-mui-icon "BorderVertical" args))
(defn branding-watermark [& args] (create-mui-icon "BrandingWatermark" args))
(defn brightness-1 [& args] (create-mui-icon "Brightness1" args))
(defn brightness-2 [& args] (create-mui-icon "Brightness2" args))
(defn brightness-3 [& args] (create-mui-icon "Brightness3" args))
(defn brightness-4 [& args] (create-mui-icon "Brightness4" args))
(defn brightness-5 [& args] (create-mui-icon "Brightness5" args))
(defn brightness-6 [& args] (create-mui-icon "Brightness6" args))
(defn brightness-7 [& args] (create-mui-icon "Brightness7" args))
(defn brightness-auto [& args] (create-mui-icon "BrightnessAuto" args))
(defn brightness-high [& args] (create-mui-icon "BrightnessHigh" args))
(defn brightness-low [& args] (create-mui-icon "BrightnessLow" args))
(defn brightness-medium [& args] (create-mui-icon "BrightnessMedium" args))
(defn broken-image [& args] (create-mui-icon "BrokenImage" args))
(defn brush [& args] (create-mui-icon "Brush" args))
(defn bubble-chart [& args] (create-mui-icon "BubbleChart" args))
(defn bug-report [& args] (create-mui-icon "BugReport" args))
(defn build [& args] (create-mui-icon "Build" args))
(defn burst-mode [& args] (create-mui-icon "BurstMode" args))
(defn business [& args] (create-mui-icon "Business" args))
(defn business-center [& args] (create-mui-icon "BusinessCenter" args))
(defn cached [& args] (create-mui-icon "Cached" args))
(defn cake [& args] (create-mui-icon "Cake" args))
(defn call [& args] (create-mui-icon "Call" args))
(defn call-end [& args] (create-mui-icon "CallEnd" args))
(defn call-made [& args] (create-mui-icon "CallMade" args))
(defn call-merge [& args] (create-mui-icon "CallMerge" args))
(defn call-missed [& args] (create-mui-icon "CallMissed" args))
(defn call-missed-outgoing [& args] (create-mui-icon "CallMissedOutgoing" args))
(defn call-received [& args] (create-mui-icon "CallReceived" args))
(defn call-split [& args] (create-mui-icon "CallSplit" args))
(defn call-to-action [& args] (create-mui-icon "CallToAction" args))
(defn camera [& args] (create-mui-icon "Camera" args))
(defn camera-alt [& args] (create-mui-icon "CameraAlt" args))
(defn camera-enhance [& args] (create-mui-icon "CameraEnhance" args))
(defn camera-front [& args] (create-mui-icon "CameraFront" args))
(defn camera-rear [& args] (create-mui-icon "CameraRear" args))
(defn camera-roll [& args] (create-mui-icon "CameraRoll" args))
(defn cancel [& args] (create-mui-icon "Cancel" args))
(defn card-giftcard [& args] (create-mui-icon "CardGiftcard" args))
(defn card-membership [& args] (create-mui-icon "CardMembership" args))
(defn card-travel [& args] (create-mui-icon "CardTravel" args))
(defn casino [& args] (create-mui-icon "Casino" args))
(defn cast [& args] (create-mui-icon "Cast" args))
(defn cast-connected [& args] (create-mui-icon "CastConnected" args))
(defn center-focus-strong [& args] (create-mui-icon "CenterFocusStrong" args))
(defn center-focus-weak [& args] (create-mui-icon "CenterFocusWeak" args))
(defn change-history [& args] (create-mui-icon "ChangeHistory" args))
(defn chat [& args] (create-mui-icon "Chat" args))
(defn chat-bubble [& args] (create-mui-icon "ChatBubble" args))
(defn chat-bubble-outline [& args] (create-mui-icon "ChatBubbleOutline" args))
(defn check [& args] (create-mui-icon "Check" args))
(defn check-box [& args] (create-mui-icon "CheckBox" args))
(defn check-box-outline-blank [& args] (create-mui-icon "CheckBoxOutlineBlank" args))
(defn check-circle [& args] (create-mui-icon "CheckCircle" args))
(defn chevron-left [& args] (create-mui-icon "ChevronLeft" args))
(defn chevron-right [& args] (create-mui-icon "ChevronRight" args))
(defn child-care [& args] (create-mui-icon "ChildCare" args))
(defn child-friendly [& args] (create-mui-icon "ChildFriendly" args))
(defn chrome-reader-mode [& args] (create-mui-icon "ChromeReaderMode" args))
(defn class [& args] (create-mui-icon "Class" args))
(defn clear [& args] (create-mui-icon "Clear" args))
(defn clear-all [& args] (create-mui-icon "ClearAll" args))
(defn close [& args] (create-mui-icon "Close" args))
(defn closed-caption [& args] (create-mui-icon "ClosedCaption" args))
(defn cloud [& args] (create-mui-icon "Cloud" args))
(defn cloud-circle [& args] (create-mui-icon "CloudCircle" args))
(defn cloud-done [& args] (create-mui-icon "CloudDone" args))
(defn cloud-download [& args] (create-mui-icon "CloudDownload" args))
(defn cloud-off [& args] (create-mui-icon "CloudOff" args))
(defn cloud-queue [& args] (create-mui-icon "CloudQueue" args))
(defn cloud-upload [& args] (create-mui-icon "CloudUpload" args))
(defn code [& args] (create-mui-icon "Code" args))
(defn collections [& args] (create-mui-icon "Collections" args))
(defn collections-bookmark [& args] (create-mui-icon "CollectionsBookmark" args))
(defn color-lens [& args] (create-mui-icon "ColorLens" args))
(defn colorize [& args] (create-mui-icon "Colorize" args))
(defn comment [& args] (create-mui-icon "Comment" args))
(defn compare [& args] (create-mui-icon "Compare" args))
(defn compare-arrows [& args] (create-mui-icon "CompareArrows" args))
(defn computer [& args] (create-mui-icon "Computer" args))
(defn confirmation-number [& args] (create-mui-icon "ConfirmationNumber" args))
(defn contact-mail [& args] (create-mui-icon "ContactMail" args))
(defn contact-phone [& args] (create-mui-icon "ContactPhone" args))
(defn contacts [& args] (create-mui-icon "Contacts" args))
(defn content-copy [& args] (create-mui-icon "ContentCopy" args))
(defn content-cut [& args] (create-mui-icon "ContentCut" args))
(defn content-paste [& args] (create-mui-icon "ContentPaste" args))
(defn control-point [& args] (create-mui-icon "ControlPoint" args))
(defn control-point-duplicate [& args] (create-mui-icon "ControlPointDuplicate" args))
(defn copyright [& args] (create-mui-icon "Copyright" args))
(defn create [& args] (create-mui-icon "Create" args))
(defn create-new-folder [& args] (create-mui-icon "CreateNewFolder" args))
(defn credit-card [& args] (create-mui-icon "CreditCard" args))
(defn crop [& args] (create-mui-icon "Crop" args))
(defn crop-169 [& args] (create-mui-icon "Crop169" args))
(defn crop-32 [& args] (create-mui-icon "Crop32" args))
(defn crop-54 [& args] (create-mui-icon "Crop54" args))
(defn crop-75 [& args] (create-mui-icon "Crop75" args))
(defn crop-din [& args] (create-mui-icon "CropDin" args))
(defn crop-free [& args] (create-mui-icon "CropFree" args))
(defn crop-landscape [& args] (create-mui-icon "CropLandscape" args))
(defn crop-original [& args] (create-mui-icon "CropOriginal" args))
(defn crop-portrait [& args] (create-mui-icon "CropPortrait" args))
(defn crop-rotate [& args] (create-mui-icon "CropRotate" args))
(defn crop-square [& args] (create-mui-icon "CropSquare" args))
(defn dashboard [& args] (create-mui-icon "Dashboard" args))
(defn data-usage [& args] (create-mui-icon "DataUsage" args))
(defn date-range [& args] (create-mui-icon "DateRange" args))
(defn dehaze [& args] (create-mui-icon "Dehaze" args))
(defn delete [& args] (create-mui-icon "Delete" args))
(defn delete-forever [& args] (create-mui-icon "DeleteForever" args))
(defn delete-sweep [& args] (create-mui-icon "DeleteSweep" args))
(defn description [& args] (create-mui-icon "Description" args))
(defn desktop-mac [& args] (create-mui-icon "DesktopMac" args))
(defn desktop-windows [& args] (create-mui-icon "DesktopWindows" args))
(defn details [& args] (create-mui-icon "Details" args))
(defn developer-board [& args] (create-mui-icon "DeveloperBoard" args))
(defn developer-mode [& args] (create-mui-icon "DeveloperMode" args))
(defn device-hub [& args] (create-mui-icon "DeviceHub" args))
(defn devices [& args] (create-mui-icon "Devices" args))
(defn devices-other [& args] (create-mui-icon "DevicesOther" args))
(defn dialer-sip [& args] (create-mui-icon "DialerSip" args))
(defn dialpad [& args] (create-mui-icon "Dialpad" args))
(defn directions [& args] (create-mui-icon "Directions" args))
(defn directions-bike [& args] (create-mui-icon "DirectionsBike" args))
(defn directions-boat [& args] (create-mui-icon "DirectionsBoat" args))
(defn directions-bus [& args] (create-mui-icon "DirectionsBus" args))
(defn directions-car [& args] (create-mui-icon "DirectionsCar" args))
(defn directions-railway [& args] (create-mui-icon "DirectionsRailway" args))
(defn directions-run [& args] (create-mui-icon "DirectionsRun" args))
(defn directions-subway [& args] (create-mui-icon "DirectionsSubway" args))
(defn directions-transit [& args] (create-mui-icon "DirectionsTransit" args))
(defn directions-walk [& args] (create-mui-icon "DirectionsWalk" args))
(defn disc-full [& args] (create-mui-icon "DiscFull" args))
(defn dns [& args] (create-mui-icon "Dns" args))
(defn do-not-disturb [& args] (create-mui-icon "DoNotDisturb" args))
(defn do-not-disturb-alt [& args] (create-mui-icon "DoNotDisturbAlt" args))
(defn do-not-disturb-off [& args] (create-mui-icon "DoNotDisturbOff" args))
(defn do-not-disturb-on [& args] (create-mui-icon "DoNotDisturbOn" args))
(defn dock [& args] (create-mui-icon "Dock" args))
(defn domain [& args] (create-mui-icon "Domain" args))
(defn done [& args] (create-mui-icon "Done" args))
(defn done-all [& args] (create-mui-icon "DoneAll" args))
(defn donut-large [& args] (create-mui-icon "DonutLarge" args))
(defn donut-small [& args] (create-mui-icon "DonutSmall" args))
(defn drafts [& args] (create-mui-icon "Drafts" args))
(defn drag-handle [& args] (create-mui-icon "DragHandle" args))
(defn drive-eta [& args] (create-mui-icon "DriveEta" args))
(defn dvr [& args] (create-mui-icon "Dvr" args))
(defn edit [& args] (create-mui-icon "Edit" args))
(defn edit-location [& args] (create-mui-icon "EditLocation" args))
(defn eject [& args] (create-mui-icon "Eject" args))
(defn email [& args] (create-mui-icon "Email" args))
(defn enhanced-encryption [& args] (create-mui-icon "EnhancedEncryption" args))
(defn equalizer [& args] (create-mui-icon "Equalizer" args))
(defn error [& args] (create-mui-icon "Error" args))
(defn error-outline [& args] (create-mui-icon "ErrorOutline" args))
(defn euro-symbol [& args] (create-mui-icon "EuroSymbol" args))
(defn ev-station [& args] (create-mui-icon "EvStation" args))
(defn event [& args] (create-mui-icon "Event" args))
(defn event-available [& args] (create-mui-icon "EventAvailable" args))
(defn event-busy [& args] (create-mui-icon "EventBusy" args))
(defn event-note [& args] (create-mui-icon "EventNote" args))
(defn event-seat [& args] (create-mui-icon "EventSeat" args))
(defn exit-to-app [& args] (create-mui-icon "ExitToApp" args))
(defn expand-less [& args] (create-mui-icon "ExpandLess" args))
(defn expand-more [& args] (create-mui-icon "ExpandMore" args))
(defn explicit [& args] (create-mui-icon "Explicit" args))
(defn explore [& args] (create-mui-icon "Explore" args))
(defn exposure [& args] (create-mui-icon "Exposure" args))
(defn exposure-neg [& args] (create-mui-icon "ExposureNeg1" args))
(defn exposure-neg [& args] (create-mui-icon "ExposureNeg2" args))
(defn exposure-plus [& args] (create-mui-icon "ExposurePlus1" args))
(defn exposure-plus [& args] (create-mui-icon "ExposurePlus2" args))
(defn exposure-zero [& args] (create-mui-icon "ExposureZero" args))
(defn extension [& args] (create-mui-icon "Extension" args))
(defn face [& args] (create-mui-icon "Face" args))
(defn fast-forward [& args] (create-mui-icon "FastForward" args))
(defn fast-rewind [& args] (create-mui-icon "FastRewind" args))
(defn favorite [& args] (create-mui-icon "Favorite" args))
(defn favorite-border [& args] (create-mui-icon "FavoriteBorder" args))
(defn featured-play-list [& args] (create-mui-icon "FeaturedPlayList" args))
(defn featured-video [& args] (create-mui-icon "FeaturedVideo" args))
(defn feedback [& args] (create-mui-icon "Feedback" args))
(defn fiber-dvr [& args] (create-mui-icon "FiberDvr" args))
(defn fiber-manual-record [& args] (create-mui-icon "FiberManualRecord" args))
(defn fiber-new [& args] (create-mui-icon "FiberNew" args))
(defn fiber-pin [& args] (create-mui-icon "FiberPin" args))
(defn fiber-smart-record [& args] (create-mui-icon "FiberSmartRecord" args))
(defn file-download [& args] (create-mui-icon "FileDownload" args))
(defn file-upload [& args] (create-mui-icon "FileUpload" args))
(defn filter [& args] (create-mui-icon "Filter" args))
(defn filter-1 [& args] (create-mui-icon "Filter1" args))
(defn filter-2 [& args] (create-mui-icon "Filter2" args))
(defn filter-3 [& args] (create-mui-icon "Filter3" args))
(defn filter-4 [& args] (create-mui-icon "Filter4" args))
(defn filter-5 [& args] (create-mui-icon "Filter5" args))
(defn filter-6 [& args] (create-mui-icon "Filter6" args))
(defn filter-7 [& args] (create-mui-icon "Filter7" args))
(defn filter-8 [& args] (create-mui-icon "Filter8" args))
(defn filter-9 [& args] (create-mui-icon "Filter9" args))
(defn filter-9-plus [& args] (create-mui-icon "Filter9Plus" args))
(defn filter-and [& args] (create-mui-icon "FilterBAndW" args))
(defn filter-center-focus [& args] (create-mui-icon "FilterCenterFocus" args))
(defn filter-drama [& args] (create-mui-icon "FilterDrama" args))
(defn filter-frames [& args] (create-mui-icon "FilterFrames" args))
(defn filter-hdr [& args] (create-mui-icon "FilterHdr" args))
(defn filter-list [& args] (create-mui-icon "FilterList" args))
(defn filter-none [& args] (create-mui-icon "FilterNone" args))
(defn filter-tilt-shift [& args] (create-mui-icon "FilterTiltShift" args))
(defn filter-vintage [& args] (create-mui-icon "FilterVintage" args))
(defn find-in-page [& args] (create-mui-icon "FindInPage" args))
(defn find-replace [& args] (create-mui-icon "FindReplace" args))
(defn fingerprint [& args] (create-mui-icon "Fingerprint" args))
(defn first-page [& args] (create-mui-icon "FirstPage" args))
(defn fitness-center [& args] (create-mui-icon "FitnessCenter" args))
(defn flag [& args] (create-mui-icon "Flag" args))
(defn flare [& args] (create-mui-icon "Flare" args))
(defn flash-auto [& args] (create-mui-icon "FlashAuto" args))
(defn flash-off [& args] (create-mui-icon "FlashOff" args))
(defn flash-on [& args] (create-mui-icon "FlashOn" args))
(defn flight [& args] (create-mui-icon "Flight" args))
(defn flight-land [& args] (create-mui-icon "FlightLand" args))
(defn flight-takeoff [& args] (create-mui-icon "FlightTakeoff" args))
(defn flip [& args] (create-mui-icon "Flip" args))
(defn flip-to-back [& args] (create-mui-icon "FlipToBack" args))
(defn flip-to-front [& args] (create-mui-icon "FlipToFront" args))
(defn folder [& args] (create-mui-icon "Folder" args))
(defn folder-open [& args] (create-mui-icon "FolderOpen" args))
(defn folder-shared [& args] (create-mui-icon "FolderShared" args))
(defn folder-special [& args] (create-mui-icon "FolderSpecial" args))
(defn font-download [& args] (create-mui-icon "FontDownload" args))
(defn format-align-center [& args] (create-mui-icon "FormatAlignCenter" args))
(defn format-align-justify [& args] (create-mui-icon "FormatAlignJustify" args))
(defn format-align-left [& args] (create-mui-icon "FormatAlignLeft" args))
(defn format-align-right [& args] (create-mui-icon "FormatAlignRight" args))
(defn format-bold [& args] (create-mui-icon "FormatBold" args))
(defn format-clear [& args] (create-mui-icon "FormatClear" args))
(defn format-color-fill [& args] (create-mui-icon "FormatColorFill" args))
(defn format-color-reset [& args] (create-mui-icon "FormatColorReset" args))
(defn format-color-text [& args] (create-mui-icon "FormatColorText" args))
(defn format-indent-decrease [& args] (create-mui-icon "FormatIndentDecrease" args))
(defn format-indent-increase [& args] (create-mui-icon "FormatIndentIncrease" args))
(defn format-italic [& args] (create-mui-icon "FormatItalic" args))
(defn format-line-spacing [& args] (create-mui-icon "FormatLineSpacing" args))
(defn format-list-bulleted [& args] (create-mui-icon "FormatListBulleted" args))
(defn format-list-numbered [& args] (create-mui-icon "FormatListNumbered" args))
(defn format-paint [& args] (create-mui-icon "FormatPaint" args))
(defn format-quote [& args] (create-mui-icon "FormatQuote" args))
(defn format-shapes [& args] (create-mui-icon "FormatShapes" args))
(defn format-size [& args] (create-mui-icon "FormatSize" args))
(defn format-strikethrough [& args] (create-mui-icon "FormatStrikethrough" args))
(defn format-textdirection-to [& args] (create-mui-icon "FormatTextdirectionLToR" args))
(defn format-textdirection-to [& args] (create-mui-icon "FormatTextdirectionRToL" args))
(defn format-underlined [& args] (create-mui-icon "FormatUnderlined" args))
(defn forum [& args] (create-mui-icon "Forum" args))
(defn forward [& args] (create-mui-icon "Forward" args))
(defn forward-10 [& args] (create-mui-icon "Forward10" args))
(defn forward-30 [& args] (create-mui-icon "Forward30" args))
(defn forward-5 [& args] (create-mui-icon "Forward5" args))
(defn free-breakfast [& args] (create-mui-icon "FreeBreakfast" args))
(defn fullscreen [& args] (create-mui-icon "Fullscreen" args))
(defn fullscreen-exit [& args] (create-mui-icon "FullscreenExit" args))
(defn functions [& args] (create-mui-icon "Functions" args))
(defn g-translate [& args] (create-mui-icon "GTranslate" args))
(defn gamepad [& args] (create-mui-icon "Gamepad" args))
(defn games [& args] (create-mui-icon "Games" args))
(defn gavel [& args] (create-mui-icon "Gavel" args))
(defn gesture [& args] (create-mui-icon "Gesture" args))
(defn get-app [& args] (create-mui-icon "GetApp" args))
(defn gif [& args] (create-mui-icon "Gif" args))
(defn golf-course [& args] (create-mui-icon "GolfCourse" args))
(defn gps-fixed [& args] (create-mui-icon "GpsFixed" args))
(defn gps-not-fixed [& args] (create-mui-icon "GpsNotFixed" args))
(defn gps-off [& args] (create-mui-icon "GpsOff" args))
(defn grade [& args] (create-mui-icon "Grade" args))
(defn gradient [& args] (create-mui-icon "Gradient" args))
(defn grain [& args] (create-mui-icon "Grain" args))
(defn graphic-eq [& args] (create-mui-icon "GraphicEq" args))
(defn grid-off [& args] (create-mui-icon "GridOff" args))
(defn grid-on [& args] (create-mui-icon "GridOn" args))
(defn group [& args] (create-mui-icon "Group" args))
(defn group-add [& args] (create-mui-icon "GroupAdd" args))
(defn group-work [& args] (create-mui-icon "GroupWork" args))
(defn hd [& args] (create-mui-icon "Hd" args))
(defn hdr-off [& args] (create-mui-icon "HdrOff" args))
(defn hdr-on [& args] (create-mui-icon "HdrOn" args))
(defn hdr-strong [& args] (create-mui-icon "HdrStrong" args))
(defn hdr-weak [& args] (create-mui-icon "HdrWeak" args))
(defn headset [& args] (create-mui-icon "Headset" args))
(defn headset-mic [& args] (create-mui-icon "HeadsetMic" args))
(defn healing [& args] (create-mui-icon "Healing" args))
(defn hearing [& args] (create-mui-icon "Hearing" args))
(defn help [& args] (create-mui-icon "Help" args))
(defn help-outline [& args] (create-mui-icon "HelpOutline" args))
(defn high-quality [& args] (create-mui-icon "HighQuality" args))
(defn highlight [& args] (create-mui-icon "Highlight" args))
(defn highlight-off [& args] (create-mui-icon "HighlightOff" args))
(defn history [& args] (create-mui-icon "History" args))
(defn home [& args] (create-mui-icon "Home" args))
(defn hot-tub [& args] (create-mui-icon "HotTub" args))
(defn hotel [& args] (create-mui-icon "Hotel" args))
(defn hourglass-empty [& args] (create-mui-icon "HourglassEmpty" args))
(defn hourglass-full [& args] (create-mui-icon "HourglassFull" args))
(defn http [& args] (create-mui-icon "Http" args))
(defn https [& args] (create-mui-icon "Https" args))
(defn image [& args] (create-mui-icon "Image" args))
(defn image-aspect-ratio [& args] (create-mui-icon "ImageAspectRatio" args))
(defn import-contacts [& args] (create-mui-icon "ImportContacts" args))
(defn import-export [& args] (create-mui-icon "ImportExport" args))
(defn important-devices [& args] (create-mui-icon "ImportantDevices" args))
(defn inbox [& args] (create-mui-icon "Inbox" args))
(defn indeterminate-check-box [& args] (create-mui-icon "IndeterminateCheckBox" args))
(defn info [& args] (create-mui-icon "Info" args))
(defn info-outline [& args] (create-mui-icon "InfoOutline" args))
(defn input [& args] (create-mui-icon "Input" args))
(defn insert-chart [& args] (create-mui-icon "InsertChart" args))
(defn insert-comment [& args] (create-mui-icon "InsertComment" args))
(defn insert-drive-file [& args] (create-mui-icon "InsertDriveFile" args))
(defn insert-emoticon [& args] (create-mui-icon "InsertEmoticon" args))
(defn insert-invitation [& args] (create-mui-icon "InsertInvitation" args))
(defn insert-link [& args] (create-mui-icon "InsertLink" args))
(defn insert-photo [& args] (create-mui-icon "InsertPhoto" args))
(defn invert-colors [& args] (create-mui-icon "InvertColors" args))
(defn invert-colors-off [& args] (create-mui-icon "InvertColorsOff" args))
(defn iso [& args] (create-mui-icon "Iso" args))
(defn keyboard [& args] (create-mui-icon "Keyboard" args))
(defn keyboard-arrow-down [& args] (create-mui-icon "KeyboardArrowDown" args))
(defn keyboard-arrow-left [& args] (create-mui-icon "KeyboardArrowLeft" args))
(defn keyboard-arrow-right [& args] (create-mui-icon "KeyboardArrowRight" args))
(defn keyboard-arrow-up [& args] (create-mui-icon "KeyboardArrowUp" args))
(defn keyboard-backspace [& args] (create-mui-icon "KeyboardBackspace" args))
(defn keyboard-capslock [& args] (create-mui-icon "KeyboardCapslock" args))
(defn keyboard-hide [& args] (create-mui-icon "KeyboardHide" args))
(defn keyboard-return [& args] (create-mui-icon "KeyboardReturn" args))
(defn keyboard-tab [& args] (create-mui-icon "KeyboardTab" args))
(defn keyboard-voice [& args] (create-mui-icon "KeyboardVoice" args))
(defn kitchen [& args] (create-mui-icon "Kitchen" args))
(defn label [& args] (create-mui-icon "Label" args))
(defn label-outline [& args] (create-mui-icon "LabelOutline" args))
(defn landscape [& args] (create-mui-icon "Landscape" args))
(defn language [& args] (create-mui-icon "Language" args))
(defn laptop [& args] (create-mui-icon "Laptop" args))
(defn laptop-chromebook [& args] (create-mui-icon "LaptopChromebook" args))
(defn laptop-mac [& args] (create-mui-icon "LaptopMac" args))
(defn laptop-windows [& args] (create-mui-icon "LaptopWindows" args))
(defn last-page [& args] (create-mui-icon "LastPage" args))
(defn launch [& args] (create-mui-icon "Launch" args))
(defn layers [& args] (create-mui-icon "Layers" args))
(defn layers-clear [& args] (create-mui-icon "LayersClear" args))
(defn leak-add [& args] (create-mui-icon "LeakAdd" args))
(defn leak-remove [& args] (create-mui-icon "LeakRemove" args))
(defn lens [& args] (create-mui-icon "Lens" args))
(defn library-add [& args] (create-mui-icon "LibraryAdd" args))
(defn library-books [& args] (create-mui-icon "LibraryBooks" args))
(defn library-music [& args] (create-mui-icon "LibraryMusic" args))
(defn lightbulb-outline [& args] (create-mui-icon "LightbulbOutline" args))
(defn line-style [& args] (create-mui-icon "LineStyle" args))
(defn line-weight [& args] (create-mui-icon "LineWeight" args))
(defn linear-scale [& args] (create-mui-icon "LinearScale" args))
(defn link [& args] (create-mui-icon "Link" args))
(defn linked-camera [& args] (create-mui-icon "LinkedCamera" args))
(defn list [& args] (create-mui-icon "List" args))
(defn live-help [& args] (create-mui-icon "LiveHelp" args))
(defn live-tv [& args] (create-mui-icon "LiveTv" args))
(defn local-activity [& args] (create-mui-icon "LocalActivity" args))
(defn local-airport [& args] (create-mui-icon "LocalAirport" args))
(defn local-atm [& args] (create-mui-icon "LocalAtm" args))
(defn local-bar [& args] (create-mui-icon "LocalBar" args))
(defn local-cafe [& args] (create-mui-icon "LocalCafe" args))
(defn local-car-wash [& args] (create-mui-icon "LocalCarWash" args))
(defn local-convenience-store [& args] (create-mui-icon "LocalConvenienceStore" args))
(defn local-dining [& args] (create-mui-icon "LocalDining" args))
(defn local-drink [& args] (create-mui-icon "LocalDrink" args))
(defn local-florist [& args] (create-mui-icon "LocalFlorist" args))
(defn local-gas-station [& args] (create-mui-icon "LocalGasStation" args))
(defn local-grocery-store [& args] (create-mui-icon "LocalGroceryStore" args))
(defn local-hospital [& args] (create-mui-icon "LocalHospital" args))
(defn local-hotel [& args] (create-mui-icon "LocalHotel" args))
(defn local-laundry-service [& args] (create-mui-icon "LocalLaundryService" args))
(defn local-library [& args] (create-mui-icon "LocalLibrary" args))
(defn local-mall [& args] (create-mui-icon "LocalMall" args))
(defn local-movies [& args] (create-mui-icon "LocalMovies" args))
(defn local-offer [& args] (create-mui-icon "LocalOffer" args))
(defn local-parking [& args] (create-mui-icon "LocalParking" args))
(defn local-pharmacy [& args] (create-mui-icon "LocalPharmacy" args))
(defn local-phone [& args] (create-mui-icon "LocalPhone" args))
(defn local-pizza [& args] (create-mui-icon "LocalPizza" args))
(defn local-play [& args] (create-mui-icon "LocalPlay" args))
(defn local-post-office [& args] (create-mui-icon "LocalPostOffice" args))
(defn local-printshop [& args] (create-mui-icon "LocalPrintshop" args))
(defn local-see [& args] (create-mui-icon "LocalSee" args))
(defn local-shipping [& args] (create-mui-icon "LocalShipping" args))
(defn local-taxi [& args] (create-mui-icon "LocalTaxi" args))
(defn location-city [& args] (create-mui-icon "LocationCity" args))
(defn location-disabled [& args] (create-mui-icon "LocationDisabled" args))
(defn location-off [& args] (create-mui-icon "LocationOff" args))
(defn location-on [& args] (create-mui-icon "LocationOn" args))
(defn location-searching [& args] (create-mui-icon "LocationSearching" args))
(defn lock [& args] (create-mui-icon "Lock" args))
(defn lock-open [& args] (create-mui-icon "LockOpen" args))
(defn lock-outline [& args] (create-mui-icon "LockOutline" args))
(defn looks [& args] (create-mui-icon "Looks" args))
(defn looks-3 [& args] (create-mui-icon "Looks3" args))
(defn looks-4 [& args] (create-mui-icon "Looks4" args))
(defn looks-5 [& args] (create-mui-icon "Looks5" args))
(defn looks-6 [& args] (create-mui-icon "Looks6" args))
(defn looks-one [& args] (create-mui-icon "LooksOne" args))
(defn looks-two [& args] (create-mui-icon "LooksTwo" args))
(defn loop [& args] (create-mui-icon "Loop" args))
(defn loupe [& args] (create-mui-icon "Loupe" args))
(defn low-priority [& args] (create-mui-icon "LowPriority" args))
(defn loyalty [& args] (create-mui-icon "Loyalty" args))
(defn mail [& args] (create-mui-icon "Mail" args))
(defn mail-outline [& args] (create-mui-icon "MailOutline" args))
(defn map [& args] (create-mui-icon "Map" args))
(defn markunread [& args] (create-mui-icon "Markunread" args))
(defn markunread-mailbox [& args] (create-mui-icon "MarkunreadMailbox" args))
(defn memory [& args] (create-mui-icon "Memory" args))
(defn menu [& args] (create-mui-icon "Menu" args))
(defn merge-type [& args] (create-mui-icon "MergeType" args))
(defn message [& args] (create-mui-icon "Message" args))
(defn mic [& args] (create-mui-icon "Mic" args))
(defn mic-none [& args] (create-mui-icon "MicNone" args))
(defn mic-off [& args] (create-mui-icon "MicOff" args))
(defn mms [& args] (create-mui-icon "Mms" args))
(defn mode-comment [& args] (create-mui-icon "ModeComment" args))
(defn mode-edit [& args] (create-mui-icon "ModeEdit" args))
(defn monetization-on [& args] (create-mui-icon "MonetizationOn" args))
(defn money-off [& args] (create-mui-icon "MoneyOff" args))
(defn monochrome-photos [& args] (create-mui-icon "MonochromePhotos" args))
(defn mood [& args] (create-mui-icon "Mood" args))
(defn mood-bad [& args] (create-mui-icon "MoodBad" args))
(defn more [& args] (create-mui-icon "More" args))
(defn more-horiz [& args] (create-mui-icon "MoreHoriz" args))
(defn more-vert [& args] (create-mui-icon "MoreVert" args))
(defn motorcycle [& args] (create-mui-icon "Motorcycle" args))
(defn mouse [& args] (create-mui-icon "Mouse" args))
(defn move-to-inbox [& args] (create-mui-icon "MoveToInbox" args))
(defn movie [& args] (create-mui-icon "Movie" args))
(defn movie-creation [& args] (create-mui-icon "MovieCreation" args))
(defn movie-filter [& args] (create-mui-icon "MovieFilter" args))
(defn multiline-chart [& args] (create-mui-icon "MultilineChart" args))
(defn music-note [& args] (create-mui-icon "MusicNote" args))
(defn music-video [& args] (create-mui-icon "MusicVideo" args))
(defn my-location [& args] (create-mui-icon "MyLocation" args))
(defn nature [& args] (create-mui-icon "Nature" args))
(defn nature-people [& args] (create-mui-icon "NaturePeople" args))
(defn navigate-before [& args] (create-mui-icon "NavigateBefore" args))
(defn navigate-next [& args] (create-mui-icon "NavigateNext" args))
(defn navigation [& args] (create-mui-icon "Navigation" args))
(defn near-me [& args] (create-mui-icon "NearMe" args))
(defn network-cell [& args] (create-mui-icon "NetworkCell" args))
(defn network-check [& args] (create-mui-icon "NetworkCheck" args))
(defn network-locked [& args] (create-mui-icon "NetworkLocked" args))
(defn network-wifi [& args] (create-mui-icon "NetworkWifi" args))
(defn new-releases [& args] (create-mui-icon "NewReleases" args))
(defn next-week [& args] (create-mui-icon "NextWeek" args))
(defn nfc [& args] (create-mui-icon "Nfc" args))
(defn no-encryption [& args] (create-mui-icon "NoEncryption" args))
(defn no-sim [& args] (create-mui-icon "NoSim" args))
(defn not-interested [& args] (create-mui-icon "NotInterested" args))
(defn note [& args] (create-mui-icon "Note" args))
(defn note-add [& args] (create-mui-icon "NoteAdd" args))
(defn notifications [& args] (create-mui-icon "Notifications" args))
(defn notifications-active [& args] (create-mui-icon "NotificationsActive" args))
(defn notifications-none [& args] (create-mui-icon "NotificationsNone" args))
(defn notifications-off [& args] (create-mui-icon "NotificationsOff" args))
(defn notifications-paused [& args] (create-mui-icon "NotificationsPaused" args))
(defn offline-pin [& args] (create-mui-icon "OfflinePin" args))
(defn ondemand-video [& args] (create-mui-icon "OndemandVideo" args))
(defn opacity [& args] (create-mui-icon "Opacity" args))
(defn open-in-browser [& args] (create-mui-icon "OpenInBrowser" args))
(defn open-in-new [& args] (create-mui-icon "OpenInNew" args))
(defn open-with [& args] (create-mui-icon "OpenWith" args))
(defn pages [& args] (create-mui-icon "Pages" args))
(defn pageview [& args] (create-mui-icon "Pageview" args))
(defn palette [& args] (create-mui-icon "Palette" args))
(defn pan-tool [& args] (create-mui-icon "PanTool" args))
(defn panorama [& args] (create-mui-icon "Panorama" args))
(defn panorama-fish-eye [& args] (create-mui-icon "PanoramaFishEye" args))
(defn panorama-horizontal [& args] (create-mui-icon "PanoramaHorizontal" args))
(defn panorama-vertical [& args] (create-mui-icon "PanoramaVertical" args))
(defn panorama-wide-angle [& args] (create-mui-icon "PanoramaWideAngle" args))
(defn party-mode [& args] (create-mui-icon "PartyMode" args))
(defn pause [& args] (create-mui-icon "Pause" args))
(defn pause-circle-filled [& args] (create-mui-icon "PauseCircleFilled" args))
(defn pause-circle-outline [& args] (create-mui-icon "PauseCircleOutline" args))
(defn payment [& args] (create-mui-icon "Payment" args))
(defn people [& args] (create-mui-icon "People" args))
(defn people-outline [& args] (create-mui-icon "PeopleOutline" args))
(defn perm-camera-mic [& args] (create-mui-icon "PermCameraMic" args))
(defn perm-contact-calendar [& args] (create-mui-icon "PermContactCalendar" args))
(defn perm-data-setting [& args] (create-mui-icon "PermDataSetting" args))
(defn perm-device-information [& args] (create-mui-icon "PermDeviceInformation" args))
(defn perm-identity [& args] (create-mui-icon "PermIdentity" args))
(defn perm-media [& args] (create-mui-icon "PermMedia" args))
(defn perm-phone-msg [& args] (create-mui-icon "PermPhoneMsg" args))
(defn perm-scan-wifi [& args] (create-mui-icon "PermScanWifi" args))
(defn person [& args] (create-mui-icon "Person" args))
(defn person-add [& args] (create-mui-icon "PersonAdd" args))
(defn person-outline [& args] (create-mui-icon "PersonOutline" args))
(defn person-pin [& args] (create-mui-icon "PersonPin" args))
(defn person-pin-circle [& args] (create-mui-icon "PersonPinCircle" args))
(defn personal-video [& args] (create-mui-icon "PersonalVideo" args))
(defn pets [& args] (create-mui-icon "Pets" args))
(defn phone [& args] (create-mui-icon "Phone" args))
(defn phone-android [& args] (create-mui-icon "PhoneAndroid" args))
(defn phone-bluetooth-speaker [& args] (create-mui-icon "PhoneBluetoothSpeaker" args))
(defn phone-forwarded [& args] (create-mui-icon "PhoneForwarded" args))
(defn phone-in-talk [& args] (create-mui-icon "PhoneInTalk" args))
(defn phone-iphone [& args] (create-mui-icon "PhoneIphone" args))
(defn phone-locked [& args] (create-mui-icon "PhoneLocked" args))
(defn phone-missed [& args] (create-mui-icon "PhoneMissed" args))
(defn phone-paused [& args] (create-mui-icon "PhonePaused" args))
(defn phonelink [& args] (create-mui-icon "Phonelink" args))
(defn phonelink-erase [& args] (create-mui-icon "PhonelinkErase" args))
(defn phonelink-lock [& args] (create-mui-icon "PhonelinkLock" args))
(defn phonelink-off [& args] (create-mui-icon "PhonelinkOff" args))
(defn phonelink-ring [& args] (create-mui-icon "PhonelinkRing" args))
(defn phonelink-setup [& args] (create-mui-icon "PhonelinkSetup" args))
(defn photo [& args] (create-mui-icon "Photo" args))
(defn photo-album [& args] (create-mui-icon "PhotoAlbum" args))
(defn photo-camera [& args] (create-mui-icon "PhotoCamera" args))
(defn photo-filter [& args] (create-mui-icon "PhotoFilter" args))
(defn photo-library [& args] (create-mui-icon "PhotoLibrary" args))
(defn photo-size-select-actual [& args] (create-mui-icon "PhotoSizeSelectActual" args))
(defn photo-size-select-large [& args] (create-mui-icon "PhotoSizeSelectLarge" args))
(defn photo-size-select-small [& args] (create-mui-icon "PhotoSizeSelectSmall" args))
(defn picture-as-pdf [& args] (create-mui-icon "PictureAsPdf" args))
(defn picture-in-picture [& args] (create-mui-icon "PictureInPicture" args))
(defn picture-in-picture-alt [& args] (create-mui-icon "PictureInPictureAlt" args))
(defn pie-chart [& args] (create-mui-icon "PieChart" args))
(defn pie-chart-outlined [& args] (create-mui-icon "PieChartOutlined" args))
(defn pin-drop [& args] (create-mui-icon "PinDrop" args))
(defn place [& args] (create-mui-icon "Place" args))
(defn play-arrow [& args] (create-mui-icon "PlayArrow" args))
(defn play-circle-filled [& args] (create-mui-icon "PlayCircleFilled" args))
(defn play-circle-outline [& args] (create-mui-icon "PlayCircleOutline" args))
(defn play-for-work [& args] (create-mui-icon "PlayForWork" args))
(defn playlist-add [& args] (create-mui-icon "PlaylistAdd" args))
(defn playlist-add-check [& args] (create-mui-icon "PlaylistAddCheck" args))
(defn playlist-play [& args] (create-mui-icon "PlaylistPlay" args))
(defn plus-one [& args] (create-mui-icon "PlusOne" args))
(defn poll [& args] (create-mui-icon "Poll" args))
(defn polymer [& args] (create-mui-icon "Polymer" args))
(defn pool [& args] (create-mui-icon "Pool" args))
(defn portable-wifi-off [& args] (create-mui-icon "PortableWifiOff" args))
(defn portrait [& args] (create-mui-icon "Portrait" args))
(defn power [& args] (create-mui-icon "Power" args))
(defn power-input [& args] (create-mui-icon "PowerInput" args))
(defn power-settings-new [& args] (create-mui-icon "PowerSettingsNew" args))
(defn pregnant-woman [& args] (create-mui-icon "PregnantWoman" args))
(defn present-to-all [& args] (create-mui-icon "PresentToAll" args))
(defn print [& args] (create-mui-icon "Print" args))
(defn priority-high [& args] (create-mui-icon "PriorityHigh" args))
(defn public [& args] (create-mui-icon "Public" args))
(defn publish [& args] (create-mui-icon "Publish" args))
(defn query-builder [& args] (create-mui-icon "QueryBuilder" args))
(defn question-answer [& args] (create-mui-icon "QuestionAnswer" args))
(defn queue [& args] (create-mui-icon "Queue" args))
(defn queue-music [& args] (create-mui-icon "QueueMusic" args))
(defn queue-play-next [& args] (create-mui-icon "QueuePlayNext" args))
(defn radio [& args] (create-mui-icon "Radio" args))
(defn radio-button-checked [& args] (create-mui-icon "RadioButtonChecked" args))
(defn radio-button-unchecked [& args] (create-mui-icon "RadioButtonUnchecked" args))
(defn rate-review [& args] (create-mui-icon "RateReview" args))
(defn receipt [& args] (create-mui-icon "Receipt" args))
(defn recent-actors [& args] (create-mui-icon "RecentActors" args))
(defn record-voice-over [& args] (create-mui-icon "RecordVoiceOver" args))
(defn redeem [& args] (create-mui-icon "Redeem" args))
(defn redo [& args] (create-mui-icon "Redo" args))
(defn refresh [& args] (create-mui-icon "Refresh" args))
(defn remove [& args] (create-mui-icon "Remove" args))
(defn remove-circle [& args] (create-mui-icon "RemoveCircle" args))
(defn remove-circle-outline [& args] (create-mui-icon "RemoveCircleOutline" args))
(defn remove-from-queue [& args] (create-mui-icon "RemoveFromQueue" args))
(defn remove-red-eye [& args] (create-mui-icon "RemoveRedEye" args))
(defn remove-shopping-cart [& args] (create-mui-icon "RemoveShoppingCart" args))
(defn reorder [& args] (create-mui-icon "Reorder" args))
(defn repeat [& args] (create-mui-icon "Repeat" args))
(defn repeat-one [& args] (create-mui-icon "RepeatOne" args))
(defn replay [& args] (create-mui-icon "Replay" args))
(defn replay-10 [& args] (create-mui-icon "Replay10" args))
(defn replay-30 [& args] (create-mui-icon "Replay30" args))
(defn replay-5 [& args] (create-mui-icon "Replay5" args))
(defn reply [& args] (create-mui-icon "Reply" args))
(defn reply-all [& args] (create-mui-icon "ReplyAll" args))
(defn report [& args] (create-mui-icon "Report" args))
(defn report-problem [& args] (create-mui-icon "ReportProblem" args))
(defn restaurant [& args] (create-mui-icon "Restaurant" args))
(defn restaurant-menu [& args] (create-mui-icon "RestaurantMenu" args))
(defn restore [& args] (create-mui-icon "Restore" args))
(defn restore-page [& args] (create-mui-icon "RestorePage" args))
(defn ring-volume [& args] (create-mui-icon "RingVolume" args))
(defn room [& args] (create-mui-icon "Room" args))
(defn room-service [& args] (create-mui-icon "RoomService" args))
(defn rotate-degrees-ccw [& args] (create-mui-icon "Rotate90DegreesCcw" args))
(defn rotate-left [& args] (create-mui-icon "RotateLeft" args))
(defn rotate-right [& args] (create-mui-icon "RotateRight" args))
(defn rounded-corner [& args] (create-mui-icon "RoundedCorner" args))
(defn router [& args] (create-mui-icon "Router" args))
(defn rowing [& args] (create-mui-icon "Rowing" args))
(defn rss-feed [& args] (create-mui-icon "RssFeed" args))
(defn rv-hookup [& args] (create-mui-icon "RvHookup" args))
(defn satellite [& args] (create-mui-icon "Satellite" args))
(defn save [& args] (create-mui-icon "Save" args))
(defn scanner [& args] (create-mui-icon "Scanner" args))
(defn schedule [& args] (create-mui-icon "Schedule" args))
(defn school [& args] (create-mui-icon "School" args))
(defn screen-lock-landscape [& args] (create-mui-icon "ScreenLockLandscape" args))
(defn screen-lock-portrait [& args] (create-mui-icon "ScreenLockPortrait" args))
(defn screen-lock-rotation [& args] (create-mui-icon "ScreenLockRotation" args))
(defn screen-rotation [& args] (create-mui-icon "ScreenRotation" args))
(defn screen-share [& args] (create-mui-icon "ScreenShare" args))
(defn sd-card [& args] (create-mui-icon "SdCard" args))
(defn sd-storage [& args] (create-mui-icon "SdStorage" args))
(defn search [& args] (create-mui-icon "Search" args))
(defn security [& args] (create-mui-icon "Security" args))
(defn select-all [& args] (create-mui-icon "SelectAll" args))
(defn send [& args] (create-mui-icon "Send" args))
(defn sentiment-dissatisfied [& args] (create-mui-icon "SentimentDissatisfied" args))
(defn sentiment-neutral [& args] (create-mui-icon "SentimentNeutral" args))
(defn sentiment-satisfied [& args] (create-mui-icon "SentimentSatisfied" args))
(defn sentiment-very-dissatisfied [& args] (create-mui-icon "SentimentVeryDissatisfied" args))
(defn sentiment-very-satisfied [& args] (create-mui-icon "SentimentVerySatisfied" args))
(defn settings [& args] (create-mui-icon "Settings" args))
(defn settings-applications [& args] (create-mui-icon "SettingsApplications" args))
(defn settings-backup-restore [& args] (create-mui-icon "SettingsBackupRestore" args))
(defn settings-bluetooth [& args] (create-mui-icon "SettingsBluetooth" args))
(defn settings-brightness [& args] (create-mui-icon "SettingsBrightness" args))
(defn settings-cell [& args] (create-mui-icon "SettingsCell" args))
(defn settings-ethernet [& args] (create-mui-icon "SettingsEthernet" args))
(defn settings-input-antenna [& args] (create-mui-icon "SettingsInputAntenna" args))
(defn settings-input-component [& args] (create-mui-icon "SettingsInputComponent" args))
(defn settings-input-composite [& args] (create-mui-icon "SettingsInputComposite" args))
(defn settings-input-hdmi [& args] (create-mui-icon "SettingsInputHdmi" args))
(defn settings-input-svideo [& args] (create-mui-icon "SettingsInputSvideo" args))
(defn settings-overscan [& args] (create-mui-icon "SettingsOverscan" args))
(defn settings-phone [& args] (create-mui-icon "SettingsPhone" args))
(defn settings-power [& args] (create-mui-icon "SettingsPower" args))
(defn settings-remote [& args] (create-mui-icon "SettingsRemote" args))
(defn settings-system-daydream [& args] (create-mui-icon "SettingsSystemDaydream" args))
(defn settings-voice [& args] (create-mui-icon "SettingsVoice" args))
(defn share [& args] (create-mui-icon "Share" args))
(defn shop [& args] (create-mui-icon "Shop" args))
(defn shop-two [& args] (create-mui-icon "ShopTwo" args))
(defn shopping-basket [& args] (create-mui-icon "ShoppingBasket" args))
(defn shopping-cart [& args] (create-mui-icon "ShoppingCart" args))
(defn short-text [& args] (create-mui-icon "ShortText" args))
(defn show-chart [& args] (create-mui-icon "ShowChart" args))
(defn shuffle [& args] (create-mui-icon "Shuffle" args))
(defn signal-cellular-0-bar [& args] (create-mui-icon "SignalCellular0Bar" args))
(defn signal-cellular-1-bar [& args] (create-mui-icon "SignalCellular1Bar" args))
(defn signal-cellular-2-bar [& args] (create-mui-icon "SignalCellular2Bar" args))
(defn signal-cellular-3-bar [& args] (create-mui-icon "SignalCellular3Bar" args))
(defn signal-cellular-4-bar [& args] (create-mui-icon "SignalCellular4Bar" args))
(defn signal-cellular-connected-no-internet-0-bar [& args] (create-mui-icon "SignalCellularConnectedNoInternet0Bar" args))
(defn signal-cellular-connected-no-internet-1-bar [& args] (create-mui-icon "SignalCellularConnectedNoInternet1Bar" args))
(defn signal-cellular-connected-no-internet-2-bar [& args] (create-mui-icon "SignalCellularConnectedNoInternet2Bar" args))
(defn signal-cellular-connected-no-internet-3-bar [& args] (create-mui-icon "SignalCellularConnectedNoInternet3Bar" args))
(defn signal-cellular-connected-no-internet-4-bar [& args] (create-mui-icon "SignalCellularConnectedNoInternet4Bar" args))
(defn signal-cellular-no-sim [& args] (create-mui-icon "SignalCellularNoSim" args))
(defn signal-cellular-null [& args] (create-mui-icon "SignalCellularNull" args))
(defn signal-cellular-off [& args] (create-mui-icon "SignalCellularOff" args))
(defn signal-wifi-0-bar [& args] (create-mui-icon "SignalWifi0Bar" args))
(defn signal-wifi-1-bar [& args] (create-mui-icon "SignalWifi1Bar" args))
(defn signal-wifi-1-bar-lock [& args] (create-mui-icon "SignalWifi1BarLock" args))
(defn signal-wifi-2-bar [& args] (create-mui-icon "SignalWifi2Bar" args))
(defn signal-wifi-2-bar-lock [& args] (create-mui-icon "SignalWifi2BarLock" args))
(defn signal-wifi-3-bar [& args] (create-mui-icon "SignalWifi3Bar" args))
(defn signal-wifi-3-bar-lock [& args] (create-mui-icon "SignalWifi3BarLock" args))
(defn signal-wifi-4-bar [& args] (create-mui-icon "SignalWifi4Bar" args))
(defn signal-wifi-4-bar-lock [& args] (create-mui-icon "SignalWifi4BarLock" args))
(defn signal-wifi-off [& args] (create-mui-icon "SignalWifiOff" args))
(defn sim-card [& args] (create-mui-icon "SimCard" args))
(defn sim-card-alert [& args] (create-mui-icon "SimCardAlert" args))
(defn skip-next [& args] (create-mui-icon "SkipNext" args))
(defn skip-previous [& args] (create-mui-icon "SkipPrevious" args))
(defn slideshow [& args] (create-mui-icon "Slideshow" args))
(defn slow-motion-video [& args] (create-mui-icon "SlowMotionVideo" args))
(defn smartphone [& args] (create-mui-icon "Smartphone" args))
(defn smoke-free [& args] (create-mui-icon "SmokeFree" args))
(defn smoking-rooms [& args] (create-mui-icon "SmokingRooms" args))
(defn sms [& args] (create-mui-icon "Sms" args))
(defn sms-failed [& args] (create-mui-icon "SmsFailed" args))
(defn snooze [& args] (create-mui-icon "Snooze" args))
(defn sort [& args] (create-mui-icon "Sort" args))
(defn sort-by-alpha [& args] (create-mui-icon "SortByAlpha" args))
(defn spa [& args] (create-mui-icon "Spa" args))
(defn space-bar [& args] (create-mui-icon "SpaceBar" args))
(defn speaker [& args] (create-mui-icon "Speaker" args))
(defn speaker-group [& args] (create-mui-icon "SpeakerGroup" args))
(defn speaker-notes [& args] (create-mui-icon "SpeakerNotes" args))
(defn speaker-notes-off [& args] (create-mui-icon "SpeakerNotesOff" args))
(defn speaker-phone [& args] (create-mui-icon "SpeakerPhone" args))
(defn spellcheck [& args] (create-mui-icon "Spellcheck" args))
(defn star [& args] (create-mui-icon "Star" args))
(defn star-border [& args] (create-mui-icon "StarBorder" args))
(defn star-half [& args] (create-mui-icon "StarHalf" args))
(defn stars [& args] (create-mui-icon "Stars" args))
(defn stay-current-landscape [& args] (create-mui-icon "StayCurrentLandscape" args))
(defn stay-current-portrait [& args] (create-mui-icon "StayCurrentPortrait" args))
(defn stay-primary-landscape [& args] (create-mui-icon "StayPrimaryLandscape" args))
(defn stay-primary-portrait [& args] (create-mui-icon "StayPrimaryPortrait" args))
(defn stop [& args] (create-mui-icon "Stop" args))
(defn stop-screen-share [& args] (create-mui-icon "StopScreenShare" args))
(defn storage [& args] (create-mui-icon "Storage" args))
(defn store [& args] (create-mui-icon "Store" args))
(defn store-mall-directory [& args] (create-mui-icon "StoreMallDirectory" args))
(defn straighten [& args] (create-mui-icon "Straighten" args))
(defn streetview [& args] (create-mui-icon "Streetview" args))
(defn strikethrough [& args] (create-mui-icon "StrikethroughS" args))
(defn style [& args] (create-mui-icon "Style" args))
(defn subdirectory-arrow-left [& args] (create-mui-icon "SubdirectoryArrowLeft" args))
(defn subdirectory-arrow-right [& args] (create-mui-icon "SubdirectoryArrowRight" args))
(defn subject [& args] (create-mui-icon "Subject" args))
(defn subscriptions [& args] (create-mui-icon "Subscriptions" args))
(defn subtitles [& args] (create-mui-icon "Subtitles" args))
(defn subway [& args] (create-mui-icon "Subway" args))
(defn supervisor-account [& args] (create-mui-icon "SupervisorAccount" args))
(defn surround-sound [& args] (create-mui-icon "SurroundSound" args))
(defn swap-calls [& args] (create-mui-icon "SwapCalls" args))
(defn swap-horiz [& args] (create-mui-icon "SwapHoriz" args))
(defn swap-vert [& args] (create-mui-icon "SwapVert" args))
(defn swap-vertical-circle [& args] (create-mui-icon "SwapVerticalCircle" args))
(defn switch-camera [& args] (create-mui-icon "SwitchCamera" args))
(defn switch-video [& args] (create-mui-icon "SwitchVideo" args))
(defn sync [& args] (create-mui-icon "Sync" args))
(defn sync-disabled [& args] (create-mui-icon "SyncDisabled" args))
(defn sync-problem [& args] (create-mui-icon "SyncProblem" args))
(defn system-update [& args] (create-mui-icon "SystemUpdate" args))
(defn system-update-alt [& args] (create-mui-icon "SystemUpdateAlt" args))
(defn tab [& args] (create-mui-icon "Tab" args))
(defn tab-unselected [& args] (create-mui-icon "TabUnselected" args))
(defn tablet [& args] (create-mui-icon "Tablet" args))
(defn tablet-android [& args] (create-mui-icon "TabletAndroid" args))
(defn tablet-mac [& args] (create-mui-icon "TabletMac" args))
(defn tag-faces [& args] (create-mui-icon "TagFaces" args))
(defn tap-and-play [& args] (create-mui-icon "TapAndPlay" args))
(defn terrain [& args] (create-mui-icon "Terrain" args))
(defn text-fields [& args] (create-mui-icon "TextFields" args))
(defn text-format [& args] (create-mui-icon "TextFormat" args))
(defn textsms [& args] (create-mui-icon "Textsms" args))
(defn texture [& args] (create-mui-icon "Texture" args))
(defn theaters [& args] (create-mui-icon "Theaters" args))
(defn three-rotation [& args] (create-mui-icon "ThreeDRotation" args))
(defn thumb-down [& args] (create-mui-icon "ThumbDown" args))
(defn thumb-up [& args] (create-mui-icon "ThumbUp" args))
(defn thumbs-up-down [& args] (create-mui-icon "ThumbsUpDown" args))
(defn time-to-leave [& args] (create-mui-icon "TimeToLeave" args))
(defn timelapse [& args] (create-mui-icon "Timelapse" args))
(defn timeline [& args] (create-mui-icon "Timeline" args))
(defn timer [& args] (create-mui-icon "Timer" args))
(defn timer-10 [& args] (create-mui-icon "Timer10" args))
(defn timer-3 [& args] (create-mui-icon "Timer3" args))
(defn timer-off [& args] (create-mui-icon "TimerOff" args))
(defn title [& args] (create-mui-icon "Title" args))
(defn toc [& args] (create-mui-icon "Toc" args))
(defn today [& args] (create-mui-icon "Today" args))
(defn toll [& args] (create-mui-icon "Toll" args))
(defn tonality [& args] (create-mui-icon "Tonality" args))
(defn touch-app [& args] (create-mui-icon "TouchApp" args))
(defn toys [& args] (create-mui-icon "Toys" args))
(defn track-changes [& args] (create-mui-icon "TrackChanges" args))
(defn traffic [& args] (create-mui-icon "Traffic" args))
(defn train [& args] (create-mui-icon "Train" args))
(defn tram [& args] (create-mui-icon "Tram" args))
(defn transfer-within-station [& args] (create-mui-icon "TransferWithinAStation" args))
(defn transform [& args] (create-mui-icon "Transform" args))
(defn translate [& args] (create-mui-icon "Translate" args))
(defn trending-down [& args] (create-mui-icon "TrendingDown" args))
(defn trending-flat [& args] (create-mui-icon "TrendingFlat" args))
(defn trending-up [& args] (create-mui-icon "TrendingUp" args))
(defn tune [& args] (create-mui-icon "Tune" args))
(defn turned-in [& args] (create-mui-icon "TurnedIn" args))
(defn turned-in-not [& args] (create-mui-icon "TurnedInNot" args))
(defn tv [& args] (create-mui-icon "Tv" args))
(defn unarchive [& args] (create-mui-icon "Unarchive" args))
(defn undo [& args] (create-mui-icon "Undo" args))
(defn unfold-less [& args] (create-mui-icon "UnfoldLess" args))
(defn unfold-more [& args] (create-mui-icon "UnfoldMore" args))
(defn update [& args] (create-mui-icon "Update" args))
(defn usb [& args] (create-mui-icon "Usb" args))
(defn verified-user [& args] (create-mui-icon "VerifiedUser" args))
(defn vertical-align-bottom [& args] (create-mui-icon "VerticalAlignBottom" args))
(defn vertical-align-center [& args] (create-mui-icon "VerticalAlignCenter" args))
(defn vertical-align-top [& args] (create-mui-icon "VerticalAlignTop" args))
(defn vibration [& args] (create-mui-icon "Vibration" args))
(defn video-call [& args] (create-mui-icon "VideoCall" args))
(defn video-label [& args] (create-mui-icon "VideoLabel" args))
(defn video-library [& args] (create-mui-icon "VideoLibrary" args))
(defn videocam [& args] (create-mui-icon "Videocam" args))
(defn videocam-off [& args] (create-mui-icon "VideocamOff" args))
(defn videogame-asset [& args] (create-mui-icon "VideogameAsset" args))
(defn view-agenda [& args] (create-mui-icon "ViewAgenda" args))
(defn view-array [& args] (create-mui-icon "ViewArray" args))
(defn view-carousel [& args] (create-mui-icon "ViewCarousel" args))
(defn view-column [& args] (create-mui-icon "ViewColumn" args))
(defn view-comfy [& args] (create-mui-icon "ViewComfy" args))
(defn view-compact [& args] (create-mui-icon "ViewCompact" args))
(defn view-day [& args] (create-mui-icon "ViewDay" args))
(defn view-headline [& args] (create-mui-icon "ViewHeadline" args))
(defn view-list [& args] (create-mui-icon "ViewList" args))
(defn view-module [& args] (create-mui-icon "ViewModule" args))
(defn view-quilt [& args] (create-mui-icon "ViewQuilt" args))
(defn view-stream [& args] (create-mui-icon "ViewStream" args))
(defn view-week [& args] (create-mui-icon "ViewWeek" args))
(defn vignette [& args] (create-mui-icon "Vignette" args))
(defn visibility [& args] (create-mui-icon "Visibility" args))
(defn visibility-off [& args] (create-mui-icon "VisibilityOff" args))
(defn voice-chat [& args] (create-mui-icon "VoiceChat" args))
(defn voicemail [& args] (create-mui-icon "Voicemail" args))
(defn volume-down [& args] (create-mui-icon "VolumeDown" args))
(defn volume-mute [& args] (create-mui-icon "VolumeMute" args))
(defn volume-off [& args] (create-mui-icon "VolumeOff" args))
(defn volume-up [& args] (create-mui-icon "VolumeUp" args))
(defn vpn-key [& args] (create-mui-icon "VpnKey" args))
(defn vpn-lock [& args] (create-mui-icon "VpnLock" args))
(defn wallpaper [& args] (create-mui-icon "Wallpaper" args))
(defn warning [& args] (create-mui-icon "Warning" args))
(defn watch [& args] (create-mui-icon "Watch" args))
(defn watch-later [& args] (create-mui-icon "WatchLater" args))
(defn wb-auto [& args] (create-mui-icon "WbAuto" args))
(defn wb-cloudy [& args] (create-mui-icon "WbCloudy" args))
(defn wb-incandescent [& args] (create-mui-icon "WbIncandescent" args))
(defn wb-iridescent [& args] (create-mui-icon "WbIridescent" args))
(defn wb-sunny [& args] (create-mui-icon "WbSunny" args))
(defn wc [& args] (create-mui-icon "Wc" args))
(defn web [& args] (create-mui-icon "Web" args))
(defn web-asset [& args] (create-mui-icon "WebAsset" args))
(defn weekend [& args] (create-mui-icon "Weekend" args))
(defn whatshot [& args] (create-mui-icon "Whatshot" args))
(defn widgets [& args] (create-mui-icon "Widgets" args))
(defn wifi [& args] (create-mui-icon "Wifi" args))
(defn wifi-lock [& args] (create-mui-icon "WifiLock" args))
(defn wifi-tethering [& args] (create-mui-icon "WifiTethering" args))
(defn work [& args] (create-mui-icon "Work" args))
(defn wrap-text [& args] (create-mui-icon "WrapText" args))
(defn youtube-searched-for [& args] (create-mui-icon "YoutubeSearchedFor" args))
(defn zoom-in [& args] (create-mui-icon "ZoomIn" args))
(defn zoom-out [& args] (create-mui-icon "ZoomOut" args))
(defn zoom-out-map [& args] (create-mui-icon "ZoomOutMap" args))
