
(ns ^{:author "Eduardo Julian",
      :doc "E-mail functionality."}
     eejp-web-dev0.external.email
  (:import org.apache.commons.mail.SimpleEmail))

(def ^:dynamic *sender-conf*
  {:from nil, :auth nil,
   :verif-email nil, :pass-change-email nil})

(defn configure-sender! [conf] (alter-var-root #'*sender-conf* merge conf))

(defn send-email [{:keys [to subject message]}]
  (let [{:keys [from auth]} *sender-conf*]
    (doto (SimpleEmail.)
      (.setHostName "smtp.gmail.com")
      (.setSslSmtpPort "465")
      (.setSSL true)
      (.addTo to)
      (.setFrom (first from) (second from))
      (.setSubject subject)
      (.setMsg message)
      (.setAuthentication (first auth) (second auth))
      (.send))))

(defn send-verification-email [to url]
  (send-email {:to to, :subject (first (:verif-email *sender-conf*)),
               :message ((second (:verif-email *sender-conf*)) url)}))

(defn send-password-change-email [to url]
  (send-email {:to to, :subject (first (:pass-change-email *sender-conf*)),
               :message ((second (:pass-change-email *sender-conf*)) url)}))

