
(ns ^{:author "Eduardo Julian",
      :doc "File handling."}
     eejp-web-dev0.files
  (:use clojure.template)
  (:require [clj-orient.core :as oc]
            [clj-orient.graph :as og]
            [eejp-web-dev0.core :as $]))

(def +FILE+ :File)
($/deffetch fetch-file +FILE+)

(defn create-file [filename ctype size data]
  (oc/save! (oc/document :File {:filename filename, :data (oc/record-bytes data), :content-type ctype, :size size})))

(defn set-user-img [user file]
  (if (oc/pget user :user-img) (oc/delete! (oc/pget user :user-img)))
  (oc/save! (oc/passoc! user :user-img file)))

(defn delete-user-img [user]
  (oc/delete! (oc/pget user :user-img))
  (oc/save! (oc/passoc! user :user-img nil)))
