
(ns ^{:author "Eduardo Julian",
      :doc "System task scheduling."}
     eejp-web-dev0.schedules
  (:import (java.util Timer TimerTask Date)))

; Constants
(def +hour+ (* 1000 60 60))

; Private State
(def ^:private schedules (atom {}))

; Utils
(defn timer-task [f]
  (proxy [java.util.TimerTask] []
    (run [] (f))))

(defn create-schedule! [kname f start period]
  (let [t (Timer. (name kname) true)]
    (swap! schedules assoc kname t)
    (.schedule t (timer-task f) start period)))

(defn cancel-schedule! [kname]
  (.cancel (@schedules kname))
  (swap! schedules dissoc kname))
