
(ns ^{:author "Eduardo Julian",
      :doc "Social network functionality."}
     eejp-web-dev0.social
  (:require [clj-orient.core :as oc]
            [clj-orient.graph :as og]
            [eejp-web-dev0.core :as $]
            [eejp-web-dev0.users :as $users]))

(def +FRIENDSHIP+ :is-friend)
(def +FOLLOWING+ :follows)

(defn befriend [user1 user2] (oc/save! (og/link! ($users/fetch-user user1) :is-friend {:date (java.util.Date.)} ($users/fetch-user user2))))
(defn unfriend [user1 user2] (oc/delete! (first (og/get-links ($users/fetch-user user1) ($users/fetch-user user2) :is-friend))))
(defn get-friends [user] (og/get-ends user :both :is-friend))
(defn follow [user target] (oc/save! (og/link! user :follows {:date (java.util.Date.)} target)))
(defn unfollow [user target]  (oc/delete! (first (og/get-links user target :follows))))
(defn friends? [user1 user2] (some #(= % user2) (og/get-ends user1 :both :is-friend)))

($/set-var-root! #'get-friends ($/paginate get-friends 10))
