
(ns ^{:author "Eduardo Julian",
      :doc "E-mail functionality."}
     eejp-web-dev0.external.email
  (:use clojure.template)
  (:import org.apache.commons.mail.SimpleEmail))

(def ^:dynamic *sender-conf*
  {:from nil, :auth nil,
   :verif-email nil, :pass-change-email nil})

(defn configure-sender! "Configuration keys:
{:from [\"E-mail\", \"Name\"], :auth [\"E-mail\", \"Password\"],
:verif-email <Function>, :pass-change-email <Function>}"
  [conf] (alter-var-root #'*sender-conf* merge conf))

(defn send-email "" [{:keys [to subject message]}]
  (let [{:keys [from auth]} *sender-conf*]
    (doto (SimpleEmail.)
      (.setHostName "smtp.gmail.com")
      (.setSslSmtpPort "465")
      (.setSSL true)
      (.addTo to)
      (.setFrom (first from) (second from))
      (.setSubject subject)
      (.setMsg message)
      (.setAuthentication (first auth) (second auth))
      (.send))))

(do-template [sym email-fn]
  (defn sym "" [to url]
    (send-email {:to to, :subject (first (*sender-conf* email-fn)),
                 :message ((second (*sender-conf* email-fn)) url)}))
  send-verification-email :verif-email,
  send-password-change-email :pass-change-email)
