
(ns ^{:author "Eduardo Julian",
      :doc "User feedback functionality."}
     eejp-web-dev0.feedback
  (:use clojure.template)
  (:require [clj-orient.core :as oc]
            [clj-orient.graph :as og]
            [clj-orient.query :as oq]
            [eejp-web-dev0.core :as $]))

(def +USER_FEEDBACK+ :UserFeedback)

; Types of user feedback.
(def ^{:doc "Available types of user feedback."}
      +feedback-types+ #{:question :copyright :request :comment :complaint})

(defn store-feedback "" [type user text] (oc/save! (oc/document :UserFeedback {:type type, :user user, :text text})))
(defn get-feedback ""
  ([type] (oq/sql-query "SELECT FROM UserFeedback WHERE type = :type" {:type type}))
  ([type user] (oq/sql-query "SELECT FROM UserFeedback WHERE type = :type & user"
                             {:type type, :orid (oc/get-id user)})))
