
(ns ^{:author "Eduardo Julian",
      :doc "Common remotes for usage by ClojureScript scripts."}
     eejp-web-dev0.remotes
  (:use noir.fetch.remotes)
  (:require [clj-orient.core :as oc]
            [clj-orient.query :as oq]
            [eejp-web-dev0.core :as $]))

(defmacro defremote+ [sym args & body] `(defremote ~sym ~args (oc/with-db ($/get-db) ~@body)))

(defn import-signup-checks! []
  (defremote+ username-taken? [uname] (boolean (first (oq/sql-query "SELECT FROM User WHERE username = ?" [uname]))))
  (defremote+ email-taken? [email] (boolean (first (oq/sql-query "SELECT FROM User WHERE email = ?" [email]))))
  )
