
(ns ^{:author "Eduardo Julian",
      :doc "Google Maps."}
     eejp-web-dev0.cljs.google-maps
  (:require [eejp-web-dev0.cljs.core :as $]))

; Basic geolocation.
(defn init-geo! "Initializes geo-location library." [] (geo_position_js/init))

(defn get-coords "Fetches the current user coordinates and passes them as a vector [lat lng] to the callback fn.
If it fails, invokes 'error' with the exception."
  [callback error]
  (geo_position_js/getCurrentPosition
    (fn [x] (callback [(.. x -coords -latitude), (.. x -coords -longitude)])) ; SUCCESS
    error ; ERROR
    (js* "{enableHighAccuracy: true}")))

; Google Maps specifics.
(defn lat-lng "Transforms a [lat lng] vector into a google.maps.LatLng object."
  [ll] (if (vector? ll) (google.maps.LatLng. (first ll) (second ll)) ll))

(defn init-map! "Initializes an HTML container to a Google map at the specified location (ll) and with the given zoom level."
  [container ll zoom] (google.maps.Map. container ($/map->jso {:center (lat-lng ll), :zoom zoom, :mapTypeId google.maps.MapTypeId.ROADMAP})))

(defn add-markers! "Adds markers to a map.
The markers must have this structure:
{:title \"string\",
:coords [lat lng],
:on-drag <fn to be called when dragging of a marker ends. Receives the marker as only arg.>}"
  [gmap & markers]
  (doseq [{:keys [coords title on-drag]} markers
          :let [mark (google.maps.Marker. ($/map->jso {:map gmap,
                                                       :title title,
                                                       :position (lat-lng coords),
                                                       :draggable (boolean on-drag)}))]]
    (do
      (if on-drag (google.maps.event/addListener mark "dragend" #(on-drag mark)))
      mark)))
