
(ns ^{:author "Eduardo Julian",
      :doc "Google maps widget and base data."}
     eejp-web-dev0.external.google-maps
  (:use hiccup.page-helpers)
  (:require [eejp-web-dev0.core :as $]))

(def ^:private +google-maps+ (str "<script src=\"http://maps.googleapis.com/maps/api/js?key=" ($/*system-conf* :google-api-key)
                                  "&sensor=false\" type=\"text/javascript\"></script >"))
(def ^:private +google-gears+ "http://code.google.com/apis/gears/gears_init.js")
(def ^:private +geo-gs+ (str ($/*system-conf* :home-url) "/static/js/geo.js"))
(def ^{:doc "JS dependencies needed to make Google Maps work."}
      +google-maps-deps+ (list +google-maps+ (include-js +google-gears+ +geo-gs+)))

(def ^{:doc "Standard Google Maps widget to be used."} +gmap-widget+ [:div#gmap])

(defn preset-map [lat lng editable?]
  (conj +gmap-widget+ {:_editable editable?}
        [:input#lat {:type :hidden, :name :lat, :value lat}]
        [:input#lng {:type :hidden, :name :lng, :value lng}]))
