
(ns ^{:author "Eduardo Julian",
      :doc "System data cleanup functionality."}
     eejp-web-dev0.cleanup
  (:require [clj-orient.core :as oc]
            [clj-orient.query :as oq]
            [eejp-web-dev0.core :as $]
            [eejp-web-dev0.schedules :as sched]))

; [Macros]
(defmacro delete-all! "Deletes all the documents returned by a SQL query."
  [query params] `(doseq [f# (oq/sql-query ~query ~params)] (oc/delete! f#)))

; [Resources]
(defn clean-late-unverified! "Cleans all unverified user accounts that are past their 1-month expiry date."
  []
  (delete-all! "SELECT FROM User WHERE verification-code IS NOT NULL AND joined-date < :limit"
               {:limit (java.util.Date. (- (.getTime (java.util.Date.)) (* 1000 60 60 24 30)))}))

(defn clean-deleted-messages! "Cleans all the messages deleted by both parties."
  [] (delete-all! "SELECT FROM messages WHERE delete = :type" {:type "both"}))

(defn start-cleanup-daemon!
  "Starts the cleanup daemon at the speficied time (expressed as miliseconds after the current time),
delays between sweeps by the specified ammount and runs the given no-arg cleanup functions."
  [fns start delay]
  (let [wrapper (fn [] (oc/with-db ($/get-db) (doseq [f fns] (f))))]
    (sched/create-schedule! :_cleanup wrapper start delay)))
