
(ns ^{:author "Eduardo Julian",
      :doc "DOM handling utils."}
     eejp-web-dev0.cljs.dom
  (:require [goog.dom :as gdom]
            [goog.string :as gstring])
  (:refer-clojure :exclude [assoc dissoc get contains? remove replace children]))

(defn- nl->ls "Transforms a NodeList to a LazySeq."
  [nl] (for [i (range (.-length nl))] (.item nl i)))

(defn by-id "" [id] (gdom/getElement id))
(defn by-class "" [class & [root]] (nl->ls (gdom/getElementsByClass class root)))
(defn by-tag-and-class "" [tag class & [root]] (nl->ls (gdom/getElementsByTagNameAndClass tag class root)))
(defn by-tag "" [tag & [root]] (nl->ls (gdom/getElementsByTagNameAndClass tag nil root)))

(defn query "" [sel & [root]]
  (cond
    (gstring/startsWith sel "#") (list (by-id sel))
    (gstring/startsWith sel ".") (by-class sel root)
    (not= -1 (.indexOf sel ".")) (let [idx (.indexOf sel ".")] (by-tag-and-class (.substring sel 0 idx) (.substring sel idx) root))
    :else (by-tag sel root)))

(defn append "" [node & subs] (apply gdom/append node subs))

(defn get-text "" [node & [else]]
  (or (gdom/getTextContent node)
      else))

(defn set-text "" [node text] (gdom/setTextContent node text))

(defn replace "" [newn oldn] (gdom/replaceNode newn oldn))

(defn remove "" [node] (gdom/removeNode node))
(defn remove-children "" [node] (gdom/removeChildren node))

(defn get-viewport-size "" [& [window]]
  (let [size (gdom/getViewportSize window)]
    [(.-width size) (.-height size)]))

(defn get "" [x k] (.getAttribute x (name k)))
(defn assoc ""
  [x k v & kvs]
  (.setAttribute x (name k) v)
  (apply assoc x kvs))
(defn dissoc "" [x k] (.removeAttribute x (name k)))
(defn contains? "" [x k] (.hasAttribute x (name k)))
(defn update "" [x k f & args] (assoc x k (apply f (get x k) args)))

(defn parent "" [x] (.-parentNode x))
(defn children "" [x] (nl->ls (.-childNodes x)))

(defn last-elem-child "" [x] (gdom/getLastElementChild x))
