
(ns eejp-web-dev0.cljs.voting
  (:require [eejp-web-dev0.cljs.core :as $]
            [eejp-web-dev0.cljs.dom :as $dom]
            [fetch.remotes :as remotes]
            [goog.events :as events]
            [cljs.reader :as reader])
  (:require-macros [fetch.macros :as fm]))

(defn vote [kcluss id up-or-down]
  (fm/remote (vote (@$/*globals* :user-id) (reader/read-string kcluss) (js/parseInt id) up-or-down) [voted?]
             nil))

(defn init-voting "Initilizes voting widgets."
  []
  (doseq [vs ($dom/by-class "votes")
          :let [uvb (first ($dom/by-class "up-vote-btn" vs))
                dvb (first ($dom/by-class "down-vote-btn" vs))]]
    (do
      (events/listen uvb (.-CLICK events/EventType) #(vote ($dom/get vs :_kcluss) ($dom/get vs :_id) true))
      (events/listen dvb (.-CLICK events/EventType) #(vote ($dom/get vs :_kcluss) ($dom/get vs :_id) false)))))
