
(ns ^{:author "Eduardo Julian",
      :doc "ReCaptcha utils."}
     eejp-web-dev0.external.recaptcha
  (:require [clj-http.client :as http]
            [eejp-web-dev0.core :as $]))

(def ^:private +verify-url+ "http://www.google.com/recaptcha/api/verify")
(def ^:private +challenge-url+ "http://www.google.com/recaptcha/api/challenge?k=")
(def ^:private +widget-url+ "http://www.google.com/recaptcha/api/noscript?k=")

(def ^{:doc "ReCaptcha widget to be used by HTML code."} +widget+
  [:div [:script {:type "text/javascript", :src (str +challenge-url+ ($/*system-conf* :recaptcha-public-key))}]
   [:noscript
    [:iframe {:src (str +widget-url+ ($/*system-conf* :recaptcha-public-key)),:height 300, :width 500, :frameborder 0}]
    [:textarea {:name "recaptcha_challenge_field", :rows 3, :cols 40}]
    [:input {:type :hidden, :name "recaptcha_response_field", :value "manual_challenge"}]]])

(defn verify-captcha "" [remote-ip challenge response]
  (let [x (http/post +verify-url+ {:form-params {:privatekey ($/*system-conf* :recaptcha-private-key), :remoteip remote-ip
                                                 :challenge challenge, :response response}})
        x (:body x)]
    (or (.startsWith x "true") (second (.split x "\n")))))
