if(typeof Math.imul == "undefined" || (Math.imul(0xffffffff,5) == 0)) {
    Math.imul = function (a, b) {
        var ah  = (a >>> 16) & 0xffff;
        var al = a & 0xffff;
        var bh  = (b >>> 16) & 0xffff;
        var bl = b & 0xffff;
        // the shift by 0 fixes the sign on the high part
        // the final |0 converts the unsigned value into a signed value
        return ((al * bl) + (((ah * bl + al * bh) << 16) >>> 0)|0);
    }
}


var CLOSURE_NO_DEPS = true;
var COMPILED = false;
var goog = goog || {};
goog.global = this;
goog.global.CLOSURE_UNCOMPILED_DEFINES;
goog.global.CLOSURE_DEFINES;
goog.isDef = function(val) {
  return val !== void 0;
};
goog.isString = function(val) {
  return typeof val == "string";
};
goog.isBoolean = function(val) {
  return typeof val == "boolean";
};
goog.isNumber = function(val) {
  return typeof val == "number";
};
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split(".");
  var cur = opt_objectToExportTo || goog.global;
  if (!(parts[0] in cur) && cur.execScript) {
    cur.execScript("var " + parts[0]);
  }
  for (var part; parts.length && (part = parts.shift());) {
    if (!parts.length && goog.isDef(opt_object)) {
      cur[part] = opt_object;
    } else {
      if (cur[part] && cur[part] !== Object.prototype[part]) {
        cur = cur[part];
      } else {
        cur = cur[part] = {};
      }
    }
  }
};
goog.define = function(name, defaultValue) {
  var value = defaultValue;
  if (!COMPILED) {
    if (goog.global.CLOSURE_UNCOMPILED_DEFINES && goog.global.CLOSURE_UNCOMPILED_DEFINES.nodeType === undefined && Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_UNCOMPILED_DEFINES, name)) {
      value = goog.global.CLOSURE_UNCOMPILED_DEFINES[name];
    } else {
      if (goog.global.CLOSURE_DEFINES && goog.global.CLOSURE_DEFINES.nodeType === undefined && Object.prototype.hasOwnProperty.call(goog.global.CLOSURE_DEFINES, name)) {
        value = goog.global.CLOSURE_DEFINES[name];
      }
    }
  }
  goog.exportPath_(name, value);
};
goog.define("goog.DEBUG", true);
goog.define("goog.LOCALE", "en");
goog.define("goog.TRUSTED_SITE", true);
goog.define("goog.STRICT_MODE_COMPATIBLE", false);
goog.define("goog.DISALLOW_TEST_ONLY_CODE", COMPILED && !goog.DEBUG);
goog.define("goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING", false);
goog.provide = function(name) {
  if (goog.isInModuleLoader_()) {
    throw Error("goog.provide can not be used within a goog.module.");
  }
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
  }
  goog.constructNamespace_(name);
};
goog.constructNamespace_ = function(name, opt_obj) {
  if (!COMPILED) {
    delete goog.implicitNamespaces_[name];
    var namespace = name;
    while (namespace = namespace.substring(0, namespace.lastIndexOf("."))) {
      if (goog.getObjectByName(namespace)) {
        break;
      }
      goog.implicitNamespaces_[namespace] = true;
    }
  }
  goog.exportPath_(name, opt_obj);
};
goog.VALID_MODULE_RE_ = /^[a-zA-Z_$][a-zA-Z0-9._$]*$/;
goog.module = function(name) {
  if (!goog.isString(name) || !name || name.search(goog.VALID_MODULE_RE_) == -1) {
    throw Error("Invalid module identifier");
  }
  if (!goog.isInModuleLoader_()) {
    throw Error("Module " + name + " has been loaded incorrectly. Note, " + "modules cannot be loaded as normal scripts. They require some kind of " + "pre-processing step. You're likely trying to load a module via a " + "script tag or as a part of a concatenated bundle without rewriting the " + "module. For more info see: " + "https://github.com/google/closure-library/wiki/goog.module:-an-ES6-module-like-alternative-to-goog.provide.");
  }
  if (goog.moduleLoaderState_.moduleName) {
    throw Error("goog.module may only be called once per module.");
  }
  goog.moduleLoaderState_.moduleName = name;
  if (!COMPILED) {
    if (goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
    delete goog.implicitNamespaces_[name];
  }
};
goog.module.get = function(name) {
  return goog.module.getInternal_(name);
};
goog.module.getInternal_ = function(name) {
  if (!COMPILED) {
    if (name in goog.loadedModules_) {
      return goog.loadedModules_[name];
    } else {
      if (!goog.implicitNamespaces_[name]) {
        var ns = goog.getObjectByName(name);
        return ns != null ? ns : null;
      }
    }
  }
  return null;
};
goog.moduleLoaderState_ = null;
goog.isInModuleLoader_ = function() {
  return goog.moduleLoaderState_ != null;
};
goog.module.declareLegacyNamespace = function() {
  if (!COMPILED && !goog.isInModuleLoader_()) {
    throw new Error("goog.module.declareLegacyNamespace must be called from " + "within a goog.module");
  }
  if (!COMPILED && !goog.moduleLoaderState_.moduleName) {
    throw Error("goog.module must be called prior to " + "goog.module.declareLegacyNamespace.");
  }
  goog.moduleLoaderState_.declareLegacyNamespace = true;
};
goog.setTestOnly = function(opt_message) {
  if (goog.DISALLOW_TEST_ONLY_CODE) {
    opt_message = opt_message || "";
    throw Error("Importing test-only code into non-debug environment" + (opt_message ? ": " + opt_message : "."));
  }
};
goog.forwardDeclare = function(name) {
};
goog.forwardDeclare("Document");
goog.forwardDeclare("HTMLScriptElement");
goog.forwardDeclare("XMLHttpRequest");
if (!COMPILED) {
  goog.isProvided_ = function(name) {
    return name in goog.loadedModules_ || !goog.implicitNamespaces_[name] && goog.isDefAndNotNull(goog.getObjectByName(name));
  };
  goog.implicitNamespaces_ = {"goog.module":true};
}
goog.getObjectByName = function(name, opt_obj) {
  var parts = name.split(".");
  var cur = opt_obj || goog.global;
  for (var part; part = parts.shift();) {
    if (goog.isDefAndNotNull(cur[part])) {
      cur = cur[part];
    } else {
      return null;
    }
  }
  return cur;
};
goog.globalize = function(obj, opt_global) {
  var global = opt_global || goog.global;
  for (var x in obj) {
    global[x] = obj[x];
  }
};
goog.addDependency = function(relPath, provides, requires, opt_loadFlags) {
  if (goog.DEPENDENCIES_ENABLED) {
    var provide, require;
    var path = relPath.replace(/\\/g, "/");
    var deps = goog.dependencies_;
    if (!opt_loadFlags || typeof opt_loadFlags === "boolean") {
      opt_loadFlags = opt_loadFlags ? {"module":"goog"} : {};
    }
    for (var i = 0; provide = provides[i]; i++) {
      deps.nameToPath[provide] = path;
      deps.loadFlags[path] = opt_loadFlags;
    }
    for (var j = 0; require = requires[j]; j++) {
      if (!(path in deps.requires)) {
        deps.requires[path] = {};
      }
      deps.requires[path][require] = true;
    }
  }
};
goog.define("goog.ENABLE_DEBUG_LOADER", true);
goog.logToConsole_ = function(msg) {
  if (goog.global.console) {
    goog.global.console["error"](msg);
  }
};
goog.require = function(name) {
  if (!COMPILED) {
    if (goog.ENABLE_DEBUG_LOADER && goog.IS_OLD_IE_) {
      goog.maybeProcessDeferredDep_(name);
    }
    if (goog.isProvided_(name)) {
      if (goog.isInModuleLoader_()) {
        return goog.module.getInternal_(name);
      }
    } else {
      if (goog.ENABLE_DEBUG_LOADER) {
        var path = goog.getPathFromDeps_(name);
        if (path) {
          goog.writeScripts_(path);
        } else {
          var errorMessage = "goog.require could not find: " + name;
          goog.logToConsole_(errorMessage);
          throw Error(errorMessage);
        }
      }
    }
    return null;
  }
};
goog.basePath = "";
goog.global.CLOSURE_BASE_PATH;
goog.global.CLOSURE_NO_DEPS;
goog.global.CLOSURE_IMPORT_SCRIPT;
goog.nullFunction = function() {
};
goog.abstractMethod = function() {
  throw Error("unimplemented abstract method");
};
goog.addSingletonGetter = function(ctor) {
  ctor.instance_ = undefined;
  ctor.getInstance = function() {
    if (ctor.instance_) {
      return ctor.instance_;
    }
    if (goog.DEBUG) {
      goog.instantiatedSingletons_[goog.instantiatedSingletons_.length] = ctor;
    }
    return ctor.instance_ = new ctor;
  };
};
goog.instantiatedSingletons_ = [];
goog.define("goog.LOAD_MODULE_USING_EVAL", true);
goog.define("goog.SEAL_MODULE_EXPORTS", goog.DEBUG);
goog.loadedModules_ = {};
goog.DEPENDENCIES_ENABLED = !COMPILED && goog.ENABLE_DEBUG_LOADER;
goog.define("goog.TRANSPILE", "detect");
goog.define("goog.TRANSPILER", "transpile.js");
if (goog.DEPENDENCIES_ENABLED) {
  goog.dependencies_ = {loadFlags:{}, nameToPath:{}, requires:{}, visited:{}, written:{}, deferred:{}};
  goog.inHtmlDocument_ = function() {
    var doc = goog.global.document;
    return doc != null && "write" in doc;
  };
  goog.findBasePath_ = function() {
    if (goog.isDef(goog.global.CLOSURE_BASE_PATH) && goog.isString(goog.global.CLOSURE_BASE_PATH)) {
      goog.basePath = goog.global.CLOSURE_BASE_PATH;
      return;
    } else {
      if (!goog.inHtmlDocument_()) {
        return;
      }
    }
    var doc = goog.global.document;
    var currentScript = doc.currentScript;
    if (currentScript) {
      var scripts = [currentScript];
    } else {
      var scripts = doc.getElementsByTagName("SCRIPT");
    }
    for (var i = scripts.length - 1; i >= 0; --i) {
      var script = scripts[i];
      var src = script.src;
      var qmark = src.lastIndexOf("?");
      var l = qmark == -1 ? src.length : qmark;
      if (src.substr(l - 7, 7) == "base.js") {
        goog.basePath = src.substr(0, l - 7);
        return;
      }
    }
  };
  goog.importScript_ = function(src, opt_sourceText) {
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    if (importScript(src, opt_sourceText)) {
      goog.dependencies_.written[src] = true;
    }
  };
  goog.IS_OLD_IE_ = !!(!goog.global.atob && goog.global.document && goog.global.document.all);
  goog.oldIeWaiting_ = false;
  goog.importProcessedScript_ = function(src, isModule, needsTranspile) {
    var bootstrap = 'goog.retrieveAndExec_("' + src + '", ' + isModule + ", " + needsTranspile + ");";
    goog.importScript_("", bootstrap);
  };
  goog.queuedModules_ = [];
  goog.wrapModule_ = function(srcUrl, scriptText) {
    if (!goog.LOAD_MODULE_USING_EVAL || !goog.isDef(goog.global.JSON)) {
      return "" + "goog.loadModule(function(exports) {" + '"use strict";' + scriptText + "\n" + ";return exports" + "});" + "\n//# sourceURL\x3d" + srcUrl + "\n";
    } else {
      return "" + "goog.loadModule(" + goog.global.JSON.stringify(scriptText + "\n//# sourceURL\x3d" + srcUrl + "\n") + ");";
    }
  };
  goog.loadQueuedModules_ = function() {
    var count = goog.queuedModules_.length;
    if (count > 0) {
      var queue = goog.queuedModules_;
      goog.queuedModules_ = [];
      for (var i = 0; i < count; i++) {
        var path = queue[i];
        goog.maybeProcessDeferredPath_(path);
      }
    }
    goog.oldIeWaiting_ = false;
  };
  goog.maybeProcessDeferredDep_ = function(name) {
    if (goog.isDeferredModule_(name) && goog.allDepsAreAvailable_(name)) {
      var path = goog.getPathFromDeps_(name);
      goog.maybeProcessDeferredPath_(goog.basePath + path);
    }
  };
  goog.isDeferredModule_ = function(name) {
    var path = goog.getPathFromDeps_(name);
    var loadFlags = path && goog.dependencies_.loadFlags[path] || {};
    var languageLevel = loadFlags["lang"] || "es3";
    if (path && (loadFlags["module"] == "goog" || goog.needsTranspile_(languageLevel))) {
      var abspath = goog.basePath + path;
      return abspath in goog.dependencies_.deferred;
    }
    return false;
  };
  goog.allDepsAreAvailable_ = function(name) {
    var path = goog.getPathFromDeps_(name);
    if (path && path in goog.dependencies_.requires) {
      for (var requireName in goog.dependencies_.requires[path]) {
        if (!goog.isProvided_(requireName) && !goog.isDeferredModule_(requireName)) {
          return false;
        }
      }
    }
    return true;
  };
  goog.maybeProcessDeferredPath_ = function(abspath) {
    if (abspath in goog.dependencies_.deferred) {
      var src = goog.dependencies_.deferred[abspath];
      delete goog.dependencies_.deferred[abspath];
      goog.globalEval(src);
    }
  };
  goog.loadModuleFromUrl = function(url) {
    goog.retrieveAndExec_(url, true, false);
  };
  goog.writeScriptSrcNode_ = function(src) {
    goog.global.document.write('\x3cscript type\x3d"text/javascript" src\x3d"' + src + '"\x3e\x3c/' + "script\x3e");
  };
  goog.appendScriptSrcNode_ = function(src) {
    var doc = goog.global.document;
    var scriptEl = doc.createElement("script");
    scriptEl.type = "text/javascript";
    scriptEl.src = src;
    scriptEl.defer = false;
    scriptEl.async = false;
    doc.head.appendChild(scriptEl);
  };
  goog.writeScriptTag_ = function(src, opt_sourceText) {
    if (goog.inHtmlDocument_()) {
      var doc = goog.global.document;
      if (!goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING && doc.readyState == "complete") {
        var isDeps = /\bdeps.js$/.test(src);
        if (isDeps) {
          return false;
        } else {
          throw Error('Cannot write "' + src + '" after document load');
        }
      }
      if (opt_sourceText === undefined) {
        if (!goog.IS_OLD_IE_) {
          if (goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING) {
            goog.appendScriptSrcNode_(src);
          } else {
            goog.writeScriptSrcNode_(src);
          }
        } else {
          goog.oldIeWaiting_ = true;
          var state = " onreadystatechange\x3d'goog.onScriptLoad_(this, " + ++goog.lastNonModuleScriptIndex_ + ")' ";
          doc.write('\x3cscript type\x3d"text/javascript" src\x3d"' + src + '"' + state + "\x3e\x3c/" + "script\x3e");
        }
      } else {
        doc.write('\x3cscript type\x3d"text/javascript"\x3e' + goog.protectScriptTag_(opt_sourceText) + "\x3c/" + "script\x3e");
      }
      return true;
    } else {
      return false;
    }
  };
  goog.protectScriptTag_ = function(str) {
    return str.replace(/<\/(SCRIPT)/ig, "\\x3c/$1");
  };
  goog.needsTranspile_ = function(lang) {
    if (goog.TRANSPILE == "always") {
      return true;
    } else {
      if (goog.TRANSPILE == "never") {
        return false;
      } else {
        if (!goog.requiresTranspilation_) {
          goog.requiresTranspilation_ = goog.createRequiresTranspilation_();
        }
      }
    }
    if (lang in goog.requiresTranspilation_) {
      return goog.requiresTranspilation_[lang];
    } else {
      throw new Error("Unknown language mode: " + lang);
    }
  };
  goog.requiresTranspilation_ = null;
  goog.lastNonModuleScriptIndex_ = 0;
  goog.onScriptLoad_ = function(script, scriptIndex) {
    if (script.readyState == "complete" && goog.lastNonModuleScriptIndex_ == scriptIndex) {
      goog.loadQueuedModules_();
    }
    return true;
  };
  goog.writeScripts_ = function(pathToLoad) {
    var scripts = [];
    var seenScript = {};
    var deps = goog.dependencies_;
    function visitNode(path) {
      if (path in deps.written) {
        return;
      }
      if (path in deps.visited) {
        return;
      }
      deps.visited[path] = true;
      if (path in deps.requires) {
        for (var requireName in deps.requires[path]) {
          if (!goog.isProvided_(requireName)) {
            if (requireName in deps.nameToPath) {
              visitNode(deps.nameToPath[requireName]);
            } else {
              throw Error("Undefined nameToPath for " + requireName);
            }
          }
        }
      }
      if (!(path in seenScript)) {
        seenScript[path] = true;
        scripts.push(path);
      }
    }
    visitNode(pathToLoad);
    for (var i = 0; i < scripts.length; i++) {
      var path = scripts[i];
      goog.dependencies_.written[path] = true;
    }
    var moduleState = goog.moduleLoaderState_;
    goog.moduleLoaderState_ = null;
    for (var i = 0; i < scripts.length; i++) {
      var path = scripts[i];
      if (path) {
        var loadFlags = deps.loadFlags[path] || {};
        var languageLevel = loadFlags["lang"] || "es3";
        var needsTranspile = goog.needsTranspile_(languageLevel);
        if (loadFlags["module"] == "goog" || needsTranspile) {
          goog.importProcessedScript_(goog.basePath + path, loadFlags["module"] == "goog", needsTranspile);
        } else {
          goog.importScript_(goog.basePath + path);
        }
      } else {
        goog.moduleLoaderState_ = moduleState;
        throw Error("Undefined script input");
      }
    }
    goog.moduleLoaderState_ = moduleState;
  };
  goog.getPathFromDeps_ = function(rule) {
    if (rule in goog.dependencies_.nameToPath) {
      return goog.dependencies_.nameToPath[rule];
    } else {
      return null;
    }
  };
  goog.findBasePath_();
  if (!goog.global.CLOSURE_NO_DEPS) {
    goog.importScript_(goog.basePath + "deps.js");
  }
}
goog.hasBadLetScoping = null;
goog.useSafari10Workaround = function() {
  if (goog.hasBadLetScoping == null) {
    var hasBadLetScoping;
    try {
      hasBadLetScoping = !eval('"use strict";' + "let x \x3d 1; function f() { return typeof x; };" + 'f() \x3d\x3d "number";');
    } catch (e) {
      hasBadLetScoping = false;
    }
    goog.hasBadLetScoping = hasBadLetScoping;
  }
  return goog.hasBadLetScoping;
};
goog.workaroundSafari10EvalBug = function(moduleDef) {
  return "(function(){" + moduleDef + "\n" + ";" + "})();\n";
};
goog.loadModule = function(moduleDef) {
  var previousState = goog.moduleLoaderState_;
  try {
    goog.moduleLoaderState_ = {moduleName:undefined, declareLegacyNamespace:false};
    var exports;
    if (goog.isFunction(moduleDef)) {
      exports = moduleDef.call(undefined, {});
    } else {
      if (goog.isString(moduleDef)) {
        if (goog.useSafari10Workaround()) {
          moduleDef = goog.workaroundSafari10EvalBug(moduleDef);
        }
        exports = goog.loadModuleFromSource_.call(undefined, moduleDef);
      } else {
        throw Error("Invalid module definition");
      }
    }
    var moduleName = goog.moduleLoaderState_.moduleName;
    if (!goog.isString(moduleName) || !moduleName) {
      throw Error('Invalid module name "' + moduleName + '"');
    }
    if (goog.moduleLoaderState_.declareLegacyNamespace) {
      goog.constructNamespace_(moduleName, exports);
    } else {
      if (goog.SEAL_MODULE_EXPORTS && Object.seal && typeof exports == "object" && exports != null) {
        Object.seal(exports);
      }
    }
    goog.loadedModules_[moduleName] = exports;
  } finally {
    goog.moduleLoaderState_ = previousState;
  }
};
goog.loadModuleFromSource_ = function() {
  var exports = {};
  eval(arguments[0]);
  return exports;
};
goog.normalizePath_ = function(path) {
  var components = path.split("/");
  var i = 0;
  while (i < components.length) {
    if (components[i] == ".") {
      components.splice(i, 1);
    } else {
      if (i && components[i] == ".." && components[i - 1] && components[i - 1] != "..") {
        components.splice(--i, 2);
      } else {
        i++;
      }
    }
  }
  return components.join("/");
};
goog.global.CLOSURE_LOAD_FILE_SYNC;
goog.loadFileSync_ = function(src) {
  if (goog.global.CLOSURE_LOAD_FILE_SYNC) {
    return goog.global.CLOSURE_LOAD_FILE_SYNC(src);
  } else {
    try {
      var xhr = new goog.global["XMLHttpRequest"];
      xhr.open("get", src, false);
      xhr.send();
      return xhr.status == 0 || xhr.status == 200 ? xhr.responseText : null;
    } catch (err) {
      return null;
    }
  }
};
goog.retrieveAndExec_ = function(src, isModule, needsTranspile) {
  if (!COMPILED) {
    var originalPath = src;
    src = goog.normalizePath_(src);
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    var scriptText = goog.loadFileSync_(src);
    if (scriptText == null) {
      throw new Error('Load of "' + src + '" failed');
    }
    if (needsTranspile) {
      scriptText = goog.transpile_.call(goog.global, scriptText, src);
    }
    if (isModule) {
      scriptText = goog.wrapModule_(src, scriptText);
    } else {
      scriptText += "\n//# sourceURL\x3d" + src;
    }
    var isOldIE = goog.IS_OLD_IE_;
    if (isOldIE && goog.oldIeWaiting_) {
      goog.dependencies_.deferred[originalPath] = scriptText;
      goog.queuedModules_.push(originalPath);
    } else {
      importScript(src, scriptText);
    }
  }
};
goog.transpile_ = function(code, path) {
  var jscomp = goog.global["$jscomp"];
  if (!jscomp) {
    goog.global["$jscomp"] = jscomp = {};
  }
  var transpile = jscomp.transpile;
  if (!transpile) {
    var transpilerPath = goog.basePath + goog.TRANSPILER;
    var transpilerCode = goog.loadFileSync_(transpilerPath);
    if (transpilerCode) {
      eval(transpilerCode + "\n//# sourceURL\x3d" + transpilerPath);
      if (goog.global["$gwtExport"] && goog.global["$gwtExport"]["$jscomp"] && !goog.global["$gwtExport"]["$jscomp"]["transpile"]) {
        throw new Error('The transpiler did not properly export the "transpile" ' + "method. $gwtExport: " + JSON.stringify(goog.global["$gwtExport"]));
      }
      goog.global["$jscomp"].transpile = goog.global["$gwtExport"]["$jscomp"]["transpile"];
      jscomp = goog.global["$jscomp"];
      transpile = jscomp.transpile;
    }
  }
  if (!transpile) {
    var suffix = " requires transpilation but no transpiler was found.";
    transpile = jscomp.transpile = function(code, path) {
      goog.logToConsole_(path + suffix);
      return code;
    };
  }
  return transpile(code, path);
};
goog.typeOf = function(value) {
  var s = typeof value;
  if (s == "object") {
    if (value) {
      if (value instanceof Array) {
        return "array";
      } else {
        if (value instanceof Object) {
          return s;
        }
      }
      var className = Object.prototype.toString.call(value);
      if (className == "[object Window]") {
        return "object";
      }
      if (className == "[object Array]" || typeof value.length == "number" && typeof value.splice != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("splice")) {
        return "array";
      }
      if (className == "[object Function]" || typeof value.call != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("call")) {
        return "function";
      }
    } else {
      return "null";
    }
  } else {
    if (s == "function" && typeof value.call == "undefined") {
      return "object";
    }
  }
  return s;
};
goog.isNull = function(val) {
  return val === null;
};
goog.isDefAndNotNull = function(val) {
  return val != null;
};
goog.isArray = function(val) {
  return goog.typeOf(val) == "array";
};
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  return type == "array" || type == "object" && typeof val.length == "number";
};
goog.isDateLike = function(val) {
  return goog.isObject(val) && typeof val.getFullYear == "function";
};
goog.isFunction = function(val) {
  return goog.typeOf(val) == "function";
};
goog.isObject = function(val) {
  var type = typeof val;
  return type == "object" && val != null || type == "function";
};
goog.getUid = function(obj) {
  return obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_);
};
goog.hasUid = function(obj) {
  return !!obj[goog.UID_PROPERTY_];
};
goog.removeUid = function(obj) {
  if (obj !== null && "removeAttribute" in obj) {
    obj.removeAttribute(goog.UID_PROPERTY_);
  }
  try {
    delete obj[goog.UID_PROPERTY_];
  } catch (ex) {
  }
};
goog.UID_PROPERTY_ = "closure_uid_" + (Math.random() * 1e9 >>> 0);
goog.uidCounter_ = 0;
goog.getHashCode = goog.getUid;
goog.removeHashCode = goog.removeUid;
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if (type == "object" || type == "array") {
    if (obj.clone) {
      return obj.clone();
    }
    var clone = type == "array" ? [] : {};
    for (var key in obj) {
      clone[key] = goog.cloneObject(obj[key]);
    }
    return clone;
  }
  return obj;
};
goog.bindNative_ = function(fn, selfObj, var_args) {
  return fn.call.apply(fn.bind, arguments);
};
goog.bindJs_ = function(fn, selfObj, var_args) {
  if (!fn) {
    throw new Error;
  }
  if (arguments.length > 2) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(selfObj, newArgs);
    };
  } else {
    return function() {
      return fn.apply(selfObj, arguments);
    };
  }
};
goog.bind = function(fn, selfObj, var_args) {
  if (Function.prototype.bind && Function.prototype.bind.toString().indexOf("native code") != -1) {
    goog.bind = goog.bindNative_;
  } else {
    goog.bind = goog.bindJs_;
  }
  return goog.bind.apply(null, arguments);
};
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = args.slice();
    newArgs.push.apply(newArgs, arguments);
    return fn.apply(this, newArgs);
  };
};
goog.mixin = function(target, source) {
  for (var x in source) {
    target[x] = source[x];
  }
};
goog.now = goog.TRUSTED_SITE && Date.now || function() {
  return +new Date;
};
goog.globalEval = function(script) {
  if (goog.global.execScript) {
    goog.global.execScript(script, "JavaScript");
  } else {
    if (goog.global.eval) {
      if (goog.evalWorksForGlobals_ == null) {
        goog.global.eval("var _evalTest_ \x3d 1;");
        if (typeof goog.global["_evalTest_"] != "undefined") {
          try {
            delete goog.global["_evalTest_"];
          } catch (ignore) {
          }
          goog.evalWorksForGlobals_ = true;
        } else {
          goog.evalWorksForGlobals_ = false;
        }
      }
      if (goog.evalWorksForGlobals_) {
        goog.global.eval(script);
      } else {
        var doc = goog.global.document;
        var scriptElt = doc.createElement("SCRIPT");
        scriptElt.type = "text/javascript";
        scriptElt.defer = false;
        scriptElt.appendChild(doc.createTextNode(script));
        doc.body.appendChild(scriptElt);
        doc.body.removeChild(scriptElt);
      }
    } else {
      throw Error("goog.globalEval not available");
    }
  }
};
goog.evalWorksForGlobals_ = null;
goog.cssNameMapping_;
goog.cssNameMappingStyle_;
goog.global.CLOSURE_CSS_NAME_MAP_FN;
goog.getCssName = function(className, opt_modifier) {
  if (String(className).charAt(0) == ".") {
    throw new Error('className passed in goog.getCssName must not start with ".".' + " You passed: " + className);
  }
  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName;
  };
  var renameByParts = function(cssName) {
    var parts = cssName.split("-");
    var mapped = [];
    for (var i = 0; i < parts.length; i++) {
      mapped.push(getMapping(parts[i]));
    }
    return mapped.join("-");
  };
  var rename;
  if (goog.cssNameMapping_) {
    rename = goog.cssNameMappingStyle_ == "BY_WHOLE" ? getMapping : renameByParts;
  } else {
    rename = function(a) {
      return a;
    };
  }
  var result = opt_modifier ? className + "-" + rename(opt_modifier) : rename(className);
  if (goog.global.CLOSURE_CSS_NAME_MAP_FN) {
    return goog.global.CLOSURE_CSS_NAME_MAP_FN(result);
  }
  return result;
};
goog.setCssNameMapping = function(mapping, opt_style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = opt_style;
};
goog.global.CLOSURE_CSS_NAME_MAPPING;
if (!COMPILED && goog.global.CLOSURE_CSS_NAME_MAPPING) {
  goog.cssNameMapping_ = goog.global.CLOSURE_CSS_NAME_MAPPING;
}
goog.getMsg = function(str, opt_values) {
  if (opt_values) {
    str = str.replace(/\{\$([^}]+)}/g, function(match, key) {
      return opt_values != null && key in opt_values ? opt_values[key] : match;
    });
  }
  return str;
};
goog.getMsgWithFallback = function(a, b) {
  return a;
};
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo);
};
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol;
};
goog.inherits = function(childCtor, parentCtor) {
  function tempCtor() {
  }
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor;
  childCtor.prototype.constructor = childCtor;
  childCtor.base = function(me, methodName, var_args) {
    var args = new Array(arguments.length - 2);
    for (var i = 2; i < arguments.length; i++) {
      args[i - 2] = arguments[i];
    }
    return parentCtor.prototype[methodName].apply(me, args);
  };
};
goog.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;
  if (goog.STRICT_MODE_COMPATIBLE || goog.DEBUG && !caller) {
    throw Error("arguments.caller not defined.  goog.base() cannot be used " + "with strict mode code. See " + "http://www.ecma-international.org/ecma-262/5.1/#sec-C");
  }
  if (caller.superClass_) {
    var ctorArgs = new Array(arguments.length - 1);
    for (var i = 1; i < arguments.length; i++) {
      ctorArgs[i - 1] = arguments[i];
    }
    return caller.superClass_.constructor.apply(me, ctorArgs);
  }
  var args = new Array(arguments.length - 2);
  for (var i = 2; i < arguments.length; i++) {
    args[i - 2] = arguments[i];
  }
  var foundCaller = false;
  for (var ctor = me.constructor; ctor; ctor = ctor.superClass_ && ctor.superClass_.constructor) {
    if (ctor.prototype[opt_methodName] === caller) {
      foundCaller = true;
    } else {
      if (foundCaller) {
        return ctor.prototype[opt_methodName].apply(me, args);
      }
    }
  }
  if (me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args);
  } else {
    throw Error("goog.base called from a method of one name " + "to a method of a different name");
  }
};
goog.scope = function(fn) {
  if (goog.isInModuleLoader_()) {
    throw Error("goog.scope is not supported within a goog.module.");
  }
  fn.call(goog.global);
};
if (!COMPILED) {
  goog.global["COMPILED"] = COMPILED;
}
goog.defineClass = function(superClass, def) {
  var constructor = def.constructor;
  var statics = def.statics;
  if (!constructor || constructor == Object.prototype.constructor) {
    constructor = function() {
      throw Error("cannot instantiate an interface (no constructor defined).");
    };
  }
  var cls = goog.defineClass.createSealingConstructor_(constructor, superClass);
  if (superClass) {
    goog.inherits(cls, superClass);
  }
  delete def.constructor;
  delete def.statics;
  goog.defineClass.applyProperties_(cls.prototype, def);
  if (statics != null) {
    if (statics instanceof Function) {
      statics(cls);
    } else {
      goog.defineClass.applyProperties_(cls, statics);
    }
  }
  return cls;
};
goog.defineClass.ClassDescriptor;
goog.define("goog.defineClass.SEAL_CLASS_INSTANCES", goog.DEBUG);
goog.defineClass.createSealingConstructor_ = function(ctr, superClass) {
  if (!goog.defineClass.SEAL_CLASS_INSTANCES) {
    return ctr;
  }
  var superclassSealable = !goog.defineClass.isUnsealable_(superClass);
  var wrappedCtr = function() {
    var instance = ctr.apply(this, arguments) || this;
    instance[goog.UID_PROPERTY_] = instance[goog.UID_PROPERTY_];
    if (this.constructor === wrappedCtr && superclassSealable && Object.seal instanceof Function) {
      Object.seal(instance);
    }
    return instance;
  };
  return wrappedCtr;
};
goog.defineClass.isUnsealable_ = function(ctr) {
  return ctr && ctr.prototype && ctr.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_];
};
goog.defineClass.OBJECT_PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.defineClass.applyProperties_ = function(target, source) {
  var key;
  for (key in source) {
    if (Object.prototype.hasOwnProperty.call(source, key)) {
      target[key] = source[key];
    }
  }
  for (var i = 0; i < goog.defineClass.OBJECT_PROTOTYPE_FIELDS_.length; i++) {
    key = goog.defineClass.OBJECT_PROTOTYPE_FIELDS_[i];
    if (Object.prototype.hasOwnProperty.call(source, key)) {
      target[key] = source[key];
    }
  }
};
goog.tagUnsealableClass = function(ctr) {
  if (!COMPILED && goog.defineClass.SEAL_CLASS_INSTANCES) {
    ctr.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_] = true;
  }
};
goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_ = "goog_defineClass_legacy_unsealable";
goog.createRequiresTranspilation_ = function() {
  var requiresTranspilation = {"es3":false};
  var transpilationRequiredForAllLaterModes = false;
  function addNewerLanguageTranspilationCheck(modeName, isSupported) {
    if (transpilationRequiredForAllLaterModes) {
      requiresTranspilation[modeName] = true;
    } else {
      if (isSupported()) {
        requiresTranspilation[modeName] = false;
      } else {
        requiresTranspilation[modeName] = true;
        transpilationRequiredForAllLaterModes = true;
      }
    }
  }
  function evalCheck(code) {
    try {
      return !!eval(code);
    } catch (ignored) {
      return false;
    }
  }
  var userAgent = goog.global.navigator && goog.global.navigator.userAgent ? goog.global.navigator.userAgent : "";
  addNewerLanguageTranspilationCheck("es5", function() {
    return evalCheck("[1,].length\x3d\x3d1");
  });
  addNewerLanguageTranspilationCheck("es6", function() {
    var re = /Edge\/(\d+)(\.\d)*/i;
    var edgeUserAgent = userAgent.match(re);
    if (edgeUserAgent && Number(edgeUserAgent[1]) < 15) {
      return false;
    }
    var es6fullTest = "class X{constructor(){if(new.target!\x3dString)throw 1;this.x\x3d42}}" + "let q\x3dReflect.construct(X,[],String);if(q.x!\x3d42||!(q instanceof " + "String))throw 1;for(const a of[2,3]){if(a\x3d\x3d2)continue;function " + "f(z\x3d{a}){let a\x3d0;return z.a}{function f(){return 0;}}return f()" + "\x3d\x3d3}";
    return evalCheck('(()\x3d\x3e{"use strict";' + es6fullTest + "})()");
  });
  addNewerLanguageTranspilationCheck("es6-impl", function() {
    return true;
  });
  addNewerLanguageTranspilationCheck("es7", function() {
    return evalCheck("2 ** 2 \x3d\x3d 4");
  });
  addNewerLanguageTranspilationCheck("es8", function() {
    return evalCheck("async () \x3d\x3e 1, true");
  });
  return requiresTranspilation;
};
goog.provide("goog.string");
goog.provide("goog.string.Unicode");
goog.define("goog.string.DETECT_DOUBLE_ESCAPING", false);
goog.define("goog.string.FORCE_NON_DOM_HTML_UNESCAPING", false);
goog.string.Unicode = {NBSP:" "};
goog.string.startsWith = function(str, prefix) {
  return str.lastIndexOf(prefix, 0) == 0;
};
goog.string.endsWith = function(str, suffix) {
  var l = str.length - suffix.length;
  return l >= 0 && str.indexOf(suffix, l) == l;
};
goog.string.caseInsensitiveStartsWith = function(str, prefix) {
  return goog.string.caseInsensitiveCompare(prefix, str.substr(0, prefix.length)) == 0;
};
goog.string.caseInsensitiveEndsWith = function(str, suffix) {
  return goog.string.caseInsensitiveCompare(suffix, str.substr(str.length - suffix.length, suffix.length)) == 0;
};
goog.string.caseInsensitiveEquals = function(str1, str2) {
  return str1.toLowerCase() == str2.toLowerCase();
};
goog.string.subs = function(str, var_args) {
  var splitParts = str.split("%s");
  var returnString = "";
  var subsArguments = Array.prototype.slice.call(arguments, 1);
  while (subsArguments.length && splitParts.length > 1) {
    returnString += splitParts.shift() + subsArguments.shift();
  }
  return returnString + splitParts.join("%s");
};
goog.string.collapseWhitespace = function(str) {
  return str.replace(/[\s\xa0]+/g, " ").replace(/^\s+|\s+$/g, "");
};
goog.string.isEmptyOrWhitespace = function(str) {
  return /^[\s\xa0]*$/.test(str);
};
goog.string.isEmptyString = function(str) {
  return str.length == 0;
};
goog.string.isEmpty = goog.string.isEmptyOrWhitespace;
goog.string.isEmptyOrWhitespaceSafe = function(str) {
  return goog.string.isEmptyOrWhitespace(goog.string.makeSafe(str));
};
goog.string.isEmptySafe = goog.string.isEmptyOrWhitespaceSafe;
goog.string.isBreakingWhitespace = function(str) {
  return !/[^\t\n\r ]/.test(str);
};
goog.string.isAlpha = function(str) {
  return !/[^a-zA-Z]/.test(str);
};
goog.string.isNumeric = function(str) {
  return !/[^0-9]/.test(str);
};
goog.string.isAlphaNumeric = function(str) {
  return !/[^a-zA-Z0-9]/.test(str);
};
goog.string.isSpace = function(ch) {
  return ch == " ";
};
goog.string.isUnicodeChar = function(ch) {
  return ch.length == 1 && ch >= " " && ch <= "~" || ch >= "" && ch <= "�";
};
goog.string.stripNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)+/g, " ");
};
goog.string.canonicalizeNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)/g, "\n");
};
goog.string.normalizeWhitespace = function(str) {
  return str.replace(/\xa0|\s/g, " ");
};
goog.string.normalizeSpaces = function(str) {
  return str.replace(/\xa0|[ \t]+/g, " ");
};
goog.string.collapseBreakingSpaces = function(str) {
  return str.replace(/[\t\r\n ]+/g, " ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g, "");
};
goog.string.trim = goog.TRUSTED_SITE && String.prototype.trim ? function(str) {
  return str.trim();
} : function(str) {
  return str.replace(/^[\s\xa0]+|[\s\xa0]+$/g, "");
};
goog.string.trimLeft = function(str) {
  return str.replace(/^[\s\xa0]+/, "");
};
goog.string.trimRight = function(str) {
  return str.replace(/[\s\xa0]+$/, "");
};
goog.string.caseInsensitiveCompare = function(str1, str2) {
  var test1 = String(str1).toLowerCase();
  var test2 = String(str2).toLowerCase();
  if (test1 < test2) {
    return -1;
  } else {
    if (test1 == test2) {
      return 0;
    } else {
      return 1;
    }
  }
};
goog.string.numberAwareCompare_ = function(str1, str2, tokenizerRegExp) {
  if (str1 == str2) {
    return 0;
  }
  if (!str1) {
    return -1;
  }
  if (!str2) {
    return 1;
  }
  var tokens1 = str1.toLowerCase().match(tokenizerRegExp);
  var tokens2 = str2.toLowerCase().match(tokenizerRegExp);
  var count = Math.min(tokens1.length, tokens2.length);
  for (var i = 0; i < count; i++) {
    var a = tokens1[i];
    var b = tokens2[i];
    if (a != b) {
      var num1 = parseInt(a, 10);
      if (!isNaN(num1)) {
        var num2 = parseInt(b, 10);
        if (!isNaN(num2) && num1 - num2) {
          return num1 - num2;
        }
      }
      return a < b ? -1 : 1;
    }
  }
  if (tokens1.length != tokens2.length) {
    return tokens1.length - tokens2.length;
  }
  return str1 < str2 ? -1 : 1;
};
goog.string.intAwareCompare = function(str1, str2) {
  return goog.string.numberAwareCompare_(str1, str2, /\d+|\D+/g);
};
goog.string.floatAwareCompare = function(str1, str2) {
  return goog.string.numberAwareCompare_(str1, str2, /\d+|\.\d+|\D+/g);
};
goog.string.numerateCompare = goog.string.floatAwareCompare;
goog.string.urlEncode = function(str) {
  return encodeURIComponent(String(str));
};
goog.string.urlDecode = function(str) {
  return decodeURIComponent(str.replace(/\+/g, " "));
};
goog.string.newLineToBr = function(str, opt_xml) {
  return str.replace(/(\r\n|\r|\n)/g, opt_xml ? "\x3cbr /\x3e" : "\x3cbr\x3e");
};
goog.string.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {
  if (opt_isLikelyToContainHtmlChars) {
    str = str.replace(goog.string.AMP_RE_, "\x26amp;").replace(goog.string.LT_RE_, "\x26lt;").replace(goog.string.GT_RE_, "\x26gt;").replace(goog.string.QUOT_RE_, "\x26quot;").replace(goog.string.SINGLE_QUOTE_RE_, "\x26#39;").replace(goog.string.NULL_RE_, "\x26#0;");
    if (goog.string.DETECT_DOUBLE_ESCAPING) {
      str = str.replace(goog.string.E_RE_, "\x26#101;");
    }
    return str;
  } else {
    if (!goog.string.ALL_RE_.test(str)) {
      return str;
    }
    if (str.indexOf("\x26") != -1) {
      str = str.replace(goog.string.AMP_RE_, "\x26amp;");
    }
    if (str.indexOf("\x3c") != -1) {
      str = str.replace(goog.string.LT_RE_, "\x26lt;");
    }
    if (str.indexOf("\x3e") != -1) {
      str = str.replace(goog.string.GT_RE_, "\x26gt;");
    }
    if (str.indexOf('"') != -1) {
      str = str.replace(goog.string.QUOT_RE_, "\x26quot;");
    }
    if (str.indexOf("'") != -1) {
      str = str.replace(goog.string.SINGLE_QUOTE_RE_, "\x26#39;");
    }
    if (str.indexOf("\x00") != -1) {
      str = str.replace(goog.string.NULL_RE_, "\x26#0;");
    }
    if (goog.string.DETECT_DOUBLE_ESCAPING && str.indexOf("e") != -1) {
      str = str.replace(goog.string.E_RE_, "\x26#101;");
    }
    return str;
  }
};
goog.string.AMP_RE_ = /&/g;
goog.string.LT_RE_ = /</g;
goog.string.GT_RE_ = />/g;
goog.string.QUOT_RE_ = /"/g;
goog.string.SINGLE_QUOTE_RE_ = /'/g;
goog.string.NULL_RE_ = /\x00/g;
goog.string.E_RE_ = /e/g;
goog.string.ALL_RE_ = goog.string.DETECT_DOUBLE_ESCAPING ? /[\x00&<>"'e]/ : /[\x00&<>"']/;
goog.string.unescapeEntities = function(str) {
  if (goog.string.contains(str, "\x26")) {
    if (!goog.string.FORCE_NON_DOM_HTML_UNESCAPING && "document" in goog.global) {
      return goog.string.unescapeEntitiesUsingDom_(str);
    } else {
      return goog.string.unescapePureXmlEntities_(str);
    }
  }
  return str;
};
goog.string.unescapeEntitiesWithDocument = function(str, document) {
  if (goog.string.contains(str, "\x26")) {
    return goog.string.unescapeEntitiesUsingDom_(str, document);
  }
  return str;
};
goog.string.unescapeEntitiesUsingDom_ = function(str, opt_document) {
  var seen = {"\x26amp;":"\x26", "\x26lt;":"\x3c", "\x26gt;":"\x3e", "\x26quot;":'"'};
  var div;
  if (opt_document) {
    div = opt_document.createElement("div");
  } else {
    div = goog.global.document.createElement("div");
  }
  return str.replace(goog.string.HTML_ENTITY_PATTERN_, function(s, entity) {
    var value = seen[s];
    if (value) {
      return value;
    }
    if (entity.charAt(0) == "#") {
      var n = Number("0" + entity.substr(1));
      if (!isNaN(n)) {
        value = String.fromCharCode(n);
      }
    }
    if (!value) {
      div.innerHTML = s + " ";
      value = div.firstChild.nodeValue.slice(0, -1);
    }
    return seen[s] = value;
  });
};
goog.string.unescapePureXmlEntities_ = function(str) {
  return str.replace(/&([^;]+);/g, function(s, entity) {
    switch(entity) {
      case "amp":
        return "\x26";
      case "lt":
        return "\x3c";
      case "gt":
        return "\x3e";
      case "quot":
        return '"';
      default:
        if (entity.charAt(0) == "#") {
          var n = Number("0" + entity.substr(1));
          if (!isNaN(n)) {
            return String.fromCharCode(n);
          }
        }
        return s;
    }
  });
};
goog.string.HTML_ENTITY_PATTERN_ = /&([^;\s<&]+);?/g;
goog.string.whitespaceEscape = function(str, opt_xml) {
  return goog.string.newLineToBr(str.replace(/  /g, " \x26#160;"), opt_xml);
};
goog.string.preserveSpaces = function(str) {
  return str.replace(/(^|[\n ]) /g, "$1" + goog.string.Unicode.NBSP);
};
goog.string.stripQuotes = function(str, quoteChars) {
  var length = quoteChars.length;
  for (var i = 0; i < length; i++) {
    var quoteChar = length == 1 ? quoteChars : quoteChars.charAt(i);
    if (str.charAt(0) == quoteChar && str.charAt(str.length - 1) == quoteChar) {
      return str.substring(1, str.length - 1);
    }
  }
  return str;
};
goog.string.truncate = function(str, chars, opt_protectEscapedCharacters) {
  if (opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str);
  }
  if (str.length > chars) {
    str = str.substring(0, chars - 3) + "...";
  }
  if (opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str);
  }
  return str;
};
goog.string.truncateMiddle = function(str, chars, opt_protectEscapedCharacters, opt_trailingChars) {
  if (opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str);
  }
  if (opt_trailingChars && str.length > chars) {
    if (opt_trailingChars > chars) {
      opt_trailingChars = chars;
    }
    var endPoint = str.length - opt_trailingChars;
    var startPoint = chars - opt_trailingChars;
    str = str.substring(0, startPoint) + "..." + str.substring(endPoint);
  } else {
    if (str.length > chars) {
      var half = Math.floor(chars / 2);
      var endPos = str.length - half;
      half += chars % 2;
      str = str.substring(0, half) + "..." + str.substring(endPos);
    }
  }
  if (opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str);
  }
  return str;
};
goog.string.specialEscapeChars_ = {"\x00":"\\0", "\b":"\\b", "\f":"\\f", "\n":"\\n", "\r":"\\r", "\t":"\\t", "\x0B":"\\x0B", '"':'\\"', "\\":"\\\\", "\x3c":"\x3c"};
goog.string.jsEscapeCache_ = {"'":"\\'"};
goog.string.quote = function(s) {
  s = String(s);
  var sb = ['"'];
  for (var i = 0; i < s.length; i++) {
    var ch = s.charAt(i);
    var cc = ch.charCodeAt(0);
    sb[i + 1] = goog.string.specialEscapeChars_[ch] || (cc > 31 && cc < 127 ? ch : goog.string.escapeChar(ch));
  }
  sb.push('"');
  return sb.join("");
};
goog.string.escapeString = function(str) {
  var sb = [];
  for (var i = 0; i < str.length; i++) {
    sb[i] = goog.string.escapeChar(str.charAt(i));
  }
  return sb.join("");
};
goog.string.escapeChar = function(c) {
  if (c in goog.string.jsEscapeCache_) {
    return goog.string.jsEscapeCache_[c];
  }
  if (c in goog.string.specialEscapeChars_) {
    return goog.string.jsEscapeCache_[c] = goog.string.specialEscapeChars_[c];
  }
  var rv = c;
  var cc = c.charCodeAt(0);
  if (cc > 31 && cc < 127) {
    rv = c;
  } else {
    if (cc < 256) {
      rv = "\\x";
      if (cc < 16 || cc > 256) {
        rv += "0";
      }
    } else {
      rv = "\\u";
      if (cc < 4096) {
        rv += "0";
      }
    }
    rv += cc.toString(16).toUpperCase();
  }
  return goog.string.jsEscapeCache_[c] = rv;
};
goog.string.contains = function(str, subString) {
  return str.indexOf(subString) != -1;
};
goog.string.caseInsensitiveContains = function(str, subString) {
  return goog.string.contains(str.toLowerCase(), subString.toLowerCase());
};
goog.string.countOf = function(s, ss) {
  return s && ss ? s.split(ss).length - 1 : 0;
};
goog.string.removeAt = function(s, index, stringLength) {
  var resultStr = s;
  if (index >= 0 && index < s.length && stringLength > 0) {
    resultStr = s.substr(0, index) + s.substr(index + stringLength, s.length - index - stringLength);
  }
  return resultStr;
};
goog.string.remove = function(str, substr) {
  return str.replace(substr, "");
};
goog.string.removeAll = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "g");
  return s.replace(re, "");
};
goog.string.replaceAll = function(s, ss, replacement) {
  var re = new RegExp(goog.string.regExpEscape(ss), "g");
  return s.replace(re, replacement.replace(/\$/g, "$$$$"));
};
goog.string.regExpEscape = function(s) {
  return String(s).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08");
};
goog.string.repeat = String.prototype.repeat ? function(string, length) {
  return string.repeat(length);
} : function(string, length) {
  return (new Array(length + 1)).join(string);
};
goog.string.padNumber = function(num, length, opt_precision) {
  var s = goog.isDef(opt_precision) ? num.toFixed(opt_precision) : String(num);
  var index = s.indexOf(".");
  if (index == -1) {
    index = s.length;
  }
  return goog.string.repeat("0", Math.max(0, length - index)) + s;
};
goog.string.makeSafe = function(obj) {
  return obj == null ? "" : String(obj);
};
goog.string.buildString = function(var_args) {
  return Array.prototype.join.call(arguments, "");
};
goog.string.getRandomString = function() {
  var x = 2147483648;
  return Math.floor(Math.random() * x).toString(36) + Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36);
};
goog.string.compareVersions = function(version1, version2) {
  var order = 0;
  var v1Subs = goog.string.trim(String(version1)).split(".");
  var v2Subs = goog.string.trim(String(version2)).split(".");
  var subCount = Math.max(v1Subs.length, v2Subs.length);
  for (var subIdx = 0; order == 0 && subIdx < subCount; subIdx++) {
    var v1Sub = v1Subs[subIdx] || "";
    var v2Sub = v2Subs[subIdx] || "";
    do {
      var v1Comp = /(\d*)(\D*)(.*)/.exec(v1Sub) || ["", "", "", ""];
      var v2Comp = /(\d*)(\D*)(.*)/.exec(v2Sub) || ["", "", "", ""];
      if (v1Comp[0].length == 0 && v2Comp[0].length == 0) {
        break;
      }
      var v1CompNum = v1Comp[1].length == 0 ? 0 : parseInt(v1Comp[1], 10);
      var v2CompNum = v2Comp[1].length == 0 ? 0 : parseInt(v2Comp[1], 10);
      order = goog.string.compareElements_(v1CompNum, v2CompNum) || goog.string.compareElements_(v1Comp[2].length == 0, v2Comp[2].length == 0) || goog.string.compareElements_(v1Comp[2], v2Comp[2]);
      v1Sub = v1Comp[3];
      v2Sub = v2Comp[3];
    } while (order == 0);
  }
  return order;
};
goog.string.compareElements_ = function(left, right) {
  if (left < right) {
    return -1;
  } else {
    if (left > right) {
      return 1;
    }
  }
  return 0;
};
goog.string.hashCode = function(str) {
  var result = 0;
  for (var i = 0; i < str.length; ++i) {
    result = 31 * result + str.charCodeAt(i) >>> 0;
  }
  return result;
};
goog.string.uniqueStringCounter_ = Math.random() * 2147483648 | 0;
goog.string.createUniqueString = function() {
  return "goog_" + goog.string.uniqueStringCounter_++;
};
goog.string.toNumber = function(str) {
  var num = Number(str);
  if (num == 0 && goog.string.isEmptyOrWhitespace(str)) {
    return NaN;
  }
  return num;
};
goog.string.isLowerCamelCase = function(str) {
  return /^[a-z]+([A-Z][a-z]*)*$/.test(str);
};
goog.string.isUpperCamelCase = function(str) {
  return /^([A-Z][a-z]*)+$/.test(str);
};
goog.string.toCamelCase = function(str) {
  return String(str).replace(/\-([a-z])/g, function(all, match) {
    return match.toUpperCase();
  });
};
goog.string.toSelectorCase = function(str) {
  return String(str).replace(/([A-Z])/g, "-$1").toLowerCase();
};
goog.string.toTitleCase = function(str, opt_delimiters) {
  var delimiters = goog.isString(opt_delimiters) ? goog.string.regExpEscape(opt_delimiters) : "\\s";
  delimiters = delimiters ? "|[" + delimiters + "]+" : "";
  var regexp = new RegExp("(^" + delimiters + ")([a-z])", "g");
  return str.replace(regexp, function(all, p1, p2) {
    return p1 + p2.toUpperCase();
  });
};
goog.string.capitalize = function(str) {
  return String(str.charAt(0)).toUpperCase() + String(str.substr(1)).toLowerCase();
};
goog.string.parseInt = function(value) {
  if (isFinite(value)) {
    value = String(value);
  }
  if (goog.isString(value)) {
    return /^\s*-?0x/i.test(value) ? parseInt(value, 16) : parseInt(value, 10);
  }
  return NaN;
};
goog.string.splitLimit = function(str, separator, limit) {
  var parts = str.split(separator);
  var returnVal = [];
  while (limit > 0 && parts.length) {
    returnVal.push(parts.shift());
    limit--;
  }
  if (parts.length) {
    returnVal.push(parts.join(separator));
  }
  return returnVal;
};
goog.string.lastComponent = function(str, separators) {
  if (!separators) {
    return str;
  } else {
    if (typeof separators == "string") {
      separators = [separators];
    }
  }
  var lastSeparatorIndex = -1;
  for (var i = 0; i < separators.length; i++) {
    if (separators[i] == "") {
      continue;
    }
    var currentSeparatorIndex = str.lastIndexOf(separators[i]);
    if (currentSeparatorIndex > lastSeparatorIndex) {
      lastSeparatorIndex = currentSeparatorIndex;
    }
  }
  if (lastSeparatorIndex == -1) {
    return str;
  }
  return str.slice(lastSeparatorIndex + 1);
};
goog.string.editDistance = function(a, b) {
  var v0 = [];
  var v1 = [];
  if (a == b) {
    return 0;
  }
  if (!a.length || !b.length) {
    return Math.max(a.length, b.length);
  }
  for (var i = 0; i < b.length + 1; i++) {
    v0[i] = i;
  }
  for (var i = 0; i < a.length; i++) {
    v1[0] = i + 1;
    for (var j = 0; j < b.length; j++) {
      var cost = Number(a[i] != b[j]);
      v1[j + 1] = Math.min(v1[j] + 1, v0[j + 1] + 1, v0[j] + cost);
    }
    for (var j = 0; j < v0.length; j++) {
      v0[j] = v1[j];
    }
  }
  return v1[b.length];
};
goog.provide("goog.debug.Error");
goog.debug.Error = function(opt_msg) {
  if (Error.captureStackTrace) {
    Error.captureStackTrace(this, goog.debug.Error);
  } else {
    var stack = (new Error).stack;
    if (stack) {
      this.stack = stack;
    }
  }
  if (opt_msg) {
    this.message = String(opt_msg);
  }
  this.reportErrorToServer = true;
};
goog.inherits(goog.debug.Error, Error);
goog.debug.Error.prototype.name = "CustomError";
goog.provide("goog.dom.NodeType");
goog.dom.NodeType = {ELEMENT:1, ATTRIBUTE:2, TEXT:3, CDATA_SECTION:4, ENTITY_REFERENCE:5, ENTITY:6, PROCESSING_INSTRUCTION:7, COMMENT:8, DOCUMENT:9, DOCUMENT_TYPE:10, DOCUMENT_FRAGMENT:11, NOTATION:12};
goog.provide("goog.asserts");
goog.provide("goog.asserts.AssertionError");
goog.require("goog.debug.Error");
goog.require("goog.dom.NodeType");
goog.require("goog.string");
goog.define("goog.asserts.ENABLE_ASSERTS", goog.DEBUG);
goog.asserts.AssertionError = function(messagePattern, messageArgs) {
  messageArgs.unshift(messagePattern);
  goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));
  messageArgs.shift();
  this.messagePattern = messagePattern;
};
goog.inherits(goog.asserts.AssertionError, goog.debug.Error);
goog.asserts.AssertionError.prototype.name = "AssertionError";
goog.asserts.DEFAULT_ERROR_HANDLER = function(e) {
  throw e;
};
goog.asserts.errorHandler_ = goog.asserts.DEFAULT_ERROR_HANDLER;
goog.asserts.doAssertFailure_ = function(defaultMessage, defaultArgs, givenMessage, givenArgs) {
  var message = "Assertion failed";
  if (givenMessage) {
    message += ": " + givenMessage;
    var args = givenArgs;
  } else {
    if (defaultMessage) {
      message += ": " + defaultMessage;
      args = defaultArgs;
    }
  }
  var e = new goog.asserts.AssertionError("" + message, args || []);
  goog.asserts.errorHandler_(e);
};
goog.asserts.setErrorHandler = function(errorHandler) {
  if (goog.asserts.ENABLE_ASSERTS) {
    goog.asserts.errorHandler_ = errorHandler;
  }
};
goog.asserts.assert = function(condition, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !condition) {
    goog.asserts.doAssertFailure_("", null, opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return condition;
};
goog.asserts.fail = function(opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS) {
    goog.asserts.errorHandler_(new goog.asserts.AssertionError("Failure" + (opt_message ? ": " + opt_message : ""), Array.prototype.slice.call(arguments, 1)));
  }
};
goog.asserts.assertNumber = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isNumber(value)) {
    goog.asserts.doAssertFailure_("Expected number but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return value;
};
goog.asserts.assertString = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isString(value)) {
    goog.asserts.doAssertFailure_("Expected string but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return value;
};
goog.asserts.assertFunction = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isFunction(value)) {
    goog.asserts.doAssertFailure_("Expected function but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return value;
};
goog.asserts.assertObject = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isObject(value)) {
    goog.asserts.doAssertFailure_("Expected object but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return value;
};
goog.asserts.assertArray = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isArray(value)) {
    goog.asserts.doAssertFailure_("Expected array but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return value;
};
goog.asserts.assertBoolean = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !goog.isBoolean(value)) {
    goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return value;
};
goog.asserts.assertElement = function(value, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && (!goog.isObject(value) || value.nodeType != goog.dom.NodeType.ELEMENT)) {
    goog.asserts.doAssertFailure_("Expected Element but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2));
  }
  return value;
};
goog.asserts.assertInstanceof = function(value, type, opt_message, var_args) {
  if (goog.asserts.ENABLE_ASSERTS && !(value instanceof type)) {
    goog.asserts.doAssertFailure_("Expected instanceof %s but got %s.", [goog.asserts.getType_(type), goog.asserts.getType_(value)], opt_message, Array.prototype.slice.call(arguments, 3));
  }
  return value;
};
goog.asserts.assertObjectPrototypeIsIntact = function() {
  for (var key in Object.prototype) {
    goog.asserts.fail(key + " should not be enumerable in Object.prototype.");
  }
};
goog.asserts.getType_ = function(value) {
  if (value instanceof Function) {
    return value.displayName || value.name || "unknown type name";
  } else {
    if (value instanceof Object) {
      return value.constructor.displayName || value.constructor.name || Object.prototype.toString.call(value);
    } else {
      return value === null ? "null" : typeof value;
    }
  }
};
goog.provide("goog.array");
goog.require("goog.asserts");
goog.define("goog.NATIVE_ARRAY_PROTOTYPES", goog.TRUSTED_SITE);
goog.define("goog.array.ASSUME_NATIVE_FUNCTIONS", false);
goog.array.peek = function(array) {
  return array[array.length - 1];
};
goog.array.last = goog.array.peek;
goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.indexOf) ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.indexOf.call(arr, obj, opt_fromIndex);
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? 0 : opt_fromIndex < 0 ? Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex;
  if (goog.isString(arr)) {
    if (!goog.isString(obj) || obj.length != 1) {
      return -1;
    }
    return arr.indexOf(obj, fromIndex);
  }
  for (var i = fromIndex; i < arr.length; i++) {
    if (i in arr && arr[i] === obj) {
      return i;
    }
  }
  return -1;
};
goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.lastIndexOf) ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  return Array.prototype.lastIndexOf.call(arr, obj, fromIndex);
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  if (fromIndex < 0) {
    fromIndex = Math.max(0, arr.length + fromIndex);
  }
  if (goog.isString(arr)) {
    if (!goog.isString(obj) || obj.length != 1) {
      return -1;
    }
    return arr.lastIndexOf(obj, fromIndex);
  }
  for (var i = fromIndex; i >= 0; i--) {
    if (i in arr && arr[i] === obj) {
      return i;
    }
  }
  return -1;
};
goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.forEach) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  Array.prototype.forEach.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0; i < l; i++) {
    if (i in arr2) {
      f.call(opt_obj, arr2[i], i, arr);
    }
  }
};
goog.array.forEachRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = l - 1; i >= 0; --i) {
    if (i in arr2) {
      f.call(opt_obj, arr2[i], i, arr);
    }
  }
};
goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.filter) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.filter.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = [];
  var resLength = 0;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0; i < l; i++) {
    if (i in arr2) {
      var val = arr2[i];
      if (f.call(opt_obj, val, i, arr)) {
        res[resLength++] = val;
      }
    }
  }
  return res;
};
goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.map) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.map.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = new Array(l);
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0; i < l; i++) {
    if (i in arr2) {
      res[i] = f.call(opt_obj, arr2[i], i, arr);
    }
  }
  return res;
};
goog.array.reduce = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.reduce) ? function(arr, f, val, opt_obj) {
  goog.asserts.assert(arr.length != null);
  if (opt_obj) {
    f = goog.bind(f, opt_obj);
  }
  return Array.prototype.reduce.call(arr, f, val);
} : function(arr, f, val, opt_obj) {
  var rval = val;
  goog.array.forEach(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr);
  });
  return rval;
};
goog.array.reduceRight = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.reduceRight) ? function(arr, f, val, opt_obj) {
  goog.asserts.assert(arr.length != null);
  goog.asserts.assert(f != null);
  if (opt_obj) {
    f = goog.bind(f, opt_obj);
  }
  return Array.prototype.reduceRight.call(arr, f, val);
} : function(arr, f, val, opt_obj) {
  var rval = val;
  goog.array.forEachRight(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr);
  });
  return rval;
};
goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.some) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.some.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0; i < l; i++) {
    if (i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return true;
    }
  }
  return false;
};
goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES && (goog.array.ASSUME_NATIVE_FUNCTIONS || Array.prototype.every) ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.every.call(arr, f, opt_obj);
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0; i < l; i++) {
    if (i in arr2 && !f.call(opt_obj, arr2[i], i, arr)) {
      return false;
    }
  }
  return true;
};
goog.array.count = function(arr, f, opt_obj) {
  var count = 0;
  goog.array.forEach(arr, function(element, index, arr) {
    if (f.call(opt_obj, element, index, arr)) {
      ++count;
    }
  }, opt_obj);
  return count;
};
goog.array.find = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i];
};
goog.array.findIndex = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = 0; i < l; i++) {
    if (i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i;
    }
  }
  return -1;
};
goog.array.findRight = function(arr, f, opt_obj) {
  var i = goog.array.findIndexRight(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i];
};
goog.array.findIndexRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for (var i = l - 1; i >= 0; i--) {
    if (i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i;
    }
  }
  return -1;
};
goog.array.contains = function(arr, obj) {
  return goog.array.indexOf(arr, obj) >= 0;
};
goog.array.isEmpty = function(arr) {
  return arr.length == 0;
};
goog.array.clear = function(arr) {
  if (!goog.isArray(arr)) {
    for (var i = arr.length - 1; i >= 0; i--) {
      delete arr[i];
    }
  }
  arr.length = 0;
};
goog.array.insert = function(arr, obj) {
  if (!goog.array.contains(arr, obj)) {
    arr.push(obj);
  }
};
goog.array.insertAt = function(arr, obj, opt_i) {
  goog.array.splice(arr, opt_i, 0, obj);
};
goog.array.insertArrayAt = function(arr, elementsToAdd, opt_i) {
  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd);
};
goog.array.insertBefore = function(arr, obj, opt_obj2) {
  var i;
  if (arguments.length == 2 || (i = goog.array.indexOf(arr, opt_obj2)) < 0) {
    arr.push(obj);
  } else {
    goog.array.insertAt(arr, obj, i);
  }
};
goog.array.remove = function(arr, obj) {
  var i = goog.array.indexOf(arr, obj);
  var rv;
  if (rv = i >= 0) {
    goog.array.removeAt(arr, i);
  }
  return rv;
};
goog.array.removeLast = function(arr, obj) {
  var i = goog.array.lastIndexOf(arr, obj);
  if (i >= 0) {
    goog.array.removeAt(arr, i);
    return true;
  }
  return false;
};
goog.array.removeAt = function(arr, i) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.splice.call(arr, i, 1).length == 1;
};
goog.array.removeIf = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  if (i >= 0) {
    goog.array.removeAt(arr, i);
    return true;
  }
  return false;
};
goog.array.removeAllIf = function(arr, f, opt_obj) {
  var removedCount = 0;
  goog.array.forEachRight(arr, function(val, index) {
    if (f.call(opt_obj, val, index, arr)) {
      if (goog.array.removeAt(arr, index)) {
        removedCount++;
      }
    }
  });
  return removedCount;
};
goog.array.concat = function(var_args) {
  return Array.prototype.concat.apply([], arguments);
};
goog.array.join = function(var_args) {
  return Array.prototype.concat.apply([], arguments);
};
goog.array.toArray = function(object) {
  var length = object.length;
  if (length > 0) {
    var rv = new Array(length);
    for (var i = 0; i < length; i++) {
      rv[i] = object[i];
    }
    return rv;
  }
  return [];
};
goog.array.clone = goog.array.toArray;
goog.array.extend = function(arr1, var_args) {
  for (var i = 1; i < arguments.length; i++) {
    var arr2 = arguments[i];
    if (goog.isArrayLike(arr2)) {
      var len1 = arr1.length || 0;
      var len2 = arr2.length || 0;
      arr1.length = len1 + len2;
      for (var j = 0; j < len2; j++) {
        arr1[len1 + j] = arr2[j];
      }
    } else {
      arr1.push(arr2);
    }
  }
};
goog.array.splice = function(arr, index, howMany, var_args) {
  goog.asserts.assert(arr.length != null);
  return Array.prototype.splice.apply(arr, goog.array.slice(arguments, 1));
};
goog.array.slice = function(arr, start, opt_end) {
  goog.asserts.assert(arr.length != null);
  if (arguments.length <= 2) {
    return Array.prototype.slice.call(arr, start);
  } else {
    return Array.prototype.slice.call(arr, start, opt_end);
  }
};
goog.array.removeDuplicates = function(arr, opt_rv, opt_hashFn) {
  var returnArray = opt_rv || arr;
  var defaultHashFn = function(item) {
    return goog.isObject(item) ? "o" + goog.getUid(item) : (typeof item).charAt(0) + item;
  };
  var hashFn = opt_hashFn || defaultHashFn;
  var seen = {}, cursorInsert = 0, cursorRead = 0;
  while (cursorRead < arr.length) {
    var current = arr[cursorRead++];
    var key = hashFn(current);
    if (!Object.prototype.hasOwnProperty.call(seen, key)) {
      seen[key] = true;
      returnArray[cursorInsert++] = current;
    }
  }
  returnArray.length = cursorInsert;
};
goog.array.binarySearch = function(arr, target, opt_compareFn) {
  return goog.array.binarySearch_(arr, opt_compareFn || goog.array.defaultCompare, false, target);
};
goog.array.binarySelect = function(arr, evaluator, opt_obj) {
  return goog.array.binarySearch_(arr, evaluator, true, undefined, opt_obj);
};
goog.array.binarySearch_ = function(arr, compareFn, isEvaluator, opt_target, opt_selfObj) {
  var left = 0;
  var right = arr.length;
  var found;
  while (left < right) {
    var middle = left + right >> 1;
    var compareResult;
    if (isEvaluator) {
      compareResult = compareFn.call(opt_selfObj, arr[middle], middle, arr);
    } else {
      compareResult = compareFn(opt_target, arr[middle]);
    }
    if (compareResult > 0) {
      left = middle + 1;
    } else {
      right = middle;
      found = !compareResult;
    }
  }
  return found ? left : ~left;
};
goog.array.sort = function(arr, opt_compareFn) {
  arr.sort(opt_compareFn || goog.array.defaultCompare);
};
goog.array.stableSort = function(arr, opt_compareFn) {
  var compArr = new Array(arr.length);
  for (var i = 0; i < arr.length; i++) {
    compArr[i] = {index:i, value:arr[i]};
  }
  var valueCompareFn = opt_compareFn || goog.array.defaultCompare;
  function stableCompareFn(obj1, obj2) {
    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index;
  }
  goog.array.sort(compArr, stableCompareFn);
  for (var i = 0; i < arr.length; i++) {
    arr[i] = compArr[i].value;
  }
};
goog.array.sortByKey = function(arr, keyFn, opt_compareFn) {
  var keyCompareFn = opt_compareFn || goog.array.defaultCompare;
  goog.array.sort(arr, function(a, b) {
    return keyCompareFn(keyFn(a), keyFn(b));
  });
};
goog.array.sortObjectsByKey = function(arr, key, opt_compareFn) {
  goog.array.sortByKey(arr, function(obj) {
    return obj[key];
  }, opt_compareFn);
};
goog.array.isSorted = function(arr, opt_compareFn, opt_strict) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  for (var i = 1; i < arr.length; i++) {
    var compareResult = compare(arr[i - 1], arr[i]);
    if (compareResult > 0 || compareResult == 0 && opt_strict) {
      return false;
    }
  }
  return true;
};
goog.array.equals = function(arr1, arr2, opt_equalsFn) {
  if (!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) || arr1.length != arr2.length) {
    return false;
  }
  var l = arr1.length;
  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  for (var i = 0; i < l; i++) {
    if (!equalsFn(arr1[i], arr2[i])) {
      return false;
    }
  }
  return true;
};
goog.array.compare3 = function(arr1, arr2, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  var l = Math.min(arr1.length, arr2.length);
  for (var i = 0; i < l; i++) {
    var result = compare(arr1[i], arr2[i]);
    if (result != 0) {
      return result;
    }
  }
  return goog.array.defaultCompare(arr1.length, arr2.length);
};
goog.array.defaultCompare = function(a, b) {
  return a > b ? 1 : a < b ? -1 : 0;
};
goog.array.inverseDefaultCompare = function(a, b) {
  return -goog.array.defaultCompare(a, b);
};
goog.array.defaultCompareEquality = function(a, b) {
  return a === b;
};
goog.array.binaryInsert = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  if (index < 0) {
    goog.array.insertAt(array, value, -(index + 1));
    return true;
  }
  return false;
};
goog.array.binaryRemove = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  return index >= 0 ? goog.array.removeAt(array, index) : false;
};
goog.array.bucket = function(array, sorter, opt_obj) {
  var buckets = {};
  for (var i = 0; i < array.length; i++) {
    var value = array[i];
    var key = sorter.call(opt_obj, value, i, array);
    if (goog.isDef(key)) {
      var bucket = buckets[key] || (buckets[key] = []);
      bucket.push(value);
    }
  }
  return buckets;
};
goog.array.toObject = function(arr, keyFunc, opt_obj) {
  var ret = {};
  goog.array.forEach(arr, function(element, index) {
    ret[keyFunc.call(opt_obj, element, index, arr)] = element;
  });
  return ret;
};
goog.array.range = function(startOrEnd, opt_end, opt_step) {
  var array = [];
  var start = 0;
  var end = startOrEnd;
  var step = opt_step || 1;
  if (opt_end !== undefined) {
    start = startOrEnd;
    end = opt_end;
  }
  if (step * (end - start) < 0) {
    return [];
  }
  if (step > 0) {
    for (var i = start; i < end; i += step) {
      array.push(i);
    }
  } else {
    for (var i = start; i > end; i += step) {
      array.push(i);
    }
  }
  return array;
};
goog.array.repeat = function(value, n) {
  var array = [];
  for (var i = 0; i < n; i++) {
    array[i] = value;
  }
  return array;
};
goog.array.flatten = function(var_args) {
  var CHUNK_SIZE = 8192;
  var result = [];
  for (var i = 0; i < arguments.length; i++) {
    var element = arguments[i];
    if (goog.isArray(element)) {
      for (var c = 0; c < element.length; c += CHUNK_SIZE) {
        var chunk = goog.array.slice(element, c, c + CHUNK_SIZE);
        var recurseResult = goog.array.flatten.apply(null, chunk);
        for (var r = 0; r < recurseResult.length; r++) {
          result.push(recurseResult[r]);
        }
      }
    } else {
      result.push(element);
    }
  }
  return result;
};
goog.array.rotate = function(array, n) {
  goog.asserts.assert(array.length != null);
  if (array.length) {
    n %= array.length;
    if (n > 0) {
      Array.prototype.unshift.apply(array, array.splice(-n, n));
    } else {
      if (n < 0) {
        Array.prototype.push.apply(array, array.splice(0, -n));
      }
    }
  }
  return array;
};
goog.array.moveItem = function(arr, fromIndex, toIndex) {
  goog.asserts.assert(fromIndex >= 0 && fromIndex < arr.length);
  goog.asserts.assert(toIndex >= 0 && toIndex < arr.length);
  var removedItems = Array.prototype.splice.call(arr, fromIndex, 1);
  Array.prototype.splice.call(arr, toIndex, 0, removedItems[0]);
};
goog.array.zip = function(var_args) {
  if (!arguments.length) {
    return [];
  }
  var result = [];
  var minLen = arguments[0].length;
  for (var i = 1; i < arguments.length; i++) {
    if (arguments[i].length < minLen) {
      minLen = arguments[i].length;
    }
  }
  for (var i = 0; i < minLen; i++) {
    var value = [];
    for (var j = 0; j < arguments.length; j++) {
      value.push(arguments[j][i]);
    }
    result.push(value);
  }
  return result;
};
goog.array.shuffle = function(arr, opt_randFn) {
  var randFn = opt_randFn || Math.random;
  for (var i = arr.length - 1; i > 0; i--) {
    var j = Math.floor(randFn() * (i + 1));
    var tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp;
  }
};
goog.array.copyByIndex = function(arr, index_arr) {
  var result = [];
  goog.array.forEach(index_arr, function(index) {
    result.push(arr[index]);
  });
  return result;
};
goog.array.concatMap = function(arr, f, opt_obj) {
  return goog.array.concat.apply([], goog.array.map(arr, f, opt_obj));
};
goog.provide("goog.object");
goog.object.is = function(v, v2) {
  if (v === v2) {
    return v !== 0 || 1 / v === 1 / v2;
  }
  return v !== v && v2 !== v2;
};
goog.object.forEach = function(obj, f, opt_obj) {
  for (var key in obj) {
    f.call(opt_obj, obj[key], key, obj);
  }
};
goog.object.filter = function(obj, f, opt_obj) {
  var res = {};
  for (var key in obj) {
    if (f.call(opt_obj, obj[key], key, obj)) {
      res[key] = obj[key];
    }
  }
  return res;
};
goog.object.map = function(obj, f, opt_obj) {
  var res = {};
  for (var key in obj) {
    res[key] = f.call(opt_obj, obj[key], key, obj);
  }
  return res;
};
goog.object.some = function(obj, f, opt_obj) {
  for (var key in obj) {
    if (f.call(opt_obj, obj[key], key, obj)) {
      return true;
    }
  }
  return false;
};
goog.object.every = function(obj, f, opt_obj) {
  for (var key in obj) {
    if (!f.call(opt_obj, obj[key], key, obj)) {
      return false;
    }
  }
  return true;
};
goog.object.getCount = function(obj) {
  var rv = 0;
  for (var key in obj) {
    rv++;
  }
  return rv;
};
goog.object.getAnyKey = function(obj) {
  for (var key in obj) {
    return key;
  }
};
goog.object.getAnyValue = function(obj) {
  for (var key in obj) {
    return obj[key];
  }
};
goog.object.contains = function(obj, val) {
  return goog.object.containsValue(obj, val);
};
goog.object.getValues = function(obj) {
  var res = [];
  var i = 0;
  for (var key in obj) {
    res[i++] = obj[key];
  }
  return res;
};
goog.object.getKeys = function(obj) {
  var res = [];
  var i = 0;
  for (var key in obj) {
    res[i++] = key;
  }
  return res;
};
goog.object.getValueByKeys = function(obj, var_args) {
  var isArrayLike = goog.isArrayLike(var_args);
  var keys = isArrayLike ? var_args : arguments;
  for (var i = isArrayLike ? 0 : 1; i < keys.length; i++) {
    obj = obj[keys[i]];
    if (!goog.isDef(obj)) {
      break;
    }
  }
  return obj;
};
goog.object.containsKey = function(obj, key) {
  return obj !== null && key in obj;
};
goog.object.containsValue = function(obj, val) {
  for (var key in obj) {
    if (obj[key] == val) {
      return true;
    }
  }
  return false;
};
goog.object.findKey = function(obj, f, opt_this) {
  for (var key in obj) {
    if (f.call(opt_this, obj[key], key, obj)) {
      return key;
    }
  }
  return undefined;
};
goog.object.findValue = function(obj, f, opt_this) {
  var key = goog.object.findKey(obj, f, opt_this);
  return key && obj[key];
};
goog.object.isEmpty = function(obj) {
  for (var key in obj) {
    return false;
  }
  return true;
};
goog.object.clear = function(obj) {
  for (var i in obj) {
    delete obj[i];
  }
};
goog.object.remove = function(obj, key) {
  var rv;
  if (rv = key in obj) {
    delete obj[key];
  }
  return rv;
};
goog.object.add = function(obj, key, val) {
  if (obj !== null && key in obj) {
    throw Error('The object already contains the key "' + key + '"');
  }
  goog.object.set(obj, key, val);
};
goog.object.get = function(obj, key, opt_val) {
  if (obj !== null && key in obj) {
    return obj[key];
  }
  return opt_val;
};
goog.object.set = function(obj, key, value) {
  obj[key] = value;
};
goog.object.setIfUndefined = function(obj, key, value) {
  return key in obj ? obj[key] : obj[key] = value;
};
goog.object.setWithReturnValueIfNotSet = function(obj, key, f) {
  if (key in obj) {
    return obj[key];
  }
  var val = f();
  obj[key] = val;
  return val;
};
goog.object.equals = function(a, b) {
  for (var k in a) {
    if (!(k in b) || a[k] !== b[k]) {
      return false;
    }
  }
  for (var k in b) {
    if (!(k in a)) {
      return false;
    }
  }
  return true;
};
goog.object.clone = function(obj) {
  var res = {};
  for (var key in obj) {
    res[key] = obj[key];
  }
  return res;
};
goog.object.unsafeClone = function(obj) {
  var type = goog.typeOf(obj);
  if (type == "object" || type == "array") {
    if (goog.isFunction(obj.clone)) {
      return obj.clone();
    }
    var clone = type == "array" ? [] : {};
    for (var key in obj) {
      clone[key] = goog.object.unsafeClone(obj[key]);
    }
    return clone;
  }
  return obj;
};
goog.object.transpose = function(obj) {
  var transposed = {};
  for (var key in obj) {
    transposed[obj[key]] = key;
  }
  return transposed;
};
goog.object.PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.object.extend = function(target, var_args) {
  var key, source;
  for (var i = 1; i < arguments.length; i++) {
    source = arguments[i];
    for (key in source) {
      target[key] = source[key];
    }
    for (var j = 0; j < goog.object.PROTOTYPE_FIELDS_.length; j++) {
      key = goog.object.PROTOTYPE_FIELDS_[j];
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key];
      }
    }
  }
};
goog.object.create = function(var_args) {
  var argLength = arguments.length;
  if (argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.create.apply(null, arguments[0]);
  }
  if (argLength % 2) {
    throw Error("Uneven number of arguments");
  }
  var rv = {};
  for (var i = 0; i < argLength; i += 2) {
    rv[arguments[i]] = arguments[i + 1];
  }
  return rv;
};
goog.object.createSet = function(var_args) {
  var argLength = arguments.length;
  if (argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.createSet.apply(null, arguments[0]);
  }
  var rv = {};
  for (var i = 0; i < argLength; i++) {
    rv[arguments[i]] = true;
  }
  return rv;
};
goog.object.createImmutableView = function(obj) {
  var result = obj;
  if (Object.isFrozen && !Object.isFrozen(obj)) {
    result = Object.create(obj);
    Object.freeze(result);
  }
  return result;
};
goog.object.isImmutableView = function(obj) {
  return !!Object.isFrozen && Object.isFrozen(obj);
};
goog.object.getAllPropertyNames = function(obj, opt_includeObjectPrototype, opt_includeFunctionPrototype) {
  if (!obj) {
    return [];
  }
  if (!Object.getOwnPropertyNames || !Object.getPrototypeOf) {
    return goog.object.getKeys(obj);
  }
  var visitedSet = {};
  var proto = obj;
  while (proto && (proto !== Object.prototype || !!opt_includeObjectPrototype) && (proto !== Function.prototype || !!opt_includeFunctionPrototype)) {
    var names = Object.getOwnPropertyNames(proto);
    for (var i = 0; i < names.length; i++) {
      visitedSet[names[i]] = true;
    }
    proto = Object.getPrototypeOf(proto);
  }
  return goog.object.getKeys(visitedSet);
};
goog.provide("goog.structs");
goog.require("goog.array");
goog.require("goog.object");
goog.structs.getCount = function(col) {
  if (col.getCount && typeof col.getCount == "function") {
    return col.getCount();
  }
  if (goog.isArrayLike(col) || goog.isString(col)) {
    return col.length;
  }
  return goog.object.getCount(col);
};
goog.structs.getValues = function(col) {
  if (col.getValues && typeof col.getValues == "function") {
    return col.getValues();
  }
  if (goog.isString(col)) {
    return col.split("");
  }
  if (goog.isArrayLike(col)) {
    var rv = [];
    var l = col.length;
    for (var i = 0; i < l; i++) {
      rv.push(col[i]);
    }
    return rv;
  }
  return goog.object.getValues(col);
};
goog.structs.getKeys = function(col) {
  if (col.getKeys && typeof col.getKeys == "function") {
    return col.getKeys();
  }
  if (col.getValues && typeof col.getValues == "function") {
    return undefined;
  }
  if (goog.isArrayLike(col) || goog.isString(col)) {
    var rv = [];
    var l = col.length;
    for (var i = 0; i < l; i++) {
      rv.push(i);
    }
    return rv;
  }
  return goog.object.getKeys(col);
};
goog.structs.contains = function(col, val) {
  if (col.contains && typeof col.contains == "function") {
    return col.contains(val);
  }
  if (col.containsValue && typeof col.containsValue == "function") {
    return col.containsValue(val);
  }
  if (goog.isArrayLike(col) || goog.isString(col)) {
    return goog.array.contains(col, val);
  }
  return goog.object.containsValue(col, val);
};
goog.structs.isEmpty = function(col) {
  if (col.isEmpty && typeof col.isEmpty == "function") {
    return col.isEmpty();
  }
  if (goog.isArrayLike(col) || goog.isString(col)) {
    return goog.array.isEmpty(col);
  }
  return goog.object.isEmpty(col);
};
goog.structs.clear = function(col) {
  if (col.clear && typeof col.clear == "function") {
    col.clear();
  } else {
    if (goog.isArrayLike(col)) {
      goog.array.clear(col);
    } else {
      goog.object.clear(col);
    }
  }
};
goog.structs.forEach = function(col, f, opt_obj) {
  if (col.forEach && typeof col.forEach == "function") {
    col.forEach(f, opt_obj);
  } else {
    if (goog.isArrayLike(col) || goog.isString(col)) {
      goog.array.forEach(col, f, opt_obj);
    } else {
      var keys = goog.structs.getKeys(col);
      var values = goog.structs.getValues(col);
      var l = values.length;
      for (var i = 0; i < l; i++) {
        f.call(opt_obj, values[i], keys && keys[i], col);
      }
    }
  }
};
goog.structs.filter = function(col, f, opt_obj) {
  if (typeof col.filter == "function") {
    return col.filter(f, opt_obj);
  }
  if (goog.isArrayLike(col) || goog.isString(col)) {
    return goog.array.filter(col, f, opt_obj);
  }
  var rv;
  var keys = goog.structs.getKeys(col);
  var values = goog.structs.getValues(col);
  var l = values.length;
  if (keys) {
    rv = {};
    for (var i = 0; i < l; i++) {
      if (f.call(opt_obj, values[i], keys[i], col)) {
        rv[keys[i]] = values[i];
      }
    }
  } else {
    rv = [];
    for (var i = 0; i < l; i++) {
      if (f.call(opt_obj, values[i], undefined, col)) {
        rv.push(values[i]);
      }
    }
  }
  return rv;
};
goog.structs.map = function(col, f, opt_obj) {
  if (typeof col.map == "function") {
    return col.map(f, opt_obj);
  }
  if (goog.isArrayLike(col) || goog.isString(col)) {
    return goog.array.map(col, f, opt_obj);
  }
  var rv;
  var keys = goog.structs.getKeys(col);
  var values = goog.structs.getValues(col);
  var l = values.length;
  if (keys) {
    rv = {};
    for (var i = 0; i < l; i++) {
      rv[keys[i]] = f.call(opt_obj, values[i], keys[i], col);
    }
  } else {
    rv = [];
    for (var i = 0; i < l; i++) {
      rv[i] = f.call(opt_obj, values[i], undefined, col);
    }
  }
  return rv;
};
goog.structs.some = function(col, f, opt_obj) {
  if (typeof col.some == "function") {
    return col.some(f, opt_obj);
  }
  if (goog.isArrayLike(col) || goog.isString(col)) {
    return goog.array.some(col, f, opt_obj);
  }
  var keys = goog.structs.getKeys(col);
  var values = goog.structs.getValues(col);
  var l = values.length;
  for (var i = 0; i < l; i++) {
    if (f.call(opt_obj, values[i], keys && keys[i], col)) {
      return true;
    }
  }
  return false;
};
goog.structs.every = function(col, f, opt_obj) {
  if (typeof col.every == "function") {
    return col.every(f, opt_obj);
  }
  if (goog.isArrayLike(col) || goog.isString(col)) {
    return goog.array.every(col, f, opt_obj);
  }
  var keys = goog.structs.getKeys(col);
  var values = goog.structs.getValues(col);
  var l = values.length;
  for (var i = 0; i < l; i++) {
    if (!f.call(opt_obj, values[i], keys && keys[i], col)) {
      return false;
    }
  }
  return true;
};
goog.provide("goog.functions");
goog.functions.constant = function(retValue) {
  return function() {
    return retValue;
  };
};
goog.functions.FALSE = goog.functions.constant(false);
goog.functions.TRUE = goog.functions.constant(true);
goog.functions.NULL = goog.functions.constant(null);
goog.functions.identity = function(opt_returnValue, var_args) {
  return opt_returnValue;
};
goog.functions.error = function(message) {
  return function() {
    throw Error(message);
  };
};
goog.functions.fail = function(err) {
  return function() {
    throw err;
  };
};
goog.functions.lock = function(f, opt_numArgs) {
  opt_numArgs = opt_numArgs || 0;
  return function() {
    return f.apply(this, Array.prototype.slice.call(arguments, 0, opt_numArgs));
  };
};
goog.functions.nth = function(n) {
  return function() {
    return arguments[n];
  };
};
goog.functions.partialRight = function(fn, var_args) {
  var rightArgs = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = Array.prototype.slice.call(arguments);
    newArgs.push.apply(newArgs, rightArgs);
    return fn.apply(this, newArgs);
  };
};
goog.functions.withReturnValue = function(f, retValue) {
  return goog.functions.sequence(f, goog.functions.constant(retValue));
};
goog.functions.equalTo = function(value, opt_useLooseComparison) {
  return function(other) {
    return opt_useLooseComparison ? value == other : value === other;
  };
};
goog.functions.compose = function(fn, var_args) {
  var functions = arguments;
  var length = functions.length;
  return function() {
    var result;
    if (length) {
      result = functions[length - 1].apply(this, arguments);
    }
    for (var i = length - 2; i >= 0; i--) {
      result = functions[i].call(this, result);
    }
    return result;
  };
};
goog.functions.sequence = function(var_args) {
  var functions = arguments;
  var length = functions.length;
  return function() {
    var result;
    for (var i = 0; i < length; i++) {
      result = functions[i].apply(this, arguments);
    }
    return result;
  };
};
goog.functions.and = function(var_args) {
  var functions = arguments;
  var length = functions.length;
  return function() {
    for (var i = 0; i < length; i++) {
      if (!functions[i].apply(this, arguments)) {
        return false;
      }
    }
    return true;
  };
};
goog.functions.or = function(var_args) {
  var functions = arguments;
  var length = functions.length;
  return function() {
    for (var i = 0; i < length; i++) {
      if (functions[i].apply(this, arguments)) {
        return true;
      }
    }
    return false;
  };
};
goog.functions.not = function(f) {
  return function() {
    return !f.apply(this, arguments);
  };
};
goog.functions.create = function(constructor, var_args) {
  var temp = function() {
  };
  temp.prototype = constructor.prototype;
  var obj = new temp;
  constructor.apply(obj, Array.prototype.slice.call(arguments, 1));
  return obj;
};
goog.define("goog.functions.CACHE_RETURN_VALUE", true);
goog.functions.cacheReturnValue = function(fn) {
  var called = false;
  var value;
  return function() {
    if (!goog.functions.CACHE_RETURN_VALUE) {
      return fn();
    }
    if (!called) {
      value = fn();
      called = true;
    }
    return value;
  };
};
goog.functions.once = function(f) {
  var inner = f;
  return function() {
    if (inner) {
      var tmp = inner;
      inner = null;
      tmp();
    }
  };
};
goog.functions.debounce = function(f, interval, opt_scope) {
  var timeout = 0;
  return function(var_args) {
    goog.global.clearTimeout(timeout);
    var args = arguments;
    timeout = goog.global.setTimeout(function() {
      f.apply(opt_scope, args);
    }, interval);
  };
};
goog.functions.throttle = function(f, interval, opt_scope) {
  var timeout = 0;
  var shouldFire = false;
  var args = [];
  var handleTimeout = function() {
    timeout = 0;
    if (shouldFire) {
      shouldFire = false;
      fire();
    }
  };
  var fire = function() {
    timeout = goog.global.setTimeout(handleTimeout, interval);
    f.apply(opt_scope, args);
  };
  return function(var_args) {
    args = arguments;
    if (!timeout) {
      fire();
    } else {
      shouldFire = true;
    }
  };
};
goog.functions.rateLimit = function(f, interval, opt_scope) {
  var timeout = 0;
  var handleTimeout = function() {
    timeout = 0;
  };
  return function(var_args) {
    if (!timeout) {
      timeout = goog.global.setTimeout(handleTimeout, interval);
      f.apply(opt_scope, arguments);
    }
  };
};
goog.provide("goog.math");
goog.require("goog.array");
goog.require("goog.asserts");
goog.math.randomInt = function(a) {
  return Math.floor(Math.random() * a);
};
goog.math.uniformRandom = function(a, b) {
  return a + Math.random() * (b - a);
};
goog.math.clamp = function(value, min, max) {
  return Math.min(Math.max(value, min), max);
};
goog.math.modulo = function(a, b) {
  var r = a % b;
  return r * b < 0 ? r + b : r;
};
goog.math.lerp = function(a, b, x) {
  return a + x * (b - a);
};
goog.math.nearlyEquals = function(a, b, opt_tolerance) {
  return Math.abs(a - b) <= (opt_tolerance || 0.000001);
};
goog.math.standardAngle = function(angle) {
  return goog.math.modulo(angle, 360);
};
goog.math.standardAngleInRadians = function(angle) {
  return goog.math.modulo(angle, 2 * Math.PI);
};
goog.math.toRadians = function(angleDegrees) {
  return angleDegrees * Math.PI / 180;
};
goog.math.toDegrees = function(angleRadians) {
  return angleRadians * 180 / Math.PI;
};
goog.math.angleDx = function(degrees, radius) {
  return radius * Math.cos(goog.math.toRadians(degrees));
};
goog.math.angleDy = function(degrees, radius) {
  return radius * Math.sin(goog.math.toRadians(degrees));
};
goog.math.angle = function(x1, y1, x2, y2) {
  return goog.math.standardAngle(goog.math.toDegrees(Math.atan2(y2 - y1, x2 - x1)));
};
goog.math.angleDifference = function(startAngle, endAngle) {
  var d = goog.math.standardAngle(endAngle) - goog.math.standardAngle(startAngle);
  if (d > 180) {
    d = d - 360;
  } else {
    if (d <= -180) {
      d = 360 + d;
    }
  }
  return d;
};
goog.math.sign = function(x) {
  if (x > 0) {
    return 1;
  }
  if (x < 0) {
    return -1;
  }
  return x;
};
goog.math.longestCommonSubsequence = function(array1, array2, opt_compareFn, opt_collectorFn) {
  var compare = opt_compareFn || function(a, b) {
    return a == b;
  };
  var collect = opt_collectorFn || function(i1, i2) {
    return array1[i1];
  };
  var length1 = array1.length;
  var length2 = array2.length;
  var arr = [];
  for (var i = 0; i < length1 + 1; i++) {
    arr[i] = [];
    arr[i][0] = 0;
  }
  for (var j = 0; j < length2 + 1; j++) {
    arr[0][j] = 0;
  }
  for (i = 1; i <= length1; i++) {
    for (j = 1; j <= length2; j++) {
      if (compare(array1[i - 1], array2[j - 1])) {
        arr[i][j] = arr[i - 1][j - 1] + 1;
      } else {
        arr[i][j] = Math.max(arr[i - 1][j], arr[i][j - 1]);
      }
    }
  }
  var result = [];
  var i = length1, j = length2;
  while (i > 0 && j > 0) {
    if (compare(array1[i - 1], array2[j - 1])) {
      result.unshift(collect(i - 1, j - 1));
      i--;
      j--;
    } else {
      if (arr[i - 1][j] > arr[i][j - 1]) {
        i--;
      } else {
        j--;
      }
    }
  }
  return result;
};
goog.math.sum = function(var_args) {
  return goog.array.reduce(arguments, function(sum, value) {
    return sum + value;
  }, 0);
};
goog.math.average = function(var_args) {
  return goog.math.sum.apply(null, arguments) / arguments.length;
};
goog.math.sampleVariance = function(var_args) {
  var sampleSize = arguments.length;
  if (sampleSize < 2) {
    return 0;
  }
  var mean = goog.math.average.apply(null, arguments);
  var variance = goog.math.sum.apply(null, goog.array.map(arguments, function(val) {
    return Math.pow(val - mean, 2);
  })) / (sampleSize - 1);
  return variance;
};
goog.math.standardDeviation = function(var_args) {
  return Math.sqrt(goog.math.sampleVariance.apply(null, arguments));
};
goog.math.isInt = function(num) {
  return isFinite(num) && num % 1 == 0;
};
goog.math.isFiniteNumber = function(num) {
  return isFinite(num);
};
goog.math.isNegativeZero = function(num) {
  return num == 0 && 1 / num < 0;
};
goog.math.log10Floor = function(num) {
  if (num > 0) {
    var x = Math.round(Math.log(num) * Math.LOG10E);
    return x - (parseFloat("1e" + x) > num ? 1 : 0);
  }
  return num == 0 ? -Infinity : NaN;
};
goog.math.safeFloor = function(num, opt_epsilon) {
  goog.asserts.assert(!goog.isDef(opt_epsilon) || opt_epsilon > 0);
  return Math.floor(num + (opt_epsilon || 2e-15));
};
goog.math.safeCeil = function(num, opt_epsilon) {
  goog.asserts.assert(!goog.isDef(opt_epsilon) || opt_epsilon > 0);
  return Math.ceil(num - (opt_epsilon || 2e-15));
};
goog.provide("goog.iter");
goog.provide("goog.iter.Iterable");
goog.provide("goog.iter.Iterator");
goog.provide("goog.iter.StopIteration");
goog.require("goog.array");
goog.require("goog.asserts");
goog.require("goog.functions");
goog.require("goog.math");
goog.iter.Iterable;
goog.iter.StopIteration = "StopIteration" in goog.global ? goog.global["StopIteration"] : {message:"StopIteration", stack:""};
goog.iter.Iterator = function() {
};
goog.iter.Iterator.prototype.next = function() {
  throw goog.iter.StopIteration;
};
goog.iter.Iterator.prototype.__iterator__ = function(opt_keys) {
  return this;
};
goog.iter.toIterator = function(iterable) {
  if (iterable instanceof goog.iter.Iterator) {
    return iterable;
  }
  if (typeof iterable.__iterator__ == "function") {
    return iterable.__iterator__(false);
  }
  if (goog.isArrayLike(iterable)) {
    var i = 0;
    var newIter = new goog.iter.Iterator;
    newIter.next = function() {
      while (true) {
        if (i >= iterable.length) {
          throw goog.iter.StopIteration;
        }
        if (!(i in iterable)) {
          i++;
          continue;
        }
        return iterable[i++];
      }
    };
    return newIter;
  }
  throw Error("Not implemented");
};
goog.iter.forEach = function(iterable, f, opt_obj) {
  if (goog.isArrayLike(iterable)) {
    try {
      goog.array.forEach(iterable, f, opt_obj);
    } catch (ex) {
      if (ex !== goog.iter.StopIteration) {
        throw ex;
      }
    }
  } else {
    iterable = goog.iter.toIterator(iterable);
    try {
      while (true) {
        f.call(opt_obj, iterable.next(), undefined, iterable);
      }
    } catch (ex) {
      if (ex !== goog.iter.StopIteration) {
        throw ex;
      }
    }
  }
};
goog.iter.filter = function(iterable, f, opt_obj) {
  var iterator = goog.iter.toIterator(iterable);
  var newIter = new goog.iter.Iterator;
  newIter.next = function() {
    while (true) {
      var val = iterator.next();
      if (f.call(opt_obj, val, undefined, iterator)) {
        return val;
      }
    }
  };
  return newIter;
};
goog.iter.filterFalse = function(iterable, f, opt_obj) {
  return goog.iter.filter(iterable, goog.functions.not(f), opt_obj);
};
goog.iter.range = function(startOrStop, opt_stop, opt_step) {
  var start = 0;
  var stop = startOrStop;
  var step = opt_step || 1;
  if (arguments.length > 1) {
    start = startOrStop;
    stop = opt_stop;
  }
  if (step == 0) {
    throw Error("Range step argument must not be zero");
  }
  var newIter = new goog.iter.Iterator;
  newIter.next = function() {
    if (step > 0 && start >= stop || step < 0 && start <= stop) {
      throw goog.iter.StopIteration;
    }
    var rv = start;
    start += step;
    return rv;
  };
  return newIter;
};
goog.iter.join = function(iterable, deliminator) {
  return goog.iter.toArray(iterable).join(deliminator);
};
goog.iter.map = function(iterable, f, opt_obj) {
  var iterator = goog.iter.toIterator(iterable);
  var newIter = new goog.iter.Iterator;
  newIter.next = function() {
    var val = iterator.next();
    return f.call(opt_obj, val, undefined, iterator);
  };
  return newIter;
};
goog.iter.reduce = function(iterable, f, val, opt_obj) {
  var rval = val;
  goog.iter.forEach(iterable, function(val) {
    rval = f.call(opt_obj, rval, val);
  });
  return rval;
};
goog.iter.some = function(iterable, f, opt_obj) {
  iterable = goog.iter.toIterator(iterable);
  try {
    while (true) {
      if (f.call(opt_obj, iterable.next(), undefined, iterable)) {
        return true;
      }
    }
  } catch (ex) {
    if (ex !== goog.iter.StopIteration) {
      throw ex;
    }
  }
  return false;
};
goog.iter.every = function(iterable, f, opt_obj) {
  iterable = goog.iter.toIterator(iterable);
  try {
    while (true) {
      if (!f.call(opt_obj, iterable.next(), undefined, iterable)) {
        return false;
      }
    }
  } catch (ex) {
    if (ex !== goog.iter.StopIteration) {
      throw ex;
    }
  }
  return true;
};
goog.iter.chain = function(var_args) {
  return goog.iter.chainFromIterable(arguments);
};
goog.iter.chainFromIterable = function(iterable) {
  var iterator = goog.iter.toIterator(iterable);
  var iter = new goog.iter.Iterator;
  var current = null;
  iter.next = function() {
    while (true) {
      if (current == null) {
        var it = iterator.next();
        current = goog.iter.toIterator(it);
      }
      try {
        return current.next();
      } catch (ex) {
        if (ex !== goog.iter.StopIteration) {
          throw ex;
        }
        current = null;
      }
    }
  };
  return iter;
};
goog.iter.dropWhile = function(iterable, f, opt_obj) {
  var iterator = goog.iter.toIterator(iterable);
  var newIter = new goog.iter.Iterator;
  var dropping = true;
  newIter.next = function() {
    while (true) {
      var val = iterator.next();
      if (dropping && f.call(opt_obj, val, undefined, iterator)) {
        continue;
      } else {
        dropping = false;
      }
      return val;
    }
  };
  return newIter;
};
goog.iter.takeWhile = function(iterable, f, opt_obj) {
  var iterator = goog.iter.toIterator(iterable);
  var iter = new goog.iter.Iterator;
  iter.next = function() {
    var val = iterator.next();
    if (f.call(opt_obj, val, undefined, iterator)) {
      return val;
    }
    throw goog.iter.StopIteration;
  };
  return iter;
};
goog.iter.toArray = function(iterable) {
  if (goog.isArrayLike(iterable)) {
    return goog.array.toArray(iterable);
  }
  iterable = goog.iter.toIterator(iterable);
  var array = [];
  goog.iter.forEach(iterable, function(val) {
    array.push(val);
  });
  return array;
};
goog.iter.equals = function(iterable1, iterable2, opt_equalsFn) {
  var fillValue = {};
  var pairs = goog.iter.zipLongest(fillValue, iterable1, iterable2);
  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  return goog.iter.every(pairs, function(pair) {
    return equalsFn(pair[0], pair[1]);
  });
};
goog.iter.nextOrValue = function(iterable, defaultValue) {
  try {
    return goog.iter.toIterator(iterable).next();
  } catch (e) {
    if (e != goog.iter.StopIteration) {
      throw e;
    }
    return defaultValue;
  }
};
goog.iter.product = function(var_args) {
  var someArrayEmpty = goog.array.some(arguments, function(arr) {
    return !arr.length;
  });
  if (someArrayEmpty || !arguments.length) {
    return new goog.iter.Iterator;
  }
  var iter = new goog.iter.Iterator;
  var arrays = arguments;
  var indicies = goog.array.repeat(0, arrays.length);
  iter.next = function() {
    if (indicies) {
      var retVal = goog.array.map(indicies, function(valueIndex, arrayIndex) {
        return arrays[arrayIndex][valueIndex];
      });
      for (var i = indicies.length - 1; i >= 0; i--) {
        goog.asserts.assert(indicies);
        if (indicies[i] < arrays[i].length - 1) {
          indicies[i]++;
          break;
        }
        if (i == 0) {
          indicies = null;
          break;
        }
        indicies[i] = 0;
      }
      return retVal;
    }
    throw goog.iter.StopIteration;
  };
  return iter;
};
goog.iter.cycle = function(iterable) {
  var baseIterator = goog.iter.toIterator(iterable);
  var cache = [];
  var cacheIndex = 0;
  var iter = new goog.iter.Iterator;
  var useCache = false;
  iter.next = function() {
    var returnElement = null;
    if (!useCache) {
      try {
        returnElement = baseIterator.next();
        cache.push(returnElement);
        return returnElement;
      } catch (e) {
        if (e != goog.iter.StopIteration || goog.array.isEmpty(cache)) {
          throw e;
        }
        useCache = true;
      }
    }
    returnElement = cache[cacheIndex];
    cacheIndex = (cacheIndex + 1) % cache.length;
    return returnElement;
  };
  return iter;
};
goog.iter.count = function(opt_start, opt_step) {
  var counter = opt_start || 0;
  var step = goog.isDef(opt_step) ? opt_step : 1;
  var iter = new goog.iter.Iterator;
  iter.next = function() {
    var returnValue = counter;
    counter += step;
    return returnValue;
  };
  return iter;
};
goog.iter.repeat = function(value) {
  var iter = new goog.iter.Iterator;
  iter.next = goog.functions.constant(value);
  return iter;
};
goog.iter.accumulate = function(iterable) {
  var iterator = goog.iter.toIterator(iterable);
  var total = 0;
  var iter = new goog.iter.Iterator;
  iter.next = function() {
    total += iterator.next();
    return total;
  };
  return iter;
};
goog.iter.zip = function(var_args) {
  var args = arguments;
  var iter = new goog.iter.Iterator;
  if (args.length > 0) {
    var iterators = goog.array.map(args, goog.iter.toIterator);
    iter.next = function() {
      var arr = goog.array.map(iterators, function(it) {
        return it.next();
      });
      return arr;
    };
  }
  return iter;
};
goog.iter.zipLongest = function(fillValue, var_args) {
  var args = goog.array.slice(arguments, 1);
  var iter = new goog.iter.Iterator;
  if (args.length > 0) {
    var iterators = goog.array.map(args, goog.iter.toIterator);
    iter.next = function() {
      var iteratorsHaveValues = false;
      var arr = goog.array.map(iterators, function(it) {
        var returnValue;
        try {
          returnValue = it.next();
          iteratorsHaveValues = true;
        } catch (ex) {
          if (ex !== goog.iter.StopIteration) {
            throw ex;
          }
          returnValue = fillValue;
        }
        return returnValue;
      });
      if (!iteratorsHaveValues) {
        throw goog.iter.StopIteration;
      }
      return arr;
    };
  }
  return iter;
};
goog.iter.compress = function(iterable, selectors) {
  var selectorIterator = goog.iter.toIterator(selectors);
  return goog.iter.filter(iterable, function() {
    return !!selectorIterator.next();
  });
};
goog.iter.GroupByIterator_ = function(iterable, opt_keyFunc) {
  this.iterator = goog.iter.toIterator(iterable);
  this.keyFunc = opt_keyFunc || goog.functions.identity;
  this.targetKey;
  this.currentKey;
  this.currentValue;
};
goog.inherits(goog.iter.GroupByIterator_, goog.iter.Iterator);
goog.iter.GroupByIterator_.prototype.next = function() {
  while (this.currentKey == this.targetKey) {
    this.currentValue = this.iterator.next();
    this.currentKey = this.keyFunc(this.currentValue);
  }
  this.targetKey = this.currentKey;
  return [this.currentKey, this.groupItems_(this.targetKey)];
};
goog.iter.GroupByIterator_.prototype.groupItems_ = function(targetKey) {
  var arr = [];
  while (this.currentKey == targetKey) {
    arr.push(this.currentValue);
    try {
      this.currentValue = this.iterator.next();
    } catch (ex) {
      if (ex !== goog.iter.StopIteration) {
        throw ex;
      }
      break;
    }
    this.currentKey = this.keyFunc(this.currentValue);
  }
  return arr;
};
goog.iter.groupBy = function(iterable, opt_keyFunc) {
  return new goog.iter.GroupByIterator_(iterable, opt_keyFunc);
};
goog.iter.starMap = function(iterable, f, opt_obj) {
  var iterator = goog.iter.toIterator(iterable);
  var iter = new goog.iter.Iterator;
  iter.next = function() {
    var args = goog.iter.toArray(iterator.next());
    return f.apply(opt_obj, goog.array.concat(args, undefined, iterator));
  };
  return iter;
};
goog.iter.tee = function(iterable, opt_num) {
  var iterator = goog.iter.toIterator(iterable);
  var num = goog.isNumber(opt_num) ? opt_num : 2;
  var buffers = goog.array.map(goog.array.range(num), function() {
    return [];
  });
  var addNextIteratorValueToBuffers = function() {
    var val = iterator.next();
    goog.array.forEach(buffers, function(buffer) {
      buffer.push(val);
    });
  };
  var createIterator = function(buffer) {
    var iter = new goog.iter.Iterator;
    iter.next = function() {
      if (goog.array.isEmpty(buffer)) {
        addNextIteratorValueToBuffers();
      }
      goog.asserts.assert(!goog.array.isEmpty(buffer));
      return buffer.shift();
    };
    return iter;
  };
  return goog.array.map(buffers, createIterator);
};
goog.iter.enumerate = function(iterable, opt_start) {
  return goog.iter.zip(goog.iter.count(opt_start), iterable);
};
goog.iter.limit = function(iterable, limitSize) {
  goog.asserts.assert(goog.math.isInt(limitSize) && limitSize >= 0);
  var iterator = goog.iter.toIterator(iterable);
  var iter = new goog.iter.Iterator;
  var remaining = limitSize;
  iter.next = function() {
    if (remaining-- > 0) {
      return iterator.next();
    }
    throw goog.iter.StopIteration;
  };
  return iter;
};
goog.iter.consume = function(iterable, count) {
  goog.asserts.assert(goog.math.isInt(count) && count >= 0);
  var iterator = goog.iter.toIterator(iterable);
  while (count-- > 0) {
    goog.iter.nextOrValue(iterator, null);
  }
  return iterator;
};
goog.iter.slice = function(iterable, start, opt_end) {
  goog.asserts.assert(goog.math.isInt(start) && start >= 0);
  var iterator = goog.iter.consume(iterable, start);
  if (goog.isNumber(opt_end)) {
    goog.asserts.assert(goog.math.isInt(opt_end) && opt_end >= start);
    iterator = goog.iter.limit(iterator, opt_end - start);
  }
  return iterator;
};
goog.iter.hasDuplicates_ = function(arr) {
  var deduped = [];
  goog.array.removeDuplicates(arr, deduped);
  return arr.length != deduped.length;
};
goog.iter.permutations = function(iterable, opt_length) {
  var elements = goog.iter.toArray(iterable);
  var length = goog.isNumber(opt_length) ? opt_length : elements.length;
  var sets = goog.array.repeat(elements, length);
  var product = goog.iter.product.apply(undefined, sets);
  return goog.iter.filter(product, function(arr) {
    return !goog.iter.hasDuplicates_(arr);
  });
};
goog.iter.combinations = function(iterable, length) {
  var elements = goog.iter.toArray(iterable);
  var indexes = goog.iter.range(elements.length);
  var indexIterator = goog.iter.permutations(indexes, length);
  var sortedIndexIterator = goog.iter.filter(indexIterator, function(arr) {
    return goog.array.isSorted(arr);
  });
  var iter = new goog.iter.Iterator;
  function getIndexFromElements(index) {
    return elements[index];
  }
  iter.next = function() {
    return goog.array.map(sortedIndexIterator.next(), getIndexFromElements);
  };
  return iter;
};
goog.iter.combinationsWithReplacement = function(iterable, length) {
  var elements = goog.iter.toArray(iterable);
  var indexes = goog.array.range(elements.length);
  var sets = goog.array.repeat(indexes, length);
  var indexIterator = goog.iter.product.apply(undefined, sets);
  var sortedIndexIterator = goog.iter.filter(indexIterator, function(arr) {
    return goog.array.isSorted(arr);
  });
  var iter = new goog.iter.Iterator;
  function getIndexFromElements(index) {
    return elements[index];
  }
  iter.next = function() {
    return goog.array.map(sortedIndexIterator.next(), getIndexFromElements);
  };
  return iter;
};
goog.provide("goog.structs.Map");
goog.require("goog.iter.Iterator");
goog.require("goog.iter.StopIteration");
goog.require("goog.object");
goog.structs.Map = function(opt_map, var_args) {
  this.map_ = {};
  this.keys_ = [];
  this.count_ = 0;
  this.version_ = 0;
  var argLength = arguments.length;
  if (argLength > 1) {
    if (argLength % 2) {
      throw Error("Uneven number of arguments");
    }
    for (var i = 0; i < argLength; i += 2) {
      this.set(arguments[i], arguments[i + 1]);
    }
  } else {
    if (opt_map) {
      this.addAll(opt_map);
    }
  }
};
goog.structs.Map.prototype.getCount = function() {
  return this.count_;
};
goog.structs.Map.prototype.getValues = function() {
  this.cleanupKeysArray_();
  var rv = [];
  for (var i = 0; i < this.keys_.length; i++) {
    var key = this.keys_[i];
    rv.push(this.map_[key]);
  }
  return rv;
};
goog.structs.Map.prototype.getKeys = function() {
  this.cleanupKeysArray_();
  return this.keys_.concat();
};
goog.structs.Map.prototype.containsKey = function(key) {
  return goog.structs.Map.hasKey_(this.map_, key);
};
goog.structs.Map.prototype.containsValue = function(val) {
  for (var i = 0; i < this.keys_.length; i++) {
    var key = this.keys_[i];
    if (goog.structs.Map.hasKey_(this.map_, key) && this.map_[key] == val) {
      return true;
    }
  }
  return false;
};
goog.structs.Map.prototype.equals = function(otherMap, opt_equalityFn) {
  if (this === otherMap) {
    return true;
  }
  if (this.count_ != otherMap.getCount()) {
    return false;
  }
  var equalityFn = opt_equalityFn || goog.structs.Map.defaultEquals;
  this.cleanupKeysArray_();
  for (var key, i = 0; key = this.keys_[i]; i++) {
    if (!equalityFn(this.get(key), otherMap.get(key))) {
      return false;
    }
  }
  return true;
};
goog.structs.Map.defaultEquals = function(a, b) {
  return a === b;
};
goog.structs.Map.prototype.isEmpty = function() {
  return this.count_ == 0;
};
goog.structs.Map.prototype.clear = function() {
  this.map_ = {};
  this.keys_.length = 0;
  this.count_ = 0;
  this.version_ = 0;
};
goog.structs.Map.prototype.remove = function(key) {
  if (goog.structs.Map.hasKey_(this.map_, key)) {
    delete this.map_[key];
    this.count_--;
    this.version_++;
    if (this.keys_.length > 2 * this.count_) {
      this.cleanupKeysArray_();
    }
    return true;
  }
  return false;
};
goog.structs.Map.prototype.cleanupKeysArray_ = function() {
  if (this.count_ != this.keys_.length) {
    var srcIndex = 0;
    var destIndex = 0;
    while (srcIndex < this.keys_.length) {
      var key = this.keys_[srcIndex];
      if (goog.structs.Map.hasKey_(this.map_, key)) {
        this.keys_[destIndex++] = key;
      }
      srcIndex++;
    }
    this.keys_.length = destIndex;
  }
  if (this.count_ != this.keys_.length) {
    var seen = {};
    var srcIndex = 0;
    var destIndex = 0;
    while (srcIndex < this.keys_.length) {
      var key = this.keys_[srcIndex];
      if (!goog.structs.Map.hasKey_(seen, key)) {
        this.keys_[destIndex++] = key;
        seen[key] = 1;
      }
      srcIndex++;
    }
    this.keys_.length = destIndex;
  }
};
goog.structs.Map.prototype.get = function(key, opt_val) {
  if (goog.structs.Map.hasKey_(this.map_, key)) {
    return this.map_[key];
  }
  return opt_val;
};
goog.structs.Map.prototype.set = function(key, value) {
  if (!goog.structs.Map.hasKey_(this.map_, key)) {
    this.count_++;
    this.keys_.push(key);
    this.version_++;
  }
  this.map_[key] = value;
};
goog.structs.Map.prototype.addAll = function(map) {
  var keys, values;
  if (map instanceof goog.structs.Map) {
    keys = map.getKeys();
    values = map.getValues();
  } else {
    keys = goog.object.getKeys(map);
    values = goog.object.getValues(map);
  }
  for (var i = 0; i < keys.length; i++) {
    this.set(keys[i], values[i]);
  }
};
goog.structs.Map.prototype.forEach = function(f, opt_obj) {
  var keys = this.getKeys();
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    var value = this.get(key);
    f.call(opt_obj, value, key, this);
  }
};
goog.structs.Map.prototype.clone = function() {
  return new goog.structs.Map(this);
};
goog.structs.Map.prototype.transpose = function() {
  var transposed = new goog.structs.Map;
  for (var i = 0; i < this.keys_.length; i++) {
    var key = this.keys_[i];
    var value = this.map_[key];
    transposed.set(value, key);
  }
  return transposed;
};
goog.structs.Map.prototype.toObject = function() {
  this.cleanupKeysArray_();
  var obj = {};
  for (var i = 0; i < this.keys_.length; i++) {
    var key = this.keys_[i];
    obj[key] = this.map_[key];
  }
  return obj;
};
goog.structs.Map.prototype.getKeyIterator = function() {
  return this.__iterator__(true);
};
goog.structs.Map.prototype.getValueIterator = function() {
  return this.__iterator__(false);
};
goog.structs.Map.prototype.__iterator__ = function(opt_keys) {
  this.cleanupKeysArray_();
  var i = 0;
  var version = this.version_;
  var selfObj = this;
  var newIter = new goog.iter.Iterator;
  newIter.next = function() {
    if (version != selfObj.version_) {
      throw Error("The map has changed since the iterator was created");
    }
    if (i >= selfObj.keys_.length) {
      throw goog.iter.StopIteration;
    }
    var key = selfObj.keys_[i++];
    return opt_keys ? key : selfObj.map_[key];
  };
  return newIter;
};
goog.structs.Map.hasKey_ = function(obj, key) {
  return Object.prototype.hasOwnProperty.call(obj, key);
};
goog.provide("goog.uri.utils");
goog.provide("goog.uri.utils.ComponentIndex");
goog.provide("goog.uri.utils.QueryArray");
goog.provide("goog.uri.utils.QueryValue");
goog.provide("goog.uri.utils.StandardQueryParam");
goog.require("goog.array");
goog.require("goog.asserts");
goog.require("goog.string");
goog.uri.utils.CharCode_ = {AMPERSAND:38, EQUAL:61, HASH:35, QUESTION:63};
goog.uri.utils.buildFromEncodedParts = function(opt_scheme, opt_userInfo, opt_domain, opt_port, opt_path, opt_queryData, opt_fragment) {
  var out = "";
  if (opt_scheme) {
    out += opt_scheme + ":";
  }
  if (opt_domain) {
    out += "//";
    if (opt_userInfo) {
      out += opt_userInfo + "@";
    }
    out += opt_domain;
    if (opt_port) {
      out += ":" + opt_port;
    }
  }
  if (opt_path) {
    out += opt_path;
  }
  if (opt_queryData) {
    out += "?" + opt_queryData;
  }
  if (opt_fragment) {
    out += "#" + opt_fragment;
  }
  return out;
};
goog.uri.utils.splitRe_ = new RegExp("^" + "(?:" + "([^:/?#.]+)" + ":)?" + "(?://" + "(?:([^/?#]*)@)?" + "([^/#?]*?)" + "(?::([0-9]+))?" + "(?\x3d[/#?]|$)" + ")?" + "([^?#]+)?" + "(?:\\?([^#]*))?" + "(?:#([\\s\\S]*))?" + "$");
goog.uri.utils.ComponentIndex = {SCHEME:1, USER_INFO:2, DOMAIN:3, PORT:4, PATH:5, QUERY_DATA:6, FRAGMENT:7};
goog.uri.utils.split = function(uri) {
  return uri.match(goog.uri.utils.splitRe_);
};
goog.uri.utils.decodeIfPossible_ = function(uri, opt_preserveReserved) {
  if (!uri) {
    return uri;
  }
  return opt_preserveReserved ? decodeURI(uri) : decodeURIComponent(uri);
};
goog.uri.utils.getComponentByIndex_ = function(componentIndex, uri) {
  return goog.uri.utils.split(uri)[componentIndex] || null;
};
goog.uri.utils.getScheme = function(uri) {
  return goog.uri.utils.getComponentByIndex_(goog.uri.utils.ComponentIndex.SCHEME, uri);
};
goog.uri.utils.getEffectiveScheme = function(uri) {
  var scheme = goog.uri.utils.getScheme(uri);
  if (!scheme && goog.global.self && goog.global.self.location) {
    var protocol = goog.global.self.location.protocol;
    scheme = protocol.substr(0, protocol.length - 1);
  }
  return scheme ? scheme.toLowerCase() : "";
};
goog.uri.utils.getUserInfoEncoded = function(uri) {
  return goog.uri.utils.getComponentByIndex_(goog.uri.utils.ComponentIndex.USER_INFO, uri);
};
goog.uri.utils.getUserInfo = function(uri) {
  return goog.uri.utils.decodeIfPossible_(goog.uri.utils.getUserInfoEncoded(uri));
};
goog.uri.utils.getDomainEncoded = function(uri) {
  return goog.uri.utils.getComponentByIndex_(goog.uri.utils.ComponentIndex.DOMAIN, uri);
};
goog.uri.utils.getDomain = function(uri) {
  return goog.uri.utils.decodeIfPossible_(goog.uri.utils.getDomainEncoded(uri), true);
};
goog.uri.utils.getPort = function(uri) {
  return Number(goog.uri.utils.getComponentByIndex_(goog.uri.utils.ComponentIndex.PORT, uri)) || null;
};
goog.uri.utils.getPathEncoded = function(uri) {
  return goog.uri.utils.getComponentByIndex_(goog.uri.utils.ComponentIndex.PATH, uri);
};
goog.uri.utils.getPath = function(uri) {
  return goog.uri.utils.decodeIfPossible_(goog.uri.utils.getPathEncoded(uri), true);
};
goog.uri.utils.getQueryData = function(uri) {
  return goog.uri.utils.getComponentByIndex_(goog.uri.utils.ComponentIndex.QUERY_DATA, uri);
};
goog.uri.utils.getFragmentEncoded = function(uri) {
  var hashIndex = uri.indexOf("#");
  return hashIndex < 0 ? null : uri.substr(hashIndex + 1);
};
goog.uri.utils.setFragmentEncoded = function(uri, fragment) {
  return goog.uri.utils.removeFragment(uri) + (fragment ? "#" + fragment : "");
};
goog.uri.utils.getFragment = function(uri) {
  return goog.uri.utils.decodeIfPossible_(goog.uri.utils.getFragmentEncoded(uri));
};
goog.uri.utils.getHost = function(uri) {
  var pieces = goog.uri.utils.split(uri);
  return goog.uri.utils.buildFromEncodedParts(pieces[goog.uri.utils.ComponentIndex.SCHEME], pieces[goog.uri.utils.ComponentIndex.USER_INFO], pieces[goog.uri.utils.ComponentIndex.DOMAIN], pieces[goog.uri.utils.ComponentIndex.PORT]);
};
goog.uri.utils.getOrigin = function(uri) {
  var pieces = goog.uri.utils.split(uri);
  return goog.uri.utils.buildFromEncodedParts(pieces[goog.uri.utils.ComponentIndex.SCHEME], null, pieces[goog.uri.utils.ComponentIndex.DOMAIN], pieces[goog.uri.utils.ComponentIndex.PORT]);
};
goog.uri.utils.getPathAndAfter = function(uri) {
  var pieces = goog.uri.utils.split(uri);
  return goog.uri.utils.buildFromEncodedParts(null, null, null, null, pieces[goog.uri.utils.ComponentIndex.PATH], pieces[goog.uri.utils.ComponentIndex.QUERY_DATA], pieces[goog.uri.utils.ComponentIndex.FRAGMENT]);
};
goog.uri.utils.removeFragment = function(uri) {
  var hashIndex = uri.indexOf("#");
  return hashIndex < 0 ? uri : uri.substr(0, hashIndex);
};
goog.uri.utils.haveSameDomain = function(uri1, uri2) {
  var pieces1 = goog.uri.utils.split(uri1);
  var pieces2 = goog.uri.utils.split(uri2);
  return pieces1[goog.uri.utils.ComponentIndex.DOMAIN] == pieces2[goog.uri.utils.ComponentIndex.DOMAIN] && pieces1[goog.uri.utils.ComponentIndex.SCHEME] == pieces2[goog.uri.utils.ComponentIndex.SCHEME] && pieces1[goog.uri.utils.ComponentIndex.PORT] == pieces2[goog.uri.utils.ComponentIndex.PORT];
};
goog.uri.utils.assertNoFragmentsOrQueries_ = function(uri) {
  goog.asserts.assert(uri.indexOf("#") < 0 && uri.indexOf("?") < 0, "goog.uri.utils: Fragment or query identifiers are not supported: [%s]", uri);
};
goog.uri.utils.QueryValue;
goog.uri.utils.QueryArray;
goog.uri.utils.parseQueryData = function(encodedQuery, callback) {
  if (!encodedQuery) {
    return;
  }
  var pairs = encodedQuery.split("\x26");
  for (var i = 0; i < pairs.length; i++) {
    var indexOfEquals = pairs[i].indexOf("\x3d");
    var name = null;
    var value = null;
    if (indexOfEquals >= 0) {
      name = pairs[i].substring(0, indexOfEquals);
      value = pairs[i].substring(indexOfEquals + 1);
    } else {
      name = pairs[i];
    }
    callback(name, value ? goog.string.urlDecode(value) : "");
  }
};
goog.uri.utils.splitQueryData_ = function(uri) {
  var hashIndex = uri.indexOf("#");
  if (hashIndex < 0) {
    hashIndex = uri.length;
  }
  var questionIndex = uri.indexOf("?");
  var queryData;
  if (questionIndex < 0 || questionIndex > hashIndex) {
    questionIndex = hashIndex;
    queryData = "";
  } else {
    queryData = uri.substring(questionIndex + 1, hashIndex);
  }
  return [uri.substr(0, questionIndex), queryData, uri.substr(hashIndex)];
};
goog.uri.utils.joinQueryData_ = function(parts) {
  return parts[0] + (parts[1] ? "?" + parts[1] : "") + parts[2];
};
goog.uri.utils.appendQueryData_ = function(queryData, newData) {
  if (!newData) {
    return queryData;
  }
  return queryData ? queryData + "\x26" + newData : newData;
};
goog.uri.utils.appendQueryDataToUri_ = function(uri, queryData) {
  if (!queryData) {
    return uri;
  }
  var parts = goog.uri.utils.splitQueryData_(uri);
  parts[1] = goog.uri.utils.appendQueryData_(parts[1], queryData);
  return goog.uri.utils.joinQueryData_(parts);
};
goog.uri.utils.appendKeyValuePairs_ = function(key, value, pairs) {
  goog.asserts.assertString(key);
  if (goog.isArray(value)) {
    goog.asserts.assertArray(value);
    for (var j = 0; j < value.length; j++) {
      goog.uri.utils.appendKeyValuePairs_(key, String(value[j]), pairs);
    }
  } else {
    if (value != null) {
      pairs.push(key + (value === "" ? "" : "\x3d" + goog.string.urlEncode(value)));
    }
  }
};
goog.uri.utils.buildQueryData = function(keysAndValues, opt_startIndex) {
  goog.asserts.assert(Math.max(keysAndValues.length - (opt_startIndex || 0), 0) % 2 == 0, "goog.uri.utils: Key/value lists must be even in length.");
  var params = [];
  for (var i = opt_startIndex || 0; i < keysAndValues.length; i += 2) {
    var key = keysAndValues[i];
    goog.uri.utils.appendKeyValuePairs_(key, keysAndValues[i + 1], params);
  }
  return params.join("\x26");
};
goog.uri.utils.buildQueryDataFromMap = function(map) {
  var params = [];
  for (var key in map) {
    goog.uri.utils.appendKeyValuePairs_(key, map[key], params);
  }
  return params.join("\x26");
};
goog.uri.utils.appendParams = function(uri, var_args) {
  var queryData = arguments.length == 2 ? goog.uri.utils.buildQueryData(arguments[1], 0) : goog.uri.utils.buildQueryData(arguments, 1);
  return goog.uri.utils.appendQueryDataToUri_(uri, queryData);
};
goog.uri.utils.appendParamsFromMap = function(uri, map) {
  var queryData = goog.uri.utils.buildQueryDataFromMap(map);
  return goog.uri.utils.appendQueryDataToUri_(uri, queryData);
};
goog.uri.utils.appendParam = function(uri, key, opt_value) {
  var value = goog.isDefAndNotNull(opt_value) ? "\x3d" + goog.string.urlEncode(opt_value) : "";
  return goog.uri.utils.appendQueryDataToUri_(uri, key + value);
};
goog.uri.utils.findParam_ = function(uri, startIndex, keyEncoded, hashOrEndIndex) {
  var index = startIndex;
  var keyLength = keyEncoded.length;
  while ((index = uri.indexOf(keyEncoded, index)) >= 0 && index < hashOrEndIndex) {
    var precedingChar = uri.charCodeAt(index - 1);
    if (precedingChar == goog.uri.utils.CharCode_.AMPERSAND || precedingChar == goog.uri.utils.CharCode_.QUESTION) {
      var followingChar = uri.charCodeAt(index + keyLength);
      if (!followingChar || followingChar == goog.uri.utils.CharCode_.EQUAL || followingChar == goog.uri.utils.CharCode_.AMPERSAND || followingChar == goog.uri.utils.CharCode_.HASH) {
        return index;
      }
    }
    index += keyLength + 1;
  }
  return -1;
};
goog.uri.utils.hashOrEndRe_ = /#|$/;
goog.uri.utils.hasParam = function(uri, keyEncoded) {
  return goog.uri.utils.findParam_(uri, 0, keyEncoded, uri.search(goog.uri.utils.hashOrEndRe_)) >= 0;
};
goog.uri.utils.getParamValue = function(uri, keyEncoded) {
  var hashOrEndIndex = uri.search(goog.uri.utils.hashOrEndRe_);
  var foundIndex = goog.uri.utils.findParam_(uri, 0, keyEncoded, hashOrEndIndex);
  if (foundIndex < 0) {
    return null;
  } else {
    var endPosition = uri.indexOf("\x26", foundIndex);
    if (endPosition < 0 || endPosition > hashOrEndIndex) {
      endPosition = hashOrEndIndex;
    }
    foundIndex += keyEncoded.length + 1;
    return goog.string.urlDecode(uri.substr(foundIndex, endPosition - foundIndex));
  }
};
goog.uri.utils.getParamValues = function(uri, keyEncoded) {
  var hashOrEndIndex = uri.search(goog.uri.utils.hashOrEndRe_);
  var position = 0;
  var foundIndex;
  var result = [];
  while ((foundIndex = goog.uri.utils.findParam_(uri, position, keyEncoded, hashOrEndIndex)) >= 0) {
    position = uri.indexOf("\x26", foundIndex);
    if (position < 0 || position > hashOrEndIndex) {
      position = hashOrEndIndex;
    }
    foundIndex += keyEncoded.length + 1;
    result.push(goog.string.urlDecode(uri.substr(foundIndex, position - foundIndex)));
  }
  return result;
};
goog.uri.utils.trailingQueryPunctuationRe_ = /[?&]($|#)/;
goog.uri.utils.removeParam = function(uri, keyEncoded) {
  var hashOrEndIndex = uri.search(goog.uri.utils.hashOrEndRe_);
  var position = 0;
  var foundIndex;
  var buffer = [];
  while ((foundIndex = goog.uri.utils.findParam_(uri, position, keyEncoded, hashOrEndIndex)) >= 0) {
    buffer.push(uri.substring(position, foundIndex));
    position = Math.min(uri.indexOf("\x26", foundIndex) + 1 || hashOrEndIndex, hashOrEndIndex);
  }
  buffer.push(uri.substr(position));
  return buffer.join("").replace(goog.uri.utils.trailingQueryPunctuationRe_, "$1");
};
goog.uri.utils.setParam = function(uri, keyEncoded, value) {
  return goog.uri.utils.appendParam(goog.uri.utils.removeParam(uri, keyEncoded), keyEncoded, value);
};
goog.uri.utils.setParamsFromMap = function(uri, params) {
  var parts = goog.uri.utils.splitQueryData_(uri);
  var queryData = parts[1];
  var buffer = [];
  if (queryData) {
    goog.array.forEach(queryData.split("\x26"), function(pair) {
      var indexOfEquals = pair.indexOf("\x3d");
      var name = indexOfEquals >= 0 ? pair.substr(0, indexOfEquals) : pair;
      if (!params.hasOwnProperty(name)) {
        buffer.push(pair);
      }
    });
  }
  parts[1] = goog.uri.utils.appendQueryData_(buffer.join("\x26"), goog.uri.utils.buildQueryDataFromMap(params));
  return goog.uri.utils.joinQueryData_(parts);
};
goog.uri.utils.appendPath = function(baseUri, path) {
  goog.uri.utils.assertNoFragmentsOrQueries_(baseUri);
  if (goog.string.endsWith(baseUri, "/")) {
    baseUri = baseUri.substr(0, baseUri.length - 1);
  }
  if (goog.string.startsWith(path, "/")) {
    path = path.substr(1);
  }
  return goog.string.buildString(baseUri, "/", path);
};
goog.uri.utils.setPath = function(uri, path) {
  if (!goog.string.startsWith(path, "/")) {
    path = "/" + path;
  }
  var parts = goog.uri.utils.split(uri);
  return goog.uri.utils.buildFromEncodedParts(parts[goog.uri.utils.ComponentIndex.SCHEME], parts[goog.uri.utils.ComponentIndex.USER_INFO], parts[goog.uri.utils.ComponentIndex.DOMAIN], parts[goog.uri.utils.ComponentIndex.PORT], path, parts[goog.uri.utils.ComponentIndex.QUERY_DATA], parts[goog.uri.utils.ComponentIndex.FRAGMENT]);
};
goog.uri.utils.StandardQueryParam = {RANDOM:"zx"};
goog.uri.utils.makeUnique = function(uri) {
  return goog.uri.utils.setParam(uri, goog.uri.utils.StandardQueryParam.RANDOM, goog.string.getRandomString());
};
goog.provide("goog.Uri");
goog.provide("goog.Uri.QueryData");
goog.require("goog.array");
goog.require("goog.asserts");
goog.require("goog.string");
goog.require("goog.structs");
goog.require("goog.structs.Map");
goog.require("goog.uri.utils");
goog.require("goog.uri.utils.ComponentIndex");
goog.require("goog.uri.utils.StandardQueryParam");
goog.Uri = function(opt_uri, opt_ignoreCase) {
  this.scheme_ = "";
  this.userInfo_ = "";
  this.domain_ = "";
  this.port_ = null;
  this.path_ = "";
  this.fragment_ = "";
  this.isReadOnly_ = false;
  this.ignoreCase_ = false;
  this.queryData_;
  var m;
  if (opt_uri instanceof goog.Uri) {
    this.ignoreCase_ = goog.isDef(opt_ignoreCase) ? opt_ignoreCase : opt_uri.getIgnoreCase();
    this.setScheme(opt_uri.getScheme());
    this.setUserInfo(opt_uri.getUserInfo());
    this.setDomain(opt_uri.getDomain());
    this.setPort(opt_uri.getPort());
    this.setPath(opt_uri.getPath());
    this.setQueryData(opt_uri.getQueryData().clone());
    this.setFragment(opt_uri.getFragment());
  } else {
    if (opt_uri && (m = goog.uri.utils.split(String(opt_uri)))) {
      this.ignoreCase_ = !!opt_ignoreCase;
      this.setScheme(m[goog.uri.utils.ComponentIndex.SCHEME] || "", true);
      this.setUserInfo(m[goog.uri.utils.ComponentIndex.USER_INFO] || "", true);
      this.setDomain(m[goog.uri.utils.ComponentIndex.DOMAIN] || "", true);
      this.setPort(m[goog.uri.utils.ComponentIndex.PORT]);
      this.setPath(m[goog.uri.utils.ComponentIndex.PATH] || "", true);
      this.setQueryData(m[goog.uri.utils.ComponentIndex.QUERY_DATA] || "", true);
      this.setFragment(m[goog.uri.utils.ComponentIndex.FRAGMENT] || "", true);
    } else {
      this.ignoreCase_ = !!opt_ignoreCase;
      this.queryData_ = new goog.Uri.QueryData(null, null, this.ignoreCase_);
    }
  }
};
goog.Uri.preserveParameterTypesCompatibilityFlag = false;
goog.Uri.RANDOM_PARAM = goog.uri.utils.StandardQueryParam.RANDOM;
goog.Uri.prototype.toString = function() {
  var out = [];
  var scheme = this.getScheme();
  if (scheme) {
    out.push(goog.Uri.encodeSpecialChars_(scheme, goog.Uri.reDisallowedInSchemeOrUserInfo_, true), ":");
  }
  var domain = this.getDomain();
  if (domain || scheme == "file") {
    out.push("//");
    var userInfo = this.getUserInfo();
    if (userInfo) {
      out.push(goog.Uri.encodeSpecialChars_(userInfo, goog.Uri.reDisallowedInSchemeOrUserInfo_, true), "@");
    }
    out.push(goog.Uri.removeDoubleEncoding_(goog.string.urlEncode(domain)));
    var port = this.getPort();
    if (port != null) {
      out.push(":", String(port));
    }
  }
  var path = this.getPath();
  if (path) {
    if (this.hasDomain() && path.charAt(0) != "/") {
      out.push("/");
    }
    out.push(goog.Uri.encodeSpecialChars_(path, path.charAt(0) == "/" ? goog.Uri.reDisallowedInAbsolutePath_ : goog.Uri.reDisallowedInRelativePath_, true));
  }
  var query = this.getEncodedQuery();
  if (query) {
    out.push("?", query);
  }
  var fragment = this.getFragment();
  if (fragment) {
    out.push("#", goog.Uri.encodeSpecialChars_(fragment, goog.Uri.reDisallowedInFragment_));
  }
  return out.join("");
};
goog.Uri.prototype.resolve = function(relativeUri) {
  var absoluteUri = this.clone();
  var overridden = relativeUri.hasScheme();
  if (overridden) {
    absoluteUri.setScheme(relativeUri.getScheme());
  } else {
    overridden = relativeUri.hasUserInfo();
  }
  if (overridden) {
    absoluteUri.setUserInfo(relativeUri.getUserInfo());
  } else {
    overridden = relativeUri.hasDomain();
  }
  if (overridden) {
    absoluteUri.setDomain(relativeUri.getDomain());
  } else {
    overridden = relativeUri.hasPort();
  }
  var path = relativeUri.getPath();
  if (overridden) {
    absoluteUri.setPort(relativeUri.getPort());
  } else {
    overridden = relativeUri.hasPath();
    if (overridden) {
      if (path.charAt(0) != "/") {
        if (this.hasDomain() && !this.hasPath()) {
          path = "/" + path;
        } else {
          var lastSlashIndex = absoluteUri.getPath().lastIndexOf("/");
          if (lastSlashIndex != -1) {
            path = absoluteUri.getPath().substr(0, lastSlashIndex + 1) + path;
          }
        }
      }
      path = goog.Uri.removeDotSegments(path);
    }
  }
  if (overridden) {
    absoluteUri.setPath(path);
  } else {
    overridden = relativeUri.hasQuery();
  }
  if (overridden) {
    absoluteUri.setQueryData(relativeUri.getQueryData().clone());
  } else {
    overridden = relativeUri.hasFragment();
  }
  if (overridden) {
    absoluteUri.setFragment(relativeUri.getFragment());
  }
  return absoluteUri;
};
goog.Uri.prototype.clone = function() {
  return new goog.Uri(this);
};
goog.Uri.prototype.getScheme = function() {
  return this.scheme_;
};
goog.Uri.prototype.setScheme = function(newScheme, opt_decode) {
  this.enforceReadOnly();
  this.scheme_ = opt_decode ? goog.Uri.decodeOrEmpty_(newScheme, true) : newScheme;
  if (this.scheme_) {
    this.scheme_ = this.scheme_.replace(/:$/, "");
  }
  return this;
};
goog.Uri.prototype.hasScheme = function() {
  return !!this.scheme_;
};
goog.Uri.prototype.getUserInfo = function() {
  return this.userInfo_;
};
goog.Uri.prototype.setUserInfo = function(newUserInfo, opt_decode) {
  this.enforceReadOnly();
  this.userInfo_ = opt_decode ? goog.Uri.decodeOrEmpty_(newUserInfo) : newUserInfo;
  return this;
};
goog.Uri.prototype.hasUserInfo = function() {
  return !!this.userInfo_;
};
goog.Uri.prototype.getDomain = function() {
  return this.domain_;
};
goog.Uri.prototype.setDomain = function(newDomain, opt_decode) {
  this.enforceReadOnly();
  this.domain_ = opt_decode ? goog.Uri.decodeOrEmpty_(newDomain, true) : newDomain;
  return this;
};
goog.Uri.prototype.hasDomain = function() {
  return !!this.domain_;
};
goog.Uri.prototype.getPort = function() {
  return this.port_;
};
goog.Uri.prototype.setPort = function(newPort) {
  this.enforceReadOnly();
  if (newPort) {
    newPort = Number(newPort);
    if (isNaN(newPort) || newPort < 0) {
      throw Error("Bad port number " + newPort);
    }
    this.port_ = newPort;
  } else {
    this.port_ = null;
  }
  return this;
};
goog.Uri.prototype.hasPort = function() {
  return this.port_ != null;
};
goog.Uri.prototype.getPath = function() {
  return this.path_;
};
goog.Uri.prototype.setPath = function(newPath, opt_decode) {
  this.enforceReadOnly();
  this.path_ = opt_decode ? goog.Uri.decodeOrEmpty_(newPath, true) : newPath;
  return this;
};
goog.Uri.prototype.hasPath = function() {
  return !!this.path_;
};
goog.Uri.prototype.hasQuery = function() {
  return this.queryData_.toString() !== "";
};
goog.Uri.prototype.setQueryData = function(queryData, opt_decode) {
  this.enforceReadOnly();
  if (queryData instanceof goog.Uri.QueryData) {
    this.queryData_ = queryData;
    this.queryData_.setIgnoreCase(this.ignoreCase_);
  } else {
    if (!opt_decode) {
      queryData = goog.Uri.encodeSpecialChars_(queryData, goog.Uri.reDisallowedInQuery_);
    }
    this.queryData_ = new goog.Uri.QueryData(queryData, null, this.ignoreCase_);
  }
  return this;
};
goog.Uri.prototype.setQuery = function(newQuery, opt_decode) {
  return this.setQueryData(newQuery, opt_decode);
};
goog.Uri.prototype.getEncodedQuery = function() {
  return this.queryData_.toString();
};
goog.Uri.prototype.getDecodedQuery = function() {
  return this.queryData_.toDecodedString();
};
goog.Uri.prototype.getQueryData = function() {
  return this.queryData_;
};
goog.Uri.prototype.getQuery = function() {
  return this.getEncodedQuery();
};
goog.Uri.prototype.setParameterValue = function(key, value) {
  this.enforceReadOnly();
  this.queryData_.set(key, value);
  return this;
};
goog.Uri.prototype.setParameterValues = function(key, values) {
  this.enforceReadOnly();
  if (!goog.isArray(values)) {
    values = [String(values)];
  }
  this.queryData_.setValues(key, values);
  return this;
};
goog.Uri.prototype.getParameterValues = function(name) {
  return this.queryData_.getValues(name);
};
goog.Uri.prototype.getParameterValue = function(paramName) {
  return this.queryData_.get(paramName);
};
goog.Uri.prototype.getFragment = function() {
  return this.fragment_;
};
goog.Uri.prototype.setFragment = function(newFragment, opt_decode) {
  this.enforceReadOnly();
  this.fragment_ = opt_decode ? goog.Uri.decodeOrEmpty_(newFragment) : newFragment;
  return this;
};
goog.Uri.prototype.hasFragment = function() {
  return !!this.fragment_;
};
goog.Uri.prototype.hasSameDomainAs = function(uri2) {
  return (!this.hasDomain() && !uri2.hasDomain() || this.getDomain() == uri2.getDomain()) && (!this.hasPort() && !uri2.hasPort() || this.getPort() == uri2.getPort());
};
goog.Uri.prototype.makeUnique = function() {
  this.enforceReadOnly();
  this.setParameterValue(goog.Uri.RANDOM_PARAM, goog.string.getRandomString());
  return this;
};
goog.Uri.prototype.removeParameter = function(key) {
  this.enforceReadOnly();
  this.queryData_.remove(key);
  return this;
};
goog.Uri.prototype.setReadOnly = function(isReadOnly) {
  this.isReadOnly_ = isReadOnly;
  return this;
};
goog.Uri.prototype.isReadOnly = function() {
  return this.isReadOnly_;
};
goog.Uri.prototype.enforceReadOnly = function() {
  if (this.isReadOnly_) {
    throw Error("Tried to modify a read-only Uri");
  }
};
goog.Uri.prototype.setIgnoreCase = function(ignoreCase) {
  this.ignoreCase_ = ignoreCase;
  if (this.queryData_) {
    this.queryData_.setIgnoreCase(ignoreCase);
  }
  return this;
};
goog.Uri.prototype.getIgnoreCase = function() {
  return this.ignoreCase_;
};
goog.Uri.parse = function(uri, opt_ignoreCase) {
  return uri instanceof goog.Uri ? uri.clone() : new goog.Uri(uri, opt_ignoreCase);
};
goog.Uri.create = function(opt_scheme, opt_userInfo, opt_domain, opt_port, opt_path, opt_query, opt_fragment, opt_ignoreCase) {
  var uri = new goog.Uri(null, opt_ignoreCase);
  opt_scheme && uri.setScheme(opt_scheme);
  opt_userInfo && uri.setUserInfo(opt_userInfo);
  opt_domain && uri.setDomain(opt_domain);
  opt_port && uri.setPort(opt_port);
  opt_path && uri.setPath(opt_path);
  opt_query && uri.setQueryData(opt_query);
  opt_fragment && uri.setFragment(opt_fragment);
  return uri;
};
goog.Uri.resolve = function(base, rel) {
  if (!(base instanceof goog.Uri)) {
    base = goog.Uri.parse(base);
  }
  if (!(rel instanceof goog.Uri)) {
    rel = goog.Uri.parse(rel);
  }
  return base.resolve(rel);
};
goog.Uri.removeDotSegments = function(path) {
  if (path == ".." || path == ".") {
    return "";
  } else {
    if (!goog.string.contains(path, "./") && !goog.string.contains(path, "/.")) {
      return path;
    } else {
      var leadingSlash = goog.string.startsWith(path, "/");
      var segments = path.split("/");
      var out = [];
      for (var pos = 0; pos < segments.length;) {
        var segment = segments[pos++];
        if (segment == ".") {
          if (leadingSlash && pos == segments.length) {
            out.push("");
          }
        } else {
          if (segment == "..") {
            if (out.length > 1 || out.length == 1 && out[0] != "") {
              out.pop();
            }
            if (leadingSlash && pos == segments.length) {
              out.push("");
            }
          } else {
            out.push(segment);
            leadingSlash = true;
          }
        }
      }
      return out.join("/");
    }
  }
};
goog.Uri.decodeOrEmpty_ = function(val, opt_preserveReserved) {
  if (!val) {
    return "";
  }
  return opt_preserveReserved ? decodeURI(val.replace(/%25/g, "%2525")) : decodeURIComponent(val);
};
goog.Uri.encodeSpecialChars_ = function(unescapedPart, extra, opt_removeDoubleEncoding) {
  if (goog.isString(unescapedPart)) {
    var encoded = encodeURI(unescapedPart).replace(extra, goog.Uri.encodeChar_);
    if (opt_removeDoubleEncoding) {
      encoded = goog.Uri.removeDoubleEncoding_(encoded);
    }
    return encoded;
  }
  return null;
};
goog.Uri.encodeChar_ = function(ch) {
  var n = ch.charCodeAt(0);
  return "%" + (n >> 4 & 15).toString(16) + (n & 15).toString(16);
};
goog.Uri.removeDoubleEncoding_ = function(doubleEncodedString) {
  return doubleEncodedString.replace(/%25([0-9a-fA-F]{2})/g, "%$1");
};
goog.Uri.reDisallowedInSchemeOrUserInfo_ = /[#\/\?@]/g;
goog.Uri.reDisallowedInRelativePath_ = /[#\?:]/g;
goog.Uri.reDisallowedInAbsolutePath_ = /[#\?]/g;
goog.Uri.reDisallowedInQuery_ = /[#\?@]/g;
goog.Uri.reDisallowedInFragment_ = /#/g;
goog.Uri.haveSameDomain = function(uri1String, uri2String) {
  var pieces1 = goog.uri.utils.split(uri1String);
  var pieces2 = goog.uri.utils.split(uri2String);
  return pieces1[goog.uri.utils.ComponentIndex.DOMAIN] == pieces2[goog.uri.utils.ComponentIndex.DOMAIN] && pieces1[goog.uri.utils.ComponentIndex.PORT] == pieces2[goog.uri.utils.ComponentIndex.PORT];
};
goog.Uri.QueryData = function(opt_query, opt_uri, opt_ignoreCase) {
  this.keyMap_ = null;
  this.count_ = null;
  this.encodedQuery_ = opt_query || null;
  this.ignoreCase_ = !!opt_ignoreCase;
};
goog.Uri.QueryData.prototype.ensureKeyMapInitialized_ = function() {
  if (!this.keyMap_) {
    this.keyMap_ = new goog.structs.Map;
    this.count_ = 0;
    if (this.encodedQuery_) {
      var self = this;
      goog.uri.utils.parseQueryData(this.encodedQuery_, function(name, value) {
        self.add(goog.string.urlDecode(name), value);
      });
    }
  }
};
goog.Uri.QueryData.createFromMap = function(map, opt_uri, opt_ignoreCase) {
  var keys = goog.structs.getKeys(map);
  if (typeof keys == "undefined") {
    throw Error("Keys are undefined");
  }
  var queryData = new goog.Uri.QueryData(null, null, opt_ignoreCase);
  var values = goog.structs.getValues(map);
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    var value = values[i];
    if (!goog.isArray(value)) {
      queryData.add(key, value);
    } else {
      queryData.setValues(key, value);
    }
  }
  return queryData;
};
goog.Uri.QueryData.createFromKeysValues = function(keys, values, opt_uri, opt_ignoreCase) {
  if (keys.length != values.length) {
    throw Error("Mismatched lengths for keys/values");
  }
  var queryData = new goog.Uri.QueryData(null, null, opt_ignoreCase);
  for (var i = 0; i < keys.length; i++) {
    queryData.add(keys[i], values[i]);
  }
  return queryData;
};
goog.Uri.QueryData.prototype.getCount = function() {
  this.ensureKeyMapInitialized_();
  return this.count_;
};
goog.Uri.QueryData.prototype.add = function(key, value) {
  this.ensureKeyMapInitialized_();
  this.invalidateCache_();
  key = this.getKeyName_(key);
  var values = this.keyMap_.get(key);
  if (!values) {
    this.keyMap_.set(key, values = []);
  }
  values.push(value);
  this.count_ = goog.asserts.assertNumber(this.count_) + 1;
  return this;
};
goog.Uri.QueryData.prototype.remove = function(key) {
  this.ensureKeyMapInitialized_();
  key = this.getKeyName_(key);
  if (this.keyMap_.containsKey(key)) {
    this.invalidateCache_();
    this.count_ = goog.asserts.assertNumber(this.count_) - this.keyMap_.get(key).length;
    return this.keyMap_.remove(key);
  }
  return false;
};
goog.Uri.QueryData.prototype.clear = function() {
  this.invalidateCache_();
  this.keyMap_ = null;
  this.count_ = 0;
};
goog.Uri.QueryData.prototype.isEmpty = function() {
  this.ensureKeyMapInitialized_();
  return this.count_ == 0;
};
goog.Uri.QueryData.prototype.containsKey = function(key) {
  this.ensureKeyMapInitialized_();
  key = this.getKeyName_(key);
  return this.keyMap_.containsKey(key);
};
goog.Uri.QueryData.prototype.containsValue = function(value) {
  var vals = this.getValues();
  return goog.array.contains(vals, value);
};
goog.Uri.QueryData.prototype.forEach = function(f, opt_scope) {
  this.ensureKeyMapInitialized_();
  this.keyMap_.forEach(function(values, key) {
    goog.array.forEach(values, function(value) {
      f.call(opt_scope, value, key, this);
    }, this);
  }, this);
};
goog.Uri.QueryData.prototype.getKeys = function() {
  this.ensureKeyMapInitialized_();
  var vals = this.keyMap_.getValues();
  var keys = this.keyMap_.getKeys();
  var rv = [];
  for (var i = 0; i < keys.length; i++) {
    var val = vals[i];
    for (var j = 0; j < val.length; j++) {
      rv.push(keys[i]);
    }
  }
  return rv;
};
goog.Uri.QueryData.prototype.getValues = function(opt_key) {
  this.ensureKeyMapInitialized_();
  var rv = [];
  if (goog.isString(opt_key)) {
    if (this.containsKey(opt_key)) {
      rv = goog.array.concat(rv, this.keyMap_.get(this.getKeyName_(opt_key)));
    }
  } else {
    var values = this.keyMap_.getValues();
    for (var i = 0; i < values.length; i++) {
      rv = goog.array.concat(rv, values[i]);
    }
  }
  return rv;
};
goog.Uri.QueryData.prototype.set = function(key, value) {
  this.ensureKeyMapInitialized_();
  this.invalidateCache_();
  key = this.getKeyName_(key);
  if (this.containsKey(key)) {
    this.count_ = goog.asserts.assertNumber(this.count_) - this.keyMap_.get(key).length;
  }
  this.keyMap_.set(key, [value]);
  this.count_ = goog.asserts.assertNumber(this.count_) + 1;
  return this;
};
goog.Uri.QueryData.prototype.get = function(key, opt_default) {
  var values = key ? this.getValues(key) : [];
  if (goog.Uri.preserveParameterTypesCompatibilityFlag) {
    return values.length > 0 ? values[0] : opt_default;
  } else {
    return values.length > 0 ? String(values[0]) : opt_default;
  }
};
goog.Uri.QueryData.prototype.setValues = function(key, values) {
  this.remove(key);
  if (values.length > 0) {
    this.invalidateCache_();
    this.keyMap_.set(this.getKeyName_(key), goog.array.clone(values));
    this.count_ = goog.asserts.assertNumber(this.count_) + values.length;
  }
};
goog.Uri.QueryData.prototype.toString = function() {
  if (this.encodedQuery_) {
    return this.encodedQuery_;
  }
  if (!this.keyMap_) {
    return "";
  }
  var sb = [];
  var keys = this.keyMap_.getKeys();
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    var encodedKey = goog.string.urlEncode(key);
    var val = this.getValues(key);
    for (var j = 0; j < val.length; j++) {
      var param = encodedKey;
      if (val[j] !== "") {
        param += "\x3d" + goog.string.urlEncode(val[j]);
      }
      sb.push(param);
    }
  }
  return this.encodedQuery_ = sb.join("\x26");
};
goog.Uri.QueryData.prototype.toDecodedString = function() {
  return goog.Uri.decodeOrEmpty_(this.toString());
};
goog.Uri.QueryData.prototype.invalidateCache_ = function() {
  this.encodedQuery_ = null;
};
goog.Uri.QueryData.prototype.filterKeys = function(keys) {
  this.ensureKeyMapInitialized_();
  this.keyMap_.forEach(function(value, key) {
    if (!goog.array.contains(keys, key)) {
      this.remove(key);
    }
  }, this);
  return this;
};
goog.Uri.QueryData.prototype.clone = function() {
  var rv = new goog.Uri.QueryData;
  rv.encodedQuery_ = this.encodedQuery_;
  if (this.keyMap_) {
    rv.keyMap_ = this.keyMap_.clone();
    rv.count_ = this.count_;
  }
  return rv;
};
goog.Uri.QueryData.prototype.getKeyName_ = function(arg) {
  var keyName = String(arg);
  if (this.ignoreCase_) {
    keyName = keyName.toLowerCase();
  }
  return keyName;
};
goog.Uri.QueryData.prototype.setIgnoreCase = function(ignoreCase) {
  var resetKeys = ignoreCase && !this.ignoreCase_;
  if (resetKeys) {
    this.ensureKeyMapInitialized_();
    this.invalidateCache_();
    this.keyMap_.forEach(function(value, key) {
      var lowerCase = key.toLowerCase();
      if (key != lowerCase) {
        this.remove(key);
        this.setValues(lowerCase, value);
      }
    }, this);
  }
  this.ignoreCase_ = ignoreCase;
};
goog.Uri.QueryData.prototype.extend = function(var_args) {
  for (var i = 0; i < arguments.length; i++) {
    var data = arguments[i];
    goog.structs.forEach(data, function(value, key) {
      this.add(key, value);
    }, this);
  }
};
goog.provide("goog.math.Integer");
goog.math.Integer = function(bits, sign) {
  this.bits_ = [];
  this.sign_ = sign;
  var top = true;
  for (var i = bits.length - 1; i >= 0; i--) {
    var val = bits[i] | 0;
    if (!top || val != sign) {
      this.bits_[i] = val;
      top = false;
    }
  }
};
goog.math.Integer.IntCache_ = {};
goog.math.Integer.fromInt = function(value) {
  if (-128 <= value && value < 128) {
    var cachedObj = goog.math.Integer.IntCache_[value];
    if (cachedObj) {
      return cachedObj;
    }
  }
  var obj = new goog.math.Integer([value | 0], value < 0 ? -1 : 0);
  if (-128 <= value && value < 128) {
    goog.math.Integer.IntCache_[value] = obj;
  }
  return obj;
};
goog.math.Integer.fromNumber = function(value) {
  if (isNaN(value) || !isFinite(value)) {
    return goog.math.Integer.ZERO;
  } else {
    if (value < 0) {
      return goog.math.Integer.fromNumber(-value).negate();
    } else {
      var bits = [];
      var pow = 1;
      for (var i = 0; value >= pow; i++) {
        bits[i] = value / pow | 0;
        pow *= goog.math.Integer.TWO_PWR_32_DBL_;
      }
      return new goog.math.Integer(bits, 0);
    }
  }
};
goog.math.Integer.fromBits = function(bits) {
  var high = bits[bits.length - 1];
  return new goog.math.Integer(bits, high & 1 << 31 ? -1 : 0);
};
goog.math.Integer.fromString = function(str, opt_radix) {
  if (str.length == 0) {
    throw Error("number format error: empty string");
  }
  var radix = opt_radix || 10;
  if (radix < 2 || 36 < radix) {
    throw Error("radix out of range: " + radix);
  }
  if (str.charAt(0) == "-") {
    return goog.math.Integer.fromString(str.substring(1), radix).negate();
  } else {
    if (str.indexOf("-") >= 0) {
      throw Error('number format error: interior "-" character');
    }
  }
  var radixToPower = goog.math.Integer.fromNumber(Math.pow(radix, 8));
  var result = goog.math.Integer.ZERO;
  for (var i = 0; i < str.length; i += 8) {
    var size = Math.min(8, str.length - i);
    var value = parseInt(str.substring(i, i + size), radix);
    if (size < 8) {
      var power = goog.math.Integer.fromNumber(Math.pow(radix, size));
      result = result.multiply(power).add(goog.math.Integer.fromNumber(value));
    } else {
      result = result.multiply(radixToPower);
      result = result.add(goog.math.Integer.fromNumber(value));
    }
  }
  return result;
};
goog.math.Integer.TWO_PWR_32_DBL_ = (1 << 16) * (1 << 16);
goog.math.Integer.ZERO = goog.math.Integer.fromInt(0);
goog.math.Integer.ONE = goog.math.Integer.fromInt(1);
goog.math.Integer.TWO_PWR_24_ = goog.math.Integer.fromInt(1 << 24);
goog.math.Integer.prototype.toInt = function() {
  return this.bits_.length > 0 ? this.bits_[0] : this.sign_;
};
goog.math.Integer.prototype.toNumber = function() {
  if (this.isNegative()) {
    return -this.negate().toNumber();
  } else {
    var val = 0;
    var pow = 1;
    for (var i = 0; i < this.bits_.length; i++) {
      val += this.getBitsUnsigned(i) * pow;
      pow *= goog.math.Integer.TWO_PWR_32_DBL_;
    }
    return val;
  }
};
goog.math.Integer.prototype.toString = function(opt_radix) {
  var radix = opt_radix || 10;
  if (radix < 2 || 36 < radix) {
    throw Error("radix out of range: " + radix);
  }
  if (this.isZero()) {
    return "0";
  } else {
    if (this.isNegative()) {
      return "-" + this.negate().toString(radix);
    }
  }
  var radixToPower = goog.math.Integer.fromNumber(Math.pow(radix, 6));
  var rem = this;
  var result = "";
  while (true) {
    var remDiv = rem.divide(radixToPower);
    var intval = rem.subtract(remDiv.multiply(radixToPower)).toInt() >>> 0;
    var digits = intval.toString(radix);
    rem = remDiv;
    if (rem.isZero()) {
      return digits + result;
    } else {
      while (digits.length < 6) {
        digits = "0" + digits;
      }
      result = "" + digits + result;
    }
  }
};
goog.math.Integer.prototype.getBits = function(index) {
  if (index < 0) {
    return 0;
  } else {
    if (index < this.bits_.length) {
      return this.bits_[index];
    } else {
      return this.sign_;
    }
  }
};
goog.math.Integer.prototype.getBitsUnsigned = function(index) {
  var val = this.getBits(index);
  return val >= 0 ? val : goog.math.Integer.TWO_PWR_32_DBL_ + val;
};
goog.math.Integer.prototype.getSign = function() {
  return this.sign_;
};
goog.math.Integer.prototype.isZero = function() {
  if (this.sign_ != 0) {
    return false;
  }
  for (var i = 0; i < this.bits_.length; i++) {
    if (this.bits_[i] != 0) {
      return false;
    }
  }
  return true;
};
goog.math.Integer.prototype.isNegative = function() {
  return this.sign_ == -1;
};
goog.math.Integer.prototype.isOdd = function() {
  return this.bits_.length == 0 && this.sign_ == -1 || this.bits_.length > 0 && (this.bits_[0] & 1) != 0;
};
goog.math.Integer.prototype.equals = function(other) {
  if (this.sign_ != other.sign_) {
    return false;
  }
  var len = Math.max(this.bits_.length, other.bits_.length);
  for (var i = 0; i < len; i++) {
    if (this.getBits(i) != other.getBits(i)) {
      return false;
    }
  }
  return true;
};
goog.math.Integer.prototype.notEquals = function(other) {
  return !this.equals(other);
};
goog.math.Integer.prototype.greaterThan = function(other) {
  return this.compare(other) > 0;
};
goog.math.Integer.prototype.greaterThanOrEqual = function(other) {
  return this.compare(other) >= 0;
};
goog.math.Integer.prototype.lessThan = function(other) {
  return this.compare(other) < 0;
};
goog.math.Integer.prototype.lessThanOrEqual = function(other) {
  return this.compare(other) <= 0;
};
goog.math.Integer.prototype.compare = function(other) {
  var diff = this.subtract(other);
  if (diff.isNegative()) {
    return -1;
  } else {
    if (diff.isZero()) {
      return 0;
    } else {
      return +1;
    }
  }
};
goog.math.Integer.prototype.shorten = function(numBits) {
  var arr_index = numBits - 1 >> 5;
  var bit_index = (numBits - 1) % 32;
  var bits = [];
  for (var i = 0; i < arr_index; i++) {
    bits[i] = this.getBits(i);
  }
  var sigBits = bit_index == 31 ? 4294967295 : (1 << bit_index + 1) - 1;
  var val = this.getBits(arr_index) & sigBits;
  if (val & 1 << bit_index) {
    val |= 4294967295 - sigBits;
    bits[arr_index] = val;
    return new goog.math.Integer(bits, -1);
  } else {
    bits[arr_index] = val;
    return new goog.math.Integer(bits, 0);
  }
};
goog.math.Integer.prototype.negate = function() {
  return this.not().add(goog.math.Integer.ONE);
};
goog.math.Integer.prototype.add = function(other) {
  var len = Math.max(this.bits_.length, other.bits_.length);
  var arr = [];
  var carry = 0;
  for (var i = 0; i <= len; i++) {
    var a1 = this.getBits(i) >>> 16;
    var a0 = this.getBits(i) & 65535;
    var b1 = other.getBits(i) >>> 16;
    var b0 = other.getBits(i) & 65535;
    var c0 = carry + a0 + b0;
    var c1 = (c0 >>> 16) + a1 + b1;
    carry = c1 >>> 16;
    c0 &= 65535;
    c1 &= 65535;
    arr[i] = c1 << 16 | c0;
  }
  return goog.math.Integer.fromBits(arr);
};
goog.math.Integer.prototype.subtract = function(other) {
  return this.add(other.negate());
};
goog.math.Integer.prototype.multiply = function(other) {
  if (this.isZero()) {
    return goog.math.Integer.ZERO;
  } else {
    if (other.isZero()) {
      return goog.math.Integer.ZERO;
    }
  }
  if (this.isNegative()) {
    if (other.isNegative()) {
      return this.negate().multiply(other.negate());
    } else {
      return this.negate().multiply(other).negate();
    }
  } else {
    if (other.isNegative()) {
      return this.multiply(other.negate()).negate();
    }
  }
  if (this.lessThan(goog.math.Integer.TWO_PWR_24_) && other.lessThan(goog.math.Integer.TWO_PWR_24_)) {
    return goog.math.Integer.fromNumber(this.toNumber() * other.toNumber());
  }
  var len = this.bits_.length + other.bits_.length;
  var arr = [];
  for (var i = 0; i < 2 * len; i++) {
    arr[i] = 0;
  }
  for (var i = 0; i < this.bits_.length; i++) {
    for (var j = 0; j < other.bits_.length; j++) {
      var a1 = this.getBits(i) >>> 16;
      var a0 = this.getBits(i) & 65535;
      var b1 = other.getBits(j) >>> 16;
      var b0 = other.getBits(j) & 65535;
      arr[2 * i + 2 * j] += a0 * b0;
      goog.math.Integer.carry16_(arr, 2 * i + 2 * j);
      arr[2 * i + 2 * j + 1] += a1 * b0;
      goog.math.Integer.carry16_(arr, 2 * i + 2 * j + 1);
      arr[2 * i + 2 * j + 1] += a0 * b1;
      goog.math.Integer.carry16_(arr, 2 * i + 2 * j + 1);
      arr[2 * i + 2 * j + 2] += a1 * b1;
      goog.math.Integer.carry16_(arr, 2 * i + 2 * j + 2);
    }
  }
  for (var i = 0; i < len; i++) {
    arr[i] = arr[2 * i + 1] << 16 | arr[2 * i];
  }
  for (var i = len; i < 2 * len; i++) {
    arr[i] = 0;
  }
  return new goog.math.Integer(arr, 0);
};
goog.math.Integer.carry16_ = function(bits, index) {
  while ((bits[index] & 65535) != bits[index]) {
    bits[index + 1] += bits[index] >>> 16;
    bits[index] &= 65535;
    index++;
  }
};
goog.math.Integer.prototype.slowDivide_ = function(other) {
  if (this.isNegative() || other.isNegative()) {
    throw Error("slowDivide_ only works with positive integers.");
  }
  var twoPower = goog.math.Integer.ONE;
  var multiple = other;
  while (multiple.lessThanOrEqual(this)) {
    twoPower = twoPower.shiftLeft(1);
    multiple = multiple.shiftLeft(1);
  }
  var res = twoPower.shiftRight(1);
  var total = multiple.shiftRight(1);
  var total2;
  multiple = multiple.shiftRight(2);
  twoPower = twoPower.shiftRight(2);
  while (!multiple.isZero()) {
    total2 = total.add(multiple);
    if (total2.lessThanOrEqual(this)) {
      res = res.add(twoPower);
      total = total2;
    }
    multiple = multiple.shiftRight(1);
    twoPower = twoPower.shiftRight(1);
  }
  return res;
};
goog.math.Integer.prototype.divide = function(other) {
  if (other.isZero()) {
    throw Error("division by zero");
  } else {
    if (this.isZero()) {
      return goog.math.Integer.ZERO;
    }
  }
  if (this.isNegative()) {
    if (other.isNegative()) {
      return this.negate().divide(other.negate());
    } else {
      return this.negate().divide(other).negate();
    }
  } else {
    if (other.isNegative()) {
      return this.divide(other.negate()).negate();
    }
  }
  if (this.bits_.length > 30) {
    return this.slowDivide_(other);
  }
  var res = goog.math.Integer.ZERO;
  var rem = this;
  while (rem.greaterThanOrEqual(other)) {
    var approx = Math.max(1, Math.floor(rem.toNumber() / other.toNumber()));
    var log2 = Math.ceil(Math.log(approx) / Math.LN2);
    var delta = log2 <= 48 ? 1 : Math.pow(2, log2 - 48);
    var approxRes = goog.math.Integer.fromNumber(approx);
    var approxRem = approxRes.multiply(other);
    while (approxRem.isNegative() || approxRem.greaterThan(rem)) {
      approx -= delta;
      approxRes = goog.math.Integer.fromNumber(approx);
      approxRem = approxRes.multiply(other);
    }
    if (approxRes.isZero()) {
      approxRes = goog.math.Integer.ONE;
    }
    res = res.add(approxRes);
    rem = rem.subtract(approxRem);
  }
  return res;
};
goog.math.Integer.prototype.modulo = function(other) {
  return this.subtract(this.divide(other).multiply(other));
};
goog.math.Integer.prototype.not = function() {
  var len = this.bits_.length;
  var arr = [];
  for (var i = 0; i < len; i++) {
    arr[i] = ~this.bits_[i];
  }
  return new goog.math.Integer(arr, ~this.sign_);
};
goog.math.Integer.prototype.and = function(other) {
  var len = Math.max(this.bits_.length, other.bits_.length);
  var arr = [];
  for (var i = 0; i < len; i++) {
    arr[i] = this.getBits(i) & other.getBits(i);
  }
  return new goog.math.Integer(arr, this.sign_ & other.sign_);
};
goog.math.Integer.prototype.or = function(other) {
  var len = Math.max(this.bits_.length, other.bits_.length);
  var arr = [];
  for (var i = 0; i < len; i++) {
    arr[i] = this.getBits(i) | other.getBits(i);
  }
  return new goog.math.Integer(arr, this.sign_ | other.sign_);
};
goog.math.Integer.prototype.xor = function(other) {
  var len = Math.max(this.bits_.length, other.bits_.length);
  var arr = [];
  for (var i = 0; i < len; i++) {
    arr[i] = this.getBits(i) ^ other.getBits(i);
  }
  return new goog.math.Integer(arr, this.sign_ ^ other.sign_);
};
goog.math.Integer.prototype.shiftLeft = function(numBits) {
  var arr_delta = numBits >> 5;
  var bit_delta = numBits % 32;
  var len = this.bits_.length + arr_delta + (bit_delta > 0 ? 1 : 0);
  var arr = [];
  for (var i = 0; i < len; i++) {
    if (bit_delta > 0) {
      arr[i] = this.getBits(i - arr_delta) << bit_delta | this.getBits(i - arr_delta - 1) >>> 32 - bit_delta;
    } else {
      arr[i] = this.getBits(i - arr_delta);
    }
  }
  return new goog.math.Integer(arr, this.sign_);
};
goog.math.Integer.prototype.shiftRight = function(numBits) {
  var arr_delta = numBits >> 5;
  var bit_delta = numBits % 32;
  var len = this.bits_.length - arr_delta;
  var arr = [];
  for (var i = 0; i < len; i++) {
    if (bit_delta > 0) {
      arr[i] = this.getBits(i + arr_delta) >>> bit_delta | this.getBits(i + arr_delta + 1) << 32 - bit_delta;
    } else {
      arr[i] = this.getBits(i + arr_delta);
    }
  }
  return new goog.math.Integer(arr, this.sign_);
};
goog.provide("goog.string.StringBuffer");
goog.string.StringBuffer = function(opt_a1, var_args) {
  if (opt_a1 != null) {
    this.append.apply(this, arguments);
  }
};
goog.string.StringBuffer.prototype.buffer_ = "";
goog.string.StringBuffer.prototype.set = function(s) {
  this.buffer_ = "" + s;
};
goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
  this.buffer_ += String(a1);
  if (opt_a2 != null) {
    for (var i = 1; i < arguments.length; i++) {
      this.buffer_ += arguments[i];
    }
  }
  return this;
};
goog.string.StringBuffer.prototype.clear = function() {
  this.buffer_ = "";
};
goog.string.StringBuffer.prototype.getLength = function() {
  return this.buffer_.length;
};
goog.string.StringBuffer.prototype.toString = function() {
  return this.buffer_;
};
goog.provide("goog.reflect");
goog.reflect.object = function(type, object) {
  return object;
};
goog.reflect.objectProperty = function(prop, object) {
  return prop;
};
goog.reflect.sinkValue = function(x) {
  goog.reflect.sinkValue[" "](x);
  return x;
};
goog.reflect.sinkValue[" "] = goog.nullFunction;
goog.reflect.canAccessProperty = function(obj, prop) {
  try {
    goog.reflect.sinkValue(obj[prop]);
    return true;
  } catch (e) {
  }
  return false;
};
goog.reflect.cache = function(cacheObj, key, valueFn, opt_keyFn) {
  var storedKey = opt_keyFn ? opt_keyFn(key) : key;
  if (Object.prototype.hasOwnProperty.call(cacheObj, storedKey)) {
    return cacheObj[storedKey];
  }
  return cacheObj[storedKey] = valueFn(key);
};
goog.provide("goog.math.Long");
goog.require("goog.asserts");
goog.require("goog.reflect");
goog.math.Long = function(low, high) {
  this.low_ = low | 0;
  this.high_ = high | 0;
};
goog.math.Long.IntCache_ = {};
goog.math.Long.valueCache_ = {};
goog.math.Long.getCachedIntValue_ = function(value) {
  return goog.reflect.cache(goog.math.Long.IntCache_, value, function(val) {
    return new goog.math.Long(val, val < 0 ? -1 : 0);
  });
};
goog.math.Long.MAX_VALUE_FOR_RADIX_ = ["", "", "111111111111111111111111111111111111111111111111111111111111111", "2021110011022210012102010021220101220221", "13333333333333333333333333333333", "1104332401304422434310311212", "1540241003031030222122211", "22341010611245052052300", "777777777777777777777", "67404283172107811827", "9223372036854775807", "1728002635214590697", "41a792678515120367", "10b269549075433c37", "4340724c6c71dc7a7", "160e2ad3246366807", "7fffffffffffffff", "33d3d8307b214008", 
"16agh595df825fa7", "ba643dci0ffeehh", "5cbfjia3fh26ja7", "2heiciiie82dh97", "1adaibb21dckfa7", "i6k448cf4192c2", "acd772jnc9l0l7", "64ie1focnn5g77", "3igoecjbmca687", "27c48l5b37oaop", "1bk39f3ah3dmq7", "q1se8f0m04isb", "hajppbc1fc207", "bm03i95hia437", "7vvvvvvvvvvvv", "5hg4ck9jd4u37", "3tdtk1v8j6tpp", "2pijmikexrxp7", "1y2p0ij32e8e7"];
goog.math.Long.MIN_VALUE_FOR_RADIX_ = ["", "", "-1000000000000000000000000000000000000000000000000000000000000000", "-2021110011022210012102010021220101220222", "-20000000000000000000000000000000", "-1104332401304422434310311213", "-1540241003031030222122212", "-22341010611245052052301", "-1000000000000000000000", "-67404283172107811828", "-9223372036854775808", "-1728002635214590698", "-41a792678515120368", "-10b269549075433c38", "-4340724c6c71dc7a8", "-160e2ad3246366808", "-8000000000000000", "-33d3d8307b214009", 
"-16agh595df825fa8", "-ba643dci0ffeehi", "-5cbfjia3fh26ja8", "-2heiciiie82dh98", "-1adaibb21dckfa8", "-i6k448cf4192c3", "-acd772jnc9l0l8", "-64ie1focnn5g78", "-3igoecjbmca688", "-27c48l5b37oaoq", "-1bk39f3ah3dmq8", "-q1se8f0m04isc", "-hajppbc1fc208", "-bm03i95hia438", "-8000000000000", "-5hg4ck9jd4u38", "-3tdtk1v8j6tpq", "-2pijmikexrxp8", "-1y2p0ij32e8e8"];
goog.math.Long.fromInt = function(value) {
  var intValue = value | 0;
  goog.asserts.assert(value === intValue, "value should be a 32-bit integer");
  if (-128 <= intValue && intValue < 128) {
    return goog.math.Long.getCachedIntValue_(intValue);
  } else {
    return new goog.math.Long(intValue, intValue < 0 ? -1 : 0);
  }
};
goog.math.Long.fromNumber = function(value) {
  if (isNaN(value)) {
    return goog.math.Long.getZero();
  } else {
    if (value <= -goog.math.Long.TWO_PWR_63_DBL_) {
      return goog.math.Long.getMinValue();
    } else {
      if (value + 1 >= goog.math.Long.TWO_PWR_63_DBL_) {
        return goog.math.Long.getMaxValue();
      } else {
        if (value < 0) {
          return goog.math.Long.fromNumber(-value).negate();
        } else {
          return new goog.math.Long(value % goog.math.Long.TWO_PWR_32_DBL_ | 0, value / goog.math.Long.TWO_PWR_32_DBL_ | 0);
        }
      }
    }
  }
};
goog.math.Long.fromBits = function(lowBits, highBits) {
  return new goog.math.Long(lowBits, highBits);
};
goog.math.Long.fromString = function(str, opt_radix) {
  if (str.length == 0) {
    throw Error("number format error: empty string");
  }
  var radix = opt_radix || 10;
  if (radix < 2 || 36 < radix) {
    throw Error("radix out of range: " + radix);
  }
  if (str.charAt(0) == "-") {
    return goog.math.Long.fromString(str.substring(1), radix).negate();
  } else {
    if (str.indexOf("-") >= 0) {
      throw Error('number format error: interior "-" character: ' + str);
    }
  }
  var radixToPower = goog.math.Long.fromNumber(Math.pow(radix, 8));
  var result = goog.math.Long.getZero();
  for (var i = 0; i < str.length; i += 8) {
    var size = Math.min(8, str.length - i);
    var value = parseInt(str.substring(i, i + size), radix);
    if (size < 8) {
      var power = goog.math.Long.fromNumber(Math.pow(radix, size));
      result = result.multiply(power).add(goog.math.Long.fromNumber(value));
    } else {
      result = result.multiply(radixToPower);
      result = result.add(goog.math.Long.fromNumber(value));
    }
  }
  return result;
};
goog.math.Long.isStringInRange = function(str, opt_radix) {
  var radix = opt_radix || 10;
  if (radix < 2 || 36 < radix) {
    throw Error("radix out of range: " + radix);
  }
  var extremeValue = str.charAt(0) == "-" ? goog.math.Long.MIN_VALUE_FOR_RADIX_[radix] : goog.math.Long.MAX_VALUE_FOR_RADIX_[radix];
  if (str.length < extremeValue.length) {
    return true;
  } else {
    if (str.length == extremeValue.length && str <= extremeValue) {
      return true;
    } else {
      return false;
    }
  }
};
goog.math.Long.TWO_PWR_16_DBL_ = 1 << 16;
goog.math.Long.TWO_PWR_32_DBL_ = goog.math.Long.TWO_PWR_16_DBL_ * goog.math.Long.TWO_PWR_16_DBL_;
goog.math.Long.TWO_PWR_64_DBL_ = goog.math.Long.TWO_PWR_32_DBL_ * goog.math.Long.TWO_PWR_32_DBL_;
goog.math.Long.TWO_PWR_63_DBL_ = goog.math.Long.TWO_PWR_64_DBL_ / 2;
goog.math.Long.getZero = function() {
  return goog.math.Long.getCachedIntValue_(0);
};
goog.math.Long.getOne = function() {
  return goog.math.Long.getCachedIntValue_(1);
};
goog.math.Long.getNegOne = function() {
  return goog.math.Long.getCachedIntValue_(-1);
};
goog.math.Long.getMaxValue = function() {
  return goog.reflect.cache(goog.math.Long.valueCache_, goog.math.Long.ValueCacheId_.MAX_VALUE, function() {
    return goog.math.Long.fromBits(4294967295 | 0, 2147483647 | 0);
  });
};
goog.math.Long.getMinValue = function() {
  return goog.reflect.cache(goog.math.Long.valueCache_, goog.math.Long.ValueCacheId_.MIN_VALUE, function() {
    return goog.math.Long.fromBits(0, 2147483648 | 0);
  });
};
goog.math.Long.getTwoPwr24 = function() {
  return goog.reflect.cache(goog.math.Long.valueCache_, goog.math.Long.ValueCacheId_.TWO_PWR_24, function() {
    return goog.math.Long.fromInt(1 << 24);
  });
};
goog.math.Long.prototype.toInt = function() {
  return this.low_;
};
goog.math.Long.prototype.toNumber = function() {
  return this.high_ * goog.math.Long.TWO_PWR_32_DBL_ + this.getLowBitsUnsigned();
};
goog.math.Long.prototype.toString = function(opt_radix) {
  var radix = opt_radix || 10;
  if (radix < 2 || 36 < radix) {
    throw Error("radix out of range: " + radix);
  }
  if (this.isZero()) {
    return "0";
  }
  if (this.isNegative()) {
    if (this.equals(goog.math.Long.getMinValue())) {
      var radixLong = goog.math.Long.fromNumber(radix);
      var div = this.div(radixLong);
      var rem = div.multiply(radixLong).subtract(this);
      return div.toString(radix) + rem.toInt().toString(radix);
    } else {
      return "-" + this.negate().toString(radix);
    }
  }
  var radixToPower = goog.math.Long.fromNumber(Math.pow(radix, 6));
  var rem = this;
  var result = "";
  while (true) {
    var remDiv = rem.div(radixToPower);
    var intval = rem.subtract(remDiv.multiply(radixToPower)).toInt() >>> 0;
    var digits = intval.toString(radix);
    rem = remDiv;
    if (rem.isZero()) {
      return digits + result;
    } else {
      while (digits.length < 6) {
        digits = "0" + digits;
      }
      result = "" + digits + result;
    }
  }
};
goog.math.Long.prototype.getHighBits = function() {
  return this.high_;
};
goog.math.Long.prototype.getLowBits = function() {
  return this.low_;
};
goog.math.Long.prototype.getLowBitsUnsigned = function() {
  return this.low_ >= 0 ? this.low_ : goog.math.Long.TWO_PWR_32_DBL_ + this.low_;
};
goog.math.Long.prototype.getNumBitsAbs = function() {
  if (this.isNegative()) {
    if (this.equals(goog.math.Long.getMinValue())) {
      return 64;
    } else {
      return this.negate().getNumBitsAbs();
    }
  } else {
    var val = this.high_ != 0 ? this.high_ : this.low_;
    for (var bit = 31; bit > 0; bit--) {
      if ((val & 1 << bit) != 0) {
        break;
      }
    }
    return this.high_ != 0 ? bit + 33 : bit + 1;
  }
};
goog.math.Long.prototype.isZero = function() {
  return this.high_ == 0 && this.low_ == 0;
};
goog.math.Long.prototype.isNegative = function() {
  return this.high_ < 0;
};
goog.math.Long.prototype.isOdd = function() {
  return (this.low_ & 1) == 1;
};
goog.math.Long.prototype.equals = function(other) {
  return this.high_ == other.high_ && this.low_ == other.low_;
};
goog.math.Long.prototype.notEquals = function(other) {
  return this.high_ != other.high_ || this.low_ != other.low_;
};
goog.math.Long.prototype.lessThan = function(other) {
  return this.compare(other) < 0;
};
goog.math.Long.prototype.lessThanOrEqual = function(other) {
  return this.compare(other) <= 0;
};
goog.math.Long.prototype.greaterThan = function(other) {
  return this.compare(other) > 0;
};
goog.math.Long.prototype.greaterThanOrEqual = function(other) {
  return this.compare(other) >= 0;
};
goog.math.Long.prototype.compare = function(other) {
  if (this.equals(other)) {
    return 0;
  }
  var thisNeg = this.isNegative();
  var otherNeg = other.isNegative();
  if (thisNeg && !otherNeg) {
    return -1;
  }
  if (!thisNeg && otherNeg) {
    return 1;
  }
  if (this.subtract(other).isNegative()) {
    return -1;
  } else {
    return 1;
  }
};
goog.math.Long.prototype.negate = function() {
  if (this.equals(goog.math.Long.getMinValue())) {
    return goog.math.Long.getMinValue();
  } else {
    return this.not().add(goog.math.Long.getOne());
  }
};
goog.math.Long.prototype.add = function(other) {
  var a48 = this.high_ >>> 16;
  var a32 = this.high_ & 65535;
  var a16 = this.low_ >>> 16;
  var a00 = this.low_ & 65535;
  var b48 = other.high_ >>> 16;
  var b32 = other.high_ & 65535;
  var b16 = other.low_ >>> 16;
  var b00 = other.low_ & 65535;
  var c48 = 0, c32 = 0, c16 = 0, c00 = 0;
  c00 += a00 + b00;
  c16 += c00 >>> 16;
  c00 &= 65535;
  c16 += a16 + b16;
  c32 += c16 >>> 16;
  c16 &= 65535;
  c32 += a32 + b32;
  c48 += c32 >>> 16;
  c32 &= 65535;
  c48 += a48 + b48;
  c48 &= 65535;
  return goog.math.Long.fromBits(c16 << 16 | c00, c48 << 16 | c32);
};
goog.math.Long.prototype.subtract = function(other) {
  return this.add(other.negate());
};
goog.math.Long.prototype.multiply = function(other) {
  if (this.isZero()) {
    return goog.math.Long.getZero();
  } else {
    if (other.isZero()) {
      return goog.math.Long.getZero();
    }
  }
  if (this.equals(goog.math.Long.getMinValue())) {
    return other.isOdd() ? goog.math.Long.getMinValue() : goog.math.Long.getZero();
  } else {
    if (other.equals(goog.math.Long.getMinValue())) {
      return this.isOdd() ? goog.math.Long.getMinValue() : goog.math.Long.getZero();
    }
  }
  if (this.isNegative()) {
    if (other.isNegative()) {
      return this.negate().multiply(other.negate());
    } else {
      return this.negate().multiply(other).negate();
    }
  } else {
    if (other.isNegative()) {
      return this.multiply(other.negate()).negate();
    }
  }
  if (this.lessThan(goog.math.Long.getTwoPwr24()) && other.lessThan(goog.math.Long.getTwoPwr24())) {
    return goog.math.Long.fromNumber(this.toNumber() * other.toNumber());
  }
  var a48 = this.high_ >>> 16;
  var a32 = this.high_ & 65535;
  var a16 = this.low_ >>> 16;
  var a00 = this.low_ & 65535;
  var b48 = other.high_ >>> 16;
  var b32 = other.high_ & 65535;
  var b16 = other.low_ >>> 16;
  var b00 = other.low_ & 65535;
  var c48 = 0, c32 = 0, c16 = 0, c00 = 0;
  c00 += a00 * b00;
  c16 += c00 >>> 16;
  c00 &= 65535;
  c16 += a16 * b00;
  c32 += c16 >>> 16;
  c16 &= 65535;
  c16 += a00 * b16;
  c32 += c16 >>> 16;
  c16 &= 65535;
  c32 += a32 * b00;
  c48 += c32 >>> 16;
  c32 &= 65535;
  c32 += a16 * b16;
  c48 += c32 >>> 16;
  c32 &= 65535;
  c32 += a00 * b32;
  c48 += c32 >>> 16;
  c32 &= 65535;
  c48 += a48 * b00 + a32 * b16 + a16 * b32 + a00 * b48;
  c48 &= 65535;
  return goog.math.Long.fromBits(c16 << 16 | c00, c48 << 16 | c32);
};
goog.math.Long.prototype.div = function(other) {
  if (other.isZero()) {
    throw Error("division by zero");
  } else {
    if (this.isZero()) {
      return goog.math.Long.getZero();
    }
  }
  if (this.equals(goog.math.Long.getMinValue())) {
    if (other.equals(goog.math.Long.getOne()) || other.equals(goog.math.Long.getNegOne())) {
      return goog.math.Long.getMinValue();
    } else {
      if (other.equals(goog.math.Long.getMinValue())) {
        return goog.math.Long.getOne();
      } else {
        var halfThis = this.shiftRight(1);
        var approx = halfThis.div(other).shiftLeft(1);
        if (approx.equals(goog.math.Long.getZero())) {
          return other.isNegative() ? goog.math.Long.getOne() : goog.math.Long.getNegOne();
        } else {
          var rem = this.subtract(other.multiply(approx));
          var result = approx.add(rem.div(other));
          return result;
        }
      }
    }
  } else {
    if (other.equals(goog.math.Long.getMinValue())) {
      return goog.math.Long.getZero();
    }
  }
  if (this.isNegative()) {
    if (other.isNegative()) {
      return this.negate().div(other.negate());
    } else {
      return this.negate().div(other).negate();
    }
  } else {
    if (other.isNegative()) {
      return this.div(other.negate()).negate();
    }
  }
  var res = goog.math.Long.getZero();
  var rem = this;
  while (rem.greaterThanOrEqual(other)) {
    var approx = Math.max(1, Math.floor(rem.toNumber() / other.toNumber()));
    var log2 = Math.ceil(Math.log(approx) / Math.LN2);
    var delta = log2 <= 48 ? 1 : Math.pow(2, log2 - 48);
    var approxRes = goog.math.Long.fromNumber(approx);
    var approxRem = approxRes.multiply(other);
    while (approxRem.isNegative() || approxRem.greaterThan(rem)) {
      approx -= delta;
      approxRes = goog.math.Long.fromNumber(approx);
      approxRem = approxRes.multiply(other);
    }
    if (approxRes.isZero()) {
      approxRes = goog.math.Long.getOne();
    }
    res = res.add(approxRes);
    rem = rem.subtract(approxRem);
  }
  return res;
};
goog.math.Long.prototype.modulo = function(other) {
  return this.subtract(this.div(other).multiply(other));
};
goog.math.Long.prototype.not = function() {
  return goog.math.Long.fromBits(~this.low_, ~this.high_);
};
goog.math.Long.prototype.and = function(other) {
  return goog.math.Long.fromBits(this.low_ & other.low_, this.high_ & other.high_);
};
goog.math.Long.prototype.or = function(other) {
  return goog.math.Long.fromBits(this.low_ | other.low_, this.high_ | other.high_);
};
goog.math.Long.prototype.xor = function(other) {
  return goog.math.Long.fromBits(this.low_ ^ other.low_, this.high_ ^ other.high_);
};
goog.math.Long.prototype.shiftLeft = function(numBits) {
  numBits &= 63;
  if (numBits == 0) {
    return this;
  } else {
    var low = this.low_;
    if (numBits < 32) {
      var high = this.high_;
      return goog.math.Long.fromBits(low << numBits, high << numBits | low >>> 32 - numBits);
    } else {
      return goog.math.Long.fromBits(0, low << numBits - 32);
    }
  }
};
goog.math.Long.prototype.shiftRight = function(numBits) {
  numBits &= 63;
  if (numBits == 0) {
    return this;
  } else {
    var high = this.high_;
    if (numBits < 32) {
      var low = this.low_;
      return goog.math.Long.fromBits(low >>> numBits | high << 32 - numBits, high >> numBits);
    } else {
      return goog.math.Long.fromBits(high >> numBits - 32, high >= 0 ? 0 : -1);
    }
  }
};
goog.math.Long.prototype.shiftRightUnsigned = function(numBits) {
  numBits &= 63;
  if (numBits == 0) {
    return this;
  } else {
    var high = this.high_;
    if (numBits < 32) {
      var low = this.low_;
      return goog.math.Long.fromBits(low >>> numBits | high << 32 - numBits, high >>> numBits);
    } else {
      if (numBits == 32) {
        return goog.math.Long.fromBits(high, 0);
      } else {
        return goog.math.Long.fromBits(high >>> numBits - 32, 0);
      }
    }
  }
};
goog.math.Long.ValueCacheId_ = {MAX_VALUE:1, MIN_VALUE:2, TWO_PWR_24:6};
goog.provide("cljs.core");
goog.require("goog.math.Long");
goog.require("goog.math.Integer");
goog.require("goog.string");
goog.require("goog.object");
goog.require("goog.array");
goog.require("goog.Uri");
goog.require("goog.string.StringBuffer");
cljs.core._STAR_clojurescript_version_STAR_ = "1.10.238";
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_unchecked_arrays_STAR_ = false;
cljs.core._STAR_warn_on_infer_STAR_ = false;
if (typeof cljs.core.PROTOCOL_SENTINEL !== "undefined") {
} else {
  cljs.core.PROTOCOL_SENTINEL = {};
}
cljs.core.MODULE_URIS = null;
cljs.core.MODULE_INFOS = null;
goog.define("cljs.core._STAR_target_STAR_", "default");
cljs.core._STAR_ns_STAR_ = null;
cljs.core._STAR_out_STAR_ = null;
cljs.core._STAR_assert_STAR_ = true;
if (typeof cljs.core._STAR_print_fn_STAR_ !== "undefined") {
} else {
  cljs.core._STAR_print_fn_STAR_ = null;
}
cljs.core._STAR_exec_tap_fn_STAR_ = function cljs$core$_STAR_exec_tap_fn_STAR_(f) {
  var and__3911__auto__ = typeof setTimeout !== "undefined";
  if (and__3911__auto__) {
    var and__3911__auto____$1 = setTimeout(f, 0);
    if (cljs.core.truth_(and__3911__auto____$1)) {
      return true;
    } else {
      return and__3911__auto____$1;
    }
  } else {
    return and__3911__auto__;
  }
};
if (typeof cljs.core._STAR_print_err_fn_STAR_ !== "undefined") {
} else {
  cljs.core._STAR_print_err_fn_STAR_ = null;
}
cljs.core.set_print_fn_BANG_ = function cljs$core$set_print_fn_BANG_(f) {
  return cljs.core._STAR_print_fn_STAR_ = f;
};
cljs.core.set_print_err_fn_BANG_ = function cljs$core$set_print_err_fn_BANG_(f) {
  return cljs.core._STAR_print_err_fn_STAR_ = f;
};
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core._STAR_print_namespace_maps_STAR_ = false;
cljs.core._STAR_print_length_STAR_ = null;
cljs.core._STAR_print_level_STAR_ = null;
cljs.core._STAR_print_fn_bodies_STAR_ = false;
if (typeof cljs.core._STAR_loaded_libs_STAR_ !== "undefined") {
} else {
  cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = function cljs$core$pr_opts() {
  return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null, "flush-on-newline", "flush-on-newline", -151457939), cljs.core._STAR_flush_on_newline_STAR_, new cljs.core.Keyword(null, "readably", "readably", 1129599760), cljs.core._STAR_print_readably_STAR_, new cljs.core.Keyword(null, "meta", "meta", 1499536964), cljs.core._STAR_print_meta_STAR_, new cljs.core.Keyword(null, "dup", "dup", 556298533), cljs.core._STAR_print_dup_STAR_, new cljs.core.Keyword(null, "print-length", "print-length", 
  1931866356), cljs.core._STAR_print_length_STAR_], null);
};
cljs.core.enable_console_print_BANG_ = function cljs$core$enable_console_print_BANG_() {
  cljs.core._STAR_print_newline_STAR_ = false;
  cljs.core.set_print_fn_BANG_(function() {
    var xs = arguments;
    return console.log.apply(console, goog.array.clone(xs));
  });
  cljs.core.set_print_err_fn_BANG_(function() {
    var xs = arguments;
    return console.error.apply(console, goog.array.clone(xs));
  });
  return null;
};
cljs.core.truth_ = function cljs$core$truth_(x) {
  return x != null && x !== false;
};
cljs.core.not_native = null;
cljs.core.identical_QMARK_ = function cljs$core$identical_QMARK_(x, y) {
  return x === y;
};
cljs.core.nil_QMARK_ = function cljs$core$nil_QMARK_(x) {
  return x == null;
};
cljs.core.array_QMARK_ = function cljs$core$array_QMARK_(x) {
  if (cljs.core._STAR_target_STAR_ === "nodejs") {
    return Array.isArray(x);
  } else {
    return x instanceof Array;
  }
};
cljs.core.number_QMARK_ = function cljs$core$number_QMARK_(x) {
  return typeof x === "number";
};
cljs.core.not = function cljs$core$not(x) {
  if (x == null) {
    return true;
  } else {
    if (x === false) {
      return true;
    } else {
      return false;
    }
  }
};
cljs.core.some_QMARK_ = function cljs$core$some_QMARK_(x) {
  return !(x == null);
};
cljs.core.object_QMARK_ = function cljs$core$object_QMARK_(x) {
  if (!(x == null)) {
    return x.constructor === Object;
  } else {
    return false;
  }
};
cljs.core.string_QMARK_ = function cljs$core$string_QMARK_(x) {
  return goog.isString(x);
};
cljs.core.char_QMARK_ = function cljs$core$char_QMARK_(x) {
  return typeof x === "string" && 1 === x.length;
};
cljs.core.any_QMARK_ = function cljs$core$any_QMARK_(x) {
  return true;
};
cljs.core.native_satisfies_QMARK_ = function cljs$core$native_satisfies_QMARK_(p, x) {
  var x__$1 = x == null ? null : x;
  if (p[goog.typeOf(x__$1)]) {
    return true;
  } else {
    if (p["_"]) {
      return true;
    } else {
      return false;
    }
  }
};
cljs.core.is_proto_ = function cljs$core$is_proto_(x) {
  return x.constructor.prototype === x;
};
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core._STAR_command_line_args_STAR_ = null;
cljs.core.type = function cljs$core$type(x) {
  if (x == null) {
    return null;
  } else {
    return x.constructor;
  }
};
cljs.core.missing_protocol = function cljs$core$missing_protocol(proto, obj) {
  var ty = cljs.core.type(obj);
  var ty__$1 = cljs.core.truth_(function() {
    var and__3911__auto__ = ty;
    if (cljs.core.truth_(and__3911__auto__)) {
      return ty.cljs$lang$type;
    } else {
      return and__3911__auto__;
    }
  }()) ? ty.cljs$lang$ctorStr : goog.typeOf(obj);
  return new Error(["No protocol method ", proto, " defined for type ", ty__$1, ": ", obj].join(""));
};
cljs.core.type__GT_str = function cljs$core$type__GT_str(ty) {
  var temp__5455__auto__ = ty.cljs$lang$ctorStr;
  if (cljs.core.truth_(temp__5455__auto__)) {
    var s = temp__5455__auto__;
    return s;
  } else {
    return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ty)].join("");
  }
};
cljs.core.load_file = function cljs$core$load_file(file) {
  if (cljs.core.truth_(COMPILED)) {
    return null;
  } else {
    return goog.nodeGlobalRequire(file);
  }
};
if (typeof Symbol !== "undefined" && goog.typeOf(Symbol) === "function") {
  cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
  cljs.core.ITER_SYMBOL = "@@iterator";
}
cljs.core.CHAR_MAP = {"]":"_RBRACK_", "'":"_SINGLEQUOTE_", "\x3d":"_EQ_", '"':"_DOUBLEQUOTE_", "!":"_BANG_", "*":"_STAR_", "%":"_PERCENT_", "|":"_BAR_", "~":"_TILDE_", "/":"_SLASH_", "\\":"_BSLASH_", "-":"_", "?":"_QMARK_", "\x26":"_AMPERSAND_", ":":"_COLON_", "\x3c":"_LT_", "{":"_LBRACE_", "}":"_RBRACE_", "[":"_LBRACK_", "#":"_SHARP_", "^":"_CARET_", "+":"_PLUS_", "@":"_CIRCA_", "\x3e":"_GT_"};
cljs.core.DEMUNGE_MAP = {"_RBRACE_":"}", "_COLON_":":", "_BANG_":"!", "_QMARK_":"?", "_BSLASH_":"\\\\", "_SLASH_":"/", "_PERCENT_":"%", "_PLUS_":"+", "_SHARP_":"#", "_LBRACE_":"{", "_BAR_":"|", "_LBRACK_":"[", "_EQ_":"\x3d", "_":"-", "_TILDE_":"~", "_RBRACK_":"]", "_GT_":"\x3e", "_SINGLEQUOTE_":"'", "_CIRCA_":"@", "_AMPERSAND_":"\x26", "_DOUBLEQUOTE_":'\\"', "_CARET_":"^", "_LT_":"\x3c", "_STAR_":"*"};
cljs.core.DEMUNGE_PATTERN = null;
cljs.core.system_time = function cljs$core$system_time() {
  if (typeof performance !== "undefined" && !(performance.now == null)) {
    return performance.now();
  } else {
    if (typeof process !== "undefined" && !(process.hrtime == null)) {
      var t = process.hrtime();
      return (t[0] * 1.0E9 + t[1]) / 1000000.0;
    } else {
      return (new Date).getTime();
    }
  }
};
cljs.core.make_array = function cljs$core$make_array(var_args) {
  var G__4372 = arguments.length;
  switch(G__4372) {
    case 1:
      return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4374 = arguments.length;
      var i__4500__auto___4375 = 0;
      while (true) {
        if (i__4500__auto___4375 < len__4499__auto___4374) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4375]);
          var G__4376 = i__4500__auto___4375 + 1;
          i__4500__auto___4375 = G__4376;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = function(size) {
  return new Array(size);
};
cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = function(type, size) {
  return new Array(size);
};
cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic = function(type, size, more_sizes) {
  var dims = more_sizes;
  var dimarray = new Array(size);
  var n__4376__auto___4377 = dimarray.length;
  var i_4378 = 0;
  while (true) {
    if (i_4378 < n__4376__auto___4377) {
      dimarray[i_4378] = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.make_array, null, dims);
      var G__4379 = i_4378 + 1;
      i_4378 = G__4379;
      continue;
    } else {
    }
    break;
  }
  return dimarray;
};
cljs.core.make_array.cljs$lang$applyTo = function(seq4369) {
  var G__4370 = cljs.core.first(seq4369);
  var seq4369__$1 = cljs.core.next(seq4369);
  var G__4371 = cljs.core.first(seq4369__$1);
  var seq4369__$2 = cljs.core.next(seq4369__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4370, G__4371, seq4369__$2);
};
cljs.core.make_array.cljs$lang$maxFixedArity = 2;
cljs.core.aclone = function cljs$core$aclone(arr) {
  var len = arr.length;
  var new_arr = new Array(len);
  var n__4376__auto___4380 = len;
  var i_4381 = 0;
  while (true) {
    if (i_4381 < n__4376__auto___4380) {
      new_arr[i_4381] = arr[i_4381];
      var G__4382 = i_4381 + 1;
      i_4381 = G__4382;
      continue;
    } else {
    }
    break;
  }
  return new_arr;
};
cljs.core.array = function cljs$core$array(var_args) {
  var a = new Array(arguments.length);
  var i = 0;
  while (true) {
    if (i < a.length) {
      a[i] = arguments[i];
      var G__4383 = i + 1;
      i = G__4383;
      continue;
    } else {
      return a;
    }
    break;
  }
};
cljs.core.maybe_warn = function cljs$core$maybe_warn(e) {
  if (cljs.core.truth_(cljs.core._STAR_print_err_fn_STAR_)) {
    return cljs.core._STAR_print_err_fn_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.core._STAR_print_err_fn_STAR_.cljs$core$IFn$_invoke$arity$1(e) : cljs.core._STAR_print_err_fn_STAR_.call(null, e);
  } else {
    return null;
  }
};
cljs.core.checked_aget = function cljs$core$checked_aget(var_args) {
  var G__4388 = arguments.length;
  switch(G__4388) {
    case 2:
      return cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4391 = arguments.length;
      var i__4500__auto___4392 = 0;
      while (true) {
        if (i__4500__auto___4392 < len__4499__auto___4391) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4392]);
          var G__4393 = i__4500__auto___4392 + 1;
          i__4500__auto___4392 = G__4393;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2 = function(array, idx) {
  try {
    if (cljs.core.truth_(function() {
      var or__3922__auto__ = cljs.core.array_QMARK_(array);
      if (or__3922__auto__) {
        return or__3922__auto__;
      } else {
        return goog.isArrayLike(array);
      }
    }())) {
    } else {
      throw new Error("Assert failed: (or (array? array) (js/goog.isArrayLike array))");
    }
    if (typeof idx === "number") {
    } else {
      throw new Error("Assert failed: (number? idx)");
    }
    if (!(idx < 0)) {
    } else {
      throw new Error("Assert failed: (not (neg? idx))");
    }
    if (idx < array.length) {
    } else {
      throw new Error("Assert failed: (\x3c idx (alength array))");
    }
  } catch (e4389) {
    var e_4394 = e4389;
    cljs.core.maybe_warn(e_4394);
  }
  return array[idx];
};
cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$variadic = function(array, idx, idxs) {
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.checked_aget, cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2(array, idx), idxs);
};
cljs.core.checked_aget.cljs$lang$applyTo = function(seq4385) {
  var G__4386 = cljs.core.first(seq4385);
  var seq4385__$1 = cljs.core.next(seq4385);
  var G__4387 = cljs.core.first(seq4385__$1);
  var seq4385__$2 = cljs.core.next(seq4385__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4386, G__4387, seq4385__$2);
};
cljs.core.checked_aget.cljs$lang$maxFixedArity = 2;
cljs.core.checked_aset = function cljs$core$checked_aset(var_args) {
  var G__4400 = arguments.length;
  switch(G__4400) {
    case 3:
      return cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4403 = arguments.length;
      var i__4500__auto___4404 = 0;
      while (true) {
        if (i__4500__auto___4404 < len__4499__auto___4403) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4404]);
          var G__4405 = i__4500__auto___4404 + 1;
          i__4500__auto___4404 = G__4405;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(3), 0, null);
      return cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__4515__auto__);
  }
};
cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$3 = function(array, idx, val) {
  try {
    if (cljs.core.truth_(function() {
      var or__3922__auto__ = cljs.core.array_QMARK_(array);
      if (or__3922__auto__) {
        return or__3922__auto__;
      } else {
        return goog.isArrayLike(array);
      }
    }())) {
    } else {
      throw new Error("Assert failed: (or (array? array) (js/goog.isArrayLike array))");
    }
    if (typeof idx === "number") {
    } else {
      throw new Error("Assert failed: (number? idx)");
    }
    if (!(idx < 0)) {
    } else {
      throw new Error("Assert failed: (not (neg? idx))");
    }
    if (idx < array.length) {
    } else {
      throw new Error("Assert failed: (\x3c idx (alength array))");
    }
  } catch (e4401) {
    var e_4406 = e4401;
    cljs.core.maybe_warn(e_4406);
  }
  return array[idx] = val;
};
cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$variadic = function(array, idx, idx2, idxv) {
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.checked_aset, cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2(array, idx), idx2, idxv);
};
cljs.core.checked_aset.cljs$lang$applyTo = function(seq4396) {
  var G__4397 = cljs.core.first(seq4396);
  var seq4396__$1 = cljs.core.next(seq4396);
  var G__4398 = cljs.core.first(seq4396__$1);
  var seq4396__$2 = cljs.core.next(seq4396__$1);
  var G__4399 = cljs.core.first(seq4396__$2);
  var seq4396__$3 = cljs.core.next(seq4396__$2);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4397, G__4398, G__4399, seq4396__$3);
};
cljs.core.checked_aset.cljs$lang$maxFixedArity = 3;
cljs.core.checked_aget_SINGLEQUOTE_ = function cljs$core$checked_aget_SINGLEQUOTE_(var_args) {
  var G__4411 = arguments.length;
  switch(G__4411) {
    case 2:
      return cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4413 = arguments.length;
      var i__4500__auto___4414 = 0;
      while (true) {
        if (i__4500__auto___4414 < len__4499__auto___4413) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4414]);
          var G__4415 = i__4500__auto___4414 + 1;
          i__4500__auto___4414 = G__4415;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 = function(array, idx) {
  if (cljs.core.truth_(function() {
    var or__3922__auto__ = cljs.core.array_QMARK_(array);
    if (or__3922__auto__) {
      return or__3922__auto__;
    } else {
      return goog.isArrayLike(array);
    }
  }())) {
  } else {
    throw new Error("Assert failed: (or (array? array) (js/goog.isArrayLike array))");
  }
  if (typeof idx === "number") {
  } else {
    throw new Error("Assert failed: (number? idx)");
  }
  if (!(idx < 0)) {
  } else {
    throw new Error("Assert failed: (not (neg? idx))");
  }
  if (idx < array.length) {
  } else {
    throw new Error("Assert failed: (\x3c idx (alength array))");
  }
  return array[idx];
};
cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic = function(array, idx, idxs) {
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.checked_aget_SINGLEQUOTE_, cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(array, idx), idxs);
};
cljs.core.checked_aget_SINGLEQUOTE_.cljs$lang$applyTo = function(seq4408) {
  var G__4409 = cljs.core.first(seq4408);
  var seq4408__$1 = cljs.core.next(seq4408);
  var G__4410 = cljs.core.first(seq4408__$1);
  var seq4408__$2 = cljs.core.next(seq4408__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4409, G__4410, seq4408__$2);
};
cljs.core.checked_aget_SINGLEQUOTE_.cljs$lang$maxFixedArity = 2;
cljs.core.checked_aset_SINGLEQUOTE_ = function cljs$core$checked_aset_SINGLEQUOTE_(var_args) {
  var G__4421 = arguments.length;
  switch(G__4421) {
    case 3:
      return cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4423 = arguments.length;
      var i__4500__auto___4424 = 0;
      while (true) {
        if (i__4500__auto___4424 < len__4499__auto___4423) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4424]);
          var G__4425 = i__4500__auto___4424 + 1;
          i__4500__auto___4424 = G__4425;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(3), 0, null);
      return cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__4515__auto__);
  }
};
cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$3 = function(array, idx, val) {
  if (cljs.core.truth_(function() {
    var or__3922__auto__ = cljs.core.array_QMARK_(array);
    if (or__3922__auto__) {
      return or__3922__auto__;
    } else {
      return goog.isArrayLike(array);
    }
  }())) {
  } else {
    throw new Error("Assert failed: (or (array? array) (js/goog.isArrayLike array))");
  }
  if (typeof idx === "number") {
  } else {
    throw new Error("Assert failed: (number? idx)");
  }
  if (!(idx < 0)) {
  } else {
    throw new Error("Assert failed: (not (neg? idx))");
  }
  if (idx < array.length) {
  } else {
    throw new Error("Assert failed: (\x3c idx (alength array))");
  }
  return array[idx] = val;
};
cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic = function(array, idx, idx2, idxv) {
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.checked_aset_SINGLEQUOTE_, cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(array, idx), idx2, idxv);
};
cljs.core.checked_aset_SINGLEQUOTE_.cljs$lang$applyTo = function(seq4417) {
  var G__4418 = cljs.core.first(seq4417);
  var seq4417__$1 = cljs.core.next(seq4417);
  var G__4419 = cljs.core.first(seq4417__$1);
  var seq4417__$2 = cljs.core.next(seq4417__$1);
  var G__4420 = cljs.core.first(seq4417__$2);
  var seq4417__$3 = cljs.core.next(seq4417__$2);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4418, G__4419, G__4420, seq4417__$3);
};
cljs.core.checked_aset_SINGLEQUOTE_.cljs$lang$maxFixedArity = 3;
cljs.core.aget = function cljs$core$aget(var_args) {
  var G__4430 = arguments.length;
  switch(G__4430) {
    case 2:
      return cljs.core.aget.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4432 = arguments.length;
      var i__4500__auto___4433 = 0;
      while (true) {
        if (i__4500__auto___4433 < len__4499__auto___4432) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4433]);
          var G__4434 = i__4500__auto___4433 + 1;
          i__4500__auto___4433 = G__4434;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = function(array, idx) {
  return array[idx];
};
cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = function(array, idx, idxs) {
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.aget, array[idx], idxs);
};
cljs.core.aget.cljs$lang$applyTo = function(seq4427) {
  var G__4428 = cljs.core.first(seq4427);
  var seq4427__$1 = cljs.core.next(seq4427);
  var G__4429 = cljs.core.first(seq4427__$1);
  var seq4427__$2 = cljs.core.next(seq4427__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4428, G__4429, seq4427__$2);
};
cljs.core.aget.cljs$lang$maxFixedArity = 2;
cljs.core.aset = function cljs$core$aset(var_args) {
  var G__4440 = arguments.length;
  switch(G__4440) {
    case 3:
      return cljs.core.aset.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4442 = arguments.length;
      var i__4500__auto___4443 = 0;
      while (true) {
        if (i__4500__auto___4443 < len__4499__auto___4442) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4443]);
          var G__4444 = i__4500__auto___4443 + 1;
          i__4500__auto___4443 = G__4444;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(3), 0, null);
      return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__4515__auto__);
  }
};
cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = function(array, idx, val) {
  return array[idx] = val;
};
cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = function(array, idx, idx2, idxv) {
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.aset, array[idx], idx2, idxv);
};
cljs.core.aset.cljs$lang$applyTo = function(seq4436) {
  var G__4437 = cljs.core.first(seq4436);
  var seq4436__$1 = cljs.core.next(seq4436);
  var G__4438 = cljs.core.first(seq4436__$1);
  var seq4436__$2 = cljs.core.next(seq4436__$1);
  var G__4439 = cljs.core.first(seq4436__$2);
  var seq4436__$3 = cljs.core.next(seq4436__$2);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4437, G__4438, G__4439, seq4436__$3);
};
cljs.core.aset.cljs$lang$maxFixedArity = 3;
cljs.core.alength = function cljs$core$alength(array) {
  return array.length;
};
cljs.core.into_array = function cljs$core$into_array(var_args) {
  var G__4446 = arguments.length;
  switch(G__4446) {
    case 1:
      return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = function(aseq) {
  return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null, aseq);
};
cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = function(type, aseq) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(a, x) {
    a.push(x);
    return a;
  }, [], aseq);
};
cljs.core.into_array.cljs$lang$maxFixedArity = 2;
cljs.core.js_invoke = function cljs$core$js_invoke(var_args) {
  var args__4502__auto__ = [];
  var len__4499__auto___4451 = arguments.length;
  var i__4500__auto___4452 = 0;
  while (true) {
    if (i__4500__auto___4452 < len__4499__auto___4451) {
      args__4502__auto__.push(arguments[i__4500__auto___4452]);
      var G__4453 = i__4500__auto___4452 + 1;
      i__4500__auto___4452 = G__4453;
      continue;
    } else {
    }
    break;
  }
  var argseq__4503__auto__ = 2 < args__4502__auto__.length ? new cljs.core.IndexedSeq(args__4502__auto__.slice(2), 0, null) : null;
  return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4503__auto__);
};
cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = function(obj, s, args) {
  return obj[s].apply(obj, cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
};
cljs.core.js_invoke.cljs$lang$maxFixedArity = 2;
cljs.core.js_invoke.cljs$lang$applyTo = function(seq4448) {
  var G__4449 = cljs.core.first(seq4448);
  var seq4448__$1 = cljs.core.next(seq4448);
  var G__4450 = cljs.core.first(seq4448__$1);
  var seq4448__$2 = cljs.core.next(seq4448__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4449, G__4450, seq4448__$2);
};
cljs.core.Fn = function() {
};
cljs.core.IFn = function() {
};
cljs.core._invoke = function cljs$core$_invoke(var_args) {
  var G__4455 = arguments.length;
  switch(G__4455) {
    case 1:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    case 7:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6]);
      break;
    case 8:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7]);
      break;
    case 9:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8]);
      break;
    case 10:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9]);
      break;
    case 11:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10]);
      break;
    case 12:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11]);
      break;
    case 13:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12]);
      break;
    case 14:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13]);
      break;
    case 15:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14]);
      break;
    case 16:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15]);
      break;
    case 17:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16]);
      break;
    case 18:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17]);
      break;
    case 19:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18]);
      break;
    case 20:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19]);
      break;
    case 21:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19], arguments[20]);
      break;
    case 22:
      return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9], arguments[10], arguments[11], arguments[12], arguments[13], arguments[14], arguments[15], arguments[16], arguments[17], arguments[18], arguments[19], arguments[20], arguments[21]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = function(this$) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$1 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$1(this$);
  } else {
    var x__4211__auto__ = this$ == null ? null : this$;
    var m__4212__auto__ = cljs.core._invoke[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4212__auto__.call(null, this$);
    } else {
      var m__4212__auto____$1 = cljs.core._invoke["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__4212__auto____$1.call(null, this$);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = function(this$, a) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$2 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$2(this$, a);
  } else {
    var x__4211__auto__ = this$ == null ? null : this$;
    var m__4212__auto__ = cljs.core._invoke[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(this$, a) : m__4212__auto__.call(null, this$, a);
    } else {
      var m__4212__auto____$1 = cljs.core._invoke["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(this$, a) : m__4212__auto____$1.call(null, this$, a);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = function(this$, a, b) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$3 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$3(this$, a, b);
  } else {
    var x__4211__auto__ = this$ == null ? null : this$;
    var m__4212__auto__ = cljs.core._invoke[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$3(this$, a, b) : m__4212__auto__.call(null, this$, a, b);
    } else {
      var m__4212__auto____$1 = cljs.core._invoke["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3(this$, a, b) : m__4212__auto____$1.call(null, this$, a, b);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = function(this$, a, b, c) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$4 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$4(this$, a, b, c);
  } else {
    var x__4211__auto__ = this$ == null ? null : this$;
    var m__4212__auto__ = cljs.core._invoke[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$4(this$, a, b, c) : m__4212__auto__.call(null, this$, a, b, c);
    } else {
      var m__4212__auto____$1 = cljs.core._invoke["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$4(this$, a, b, c) : m__4212__auto____$1.call(null, this$, a, b, c);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = function(this$, a, b, c, d) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$5 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d);
  } else {
    var x__4211__auto__ = this$ == null ? null : this$;
    var m__4212__auto__ = cljs.core._invoke[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d) : m__4212__auto__.call(null, this$, a, b, c, d);
    } else {
      var m__4212__auto____$1 = cljs.core._invoke["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$5 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d) : m__4212__auto____$1.call(null, this$, a, b, c, d);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = function(this$, a, b, c, d, e) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$6 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e);
  } else {
    var x__4211__auto__ = this$ == null ? null : this$;
    var m__4212__auto__ = cljs.core._invoke[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$6 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e) : m__4212__auto__.call(null, this$, a, b, c, d, e);
    } else {
      var m__4212__auto____$1 = cljs.core._invoke["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$6 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e) : m__4212__auto____$1.call(null, this$, a, b, c, d, e);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = function(this$, a, b, c, d, e, f) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$7 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f);
  } else {
    var x__4211__auto__ = this$ == null ? null : this$;
    var m__4212__auto__ = cljs.core._invoke[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$7 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f) : m__4212__auto__.call(null, this$, a, b, c, d, e, f);
    } else {
      var m__4212__auto____$1 = cljs.core._invoke["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$7 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f) : m__4212__auto____$1.call(null, this$, a, b, c, d, e, f);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = function(this$, a, b, c, d, e, f, g) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$8 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g);
  } else {
    var x__4211__auto__ = this$ == null ? null : this$;
    var m__4212__auto__ = cljs.core._invoke[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$8 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g) : m__4212__auto__.call(null, this$, a, b, c, d, e, f, g);
    } else {
      var m__4212__auto____$1 = cljs.core._invoke["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$8 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g) : m__4212__auto____$1.call(null, this$, a, b, c, d, e, f, g);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = function(this$, a, b, c, d, e, f, g, h) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$9 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h);
  } else {
    var x__4211__auto__ = this$ == null ? null : this$;
    var m__4212__auto__ = cljs.core._invoke[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$9 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h) : m__4212__auto__.call(null, this$, a, b, c, d, e, f, g, h);
    } else {
      var m__4212__auto____$1 = cljs.core._invoke["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$9 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h) : m__4212__auto____$1.call(null, this$, a, b, c, d, e, f, g, h);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = function(this$, a, b, c, d, e, f, g, h, i) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$10 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i);
  } else {
    var x__4211__auto__ = this$ == null ? null : this$;
    var m__4212__auto__ = cljs.core._invoke[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$10 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i) : m__4212__auto__.call(null, this$, a, b, c, d, e, f, g, h, i);
    } else {
      var m__4212__auto____$1 = cljs.core._invoke["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$10 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i) : m__4212__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = function(this$, a, b, c, d, e, f, g, h, i, j) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$11 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j);
  } else {
    var x__4211__auto__ = this$ == null ? null : this$;
    var m__4212__auto__ = cljs.core._invoke[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$11 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j) : m__4212__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j);
    } else {
      var m__4212__auto____$1 = cljs.core._invoke["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$11 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j) : m__4212__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = function(this$, a, b, c, d, e, f, g, h, i, j, k) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$12 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k);
  } else {
    var x__4211__auto__ = this$ == null ? null : this$;
    var m__4212__auto__ = cljs.core._invoke[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$12 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k) : m__4212__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k);
    } else {
      var m__4212__auto____$1 = cljs.core._invoke["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$12 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k) : m__4212__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$13 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l);
  } else {
    var x__4211__auto__ = this$ == null ? null : this$;
    var m__4212__auto__ = cljs.core._invoke[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$13 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l) : m__4212__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l);
    } else {
      var m__4212__auto____$1 = cljs.core._invoke["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$13 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l) : m__4212__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$14 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
  } else {
    var x__4211__auto__ = this$ == null ? null : this$;
    var m__4212__auto__ = cljs.core._invoke[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$14 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) : m__4212__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
    } else {
      var m__4212__auto____$1 = cljs.core._invoke["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$14 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) : m__4212__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$15 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  } else {
    var x__4211__auto__ = this$ == null ? null : this$;
    var m__4212__auto__ = cljs.core._invoke[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$15 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) : m__4212__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
    } else {
      var m__4212__auto____$1 = cljs.core._invoke["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$15 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) : m__4212__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$16 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  } else {
    var x__4211__auto__ = this$ == null ? null : this$;
    var m__4212__auto__ = cljs.core._invoke[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$16 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) : m__4212__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
    } else {
      var m__4212__auto____$1 = cljs.core._invoke["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$16 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) : m__4212__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$17 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  } else {
    var x__4211__auto__ = this$ == null ? null : this$;
    var m__4212__auto__ = cljs.core._invoke[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$17 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) : m__4212__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
    } else {
      var m__4212__auto____$1 = cljs.core._invoke["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$17 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) : m__4212__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$18 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  } else {
    var x__4211__auto__ = this$ == null ? null : this$;
    var m__4212__auto__ = cljs.core._invoke[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$18 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) : m__4212__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
    } else {
      var m__4212__auto____$1 = cljs.core._invoke["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$18 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) : m__4212__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$19 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  } else {
    var x__4211__auto__ = this$ == null ? null : this$;
    var m__4212__auto__ = cljs.core._invoke[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$19 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) : m__4212__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
    } else {
      var m__4212__auto____$1 = cljs.core._invoke["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$19 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) : m__4212__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$20 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  } else {
    var x__4211__auto__ = this$ == null ? null : this$;
    var m__4212__auto__ = cljs.core._invoke[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$20 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) : m__4212__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
    } else {
      var m__4212__auto____$1 = cljs.core._invoke["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$20 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) : m__4212__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$21 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  } else {
    var x__4211__auto__ = this$ == null ? null : this$;
    var m__4212__auto__ = cljs.core._invoke[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$21 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) : m__4212__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
    } else {
      var m__4212__auto____$1 = cljs.core._invoke["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$21 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) : m__4212__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  if (!(this$ == null) && !(this$.cljs$core$IFn$_invoke$arity$22 == null)) {
    return this$.cljs$core$IFn$_invoke$arity$22(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
  } else {
    var x__4211__auto__ = this$ == null ? null : this$;
    var m__4212__auto__ = cljs.core._invoke[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$22 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$22(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) : m__4212__auto__.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
    } else {
      var m__4212__auto____$1 = cljs.core._invoke["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$22 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$22(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) : m__4212__auto____$1.call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
      } else {
        throw cljs.core.missing_protocol("IFn.-invoke", this$);
      }
    }
  }
};
cljs.core._invoke.cljs$lang$maxFixedArity = 22;
cljs.core.ICloneable = function() {
};
cljs.core._clone = function cljs$core$_clone(value) {
  if (!(value == null) && !(value.cljs$core$ICloneable$_clone$arity$1 == null)) {
    return value.cljs$core$ICloneable$_clone$arity$1(value);
  } else {
    var x__4211__auto__ = value == null ? null : value;
    var m__4212__auto__ = cljs.core._clone[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__4212__auto__.call(null, value);
    } else {
      var m__4212__auto____$1 = cljs.core._clone["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(value) : m__4212__auto____$1.call(null, value);
      } else {
        throw cljs.core.missing_protocol("ICloneable.-clone", value);
      }
    }
  }
};
cljs.core.ICounted = function() {
};
cljs.core._count = function cljs$core$_count(coll) {
  if (!(coll == null) && !(coll.cljs$core$ICounted$_count$arity$1 == null)) {
    return coll.cljs$core$ICounted$_count$arity$1(coll);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._count[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto__.call(null, coll);
    } else {
      var m__4212__auto____$1 = cljs.core._count["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("ICounted.-count", coll);
      }
    }
  }
};
cljs.core.IEmptyableCollection = function() {
};
cljs.core._empty = function cljs$core$_empty(coll) {
  if (!(coll == null) && !(coll.cljs$core$IEmptyableCollection$_empty$arity$1 == null)) {
    return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._empty[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto__.call(null, coll);
    } else {
      var m__4212__auto____$1 = cljs.core._empty["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IEmptyableCollection.-empty", coll);
      }
    }
  }
};
cljs.core.ICollection = function() {
};
cljs.core._conj = function cljs$core$_conj(coll, o) {
  if (!(coll == null) && !(coll.cljs$core$ICollection$_conj$arity$2 == null)) {
    return coll.cljs$core$ICollection$_conj$arity$2(coll, o);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._conj[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(coll, o) : m__4212__auto__.call(null, coll, o);
    } else {
      var m__4212__auto____$1 = cljs.core._conj["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, o) : m__4212__auto____$1.call(null, coll, o);
      } else {
        throw cljs.core.missing_protocol("ICollection.-conj", coll);
      }
    }
  }
};
cljs.core.IIndexed = function() {
};
cljs.core._nth = function cljs$core$_nth(var_args) {
  var G__4458 = arguments.length;
  switch(G__4458) {
    case 2:
      return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  if (!(coll == null) && !(coll.cljs$core$IIndexed$_nth$arity$2 == null)) {
    return coll.cljs$core$IIndexed$_nth$arity$2(coll, n);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._nth[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(coll, n) : m__4212__auto__.call(null, coll, n);
    } else {
      var m__4212__auto____$1 = cljs.core._nth["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, n) : m__4212__auto____$1.call(null, coll, n);
      } else {
        throw cljs.core.missing_protocol("IIndexed.-nth", coll);
      }
    }
  }
};
cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  if (!(coll == null) && !(coll.cljs$core$IIndexed$_nth$arity$3 == null)) {
    return coll.cljs$core$IIndexed$_nth$arity$3(coll, n, not_found);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._nth[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$3(coll, n, not_found) : m__4212__auto__.call(null, coll, n, not_found);
    } else {
      var m__4212__auto____$1 = cljs.core._nth["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, n, not_found) : m__4212__auto____$1.call(null, coll, n, not_found);
      } else {
        throw cljs.core.missing_protocol("IIndexed.-nth", coll);
      }
    }
  }
};
cljs.core._nth.cljs$lang$maxFixedArity = 3;
cljs.core.ASeq = function() {
};
cljs.core.ISeq = function() {
};
cljs.core._first = function cljs$core$_first(coll) {
  if (!(coll == null) && !(coll.cljs$core$ISeq$_first$arity$1 == null)) {
    return coll.cljs$core$ISeq$_first$arity$1(coll);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._first[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto__.call(null, coll);
    } else {
      var m__4212__auto____$1 = cljs.core._first["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("ISeq.-first", coll);
      }
    }
  }
};
cljs.core._rest = function cljs$core$_rest(coll) {
  if (!(coll == null) && !(coll.cljs$core$ISeq$_rest$arity$1 == null)) {
    return coll.cljs$core$ISeq$_rest$arity$1(coll);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._rest[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto__.call(null, coll);
    } else {
      var m__4212__auto____$1 = cljs.core._rest["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("ISeq.-rest", coll);
      }
    }
  }
};
cljs.core.INext = function() {
};
cljs.core._next = function cljs$core$_next(coll) {
  if (!(coll == null) && !(coll.cljs$core$INext$_next$arity$1 == null)) {
    return coll.cljs$core$INext$_next$arity$1(coll);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._next[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto__.call(null, coll);
    } else {
      var m__4212__auto____$1 = cljs.core._next["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("INext.-next", coll);
      }
    }
  }
};
cljs.core.ILookup = function() {
};
cljs.core._lookup = function cljs$core$_lookup(var_args) {
  var G__4461 = arguments.length;
  switch(G__4461) {
    case 2:
      return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = function(o, k) {
  if (!(o == null) && !(o.cljs$core$ILookup$_lookup$arity$2 == null)) {
    return o.cljs$core$ILookup$_lookup$arity$2(o, k);
  } else {
    var x__4211__auto__ = o == null ? null : o;
    var m__4212__auto__ = cljs.core._lookup[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(o, k) : m__4212__auto__.call(null, o, k);
    } else {
      var m__4212__auto____$1 = cljs.core._lookup["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(o, k) : m__4212__auto____$1.call(null, o, k);
      } else {
        throw cljs.core.missing_protocol("ILookup.-lookup", o);
      }
    }
  }
};
cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = function(o, k, not_found) {
  if (!(o == null) && !(o.cljs$core$ILookup$_lookup$arity$3 == null)) {
    return o.cljs$core$ILookup$_lookup$arity$3(o, k, not_found);
  } else {
    var x__4211__auto__ = o == null ? null : o;
    var m__4212__auto__ = cljs.core._lookup[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$3(o, k, not_found) : m__4212__auto__.call(null, o, k, not_found);
    } else {
      var m__4212__auto____$1 = cljs.core._lookup["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3(o, k, not_found) : m__4212__auto____$1.call(null, o, k, not_found);
      } else {
        throw cljs.core.missing_protocol("ILookup.-lookup", o);
      }
    }
  }
};
cljs.core._lookup.cljs$lang$maxFixedArity = 3;
cljs.core.IAssociative = function() {
};
cljs.core._contains_key_QMARK_ = function cljs$core$_contains_key_QMARK_(coll, k) {
  if (!(coll == null) && !(coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 == null)) {
    return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll, k);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._contains_key_QMARK_[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(coll, k) : m__4212__auto__.call(null, coll, k);
    } else {
      var m__4212__auto____$1 = cljs.core._contains_key_QMARK_["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, k) : m__4212__auto____$1.call(null, coll, k);
      } else {
        throw cljs.core.missing_protocol("IAssociative.-contains-key?", coll);
      }
    }
  }
};
cljs.core._assoc = function cljs$core$_assoc(coll, k, v) {
  if (!(coll == null) && !(coll.cljs$core$IAssociative$_assoc$arity$3 == null)) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, k, v);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._assoc[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$3(coll, k, v) : m__4212__auto__.call(null, coll, k, v);
    } else {
      var m__4212__auto____$1 = cljs.core._assoc["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, k, v) : m__4212__auto____$1.call(null, coll, k, v);
      } else {
        throw cljs.core.missing_protocol("IAssociative.-assoc", coll);
      }
    }
  }
};
cljs.core.IFind = function() {
};
cljs.core._find = function cljs$core$_find(coll, k) {
  if (!(coll == null) && !(coll.cljs$core$IFind$_find$arity$2 == null)) {
    return coll.cljs$core$IFind$_find$arity$2(coll, k);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._find[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(coll, k) : m__4212__auto__.call(null, coll, k);
    } else {
      var m__4212__auto____$1 = cljs.core._find["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, k) : m__4212__auto____$1.call(null, coll, k);
      } else {
        throw cljs.core.missing_protocol("IFind.-find", coll);
      }
    }
  }
};
cljs.core.IMap = function() {
};
cljs.core._dissoc = function cljs$core$_dissoc(coll, k) {
  if (!(coll == null) && !(coll.cljs$core$IMap$_dissoc$arity$2 == null)) {
    return coll.cljs$core$IMap$_dissoc$arity$2(coll, k);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._dissoc[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(coll, k) : m__4212__auto__.call(null, coll, k);
    } else {
      var m__4212__auto____$1 = cljs.core._dissoc["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, k) : m__4212__auto____$1.call(null, coll, k);
      } else {
        throw cljs.core.missing_protocol("IMap.-dissoc", coll);
      }
    }
  }
};
cljs.core.IMapEntry = function() {
};
cljs.core._key = function cljs$core$_key(coll) {
  if (!(coll == null) && !(coll.cljs$core$IMapEntry$_key$arity$1 == null)) {
    return coll.cljs$core$IMapEntry$_key$arity$1(coll);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._key[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto__.call(null, coll);
    } else {
      var m__4212__auto____$1 = cljs.core._key["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IMapEntry.-key", coll);
      }
    }
  }
};
cljs.core._val = function cljs$core$_val(coll) {
  if (!(coll == null) && !(coll.cljs$core$IMapEntry$_val$arity$1 == null)) {
    return coll.cljs$core$IMapEntry$_val$arity$1(coll);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._val[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto__.call(null, coll);
    } else {
      var m__4212__auto____$1 = cljs.core._val["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IMapEntry.-val", coll);
      }
    }
  }
};
cljs.core.ISet = function() {
};
cljs.core._disjoin = function cljs$core$_disjoin(coll, v) {
  if (!(coll == null) && !(coll.cljs$core$ISet$_disjoin$arity$2 == null)) {
    return coll.cljs$core$ISet$_disjoin$arity$2(coll, v);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._disjoin[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(coll, v) : m__4212__auto__.call(null, coll, v);
    } else {
      var m__4212__auto____$1 = cljs.core._disjoin["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, v) : m__4212__auto____$1.call(null, coll, v);
      } else {
        throw cljs.core.missing_protocol("ISet.-disjoin", coll);
      }
    }
  }
};
cljs.core.IStack = function() {
};
cljs.core._peek = function cljs$core$_peek(coll) {
  if (!(coll == null) && !(coll.cljs$core$IStack$_peek$arity$1 == null)) {
    return coll.cljs$core$IStack$_peek$arity$1(coll);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._peek[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto__.call(null, coll);
    } else {
      var m__4212__auto____$1 = cljs.core._peek["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IStack.-peek", coll);
      }
    }
  }
};
cljs.core._pop = function cljs$core$_pop(coll) {
  if (!(coll == null) && !(coll.cljs$core$IStack$_pop$arity$1 == null)) {
    return coll.cljs$core$IStack$_pop$arity$1(coll);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._pop[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto__.call(null, coll);
    } else {
      var m__4212__auto____$1 = cljs.core._pop["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IStack.-pop", coll);
      }
    }
  }
};
cljs.core.IVector = function() {
};
cljs.core._assoc_n = function cljs$core$_assoc_n(coll, n, val) {
  if (!(coll == null) && !(coll.cljs$core$IVector$_assoc_n$arity$3 == null)) {
    return coll.cljs$core$IVector$_assoc_n$arity$3(coll, n, val);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._assoc_n[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$3(coll, n, val) : m__4212__auto__.call(null, coll, n, val);
    } else {
      var m__4212__auto____$1 = cljs.core._assoc_n["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, n, val) : m__4212__auto____$1.call(null, coll, n, val);
      } else {
        throw cljs.core.missing_protocol("IVector.-assoc-n", coll);
      }
    }
  }
};
cljs.core.IDeref = function() {
};
cljs.core._deref = function cljs$core$_deref(o) {
  if (!(o == null) && !(o.cljs$core$IDeref$_deref$arity$1 == null)) {
    return o.cljs$core$IDeref$_deref$arity$1(o);
  } else {
    var x__4211__auto__ = o == null ? null : o;
    var m__4212__auto__ = cljs.core._deref[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4212__auto__.call(null, o);
    } else {
      var m__4212__auto____$1 = cljs.core._deref["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__4212__auto____$1.call(null, o);
      } else {
        throw cljs.core.missing_protocol("IDeref.-deref", o);
      }
    }
  }
};
cljs.core.IDerefWithTimeout = function() {
};
cljs.core._deref_with_timeout = function cljs$core$_deref_with_timeout(o, msec, timeout_val) {
  if (!(o == null) && !(o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3 == null)) {
    return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o, msec, timeout_val);
  } else {
    var x__4211__auto__ = o == null ? null : o;
    var m__4212__auto__ = cljs.core._deref_with_timeout[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$3(o, msec, timeout_val) : m__4212__auto__.call(null, o, msec, timeout_val);
    } else {
      var m__4212__auto____$1 = cljs.core._deref_with_timeout["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3(o, msec, timeout_val) : m__4212__auto____$1.call(null, o, msec, timeout_val);
      } else {
        throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout", o);
      }
    }
  }
};
cljs.core.IMeta = function() {
};
cljs.core._meta = function cljs$core$_meta(o) {
  if (!(o == null) && !(o.cljs$core$IMeta$_meta$arity$1 == null)) {
    return o.cljs$core$IMeta$_meta$arity$1(o);
  } else {
    var x__4211__auto__ = o == null ? null : o;
    var m__4212__auto__ = cljs.core._meta[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4212__auto__.call(null, o);
    } else {
      var m__4212__auto____$1 = cljs.core._meta["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__4212__auto____$1.call(null, o);
      } else {
        throw cljs.core.missing_protocol("IMeta.-meta", o);
      }
    }
  }
};
cljs.core.IWithMeta = function() {
};
cljs.core._with_meta = function cljs$core$_with_meta(o, meta) {
  if (!(o == null) && !(o.cljs$core$IWithMeta$_with_meta$arity$2 == null)) {
    return o.cljs$core$IWithMeta$_with_meta$arity$2(o, meta);
  } else {
    var x__4211__auto__ = o == null ? null : o;
    var m__4212__auto__ = cljs.core._with_meta[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(o, meta) : m__4212__auto__.call(null, o, meta);
    } else {
      var m__4212__auto____$1 = cljs.core._with_meta["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(o, meta) : m__4212__auto____$1.call(null, o, meta);
      } else {
        throw cljs.core.missing_protocol("IWithMeta.-with-meta", o);
      }
    }
  }
};
cljs.core.IReduce = function() {
};
cljs.core._reduce = function cljs$core$_reduce(var_args) {
  var G__4464 = arguments.length;
  switch(G__4464) {
    case 2:
      return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = function(coll, f) {
  if (!(coll == null) && !(coll.cljs$core$IReduce$_reduce$arity$2 == null)) {
    return coll.cljs$core$IReduce$_reduce$arity$2(coll, f);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._reduce[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(coll, f) : m__4212__auto__.call(null, coll, f);
    } else {
      var m__4212__auto____$1 = cljs.core._reduce["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, f) : m__4212__auto____$1.call(null, coll, f);
      } else {
        throw cljs.core.missing_protocol("IReduce.-reduce", coll);
      }
    }
  }
};
cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = function(coll, f, start) {
  if (!(coll == null) && !(coll.cljs$core$IReduce$_reduce$arity$3 == null)) {
    return coll.cljs$core$IReduce$_reduce$arity$3(coll, f, start);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._reduce[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$3(coll, f, start) : m__4212__auto__.call(null, coll, f, start);
    } else {
      var m__4212__auto____$1 = cljs.core._reduce["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, f, start) : m__4212__auto____$1.call(null, coll, f, start);
      } else {
        throw cljs.core.missing_protocol("IReduce.-reduce", coll);
      }
    }
  }
};
cljs.core._reduce.cljs$lang$maxFixedArity = 3;
cljs.core.IKVReduce = function() {
};
cljs.core._kv_reduce = function cljs$core$_kv_reduce(coll, f, init) {
  if (!(coll == null) && !(coll.cljs$core$IKVReduce$_kv_reduce$arity$3 == null)) {
    return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll, f, init);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._kv_reduce[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$3(coll, f, init) : m__4212__auto__.call(null, coll, f, init);
    } else {
      var m__4212__auto____$1 = cljs.core._kv_reduce["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, f, init) : m__4212__auto____$1.call(null, coll, f, init);
      } else {
        throw cljs.core.missing_protocol("IKVReduce.-kv-reduce", coll);
      }
    }
  }
};
cljs.core.IEquiv = function() {
};
cljs.core._equiv = function cljs$core$_equiv(o, other) {
  if (!(o == null) && !(o.cljs$core$IEquiv$_equiv$arity$2 == null)) {
    return o.cljs$core$IEquiv$_equiv$arity$2(o, other);
  } else {
    var x__4211__auto__ = o == null ? null : o;
    var m__4212__auto__ = cljs.core._equiv[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(o, other) : m__4212__auto__.call(null, o, other);
    } else {
      var m__4212__auto____$1 = cljs.core._equiv["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(o, other) : m__4212__auto____$1.call(null, o, other);
      } else {
        throw cljs.core.missing_protocol("IEquiv.-equiv", o);
      }
    }
  }
};
cljs.core.IHash = function() {
};
cljs.core._hash = function cljs$core$_hash(o) {
  if (!(o == null) && !(o.cljs$core$IHash$_hash$arity$1 == null)) {
    return o.cljs$core$IHash$_hash$arity$1(o);
  } else {
    var x__4211__auto__ = o == null ? null : o;
    var m__4212__auto__ = cljs.core._hash[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4212__auto__.call(null, o);
    } else {
      var m__4212__auto____$1 = cljs.core._hash["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__4212__auto____$1.call(null, o);
      } else {
        throw cljs.core.missing_protocol("IHash.-hash", o);
      }
    }
  }
};
cljs.core.ISeqable = function() {
};
cljs.core._seq = function cljs$core$_seq(o) {
  if (!(o == null) && !(o.cljs$core$ISeqable$_seq$arity$1 == null)) {
    return o.cljs$core$ISeqable$_seq$arity$1(o);
  } else {
    var x__4211__auto__ = o == null ? null : o;
    var m__4212__auto__ = cljs.core._seq[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4212__auto__.call(null, o);
    } else {
      var m__4212__auto____$1 = cljs.core._seq["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__4212__auto____$1.call(null, o);
      } else {
        throw cljs.core.missing_protocol("ISeqable.-seq", o);
      }
    }
  }
};
cljs.core.ISequential = function() {
};
cljs.core.IList = function() {
};
cljs.core.IRecord = function() {
};
cljs.core.IReversible = function() {
};
cljs.core._rseq = function cljs$core$_rseq(coll) {
  if (!(coll == null) && !(coll.cljs$core$IReversible$_rseq$arity$1 == null)) {
    return coll.cljs$core$IReversible$_rseq$arity$1(coll);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._rseq[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto__.call(null, coll);
    } else {
      var m__4212__auto____$1 = cljs.core._rseq["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IReversible.-rseq", coll);
      }
    }
  }
};
cljs.core.ISorted = function() {
};
cljs.core._sorted_seq = function cljs$core$_sorted_seq(coll, ascending_QMARK_) {
  if (!(coll == null) && !(coll.cljs$core$ISorted$_sorted_seq$arity$2 == null)) {
    return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll, ascending_QMARK_);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._sorted_seq[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(coll, ascending_QMARK_) : m__4212__auto__.call(null, coll, ascending_QMARK_);
    } else {
      var m__4212__auto____$1 = cljs.core._sorted_seq["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, ascending_QMARK_) : m__4212__auto____$1.call(null, coll, ascending_QMARK_);
      } else {
        throw cljs.core.missing_protocol("ISorted.-sorted-seq", coll);
      }
    }
  }
};
cljs.core._sorted_seq_from = function cljs$core$_sorted_seq_from(coll, k, ascending_QMARK_) {
  if (!(coll == null) && !(coll.cljs$core$ISorted$_sorted_seq_from$arity$3 == null)) {
    return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll, k, ascending_QMARK_);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._sorted_seq_from[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$3(coll, k, ascending_QMARK_) : m__4212__auto__.call(null, coll, k, ascending_QMARK_);
    } else {
      var m__4212__auto____$1 = cljs.core._sorted_seq_from["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3(coll, k, ascending_QMARK_) : m__4212__auto____$1.call(null, coll, k, ascending_QMARK_);
      } else {
        throw cljs.core.missing_protocol("ISorted.-sorted-seq-from", coll);
      }
    }
  }
};
cljs.core._entry_key = function cljs$core$_entry_key(coll, entry) {
  if (!(coll == null) && !(coll.cljs$core$ISorted$_entry_key$arity$2 == null)) {
    return coll.cljs$core$ISorted$_entry_key$arity$2(coll, entry);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._entry_key[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(coll, entry) : m__4212__auto__.call(null, coll, entry);
    } else {
      var m__4212__auto____$1 = cljs.core._entry_key["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(coll, entry) : m__4212__auto____$1.call(null, coll, entry);
      } else {
        throw cljs.core.missing_protocol("ISorted.-entry-key", coll);
      }
    }
  }
};
cljs.core._comparator = function cljs$core$_comparator(coll) {
  if (!(coll == null) && !(coll.cljs$core$ISorted$_comparator$arity$1 == null)) {
    return coll.cljs$core$ISorted$_comparator$arity$1(coll);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._comparator[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto__.call(null, coll);
    } else {
      var m__4212__auto____$1 = cljs.core._comparator["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("ISorted.-comparator", coll);
      }
    }
  }
};
cljs.core.IWriter = function() {
};
cljs.core._write = function cljs$core$_write(writer, s) {
  if (!(writer == null) && !(writer.cljs$core$IWriter$_write$arity$2 == null)) {
    return writer.cljs$core$IWriter$_write$arity$2(writer, s);
  } else {
    var x__4211__auto__ = writer == null ? null : writer;
    var m__4212__auto__ = cljs.core._write[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(writer, s) : m__4212__auto__.call(null, writer, s);
    } else {
      var m__4212__auto____$1 = cljs.core._write["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(writer, s) : m__4212__auto____$1.call(null, writer, s);
      } else {
        throw cljs.core.missing_protocol("IWriter.-write", writer);
      }
    }
  }
};
cljs.core._flush = function cljs$core$_flush(writer) {
  if (!(writer == null) && !(writer.cljs$core$IWriter$_flush$arity$1 == null)) {
    return writer.cljs$core$IWriter$_flush$arity$1(writer);
  } else {
    var x__4211__auto__ = writer == null ? null : writer;
    var m__4212__auto__ = cljs.core._flush[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__4212__auto__.call(null, writer);
    } else {
      var m__4212__auto____$1 = cljs.core._flush["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(writer) : m__4212__auto____$1.call(null, writer);
      } else {
        throw cljs.core.missing_protocol("IWriter.-flush", writer);
      }
    }
  }
};
cljs.core.IPrintWithWriter = function() {
};
cljs.core._pr_writer = function cljs$core$_pr_writer(o, writer, opts) {
  if (!(o == null) && !(o.cljs$core$IPrintWithWriter$_pr_writer$arity$3 == null)) {
    return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o, writer, opts);
  } else {
    var x__4211__auto__ = o == null ? null : o;
    var m__4212__auto__ = cljs.core._pr_writer[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$3(o, writer, opts) : m__4212__auto__.call(null, o, writer, opts);
    } else {
      var m__4212__auto____$1 = cljs.core._pr_writer["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3(o, writer, opts) : m__4212__auto____$1.call(null, o, writer, opts);
      } else {
        throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer", o);
      }
    }
  }
};
cljs.core.IPending = function() {
};
cljs.core._realized_QMARK_ = function cljs$core$_realized_QMARK_(x) {
  if (!(x == null) && !(x.cljs$core$IPending$_realized_QMARK_$arity$1 == null)) {
    return x.cljs$core$IPending$_realized_QMARK_$arity$1(x);
  } else {
    var x__4211__auto__ = x == null ? null : x;
    var m__4212__auto__ = cljs.core._realized_QMARK_[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4212__auto__.call(null, x);
    } else {
      var m__4212__auto____$1 = cljs.core._realized_QMARK_["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__4212__auto____$1.call(null, x);
      } else {
        throw cljs.core.missing_protocol("IPending.-realized?", x);
      }
    }
  }
};
cljs.core.IWatchable = function() {
};
cljs.core._notify_watches = function cljs$core$_notify_watches(this$, oldval, newval) {
  if (!(this$ == null) && !(this$.cljs$core$IWatchable$_notify_watches$arity$3 == null)) {
    return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$, oldval, newval);
  } else {
    var x__4211__auto__ = this$ == null ? null : this$;
    var m__4212__auto__ = cljs.core._notify_watches[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$3(this$, oldval, newval) : m__4212__auto__.call(null, this$, oldval, newval);
    } else {
      var m__4212__auto____$1 = cljs.core._notify_watches["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3(this$, oldval, newval) : m__4212__auto____$1.call(null, this$, oldval, newval);
      } else {
        throw cljs.core.missing_protocol("IWatchable.-notify-watches", this$);
      }
    }
  }
};
cljs.core._add_watch = function cljs$core$_add_watch(this$, key, f) {
  if (!(this$ == null) && !(this$.cljs$core$IWatchable$_add_watch$arity$3 == null)) {
    return this$.cljs$core$IWatchable$_add_watch$arity$3(this$, key, f);
  } else {
    var x__4211__auto__ = this$ == null ? null : this$;
    var m__4212__auto__ = cljs.core._add_watch[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$3(this$, key, f) : m__4212__auto__.call(null, this$, key, f);
    } else {
      var m__4212__auto____$1 = cljs.core._add_watch["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3(this$, key, f) : m__4212__auto____$1.call(null, this$, key, f);
      } else {
        throw cljs.core.missing_protocol("IWatchable.-add-watch", this$);
      }
    }
  }
};
cljs.core._remove_watch = function cljs$core$_remove_watch(this$, key) {
  if (!(this$ == null) && !(this$.cljs$core$IWatchable$_remove_watch$arity$2 == null)) {
    return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$, key);
  } else {
    var x__4211__auto__ = this$ == null ? null : this$;
    var m__4212__auto__ = cljs.core._remove_watch[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(this$, key) : m__4212__auto__.call(null, this$, key);
    } else {
      var m__4212__auto____$1 = cljs.core._remove_watch["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(this$, key) : m__4212__auto____$1.call(null, this$, key);
      } else {
        throw cljs.core.missing_protocol("IWatchable.-remove-watch", this$);
      }
    }
  }
};
cljs.core.IEditableCollection = function() {
};
cljs.core._as_transient = function cljs$core$_as_transient(coll) {
  if (!(coll == null) && !(coll.cljs$core$IEditableCollection$_as_transient$arity$1 == null)) {
    return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._as_transient[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto__.call(null, coll);
    } else {
      var m__4212__auto____$1 = cljs.core._as_transient["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IEditableCollection.-as-transient", coll);
      }
    }
  }
};
cljs.core.ITransientCollection = function() {
};
cljs.core._conj_BANG_ = function cljs$core$_conj_BANG_(tcoll, val) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2 == null)) {
    return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll, val);
  } else {
    var x__4211__auto__ = tcoll == null ? null : tcoll;
    var m__4212__auto__ = cljs.core._conj_BANG_[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(tcoll, val) : m__4212__auto__.call(null, tcoll, val);
    } else {
      var m__4212__auto____$1 = cljs.core._conj_BANG_["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll, val) : m__4212__auto____$1.call(null, tcoll, val);
      } else {
        throw cljs.core.missing_protocol("ITransientCollection.-conj!", tcoll);
      }
    }
  }
};
cljs.core._persistent_BANG_ = function cljs$core$_persistent_BANG_(tcoll) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 == null)) {
    return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
  } else {
    var x__4211__auto__ = tcoll == null ? null : tcoll;
    var m__4212__auto__ = cljs.core._persistent_BANG_[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__4212__auto__.call(null, tcoll);
    } else {
      var m__4212__auto____$1 = cljs.core._persistent_BANG_["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(tcoll) : m__4212__auto____$1.call(null, tcoll);
      } else {
        throw cljs.core.missing_protocol("ITransientCollection.-persistent!", tcoll);
      }
    }
  }
};
cljs.core.ITransientAssociative = function() {
};
cljs.core._assoc_BANG_ = function cljs$core$_assoc_BANG_(tcoll, key, val) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 == null)) {
    return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll, key, val);
  } else {
    var x__4211__auto__ = tcoll == null ? null : tcoll;
    var m__4212__auto__ = cljs.core._assoc_BANG_[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$3(tcoll, key, val) : m__4212__auto__.call(null, tcoll, key, val);
    } else {
      var m__4212__auto____$1 = cljs.core._assoc_BANG_["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3(tcoll, key, val) : m__4212__auto____$1.call(null, tcoll, key, val);
      } else {
        throw cljs.core.missing_protocol("ITransientAssociative.-assoc!", tcoll);
      }
    }
  }
};
cljs.core.ITransientMap = function() {
};
cljs.core._dissoc_BANG_ = function cljs$core$_dissoc_BANG_(tcoll, key) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 == null)) {
    return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll, key);
  } else {
    var x__4211__auto__ = tcoll == null ? null : tcoll;
    var m__4212__auto__ = cljs.core._dissoc_BANG_[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(tcoll, key) : m__4212__auto__.call(null, tcoll, key);
    } else {
      var m__4212__auto____$1 = cljs.core._dissoc_BANG_["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll, key) : m__4212__auto____$1.call(null, tcoll, key);
      } else {
        throw cljs.core.missing_protocol("ITransientMap.-dissoc!", tcoll);
      }
    }
  }
};
cljs.core.ITransientVector = function() {
};
cljs.core._assoc_n_BANG_ = function cljs$core$_assoc_n_BANG_(tcoll, n, val) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 == null)) {
    return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll, n, val);
  } else {
    var x__4211__auto__ = tcoll == null ? null : tcoll;
    var m__4212__auto__ = cljs.core._assoc_n_BANG_[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$3(tcoll, n, val) : m__4212__auto__.call(null, tcoll, n, val);
    } else {
      var m__4212__auto____$1 = cljs.core._assoc_n_BANG_["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3(tcoll, n, val) : m__4212__auto____$1.call(null, tcoll, n, val);
      } else {
        throw cljs.core.missing_protocol("ITransientVector.-assoc-n!", tcoll);
      }
    }
  }
};
cljs.core._pop_BANG_ = function cljs$core$_pop_BANG_(tcoll) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1 == null)) {
    return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
  } else {
    var x__4211__auto__ = tcoll == null ? null : tcoll;
    var m__4212__auto__ = cljs.core._pop_BANG_[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__4212__auto__.call(null, tcoll);
    } else {
      var m__4212__auto____$1 = cljs.core._pop_BANG_["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(tcoll) : m__4212__auto____$1.call(null, tcoll);
      } else {
        throw cljs.core.missing_protocol("ITransientVector.-pop!", tcoll);
      }
    }
  }
};
cljs.core.ITransientSet = function() {
};
cljs.core._disjoin_BANG_ = function cljs$core$_disjoin_BANG_(tcoll, v) {
  if (!(tcoll == null) && !(tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 == null)) {
    return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll, v);
  } else {
    var x__4211__auto__ = tcoll == null ? null : tcoll;
    var m__4212__auto__ = cljs.core._disjoin_BANG_[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(tcoll, v) : m__4212__auto__.call(null, tcoll, v);
    } else {
      var m__4212__auto____$1 = cljs.core._disjoin_BANG_["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll, v) : m__4212__auto____$1.call(null, tcoll, v);
      } else {
        throw cljs.core.missing_protocol("ITransientSet.-disjoin!", tcoll);
      }
    }
  }
};
cljs.core.IComparable = function() {
};
cljs.core._compare = function cljs$core$_compare(x, y) {
  if (!(x == null) && !(x.cljs$core$IComparable$_compare$arity$2 == null)) {
    return x.cljs$core$IComparable$_compare$arity$2(x, y);
  } else {
    var x__4211__auto__ = x == null ? null : x;
    var m__4212__auto__ = cljs.core._compare[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(x, y) : m__4212__auto__.call(null, x, y);
    } else {
      var m__4212__auto____$1 = cljs.core._compare["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(x, y) : m__4212__auto____$1.call(null, x, y);
      } else {
        throw cljs.core.missing_protocol("IComparable.-compare", x);
      }
    }
  }
};
cljs.core.IChunk = function() {
};
cljs.core._drop_first = function cljs$core$_drop_first(coll) {
  if (!(coll == null) && !(coll.cljs$core$IChunk$_drop_first$arity$1 == null)) {
    return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._drop_first[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto__.call(null, coll);
    } else {
      var m__4212__auto____$1 = cljs.core._drop_first["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IChunk.-drop-first", coll);
      }
    }
  }
};
cljs.core.IChunkedSeq = function() {
};
cljs.core._chunked_first = function cljs$core$_chunked_first(coll) {
  if (!(coll == null) && !(coll.cljs$core$IChunkedSeq$_chunked_first$arity$1 == null)) {
    return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._chunked_first[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto__.call(null, coll);
    } else {
      var m__4212__auto____$1 = cljs.core._chunked_first["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first", coll);
      }
    }
  }
};
cljs.core._chunked_rest = function cljs$core$_chunked_rest(coll) {
  if (!(coll == null) && !(coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1 == null)) {
    return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._chunked_rest[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto__.call(null, coll);
    } else {
      var m__4212__auto____$1 = cljs.core._chunked_rest["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest", coll);
      }
    }
  }
};
cljs.core.IChunkedNext = function() {
};
cljs.core._chunked_next = function cljs$core$_chunked_next(coll) {
  if (!(coll == null) && !(coll.cljs$core$IChunkedNext$_chunked_next$arity$1 == null)) {
    return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._chunked_next[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto__.call(null, coll);
    } else {
      var m__4212__auto____$1 = cljs.core._chunked_next["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IChunkedNext.-chunked-next", coll);
      }
    }
  }
};
cljs.core.INamed = function() {
};
cljs.core._name = function cljs$core$_name(x) {
  if (!(x == null) && !(x.cljs$core$INamed$_name$arity$1 == null)) {
    return x.cljs$core$INamed$_name$arity$1(x);
  } else {
    var x__4211__auto__ = x == null ? null : x;
    var m__4212__auto__ = cljs.core._name[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4212__auto__.call(null, x);
    } else {
      var m__4212__auto____$1 = cljs.core._name["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__4212__auto____$1.call(null, x);
      } else {
        throw cljs.core.missing_protocol("INamed.-name", x);
      }
    }
  }
};
cljs.core._namespace = function cljs$core$_namespace(x) {
  if (!(x == null) && !(x.cljs$core$INamed$_namespace$arity$1 == null)) {
    return x.cljs$core$INamed$_namespace$arity$1(x);
  } else {
    var x__4211__auto__ = x == null ? null : x;
    var m__4212__auto__ = cljs.core._namespace[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4212__auto__.call(null, x);
    } else {
      var m__4212__auto____$1 = cljs.core._namespace["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__4212__auto____$1.call(null, x);
      } else {
        throw cljs.core.missing_protocol("INamed.-namespace", x);
      }
    }
  }
};
cljs.core.IAtom = function() {
};
cljs.core.IReset = function() {
};
cljs.core._reset_BANG_ = function cljs$core$_reset_BANG_(o, new_value) {
  if (!(o == null) && !(o.cljs$core$IReset$_reset_BANG_$arity$2 == null)) {
    return o.cljs$core$IReset$_reset_BANG_$arity$2(o, new_value);
  } else {
    var x__4211__auto__ = o == null ? null : o;
    var m__4212__auto__ = cljs.core._reset_BANG_[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(o, new_value) : m__4212__auto__.call(null, o, new_value);
    } else {
      var m__4212__auto____$1 = cljs.core._reset_BANG_["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(o, new_value) : m__4212__auto____$1.call(null, o, new_value);
      } else {
        throw cljs.core.missing_protocol("IReset.-reset!", o);
      }
    }
  }
};
cljs.core.ISwap = function() {
};
cljs.core._swap_BANG_ = function cljs$core$_swap_BANG_(var_args) {
  var G__4467 = arguments.length;
  switch(G__4467) {
    case 2:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = function(o, f) {
  if (!(o == null) && !(o.cljs$core$ISwap$_swap_BANG_$arity$2 == null)) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$2(o, f);
  } else {
    var x__4211__auto__ = o == null ? null : o;
    var m__4212__auto__ = cljs.core._swap_BANG_[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(o, f) : m__4212__auto__.call(null, o, f);
    } else {
      var m__4212__auto____$1 = cljs.core._swap_BANG_["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(o, f) : m__4212__auto____$1.call(null, o, f);
      } else {
        throw cljs.core.missing_protocol("ISwap.-swap!", o);
      }
    }
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = function(o, f, a) {
  if (!(o == null) && !(o.cljs$core$ISwap$_swap_BANG_$arity$3 == null)) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$3(o, f, a);
  } else {
    var x__4211__auto__ = o == null ? null : o;
    var m__4212__auto__ = cljs.core._swap_BANG_[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$3(o, f, a) : m__4212__auto__.call(null, o, f, a);
    } else {
      var m__4212__auto____$1 = cljs.core._swap_BANG_["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$3(o, f, a) : m__4212__auto____$1.call(null, o, f, a);
      } else {
        throw cljs.core.missing_protocol("ISwap.-swap!", o);
      }
    }
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = function(o, f, a, b) {
  if (!(o == null) && !(o.cljs$core$ISwap$_swap_BANG_$arity$4 == null)) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$4(o, f, a, b);
  } else {
    var x__4211__auto__ = o == null ? null : o;
    var m__4212__auto__ = cljs.core._swap_BANG_[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$4(o, f, a, b) : m__4212__auto__.call(null, o, f, a, b);
    } else {
      var m__4212__auto____$1 = cljs.core._swap_BANG_["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$4(o, f, a, b) : m__4212__auto____$1.call(null, o, f, a, b);
      } else {
        throw cljs.core.missing_protocol("ISwap.-swap!", o);
      }
    }
  }
};
cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = function(o, f, a, b, xs) {
  if (!(o == null) && !(o.cljs$core$ISwap$_swap_BANG_$arity$5 == null)) {
    return o.cljs$core$ISwap$_swap_BANG_$arity$5(o, f, a, b, xs);
  } else {
    var x__4211__auto__ = o == null ? null : o;
    var m__4212__auto__ = cljs.core._swap_BANG_[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$5(o, f, a, b, xs) : m__4212__auto__.call(null, o, f, a, b, xs);
    } else {
      var m__4212__auto____$1 = cljs.core._swap_BANG_["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$5 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$5(o, f, a, b, xs) : m__4212__auto____$1.call(null, o, f, a, b, xs);
      } else {
        throw cljs.core.missing_protocol("ISwap.-swap!", o);
      }
    }
  }
};
cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5;
cljs.core.IVolatile = function() {
};
cljs.core._vreset_BANG_ = function cljs$core$_vreset_BANG_(o, new_value) {
  if (!(o == null) && !(o.cljs$core$IVolatile$_vreset_BANG_$arity$2 == null)) {
    return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o, new_value);
  } else {
    var x__4211__auto__ = o == null ? null : o;
    var m__4212__auto__ = cljs.core._vreset_BANG_[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$2(o, new_value) : m__4212__auto__.call(null, o, new_value);
    } else {
      var m__4212__auto____$1 = cljs.core._vreset_BANG_["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$2(o, new_value) : m__4212__auto____$1.call(null, o, new_value);
      } else {
        throw cljs.core.missing_protocol("IVolatile.-vreset!", o);
      }
    }
  }
};
cljs.core.IIterable = function() {
};
cljs.core._iterator = function cljs$core$_iterator(coll) {
  if (!(coll == null) && !(coll.cljs$core$IIterable$_iterator$arity$1 == null)) {
    return coll.cljs$core$IIterable$_iterator$arity$1(coll);
  } else {
    var x__4211__auto__ = coll == null ? null : coll;
    var m__4212__auto__ = cljs.core._iterator[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto__.call(null, coll);
    } else {
      var m__4212__auto____$1 = cljs.core._iterator["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__4212__auto____$1.call(null, coll);
      } else {
        throw cljs.core.missing_protocol("IIterable.-iterator", coll);
      }
    }
  }
};
cljs.core.StringBufferWriter = function(sb) {
  this.sb = sb;
  this.cljs$lang$protocol_mask$partition0$ = 1073741824;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = function(_, s) {
  var self__ = this;
  var ___$1 = this;
  return self__.sb.append(s);
};
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return null;
};
cljs.core.StringBufferWriter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "sb", "sb", -1249746442, null)], null);
};
cljs.core.StringBufferWriter.cljs$lang$type = true;
cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter";
cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/StringBufferWriter");
};
cljs.core.__GT_StringBufferWriter = function cljs$core$__GT_StringBufferWriter(sb) {
  return new cljs.core.StringBufferWriter(sb);
};
cljs.core.pr_str_STAR_ = function cljs$core$pr_str_STAR_(obj) {
  var sb = new goog.string.StringBuffer;
  var writer = new cljs.core.StringBufferWriter(sb);
  obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null, writer, cljs.core.pr_opts());
  writer.cljs$core$IWriter$_flush$arity$1(null);
  return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb)].join("");
};
cljs.core.int_rotate_left = function cljs$core$int_rotate_left(x, n) {
  return x << n | x >>> -n;
};
if (typeof Math.imul !== "undefined" && !(Math.imul(4294967295, 5) === 0)) {
  cljs.core.imul = function cljs$core$imul(a, b) {
    return Math.imul(a, b);
  };
} else {
  cljs.core.imul = function cljs$core$imul(a, b) {
    var ah = a >>> 16 & 65535;
    var al = a & 65535;
    var bh = b >>> 16 & 65535;
    var bl = b & 65535;
    return al * bl + (ah * bl + al * bh << 16 >>> 0) | 0;
  };
}
cljs.core.m3_seed = 0;
cljs.core.m3_C1 = 3432918353 | 0;
cljs.core.m3_C2 = 461845907 | 0;
cljs.core.m3_mix_K1 = function cljs$core$m3_mix_K1(k1) {
  return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul(k1 | 0, cljs.core.m3_C1), 15), cljs.core.m3_C2);
};
cljs.core.m3_mix_H1 = function cljs$core$m3_mix_H1(h1, k1) {
  return cljs.core.imul(cljs.core.int_rotate_left((h1 | 0) ^ (k1 | 0), 13), 5) + (3864292196 | 0) | 0;
};
cljs.core.m3_fmix = function cljs$core$m3_fmix(h1, len) {
  var h1__$1 = h1 | 0;
  var h1__$2 = h1__$1 ^ len;
  var h1__$3 = h1__$2 ^ h1__$2 >>> 16;
  var h1__$4 = cljs.core.imul(h1__$3, 2246822507 | 0);
  var h1__$5 = h1__$4 ^ h1__$4 >>> 13;
  var h1__$6 = cljs.core.imul(h1__$5, 3266489909 | 0);
  return h1__$6 ^ h1__$6 >>> 16;
};
cljs.core.m3_hash_int = function cljs$core$m3_hash_int(in$) {
  if (in$ === 0) {
    return in$;
  } else {
    var k1 = cljs.core.m3_mix_K1(in$);
    var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed, k1);
    return cljs.core.m3_fmix(h1, 4);
  }
};
cljs.core.m3_hash_unencoded_chars = function cljs$core$m3_hash_unencoded_chars(in$) {
  var h1 = function() {
    var i = 1;
    var h1 = cljs.core.m3_seed;
    while (true) {
      if (i < in$.length) {
        var G__4469 = i + 2;
        var G__4470 = cljs.core.m3_mix_H1(h1, cljs.core.m3_mix_K1(in$.charCodeAt(i - 1) | in$.charCodeAt(i) << 16));
        i = G__4469;
        h1 = G__4470;
        continue;
      } else {
        return h1;
      }
      break;
    }
  }();
  var h1__$1 = (in$.length & 1) === 1 ? h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt(in$.length - 1)) : h1;
  return cljs.core.m3_fmix(h1__$1, cljs.core.imul(2, in$.length));
};
cljs.core.string_hash_cache = {};
cljs.core.string_hash_cache_count = 0;
cljs.core.hash_string_STAR_ = function cljs$core$hash_string_STAR_(s) {
  if (!(s == null)) {
    var len = s.length;
    if (len > 0) {
      var i = 0;
      var hash = 0;
      while (true) {
        if (i < len) {
          var G__4473 = i + 1;
          var G__4474 = cljs.core.imul(31, hash) + s.charCodeAt(i);
          i = G__4473;
          hash = G__4474;
          continue;
        } else {
          return hash;
        }
        break;
      }
    } else {
      return 0;
    }
  } else {
    return 0;
  }
};
cljs.core.add_to_string_hash_cache = function cljs$core$add_to_string_hash_cache(k) {
  var h = cljs.core.hash_string_STAR_(k);
  goog.object.set(cljs.core.string_hash_cache, k, h);
  cljs.core.string_hash_cache_count = cljs.core.string_hash_cache_count + 1;
  return h;
};
cljs.core.hash_string = function cljs$core$hash_string(k) {
  if (cljs.core.string_hash_cache_count > 255) {
    cljs.core.string_hash_cache = {};
    cljs.core.string_hash_cache_count = 0;
  } else {
  }
  if (k == null) {
    return 0;
  } else {
    var h = cljs.core.string_hash_cache[k];
    if (typeof h === "number") {
      return h;
    } else {
      return cljs.core.add_to_string_hash_cache(k);
    }
  }
};
cljs.core.hash = function cljs$core$hash(o) {
  if (!(o == null) ? o.cljs$lang$protocol_mask$partition0$ & 4194304 || cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IHash$ ? true : false : false) {
    return o.cljs$core$IHash$_hash$arity$1(null) ^ 0;
  } else {
    if (typeof o === "number") {
      if (cljs.core.truth_(isFinite(o))) {
        return Math.floor(o) % 2147483647;
      } else {
        var G__4478 = o;
        switch(G__4478) {
          case Infinity:
            return 2146435072;
            break;
          case -Infinity:
            return -1048576;
            break;
          default:
            return 2146959360;
        }
      }
    } else {
      if (o === true) {
        return 1231;
      } else {
        if (o === false) {
          return 1237;
        } else {
          if (typeof o === "string") {
            return cljs.core.m3_hash_int(cljs.core.hash_string(o));
          } else {
            if (o instanceof Date) {
              return o.valueOf() ^ 0;
            } else {
              if (o == null) {
                return 0;
              } else {
                return cljs.core._hash(o) ^ 0;
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.hash_combine = function cljs$core$hash_combine(seed, hash) {
  return seed ^ hash + 2654435769 + (seed << 6) + (seed >> 2);
};
cljs.core.instance_QMARK_ = function cljs$core$instance_QMARK_(c, x) {
  return x instanceof c;
};
cljs.core.symbol_QMARK_ = function cljs$core$symbol_QMARK_(x) {
  return x instanceof cljs.core.Symbol;
};
cljs.core.hash_symbol = function cljs$core$hash_symbol(sym) {
  return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name), cljs.core.hash_string(sym.ns));
};
cljs.core.compare_symbols = function cljs$core$compare_symbols(a, b) {
  if (a.str === b.str) {
    return 0;
  } else {
    if (cljs.core.truth_(function() {
      var and__3911__auto__ = cljs.core.not(a.ns);
      if (and__3911__auto__) {
        return b.ns;
      } else {
        return and__3911__auto__;
      }
    }())) {
      return -1;
    } else {
      if (cljs.core.truth_(a.ns)) {
        if (cljs.core.not(b.ns)) {
          return 1;
        } else {
          var nsc = function() {
            var G__4480 = a.ns;
            var G__4481 = b.ns;
            return goog.array.defaultCompare(G__4480, G__4481);
          }();
          if (0 === nsc) {
            var G__4482 = a.name;
            var G__4483 = b.name;
            return goog.array.defaultCompare(G__4482, G__4483);
          } else {
            return nsc;
          }
        }
      } else {
        var G__4484 = a.name;
        var G__4485 = b.name;
        return goog.array.defaultCompare(G__4484, G__4485);
      }
    }
  }
};
cljs.core.Symbol = function(ns, name, str, _hash, _meta) {
  this.ns = ns;
  this.name = name;
  this.str = str;
  this._hash = _hash;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 2154168321;
  this.cljs$lang$protocol_mask$partition1$ = 4096;
};
cljs.core.Symbol.prototype.toString = function() {
  var self__ = this;
  var _ = this;
  return self__.str;
};
cljs.core.Symbol.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(_, other) {
  var self__ = this;
  var ___$1 = this;
  if (other instanceof cljs.core.Symbol) {
    return self__.str === other.str;
  } else {
    return false;
  }
};
cljs.core.Symbol.prototype.call = function() {
  var G__4487 = null;
  var G__4487__2 = function(self__, coll) {
    var self__ = this;
    var self____$1 = this;
    var sym = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, sym);
  };
  var G__4487__3 = function(self__, coll, not_found) {
    var self__ = this;
    var self____$1 = this;
    var sym = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, sym, not_found);
  };
  G__4487 = function(self__, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__4487__2.call(this, self__, coll);
      case 3:
        return G__4487__3.call(this, self__, coll, not_found);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__4487.cljs$core$IFn$_invoke$arity$2 = G__4487__2;
  G__4487.cljs$core$IFn$_invoke$arity$3 = G__4487__3;
  return G__4487;
}();
cljs.core.Symbol.prototype.apply = function(self__, args4486) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args4486)));
};
cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  var self__ = this;
  var sym = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, sym);
};
cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = function(coll, not_found) {
  var self__ = this;
  var sym = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, sym, not_found);
};
cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__._meta;
};
cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_, new_meta) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Symbol(self__.ns, self__.name, self__.str, self__._hash, new_meta);
};
cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = function(sym) {
  var self__ = this;
  var sym__$1 = this;
  var h__4030__auto__ = self__._hash;
  if (!(h__4030__auto__ == null)) {
    return h__4030__auto__;
  } else {
    var h__4030__auto____$1 = cljs.core.hash_symbol(sym__$1);
    self__._hash = h__4030__auto____$1;
    return h__4030__auto____$1;
  }
};
cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.name;
};
cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.ns;
};
cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = function(o, writer, _) {
  var self__ = this;
  var o__$1 = this;
  return cljs.core._write(writer, self__.str);
};
cljs.core.Symbol.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "ns", "ns", 2082130287, null), new cljs.core.Symbol(null, "name", "name", -810760592, null), new cljs.core.Symbol(null, "str", "str", -1564826950, null), cljs.core.with_meta(new cljs.core.Symbol(null, "_hash", "_hash", -2130838312, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, 
  "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.Symbol.cljs$lang$type = true;
cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol";
cljs.core.Symbol.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/Symbol");
};
cljs.core.__GT_Symbol = function cljs$core$__GT_Symbol(ns, name, str, _hash, _meta) {
  return new cljs.core.Symbol(ns, name, str, _hash, _meta);
};
cljs.core.symbol = function cljs$core$symbol(var_args) {
  var G__4489 = arguments.length;
  switch(G__4489) {
    case 1:
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = function(name) {
  if (name instanceof cljs.core.Symbol) {
    return name;
  } else {
    var idx = name.indexOf("/");
    if (idx < 1) {
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null, name);
    } else {
      return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(name.substring(0, idx), name.substring(idx + 1, name.length));
    }
  }
};
cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = function(ns, name) {
  var sym_str = !(ns == null) ? [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns), "/", cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join("") : name;
  return new cljs.core.Symbol(ns, name, sym_str, null, null);
};
cljs.core.symbol.cljs$lang$maxFixedArity = 2;
cljs.core.Var = function(val, sym, _meta) {
  this.val = val;
  this.sym = sym;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 6717441;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.Var.prototype.isMacro = function() {
  var self__ = this;
  var _ = this;
  return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).cljs$lang$macro;
};
cljs.core.Var.prototype.toString = function() {
  var self__ = this;
  var _ = this;
  return ["#'", cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.sym)].join("");
};
cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
};
cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__._meta;
};
cljs.core.Var.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_, new_meta) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Var(self__.val, self__.sym, new_meta);
};
cljs.core.Var.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(this$, other) {
  var self__ = this;
  var this$__$1 = this;
  if (other instanceof cljs.core.Var) {
    return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this$__$1.sym, other.sym);
  } else {
    return false;
  }
};
cljs.core.Var.prototype.cljs$core$IHash$_hash$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return cljs.core.hash_symbol(self__.sym);
};
cljs.core.Var.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.Var.prototype.call = function() {
  var G__4534 = null;
  var G__4534__1 = function(self__) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var fexpr__4492 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    return fexpr__4492.cljs$core$IFn$_invoke$arity$0 ? fexpr__4492.cljs$core$IFn$_invoke$arity$0() : fexpr__4492.call(null);
  };
  var G__4534__2 = function(self__, a) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var fexpr__4493 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    return fexpr__4493.cljs$core$IFn$_invoke$arity$1 ? fexpr__4493.cljs$core$IFn$_invoke$arity$1(a) : fexpr__4493.call(null, a);
  };
  var G__4534__3 = function(self__, a, b) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var fexpr__4494 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    return fexpr__4494.cljs$core$IFn$_invoke$arity$2 ? fexpr__4494.cljs$core$IFn$_invoke$arity$2(a, b) : fexpr__4494.call(null, a, b);
  };
  var G__4534__4 = function(self__, a, b, c) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var fexpr__4495 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    return fexpr__4495.cljs$core$IFn$_invoke$arity$3 ? fexpr__4495.cljs$core$IFn$_invoke$arity$3(a, b, c) : fexpr__4495.call(null, a, b, c);
  };
  var G__4534__5 = function(self__, a, b, c, d) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var fexpr__4496 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    return fexpr__4496.cljs$core$IFn$_invoke$arity$4 ? fexpr__4496.cljs$core$IFn$_invoke$arity$4(a, b, c, d) : fexpr__4496.call(null, a, b, c, d);
  };
  var G__4534__6 = function(self__, a, b, c, d, e) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var fexpr__4497 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    return fexpr__4497.cljs$core$IFn$_invoke$arity$5 ? fexpr__4497.cljs$core$IFn$_invoke$arity$5(a, b, c, d, e) : fexpr__4497.call(null, a, b, c, d, e);
  };
  var G__4534__7 = function(self__, a, b, c, d, e, f) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var fexpr__4498 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    return fexpr__4498.cljs$core$IFn$_invoke$arity$6 ? fexpr__4498.cljs$core$IFn$_invoke$arity$6(a, b, c, d, e, f) : fexpr__4498.call(null, a, b, c, d, e, f);
  };
  var G__4534__8 = function(self__, a, b, c, d, e, f, g) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var fexpr__4499 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    return fexpr__4499.cljs$core$IFn$_invoke$arity$7 ? fexpr__4499.cljs$core$IFn$_invoke$arity$7(a, b, c, d, e, f, g) : fexpr__4499.call(null, a, b, c, d, e, f, g);
  };
  var G__4534__9 = function(self__, a, b, c, d, e, f, g, h) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var fexpr__4500 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    return fexpr__4500.cljs$core$IFn$_invoke$arity$8 ? fexpr__4500.cljs$core$IFn$_invoke$arity$8(a, b, c, d, e, f, g, h) : fexpr__4500.call(null, a, b, c, d, e, f, g, h);
  };
  var G__4534__10 = function(self__, a, b, c, d, e, f, g, h, i) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var fexpr__4501 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    return fexpr__4501.cljs$core$IFn$_invoke$arity$9 ? fexpr__4501.cljs$core$IFn$_invoke$arity$9(a, b, c, d, e, f, g, h, i) : fexpr__4501.call(null, a, b, c, d, e, f, g, h, i);
  };
  var G__4534__11 = function(self__, a, b, c, d, e, f, g, h, i, j) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var fexpr__4502 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    return fexpr__4502.cljs$core$IFn$_invoke$arity$10 ? fexpr__4502.cljs$core$IFn$_invoke$arity$10(a, b, c, d, e, f, g, h, i, j) : fexpr__4502.call(null, a, b, c, d, e, f, g, h, i, j);
  };
  var G__4534__12 = function(self__, a, b, c, d, e, f, g, h, i, j, k) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var fexpr__4503 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    return fexpr__4503.cljs$core$IFn$_invoke$arity$11 ? fexpr__4503.cljs$core$IFn$_invoke$arity$11(a, b, c, d, e, f, g, h, i, j, k) : fexpr__4503.call(null, a, b, c, d, e, f, g, h, i, j, k);
  };
  var G__4534__13 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var fexpr__4504 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    return fexpr__4504.cljs$core$IFn$_invoke$arity$12 ? fexpr__4504.cljs$core$IFn$_invoke$arity$12(a, b, c, d, e, f, g, h, i, j, k, l) : fexpr__4504.call(null, a, b, c, d, e, f, g, h, i, j, k, l);
  };
  var G__4534__14 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var fexpr__4505 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    return fexpr__4505.cljs$core$IFn$_invoke$arity$13 ? fexpr__4505.cljs$core$IFn$_invoke$arity$13(a, b, c, d, e, f, g, h, i, j, k, l, m) : fexpr__4505.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
  };
  var G__4534__15 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var fexpr__4506 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    return fexpr__4506.cljs$core$IFn$_invoke$arity$14 ? fexpr__4506.cljs$core$IFn$_invoke$arity$14(a, b, c, d, e, f, g, h, i, j, k, l, m, n) : fexpr__4506.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  };
  var G__4534__16 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var fexpr__4507 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    return fexpr__4507.cljs$core$IFn$_invoke$arity$15 ? fexpr__4507.cljs$core$IFn$_invoke$arity$15(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) : fexpr__4507.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  };
  var G__4534__17 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var fexpr__4508 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    return fexpr__4508.cljs$core$IFn$_invoke$arity$16 ? fexpr__4508.cljs$core$IFn$_invoke$arity$16(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) : fexpr__4508.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  };
  var G__4534__18 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var fexpr__4509 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    return fexpr__4509.cljs$core$IFn$_invoke$arity$17 ? fexpr__4509.cljs$core$IFn$_invoke$arity$17(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) : fexpr__4509.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  };
  var G__4534__19 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var fexpr__4510 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    return fexpr__4510.cljs$core$IFn$_invoke$arity$18 ? fexpr__4510.cljs$core$IFn$_invoke$arity$18(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) : fexpr__4510.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  };
  var G__4534__20 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var fexpr__4511 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    return fexpr__4511.cljs$core$IFn$_invoke$arity$19 ? fexpr__4511.cljs$core$IFn$_invoke$arity$19(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) : fexpr__4511.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  };
  var G__4534__21 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    var fexpr__4512 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
    return fexpr__4512.cljs$core$IFn$_invoke$arity$20 ? fexpr__4512.cljs$core$IFn$_invoke$arity$20(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) : fexpr__4512.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  };
  var G__4534__22 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null), a, b, c, d, cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest], 0));
  };
  G__4534 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return G__4534__1.call(this, self__);
      case 2:
        return G__4534__2.call(this, self__, a);
      case 3:
        return G__4534__3.call(this, self__, a, b);
      case 4:
        return G__4534__4.call(this, self__, a, b, c);
      case 5:
        return G__4534__5.call(this, self__, a, b, c, d);
      case 6:
        return G__4534__6.call(this, self__, a, b, c, d, e);
      case 7:
        return G__4534__7.call(this, self__, a, b, c, d, e, f);
      case 8:
        return G__4534__8.call(this, self__, a, b, c, d, e, f, g);
      case 9:
        return G__4534__9.call(this, self__, a, b, c, d, e, f, g, h);
      case 10:
        return G__4534__10.call(this, self__, a, b, c, d, e, f, g, h, i);
      case 11:
        return G__4534__11.call(this, self__, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return G__4534__12.call(this, self__, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return G__4534__13.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return G__4534__14.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return G__4534__15.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return G__4534__16.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return G__4534__17.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return G__4534__18.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return G__4534__19.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
      case 20:
        return G__4534__20.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
      case 21:
        return G__4534__21.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
      case 22:
        return G__4534__22.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__4534.cljs$core$IFn$_invoke$arity$1 = G__4534__1;
  G__4534.cljs$core$IFn$_invoke$arity$2 = G__4534__2;
  G__4534.cljs$core$IFn$_invoke$arity$3 = G__4534__3;
  G__4534.cljs$core$IFn$_invoke$arity$4 = G__4534__4;
  G__4534.cljs$core$IFn$_invoke$arity$5 = G__4534__5;
  G__4534.cljs$core$IFn$_invoke$arity$6 = G__4534__6;
  G__4534.cljs$core$IFn$_invoke$arity$7 = G__4534__7;
  G__4534.cljs$core$IFn$_invoke$arity$8 = G__4534__8;
  G__4534.cljs$core$IFn$_invoke$arity$9 = G__4534__9;
  G__4534.cljs$core$IFn$_invoke$arity$10 = G__4534__10;
  G__4534.cljs$core$IFn$_invoke$arity$11 = G__4534__11;
  G__4534.cljs$core$IFn$_invoke$arity$12 = G__4534__12;
  G__4534.cljs$core$IFn$_invoke$arity$13 = G__4534__13;
  G__4534.cljs$core$IFn$_invoke$arity$14 = G__4534__14;
  G__4534.cljs$core$IFn$_invoke$arity$15 = G__4534__15;
  G__4534.cljs$core$IFn$_invoke$arity$16 = G__4534__16;
  G__4534.cljs$core$IFn$_invoke$arity$17 = G__4534__17;
  G__4534.cljs$core$IFn$_invoke$arity$18 = G__4534__18;
  G__4534.cljs$core$IFn$_invoke$arity$19 = G__4534__19;
  G__4534.cljs$core$IFn$_invoke$arity$20 = G__4534__20;
  G__4534.cljs$core$IFn$_invoke$arity$21 = G__4534__21;
  G__4534.cljs$core$IFn$_invoke$arity$22 = G__4534__22;
  return G__4534;
}();
cljs.core.Var.prototype.apply = function(self__, args4491) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args4491)));
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = function() {
  var self__ = this;
  var _ = this;
  var fexpr__4513 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  return fexpr__4513.cljs$core$IFn$_invoke$arity$0 ? fexpr__4513.cljs$core$IFn$_invoke$arity$0() : fexpr__4513.call(null);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = function(a) {
  var self__ = this;
  var _ = this;
  var fexpr__4514 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  return fexpr__4514.cljs$core$IFn$_invoke$arity$1 ? fexpr__4514.cljs$core$IFn$_invoke$arity$1(a) : fexpr__4514.call(null, a);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = function(a, b) {
  var self__ = this;
  var _ = this;
  var fexpr__4515 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  return fexpr__4515.cljs$core$IFn$_invoke$arity$2 ? fexpr__4515.cljs$core$IFn$_invoke$arity$2(a, b) : fexpr__4515.call(null, a, b);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = function(a, b, c) {
  var self__ = this;
  var _ = this;
  var fexpr__4516 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  return fexpr__4516.cljs$core$IFn$_invoke$arity$3 ? fexpr__4516.cljs$core$IFn$_invoke$arity$3(a, b, c) : fexpr__4516.call(null, a, b, c);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, d) {
  var self__ = this;
  var _ = this;
  var fexpr__4517 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  return fexpr__4517.cljs$core$IFn$_invoke$arity$4 ? fexpr__4517.cljs$core$IFn$_invoke$arity$4(a, b, c, d) : fexpr__4517.call(null, a, b, c, d);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = function(a, b, c, d, e) {
  var self__ = this;
  var _ = this;
  var fexpr__4518 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  return fexpr__4518.cljs$core$IFn$_invoke$arity$5 ? fexpr__4518.cljs$core$IFn$_invoke$arity$5(a, b, c, d, e) : fexpr__4518.call(null, a, b, c, d, e);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = function(a, b, c, d, e, f) {
  var self__ = this;
  var _ = this;
  var fexpr__4519 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  return fexpr__4519.cljs$core$IFn$_invoke$arity$6 ? fexpr__4519.cljs$core$IFn$_invoke$arity$6(a, b, c, d, e, f) : fexpr__4519.call(null, a, b, c, d, e, f);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = function(a, b, c, d, e, f, g) {
  var self__ = this;
  var _ = this;
  var fexpr__4520 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  return fexpr__4520.cljs$core$IFn$_invoke$arity$7 ? fexpr__4520.cljs$core$IFn$_invoke$arity$7(a, b, c, d, e, f, g) : fexpr__4520.call(null, a, b, c, d, e, f, g);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = function(a, b, c, d, e, f, g, h) {
  var self__ = this;
  var _ = this;
  var fexpr__4521 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  return fexpr__4521.cljs$core$IFn$_invoke$arity$8 ? fexpr__4521.cljs$core$IFn$_invoke$arity$8(a, b, c, d, e, f, g, h) : fexpr__4521.call(null, a, b, c, d, e, f, g, h);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = function(a, b, c, d, e, f, g, h, i) {
  var self__ = this;
  var _ = this;
  var fexpr__4522 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  return fexpr__4522.cljs$core$IFn$_invoke$arity$9 ? fexpr__4522.cljs$core$IFn$_invoke$arity$9(a, b, c, d, e, f, g, h, i) : fexpr__4522.call(null, a, b, c, d, e, f, g, h, i);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = function(a, b, c, d, e, f, g, h, i, j) {
  var self__ = this;
  var _ = this;
  var fexpr__4523 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  return fexpr__4523.cljs$core$IFn$_invoke$arity$10 ? fexpr__4523.cljs$core$IFn$_invoke$arity$10(a, b, c, d, e, f, g, h, i, j) : fexpr__4523.call(null, a, b, c, d, e, f, g, h, i, j);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = function(a, b, c, d, e, f, g, h, i, j, k) {
  var self__ = this;
  var _ = this;
  var fexpr__4524 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  return fexpr__4524.cljs$core$IFn$_invoke$arity$11 ? fexpr__4524.cljs$core$IFn$_invoke$arity$11(a, b, c, d, e, f, g, h, i, j, k) : fexpr__4524.call(null, a, b, c, d, e, f, g, h, i, j, k);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = function(a, b, c, d, e, f, g, h, i, j, k, l) {
  var self__ = this;
  var _ = this;
  var fexpr__4525 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  return fexpr__4525.cljs$core$IFn$_invoke$arity$12 ? fexpr__4525.cljs$core$IFn$_invoke$arity$12(a, b, c, d, e, f, g, h, i, j, k, l) : fexpr__4525.call(null, a, b, c, d, e, f, g, h, i, j, k, l);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = function(a, b, c, d, e, f, g, h, i, j, k, l, m) {
  var self__ = this;
  var _ = this;
  var fexpr__4526 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  return fexpr__4526.cljs$core$IFn$_invoke$arity$13 ? fexpr__4526.cljs$core$IFn$_invoke$arity$13(a, b, c, d, e, f, g, h, i, j, k, l, m) : fexpr__4526.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  var self__ = this;
  var _ = this;
  var fexpr__4527 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  return fexpr__4527.cljs$core$IFn$_invoke$arity$14 ? fexpr__4527.cljs$core$IFn$_invoke$arity$14(a, b, c, d, e, f, g, h, i, j, k, l, m, n) : fexpr__4527.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  var self__ = this;
  var _ = this;
  var fexpr__4528 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  return fexpr__4528.cljs$core$IFn$_invoke$arity$15 ? fexpr__4528.cljs$core$IFn$_invoke$arity$15(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) : fexpr__4528.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  var self__ = this;
  var _ = this;
  var fexpr__4529 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  return fexpr__4529.cljs$core$IFn$_invoke$arity$16 ? fexpr__4529.cljs$core$IFn$_invoke$arity$16(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) : fexpr__4529.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  var self__ = this;
  var _ = this;
  var fexpr__4530 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  return fexpr__4530.cljs$core$IFn$_invoke$arity$17 ? fexpr__4530.cljs$core$IFn$_invoke$arity$17(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) : fexpr__4530.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  var self__ = this;
  var _ = this;
  var fexpr__4531 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  return fexpr__4531.cljs$core$IFn$_invoke$arity$18 ? fexpr__4531.cljs$core$IFn$_invoke$arity$18(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) : fexpr__4531.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  var self__ = this;
  var _ = this;
  var fexpr__4532 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  return fexpr__4532.cljs$core$IFn$_invoke$arity$19 ? fexpr__4532.cljs$core$IFn$_invoke$arity$19(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) : fexpr__4532.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  var self__ = this;
  var _ = this;
  var fexpr__4533 = self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null);
  return fexpr__4533.cljs$core$IFn$_invoke$arity$20 ? fexpr__4533.cljs$core$IFn$_invoke$arity$20(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) : fexpr__4533.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
};
cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  var self__ = this;
  var _ = this;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null), a, b, c, d, cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest], 0));
};
cljs.core.Var.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "val", "val", 1769233139, null), new cljs.core.Symbol(null, "sym", "sym", 195671222, null), new cljs.core.Symbol(null, "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.Var.cljs$lang$type = true;
cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var";
cljs.core.Var.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/Var");
};
cljs.core.__GT_Var = function cljs$core$__GT_Var(val, sym, _meta) {
  return new cljs.core.Var(val, sym, _meta);
};
cljs.core.var_QMARK_ = function cljs$core$var_QMARK_(v) {
  return v instanceof cljs.core.Var;
};
cljs.core.iterable_QMARK_ = function cljs$core$iterable_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition1$ & 131072 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIterable$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition1$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable, x);
  }
};
cljs.core.clone = function cljs$core$clone(value) {
  return cljs.core._clone(value);
};
cljs.core.cloneable_QMARK_ = function cljs$core$cloneable_QMARK_(value) {
  if (!(value == null)) {
    if (value.cljs$lang$protocol_mask$partition1$ & 8192 || cljs.core.PROTOCOL_SENTINEL === value.cljs$core$ICloneable$) {
      return true;
    } else {
      if (!value.cljs$lang$protocol_mask$partition1$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable, value);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable, value);
  }
};
cljs.core.seq = function cljs$core$seq(coll) {
  if (coll == null) {
    return null;
  } else {
    if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 8388608 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$ ? true : false : false) {
      return coll.cljs$core$ISeqable$_seq$arity$1(null);
    } else {
      if (cljs.core.array_QMARK_(coll)) {
        if (coll.length === 0) {
          return null;
        } else {
          return new cljs.core.IndexedSeq(coll, 0, null);
        }
      } else {
        if (typeof coll === "string") {
          if (coll.length === 0) {
            return null;
          } else {
            return new cljs.core.IndexedSeq(coll, 0, null);
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, coll)) {
            return cljs.core._seq(coll);
          } else {
            throw new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll), " is not ISeqable"].join(""));
          }
        }
      }
    }
  }
};
cljs.core.first = function cljs$core$first(coll) {
  if (coll == null) {
    return null;
  } else {
    if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 64 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$ ? true : false : false) {
      return coll.cljs$core$ISeq$_first$arity$1(null);
    } else {
      var s = cljs.core.seq(coll);
      if (s == null) {
        return null;
      } else {
        return cljs.core._first(s);
      }
    }
  }
};
cljs.core.rest = function cljs$core$rest(coll) {
  if (!(coll == null)) {
    if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 64 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$ ? true : false : false) {
      return coll.cljs$core$ISeq$_rest$arity$1(null);
    } else {
      var s = cljs.core.seq(coll);
      if (s) {
        return cljs.core._rest(s);
      } else {
        return cljs.core.List.EMPTY;
      }
    }
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.next = function cljs$core$next(coll) {
  if (coll == null) {
    return null;
  } else {
    if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 128 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$INext$ ? true : false : false) {
      return coll.cljs$core$INext$_next$arity$1(null);
    } else {
      return cljs.core.seq(cljs.core.rest(coll));
    }
  }
};
cljs.core._EQ_ = function cljs$core$_EQ_(var_args) {
  var G__4545 = arguments.length;
  switch(G__4545) {
    case 1:
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4547 = arguments.length;
      var i__4500__auto___4548 = 0;
      while (true) {
        if (i__4500__auto___4548 < len__4499__auto___4547) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4548]);
          var G__4549 = i__4500__auto___4548 + 1;
          i__4500__auto___4548 = G__4549;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  if (x == null) {
    return y == null;
  } else {
    return x === y || cljs.core._equiv(x, y);
  }
};
cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
      if (cljs.core.next(more)) {
        var G__4550 = y;
        var G__4551 = cljs.core.first(more);
        var G__4552 = cljs.core.next(more);
        x = G__4550;
        y = G__4551;
        more = G__4552;
        continue;
      } else {
        return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y, cljs.core.first(more));
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._EQ_.cljs$lang$applyTo = function(seq4542) {
  var G__4543 = cljs.core.first(seq4542);
  var seq4542__$1 = cljs.core.next(seq4542);
  var G__4544 = cljs.core.first(seq4542__$1);
  var seq4542__$2 = cljs.core.next(seq4542__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4543, G__4544, seq4542__$2);
};
cljs.core._EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.ES6Iterator = function(s) {
  this.s = s;
};
cljs.core.ES6Iterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var x = cljs.core.first(self__.s);
    self__.s = cljs.core.next(self__.s);
    return {"value":x, "done":false};
  } else {
    return {"value":null, "done":true};
  }
};
cljs.core.ES6Iterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ES6Iterator.cljs$lang$type = true;
cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator";
cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/ES6Iterator");
};
cljs.core.__GT_ES6Iterator = function cljs$core$__GT_ES6Iterator(s) {
  return new cljs.core.ES6Iterator(s);
};
cljs.core.es6_iterator = function cljs$core$es6_iterator(coll) {
  return new cljs.core.ES6Iterator(cljs.core.seq(coll));
};
cljs.core.ES6IteratorSeq = function(value, iter, _rest) {
  this.value = value;
  this.iter = iter;
  this._rest = _rest;
  this.cljs$lang$protocol_mask$partition0$ = 8388672;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.value;
};
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__._rest == null) {
    self__._rest = cljs.core.es6_iterator_seq(self__.iter);
  } else {
  }
  return self__._rest;
};
cljs.core.ES6IteratorSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "value", "value", 1946509744, null), new cljs.core.Symbol(null, "iter", "iter", -1346195486, null), cljs.core.with_meta(new cljs.core.Symbol(null, "_rest", "_rest", -2100466189, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ES6IteratorSeq.cljs$lang$type = true;
cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq";
cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/ES6IteratorSeq");
};
cljs.core.__GT_ES6IteratorSeq = function cljs$core$__GT_ES6IteratorSeq(value, iter, _rest) {
  return new cljs.core.ES6IteratorSeq(value, iter, _rest);
};
cljs.core.es6_iterator_seq = function cljs$core$es6_iterator_seq(iter) {
  var v = iter.next();
  if (cljs.core.truth_(v.done)) {
    return cljs.core.List.EMPTY;
  } else {
    return new cljs.core.ES6IteratorSeq(v.value, iter, null);
  }
};
cljs.core.mix_collection_hash = function cljs$core$mix_collection_hash(hash_basis, count) {
  var h1 = cljs.core.m3_seed;
  var k1 = cljs.core.m3_mix_K1(hash_basis);
  var h1__$1 = cljs.core.m3_mix_H1(h1, k1);
  return cljs.core.m3_fmix(h1__$1, count);
};
cljs.core.hash_ordered_coll = function cljs$core$hash_ordered_coll(coll) {
  var n = 0;
  var hash_code = 1;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (!(coll__$1 == null)) {
      var G__4553 = n + 1;
      var G__4554 = cljs.core.imul(31, hash_code) + cljs.core.hash(cljs.core.first(coll__$1)) | 0;
      var G__4555 = cljs.core.next(coll__$1);
      n = G__4553;
      hash_code = G__4554;
      coll__$1 = G__4555;
      continue;
    } else {
      return cljs.core.mix_collection_hash(hash_code, n);
    }
    break;
  }
};
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash(1, 0);
cljs.core.hash_unordered_coll = function cljs$core$hash_unordered_coll(coll) {
  var n = 0;
  var hash_code = 0;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (!(coll__$1 == null)) {
      var G__4556 = n + 1;
      var G__4557 = hash_code + cljs.core.hash(cljs.core.first(coll__$1)) | 0;
      var G__4558 = cljs.core.next(coll__$1);
      n = G__4556;
      hash_code = G__4557;
      coll__$1 = G__4558;
      continue;
    } else {
      return cljs.core.mix_collection_hash(hash_code, n);
    }
    break;
  }
};
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash(0, 0);
goog.object.set(cljs.core.ICounted, "null", true);
var G__4559_4562 = cljs.core._count;
var G__4560_4563 = "null";
var G__4561_4564 = function(G__4559_4562, G__4560_4563) {
  return function(_) {
    return 0;
  };
}(G__4559_4562, G__4560_4563);
goog.object.set(G__4559_4562, G__4560_4563, G__4561_4564);
Date.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL;
Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var o__$1 = this;
  return other instanceof Date && o__$1.valueOf() === other.valueOf();
};
Date.prototype.cljs$core$IComparable$ = cljs.core.PROTOCOL_SENTINEL;
Date.prototype.cljs$core$IComparable$_compare$arity$2 = function(this$, other) {
  var this$__$1 = this;
  if (other instanceof Date) {
    var G__4565 = this$__$1.valueOf();
    var G__4566 = other.valueOf();
    return goog.array.defaultCompare(G__4565, G__4566);
  } else {
    throw new Error(["Cannot compare ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(this$__$1), " to ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(other)].join(""));
  }
};
cljs.core.Inst = function() {
};
cljs.core.inst_ms_STAR_ = function cljs$core$inst_ms_STAR_(inst) {
  if (!(inst == null) && !(inst.cljs$core$Inst$inst_ms_STAR_$arity$1 == null)) {
    return inst.cljs$core$Inst$inst_ms_STAR_$arity$1(inst);
  } else {
    var x__4211__auto__ = inst == null ? null : inst;
    var m__4212__auto__ = cljs.core.inst_ms_STAR_[goog.typeOf(x__4211__auto__)];
    if (!(m__4212__auto__ == null)) {
      return m__4212__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__4212__auto__.call(null, inst);
    } else {
      var m__4212__auto____$1 = cljs.core.inst_ms_STAR_["_"];
      if (!(m__4212__auto____$1 == null)) {
        return m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__4212__auto____$1.cljs$core$IFn$_invoke$arity$1(inst) : m__4212__auto____$1.call(null, inst);
      } else {
        throw cljs.core.missing_protocol("Inst.inst-ms*", inst);
      }
    }
  }
};
Date.prototype.cljs$core$Inst$ = cljs.core.PROTOCOL_SENTINEL;
Date.prototype.cljs$core$Inst$inst_ms_STAR_$arity$1 = function(inst) {
  var inst__$1 = this;
  return inst__$1.getTime();
};
cljs.core.inst_ms = function cljs$core$inst_ms(inst) {
  return cljs.core.inst_ms_STAR_(inst);
};
cljs.core.inst_QMARK_ = function cljs$core$inst_QMARK_(x) {
  if (!(x == null)) {
    if (false || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$Inst$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.Inst, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.Inst, x);
  }
};
goog.object.set(cljs.core.IEquiv, "number", true);
var G__4568_4571 = cljs.core._equiv;
var G__4569_4572 = "number";
var G__4570_4573 = function(G__4568_4571, G__4569_4572) {
  return function(x, o) {
    return x === o;
  };
}(G__4568_4571, G__4569_4572);
goog.object.set(G__4568_4571, G__4569_4572, G__4570_4573);
goog.object.set(cljs.core.Fn, "function", true);
goog.object.set(cljs.core.IMeta, "function", true);
var G__4574_4577 = cljs.core._meta;
var G__4575_4578 = "function";
var G__4576_4579 = function(G__4574_4577, G__4575_4578) {
  return function(_) {
    return null;
  };
}(G__4574_4577, G__4575_4578);
goog.object.set(G__4574_4577, G__4575_4578, G__4576_4579);
goog.object.set(cljs.core.IHash, "_", true);
var G__4580_4583 = cljs.core._hash;
var G__4581_4584 = "_";
var G__4582_4585 = function(G__4580_4583, G__4581_4584) {
  return function(o) {
    return goog.getUid(o);
  };
}(G__4580_4583, G__4581_4584);
goog.object.set(G__4580_4583, G__4581_4584, G__4582_4585);
cljs.core.inc = function cljs$core$inc(x) {
  return x + 1;
};
cljs.core.Reduced = function(val) {
  this.val = val;
  this.cljs$lang$protocol_mask$partition0$ = 32768;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = function(o) {
  var self__ = this;
  var o__$1 = this;
  return self__.val;
};
cljs.core.Reduced.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "val", "val", 1769233139, null)], null);
};
cljs.core.Reduced.cljs$lang$type = true;
cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced";
cljs.core.Reduced.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/Reduced");
};
cljs.core.__GT_Reduced = function cljs$core$__GT_Reduced(val) {
  return new cljs.core.Reduced(val);
};
cljs.core.reduced = function cljs$core$reduced(x) {
  return new cljs.core.Reduced(x);
};
cljs.core.reduced_QMARK_ = function cljs$core$reduced_QMARK_(r) {
  return r instanceof cljs.core.Reduced;
};
cljs.core.ensure_reduced = function cljs$core$ensure_reduced(x) {
  if (cljs.core.reduced_QMARK_(x)) {
    return x;
  } else {
    return cljs.core.reduced(x);
  }
};
cljs.core.unreduced = function cljs$core$unreduced(x) {
  if (cljs.core.reduced_QMARK_(x)) {
    return cljs.core.deref(x);
  } else {
    return x;
  }
};
cljs.core.deref = function cljs$core$deref(o) {
  return cljs.core._deref(o);
};
cljs.core.ci_reduce = function cljs$core$ci_reduce(var_args) {
  var G__4587 = arguments.length;
  switch(G__4587) {
    case 2:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = function(cicoll, f) {
  var cnt = cljs.core._count(cicoll);
  if (cnt === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var val = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, 0);
    var n = 1;
    while (true) {
      if (n < cnt) {
        var nval = function() {
          var G__4588 = val;
          var G__4589 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4588, G__4589) : f.call(null, G__4588, G__4589);
        }();
        if (cljs.core.reduced_QMARK_(nval)) {
          return cljs.core.deref(nval);
        } else {
          var G__4595 = nval;
          var G__4596 = n + 1;
          val = G__4595;
          n = G__4596;
          continue;
        }
      } else {
        return val;
      }
      break;
    }
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = function(cicoll, f, val) {
  var cnt = cljs.core._count(cicoll);
  var val__$1 = val;
  var n = 0;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__4590 = val__$1;
        var G__4591 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4590, G__4591) : f.call(null, G__4590, G__4591);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__4597 = nval;
        var G__4598 = n + 1;
        val__$1 = G__4597;
        n = G__4598;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4 = function(cicoll, f, val, idx) {
  var cnt = cljs.core._count(cicoll);
  var val__$1 = val;
  var n = idx;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__4592 = val__$1;
        var G__4593 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll, n);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4592, G__4593) : f.call(null, G__4592, G__4593);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__4599 = nval;
        var G__4600 = n + 1;
        val__$1 = G__4599;
        n = G__4600;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.ci_reduce.cljs$lang$maxFixedArity = 4;
cljs.core.array_reduce = function cljs$core$array_reduce(var_args) {
  var G__4602 = arguments.length;
  switch(G__4602) {
    case 2:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = function(arr, f) {
  var cnt = arr.length;
  if (arr.length === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var val = arr[0];
    var n = 1;
    while (true) {
      if (n < cnt) {
        var nval = function() {
          var G__4603 = val;
          var G__4604 = arr[n];
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4603, G__4604) : f.call(null, G__4603, G__4604);
        }();
        if (cljs.core.reduced_QMARK_(nval)) {
          return cljs.core.deref(nval);
        } else {
          var G__4610 = nval;
          var G__4611 = n + 1;
          val = G__4610;
          n = G__4611;
          continue;
        }
      } else {
        return val;
      }
      break;
    }
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = function(arr, f, val) {
  var cnt = arr.length;
  var val__$1 = val;
  var n = 0;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__4605 = val__$1;
        var G__4606 = arr[n];
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4605, G__4606) : f.call(null, G__4605, G__4606);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__4612 = nval;
        var G__4613 = n + 1;
        val__$1 = G__4612;
        n = G__4613;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = function(arr, f, val, idx) {
  var cnt = arr.length;
  var val__$1 = val;
  var n = idx;
  while (true) {
    if (n < cnt) {
      var nval = function() {
        var G__4607 = val__$1;
        var G__4608 = arr[n];
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4607, G__4608) : f.call(null, G__4607, G__4608);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__4614 = nval;
        var G__4615 = n + 1;
        val__$1 = G__4614;
        n = G__4615;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.array_reduce.cljs$lang$maxFixedArity = 4;
cljs.core.counted_QMARK_ = function cljs$core$counted_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 2 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICounted$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted, x);
  }
};
cljs.core.indexed_QMARK_ = function cljs$core$indexed_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 16 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIndexed$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, x);
  }
};
cljs.core._indexOf = function cljs$core$_indexOf(var_args) {
  var G__4619 = arguments.length;
  switch(G__4619) {
    case 2:
      return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2 = function(coll, x) {
  return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
};
cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3 = function(coll, x, start) {
  var len = cljs.core.count(coll);
  if (start >= len) {
    return -1;
  } else {
    var idx = start > 0 ? start : start < 0 ? function() {
      var x__4006__auto__ = 0;
      var y__4007__auto__ = start + len;
      return x__4006__auto__ > y__4007__auto__ ? x__4006__auto__ : y__4007__auto__;
    }() : start;
    while (true) {
      if (idx < len) {
        if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll, idx), x)) {
          return idx;
        } else {
          var G__4621 = idx + 1;
          idx = G__4621;
          continue;
        }
      } else {
        return -1;
      }
      break;
    }
  }
};
cljs.core._indexOf.cljs$lang$maxFixedArity = 3;
cljs.core._lastIndexOf = function cljs$core$_lastIndexOf(var_args) {
  var G__4623 = arguments.length;
  switch(G__4623) {
    case 2:
      return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2 = function(coll, x) {
  return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
};
cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3 = function(coll, x, start) {
  var len = cljs.core.count(coll);
  if (len === 0) {
    return -1;
  } else {
    var idx = start > 0 ? function() {
      var x__4009__auto__ = len - 1;
      var y__4010__auto__ = start;
      return x__4009__auto__ < y__4010__auto__ ? x__4009__auto__ : y__4010__auto__;
    }() : start < 0 ? len + start : start;
    while (true) {
      if (idx >= 0) {
        if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll, idx), x)) {
          return idx;
        } else {
          var G__4625 = idx - 1;
          idx = G__4625;
          continue;
        }
      } else {
        return -1;
      }
      break;
    }
  }
};
cljs.core._lastIndexOf.cljs$lang$maxFixedArity = 3;
cljs.core.IndexedSeqIterator = function(arr, i) {
  this.arr = arr;
  this.i = i;
};
cljs.core.IndexedSeqIterator.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.arr.length;
};
cljs.core.IndexedSeqIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.arr[self__.i];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.IndexedSeqIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.IndexedSeqIterator.cljs$lang$type = true;
cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator";
cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/IndexedSeqIterator");
};
cljs.core.__GT_IndexedSeqIterator = function cljs$core$__GT_IndexedSeqIterator(arr, i) {
  return new cljs.core.IndexedSeqIterator(arr, i);
};
cljs.core.IndexedSeq = function(arr, i, meta) {
  this.arr = arr;
  this.i = i;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 166592766;
  this.cljs$lang$protocol_mask$partition1$ = 139264;
};
cljs.core.IndexedSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.IndexedSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.IndexedSeq.prototype.indexOf = function() {
  var G__4626 = null;
  var G__4626__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__4626__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__4626 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__4626__1.call(this, x);
      case 2:
        return G__4626__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__4626.cljs$core$IFn$_invoke$arity$1 = G__4626__1;
  G__4626.cljs$core$IFn$_invoke$arity$2 = G__4626__2;
  return G__4626;
}();
cljs.core.IndexedSeq.prototype.lastIndexOf = function() {
  var G__4627 = null;
  var G__4627__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__4627__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__4627 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__4627__1.call(this, x);
      case 2:
        return G__4627__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__4627.cljs$core$IFn$_invoke$arity$1 = G__4627__1;
  G__4627.cljs$core$IFn$_invoke$arity$2 = G__4627__2;
  return G__4627;
}();
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  var i__$1 = n + self__.i;
  if (0 <= i__$1 && i__$1 < self__.arr.length) {
    return self__.arr[i__$1];
  } else {
    throw new Error("Index out of bounds");
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var i__$1 = n + self__.i;
  if (0 <= i__$1 && i__$1 < self__.arr.length) {
    return self__.arr[i__$1];
  } else {
    return not_found;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.IndexedSeqIterator(self__.arr, self__.i);
};
cljs.core.IndexedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.IndexedSeq(self__.arr, self__.i, self__.meta);
};
cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__.i + 1 < self__.arr.length) {
    return new cljs.core.IndexedSeq(self__.arr, self__.i + 1, null);
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  var x__4006__auto__ = 0;
  var y__4007__auto__ = self__.arr.length - self__.i;
  return x__4006__auto__ > y__4007__auto__ ? x__4006__auto__ : y__4007__auto__;
};
cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var c = coll__$1.cljs$core$ICounted$_count$arity$1(null);
  if (c > 0) {
    return new cljs.core.RSeq(coll__$1, c - 1, null);
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, self__.arr[self__.i], self__.i + 1);
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, start, self__.i);
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.arr[self__.i];
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  if (self__.i + 1 < self__.arr.length) {
    return new cljs.core.IndexedSeq(self__.arr, self__.i + 1, null);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  if (self__.i < self__.arr.length) {
    return this$__$1;
  } else {
    return null;
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.IndexedSeq(self__.arr, self__.i, new_meta);
};
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.IndexedSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.IndexedSeq.cljs$lang$type = true;
cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq";
cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/IndexedSeq");
};
cljs.core.__GT_IndexedSeq = function cljs$core$__GT_IndexedSeq(arr, i, meta) {
  return new cljs.core.IndexedSeq(arr, i, meta);
};
var G__4628_4631 = cljs.core.IndexedSeq.prototype;
var G__4629_4632 = cljs.core.ITER_SYMBOL;
var G__4630_4633 = function(G__4628_4631, G__4629_4632) {
  return function() {
    var this__4438__auto__ = this;
    return cljs.core.es6_iterator(this__4438__auto__);
  };
}(G__4628_4631, G__4629_4632);
goog.object.set(G__4628_4631, G__4629_4632, G__4630_4633);
cljs.core.prim_seq = function cljs$core$prim_seq(var_args) {
  var G__4635 = arguments.length;
  switch(G__4635) {
    case 1:
      return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = function(prim) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim, 0);
};
cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = function(prim, i) {
  if (i < prim.length) {
    return new cljs.core.IndexedSeq(prim, i, null);
  } else {
    return null;
  }
};
cljs.core.prim_seq.cljs$lang$maxFixedArity = 2;
cljs.core.array_seq = function cljs$core$array_seq(var_args) {
  var G__4638 = arguments.length;
  switch(G__4638) {
    case 1:
      return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = function(array) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array, 0);
};
cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = function(array, i) {
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array, i);
};
cljs.core.array_seq.cljs$lang$maxFixedArity = 2;
cljs.core.RSeq = function(ci, i, meta) {
  this.ci = ci;
  this.i = i;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 32374990;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.RSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.RSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.RSeq.prototype.indexOf = function() {
  var G__4640 = null;
  var G__4640__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__4640__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__4640 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__4640__1.call(this, x);
      case 2:
        return G__4640__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__4640.cljs$core$IFn$_invoke$arity$1 = G__4640__1;
  G__4640.cljs$core$IFn$_invoke$arity$2 = G__4640__2;
  return G__4640;
}();
cljs.core.RSeq.prototype.lastIndexOf = function() {
  var G__4641 = null;
  var G__4641__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__4641__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__4641 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__4641__1.call(this, x);
      case 2:
        return G__4641__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__4641.cljs$core$IFn$_invoke$arity$1 = G__4641__1;
  G__4641.cljs$core$IFn$_invoke$arity$2 = G__4641__2;
  return G__4641;
}();
cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.RSeq(self__.ci, self__.i, self__.meta);
};
cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i > 0) {
    return new cljs.core.RSeq(self__.ci, self__.i - 1, null);
  } else {
    return null;
  }
};
cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.i + 1;
};
cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(col, f) {
  var self__ = this;
  var col__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, col__$1);
};
cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(col, f, start) {
  var self__ = this;
  var col__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, col__$1);
};
cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci, self__.i);
};
cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i > 0) {
    return new cljs.core.RSeq(self__.ci, self__.i - 1, null);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.RSeq(self__.ci, self__.i, new_meta);
};
cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.RSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "ci", "ci", 2049808339, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.RSeq.cljs$lang$type = true;
cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq";
cljs.core.RSeq.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/RSeq");
};
cljs.core.__GT_RSeq = function cljs$core$__GT_RSeq(ci, i, meta) {
  return new cljs.core.RSeq(ci, i, meta);
};
var G__4642_4645 = cljs.core.RSeq.prototype;
var G__4643_4646 = cljs.core.ITER_SYMBOL;
var G__4644_4647 = function(G__4642_4645, G__4643_4646) {
  return function() {
    var this__4438__auto__ = this;
    return cljs.core.es6_iterator(this__4438__auto__);
  };
}(G__4642_4645, G__4643_4646);
goog.object.set(G__4642_4645, G__4643_4646, G__4644_4647);
cljs.core.second = function cljs$core$second(coll) {
  return cljs.core.first(cljs.core.next(coll));
};
cljs.core.ffirst = function cljs$core$ffirst(coll) {
  return cljs.core.first(cljs.core.first(coll));
};
cljs.core.nfirst = function cljs$core$nfirst(coll) {
  return cljs.core.next(cljs.core.first(coll));
};
cljs.core.fnext = function cljs$core$fnext(coll) {
  return cljs.core.first(cljs.core.next(coll));
};
cljs.core.nnext = function cljs$core$nnext(coll) {
  return cljs.core.next(cljs.core.next(coll));
};
cljs.core.last = function cljs$core$last(s) {
  while (true) {
    var sn = cljs.core.next(s);
    if (!(sn == null)) {
      var G__4648 = sn;
      s = G__4648;
      continue;
    } else {
      return cljs.core.first(s);
    }
    break;
  }
};
goog.object.set(cljs.core.IEquiv, "_", true);
var G__4649_4652 = cljs.core._equiv;
var G__4650_4653 = "_";
var G__4651_4654 = function(G__4649_4652, G__4650_4653) {
  return function(x, o) {
    return x === o;
  };
}(G__4649_4652, G__4650_4653);
goog.object.set(G__4649_4652, G__4650_4653, G__4651_4654);
cljs.core.conj = function cljs$core$conj(var_args) {
  var G__4659 = arguments.length;
  switch(G__4659) {
    case 0:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4661 = arguments.length;
      var i__4500__auto___4662 = 0;
      while (true) {
        if (i__4500__auto___4662 < len__4499__auto___4661) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4662]);
          var G__4663 = i__4500__auto___4662 + 1;
          i__4500__auto___4662 = G__4663;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = function(coll, x) {
  if (!(coll == null)) {
    return cljs.core._conj(coll, x);
  } else {
    return new cljs.core.List(null, x, null, 1, null);
  }
};
cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = function(coll, x, xs) {
  while (true) {
    if (cljs.core.truth_(xs)) {
      var G__4664 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll, x);
      var G__4665 = cljs.core.first(xs);
      var G__4666 = cljs.core.next(xs);
      coll = G__4664;
      x = G__4665;
      xs = G__4666;
      continue;
    } else {
      return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll, x);
    }
    break;
  }
};
cljs.core.conj.cljs$lang$applyTo = function(seq4656) {
  var G__4657 = cljs.core.first(seq4656);
  var seq4656__$1 = cljs.core.next(seq4656);
  var G__4658 = cljs.core.first(seq4656__$1);
  var seq4656__$2 = cljs.core.next(seq4656__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4657, G__4658, seq4656__$2);
};
cljs.core.conj.cljs$lang$maxFixedArity = 2;
cljs.core.empty = function cljs$core$empty(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._empty(coll);
  }
};
cljs.core.accumulating_seq_count = function cljs$core$accumulating_seq_count(coll) {
  var s = cljs.core.seq(coll);
  var acc = 0;
  while (true) {
    if (cljs.core.counted_QMARK_(s)) {
      return acc + cljs.core._count(s);
    } else {
      var G__4667 = cljs.core.next(s);
      var G__4668 = acc + 1;
      s = G__4667;
      acc = G__4668;
      continue;
    }
    break;
  }
};
cljs.core.count = function cljs$core$count(coll) {
  if (!(coll == null)) {
    if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 2 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ICounted$ ? true : false : false) {
      return coll.cljs$core$ICounted$_count$arity$1(null);
    } else {
      if (cljs.core.array_QMARK_(coll)) {
        return coll.length;
      } else {
        if (typeof coll === "string") {
          return coll.length;
        } else {
          if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 8388608 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$ ? true : false : false) {
            return cljs.core.accumulating_seq_count(coll);
          } else {
            return cljs.core._count(coll);
          }
        }
      }
    }
  } else {
    return 0;
  }
};
cljs.core.linear_traversal_nth = function cljs$core$linear_traversal_nth(var_args) {
  var G__4672 = arguments.length;
  switch(G__4672) {
    case 2:
      return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  while (true) {
    if (coll == null) {
      throw new Error("Index out of bounds");
    } else {
      if (n === 0) {
        if (cljs.core.seq(coll)) {
          return cljs.core.first(coll);
        } else {
          throw new Error("Index out of bounds");
        }
      } else {
        if (cljs.core.indexed_QMARK_(coll)) {
          return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll, n);
        } else {
          if (cljs.core.seq(coll)) {
            var G__4674 = cljs.core.next(coll);
            var G__4675 = n - 1;
            coll = G__4674;
            n = G__4675;
            continue;
          } else {
            throw new Error("Index out of bounds");
          }
        }
      }
    }
    break;
  }
};
cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  while (true) {
    if (coll == null) {
      return not_found;
    } else {
      if (n === 0) {
        if (cljs.core.seq(coll)) {
          return cljs.core.first(coll);
        } else {
          return not_found;
        }
      } else {
        if (cljs.core.indexed_QMARK_(coll)) {
          return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll, n, not_found);
        } else {
          if (cljs.core.seq(coll)) {
            var G__4676 = cljs.core.next(coll);
            var G__4677 = n - 1;
            var G__4678 = not_found;
            coll = G__4676;
            n = G__4677;
            not_found = G__4678;
            continue;
          } else {
            return not_found;
          }
        }
      }
    }
    break;
  }
};
cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3;
cljs.core.nth = function cljs$core$nth(var_args) {
  var G__4680 = arguments.length;
  switch(G__4680) {
    case 2:
      return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.nth.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = function(coll, n) {
  if (!(typeof n === "number")) {
    throw new Error("Index argument to nth must be a number");
  } else {
    if (coll == null) {
      return coll;
    } else {
      if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 16 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$ ? true : false : false) {
        return coll.cljs$core$IIndexed$_nth$arity$2(null, n);
      } else {
        if (cljs.core.array_QMARK_(coll)) {
          if (n >= 0 && n < coll.length) {
            return coll[n];
          } else {
            throw new Error("Index out of bounds");
          }
        } else {
          if (typeof coll === "string") {
            if (n >= 0 && n < coll.length) {
              return coll.charAt(n);
            } else {
              throw new Error("Index out of bounds");
            }
          } else {
            if (function() {
              var or__3922__auto__ = !(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 64 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$ ? true : false : false;
              if (or__3922__auto__) {
                return or__3922__auto__;
              } else {
                if (!(coll == null)) {
                  if (coll.cljs$lang$protocol_mask$partition0$ & 16777216 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISequential$) {
                    return true;
                  } else {
                    return false;
                  }
                } else {
                  return false;
                }
              }
            }()) {
              return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll, n);
            } else {
              if (cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, coll)) {
                return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll, n);
              } else {
                throw new Error(["nth not supported on this type ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join(""));
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = function(coll, n, not_found) {
  if (!(typeof n === "number")) {
    throw new Error("Index argument to nth must be a number.");
  } else {
    if (coll == null) {
      return not_found;
    } else {
      if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 16 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$ ? true : false : false) {
        return coll.cljs$core$IIndexed$_nth$arity$3(null, n, not_found);
      } else {
        if (cljs.core.array_QMARK_(coll)) {
          if (n >= 0 && n < coll.length) {
            return coll[n];
          } else {
            return not_found;
          }
        } else {
          if (typeof coll === "string") {
            if (n >= 0 && n < coll.length) {
              return coll.charAt(n);
            } else {
              return not_found;
            }
          } else {
            if (function() {
              var or__3922__auto__ = !(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 64 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$ ? true : false : false;
              if (or__3922__auto__) {
                return or__3922__auto__;
              } else {
                if (!(coll == null)) {
                  if (coll.cljs$lang$protocol_mask$partition0$ & 16777216 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISequential$) {
                    return true;
                  } else {
                    return false;
                  }
                } else {
                  return false;
                }
              }
            }()) {
              return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll, n, not_found);
            } else {
              if (cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed, coll)) {
                return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll, n, not_found);
              } else {
                throw new Error(["nth not supported on this type ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join(""));
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.nth.cljs$lang$maxFixedArity = 3;
cljs.core.nthrest = function cljs$core$nthrest(coll, n) {
  var n__$1 = n;
  var xs = coll;
  while (true) {
    var temp__5455__auto__ = n__$1 > 0 && cljs.core.seq(xs);
    if (temp__5455__auto__) {
      var xs__$1 = temp__5455__auto__;
      var G__4690 = n__$1 - 1;
      var G__4691 = cljs.core.rest(xs__$1);
      n__$1 = G__4690;
      xs = G__4691;
      continue;
    } else {
      return xs;
    }
    break;
  }
};
cljs.core.get = function cljs$core$get(var_args) {
  var G__4693 = arguments.length;
  switch(G__4693) {
    case 2:
      return cljs.core.get.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.get.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.get.cljs$core$IFn$_invoke$arity$2 = function(o, k) {
  if (o == null) {
    return null;
  } else {
    if (!(o == null) ? o.cljs$lang$protocol_mask$partition0$ & 256 || cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$ ? true : false : false) {
      return o.cljs$core$ILookup$_lookup$arity$2(null, k);
    } else {
      if (cljs.core.array_QMARK_(o)) {
        if (!(k == null) && k < o.length) {
          return o[k | 0];
        } else {
          return null;
        }
      } else {
        if (typeof o === "string") {
          if (!(k == null) && k < o.length) {
            return o.charAt(k | 0);
          } else {
            return null;
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, o)) {
            return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o, k);
          } else {
            return null;
          }
        }
      }
    }
  }
};
cljs.core.get.cljs$core$IFn$_invoke$arity$3 = function(o, k, not_found) {
  if (!(o == null)) {
    if (!(o == null) ? o.cljs$lang$protocol_mask$partition0$ & 256 || cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$ ? true : false : false) {
      return o.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
    } else {
      if (cljs.core.array_QMARK_(o)) {
        if (!(k == null) && k >= 0 && k < o.length) {
          return o[k | 0];
        } else {
          return not_found;
        }
      } else {
        if (typeof o === "string") {
          if (!(k == null) && k >= 0 && k < o.length) {
            return o.charAt(k | 0);
          } else {
            return not_found;
          }
        } else {
          if (cljs.core.native_satisfies_QMARK_(cljs.core.ILookup, o)) {
            return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o, k, not_found);
          } else {
            return not_found;
          }
        }
      }
    }
  } else {
    return not_found;
  }
};
cljs.core.get.cljs$lang$maxFixedArity = 3;
cljs.core.assoc = function cljs$core$assoc(var_args) {
  var G__4702 = arguments.length;
  switch(G__4702) {
    case 3:
      return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4704 = arguments.length;
      var i__4500__auto___4705 = 0;
      while (true) {
        if (i__4500__auto___4705 < len__4499__auto___4704) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4705]);
          var G__4706 = i__4500__auto___4705 + 1;
          i__4500__auto___4705 = G__4706;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(3), 0, null);
      return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__4515__auto__);
  }
};
cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = function(coll, k, v) {
  if (!(coll == null)) {
    return cljs.core._assoc(coll, k, v);
  } else {
    return cljs.core.PersistentArrayMap.createAsIfByAssoc([k, v]);
  }
};
cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, v, kvs) {
  while (true) {
    var ret = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll, k, v);
    if (cljs.core.truth_(kvs)) {
      var G__4707 = ret;
      var G__4708 = cljs.core.first(kvs);
      var G__4709 = cljs.core.second(kvs);
      var G__4710 = cljs.core.nnext(kvs);
      coll = G__4707;
      k = G__4708;
      v = G__4709;
      kvs = G__4710;
      continue;
    } else {
      return ret;
    }
    break;
  }
};
cljs.core.assoc.cljs$lang$applyTo = function(seq4698) {
  var G__4699 = cljs.core.first(seq4698);
  var seq4698__$1 = cljs.core.next(seq4698);
  var G__4700 = cljs.core.first(seq4698__$1);
  var seq4698__$2 = cljs.core.next(seq4698__$1);
  var G__4701 = cljs.core.first(seq4698__$2);
  var seq4698__$3 = cljs.core.next(seq4698__$2);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4699, G__4700, G__4701, seq4698__$3);
};
cljs.core.assoc.cljs$lang$maxFixedArity = 3;
cljs.core.dissoc = function cljs$core$dissoc(var_args) {
  var G__4715 = arguments.length;
  switch(G__4715) {
    case 1:
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4717 = arguments.length;
      var i__4500__auto___4718 = 0;
      while (true) {
        if (i__4500__auto___4718 < len__4499__auto___4717) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4718]);
          var G__4719 = i__4500__auto___4718 + 1;
          i__4500__auto___4718 = G__4719;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = function(coll, k) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._dissoc(coll, k);
  }
};
cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, ks) {
  while (true) {
    if (coll == null) {
      return null;
    } else {
      var ret = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll, k);
      if (cljs.core.truth_(ks)) {
        var G__4720 = ret;
        var G__4721 = cljs.core.first(ks);
        var G__4722 = cljs.core.next(ks);
        coll = G__4720;
        k = G__4721;
        ks = G__4722;
        continue;
      } else {
        return ret;
      }
    }
    break;
  }
};
cljs.core.dissoc.cljs$lang$applyTo = function(seq4712) {
  var G__4713 = cljs.core.first(seq4712);
  var seq4712__$1 = cljs.core.next(seq4712);
  var G__4714 = cljs.core.first(seq4712__$1);
  var seq4712__$2 = cljs.core.next(seq4712__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4713, G__4714, seq4712__$2);
};
cljs.core.dissoc.cljs$lang$maxFixedArity = 2;
cljs.core.fn_QMARK_ = function cljs$core$fn_QMARK_(f) {
  var or__3922__auto__ = goog.isFunction(f);
  if (or__3922__auto__) {
    return or__3922__auto__;
  } else {
    if (!(f == null)) {
      if (false || cljs.core.PROTOCOL_SENTINEL === f.cljs$core$Fn$) {
        return true;
      } else {
        if (!f.cljs$lang$protocol_mask$partition$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.Fn, f);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.Fn, f);
    }
  }
};
cljs.core.MetaFn = function(afn, meta) {
  this.afn = afn;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 393217;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.meta;
};
cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_, new_meta) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.MetaFn(self__.afn, new_meta);
};
cljs.core.MetaFn.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.MetaFn.prototype.call = function() {
  var G__4726 = null;
  var G__4726__1 = function(self__) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null);
  };
  var G__4726__2 = function(self__, a) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null, a);
  };
  var G__4726__3 = function(self__, a, b) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a, b) : self__.afn.call(null, a, b);
  };
  var G__4726__4 = function(self__, a, b, c) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a, b, c) : self__.afn.call(null, a, b, c);
  };
  var G__4726__5 = function(self__, a, b, c, d) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a, b, c, d) : self__.afn.call(null, a, b, c, d);
  };
  var G__4726__6 = function(self__, a, b, c, d, e) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a, b, c, d, e) : self__.afn.call(null, a, b, c, d, e);
  };
  var G__4726__7 = function(self__, a, b, c, d, e, f) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a, b, c, d, e, f) : self__.afn.call(null, a, b, c, d, e, f);
  };
  var G__4726__8 = function(self__, a, b, c, d, e, f, g) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a, b, c, d, e, f, g) : self__.afn.call(null, a, b, c, d, e, f, g);
  };
  var G__4726__9 = function(self__, a, b, c, d, e, f, g, h) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a, b, c, d, e, f, g, h) : self__.afn.call(null, a, b, c, d, e, f, g, h);
  };
  var G__4726__10 = function(self__, a, b, c, d, e, f, g, h, i) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a, b, c, d, e, f, g, h, i) : self__.afn.call(null, a, b, c, d, e, f, g, h, i);
  };
  var G__4726__11 = function(self__, a, b, c, d, e, f, g, h, i, j) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a, b, c, d, e, f, g, h, i, j) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j);
  };
  var G__4726__12 = function(self__, a, b, c, d, e, f, g, h, i, j, k) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a, b, c, d, e, f, g, h, i, j, k) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k);
  };
  var G__4726__13 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a, b, c, d, e, f, g, h, i, j, k, l) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l);
  };
  var G__4726__14 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a, b, c, d, e, f, g, h, i, j, k, l, m) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
  };
  var G__4726__15 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a, b, c, d, e, f, g, h, i, j, k, l, m, n) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
  };
  var G__4726__16 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
  };
  var G__4726__17 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
  };
  var G__4726__18 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
  };
  var G__4726__19 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
  };
  var G__4726__20 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
  };
  var G__4726__21 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
  };
  var G__4726__22 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    var self__ = this;
    var self____$1 = this;
    var _ = self____$1;
    return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(self__.afn, a, b, c, d, cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest], 0));
  };
  G__4726 = function(self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return G__4726__1.call(this, self__);
      case 2:
        return G__4726__2.call(this, self__, a);
      case 3:
        return G__4726__3.call(this, self__, a, b);
      case 4:
        return G__4726__4.call(this, self__, a, b, c);
      case 5:
        return G__4726__5.call(this, self__, a, b, c, d);
      case 6:
        return G__4726__6.call(this, self__, a, b, c, d, e);
      case 7:
        return G__4726__7.call(this, self__, a, b, c, d, e, f);
      case 8:
        return G__4726__8.call(this, self__, a, b, c, d, e, f, g);
      case 9:
        return G__4726__9.call(this, self__, a, b, c, d, e, f, g, h);
      case 10:
        return G__4726__10.call(this, self__, a, b, c, d, e, f, g, h, i);
      case 11:
        return G__4726__11.call(this, self__, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return G__4726__12.call(this, self__, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return G__4726__13.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return G__4726__14.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return G__4726__15.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return G__4726__16.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return G__4726__17.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return G__4726__18.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return G__4726__19.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
      case 20:
        return G__4726__20.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
      case 21:
        return G__4726__21.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
      case 22:
        return G__4726__22.call(this, self__, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__4726.cljs$core$IFn$_invoke$arity$1 = G__4726__1;
  G__4726.cljs$core$IFn$_invoke$arity$2 = G__4726__2;
  G__4726.cljs$core$IFn$_invoke$arity$3 = G__4726__3;
  G__4726.cljs$core$IFn$_invoke$arity$4 = G__4726__4;
  G__4726.cljs$core$IFn$_invoke$arity$5 = G__4726__5;
  G__4726.cljs$core$IFn$_invoke$arity$6 = G__4726__6;
  G__4726.cljs$core$IFn$_invoke$arity$7 = G__4726__7;
  G__4726.cljs$core$IFn$_invoke$arity$8 = G__4726__8;
  G__4726.cljs$core$IFn$_invoke$arity$9 = G__4726__9;
  G__4726.cljs$core$IFn$_invoke$arity$10 = G__4726__10;
  G__4726.cljs$core$IFn$_invoke$arity$11 = G__4726__11;
  G__4726.cljs$core$IFn$_invoke$arity$12 = G__4726__12;
  G__4726.cljs$core$IFn$_invoke$arity$13 = G__4726__13;
  G__4726.cljs$core$IFn$_invoke$arity$14 = G__4726__14;
  G__4726.cljs$core$IFn$_invoke$arity$15 = G__4726__15;
  G__4726.cljs$core$IFn$_invoke$arity$16 = G__4726__16;
  G__4726.cljs$core$IFn$_invoke$arity$17 = G__4726__17;
  G__4726.cljs$core$IFn$_invoke$arity$18 = G__4726__18;
  G__4726.cljs$core$IFn$_invoke$arity$19 = G__4726__19;
  G__4726.cljs$core$IFn$_invoke$arity$20 = G__4726__20;
  G__4726.cljs$core$IFn$_invoke$arity$21 = G__4726__21;
  G__4726.cljs$core$IFn$_invoke$arity$22 = G__4726__22;
  return G__4726;
}();
cljs.core.MetaFn.prototype.apply = function(self__, args4725) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args4725)));
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = function() {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = function(a) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null, a);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = function(a, b) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a, b) : self__.afn.call(null, a, b);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = function(a, b, c) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a, b, c) : self__.afn.call(null, a, b, c);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, d) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a, b, c, d) : self__.afn.call(null, a, b, c, d);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = function(a, b, c, d, e) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a, b, c, d, e) : self__.afn.call(null, a, b, c, d, e);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = function(a, b, c, d, e, f) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a, b, c, d, e, f) : self__.afn.call(null, a, b, c, d, e, f);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = function(a, b, c, d, e, f, g) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a, b, c, d, e, f, g) : self__.afn.call(null, a, b, c, d, e, f, g);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = function(a, b, c, d, e, f, g, h) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a, b, c, d, e, f, g, h) : self__.afn.call(null, a, b, c, d, e, f, g, h);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = function(a, b, c, d, e, f, g, h, i) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a, b, c, d, e, f, g, h, i) : self__.afn.call(null, a, b, c, d, e, f, g, h, i);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = function(a, b, c, d, e, f, g, h, i, j) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a, b, c, d, e, f, g, h, i, j) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = function(a, b, c, d, e, f, g, h, i, j, k) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a, b, c, d, e, f, g, h, i, j, k) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = function(a, b, c, d, e, f, g, h, i, j, k, l) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a, b, c, d, e, f, g, h, i, j, k, l) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = function(a, b, c, d, e, f, g, h, i, j, k, l, m) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a, b, c, d, e, f, g, h, i, j, k, l, m) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a, b, c, d, e, f, g, h, i, j, k, l, m, n) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) {
  var self__ = this;
  var _ = this;
  return self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t) : self__.afn.call(null, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t);
};
cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = function(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest) {
  var self__ = this;
  var _ = this;
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(self__.afn, a, b, c, d, cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, rest], 0));
};
cljs.core.MetaFn.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "afn", "afn", 216963467, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.MetaFn.cljs$lang$type = true;
cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn";
cljs.core.MetaFn.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/MetaFn");
};
cljs.core.__GT_MetaFn = function cljs$core$__GT_MetaFn(afn, meta) {
  return new cljs.core.MetaFn(afn, meta);
};
cljs.core.with_meta = function cljs$core$with_meta(o, meta) {
  if (goog.isFunction(o)) {
    return new cljs.core.MetaFn(o, meta);
  } else {
    if (o == null) {
      return null;
    } else {
      return cljs.core._with_meta(o, meta);
    }
  }
};
cljs.core.meta = function cljs$core$meta(o) {
  if (function() {
    var and__3911__auto__ = !(o == null);
    if (and__3911__auto__) {
      if (!(o == null)) {
        if (o.cljs$lang$protocol_mask$partition0$ & 131072 || cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IMeta$) {
          return true;
        } else {
          if (!o.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta, o);
          } else {
            return false;
          }
        }
      } else {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta, o);
      }
    } else {
      return and__3911__auto__;
    }
  }()) {
    return cljs.core._meta(o);
  } else {
    return null;
  }
};
cljs.core.peek = function cljs$core$peek(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._peek(coll);
  }
};
cljs.core.pop = function cljs$core$pop(coll) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._pop(coll);
  }
};
cljs.core.disj = function cljs$core$disj(var_args) {
  var G__4733 = arguments.length;
  switch(G__4733) {
    case 1:
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4735 = arguments.length;
      var i__4500__auto___4736 = 0;
      while (true) {
        if (i__4500__auto___4736 < len__4499__auto___4735) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4736]);
          var G__4737 = i__4500__auto___4736 + 1;
          i__4500__auto___4736 = G__4737;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return coll;
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = function(coll, k) {
  if (coll == null) {
    return null;
  } else {
    return cljs.core._disjoin(coll, k);
  }
};
cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = function(coll, k, ks) {
  while (true) {
    if (coll == null) {
      return null;
    } else {
      var ret = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll, k);
      if (cljs.core.truth_(ks)) {
        var G__4738 = ret;
        var G__4739 = cljs.core.first(ks);
        var G__4740 = cljs.core.next(ks);
        coll = G__4738;
        k = G__4739;
        ks = G__4740;
        continue;
      } else {
        return ret;
      }
    }
    break;
  }
};
cljs.core.disj.cljs$lang$applyTo = function(seq4730) {
  var G__4731 = cljs.core.first(seq4730);
  var seq4730__$1 = cljs.core.next(seq4730);
  var G__4732 = cljs.core.first(seq4730__$1);
  var seq4730__$2 = cljs.core.next(seq4730__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4731, G__4732, seq4730__$2);
};
cljs.core.disj.cljs$lang$maxFixedArity = 2;
cljs.core.empty_QMARK_ = function cljs$core$empty_QMARK_(coll) {
  return coll == null || cljs.core.not(cljs.core.seq(coll));
};
cljs.core.coll_QMARK_ = function cljs$core$coll_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    if (!(x == null)) {
      if (x.cljs$lang$protocol_mask$partition0$ & 8 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICollection$) {
        return true;
      } else {
        if (!x.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection, x);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection, x);
    }
  }
};
cljs.core.set_QMARK_ = function cljs$core$set_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    if (!(x == null)) {
      if (x.cljs$lang$protocol_mask$partition0$ & 4096 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$) {
        return true;
      } else {
        if (!x.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ISet, x);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ISet, x);
    }
  }
};
cljs.core.associative_QMARK_ = function cljs$core$associative_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 512 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IAssociative$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative, x);
  }
};
cljs.core.ifind_QMARK_ = function cljs$core$ifind_QMARK_(x) {
  if (!(x == null)) {
    if (false || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IFind$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IFind, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IFind, x);
  }
};
cljs.core.sequential_QMARK_ = function cljs$core$sequential_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 16777216 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential, x);
  }
};
cljs.core.sorted_QMARK_ = function cljs$core$sorted_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 268435456 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISorted$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted, x);
  }
};
cljs.core.reduceable_QMARK_ = function cljs$core$reduceable_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 524288 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IReduce$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, x);
  }
};
cljs.core.map_QMARK_ = function cljs$core$map_QMARK_(x) {
  if (x == null) {
    return false;
  } else {
    if (!(x == null)) {
      if (x.cljs$lang$protocol_mask$partition0$ & 1024 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$) {
        return true;
      } else {
        if (!x.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.IMap, x);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.IMap, x);
    }
  }
};
cljs.core.record_QMARK_ = function cljs$core$record_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 67108864 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IRecord$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord, x);
  }
};
cljs.core.vector_QMARK_ = function cljs$core$vector_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 16384 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IVector$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IVector, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IVector, x);
  }
};
cljs.core.chunked_seq_QMARK_ = function cljs$core$chunked_seq_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition1$ & 512 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IChunkedSeq$) {
      return true;
    } else {
      return false;
    }
  } else {
    return false;
  }
};
cljs.core.js_obj = function cljs$core$js_obj(var_args) {
  var G__4754 = arguments.length;
  switch(G__4754) {
    case 0:
      return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4758 = arguments.length;
      var i__4500__auto___4759 = 0;
      while (true) {
        if (i__4500__auto___4759 < len__4499__auto___4758) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4759]);
          var G__4760 = i__4500__auto___4759 + 1;
          i__4500__auto___4759 = G__4760;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(0), 0, null);
      return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__4515__auto__);
  }
};
cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = function() {
  return {};
};
cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = function(keyvals) {
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(goog.object.create, keyvals);
};
cljs.core.js_obj.cljs$lang$applyTo = function(seq4753) {
  var self__4487__auto__ = this;
  return self__4487__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq4753));
};
cljs.core.js_obj.cljs$lang$maxFixedArity = 0;
cljs.core.js_keys = function cljs$core$js_keys(obj) {
  return goog.object.getKeys(obj);
};
cljs.core.js_delete = function cljs$core$js_delete(obj, key) {
  return delete obj[key];
};
cljs.core.array_copy = function cljs$core$array_copy(from, i, to, j, len) {
  var i__$1 = i;
  var j__$1 = j;
  var len__$1 = len;
  while (true) {
    if (len__$1 === 0) {
      return to;
    } else {
      to[j__$1] = from[i__$1];
      var G__4761 = i__$1 + 1;
      var G__4762 = j__$1 + 1;
      var G__4763 = len__$1 - 1;
      i__$1 = G__4761;
      j__$1 = G__4762;
      len__$1 = G__4763;
      continue;
    }
    break;
  }
};
cljs.core.array_copy_downward = function cljs$core$array_copy_downward(from, i, to, j, len) {
  var i__$1 = i + (len - 1);
  var j__$1 = j + (len - 1);
  var len__$1 = len;
  while (true) {
    if (len__$1 === 0) {
      return to;
    } else {
      to[j__$1] = from[i__$1];
      var G__4764 = i__$1 - 1;
      var G__4765 = j__$1 - 1;
      var G__4766 = len__$1 - 1;
      i__$1 = G__4764;
      j__$1 = G__4765;
      len__$1 = G__4766;
      continue;
    }
    break;
  }
};
cljs.core.lookup_sentinel = {};
cljs.core.false_QMARK_ = function cljs$core$false_QMARK_(x) {
  return x === false;
};
cljs.core.true_QMARK_ = function cljs$core$true_QMARK_(x) {
  return x === true;
};
cljs.core.boolean_QMARK_ = function cljs$core$boolean_QMARK_(x) {
  return x === true || x === false;
};
cljs.core.undefined_QMARK_ = function cljs$core$undefined_QMARK_(x) {
  return void 0 === x;
};
cljs.core.seq_QMARK_ = function cljs$core$seq_QMARK_(s) {
  if (s == null) {
    return false;
  } else {
    if (!(s == null)) {
      if (s.cljs$lang$protocol_mask$partition0$ & 64 || cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeq$) {
        return true;
      } else {
        if (!s.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, s);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq, s);
    }
  }
};
cljs.core.seqable_QMARK_ = function cljs$core$seqable_QMARK_(s) {
  var or__3922__auto__ = !(s == null) ? s.cljs$lang$protocol_mask$partition0$ & 8388608 || cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeqable$ ? true : !s.cljs$lang$protocol_mask$partition0$ ? cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, s) : false : cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable, s);
  if (or__3922__auto__) {
    return or__3922__auto__;
  } else {
    return cljs.core.array_QMARK_(s) || typeof s === "string";
  }
};
cljs.core.boolean$ = function cljs$core$boolean(x) {
  if (x == null) {
    return false;
  } else {
    if (x === false) {
      return false;
    } else {
      return true;
    }
  }
};
cljs.core.ifn_QMARK_ = function cljs$core$ifn_QMARK_(f) {
  var or__3922__auto__ = cljs.core.fn_QMARK_(f);
  if (or__3922__auto__) {
    return or__3922__auto__;
  } else {
    if (!(f == null)) {
      if (f.cljs$lang$protocol_mask$partition0$ & 1 || cljs.core.PROTOCOL_SENTINEL === f.cljs$core$IFn$) {
        return true;
      } else {
        if (!f.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.native_satisfies_QMARK_(cljs.core.IFn, f);
        } else {
          return false;
        }
      }
    } else {
      return cljs.core.native_satisfies_QMARK_(cljs.core.IFn, f);
    }
  }
};
cljs.core.integer_QMARK_ = function cljs$core$integer_QMARK_(n) {
  return typeof n === "number" && !isNaN(n) && !(n === Infinity) && parseFloat(n) === parseInt(n, 10);
};
cljs.core.int_QMARK_ = function cljs$core$int_QMARK_(x) {
  return cljs.core.integer_QMARK_(x) || x instanceof goog.math.Integer || x instanceof goog.math.Long;
};
cljs.core.pos_int_QMARK_ = function cljs$core$pos_int_QMARK_(x) {
  if (cljs.core.integer_QMARK_(x)) {
    return x > 0;
  } else {
    if (x instanceof goog.math.Integer) {
      return cljs.core.not(x.isNegative()) && cljs.core.not(x.isZero());
    } else {
      if (x instanceof goog.math.Long) {
        return cljs.core.not(x.isNegative()) && cljs.core.not(x.isZero());
      } else {
        return false;
      }
    }
  }
};
cljs.core.neg_int_QMARK_ = function cljs$core$neg_int_QMARK_(x) {
  if (cljs.core.integer_QMARK_(x)) {
    return x < 0;
  } else {
    if (x instanceof goog.math.Integer) {
      return x.isNegative();
    } else {
      if (x instanceof goog.math.Long) {
        return x.isNegative();
      } else {
        return false;
      }
    }
  }
};
cljs.core.nat_int_QMARK_ = function cljs$core$nat_int_QMARK_(x) {
  if (cljs.core.integer_QMARK_(x)) {
    return !(x < 0);
  } else {
    if (x instanceof goog.math.Integer) {
      return cljs.core.not(x.isNegative());
    } else {
      if (x instanceof goog.math.Long) {
        return cljs.core.not(x.isNegative());
      } else {
        return false;
      }
    }
  }
};
cljs.core.float_QMARK_ = function cljs$core$float_QMARK_(x) {
  return typeof x === "number";
};
cljs.core.double_QMARK_ = function cljs$core$double_QMARK_(x) {
  return typeof x === "number";
};
cljs.core.infinite_QMARK_ = function cljs$core$infinite_QMARK_(x) {
  return x === Number.POSITIVE_INFINITY || x === Number.NEGATIVE_INFINITY;
};
cljs.core.contains_QMARK_ = function cljs$core$contains_QMARK_(coll, v) {
  if (cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return false;
  } else {
    return true;
  }
};
cljs.core.find = function cljs$core$find(coll, k) {
  if (cljs.core.ifind_QMARK_(coll)) {
    return cljs.core._find(coll, k);
  } else {
    if (!(coll == null) && cljs.core.associative_QMARK_(coll) && cljs.core.contains_QMARK_(coll, k)) {
      return new cljs.core.MapEntry(k, cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, k), null);
    } else {
      return null;
    }
  }
};
cljs.core.distinct_QMARK_ = function cljs$core$distinct_QMARK_(var_args) {
  var G__4778 = arguments.length;
  switch(G__4778) {
    case 1:
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4780 = arguments.length;
      var i__4500__auto___4781 = 0;
      while (true) {
        if (i__4500__auto___4781 < len__4499__auto___4780) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4781]);
          var G__4782 = i__4500__auto___4781 + 1;
          i__4500__auto___4781 = G__4782;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return !cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y);
};
cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  if (!cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
    var s = cljs.core.PersistentHashSet.createAsIfByAssoc([x, y]);
    var xs = more;
    while (true) {
      var x__$1 = cljs.core.first(xs);
      var etc = cljs.core.next(xs);
      if (cljs.core.truth_(xs)) {
        if (cljs.core.contains_QMARK_(s, x__$1)) {
          return false;
        } else {
          var G__4783 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s, x__$1);
          var G__4784 = etc;
          s = G__4783;
          xs = G__4784;
          continue;
        }
      } else {
        return true;
      }
      break;
    }
  } else {
    return false;
  }
};
cljs.core.distinct_QMARK_.cljs$lang$applyTo = function(seq4775) {
  var G__4776 = cljs.core.first(seq4775);
  var seq4775__$1 = cljs.core.next(seq4775);
  var G__4777 = cljs.core.first(seq4775__$1);
  var seq4775__$2 = cljs.core.next(seq4775__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4776, G__4777, seq4775__$2);
};
cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = 2;
cljs.core.compare = function cljs$core$compare(x, y) {
  if (x === y) {
    return 0;
  } else {
    if (x == null) {
      return -1;
    } else {
      if (y == null) {
        return 1;
      } else {
        if (typeof x === "number") {
          if (typeof y === "number") {
            return goog.array.defaultCompare(x, y);
          } else {
            throw new Error(["Cannot compare ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(x), " to ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join(""));
          }
        } else {
          if (!(x == null) ? x.cljs$lang$protocol_mask$partition1$ & 2048 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IComparable$ ? true : !x.cljs$lang$protocol_mask$partition1$ ? cljs.core.native_satisfies_QMARK_(cljs.core.IComparable, x) : false : cljs.core.native_satisfies_QMARK_(cljs.core.IComparable, x)) {
            return cljs.core._compare(x, y);
          } else {
            if ((typeof x === "string" || cljs.core.array_QMARK_(x) || x === true || x === false) && cljs.core.type(x) === cljs.core.type(y)) {
              return goog.array.defaultCompare(x, y);
            } else {
              throw new Error(["Cannot compare ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(x), " to ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join(""));
            }
          }
        }
      }
    }
  }
};
cljs.core.compare_indexed = function cljs$core$compare_indexed(var_args) {
  var G__4787 = arguments.length;
  switch(G__4787) {
    case 2:
      return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 4:
      return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = function(xs, ys) {
  var xl = cljs.core.count(xs);
  var yl = cljs.core.count(ys);
  if (xl < yl) {
    return -1;
  } else {
    if (xl > yl) {
      return 1;
    } else {
      if (xl === 0) {
        return 0;
      } else {
        return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs, ys, xl, 0);
      }
    }
  }
};
cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = function(xs, ys, len, n) {
  while (true) {
    var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs, n), cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys, n));
    if (d === 0 && n + 1 < len) {
      var G__4789 = xs;
      var G__4790 = ys;
      var G__4791 = len;
      var G__4792 = n + 1;
      xs = G__4789;
      ys = G__4790;
      len = G__4791;
      n = G__4792;
      continue;
    } else {
      return d;
    }
    break;
  }
};
cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4;
cljs.core.fn__GT_comparator = function cljs$core$fn__GT_comparator(f) {
  if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f, cljs.core.compare)) {
    return cljs.core.compare;
  } else {
    return function(x, y) {
      var r = f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x, y) : f.call(null, x, y);
      if (typeof r === "number") {
        return r;
      } else {
        if (cljs.core.truth_(r)) {
          return -1;
        } else {
          if (cljs.core.truth_(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(y, x) : f.call(null, y, x))) {
            return 1;
          } else {
            return 0;
          }
        }
      }
    };
  }
};
cljs.core.sort = function cljs$core$sort(var_args) {
  var G__4794 = arguments.length;
  switch(G__4794) {
    case 1:
      return cljs.core.sort.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare, coll);
};
cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = function(comp, coll) {
  if (cljs.core.seq(coll)) {
    var a = cljs.core.to_array(coll);
    var G__4795_4798 = a;
    var G__4796_4799 = cljs.core.fn__GT_comparator(comp);
    goog.array.stableSort(G__4795_4798, G__4796_4799);
    return cljs.core.seq(a);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.sort.cljs$lang$maxFixedArity = 2;
cljs.core.sort_by = function cljs$core$sort_by(var_args) {
  var G__4801 = arguments.length;
  switch(G__4801) {
    case 2:
      return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = function(keyfn, coll) {
  return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn, cljs.core.compare, coll);
};
cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = function(keyfn, comp, coll) {
  return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(function(x, y) {
    var G__4803 = keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(x) : keyfn.call(null, x);
    var G__4804 = keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(y) : keyfn.call(null, y);
    var fexpr__4802 = cljs.core.fn__GT_comparator(comp);
    return fexpr__4802.cljs$core$IFn$_invoke$arity$2 ? fexpr__4802.cljs$core$IFn$_invoke$arity$2(G__4803, G__4804) : fexpr__4802.call(null, G__4803, G__4804);
  }, coll);
};
cljs.core.sort_by.cljs$lang$maxFixedArity = 3;
cljs.core.seq_reduce = function cljs$core$seq_reduce(var_args) {
  var G__4807 = arguments.length;
  switch(G__4807) {
    case 2:
      return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var temp__5455__auto__ = cljs.core.seq(coll);
  if (temp__5455__auto__) {
    var s = temp__5455__auto__;
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f, cljs.core.first(s), cljs.core.next(s));
  } else {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  }
};
cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = function(f, val, coll) {
  var val__$1 = val;
  var coll__$1 = cljs.core.seq(coll);
  while (true) {
    if (coll__$1) {
      var nval = function() {
        var G__4808 = val__$1;
        var G__4809 = cljs.core.first(coll__$1);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4808, G__4809) : f.call(null, G__4808, G__4809);
      }();
      if (cljs.core.reduced_QMARK_(nval)) {
        return cljs.core.deref(nval);
      } else {
        var G__4811 = nval;
        var G__4812 = cljs.core.next(coll__$1);
        val__$1 = G__4811;
        coll__$1 = G__4812;
        continue;
      }
    } else {
      return val__$1;
    }
    break;
  }
};
cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3;
cljs.core.shuffle = function cljs$core$shuffle(coll) {
  var a = cljs.core.to_array(coll);
  goog.array.shuffle(a);
  return cljs.core.vec(a);
};
cljs.core.iter_reduce = function cljs$core$iter_reduce(var_args) {
  var G__4814 = arguments.length;
  switch(G__4814) {
    case 2:
      return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2 = function(coll, f) {
  var iter = cljs.core._iterator(coll);
  if (cljs.core.truth_(iter.hasNext())) {
    var init = iter.next();
    var acc = init;
    while (true) {
      if (iter.hasNext()) {
        var nacc = function() {
          var G__4815 = acc;
          var G__4816 = iter.next();
          return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4815, G__4816) : f.call(null, G__4815, G__4816);
        }();
        if (cljs.core.reduced_QMARK_(nacc)) {
          return cljs.core.deref(nacc);
        } else {
          var G__4820 = nacc;
          acc = G__4820;
          continue;
        }
      } else {
        return acc;
      }
      break;
    }
  } else {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  }
};
cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3 = function(coll, f, init) {
  var iter = cljs.core._iterator(coll);
  var acc = init;
  while (true) {
    if (iter.hasNext()) {
      var nacc = function() {
        var G__4817 = acc;
        var G__4818 = iter.next();
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4817, G__4818) : f.call(null, G__4817, G__4818);
      }();
      if (cljs.core.reduced_QMARK_(nacc)) {
        return cljs.core.deref(nacc);
      } else {
        var G__4821 = nacc;
        acc = G__4821;
        continue;
      }
    } else {
      return acc;
    }
    break;
  }
};
cljs.core.iter_reduce.cljs$lang$maxFixedArity = 3;
cljs.core.reduce = function cljs$core$reduce(var_args) {
  var G__4823 = arguments.length;
  switch(G__4823) {
    case 2:
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 524288 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$ ? true : false : false) {
    return coll.cljs$core$IReduce$_reduce$arity$2(null, f);
  } else {
    if (cljs.core.array_QMARK_(coll)) {
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
    } else {
      if (typeof coll === "string") {
        return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
      } else {
        if (cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, coll)) {
          return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
        } else {
          if (cljs.core.iterable_QMARK_(coll)) {
            return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2(coll, f);
          } else {
            return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll);
          }
        }
      }
    }
  }
};
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = function(f, val, coll) {
  if (!(coll == null) ? coll.cljs$lang$protocol_mask$partition0$ & 524288 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$ ? true : false : false) {
    return coll.cljs$core$IReduce$_reduce$arity$3(null, f, val);
  } else {
    if (cljs.core.array_QMARK_(coll)) {
      return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
    } else {
      if (typeof coll === "string") {
        return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
      } else {
        if (cljs.core.native_satisfies_QMARK_(cljs.core.IReduce, coll)) {
          return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
        } else {
          if (cljs.core.iterable_QMARK_(coll)) {
            return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3(coll, f, val);
          } else {
            return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, val, coll);
          }
        }
      }
    }
  }
};
cljs.core.reduce.cljs$lang$maxFixedArity = 3;
cljs.core.reduce_kv = function cljs$core$reduce_kv(f, init, coll) {
  if (!(coll == null)) {
    return cljs.core._kv_reduce(coll, f, init);
  } else {
    return init;
  }
};
cljs.core.identity = function cljs$core$identity(x) {
  return x;
};
cljs.core.completing = function cljs$core$completing(var_args) {
  var G__4828 = arguments.length;
  switch(G__4828) {
    case 1:
      return cljs.core.completing.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f, cljs.core.identity);
};
cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = function(f, cf) {
  return function() {
    var G__4830 = null;
    var G__4830__0 = function() {
      return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
    };
    var G__4830__1 = function(x) {
      return cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(x) : cf.call(null, x);
    };
    var G__4830__2 = function(x, y) {
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x, y) : f.call(null, x, y);
    };
    G__4830 = function(x, y) {
      switch(arguments.length) {
        case 0:
          return G__4830__0.call(this);
        case 1:
          return G__4830__1.call(this, x);
        case 2:
          return G__4830__2.call(this, x, y);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    G__4830.cljs$core$IFn$_invoke$arity$0 = G__4830__0;
    G__4830.cljs$core$IFn$_invoke$arity$1 = G__4830__1;
    G__4830.cljs$core$IFn$_invoke$arity$2 = G__4830__2;
    return G__4830;
  }();
};
cljs.core.completing.cljs$lang$maxFixedArity = 2;
cljs.core.transduce = function cljs$core$transduce(var_args) {
  var G__4832 = arguments.length;
  switch(G__4832) {
    case 3:
      return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = function(xform, f, coll) {
  return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, f, f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null), coll);
};
cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = function(xform, f, init, coll) {
  var f__$1 = xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null, f);
  var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1, init, coll);
  return f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(ret) : f__$1.call(null, ret);
};
cljs.core.transduce.cljs$lang$maxFixedArity = 4;
cljs.core._PLUS_ = function cljs$core$_PLUS_(var_args) {
  var G__4838 = arguments.length;
  switch(G__4838) {
    case 0:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4840 = arguments.length;
      var i__4500__auto___4841 = 0;
      while (true) {
        if (i__4500__auto___4841 < len__4499__auto___4840) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4841]);
          var G__4842 = i__4500__auto___4841 + 1;
          i__4500__auto___4841 = G__4842;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_, x + y, more);
};
cljs.core._PLUS_.cljs$lang$applyTo = function(seq4835) {
  var G__4836 = cljs.core.first(seq4835);
  var seq4835__$1 = cljs.core.next(seq4835);
  var G__4837 = cljs.core.first(seq4835__$1);
  var seq4835__$2 = cljs.core.next(seq4835__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4836, G__4837, seq4835__$2);
};
cljs.core._PLUS_.cljs$lang$maxFixedArity = 2;
cljs.core._ = function cljs$core$_(var_args) {
  var G__4847 = arguments.length;
  switch(G__4847) {
    case 1:
      return cljs.core._.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4849 = arguments.length;
      var i__4500__auto___4850 = 0;
      while (true) {
        if (i__4500__auto___4850 < len__4499__auto___4849) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4850]);
          var G__4851 = i__4500__auto___4850 + 1;
          i__4500__auto___4850 = G__4851;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core._.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return -x;
};
cljs.core._.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core._.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._, x - y, more);
};
cljs.core._.cljs$lang$applyTo = function(seq4844) {
  var G__4845 = cljs.core.first(seq4844);
  var seq4844__$1 = cljs.core.next(seq4844);
  var G__4846 = cljs.core.first(seq4844__$1);
  var seq4844__$2 = cljs.core.next(seq4844__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4845, G__4846, seq4844__$2);
};
cljs.core._.cljs$lang$maxFixedArity = 2;
cljs.core._STAR_ = function cljs$core$_STAR_(var_args) {
  var G__4856 = arguments.length;
  switch(G__4856) {
    case 0:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4858 = arguments.length;
      var i__4500__auto___4859 = 0;
      while (true) {
        if (i__4500__auto___4859 < len__4499__auto___4858) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4859]);
          var G__4860 = i__4500__auto___4859 + 1;
          i__4500__auto___4859 = G__4860;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_, x * y, more);
};
cljs.core._STAR_.cljs$lang$applyTo = function(seq4853) {
  var G__4854 = cljs.core.first(seq4853);
  var seq4853__$1 = cljs.core.next(seq4853);
  var G__4855 = cljs.core.first(seq4853__$1);
  var seq4853__$2 = cljs.core.next(seq4853__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4854, G__4855, seq4853__$2);
};
cljs.core._STAR_.cljs$lang$maxFixedArity = 2;
cljs.core._SLASH_ = function cljs$core$_SLASH_(var_args) {
  var G__4865 = arguments.length;
  switch(G__4865) {
    case 1:
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4867 = arguments.length;
      var i__4500__auto___4868 = 0;
      while (true) {
        if (i__4500__auto___4868 < len__4499__auto___4867) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4868]);
          var G__4869 = i__4500__auto___4868 + 1;
          i__4500__auto___4868 = G__4869;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return 1 / x;
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x / y;
};
cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_, x / y, more);
};
cljs.core._SLASH_.cljs$lang$applyTo = function(seq4862) {
  var G__4863 = cljs.core.first(seq4862);
  var seq4862__$1 = cljs.core.next(seq4862);
  var G__4864 = cljs.core.first(seq4862__$1);
  var seq4862__$2 = cljs.core.next(seq4862__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4863, G__4864, seq4862__$2);
};
cljs.core._SLASH_.cljs$lang$maxFixedArity = 2;
cljs.core._LT_ = function cljs$core$_LT_(var_args) {
  var G__4874 = arguments.length;
  switch(G__4874) {
    case 1:
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4876 = arguments.length;
      var i__4500__auto___4877 = 0;
      while (true) {
        if (i__4500__auto___4877 < len__4499__auto___4876) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4877]);
          var G__4878 = i__4500__auto___4877 + 1;
          i__4500__auto___4877 = G__4878;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x < y;
};
cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x < y) {
      if (cljs.core.next(more)) {
        var G__4879 = y;
        var G__4880 = cljs.core.first(more);
        var G__4881 = cljs.core.next(more);
        x = G__4879;
        y = G__4880;
        more = G__4881;
        continue;
      } else {
        return y < cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._LT_.cljs$lang$applyTo = function(seq4871) {
  var G__4872 = cljs.core.first(seq4871);
  var seq4871__$1 = cljs.core.next(seq4871);
  var G__4873 = cljs.core.first(seq4871__$1);
  var seq4871__$2 = cljs.core.next(seq4871__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4872, G__4873, seq4871__$2);
};
cljs.core._LT_.cljs$lang$maxFixedArity = 2;
cljs.core._LT__EQ_ = function cljs$core$_LT__EQ_(var_args) {
  var G__4886 = arguments.length;
  switch(G__4886) {
    case 1:
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4888 = arguments.length;
      var i__4500__auto___4889 = 0;
      while (true) {
        if (i__4500__auto___4889 < len__4499__auto___4888) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4889]);
          var G__4890 = i__4500__auto___4889 + 1;
          i__4500__auto___4889 = G__4890;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x <= y;
};
cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x <= y) {
      if (cljs.core.next(more)) {
        var G__4891 = y;
        var G__4892 = cljs.core.first(more);
        var G__4893 = cljs.core.next(more);
        x = G__4891;
        y = G__4892;
        more = G__4893;
        continue;
      } else {
        return y <= cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._LT__EQ_.cljs$lang$applyTo = function(seq4883) {
  var G__4884 = cljs.core.first(seq4883);
  var seq4883__$1 = cljs.core.next(seq4883);
  var G__4885 = cljs.core.first(seq4883__$1);
  var seq4883__$2 = cljs.core.next(seq4883__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4884, G__4885, seq4883__$2);
};
cljs.core._LT__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core._GT_ = function cljs$core$_GT_(var_args) {
  var G__4898 = arguments.length;
  switch(G__4898) {
    case 1:
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4900 = arguments.length;
      var i__4500__auto___4901 = 0;
      while (true) {
        if (i__4500__auto___4901 < len__4499__auto___4900) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4901]);
          var G__4902 = i__4500__auto___4901 + 1;
          i__4500__auto___4901 = G__4902;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x > y;
};
cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x > y) {
      if (cljs.core.next(more)) {
        var G__4903 = y;
        var G__4904 = cljs.core.first(more);
        var G__4905 = cljs.core.next(more);
        x = G__4903;
        y = G__4904;
        more = G__4905;
        continue;
      } else {
        return y > cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._GT_.cljs$lang$applyTo = function(seq4895) {
  var G__4896 = cljs.core.first(seq4895);
  var seq4895__$1 = cljs.core.next(seq4895);
  var G__4897 = cljs.core.first(seq4895__$1);
  var seq4895__$2 = cljs.core.next(seq4895__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4896, G__4897, seq4895__$2);
};
cljs.core._GT_.cljs$lang$maxFixedArity = 2;
cljs.core._GT__EQ_ = function cljs$core$_GT__EQ_(var_args) {
  var G__4910 = arguments.length;
  switch(G__4910) {
    case 1:
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4912 = arguments.length;
      var i__4500__auto___4913 = 0;
      while (true) {
        if (i__4500__auto___4913 < len__4499__auto___4912) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4913]);
          var G__4914 = i__4500__auto___4913 + 1;
          i__4500__auto___4913 = G__4914;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x >= y;
};
cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x >= y) {
      if (cljs.core.next(more)) {
        var G__4915 = y;
        var G__4916 = cljs.core.first(more);
        var G__4917 = cljs.core.next(more);
        x = G__4915;
        y = G__4916;
        more = G__4917;
        continue;
      } else {
        return y >= cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._GT__EQ_.cljs$lang$applyTo = function(seq4907) {
  var G__4908 = cljs.core.first(seq4907);
  var seq4907__$1 = cljs.core.next(seq4907);
  var G__4909 = cljs.core.first(seq4907__$1);
  var seq4907__$2 = cljs.core.next(seq4907__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4908, G__4909, seq4907__$2);
};
cljs.core._GT__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.dec = function cljs$core$dec(x) {
  return x - 1;
};
cljs.core.max = function cljs$core$max(var_args) {
  var G__4922 = arguments.length;
  switch(G__4922) {
    case 1:
      return cljs.core.max.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.max.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4924 = arguments.length;
      var i__4500__auto___4925 = 0;
      while (true) {
        if (i__4500__auto___4925 < len__4499__auto___4924) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4925]);
          var G__4926 = i__4500__auto___4925 + 1;
          i__4500__auto___4925 = G__4926;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.max.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.max.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  var x__4006__auto__ = x;
  var y__4007__auto__ = y;
  return x__4006__auto__ > y__4007__auto__ ? x__4006__auto__ : y__4007__auto__;
};
cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max, function() {
    var x__4006__auto__ = x;
    var y__4007__auto__ = y;
    return x__4006__auto__ > y__4007__auto__ ? x__4006__auto__ : y__4007__auto__;
  }(), more);
};
cljs.core.max.cljs$lang$applyTo = function(seq4919) {
  var G__4920 = cljs.core.first(seq4919);
  var seq4919__$1 = cljs.core.next(seq4919);
  var G__4921 = cljs.core.first(seq4919__$1);
  var seq4919__$2 = cljs.core.next(seq4919__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4920, G__4921, seq4919__$2);
};
cljs.core.max.cljs$lang$maxFixedArity = 2;
cljs.core.min = function cljs$core$min(var_args) {
  var G__4931 = arguments.length;
  switch(G__4931) {
    case 1:
      return cljs.core.min.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.min.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4933 = arguments.length;
      var i__4500__auto___4934 = 0;
      while (true) {
        if (i__4500__auto___4934 < len__4499__auto___4933) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4934]);
          var G__4935 = i__4500__auto___4934 + 1;
          i__4500__auto___4934 = G__4935;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.min.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.min.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  var x__4009__auto__ = x;
  var y__4010__auto__ = y;
  return x__4009__auto__ < y__4010__auto__ ? x__4009__auto__ : y__4010__auto__;
};
cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min, function() {
    var x__4009__auto__ = x;
    var y__4010__auto__ = y;
    return x__4009__auto__ < y__4010__auto__ ? x__4009__auto__ : y__4010__auto__;
  }(), more);
};
cljs.core.min.cljs$lang$applyTo = function(seq4928) {
  var G__4929 = cljs.core.first(seq4928);
  var seq4928__$1 = cljs.core.next(seq4928);
  var G__4930 = cljs.core.first(seq4928__$1);
  var seq4928__$2 = cljs.core.next(seq4928__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4929, G__4930, seq4928__$2);
};
cljs.core.min.cljs$lang$maxFixedArity = 2;
cljs.core.byte$ = function cljs$core$byte(x) {
  return x;
};
cljs.core.char$ = function cljs$core$char(x) {
  if (typeof x === "number") {
    return String.fromCharCode(x);
  } else {
    if (typeof x === "string" && x.length === 1) {
      return x;
    } else {
      throw new Error("Argument to char must be a character or number");
    }
  }
};
cljs.core.short$ = function cljs$core$short(x) {
  return x;
};
cljs.core.float$ = function cljs$core$float(x) {
  return x;
};
cljs.core.double$ = function cljs$core$double(x) {
  return x;
};
cljs.core.unchecked_byte = function cljs$core$unchecked_byte(x) {
  return x;
};
cljs.core.unchecked_char = function cljs$core$unchecked_char(x) {
  return x;
};
cljs.core.unchecked_short = function cljs$core$unchecked_short(x) {
  return x;
};
cljs.core.unchecked_float = function cljs$core$unchecked_float(x) {
  return x;
};
cljs.core.unchecked_double = function cljs$core$unchecked_double(x) {
  return x;
};
cljs.core.unchecked_add = function cljs$core$unchecked_add(var_args) {
  var G__4940 = arguments.length;
  switch(G__4940) {
    case 0:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4942 = arguments.length;
      var i__4500__auto___4943 = 0;
      while (true) {
        if (i__4500__auto___4943 < len__4499__auto___4942) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4943]);
          var G__4944 = i__4500__auto___4943 + 1;
          i__4500__auto___4943 = G__4944;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add, x + y, more);
};
cljs.core.unchecked_add.cljs$lang$applyTo = function(seq4937) {
  var G__4938 = cljs.core.first(seq4937);
  var seq4937__$1 = cljs.core.next(seq4937);
  var G__4939 = cljs.core.first(seq4937__$1);
  var seq4937__$2 = cljs.core.next(seq4937__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4938, G__4939, seq4937__$2);
};
cljs.core.unchecked_add.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_add_int = function cljs$core$unchecked_add_int(var_args) {
  var G__4949 = arguments.length;
  switch(G__4949) {
    case 0:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4951 = arguments.length;
      var i__4500__auto___4952 = 0;
      while (true) {
        if (i__4500__auto___4952 < len__4499__auto___4951) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4952]);
          var G__4953 = i__4500__auto___4952 + 1;
          i__4500__auto___4952 = G__4953;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = function() {
  return 0;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x + y;
};
cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int, x + y, more);
};
cljs.core.unchecked_add_int.cljs$lang$applyTo = function(seq4946) {
  var G__4947 = cljs.core.first(seq4946);
  var seq4946__$1 = cljs.core.next(seq4946);
  var G__4948 = cljs.core.first(seq4946__$1);
  var seq4946__$2 = cljs.core.next(seq4946__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4947, G__4948, seq4946__$2);
};
cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_dec = function cljs$core$unchecked_dec(x) {
  return x - 1;
};
cljs.core.unchecked_dec_int = function cljs$core$unchecked_dec_int(x) {
  return x - 1;
};
cljs.core.unchecked_divide_int = function cljs$core$unchecked_divide_int(var_args) {
  var G__4958 = arguments.length;
  switch(G__4958) {
    case 1:
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4960 = arguments.length;
      var i__4500__auto___4961 = 0;
      while (true) {
        if (i__4500__auto___4961 < len__4499__auto___4960) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4961]);
          var G__4962 = i__4500__auto___4961 + 1;
          i__4500__auto___4961 = G__4962;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return 1 / x;
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x / y;
};
cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int, x / y, more);
};
cljs.core.unchecked_divide_int.cljs$lang$applyTo = function(seq4955) {
  var G__4956 = cljs.core.first(seq4955);
  var seq4955__$1 = cljs.core.next(seq4955);
  var G__4957 = cljs.core.first(seq4955__$1);
  var seq4955__$2 = cljs.core.next(seq4955__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4956, G__4957, seq4955__$2);
};
cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_inc = function cljs$core$unchecked_inc(x) {
  return x + 1;
};
cljs.core.unchecked_inc_int = function cljs$core$unchecked_inc_int(x) {
  return x + 1;
};
cljs.core.unchecked_multiply = function cljs$core$unchecked_multiply(var_args) {
  var G__4967 = arguments.length;
  switch(G__4967) {
    case 0:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4969 = arguments.length;
      var i__4500__auto___4970 = 0;
      while (true) {
        if (i__4500__auto___4970 < len__4499__auto___4969) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4970]);
          var G__4971 = i__4500__auto___4970 + 1;
          i__4500__auto___4970 = G__4971;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply, x * y, more);
};
cljs.core.unchecked_multiply.cljs$lang$applyTo = function(seq4964) {
  var G__4965 = cljs.core.first(seq4964);
  var seq4964__$1 = cljs.core.next(seq4964);
  var G__4966 = cljs.core.first(seq4964__$1);
  var seq4964__$2 = cljs.core.next(seq4964__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4965, G__4966, seq4964__$2);
};
cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_multiply_int = function cljs$core$unchecked_multiply_int(var_args) {
  var G__4976 = arguments.length;
  switch(G__4976) {
    case 0:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4978 = arguments.length;
      var i__4500__auto___4979 = 0;
      while (true) {
        if (i__4500__auto___4979 < len__4499__auto___4978) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4979]);
          var G__4980 = i__4500__auto___4979 + 1;
          i__4500__auto___4979 = G__4980;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = function() {
  return 1;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return x;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x * y;
};
cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int, x * y, more);
};
cljs.core.unchecked_multiply_int.cljs$lang$applyTo = function(seq4973) {
  var G__4974 = cljs.core.first(seq4973);
  var seq4973__$1 = cljs.core.next(seq4973);
  var G__4975 = cljs.core.first(seq4973__$1);
  var seq4973__$2 = cljs.core.next(seq4973__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4974, G__4975, seq4973__$2);
};
cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_negate = function cljs$core$unchecked_negate(x) {
  return -x;
};
cljs.core.unchecked_negate_int = function cljs$core$unchecked_negate_int(x) {
  return -x;
};
cljs.core.unchecked_remainder_int = function cljs$core$unchecked_remainder_int(x, n) {
  return cljs.core.mod(x, n);
};
cljs.core.unchecked_subtract = function cljs$core$unchecked_subtract(var_args) {
  var G__4985 = arguments.length;
  switch(G__4985) {
    case 1:
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4987 = arguments.length;
      var i__4500__auto___4988 = 0;
      while (true) {
        if (i__4500__auto___4988 < len__4499__auto___4987) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4988]);
          var G__4989 = i__4500__auto___4988 + 1;
          i__4500__auto___4988 = G__4989;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return -x;
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract, x - y, more);
};
cljs.core.unchecked_subtract.cljs$lang$applyTo = function(seq4982) {
  var G__4983 = cljs.core.first(seq4982);
  var seq4982__$1 = cljs.core.next(seq4982);
  var G__4984 = cljs.core.first(seq4982__$1);
  var seq4982__$2 = cljs.core.next(seq4982__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4983, G__4984, seq4982__$2);
};
cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = 2;
cljs.core.unchecked_subtract_int = function cljs$core$unchecked_subtract_int(var_args) {
  var G__4994 = arguments.length;
  switch(G__4994) {
    case 1:
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___4996 = arguments.length;
      var i__4500__auto___4997 = 0;
      while (true) {
        if (i__4500__auto___4997 < len__4499__auto___4996) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___4997]);
          var G__4998 = i__4500__auto___4997 + 1;
          i__4500__auto___4997 = G__4998;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return -x;
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x - y;
};
cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int, x - y, more);
};
cljs.core.unchecked_subtract_int.cljs$lang$applyTo = function(seq4991) {
  var G__4992 = cljs.core.first(seq4991);
  var seq4991__$1 = cljs.core.next(seq4991);
  var G__4993 = cljs.core.first(seq4991__$1);
  var seq4991__$2 = cljs.core.next(seq4991__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4992, G__4993, seq4991__$2);
};
cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = 2;
cljs.core.fix = function cljs$core$fix(q) {
  if (q >= 0) {
    return Math.floor(q);
  } else {
    return Math.ceil(q);
  }
};
cljs.core.int$ = function cljs$core$int(x) {
  return x | 0;
};
cljs.core.unchecked_int = function cljs$core$unchecked_int(x) {
  return cljs.core.fix(x);
};
cljs.core.long$ = function cljs$core$long(x) {
  return cljs.core.fix(x);
};
cljs.core.unchecked_long = function cljs$core$unchecked_long(x) {
  return cljs.core.fix(x);
};
cljs.core.booleans = function cljs$core$booleans(x) {
  return x;
};
cljs.core.bytes = function cljs$core$bytes(x) {
  return x;
};
cljs.core.chars = function cljs$core$chars(x) {
  return x;
};
cljs.core.shorts = function cljs$core$shorts(x) {
  return x;
};
cljs.core.ints = function cljs$core$ints(x) {
  return x;
};
cljs.core.floats = function cljs$core$floats(x) {
  return x;
};
cljs.core.doubles = function cljs$core$doubles(x) {
  return x;
};
cljs.core.longs = function cljs$core$longs(x) {
  return x;
};
cljs.core.js_mod = function cljs$core$js_mod(n, d) {
  return n % d;
};
cljs.core.mod = function cljs$core$mod(n, d) {
  return (n % d + d) % d;
};
cljs.core.quot = function cljs$core$quot(n, d) {
  var rem = n % d;
  return cljs.core.fix((n - rem) / d);
};
cljs.core.rem = function cljs$core$rem(n, d) {
  var q = cljs.core.quot(n, d);
  return n - d * q;
};
cljs.core.bit_xor = function cljs$core$bit_xor(var_args) {
  var G__5003 = arguments.length;
  switch(G__5003) {
    case 2:
      return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5005 = arguments.length;
      var i__4500__auto___5006 = 0;
      while (true) {
        if (i__4500__auto___5006 < len__4499__auto___5005) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5006]);
          var G__5007 = i__4500__auto___5006 + 1;
          i__4500__auto___5006 = G__5007;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x ^ y;
};
cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor, x ^ y, more);
};
cljs.core.bit_xor.cljs$lang$applyTo = function(seq5000) {
  var G__5001 = cljs.core.first(seq5000);
  var seq5000__$1 = cljs.core.next(seq5000);
  var G__5002 = cljs.core.first(seq5000__$1);
  var seq5000__$2 = cljs.core.next(seq5000__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5001, G__5002, seq5000__$2);
};
cljs.core.bit_xor.cljs$lang$maxFixedArity = 2;
cljs.core.bit_and = function cljs$core$bit_and(var_args) {
  var G__5012 = arguments.length;
  switch(G__5012) {
    case 2:
      return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5014 = arguments.length;
      var i__4500__auto___5015 = 0;
      while (true) {
        if (i__4500__auto___5015 < len__4499__auto___5014) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5015]);
          var G__5016 = i__4500__auto___5015 + 1;
          i__4500__auto___5015 = G__5016;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x & y;
};
cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and, x & y, more);
};
cljs.core.bit_and.cljs$lang$applyTo = function(seq5009) {
  var G__5010 = cljs.core.first(seq5009);
  var seq5009__$1 = cljs.core.next(seq5009);
  var G__5011 = cljs.core.first(seq5009__$1);
  var seq5009__$2 = cljs.core.next(seq5009__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5010, G__5011, seq5009__$2);
};
cljs.core.bit_and.cljs$lang$maxFixedArity = 2;
cljs.core.bit_or = function cljs$core$bit_or(var_args) {
  var G__5021 = arguments.length;
  switch(G__5021) {
    case 2:
      return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5023 = arguments.length;
      var i__4500__auto___5024 = 0;
      while (true) {
        if (i__4500__auto___5024 < len__4499__auto___5023) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5024]);
          var G__5025 = i__4500__auto___5024 + 1;
          i__4500__auto___5024 = G__5025;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x | y;
};
cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or, x | y, more);
};
cljs.core.bit_or.cljs$lang$applyTo = function(seq5018) {
  var G__5019 = cljs.core.first(seq5018);
  var seq5018__$1 = cljs.core.next(seq5018);
  var G__5020 = cljs.core.first(seq5018__$1);
  var seq5018__$2 = cljs.core.next(seq5018__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5019, G__5020, seq5018__$2);
};
cljs.core.bit_or.cljs$lang$maxFixedArity = 2;
cljs.core.bit_and_not = function cljs$core$bit_and_not(var_args) {
  var G__5030 = arguments.length;
  switch(G__5030) {
    case 2:
      return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5032 = arguments.length;
      var i__4500__auto___5033 = 0;
      while (true) {
        if (i__4500__auto___5033 < len__4499__auto___5032) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5033]);
          var G__5034 = i__4500__auto___5033 + 1;
          i__4500__auto___5033 = G__5034;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return x & ~y;
};
cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not, x & ~y, more);
};
cljs.core.bit_and_not.cljs$lang$applyTo = function(seq5027) {
  var G__5028 = cljs.core.first(seq5027);
  var seq5027__$1 = cljs.core.next(seq5027);
  var G__5029 = cljs.core.first(seq5027__$1);
  var seq5027__$2 = cljs.core.next(seq5027__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5028, G__5029, seq5027__$2);
};
cljs.core.bit_and_not.cljs$lang$maxFixedArity = 2;
cljs.core.bit_clear = function cljs$core$bit_clear(x, n) {
  return x & ~(1 << n);
};
cljs.core.bit_flip = function cljs$core$bit_flip(x, n) {
  return x ^ 1 << n;
};
cljs.core.bit_not = function cljs$core$bit_not(x) {
  return ~x;
};
cljs.core.bit_set = function cljs$core$bit_set(x, n) {
  return x | 1 << n;
};
cljs.core.bit_test = function cljs$core$bit_test(x, n) {
  return (x & 1 << n) != 0;
};
cljs.core.bit_shift_left = function cljs$core$bit_shift_left(x, n) {
  return x << n;
};
cljs.core.bit_shift_right = function cljs$core$bit_shift_right(x, n) {
  return x >> n;
};
cljs.core.bit_shift_right_zero_fill = function cljs$core$bit_shift_right_zero_fill(x, n) {
  return x >>> n;
};
cljs.core.unsigned_bit_shift_right = function cljs$core$unsigned_bit_shift_right(x, n) {
  return x >>> n;
};
cljs.core.bit_count = function cljs$core$bit_count(v) {
  var v__$1 = v - (v >> 1 & 1431655765);
  var v__$2 = (v__$1 & 858993459) + (v__$1 >> 2 & 858993459);
  return (v__$2 + (v__$2 >> 4) & 252645135) * 16843009 >> 24;
};
cljs.core._EQ__EQ_ = function cljs$core$_EQ__EQ_(var_args) {
  var G__5039 = arguments.length;
  switch(G__5039) {
    case 1:
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5041 = arguments.length;
      var i__4500__auto___5042 = 0;
      while (true) {
        if (i__4500__auto___5042 < len__4499__auto___5041) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5042]);
          var G__5043 = i__4500__auto___5042 + 1;
          i__4500__auto___5042 = G__5043;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return true;
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return cljs.core._equiv(x, y);
};
cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  while (true) {
    if (x === y) {
      if (cljs.core.next(more)) {
        var G__5044 = y;
        var G__5045 = cljs.core.first(more);
        var G__5046 = cljs.core.next(more);
        x = G__5044;
        y = G__5045;
        more = G__5046;
        continue;
      } else {
        return y === cljs.core.first(more);
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core._EQ__EQ_.cljs$lang$applyTo = function(seq5036) {
  var G__5037 = cljs.core.first(seq5036);
  var seq5036__$1 = cljs.core.next(seq5036);
  var G__5038 = cljs.core.first(seq5036__$1);
  var seq5036__$2 = cljs.core.next(seq5036__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5037, G__5038, seq5036__$2);
};
cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.pos_QMARK_ = function cljs$core$pos_QMARK_(x) {
  return x > 0;
};
cljs.core.zero_QMARK_ = function cljs$core$zero_QMARK_(x) {
  return x === 0;
};
cljs.core.neg_QMARK_ = function cljs$core$neg_QMARK_(x) {
  return x < 0;
};
cljs.core.nthnext = function cljs$core$nthnext(coll, n) {
  var n__$1 = n;
  var xs = cljs.core.seq(coll);
  while (true) {
    if (xs && n__$1 > 0) {
      var G__5047 = n__$1 - 1;
      var G__5048 = cljs.core.next(xs);
      n__$1 = G__5047;
      xs = G__5048;
      continue;
    } else {
      return xs;
    }
    break;
  }
};
cljs.core.str = function cljs$core$str(var_args) {
  var G__5052 = arguments.length;
  switch(G__5052) {
    case 0:
      return cljs.core.str.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5054 = arguments.length;
      var i__4500__auto___5055 = 0;
      while (true) {
        if (i__4500__auto___5055 < len__4499__auto___5054) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5055]);
          var G__5056 = i__4500__auto___5055 + 1;
          i__4500__auto___5055 = G__5056;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(1), 0, null);
      return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__4515__auto__);
  }
};
cljs.core.str.cljs$core$IFn$_invoke$arity$0 = function() {
  return "";
};
cljs.core.str.cljs$core$IFn$_invoke$arity$1 = function(x) {
  if (x == null) {
    return "";
  } else {
    return [x].join("");
  }
};
cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = function(x, ys) {
  var sb = new goog.string.StringBuffer([cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(""));
  var more = ys;
  while (true) {
    if (cljs.core.truth_(more)) {
      var G__5057 = sb.append([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(more))].join(""));
      var G__5058 = cljs.core.next(more);
      sb = G__5057;
      more = G__5058;
      continue;
    } else {
      return sb.toString();
    }
    break;
  }
};
cljs.core.str.cljs$lang$applyTo = function(seq5050) {
  var G__5051 = cljs.core.first(seq5050);
  var seq5050__$1 = cljs.core.next(seq5050);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5051, seq5050__$1);
};
cljs.core.str.cljs$lang$maxFixedArity = 1;
cljs.core.subs = function cljs$core$subs(var_args) {
  var G__5060 = arguments.length;
  switch(G__5060) {
    case 2:
      return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = function(s, start) {
  return s.substring(start);
};
cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = function(s, start, end) {
  return s.substring(start, end);
};
cljs.core.subs.cljs$lang$maxFixedArity = 3;
cljs.core.equiv_sequential = function cljs$core$equiv_sequential(x, y) {
  return cljs.core.boolean$(cljs.core.sequential_QMARK_(y) ? cljs.core.counted_QMARK_(x) && cljs.core.counted_QMARK_(y) && !(cljs.core.count(x) === cljs.core.count(y)) ? false : function() {
    var xs = cljs.core.seq(x);
    var ys = cljs.core.seq(y);
    while (true) {
      if (xs == null) {
        return ys == null;
      } else {
        if (ys == null) {
          return false;
        } else {
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs), cljs.core.first(ys))) {
            var G__5062 = cljs.core.next(xs);
            var G__5063 = cljs.core.next(ys);
            xs = G__5062;
            ys = G__5063;
            continue;
          } else {
            return false;
          }
        }
      }
      break;
    }
  }() : null);
};
cljs.core.hash_coll = function cljs$core$hash_coll(coll) {
  if (cljs.core.seq(coll)) {
    var res = cljs.core.hash(cljs.core.first(coll));
    var s = cljs.core.next(coll);
    while (true) {
      if (s == null) {
        return res;
      } else {
        var G__5064 = cljs.core.hash_combine(res, cljs.core.hash(cljs.core.first(s)));
        var G__5065 = cljs.core.next(s);
        res = G__5064;
        s = G__5065;
        continue;
      }
      break;
    }
  } else {
    return 0;
  }
};
cljs.core.hash_imap = function cljs$core$hash_imap(m) {
  var h = 0;
  var s = cljs.core.seq(m);
  while (true) {
    if (s) {
      var e = cljs.core.first(s);
      var G__5066 = (h + (cljs.core.hash(cljs.core.key(e)) ^ cljs.core.hash(cljs.core.val(e)))) % 4503599627370496;
      var G__5067 = cljs.core.next(s);
      h = G__5066;
      s = G__5067;
      continue;
    } else {
      return h;
    }
    break;
  }
};
cljs.core.hash_iset = function cljs$core$hash_iset(s) {
  var h = 0;
  var s__$1 = cljs.core.seq(s);
  while (true) {
    if (s__$1) {
      var e = cljs.core.first(s__$1);
      var G__5068 = (h + cljs.core.hash(e)) % 4503599627370496;
      var G__5069 = cljs.core.next(s__$1);
      h = G__5068;
      s__$1 = G__5069;
      continue;
    } else {
      return h;
    }
    break;
  }
};
cljs.core.extend_object_BANG_ = function cljs$core$extend_object_BANG_(obj, fn_map) {
  var seq__5070_5080 = cljs.core.seq(fn_map);
  var chunk__5071_5081 = null;
  var count__5072_5082 = 0;
  var i__5073_5083 = 0;
  while (true) {
    if (i__5073_5083 < count__5072_5082) {
      var vec__5074_5084 = chunk__5071_5081.cljs$core$IIndexed$_nth$arity$2(null, i__5073_5083);
      var key_name_5085 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5074_5084, 0, null);
      var f_5086 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5074_5084, 1, null);
      var str_name_5087 = cljs.core.name(key_name_5085);
      goog.object.set(obj, str_name_5087, f_5086);
      var G__5088 = seq__5070_5080;
      var G__5089 = chunk__5071_5081;
      var G__5090 = count__5072_5082;
      var G__5091 = i__5073_5083 + 1;
      seq__5070_5080 = G__5088;
      chunk__5071_5081 = G__5089;
      count__5072_5082 = G__5090;
      i__5073_5083 = G__5091;
      continue;
    } else {
      var temp__5457__auto___5092 = cljs.core.seq(seq__5070_5080);
      if (temp__5457__auto___5092) {
        var seq__5070_5093__$1 = temp__5457__auto___5092;
        if (cljs.core.chunked_seq_QMARK_(seq__5070_5093__$1)) {
          var c__4319__auto___5094 = cljs.core.chunk_first(seq__5070_5093__$1);
          var G__5095 = cljs.core.chunk_rest(seq__5070_5093__$1);
          var G__5096 = c__4319__auto___5094;
          var G__5097 = cljs.core.count(c__4319__auto___5094);
          var G__5098 = 0;
          seq__5070_5080 = G__5095;
          chunk__5071_5081 = G__5096;
          count__5072_5082 = G__5097;
          i__5073_5083 = G__5098;
          continue;
        } else {
          var vec__5077_5099 = cljs.core.first(seq__5070_5093__$1);
          var key_name_5100 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5077_5099, 0, null);
          var f_5101 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5077_5099, 1, null);
          var str_name_5102 = cljs.core.name(key_name_5100);
          goog.object.set(obj, str_name_5102, f_5101);
          var G__5103 = cljs.core.next(seq__5070_5093__$1);
          var G__5104 = null;
          var G__5105 = 0;
          var G__5106 = 0;
          seq__5070_5080 = G__5103;
          chunk__5071_5081 = G__5104;
          count__5072_5082 = G__5105;
          i__5073_5083 = G__5106;
          continue;
        }
      } else {
      }
    }
    break;
  }
  return obj;
};
cljs.core.List = function(meta, first, rest, count, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.count = count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 65937646;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.List.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.List.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.List.prototype.indexOf = function() {
  var G__5107 = null;
  var G__5107__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__5107__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__5107 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__5107__1.call(this, x);
      case 2:
        return G__5107__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__5107.cljs$core$IFn$_invoke$arity$1 = G__5107__1;
  G__5107.cljs$core$IFn$_invoke$arity$2 = G__5107__2;
  return G__5107;
}();
cljs.core.List.prototype.lastIndexOf = function() {
  var G__5108 = null;
  var G__5108__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, self__.count);
  };
  var G__5108__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__5108 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__5108__1.call(this, x);
      case 2:
        return G__5108__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__5108.cljs$core$IFn$_invoke$arity$1 = G__5108__1;
  G__5108.cljs$core$IFn$_invoke$arity$2 = G__5108__2;
  return G__5108;
}();
cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.List(self__.meta, self__.first, self__.rest, self__.count, self__.__hash);
};
cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.count === 1) {
    return null;
  } else {
    return self__.rest;
  }
};
cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.count;
};
cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
};
cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4030__auto__ = self__.__hash;
  if (!(h__4030__auto__ == null)) {
    return h__4030__auto__;
  } else {
    var h__4030__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4030__auto____$1;
    return h__4030__auto____$1;
  }
};
cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.count === 1) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.rest;
  }
};
cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(meta__$1, self__.first, self__.rest, self__.count, self__.__hash);
};
cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(self__.meta, o, coll__$1, self__.count + 1, null);
};
cljs.core.List.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "first", "first", 996428481, null), new cljs.core.Symbol(null, "rest", "rest", 398835108, null), new cljs.core.Symbol(null, "count", "count", -514511684, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.List.cljs$lang$type = true;
cljs.core.List.cljs$lang$ctorStr = "cljs.core/List";
cljs.core.List.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/List");
};
cljs.core.__GT_List = function cljs$core$__GT_List(meta, first, rest, count, __hash) {
  return new cljs.core.List(meta, first, rest, count, __hash);
};
cljs.core.list_QMARK_ = function cljs$core$list_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 33554432 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IList$) {
      return true;
    } else {
      if (!x.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IList, x);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IList, x);
  }
};
var G__5110_5113 = cljs.core.List.prototype;
var G__5111_5114 = cljs.core.ITER_SYMBOL;
var G__5112_5115 = function(G__5110_5113, G__5111_5114) {
  return function() {
    var this__4438__auto__ = this;
    return cljs.core.es6_iterator(this__4438__auto__);
  };
}(G__5110_5113, G__5111_5114);
goog.object.set(G__5110_5113, G__5111_5114, G__5112_5115);
cljs.core.EmptyList = function(meta) {
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition0$ = 65937614;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.EmptyList.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.EmptyList.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.EmptyList.prototype.indexOf = function() {
  var G__5116 = null;
  var G__5116__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__5116__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__5116 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__5116__1.call(this, x);
      case 2:
        return G__5116__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__5116.cljs$core$IFn$_invoke$arity$1 = G__5116__1;
  G__5116.cljs$core$IFn$_invoke$arity$2 = G__5116__2;
  return G__5116;
}();
cljs.core.EmptyList.prototype.lastIndexOf = function() {
  var G__5117 = null;
  var G__5117__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__5117__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__5117 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__5117__1.call(this, x);
      case 2:
        return G__5117__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__5117.cljs$core$IFn$_invoke$arity$1 = G__5117__1;
  G__5117.cljs$core$IFn$_invoke$arity$2 = G__5117__2;
  return G__5117;
}();
cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.EmptyList(self__.meta);
};
cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return 0;
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  throw new Error("Can't pop empty list");
};
cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.empty_ordered_hash;
};
cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.list_QMARK_(other) || cljs.core.sequential_QMARK_(other)) {
    return cljs.core.seq(other) == null;
  } else {
    return false;
  }
};
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return null;
};
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.EmptyList(meta__$1);
};
cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.List(self__.meta, o, null, 1, null);
};
cljs.core.EmptyList.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null)], null);
};
cljs.core.EmptyList.cljs$lang$type = true;
cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList";
cljs.core.EmptyList.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/EmptyList");
};
cljs.core.__GT_EmptyList = function cljs$core$__GT_EmptyList(meta) {
  return new cljs.core.EmptyList(meta);
};
cljs.core.List.EMPTY = new cljs.core.EmptyList(null);
var G__5118_5121 = cljs.core.EmptyList.prototype;
var G__5119_5122 = cljs.core.ITER_SYMBOL;
var G__5120_5123 = function(G__5118_5121, G__5119_5122) {
  return function() {
    var this__4438__auto__ = this;
    return cljs.core.es6_iterator(this__4438__auto__);
  };
}(G__5118_5121, G__5119_5122);
goog.object.set(G__5118_5121, G__5119_5122, G__5120_5123);
cljs.core.reversible_QMARK_ = function cljs$core$reversible_QMARK_(coll) {
  if (!(coll == null)) {
    if (coll.cljs$lang$protocol_mask$partition0$ & 134217728 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReversible$) {
      return true;
    } else {
      if (!coll.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible, coll);
      } else {
        return false;
      }
    }
  } else {
    return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible, coll);
  }
};
cljs.core.rseq = function cljs$core$rseq(rev) {
  return cljs.core._rseq(rev);
};
cljs.core.reverse = function cljs$core$reverse(coll) {
  if (cljs.core.reversible_QMARK_(coll)) {
    var or__3922__auto__ = cljs.core.rseq(coll);
    if (or__3922__auto__) {
      return or__3922__auto__;
    } else {
      return cljs.core.List.EMPTY;
    }
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj, cljs.core.List.EMPTY, coll);
  }
};
cljs.core.list = function cljs$core$list(var_args) {
  var args__4502__auto__ = [];
  var len__4499__auto___5126 = arguments.length;
  var i__4500__auto___5127 = 0;
  while (true) {
    if (i__4500__auto___5127 < len__4499__auto___5126) {
      args__4502__auto__.push(arguments[i__4500__auto___5127]);
      var G__5128 = i__4500__auto___5127 + 1;
      i__4500__auto___5127 = G__5128;
      continue;
    } else {
    }
    break;
  }
  var argseq__4503__auto__ = 0 < args__4502__auto__.length ? new cljs.core.IndexedSeq(args__4502__auto__.slice(0), 0, null) : null;
  return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__4503__auto__);
};
cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = function(xs) {
  var arr = xs instanceof cljs.core.IndexedSeq && xs.i === 0 ? xs.arr : function() {
    var arr = [];
    var xs__$1 = xs;
    while (true) {
      if (!(xs__$1 == null)) {
        arr.push(xs__$1.cljs$core$ISeq$_first$arity$1(null));
        var G__5129 = xs__$1.cljs$core$INext$_next$arity$1(null);
        xs__$1 = G__5129;
        continue;
      } else {
        return arr;
      }
      break;
    }
  }();
  var i = arr.length;
  var r = cljs.core.List.EMPTY;
  while (true) {
    if (i > 0) {
      var G__5130 = i - 1;
      var G__5131 = r.cljs$core$ICollection$_conj$arity$2(null, arr[i - 1]);
      i = G__5130;
      r = G__5131;
      continue;
    } else {
      return r;
    }
    break;
  }
};
cljs.core.list.cljs$lang$maxFixedArity = 0;
cljs.core.list.cljs$lang$applyTo = function(seq5125) {
  var self__4487__auto__ = this;
  return self__4487__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq5125));
};
cljs.core.Cons = function(meta, first, rest, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 65929452;
  this.cljs$lang$protocol_mask$partition1$ = 8192;
};
cljs.core.Cons.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.Cons.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Cons.prototype.indexOf = function() {
  var G__5132 = null;
  var G__5132__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__5132__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__5132 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__5132__1.call(this, x);
      case 2:
        return G__5132__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__5132.cljs$core$IFn$_invoke$arity$1 = G__5132__1;
  G__5132.cljs$core$IFn$_invoke$arity$2 = G__5132__2;
  return G__5132;
}();
cljs.core.Cons.prototype.lastIndexOf = function() {
  var G__5133 = null;
  var G__5133__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__5133__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__5133 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__5133__1.call(this, x);
      case 2:
        return G__5133__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__5133.cljs$core$IFn$_invoke$arity$1 = G__5133__1;
  G__5133.cljs$core$IFn$_invoke$arity$2 = G__5133__2;
  return G__5133;
}();
cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Cons(self__.meta, self__.first, self__.rest, self__.__hash);
};
cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.rest == null) {
    return null;
  } else {
    return cljs.core.seq(self__.rest);
  }
};
cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4030__auto__ = self__.__hash;
  if (!(h__4030__auto__ == null)) {
    return h__4030__auto__;
  } else {
    var h__4030__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4030__auto____$1;
    return h__4030__auto____$1;
  }
};
cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.first;
};
cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.rest == null) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.rest;
  }
};
cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.Cons(meta__$1, self__.first, self__.rest, self__.__hash);
};
cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.Cons(null, o, coll__$1, null);
};
cljs.core.Cons.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "first", "first", 996428481, null), new cljs.core.Symbol(null, "rest", "rest", 398835108, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.Cons.cljs$lang$type = true;
cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons";
cljs.core.Cons.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/Cons");
};
cljs.core.__GT_Cons = function cljs$core$__GT_Cons(meta, first, rest, __hash) {
  return new cljs.core.Cons(meta, first, rest, __hash);
};
var G__5134_5137 = cljs.core.Cons.prototype;
var G__5135_5138 = cljs.core.ITER_SYMBOL;
var G__5136_5139 = function(G__5134_5137, G__5135_5138) {
  return function() {
    var this__4438__auto__ = this;
    return cljs.core.es6_iterator(this__4438__auto__);
  };
}(G__5134_5137, G__5135_5138);
goog.object.set(G__5134_5137, G__5135_5138, G__5136_5139);
cljs.core.cons = function cljs$core$cons(x, coll) {
  if (function() {
    var or__3922__auto__ = coll == null;
    if (or__3922__auto__) {
      return or__3922__auto__;
    } else {
      if (!(coll == null)) {
        if (coll.cljs$lang$protocol_mask$partition0$ & 64 || cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$) {
          return true;
        } else {
          return false;
        }
      } else {
        return false;
      }
    }
  }()) {
    return new cljs.core.Cons(null, x, coll, null);
  } else {
    return new cljs.core.Cons(null, x, cljs.core.seq(coll), null);
  }
};
cljs.core.hash_keyword = function cljs$core$hash_keyword(k) {
  return cljs.core.hash_symbol(k) + 2654435769 | 0;
};
cljs.core.compare_keywords = function cljs$core$compare_keywords(a, b) {
  if (a.fqn === b.fqn) {
    return 0;
  } else {
    if (cljs.core.truth_(function() {
      var and__3911__auto__ = cljs.core.not(a.ns);
      if (and__3911__auto__) {
        return b.ns;
      } else {
        return and__3911__auto__;
      }
    }())) {
      return -1;
    } else {
      if (cljs.core.truth_(a.ns)) {
        if (cljs.core.not(b.ns)) {
          return 1;
        } else {
          var nsc = function() {
            var G__5142 = a.ns;
            var G__5143 = b.ns;
            return goog.array.defaultCompare(G__5142, G__5143);
          }();
          if (0 === nsc) {
            var G__5144 = a.name;
            var G__5145 = b.name;
            return goog.array.defaultCompare(G__5144, G__5145);
          } else {
            return nsc;
          }
        }
      } else {
        var G__5146 = a.name;
        var G__5147 = b.name;
        return goog.array.defaultCompare(G__5146, G__5147);
      }
    }
  }
};
cljs.core.Keyword = function(ns, name, fqn, _hash) {
  this.ns = ns;
  this.name = name;
  this.fqn = fqn;
  this._hash = _hash;
  this.cljs$lang$protocol_mask$partition0$ = 2153775105;
  this.cljs$lang$protocol_mask$partition1$ = 4096;
};
cljs.core.Keyword.prototype.toString = function() {
  var self__ = this;
  var _ = this;
  return [":", cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join("");
};
cljs.core.Keyword.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(_, other) {
  var self__ = this;
  var ___$1 = this;
  if (other instanceof cljs.core.Keyword) {
    return self__.fqn === other.fqn;
  } else {
    return false;
  }
};
cljs.core.Keyword.prototype.call = function() {
  var G__5149 = null;
  var G__5149__2 = function(self__, coll) {
    var self__ = this;
    var self____$1 = this;
    var kw = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, kw);
  };
  var G__5149__3 = function(self__, coll, not_found) {
    var self__ = this;
    var self____$1 = this;
    var kw = self____$1;
    return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, kw, not_found);
  };
  G__5149 = function(self__, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5149__2.call(this, self__, coll);
      case 3:
        return G__5149__3.call(this, self__, coll, not_found);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__5149.cljs$core$IFn$_invoke$arity$2 = G__5149__2;
  G__5149.cljs$core$IFn$_invoke$arity$3 = G__5149__3;
  return G__5149;
}();
cljs.core.Keyword.prototype.apply = function(self__, args5148) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args5148)));
};
cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  var self__ = this;
  var kw = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll, kw);
};
cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = function(coll, not_found) {
  var self__ = this;
  var kw = this;
  return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll, kw, not_found);
};
cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  var h__4030__auto__ = self__._hash;
  if (!(h__4030__auto__ == null)) {
    return h__4030__auto__;
  } else {
    var h__4030__auto____$1 = cljs.core.hash_keyword(this$__$1);
    self__._hash = h__4030__auto____$1;
    return h__4030__auto____$1;
  }
};
cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.name;
};
cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.ns;
};
cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = function(o, writer, _) {
  var self__ = this;
  var o__$1 = this;
  return cljs.core._write(writer, [":", cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join(""));
};
cljs.core.Keyword.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "ns", "ns", 2082130287, null), new cljs.core.Symbol(null, "name", "name", -810760592, null), new cljs.core.Symbol(null, "fqn", "fqn", -1749334463, null), cljs.core.with_meta(new cljs.core.Symbol(null, "_hash", "_hash", -2130838312, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.Keyword.cljs$lang$type = true;
cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword";
cljs.core.Keyword.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/Keyword");
};
cljs.core.__GT_Keyword = function cljs$core$__GT_Keyword(ns, name, fqn, _hash) {
  return new cljs.core.Keyword(ns, name, fqn, _hash);
};
cljs.core.keyword_QMARK_ = function cljs$core$keyword_QMARK_(x) {
  return x instanceof cljs.core.Keyword;
};
cljs.core.keyword_identical_QMARK_ = function cljs$core$keyword_identical_QMARK_(x, y) {
  if (x === y) {
    return true;
  } else {
    if (x instanceof cljs.core.Keyword && y instanceof cljs.core.Keyword) {
      return x.fqn === y.fqn;
    } else {
      return false;
    }
  }
};
cljs.core.symbol_identical_QMARK_ = function cljs$core$symbol_identical_QMARK_(x, y) {
  if (x === y) {
    return true;
  } else {
    if (x instanceof cljs.core.Symbol && y instanceof cljs.core.Symbol) {
      return x.str === y.str;
    } else {
      return false;
    }
  }
};
cljs.core.namespace = function cljs$core$namespace(x) {
  if (!(x == null) ? x.cljs$lang$protocol_mask$partition1$ & 4096 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$INamed$ ? true : false : false) {
    return x.cljs$core$INamed$_namespace$arity$1(null);
  } else {
    throw new Error(["Doesn't support namespace: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(""));
  }
};
cljs.core.ident_QMARK_ = function cljs$core$ident_QMARK_(x) {
  return x instanceof cljs.core.Keyword || x instanceof cljs.core.Symbol;
};
cljs.core.simple_ident_QMARK_ = function cljs$core$simple_ident_QMARK_(x) {
  return cljs.core.ident_QMARK_(x) && cljs.core.namespace(x) == null;
};
cljs.core.qualified_ident_QMARK_ = function cljs$core$qualified_ident_QMARK_(x) {
  return cljs.core.boolean$(function() {
    var and__3911__auto__ = cljs.core.ident_QMARK_(x);
    if (and__3911__auto__) {
      var and__3911__auto____$1 = cljs.core.namespace(x);
      if (cljs.core.truth_(and__3911__auto____$1)) {
        return true;
      } else {
        return and__3911__auto____$1;
      }
    } else {
      return and__3911__auto__;
    }
  }());
};
cljs.core.simple_symbol_QMARK_ = function cljs$core$simple_symbol_QMARK_(x) {
  return x instanceof cljs.core.Symbol && cljs.core.namespace(x) == null;
};
cljs.core.qualified_symbol_QMARK_ = function cljs$core$qualified_symbol_QMARK_(x) {
  return cljs.core.boolean$(function() {
    var and__3911__auto__ = x instanceof cljs.core.Symbol;
    if (and__3911__auto__) {
      var and__3911__auto____$1 = cljs.core.namespace(x);
      if (cljs.core.truth_(and__3911__auto____$1)) {
        return true;
      } else {
        return and__3911__auto____$1;
      }
    } else {
      return and__3911__auto__;
    }
  }());
};
cljs.core.simple_keyword_QMARK_ = function cljs$core$simple_keyword_QMARK_(x) {
  return x instanceof cljs.core.Keyword && cljs.core.namespace(x) == null;
};
cljs.core.qualified_keyword_QMARK_ = function cljs$core$qualified_keyword_QMARK_(x) {
  return cljs.core.boolean$(function() {
    var and__3911__auto__ = x instanceof cljs.core.Keyword;
    if (and__3911__auto__) {
      var and__3911__auto____$1 = cljs.core.namespace(x);
      if (cljs.core.truth_(and__3911__auto____$1)) {
        return true;
      } else {
        return and__3911__auto____$1;
      }
    } else {
      return and__3911__auto__;
    }
  }());
};
cljs.core.keyword = function cljs$core$keyword(var_args) {
  var G__5152 = arguments.length;
  switch(G__5152) {
    case 1:
      return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = function(name) {
  if (name instanceof cljs.core.Keyword) {
    return name;
  } else {
    if (name instanceof cljs.core.Symbol) {
      return new cljs.core.Keyword(cljs.core.namespace(name), cljs.core.name(name), name.str, null);
    } else {
      if (typeof name === "string") {
        var parts = name.split("/");
        if (parts.length === 2) {
          return new cljs.core.Keyword(parts[0], parts[1], name, null);
        } else {
          return new cljs.core.Keyword(null, parts[0], name, null);
        }
      } else {
        return null;
      }
    }
  }
};
cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = function(ns, name) {
  var ns__$1 = ns instanceof cljs.core.Keyword ? cljs.core.name(ns) : ns instanceof cljs.core.Symbol ? cljs.core.name(ns) : ns;
  var name__$1 = name instanceof cljs.core.Keyword ? cljs.core.name(name) : name instanceof cljs.core.Symbol ? cljs.core.name(name) : name;
  return new cljs.core.Keyword(ns__$1, name__$1, [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.truth_(ns__$1) ? [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns__$1), "/"].join("") : null), cljs.core.str.cljs$core$IFn$_invoke$arity$1(name__$1)].join(""), null);
};
cljs.core.keyword.cljs$lang$maxFixedArity = 2;
cljs.core.LazySeq = function(meta, fn, s, __hash) {
  this.meta = meta;
  this.fn = fn;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374988;
  this.cljs$lang$protocol_mask$partition1$ = 1;
};
cljs.core.LazySeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.LazySeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.LazySeq.prototype.sval = function() {
  var self__ = this;
  var coll = this;
  if (self__.fn == null) {
    return self__.s;
  } else {
    self__.s = self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null);
    self__.fn = null;
    return self__.s;
  }
};
cljs.core.LazySeq.prototype.indexOf = function() {
  var G__5154 = null;
  var G__5154__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__5154__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__5154 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__5154__1.call(this, x);
      case 2:
        return G__5154__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__5154.cljs$core$IFn$_invoke$arity$1 = G__5154__1;
  G__5154.cljs$core$IFn$_invoke$arity$2 = G__5154__2;
  return G__5154;
}();
cljs.core.LazySeq.prototype.lastIndexOf = function() {
  var G__5155 = null;
  var G__5155__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__5155__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__5155 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__5155__1.call(this, x);
      case 2:
        return G__5155__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__5155.cljs$core$IFn$_invoke$arity$1 = G__5155__1;
  G__5155.cljs$core$IFn$_invoke$arity$2 = G__5155__2;
  return G__5155;
}();
cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  coll__$1.cljs$core$ISeqable$_seq$arity$1(null);
  if (self__.s == null) {
    return null;
  } else {
    return cljs.core.next(self__.s);
  }
};
cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4030__auto__ = self__.__hash;
  if (!(h__4030__auto__ == null)) {
    return h__4030__auto__;
  } else {
    var h__4030__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4030__auto____$1;
    return h__4030__auto____$1;
  }
};
cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.LazySeq.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.not(self__.fn);
};
cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  coll__$1.cljs$core$ISeqable$_seq$arity$1(null);
  if (self__.s == null) {
    return null;
  } else {
    return cljs.core.first(self__.s);
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  coll__$1.cljs$core$ISeqable$_seq$arity$1(null);
  if (!(self__.s == null)) {
    return cljs.core.rest(self__.s);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  coll__$1.sval();
  if (self__.s == null) {
    return null;
  } else {
    var ls = self__.s;
    while (true) {
      if (ls instanceof cljs.core.LazySeq) {
        var G__5156 = ls.sval();
        ls = G__5156;
        continue;
      } else {
        self__.s = ls;
        return cljs.core.seq(self__.s);
      }
      break;
    }
  }
};
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.LazySeq(meta__$1, function(coll__$1) {
    return function() {
      return coll__$1.cljs$core$ISeqable$_seq$arity$1(null);
    };
  }(coll__$1), null, self__.__hash);
};
cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.LazySeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), cljs.core.with_meta(new cljs.core.Symbol(null, "fn", "fn", 465265323, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", 
  "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.LazySeq.cljs$lang$type = true;
cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq";
cljs.core.LazySeq.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/LazySeq");
};
cljs.core.__GT_LazySeq = function cljs$core$__GT_LazySeq(meta, fn, s, __hash) {
  return new cljs.core.LazySeq(meta, fn, s, __hash);
};
var G__5157_5160 = cljs.core.LazySeq.prototype;
var G__5158_5161 = cljs.core.ITER_SYMBOL;
var G__5159_5162 = function(G__5157_5160, G__5158_5161) {
  return function() {
    var this__4438__auto__ = this;
    return cljs.core.es6_iterator(this__4438__auto__);
  };
}(G__5157_5160, G__5158_5161);
goog.object.set(G__5157_5160, G__5158_5161, G__5159_5162);
cljs.core.ChunkBuffer = function(buf, end) {
  this.buf = buf;
  this.end = end;
  this.cljs$lang$protocol_mask$partition0$ = 2;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ChunkBuffer.prototype.add = function(o) {
  var self__ = this;
  var _ = this;
  self__.buf[self__.end] = o;
  return self__.end = self__.end + 1;
};
cljs.core.ChunkBuffer.prototype.chunk = function() {
  var self__ = this;
  var _ = this;
  var ret = new cljs.core.ArrayChunk(self__.buf, 0, self__.end);
  self__.buf = null;
  return ret;
};
cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.end;
};
cljs.core.ChunkBuffer.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "buf", "buf", 1426618187, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "end", "end", 1372345569, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ChunkBuffer.cljs$lang$type = true;
cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer";
cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/ChunkBuffer");
};
cljs.core.__GT_ChunkBuffer = function cljs$core$__GT_ChunkBuffer(buf, end) {
  return new cljs.core.ChunkBuffer(buf, end);
};
cljs.core.chunk_buffer = function cljs$core$chunk_buffer(capacity) {
  return new cljs.core.ChunkBuffer(new Array(capacity), 0);
};
cljs.core.ArrayChunk = function(arr, off, end) {
  this.arr = arr;
  this.off = off;
  this.end = end;
  this.cljs$lang$protocol_mask$partition0$ = 524306;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.end - self__.off;
};
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, i) {
  var self__ = this;
  var coll__$1 = this;
  return self__.arr[self__.off + i];
};
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, i, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (i >= 0 && i < self__.end - self__.off) {
    return self__.arr[self__.off + i];
  } else {
    return not_found;
  }
};
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off === self__.end) {
    throw new Error("-drop-first of empty chunk");
  } else {
    return new cljs.core.ArrayChunk(self__.arr, self__.off + 1, self__.end);
  }
};
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, self__.arr[self__.off], self__.off + 1);
};
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr, f, start, self__.off);
};
cljs.core.ArrayChunk.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "off", "off", -2047994980, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null)], null);
};
cljs.core.ArrayChunk.cljs$lang$type = true;
cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk";
cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/ArrayChunk");
};
cljs.core.__GT_ArrayChunk = function cljs$core$__GT_ArrayChunk(arr, off, end) {
  return new cljs.core.ArrayChunk(arr, off, end);
};
cljs.core.array_chunk = function cljs$core$array_chunk(var_args) {
  var G__5164 = arguments.length;
  switch(G__5164) {
    case 1:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = function(arr) {
  return new cljs.core.ArrayChunk(arr, 0, arr.length);
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = function(arr, off) {
  return new cljs.core.ArrayChunk(arr, off, arr.length);
};
cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = function(arr, off, end) {
  return new cljs.core.ArrayChunk(arr, off, end);
};
cljs.core.array_chunk.cljs$lang$maxFixedArity = 3;
cljs.core.ChunkedCons = function(chunk, more, meta, __hash) {
  this.chunk = chunk;
  this.more = more;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 31850732;
  this.cljs$lang$protocol_mask$partition1$ = 1536;
};
cljs.core.ChunkedCons.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ChunkedCons.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ChunkedCons.prototype.indexOf = function() {
  var G__5166 = null;
  var G__5166__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__5166__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__5166 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__5166__1.call(this, x);
      case 2:
        return G__5166__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__5166.cljs$core$IFn$_invoke$arity$1 = G__5166__1;
  G__5166.cljs$core$IFn$_invoke$arity$2 = G__5166__2;
  return G__5166;
}();
cljs.core.ChunkedCons.prototype.lastIndexOf = function() {
  var G__5167 = null;
  var G__5167__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__5167__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__5167 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__5167__1.call(this, x);
      case 2:
        return G__5167__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__5167.cljs$core$IFn$_invoke$arity$1 = G__5167__1;
  G__5167.cljs$core$IFn$_invoke$arity$2 = G__5167__2;
  return G__5167;
}();
cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core._count(self__.chunk) > 1) {
    return new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk), self__.more, self__.meta, null);
  } else {
    var more__$1 = cljs.core._seq(self__.more);
    if (more__$1 == null) {
      return null;
    } else {
      return more__$1;
    }
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4030__auto__ = self__.__hash;
  if (!(h__4030__auto__ == null)) {
    return h__4030__auto__;
  } else {
    var h__4030__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4030__auto____$1;
    return h__4030__auto____$1;
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk, 0);
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core._count(self__.chunk) > 1) {
    return new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk), self__.more, self__.meta, null);
  } else {
    if (self__.more == null) {
      return cljs.core.List.EMPTY;
    } else {
      return self__.more;
    }
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.chunk;
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.more == null) {
    return cljs.core.List.EMPTY;
  } else {
    return self__.more;
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, m) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ChunkedCons(self__.chunk, self__.more, m, self__.__hash);
};
cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = function(this$, o) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.cons(o, this$__$1);
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.more == null) {
    return null;
  } else {
    return self__.more;
  }
};
cljs.core.ChunkedCons.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "chunk", "chunk", 449371907, null), new cljs.core.Symbol(null, "more", "more", -418290273, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ChunkedCons.cljs$lang$type = true;
cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons";
cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/ChunkedCons");
};
cljs.core.__GT_ChunkedCons = function cljs$core$__GT_ChunkedCons(chunk, more, meta, __hash) {
  return new cljs.core.ChunkedCons(chunk, more, meta, __hash);
};
var G__5168_5171 = cljs.core.ChunkedCons.prototype;
var G__5169_5172 = cljs.core.ITER_SYMBOL;
var G__5170_5173 = function(G__5168_5171, G__5169_5172) {
  return function() {
    var this__4438__auto__ = this;
    return cljs.core.es6_iterator(this__4438__auto__);
  };
}(G__5168_5171, G__5169_5172);
goog.object.set(G__5168_5171, G__5169_5172, G__5170_5173);
cljs.core.chunk_cons = function cljs$core$chunk_cons(chunk, rest) {
  if (cljs.core._count(chunk) === 0) {
    return rest;
  } else {
    return new cljs.core.ChunkedCons(chunk, rest, null, null);
  }
};
cljs.core.chunk_append = function cljs$core$chunk_append(b, x) {
  return b.add(x);
};
cljs.core.chunk = function cljs$core$chunk(b) {
  return b.chunk();
};
cljs.core.chunk_first = function cljs$core$chunk_first(s) {
  return cljs.core._chunked_first(s);
};
cljs.core.chunk_rest = function cljs$core$chunk_rest(s) {
  return cljs.core._chunked_rest(s);
};
cljs.core.chunk_next = function cljs$core$chunk_next(s) {
  if (!(s == null) ? s.cljs$lang$protocol_mask$partition1$ & 1024 || cljs.core.PROTOCOL_SENTINEL === s.cljs$core$IChunkedNext$ ? true : false : false) {
    return cljs.core._chunked_next(s);
  } else {
    return cljs.core.seq(cljs.core._chunked_rest(s));
  }
};
cljs.core.to_array = function cljs$core$to_array(s) {
  var ary = [];
  var s__$1 = cljs.core.seq(s);
  while (true) {
    if (!(s__$1 == null)) {
      ary.push(cljs.core.first(s__$1));
      var G__5175 = cljs.core.next(s__$1);
      s__$1 = G__5175;
      continue;
    } else {
      return ary;
    }
    break;
  }
};
cljs.core.to_array_2d = function cljs$core$to_array_2d(coll) {
  var ret = new Array(cljs.core.count(coll));
  var i_5176 = 0;
  var xs_5177 = cljs.core.seq(coll);
  while (true) {
    if (xs_5177 == null) {
    } else {
      ret[i_5176] = cljs.core.to_array(cljs.core.first(xs_5177));
      var G__5178 = i_5176 + 1;
      var G__5179 = cljs.core.next(xs_5177);
      i_5176 = G__5178;
      xs_5177 = G__5179;
      continue;
    }
    break;
  }
  return ret;
};
cljs.core.int_array = function cljs$core$int_array(var_args) {
  var G__5181 = arguments.length;
  switch(G__5181) {
    case 1:
      return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__5183 = i + 1;
        var G__5184 = cljs.core.next(s__$1);
        i = G__5183;
        s__$1 = G__5184;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__4376__auto___5185 = size;
    var i_5186 = 0;
    while (true) {
      if (i_5186 < n__4376__auto___5185) {
        a[i_5186] = init_val_or_seq;
        var G__5187 = i_5186 + 1;
        i_5186 = G__5187;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.int_array.cljs$lang$maxFixedArity = 2;
cljs.core.long_array = function cljs$core$long_array(var_args) {
  var G__5189 = arguments.length;
  switch(G__5189) {
    case 1:
      return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__5191 = i + 1;
        var G__5192 = cljs.core.next(s__$1);
        i = G__5191;
        s__$1 = G__5192;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__4376__auto___5193 = size;
    var i_5194 = 0;
    while (true) {
      if (i_5194 < n__4376__auto___5193) {
        a[i_5194] = init_val_or_seq;
        var G__5195 = i_5194 + 1;
        i_5194 = G__5195;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.long_array.cljs$lang$maxFixedArity = 2;
cljs.core.double_array = function cljs$core$double_array(var_args) {
  var G__5197 = arguments.length;
  switch(G__5197) {
    case 1:
      return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__5199 = i + 1;
        var G__5200 = cljs.core.next(s__$1);
        i = G__5199;
        s__$1 = G__5200;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__4376__auto___5201 = size;
    var i_5202 = 0;
    while (true) {
      if (i_5202 < n__4376__auto___5201) {
        a[i_5202] = init_val_or_seq;
        var G__5203 = i_5202 + 1;
        i_5202 = G__5203;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.double_array.cljs$lang$maxFixedArity = 2;
cljs.core.object_array = function cljs$core$object_array(var_args) {
  var G__5205 = arguments.length;
  switch(G__5205) {
    case 1:
      return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = function(size_or_seq) {
  if (typeof size_or_seq === "number") {
    return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq, null);
  } else {
    return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
  }
};
cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = function(size, init_val_or_seq) {
  var a = new Array(size);
  if (cljs.core.seq_QMARK_(init_val_or_seq)) {
    var s = cljs.core.seq(init_val_or_seq);
    var i = 0;
    var s__$1 = s;
    while (true) {
      if (s__$1 && i < size) {
        a[i] = cljs.core.first(s__$1);
        var G__5207 = i + 1;
        var G__5208 = cljs.core.next(s__$1);
        i = G__5207;
        s__$1 = G__5208;
        continue;
      } else {
        return a;
      }
      break;
    }
  } else {
    var n__4376__auto___5209 = size;
    var i_5210 = 0;
    while (true) {
      if (i_5210 < n__4376__auto___5209) {
        a[i_5210] = init_val_or_seq;
        var G__5211 = i_5210 + 1;
        i_5210 = G__5211;
        continue;
      } else {
      }
      break;
    }
    return a;
  }
};
cljs.core.object_array.cljs$lang$maxFixedArity = 2;
cljs.core.bounded_count = function cljs$core$bounded_count(n, coll) {
  if (cljs.core.counted_QMARK_(coll)) {
    return cljs.core.count(coll);
  } else {
    var i = 0;
    var s = cljs.core.seq(coll);
    while (true) {
      if (!(s == null) && i < n) {
        var G__5212 = i + 1;
        var G__5213 = cljs.core.next(s);
        i = G__5212;
        s = G__5213;
        continue;
      } else {
        return i;
      }
      break;
    }
  }
};
cljs.core.spread = function cljs$core$spread(arglist) {
  if (arglist == null) {
    return null;
  } else {
    var n = cljs.core.next(arglist);
    if (n == null) {
      return cljs.core.seq(cljs.core.first(arglist));
    } else {
      return cljs.core.cons(cljs.core.first(arglist), cljs.core.spread.cljs$core$IFn$_invoke$arity$1 ? cljs.core.spread.cljs$core$IFn$_invoke$arity$1(n) : cljs.core.spread.call(null, n));
    }
  }
};
cljs.core.concat = function cljs$core$concat(var_args) {
  var G__5218 = arguments.length;
  switch(G__5218) {
    case 0:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5220 = arguments.length;
      var i__4500__auto___5221 = 0;
      while (true) {
        if (i__4500__auto___5221 < len__4499__auto___5220) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5221]);
          var G__5222 = i__4500__auto___5221 + 1;
          i__4500__auto___5221 = G__5222;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = function() {
  return new cljs.core.LazySeq(null, function() {
    return null;
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.LazySeq(null, function() {
    return x;
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return new cljs.core.LazySeq(null, function() {
    var s = cljs.core.seq(x);
    if (s) {
      if (cljs.core.chunked_seq_QMARK_(s)) {
        return cljs.core.chunk_cons(cljs.core.chunk_first(s), cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s), y));
      } else {
        return cljs.core.cons(cljs.core.first(s), cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s), y));
      }
    } else {
      return y;
    }
  }, null, null);
};
cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = function(x, y, zs) {
  var cat = function cljs$core$cat(xys, zs__$1) {
    return new cljs.core.LazySeq(null, function() {
      var xys__$1 = cljs.core.seq(xys);
      if (xys__$1) {
        if (cljs.core.chunked_seq_QMARK_(xys__$1)) {
          return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1), cljs$core$cat(cljs.core.chunk_rest(xys__$1), zs__$1));
        } else {
          return cljs.core.cons(cljs.core.first(xys__$1), cljs$core$cat(cljs.core.rest(xys__$1), zs__$1));
        }
      } else {
        if (cljs.core.truth_(zs__$1)) {
          return cljs$core$cat(cljs.core.first(zs__$1), cljs.core.next(zs__$1));
        } else {
          return null;
        }
      }
    }, null, null);
  };
  return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x, y), zs);
};
cljs.core.concat.cljs$lang$applyTo = function(seq5215) {
  var G__5216 = cljs.core.first(seq5215);
  var seq5215__$1 = cljs.core.next(seq5215);
  var G__5217 = cljs.core.first(seq5215__$1);
  var seq5215__$2 = cljs.core.next(seq5215__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5216, G__5217, seq5215__$2);
};
cljs.core.concat.cljs$lang$maxFixedArity = 2;
cljs.core.list_STAR_ = function cljs$core$list_STAR_(var_args) {
  var G__5229 = arguments.length;
  switch(G__5229) {
    case 1:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5231 = arguments.length;
      var i__4500__auto___5232 = 0;
      while (true) {
        if (i__4500__auto___5232 < len__4499__auto___5231) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5232]);
          var G__5233 = i__4500__auto___5232 + 1;
          i__4500__auto___5232 = G__5233;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(4), 0, null);
      return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__4515__auto__);
  }
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = function(args) {
  return cljs.core.seq(args);
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = function(a, args) {
  return cljs.core.cons(a, args);
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = function(a, b, args) {
  return cljs.core.cons(a, cljs.core.cons(b, args));
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = function(a, b, c, args) {
  return cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, args)));
};
cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = function(a, b, c, d, more) {
  return cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, cljs.core.cons(d, cljs.core.spread(more)))));
};
cljs.core.list_STAR_.cljs$lang$applyTo = function(seq5224) {
  var G__5225 = cljs.core.first(seq5224);
  var seq5224__$1 = cljs.core.next(seq5224);
  var G__5226 = cljs.core.first(seq5224__$1);
  var seq5224__$2 = cljs.core.next(seq5224__$1);
  var G__5227 = cljs.core.first(seq5224__$2);
  var seq5224__$3 = cljs.core.next(seq5224__$2);
  var G__5228 = cljs.core.first(seq5224__$3);
  var seq5224__$4 = cljs.core.next(seq5224__$3);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5225, G__5226, G__5227, G__5228, seq5224__$4);
};
cljs.core.list_STAR_.cljs$lang$maxFixedArity = 4;
cljs.core.transient$ = function cljs$core$transient(coll) {
  return cljs.core._as_transient(coll);
};
cljs.core.persistent_BANG_ = function cljs$core$persistent_BANG_(tcoll) {
  return cljs.core._persistent_BANG_(tcoll);
};
cljs.core.conj_BANG_ = function cljs$core$conj_BANG_(var_args) {
  var G__5238 = arguments.length;
  switch(G__5238) {
    case 0:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5240 = arguments.length;
      var i__4500__auto___5241 = 0;
      while (true) {
        if (i__4500__auto___5241 < len__4499__auto___5240) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5241]);
          var G__5242 = i__4500__auto___5241 + 1;
          i__4500__auto___5241 = G__5242;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = function(tcoll) {
  return tcoll;
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, val) {
  return cljs.core._conj_BANG_(tcoll, val);
};
cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, val, vals) {
  while (true) {
    var ntcoll = cljs.core._conj_BANG_(tcoll, val);
    if (cljs.core.truth_(vals)) {
      var G__5243 = ntcoll;
      var G__5244 = cljs.core.first(vals);
      var G__5245 = cljs.core.next(vals);
      tcoll = G__5243;
      val = G__5244;
      vals = G__5245;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.conj_BANG_.cljs$lang$applyTo = function(seq5235) {
  var G__5236 = cljs.core.first(seq5235);
  var seq5235__$1 = cljs.core.next(seq5235);
  var G__5237 = cljs.core.first(seq5235__$1);
  var seq5235__$2 = cljs.core.next(seq5235__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5236, G__5237, seq5235__$2);
};
cljs.core.conj_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.assoc_BANG_ = function cljs$core$assoc_BANG_(var_args) {
  var G__5251 = arguments.length;
  switch(G__5251) {
    case 3:
      return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5253 = arguments.length;
      var i__4500__auto___5254 = 0;
      while (true) {
        if (i__4500__auto___5254 < len__4499__auto___5253) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5254]);
          var G__5255 = i__4500__auto___5254 + 1;
          i__4500__auto___5254 = G__5255;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(3), 0, null);
      return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__4515__auto__);
  }
};
cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = function(tcoll, key, val) {
  return cljs.core._assoc_BANG_(tcoll, key, val);
};
cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, key, val, kvs) {
  while (true) {
    var ntcoll = cljs.core._assoc_BANG_(tcoll, key, val);
    if (cljs.core.truth_(kvs)) {
      var G__5256 = ntcoll;
      var G__5257 = cljs.core.first(kvs);
      var G__5258 = cljs.core.second(kvs);
      var G__5259 = cljs.core.nnext(kvs);
      tcoll = G__5256;
      key = G__5257;
      val = G__5258;
      kvs = G__5259;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.assoc_BANG_.cljs$lang$applyTo = function(seq5247) {
  var G__5248 = cljs.core.first(seq5247);
  var seq5247__$1 = cljs.core.next(seq5247);
  var G__5249 = cljs.core.first(seq5247__$1);
  var seq5247__$2 = cljs.core.next(seq5247__$1);
  var G__5250 = cljs.core.first(seq5247__$2);
  var seq5247__$3 = cljs.core.next(seq5247__$2);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5248, G__5249, G__5250, seq5247__$3);
};
cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.dissoc_BANG_ = function cljs$core$dissoc_BANG_(var_args) {
  var G__5264 = arguments.length;
  switch(G__5264) {
    case 2:
      return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5266 = arguments.length;
      var i__4500__auto___5267 = 0;
      while (true) {
        if (i__4500__auto___5267 < len__4499__auto___5266) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5267]);
          var G__5268 = i__4500__auto___5267 + 1;
          i__4500__auto___5267 = G__5268;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, key) {
  return cljs.core._dissoc_BANG_(tcoll, key);
};
cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, key, ks) {
  while (true) {
    var ntcoll = cljs.core._dissoc_BANG_(tcoll, key);
    if (cljs.core.truth_(ks)) {
      var G__5269 = ntcoll;
      var G__5270 = cljs.core.first(ks);
      var G__5271 = cljs.core.next(ks);
      tcoll = G__5269;
      key = G__5270;
      ks = G__5271;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.dissoc_BANG_.cljs$lang$applyTo = function(seq5261) {
  var G__5262 = cljs.core.first(seq5261);
  var seq5261__$1 = cljs.core.next(seq5261);
  var G__5263 = cljs.core.first(seq5261__$1);
  var seq5261__$2 = cljs.core.next(seq5261__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5262, G__5263, seq5261__$2);
};
cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.pop_BANG_ = function cljs$core$pop_BANG_(tcoll) {
  return cljs.core._pop_BANG_(tcoll);
};
cljs.core.disj_BANG_ = function cljs$core$disj_BANG_(var_args) {
  var G__5276 = arguments.length;
  switch(G__5276) {
    case 2:
      return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5278 = arguments.length;
      var i__4500__auto___5279 = 0;
      while (true) {
        if (i__4500__auto___5279 < len__4499__auto___5278) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5279]);
          var G__5280 = i__4500__auto___5279 + 1;
          i__4500__auto___5279 = G__5280;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = function(tcoll, val) {
  return cljs.core._disjoin_BANG_(tcoll, val);
};
cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(tcoll, val, vals) {
  while (true) {
    var ntcoll = cljs.core._disjoin_BANG_(tcoll, val);
    if (cljs.core.truth_(vals)) {
      var G__5281 = ntcoll;
      var G__5282 = cljs.core.first(vals);
      var G__5283 = cljs.core.next(vals);
      tcoll = G__5281;
      val = G__5282;
      vals = G__5283;
      continue;
    } else {
      return ntcoll;
    }
    break;
  }
};
cljs.core.disj_BANG_.cljs$lang$applyTo = function(seq5273) {
  var G__5274 = cljs.core.first(seq5273);
  var seq5273__$1 = cljs.core.next(seq5273);
  var G__5275 = cljs.core.first(seq5273__$1);
  var seq5273__$2 = cljs.core.next(seq5273__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5274, G__5275, seq5273__$2);
};
cljs.core.disj_BANG_.cljs$lang$maxFixedArity = 2;
cljs.core.apply_to = function cljs$core$apply_to(f, argc, args) {
  var args__$1 = cljs.core.seq(args);
  if (argc === 0) {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  } else {
    var a17 = cljs.core._first(args__$1);
    var args__$2 = cljs.core._rest(args__$1);
    if (argc === 1) {
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(a17) : f.call(null, a17);
    } else {
      var b18 = cljs.core._first(args__$2);
      var args__$3 = cljs.core._rest(args__$2);
      if (argc === 2) {
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(a17, b18) : f.call(null, a17, b18);
      } else {
        var c19 = cljs.core._first(args__$3);
        var args__$4 = cljs.core._rest(args__$3);
        if (argc === 3) {
          return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(a17, b18, c19) : f.call(null, a17, b18, c19);
        } else {
          var d20 = cljs.core._first(args__$4);
          var args__$5 = cljs.core._rest(args__$4);
          if (argc === 4) {
            return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(a17, b18, c19, d20) : f.call(null, a17, b18, c19, d20);
          } else {
            var e21 = cljs.core._first(args__$5);
            var args__$6 = cljs.core._rest(args__$5);
            if (argc === 5) {
              return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(a17, b18, c19, d20, e21) : f.call(null, a17, b18, c19, d20, e21);
            } else {
              var f22 = cljs.core._first(args__$6);
              var args__$7 = cljs.core._rest(args__$6);
              if (argc === 6) {
                return f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(a17, b18, c19, d20, e21, f22) : f.call(null, a17, b18, c19, d20, e21, f22);
              } else {
                var g23 = cljs.core._first(args__$7);
                var args__$8 = cljs.core._rest(args__$7);
                if (argc === 7) {
                  return f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(a17, b18, c19, d20, e21, f22, g23) : f.call(null, a17, b18, c19, d20, e21, f22, g23);
                } else {
                  var h24 = cljs.core._first(args__$8);
                  var args__$9 = cljs.core._rest(args__$8);
                  if (argc === 8) {
                    return f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(a17, b18, c19, d20, e21, f22, g23, h24) : f.call(null, a17, b18, c19, d20, e21, f22, g23, h24);
                  } else {
                    var i25 = cljs.core._first(args__$9);
                    var args__$10 = cljs.core._rest(args__$9);
                    if (argc === 9) {
                      return f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(a17, b18, c19, d20, e21, f22, g23, h24, i25) : f.call(null, a17, b18, c19, d20, e21, f22, g23, h24, i25);
                    } else {
                      var j26 = cljs.core._first(args__$10);
                      var args__$11 = cljs.core._rest(args__$10);
                      if (argc === 10) {
                        return f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(a17, b18, c19, d20, e21, f22, g23, h24, i25, j26) : f.call(null, a17, b18, c19, d20, e21, f22, g23, h24, i25, j26);
                      } else {
                        var k27 = cljs.core._first(args__$11);
                        var args__$12 = cljs.core._rest(args__$11);
                        if (argc === 11) {
                          return f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(a17, b18, c19, d20, e21, f22, g23, h24, i25, j26, k27) : f.call(null, a17, b18, c19, d20, e21, f22, g23, h24, i25, j26, k27);
                        } else {
                          var l28 = cljs.core._first(args__$12);
                          var args__$13 = cljs.core._rest(args__$12);
                          if (argc === 12) {
                            return f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(a17, b18, c19, d20, e21, f22, g23, h24, i25, j26, k27, l28) : f.call(null, a17, b18, c19, d20, e21, f22, g23, h24, i25, j26, k27, l28);
                          } else {
                            var m29 = cljs.core._first(args__$13);
                            var args__$14 = cljs.core._rest(args__$13);
                            if (argc === 13) {
                              return f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(a17, b18, c19, d20, e21, f22, g23, h24, i25, j26, k27, l28, m29) : f.call(null, a17, b18, c19, d20, e21, f22, g23, h24, i25, j26, k27, l28, m29);
                            } else {
                              var n30 = cljs.core._first(args__$14);
                              var args__$15 = cljs.core._rest(args__$14);
                              if (argc === 14) {
                                return f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(a17, b18, c19, d20, e21, f22, g23, h24, i25, j26, k27, l28, m29, n30) : f.call(null, a17, b18, c19, d20, e21, f22, g23, h24, i25, j26, k27, l28, m29, n30);
                              } else {
                                var o31 = cljs.core._first(args__$15);
                                var args__$16 = cljs.core._rest(args__$15);
                                if (argc === 15) {
                                  return f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(a17, b18, c19, d20, e21, f22, g23, h24, i25, j26, k27, l28, m29, n30, o31) : f.call(null, a17, b18, c19, d20, e21, f22, g23, h24, i25, j26, k27, l28, m29, n30, o31);
                                } else {
                                  var p32 = cljs.core._first(args__$16);
                                  var args__$17 = cljs.core._rest(args__$16);
                                  if (argc === 16) {
                                    return f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(a17, b18, c19, d20, e21, f22, g23, h24, i25, j26, k27, l28, m29, n30, o31, p32) : f.call(null, a17, b18, c19, d20, e21, f22, g23, h24, i25, j26, k27, l28, m29, n30, o31, p32);
                                  } else {
                                    var q33 = cljs.core._first(args__$17);
                                    var args__$18 = cljs.core._rest(args__$17);
                                    if (argc === 17) {
                                      return f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(a17, b18, c19, d20, e21, f22, g23, h24, i25, j26, k27, l28, m29, n30, o31, p32, q33) : f.call(null, a17, b18, c19, d20, e21, f22, g23, h24, i25, j26, k27, l28, m29, n30, o31, p32, q33);
                                    } else {
                                      var r34 = cljs.core._first(args__$18);
                                      var args__$19 = cljs.core._rest(args__$18);
                                      if (argc === 18) {
                                        return f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(a17, b18, c19, d20, e21, f22, g23, h24, i25, j26, k27, l28, m29, n30, o31, p32, q33, r34) : f.call(null, a17, b18, c19, d20, e21, f22, g23, h24, i25, j26, k27, l28, m29, n30, o31, p32, q33, r34);
                                      } else {
                                        var s35 = cljs.core._first(args__$19);
                                        var args__$20 = cljs.core._rest(args__$19);
                                        if (argc === 19) {
                                          return f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(a17, b18, c19, d20, e21, f22, g23, h24, i25, j26, k27, l28, m29, n30, o31, p32, q33, r34, s35) : f.call(null, a17, b18, c19, d20, e21, f22, g23, h24, i25, j26, k27, l28, m29, n30, o31, p32, q33, r34, s35);
                                        } else {
                                          var t36 = cljs.core._first(args__$20);
                                          var args__$21 = cljs.core._rest(args__$20);
                                          if (argc === 20) {
                                            return f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(a17, b18, c19, d20, e21, f22, g23, h24, i25, j26, k27, l28, m29, n30, o31, p32, q33, r34, s35, t36) : f.call(null, a17, b18, c19, d20, e21, f22, g23, h24, i25, j26, k27, l28, m29, n30, o31, p32, q33, r34, s35, t36);
                                          } else {
                                            throw new Error("Only up to 20 arguments supported on functions");
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.apply_to_simple = function cljs$core$apply_to_simple(var_args) {
  var G__5285 = arguments.length;
  switch(G__5285) {
    case 2:
      return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2 = function(f, args) {
  if (args == null) {
    if (f.cljs$core$IFn$_invoke$arity$0) {
      return f.cljs$core$IFn$_invoke$arity$0();
    } else {
      return f.call(f);
    }
  } else {
    return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(f, cljs.core._first(args), cljs.core.next(args));
  }
};
cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3 = function(f, a0, args) {
  if (args == null) {
    if (f.cljs$core$IFn$_invoke$arity$1) {
      return f.cljs$core$IFn$_invoke$arity$1(a0);
    } else {
      return f.call(f, a0);
    }
  } else {
    return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(f, a0, cljs.core._first(args), cljs.core.next(args));
  }
};
cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4 = function(f, a0, a1, args) {
  if (args == null) {
    if (f.cljs$core$IFn$_invoke$arity$2) {
      return f.cljs$core$IFn$_invoke$arity$2(a0, a1);
    } else {
      return f.call(f, a0, a1);
    }
  } else {
    return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(f, a0, a1, cljs.core._first(args), cljs.core.next(args));
  }
};
cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5 = function(f, a0, a1, a2, args) {
  if (args == null) {
    if (f.cljs$core$IFn$_invoke$arity$3) {
      return f.cljs$core$IFn$_invoke$arity$3(a0, a1, a2);
    } else {
      return f.call(f, a0, a1, a2);
    }
  } else {
    return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(f, a0, a1, a2, cljs.core._first(args), cljs.core.next(args));
  }
};
cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6 = function(f, a0, a1, a2, a3, args) {
  if (args == null) {
    if (f.cljs$core$IFn$_invoke$arity$4) {
      return f.cljs$core$IFn$_invoke$arity$4(a0, a1, a2, a3);
    } else {
      return f.call(f, a0, a1, a2, a3);
    }
  } else {
    var a4 = cljs.core._first(args);
    var next_4 = cljs.core.next(args);
    if (next_4 == null) {
      if (f.cljs$core$IFn$_invoke$arity$5) {
        return f.cljs$core$IFn$_invoke$arity$5(a0, a1, a2, a3, a4);
      } else {
        return f.call(f, a0, a1, a2, a3, a4);
      }
    } else {
      var a5 = cljs.core._first(next_4);
      var next_5 = cljs.core.next(next_4);
      if (next_5 == null) {
        if (f.cljs$core$IFn$_invoke$arity$6) {
          return f.cljs$core$IFn$_invoke$arity$6(a0, a1, a2, a3, a4, a5);
        } else {
          return f.call(f, a0, a1, a2, a3, a4, a5);
        }
      } else {
        var a6 = cljs.core._first(next_5);
        var next_6 = cljs.core.next(next_5);
        if (next_6 == null) {
          if (f.cljs$core$IFn$_invoke$arity$7) {
            return f.cljs$core$IFn$_invoke$arity$7(a0, a1, a2, a3, a4, a5, a6);
          } else {
            return f.call(f, a0, a1, a2, a3, a4, a5, a6);
          }
        } else {
          var a7 = cljs.core._first(next_6);
          var next_7 = cljs.core.next(next_6);
          if (next_7 == null) {
            if (f.cljs$core$IFn$_invoke$arity$8) {
              return f.cljs$core$IFn$_invoke$arity$8(a0, a1, a2, a3, a4, a5, a6, a7);
            } else {
              return f.call(f, a0, a1, a2, a3, a4, a5, a6, a7);
            }
          } else {
            var a8 = cljs.core._first(next_7);
            var next_8 = cljs.core.next(next_7);
            if (next_8 == null) {
              if (f.cljs$core$IFn$_invoke$arity$9) {
                return f.cljs$core$IFn$_invoke$arity$9(a0, a1, a2, a3, a4, a5, a6, a7, a8);
              } else {
                return f.call(f, a0, a1, a2, a3, a4, a5, a6, a7, a8);
              }
            } else {
              var a9 = cljs.core._first(next_8);
              var next_9 = cljs.core.next(next_8);
              if (next_9 == null) {
                if (f.cljs$core$IFn$_invoke$arity$10) {
                  return f.cljs$core$IFn$_invoke$arity$10(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
                } else {
                  return f.call(f, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
                }
              } else {
                var a10 = cljs.core._first(next_9);
                var next_10 = cljs.core.next(next_9);
                if (next_10 == null) {
                  if (f.cljs$core$IFn$_invoke$arity$11) {
                    return f.cljs$core$IFn$_invoke$arity$11(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10);
                  } else {
                    return f.call(f, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10);
                  }
                } else {
                  var a11 = cljs.core._first(next_10);
                  var next_11 = cljs.core.next(next_10);
                  if (next_11 == null) {
                    if (f.cljs$core$IFn$_invoke$arity$12) {
                      return f.cljs$core$IFn$_invoke$arity$12(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11);
                    } else {
                      return f.call(f, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11);
                    }
                  } else {
                    var a12 = cljs.core._first(next_11);
                    var next_12 = cljs.core.next(next_11);
                    if (next_12 == null) {
                      if (f.cljs$core$IFn$_invoke$arity$13) {
                        return f.cljs$core$IFn$_invoke$arity$13(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12);
                      } else {
                        return f.call(f, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12);
                      }
                    } else {
                      var a13 = cljs.core._first(next_12);
                      var next_13 = cljs.core.next(next_12);
                      if (next_13 == null) {
                        if (f.cljs$core$IFn$_invoke$arity$14) {
                          return f.cljs$core$IFn$_invoke$arity$14(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13);
                        } else {
                          return f.call(f, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13);
                        }
                      } else {
                        var a14 = cljs.core._first(next_13);
                        var next_14 = cljs.core.next(next_13);
                        if (next_14 == null) {
                          if (f.cljs$core$IFn$_invoke$arity$15) {
                            return f.cljs$core$IFn$_invoke$arity$15(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14);
                          } else {
                            return f.call(f, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14);
                          }
                        } else {
                          var a15 = cljs.core._first(next_14);
                          var next_15 = cljs.core.next(next_14);
                          if (next_15 == null) {
                            if (f.cljs$core$IFn$_invoke$arity$16) {
                              return f.cljs$core$IFn$_invoke$arity$16(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15);
                            } else {
                              return f.call(f, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15);
                            }
                          } else {
                            var a16 = cljs.core._first(next_15);
                            var next_16 = cljs.core.next(next_15);
                            if (next_16 == null) {
                              if (f.cljs$core$IFn$_invoke$arity$17) {
                                return f.cljs$core$IFn$_invoke$arity$17(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16);
                              } else {
                                return f.call(f, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16);
                              }
                            } else {
                              var a17 = cljs.core._first(next_16);
                              var next_17 = cljs.core.next(next_16);
                              if (next_17 == null) {
                                if (f.cljs$core$IFn$_invoke$arity$18) {
                                  return f.cljs$core$IFn$_invoke$arity$18(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17);
                                } else {
                                  return f.call(f, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17);
                                }
                              } else {
                                var a18 = cljs.core._first(next_17);
                                var next_18 = cljs.core.next(next_17);
                                if (next_18 == null) {
                                  if (f.cljs$core$IFn$_invoke$arity$19) {
                                    return f.cljs$core$IFn$_invoke$arity$19(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18);
                                  } else {
                                    return f.call(f, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18);
                                  }
                                } else {
                                  var a19 = cljs.core._first(next_18);
                                  var next_19 = cljs.core.next(next_18);
                                  if (next_19 == null) {
                                    if (f.cljs$core$IFn$_invoke$arity$20) {
                                      return f.cljs$core$IFn$_invoke$arity$20(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19);
                                    } else {
                                      return f.call(f, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19);
                                    }
                                  } else {
                                    var arr__4424__auto__ = [a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19];
                                    var s__4425__auto___5287 = next_19;
                                    while (true) {
                                      if (s__4425__auto___5287) {
                                        arr__4424__auto__.push(cljs.core._first(s__4425__auto___5287));
                                        var G__5288 = cljs.core.next(s__4425__auto___5287);
                                        s__4425__auto___5287 = G__5288;
                                        continue;
                                      } else {
                                      }
                                      break;
                                    }
                                    return f.apply(f, arr__4424__auto__);
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.apply_to_simple.cljs$lang$maxFixedArity = 6;
cljs.core.apply = function cljs$core$apply(var_args) {
  var G__5296 = arguments.length;
  switch(G__5296) {
    case 2:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5298 = arguments.length;
      var i__4500__auto___5299 = 0;
      while (true) {
        if (i__4500__auto___5299 < len__4499__auto___5298) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5299]);
          var G__5300 = i__4500__auto___5299 + 1;
          i__4500__auto___5299 = G__5300;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(5), 0, null);
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], argseq__4515__auto__);
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = function(f, args) {
  if (f.cljs$lang$applyTo) {
    var fixed_arity = f.cljs$lang$maxFixedArity;
    var bc = cljs.core.bounded_count(fixed_arity + 1, args);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, args);
    } else {
      return f.cljs$lang$applyTo(args);
    }
  } else {
    return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2(f, cljs.core.seq(args));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = function(f, x, args) {
  if (f.cljs$lang$applyTo) {
    var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x, args);
    var fixed_arity = f.cljs$lang$maxFixedArity;
    var bc = cljs.core.bounded_count(fixed_arity, args) + 1;
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(f, x, cljs.core.seq(args));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = function(f, x, y, args) {
  if (f.cljs$lang$applyTo) {
    var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x, y, args);
    var fixed_arity = f.cljs$lang$maxFixedArity;
    var bc = 2 + cljs.core.bounded_count(fixed_arity - 1, args);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(f, x, y, cljs.core.seq(args));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = function(f, x, y, z, args) {
  if (f.cljs$lang$applyTo) {
    var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x, y, z, args);
    var fixed_arity = f.cljs$lang$maxFixedArity;
    var bc = 3 + cljs.core.bounded_count(fixed_arity - 2, args);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(f, x, y, z, cljs.core.seq(args));
  }
};
cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = function(f, a, b, c, d, args) {
  if (f.cljs$lang$applyTo) {
    var spread_args = cljs.core.spread(args);
    var arglist = cljs.core.cons(a, cljs.core.cons(b, cljs.core.cons(c, cljs.core.cons(d, spread_args))));
    var fixed_arity = f.cljs$lang$maxFixedArity;
    var bc = 4 + cljs.core.bounded_count(fixed_arity - 3, spread_args);
    if (bc <= fixed_arity) {
      return cljs.core.apply_to(f, bc, arglist);
    } else {
      return f.cljs$lang$applyTo(arglist);
    }
  } else {
    return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(f, a, b, c, d, cljs.core.spread(args));
  }
};
cljs.core.apply.cljs$lang$applyTo = function(seq5290) {
  var G__5291 = cljs.core.first(seq5290);
  var seq5290__$1 = cljs.core.next(seq5290);
  var G__5292 = cljs.core.first(seq5290__$1);
  var seq5290__$2 = cljs.core.next(seq5290__$1);
  var G__5293 = cljs.core.first(seq5290__$2);
  var seq5290__$3 = cljs.core.next(seq5290__$2);
  var G__5294 = cljs.core.first(seq5290__$3);
  var seq5290__$4 = cljs.core.next(seq5290__$3);
  var G__5295 = cljs.core.first(seq5290__$4);
  var seq5290__$5 = cljs.core.next(seq5290__$4);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5291, G__5292, G__5293, G__5294, G__5295, seq5290__$5);
};
cljs.core.apply.cljs$lang$maxFixedArity = 5;
cljs.core.vary_meta = function cljs$core$vary_meta(var_args) {
  var G__5309 = arguments.length;
  switch(G__5309) {
    case 2:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5326 = arguments.length;
      var i__4500__auto___5327 = 0;
      while (true) {
        if (i__4500__auto___5327 < len__4499__auto___5326) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5327]);
          var G__5328 = i__4500__auto___5327 + 1;
          i__4500__auto___5327 = G__5328;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(6), 0, null);
      return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__4515__auto__);
  }
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = function(obj, f) {
  return cljs.core.with_meta(obj, function() {
    var G__5310 = cljs.core.meta(obj);
    return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__5310) : f.call(null, G__5310);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = function(obj, f, a) {
  return cljs.core.with_meta(obj, function() {
    var G__5311 = cljs.core.meta(obj);
    var G__5312 = a;
    return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5311, G__5312) : f.call(null, G__5311, G__5312);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = function(obj, f, a, b) {
  return cljs.core.with_meta(obj, function() {
    var G__5313 = cljs.core.meta(obj);
    var G__5314 = a;
    var G__5315 = b;
    return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__5313, G__5314, G__5315) : f.call(null, G__5313, G__5314, G__5315);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = function(obj, f, a, b, c) {
  return cljs.core.with_meta(obj, function() {
    var G__5316 = cljs.core.meta(obj);
    var G__5317 = a;
    var G__5318 = b;
    var G__5319 = c;
    return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__5316, G__5317, G__5318, G__5319) : f.call(null, G__5316, G__5317, G__5318, G__5319);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = function(obj, f, a, b, c, d) {
  return cljs.core.with_meta(obj, function() {
    var G__5320 = cljs.core.meta(obj);
    var G__5321 = a;
    var G__5322 = b;
    var G__5323 = c;
    var G__5324 = d;
    return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__5320, G__5321, G__5322, G__5323, G__5324) : f.call(null, G__5320, G__5321, G__5322, G__5323, G__5324);
  }());
};
cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = function(obj, f, a, b, c, d, args) {
  return cljs.core.with_meta(obj, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.meta(obj), a, b, c, cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([d, args], 0)));
};
cljs.core.vary_meta.cljs$lang$applyTo = function(seq5302) {
  var G__5303 = cljs.core.first(seq5302);
  var seq5302__$1 = cljs.core.next(seq5302);
  var G__5304 = cljs.core.first(seq5302__$1);
  var seq5302__$2 = cljs.core.next(seq5302__$1);
  var G__5305 = cljs.core.first(seq5302__$2);
  var seq5302__$3 = cljs.core.next(seq5302__$2);
  var G__5306 = cljs.core.first(seq5302__$3);
  var seq5302__$4 = cljs.core.next(seq5302__$3);
  var G__5307 = cljs.core.first(seq5302__$4);
  var seq5302__$5 = cljs.core.next(seq5302__$4);
  var G__5308 = cljs.core.first(seq5302__$5);
  var seq5302__$6 = cljs.core.next(seq5302__$5);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5303, G__5304, G__5305, G__5306, G__5307, G__5308, seq5302__$6);
};
cljs.core.vary_meta.cljs$lang$maxFixedArity = 6;
cljs.core.not_EQ_ = function cljs$core$not_EQ_(var_args) {
  var G__5333 = arguments.length;
  switch(G__5333) {
    case 1:
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5335 = arguments.length;
      var i__4500__auto___5336 = 0;
      while (true) {
        if (i__4500__auto___5336 < len__4499__auto___5335) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5336]);
          var G__5337 = i__4500__auto___5336 + 1;
          i__4500__auto___5336 = G__5337;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return false;
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = function(x, y) {
  return !cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y);
};
cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = function(x, y, more) {
  return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_, x, y, more));
};
cljs.core.not_EQ_.cljs$lang$applyTo = function(seq5330) {
  var G__5331 = cljs.core.first(seq5330);
  var seq5330__$1 = cljs.core.next(seq5330);
  var G__5332 = cljs.core.first(seq5330__$1);
  var seq5330__$2 = cljs.core.next(seq5330__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5331, G__5332, seq5330__$2);
};
cljs.core.not_EQ_.cljs$lang$maxFixedArity = 2;
cljs.core.not_empty = function cljs$core$not_empty(coll) {
  if (cljs.core.seq(coll)) {
    return coll;
  } else {
    return null;
  }
};
cljs.core.nil_iter = function cljs$core$nil_iter() {
  if (typeof cljs.core.t_cljs$core5338 !== "undefined") {
  } else {
    cljs.core.t_cljs$core5338 = function(meta5339) {
      this.meta5339 = meta5339;
      this.cljs$lang$protocol_mask$partition0$ = 393216;
      this.cljs$lang$protocol_mask$partition1$ = 0;
    };
    cljs.core.t_cljs$core5338.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(_5340, meta5339__$1) {
      var self__ = this;
      var _5340__$1 = this;
      return new cljs.core.t_cljs$core5338(meta5339__$1);
    };
    cljs.core.t_cljs$core5338.prototype.cljs$core$IMeta$_meta$arity$1 = function(_5340) {
      var self__ = this;
      var _5340__$1 = this;
      return self__.meta5339;
    };
    cljs.core.t_cljs$core5338.prototype.hasNext = function() {
      var self__ = this;
      var _ = this;
      return false;
    };
    cljs.core.t_cljs$core5338.prototype.next = function() {
      var self__ = this;
      var _ = this;
      return new Error("No such element");
    };
    cljs.core.t_cljs$core5338.prototype.remove = function() {
      var self__ = this;
      var _ = this;
      return new Error("Unsupported operation");
    };
    cljs.core.t_cljs$core5338.getBasis = function() {
      return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta5339", "meta5339", 578386699, null)], null);
    };
    cljs.core.t_cljs$core5338.cljs$lang$type = true;
    cljs.core.t_cljs$core5338.cljs$lang$ctorStr = "cljs.core/t_cljs$core5338";
    cljs.core.t_cljs$core5338.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
      return cljs.core._write(writer__4162__auto__, "cljs.core/t_cljs$core5338");
    };
    cljs.core.__GT_t_cljs$core5338 = function cljs$core$nil_iter_$___GT_t_cljs$core5338(meta5339) {
      return new cljs.core.t_cljs$core5338(meta5339);
    };
  }
  return new cljs.core.t_cljs$core5338(cljs.core.PersistentArrayMap.EMPTY);
};
cljs.core.StringIter = function(s, i) {
  this.s = s;
  this.i = i;
};
cljs.core.StringIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.s.length;
};
cljs.core.StringIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.s.charAt(self__.i);
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.StringIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.StringIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "s", "s", -948495851, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.StringIter.cljs$lang$type = true;
cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter";
cljs.core.StringIter.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/StringIter");
};
cljs.core.__GT_StringIter = function cljs$core$__GT_StringIter(s, i) {
  return new cljs.core.StringIter(s, i);
};
cljs.core.string_iter = function cljs$core$string_iter(x) {
  return new cljs.core.StringIter(x, 0);
};
cljs.core.ArrayIter = function(arr, i) {
  this.arr = arr;
  this.i = i;
};
cljs.core.ArrayIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.arr.length;
};
cljs.core.ArrayIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = self__.arr[self__.i];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.ArrayIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.ArrayIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ArrayIter.cljs$lang$type = true;
cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter";
cljs.core.ArrayIter.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/ArrayIter");
};
cljs.core.__GT_ArrayIter = function cljs$core$__GT_ArrayIter(arr, i) {
  return new cljs.core.ArrayIter(arr, i);
};
cljs.core.array_iter = function cljs$core$array_iter(x) {
  return new cljs.core.ArrayIter(x, 0);
};
cljs.core.INIT = {};
cljs.core.START = {};
cljs.core.SeqIter = function(_seq, _next) {
  this._seq = _seq;
  this._next = _next;
};
cljs.core.SeqIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  if (self__._seq === cljs.core.INIT) {
    self__._seq = cljs.core.START;
    self__._next = cljs.core.seq(self__._next);
  } else {
    if (self__._seq === self__._next) {
      self__._next = cljs.core.next(self__._seq);
    } else {
    }
  }
  return !(self__._next == null);
};
cljs.core.SeqIter.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (!this$.hasNext()) {
    throw new Error("No such element");
  } else {
    self__._seq = self__._next;
    return cljs.core.first(self__._next);
  }
};
cljs.core.SeqIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.SeqIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "_seq", "_seq", -449557847, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "_next", "_next", 101877036, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.SeqIter.cljs$lang$type = true;
cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter";
cljs.core.SeqIter.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/SeqIter");
};
cljs.core.__GT_SeqIter = function cljs$core$__GT_SeqIter(_seq, _next) {
  return new cljs.core.SeqIter(_seq, _next);
};
cljs.core.seq_iter = function cljs$core$seq_iter(coll) {
  return new cljs.core.SeqIter(cljs.core.INIT, coll);
};
cljs.core.iter = function cljs$core$iter(coll) {
  if (cljs.core.iterable_QMARK_(coll)) {
    return cljs.core._iterator(coll);
  } else {
    if (coll == null) {
      return cljs.core.nil_iter();
    } else {
      if (typeof coll === "string") {
        return cljs.core.string_iter(coll);
      } else {
        if (cljs.core.array_QMARK_(coll)) {
          return cljs.core.array_iter(coll);
        } else {
          if (cljs.core.seqable_QMARK_(coll)) {
            return cljs.core.seq_iter(coll);
          } else {
            throw new Error(["Cannot create iterator from ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll)].join(""));
          }
        }
      }
    }
  }
};
cljs.core.Many = function(vals) {
  this.vals = vals;
};
cljs.core.Many.prototype.add = function(o) {
  var self__ = this;
  var this$ = this;
  self__.vals.push(o);
  return this$;
};
cljs.core.Many.prototype.remove = function() {
  var self__ = this;
  var this$ = this;
  return self__.vals.shift();
};
cljs.core.Many.prototype.isEmpty = function() {
  var self__ = this;
  var this$ = this;
  return self__.vals.length === 0;
};
cljs.core.Many.prototype.toString = function() {
  var self__ = this;
  var this$ = this;
  return ["Many: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.vals)].join("");
};
cljs.core.Many.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "vals", "vals", -1886377036, null)], null);
};
cljs.core.Many.cljs$lang$type = true;
cljs.core.Many.cljs$lang$ctorStr = "cljs.core/Many";
cljs.core.Many.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/Many");
};
cljs.core.__GT_Many = function cljs$core$__GT_Many(vals) {
  return new cljs.core.Many(vals);
};
cljs.core.NONE = {};
cljs.core.Single = function(val) {
  this.val = val;
};
cljs.core.Single.prototype.add = function(o) {
  var self__ = this;
  var this$ = this;
  if (self__.val === cljs.core.NONE) {
    self__.val = o;
    return this$;
  } else {
    return new cljs.core.Many([self__.val, o]);
  }
};
cljs.core.Single.prototype.remove = function() {
  var self__ = this;
  var this$ = this;
  if (self__.val === cljs.core.NONE) {
    throw new Error(["Removing object from empty buffer"].join(""));
  } else {
    var ret = self__.val;
    self__.val = cljs.core.NONE;
    return ret;
  }
};
cljs.core.Single.prototype.isEmpty = function() {
  var self__ = this;
  var this$ = this;
  return self__.val === cljs.core.NONE;
};
cljs.core.Single.prototype.toString = function() {
  var self__ = this;
  var this$ = this;
  return ["Single: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.val)].join("");
};
cljs.core.Single.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "val", "val", 1769233139, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.Single.cljs$lang$type = true;
cljs.core.Single.cljs$lang$ctorStr = "cljs.core/Single";
cljs.core.Single.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/Single");
};
cljs.core.__GT_Single = function cljs$core$__GT_Single(val) {
  return new cljs.core.Single(val);
};
cljs.core.Empty = function() {
};
cljs.core.Empty.prototype.add = function(o) {
  var self__ = this;
  var this$ = this;
  return new cljs.core.Single(o);
};
cljs.core.Empty.prototype.remove = function() {
  var self__ = this;
  var this$ = this;
  throw new Error(["Removing object from empty buffer"].join(""));
};
cljs.core.Empty.prototype.isEmpty = function() {
  var self__ = this;
  var this$ = this;
  return true;
};
cljs.core.Empty.prototype.toString = function() {
  var self__ = this;
  var this$ = this;
  return "Empty";
};
cljs.core.Empty.getBasis = function() {
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.Empty.cljs$lang$type = true;
cljs.core.Empty.cljs$lang$ctorStr = "cljs.core/Empty";
cljs.core.Empty.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/Empty");
};
cljs.core.__GT_Empty = function cljs$core$__GT_Empty() {
  return new cljs.core.Empty;
};
cljs.core.EMPTY = new cljs.core.Empty;
cljs.core.MultiIterator = function(iters) {
  this.iters = iters;
};
cljs.core.MultiIterator.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  var iters__$1 = cljs.core.seq(self__.iters);
  while (true) {
    if (!(iters__$1 == null)) {
      var iter = cljs.core.first(iters__$1);
      if (!iter.hasNext()) {
        return false;
      } else {
        var G__5341 = cljs.core.next(iters__$1);
        iters__$1 = G__5341;
        continue;
      }
    } else {
      return true;
    }
    break;
  }
};
cljs.core.MultiIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var nexts = [];
  var n__4376__auto___5342 = self__.iters.length;
  var i_5343 = 0;
  while (true) {
    if (i_5343 < n__4376__auto___5342) {
      nexts[i_5343] = self__.iters[i_5343].next();
      var G__5344 = i_5343 + 1;
      i_5343 = G__5344;
      continue;
    } else {
    }
    break;
  }
  return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(nexts, 0);
};
cljs.core.MultiIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "iters", "iters", 719353031, null)], null);
};
cljs.core.MultiIterator.cljs$lang$type = true;
cljs.core.MultiIterator.cljs$lang$ctorStr = "cljs.core/MultiIterator";
cljs.core.MultiIterator.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/MultiIterator");
};
cljs.core.__GT_MultiIterator = function cljs$core$__GT_MultiIterator(iters) {
  return new cljs.core.MultiIterator(iters);
};
cljs.core.chunkIteratorSeq = function cljs$core$chunkIteratorSeq(iter) {
  return new cljs.core.LazySeq(null, function() {
    if (iter.hasNext()) {
      var arr = [];
      var n = 0;
      while (true) {
        if (cljs.core.truth_(function() {
          var and__3911__auto__ = iter.hasNext();
          if (cljs.core.truth_(and__3911__auto__)) {
            return n < 32;
          } else {
            return and__3911__auto__;
          }
        }())) {
          arr[n] = iter.next();
          var G__5345 = n + 1;
          n = G__5345;
          continue;
        } else {
          return cljs.core.chunk_cons(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3(arr, 0, n), cljs.core.chunkIteratorSeq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunkIteratorSeq.cljs$core$IFn$_invoke$arity$1(iter) : cljs.core.chunkIteratorSeq.call(null, iter));
        }
        break;
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.TransformerIterator = function(buffer, _next, completed, xf, sourceIter, multi) {
  this.buffer = buffer;
  this._next = _next;
  this.completed = completed;
  this.xf = xf;
  this.sourceIter = sourceIter;
  this.multi = multi;
};
cljs.core.TransformerIterator.prototype.step = function() {
  var self__ = this;
  var this$ = this;
  if (!(self__._next === cljs.core.NONE)) {
    return true;
  } else {
    while (true) {
      if (self__._next === cljs.core.NONE) {
        if (self__.buffer.isEmpty()) {
          if (self__.completed) {
            return false;
          } else {
            if (self__.sourceIter.hasNext()) {
              var iter = self__.multi ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xf, cljs.core.cons(null, self__.sourceIter.next())) : function() {
                var G__5346 = null;
                var G__5347 = self__.sourceIter.next();
                return self__.xf.cljs$core$IFn$_invoke$arity$2 ? self__.xf.cljs$core$IFn$_invoke$arity$2(G__5346, G__5347) : self__.xf.call(null, G__5346, G__5347);
              }();
              if (cljs.core.reduced_QMARK_(iter)) {
                self__.xf.cljs$core$IFn$_invoke$arity$1 ? self__.xf.cljs$core$IFn$_invoke$arity$1(null) : self__.xf.call(null, null);
                self__.completed = true;
              } else {
              }
              continue;
            } else {
              self__.xf.cljs$core$IFn$_invoke$arity$1 ? self__.xf.cljs$core$IFn$_invoke$arity$1(null) : self__.xf.call(null, null);
              self__.completed = true;
              continue;
            }
          }
        } else {
          self__._next = self__.buffer.remove();
          continue;
        }
      } else {
        return true;
      }
      break;
    }
  }
};
cljs.core.TransformerIterator.prototype.hasNext = function() {
  var self__ = this;
  var this$ = this;
  return this$.step();
};
cljs.core.TransformerIterator.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (this$.hasNext()) {
    var ret = self__._next;
    self__._next = cljs.core.NONE;
    return ret;
  } else {
    throw new Error("No such element");
  }
};
cljs.core.TransformerIterator.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.TransformerIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "buffer", "buffer", -2037140571, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "_next", "_next", 101877036, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), 
  cljs.core.with_meta(new cljs.core.Symbol(null, "completed", "completed", 1154475024, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "xf", "xf", 2042434515, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, "sourceIter", "sourceIter", 1068220306, null), new cljs.core.Symbol(null, 
  "multi", "multi", 1450238522, null)], null);
};
cljs.core.TransformerIterator.cljs$lang$type = true;
cljs.core.TransformerIterator.cljs$lang$ctorStr = "cljs.core/TransformerIterator";
cljs.core.TransformerIterator.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/TransformerIterator");
};
cljs.core.__GT_TransformerIterator = function cljs$core$__GT_TransformerIterator(buffer, _next, completed, xf, sourceIter, multi) {
  return new cljs.core.TransformerIterator(buffer, _next, completed, xf, sourceIter, multi);
};
var G__5348_5351 = cljs.core.TransformerIterator.prototype;
var G__5349_5352 = cljs.core.ITER_SYMBOL;
var G__5350_5353 = function(G__5348_5351, G__5349_5352) {
  return function() {
    var this__4438__auto__ = this;
    return cljs.core.es6_iterator(this__4438__auto__);
  };
}(G__5348_5351, G__5349_5352);
goog.object.set(G__5348_5351, G__5349_5352, G__5350_5353);
cljs.core.transformer_iterator = function cljs$core$transformer_iterator(xform, sourceIter, multi) {
  var iterator = new cljs.core.TransformerIterator(cljs.core.EMPTY, cljs.core.NONE, false, null, sourceIter, multi);
  iterator.xf = function() {
    var G__5354 = function(iterator) {
      return function() {
        var G__5355 = null;
        var G__5355__0 = function() {
          return null;
        };
        var G__5355__1 = function(acc) {
          return acc;
        };
        var G__5355__2 = function(acc, o) {
          iterator.buffer = iterator.buffer.add(o);
          return acc;
        };
        G__5355 = function(acc, o) {
          switch(arguments.length) {
            case 0:
              return G__5355__0.call(this);
            case 1:
              return G__5355__1.call(this, acc);
            case 2:
              return G__5355__2.call(this, acc, o);
          }
          throw new Error("Invalid arity: " + (arguments.length - 1));
        };
        G__5355.cljs$core$IFn$_invoke$arity$0 = G__5355__0;
        G__5355.cljs$core$IFn$_invoke$arity$1 = G__5355__1;
        G__5355.cljs$core$IFn$_invoke$arity$2 = G__5355__2;
        return G__5355;
      }();
    }(iterator);
    return xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__5354) : xform.call(null, G__5354);
  }();
  return iterator;
};
cljs.core.TransformerIterator.create = function(xform, source) {
  return cljs.core.transformer_iterator(xform, source, false);
};
cljs.core.TransformerIterator.createMulti = function(xform, sources) {
  return cljs.core.transformer_iterator(xform, new cljs.core.MultiIterator(cljs.core.to_array(sources)), true);
};
cljs.core.sequence = function cljs$core$sequence(var_args) {
  var G__5360 = arguments.length;
  switch(G__5360) {
    case 1:
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5362 = arguments.length;
      var i__4500__auto___5363 = 0;
      while (true) {
        if (i__4500__auto___5363 < len__4499__auto___5362) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5363]);
          var G__5364 = i__4500__auto___5363 + 1;
          i__4500__auto___5363 = G__5364;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = function(coll) {
  if (cljs.core.seq_QMARK_(coll)) {
    return coll;
  } else {
    var or__3922__auto__ = cljs.core.seq(coll);
    if (or__3922__auto__) {
      return or__3922__auto__;
    } else {
      return cljs.core.List.EMPTY;
    }
  }
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = function(xform, coll) {
  var or__3922__auto__ = cljs.core.chunkIteratorSeq(cljs.core.TransformerIterator.create(xform, cljs.core.iter(coll)));
  if (cljs.core.truth_(or__3922__auto__)) {
    return or__3922__auto__;
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = function(xform, coll, colls) {
  var or__3922__auto__ = cljs.core.chunkIteratorSeq(cljs.core.TransformerIterator.createMulti(xform, cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.iter, cljs.core.cons(coll, colls))));
  if (cljs.core.truth_(or__3922__auto__)) {
    return or__3922__auto__;
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.sequence.cljs$lang$applyTo = function(seq5357) {
  var G__5358 = cljs.core.first(seq5357);
  var seq5357__$1 = cljs.core.next(seq5357);
  var G__5359 = cljs.core.first(seq5357__$1);
  var seq5357__$2 = cljs.core.next(seq5357__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5358, G__5359, seq5357__$2);
};
cljs.core.sequence.cljs$lang$maxFixedArity = 2;
cljs.core.every_QMARK_ = function cljs$core$every_QMARK_(pred, coll) {
  while (true) {
    if (cljs.core.seq(coll) == null) {
      return true;
    } else {
      if (cljs.core.truth_(function() {
        var G__5365 = cljs.core.first(coll);
        return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__5365) : pred.call(null, G__5365);
      }())) {
        var G__5366 = pred;
        var G__5367 = cljs.core.next(coll);
        pred = G__5366;
        coll = G__5367;
        continue;
      } else {
        return false;
      }
    }
    break;
  }
};
cljs.core.not_every_QMARK_ = function cljs$core$not_every_QMARK_(pred, coll) {
  return !cljs.core.every_QMARK_(pred, coll);
};
cljs.core.some = function cljs$core$some(pred, coll) {
  while (true) {
    if (cljs.core.seq(coll)) {
      var or__3922__auto__ = function() {
        var G__5369 = cljs.core.first(coll);
        return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__5369) : pred.call(null, G__5369);
      }();
      if (cljs.core.truth_(or__3922__auto__)) {
        return or__3922__auto__;
      } else {
        var G__5370 = pred;
        var G__5371 = cljs.core.next(coll);
        pred = G__5370;
        coll = G__5371;
        continue;
      }
    } else {
      return null;
    }
    break;
  }
};
cljs.core.not_any_QMARK_ = function cljs$core$not_any_QMARK_(pred, coll) {
  return cljs.core.not(cljs.core.some(pred, coll));
};
cljs.core.even_QMARK_ = function cljs$core$even_QMARK_(n) {
  if (cljs.core.integer_QMARK_(n)) {
    return (n & 1) === 0;
  } else {
    throw new Error(["Argument must be an integer: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)].join(""));
  }
};
cljs.core.odd_QMARK_ = function cljs$core$odd_QMARK_(n) {
  return !cljs.core.even_QMARK_(n);
};
cljs.core.complement = function cljs$core$complement(f) {
  return function() {
    var G__5372 = null;
    var G__5372__0 = function() {
      return cljs.core.not(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
    };
    var G__5372__1 = function(x) {
      return cljs.core.not(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null, x));
    };
    var G__5372__2 = function(x, y) {
      return cljs.core.not(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x, y) : f.call(null, x, y));
    };
    var G__5372__3 = function() {
      var G__5373__delegate = function(x, y, zs) {
        return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f, x, y, zs));
      };
      var G__5373 = function(x, y, var_args) {
        var zs = null;
        if (arguments.length > 2) {
          var G__5374__i = 0, G__5374__a = new Array(arguments.length - 2);
          while (G__5374__i < G__5374__a.length) {
            G__5374__a[G__5374__i] = arguments[G__5374__i + 2];
            ++G__5374__i;
          }
          zs = new cljs.core.IndexedSeq(G__5374__a, 0, null);
        }
        return G__5373__delegate.call(this, x, y, zs);
      };
      G__5373.cljs$lang$maxFixedArity = 2;
      G__5373.cljs$lang$applyTo = function(arglist__5375) {
        var x = cljs.core.first(arglist__5375);
        arglist__5375 = cljs.core.next(arglist__5375);
        var y = cljs.core.first(arglist__5375);
        var zs = cljs.core.rest(arglist__5375);
        return G__5373__delegate(x, y, zs);
      };
      G__5373.cljs$core$IFn$_invoke$arity$variadic = G__5373__delegate;
      return G__5373;
    }();
    G__5372 = function(x, y, var_args) {
      var zs = var_args;
      switch(arguments.length) {
        case 0:
          return G__5372__0.call(this);
        case 1:
          return G__5372__1.call(this, x);
        case 2:
          return G__5372__2.call(this, x, y);
        default:
          var G__5376 = null;
          if (arguments.length > 2) {
            var G__5377__i = 0, G__5377__a = new Array(arguments.length - 2);
            while (G__5377__i < G__5377__a.length) {
              G__5377__a[G__5377__i] = arguments[G__5377__i + 2];
              ++G__5377__i;
            }
            G__5376 = new cljs.core.IndexedSeq(G__5377__a, 0, null);
          }
          return G__5372__3.cljs$core$IFn$_invoke$arity$variadic(x, y, G__5376);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    G__5372.cljs$lang$maxFixedArity = 2;
    G__5372.cljs$lang$applyTo = G__5372__3.cljs$lang$applyTo;
    G__5372.cljs$core$IFn$_invoke$arity$0 = G__5372__0;
    G__5372.cljs$core$IFn$_invoke$arity$1 = G__5372__1;
    G__5372.cljs$core$IFn$_invoke$arity$2 = G__5372__2;
    G__5372.cljs$core$IFn$_invoke$arity$variadic = G__5372__3.cljs$core$IFn$_invoke$arity$variadic;
    return G__5372;
  }();
};
cljs.core.constantly = function cljs$core$constantly(x) {
  return function() {
    var G__5378__delegate = function(args) {
      return x;
    };
    var G__5378 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__5379__i = 0, G__5379__a = new Array(arguments.length - 0);
        while (G__5379__i < G__5379__a.length) {
          G__5379__a[G__5379__i] = arguments[G__5379__i + 0];
          ++G__5379__i;
        }
        args = new cljs.core.IndexedSeq(G__5379__a, 0, null);
      }
      return G__5378__delegate.call(this, args);
    };
    G__5378.cljs$lang$maxFixedArity = 0;
    G__5378.cljs$lang$applyTo = function(arglist__5380) {
      var args = cljs.core.seq(arglist__5380);
      return G__5378__delegate(args);
    };
    G__5378.cljs$core$IFn$_invoke$arity$variadic = G__5378__delegate;
    return G__5378;
  }();
};
cljs.core.comp = function cljs$core$comp(var_args) {
  var G__5386 = arguments.length;
  switch(G__5386) {
    case 0:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5404 = arguments.length;
      var i__4500__auto___5405 = 0;
      while (true) {
        if (i__4500__auto___5405 < len__4499__auto___5404) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5405]);
          var G__5406 = i__4500__auto___5405 + 1;
          i__4500__auto___5405 = G__5406;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(3), 0, null);
      return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__4515__auto__);
  }
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.identity;
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return f;
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = function(f, g) {
  return function() {
    var G__5407 = null;
    var G__5407__0 = function() {
      var G__5387 = g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__5387) : f.call(null, G__5387);
    };
    var G__5407__1 = function(x) {
      var G__5388 = g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null, x);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__5388) : f.call(null, G__5388);
    };
    var G__5407__2 = function(x, y) {
      var G__5389 = g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x, y) : g.call(null, x, y);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__5389) : f.call(null, G__5389);
    };
    var G__5407__3 = function(x, y, z) {
      var G__5390 = g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x, y, z) : g.call(null, x, y, z);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__5390) : f.call(null, G__5390);
    };
    var G__5407__4 = function() {
      var G__5408__delegate = function(x, y, z, args) {
        var G__5391 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g, x, y, z, args);
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__5391) : f.call(null, G__5391);
      };
      var G__5408 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__5409__i = 0, G__5409__a = new Array(arguments.length - 3);
          while (G__5409__i < G__5409__a.length) {
            G__5409__a[G__5409__i] = arguments[G__5409__i + 3];
            ++G__5409__i;
          }
          args = new cljs.core.IndexedSeq(G__5409__a, 0, null);
        }
        return G__5408__delegate.call(this, x, y, z, args);
      };
      G__5408.cljs$lang$maxFixedArity = 3;
      G__5408.cljs$lang$applyTo = function(arglist__5410) {
        var x = cljs.core.first(arglist__5410);
        arglist__5410 = cljs.core.next(arglist__5410);
        var y = cljs.core.first(arglist__5410);
        arglist__5410 = cljs.core.next(arglist__5410);
        var z = cljs.core.first(arglist__5410);
        var args = cljs.core.rest(arglist__5410);
        return G__5408__delegate(x, y, z, args);
      };
      G__5408.cljs$core$IFn$_invoke$arity$variadic = G__5408__delegate;
      return G__5408;
    }();
    G__5407 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__5407__0.call(this);
        case 1:
          return G__5407__1.call(this, x);
        case 2:
          return G__5407__2.call(this, x, y);
        case 3:
          return G__5407__3.call(this, x, y, z);
        default:
          var G__5411 = null;
          if (arguments.length > 3) {
            var G__5412__i = 0, G__5412__a = new Array(arguments.length - 3);
            while (G__5412__i < G__5412__a.length) {
              G__5412__a[G__5412__i] = arguments[G__5412__i + 3];
              ++G__5412__i;
            }
            G__5411 = new cljs.core.IndexedSeq(G__5412__a, 0, null);
          }
          return G__5407__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__5411);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    G__5407.cljs$lang$maxFixedArity = 3;
    G__5407.cljs$lang$applyTo = G__5407__4.cljs$lang$applyTo;
    G__5407.cljs$core$IFn$_invoke$arity$0 = G__5407__0;
    G__5407.cljs$core$IFn$_invoke$arity$1 = G__5407__1;
    G__5407.cljs$core$IFn$_invoke$arity$2 = G__5407__2;
    G__5407.cljs$core$IFn$_invoke$arity$3 = G__5407__3;
    G__5407.cljs$core$IFn$_invoke$arity$variadic = G__5407__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__5407;
  }();
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = function(f, g, h) {
  return function() {
    var G__5413 = null;
    var G__5413__0 = function() {
      var G__5392 = function() {
        var G__5393 = h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null);
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__5393) : g.call(null, G__5393);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__5392) : f.call(null, G__5392);
    };
    var G__5413__1 = function(x) {
      var G__5394 = function() {
        var G__5395 = h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(x) : h.call(null, x);
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__5395) : g.call(null, G__5395);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__5394) : f.call(null, G__5394);
    };
    var G__5413__2 = function(x, y) {
      var G__5396 = function() {
        var G__5397 = h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(x, y) : h.call(null, x, y);
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__5397) : g.call(null, G__5397);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__5396) : f.call(null, G__5396);
    };
    var G__5413__3 = function(x, y, z) {
      var G__5398 = function() {
        var G__5399 = h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(x, y, z) : h.call(null, x, y, z);
        return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__5399) : g.call(null, G__5399);
      }();
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__5398) : f.call(null, G__5398);
    };
    var G__5413__4 = function() {
      var G__5414__delegate = function(x, y, z, args) {
        var G__5400 = function() {
          var G__5401 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h, x, y, z, args);
          return g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__5401) : g.call(null, G__5401);
        }();
        return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__5400) : f.call(null, G__5400);
      };
      var G__5414 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__5415__i = 0, G__5415__a = new Array(arguments.length - 3);
          while (G__5415__i < G__5415__a.length) {
            G__5415__a[G__5415__i] = arguments[G__5415__i + 3];
            ++G__5415__i;
          }
          args = new cljs.core.IndexedSeq(G__5415__a, 0, null);
        }
        return G__5414__delegate.call(this, x, y, z, args);
      };
      G__5414.cljs$lang$maxFixedArity = 3;
      G__5414.cljs$lang$applyTo = function(arglist__5416) {
        var x = cljs.core.first(arglist__5416);
        arglist__5416 = cljs.core.next(arglist__5416);
        var y = cljs.core.first(arglist__5416);
        arglist__5416 = cljs.core.next(arglist__5416);
        var z = cljs.core.first(arglist__5416);
        var args = cljs.core.rest(arglist__5416);
        return G__5414__delegate(x, y, z, args);
      };
      G__5414.cljs$core$IFn$_invoke$arity$variadic = G__5414__delegate;
      return G__5414;
    }();
    G__5413 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__5413__0.call(this);
        case 1:
          return G__5413__1.call(this, x);
        case 2:
          return G__5413__2.call(this, x, y);
        case 3:
          return G__5413__3.call(this, x, y, z);
        default:
          var G__5417 = null;
          if (arguments.length > 3) {
            var G__5418__i = 0, G__5418__a = new Array(arguments.length - 3);
            while (G__5418__i < G__5418__a.length) {
              G__5418__a[G__5418__i] = arguments[G__5418__i + 3];
              ++G__5418__i;
            }
            G__5417 = new cljs.core.IndexedSeq(G__5418__a, 0, null);
          }
          return G__5413__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__5417);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    G__5413.cljs$lang$maxFixedArity = 3;
    G__5413.cljs$lang$applyTo = G__5413__4.cljs$lang$applyTo;
    G__5413.cljs$core$IFn$_invoke$arity$0 = G__5413__0;
    G__5413.cljs$core$IFn$_invoke$arity$1 = G__5413__1;
    G__5413.cljs$core$IFn$_invoke$arity$2 = G__5413__2;
    G__5413.cljs$core$IFn$_invoke$arity$3 = G__5413__3;
    G__5413.cljs$core$IFn$_invoke$arity$variadic = G__5413__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__5413;
  }();
};
cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = function(f1, f2, f3, fs) {
  var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1, f2, f3, fs));
  return function(fs__$1) {
    return function() {
      var G__5419__delegate = function(args) {
        var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1), args);
        var fs__$2 = cljs.core.next(fs__$1);
        while (true) {
          if (fs__$2) {
            var G__5420 = function() {
              var fexpr__5402 = cljs.core.first(fs__$2);
              return fexpr__5402.cljs$core$IFn$_invoke$arity$1 ? fexpr__5402.cljs$core$IFn$_invoke$arity$1(ret) : fexpr__5402.call(null, ret);
            }();
            var G__5421 = cljs.core.next(fs__$2);
            ret = G__5420;
            fs__$2 = G__5421;
            continue;
          } else {
            return ret;
          }
          break;
        }
      };
      var G__5419 = function(var_args) {
        var args = null;
        if (arguments.length > 0) {
          var G__5422__i = 0, G__5422__a = new Array(arguments.length - 0);
          while (G__5422__i < G__5422__a.length) {
            G__5422__a[G__5422__i] = arguments[G__5422__i + 0];
            ++G__5422__i;
          }
          args = new cljs.core.IndexedSeq(G__5422__a, 0, null);
        }
        return G__5419__delegate.call(this, args);
      };
      G__5419.cljs$lang$maxFixedArity = 0;
      G__5419.cljs$lang$applyTo = function(arglist__5423) {
        var args = cljs.core.seq(arglist__5423);
        return G__5419__delegate(args);
      };
      G__5419.cljs$core$IFn$_invoke$arity$variadic = G__5419__delegate;
      return G__5419;
    }();
  }(fs__$1);
};
cljs.core.comp.cljs$lang$applyTo = function(seq5382) {
  var G__5383 = cljs.core.first(seq5382);
  var seq5382__$1 = cljs.core.next(seq5382);
  var G__5384 = cljs.core.first(seq5382__$1);
  var seq5382__$2 = cljs.core.next(seq5382__$1);
  var G__5385 = cljs.core.first(seq5382__$2);
  var seq5382__$3 = cljs.core.next(seq5382__$2);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5383, G__5384, G__5385, seq5382__$3);
};
cljs.core.comp.cljs$lang$maxFixedArity = 3;
cljs.core.partial = function cljs$core$partial(var_args) {
  var G__5430 = arguments.length;
  switch(G__5430) {
    case 1:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5432 = arguments.length;
      var i__4500__auto___5433 = 0;
      while (true) {
        if (i__4500__auto___5433 < len__4499__auto___5432) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5433]);
          var G__5434 = i__4500__auto___5433 + 1;
          i__4500__auto___5433 = G__5434;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(4), 0, null);
      return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__4515__auto__);
  }
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return f;
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = function(f, arg1) {
  return function() {
    var G__5435 = null;
    var G__5435__0 = function() {
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(arg1) : f.call(null, arg1);
    };
    var G__5435__1 = function(x) {
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1, x) : f.call(null, arg1, x);
    };
    var G__5435__2 = function(x, y) {
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1, x, y) : f.call(null, arg1, x, y);
    };
    var G__5435__3 = function(x, y, z) {
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1, x, y, z) : f.call(null, arg1, x, y, z);
    };
    var G__5435__4 = function() {
      var G__5436__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, x, y, z, cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
      };
      var G__5436 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__5437__i = 0, G__5437__a = new Array(arguments.length - 3);
          while (G__5437__i < G__5437__a.length) {
            G__5437__a[G__5437__i] = arguments[G__5437__i + 3];
            ++G__5437__i;
          }
          args = new cljs.core.IndexedSeq(G__5437__a, 0, null);
        }
        return G__5436__delegate.call(this, x, y, z, args);
      };
      G__5436.cljs$lang$maxFixedArity = 3;
      G__5436.cljs$lang$applyTo = function(arglist__5438) {
        var x = cljs.core.first(arglist__5438);
        arglist__5438 = cljs.core.next(arglist__5438);
        var y = cljs.core.first(arglist__5438);
        arglist__5438 = cljs.core.next(arglist__5438);
        var z = cljs.core.first(arglist__5438);
        var args = cljs.core.rest(arglist__5438);
        return G__5436__delegate(x, y, z, args);
      };
      G__5436.cljs$core$IFn$_invoke$arity$variadic = G__5436__delegate;
      return G__5436;
    }();
    G__5435 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__5435__0.call(this);
        case 1:
          return G__5435__1.call(this, x);
        case 2:
          return G__5435__2.call(this, x, y);
        case 3:
          return G__5435__3.call(this, x, y, z);
        default:
          var G__5439 = null;
          if (arguments.length > 3) {
            var G__5440__i = 0, G__5440__a = new Array(arguments.length - 3);
            while (G__5440__i < G__5440__a.length) {
              G__5440__a[G__5440__i] = arguments[G__5440__i + 3];
              ++G__5440__i;
            }
            G__5439 = new cljs.core.IndexedSeq(G__5440__a, 0, null);
          }
          return G__5435__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__5439);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    G__5435.cljs$lang$maxFixedArity = 3;
    G__5435.cljs$lang$applyTo = G__5435__4.cljs$lang$applyTo;
    G__5435.cljs$core$IFn$_invoke$arity$0 = G__5435__0;
    G__5435.cljs$core$IFn$_invoke$arity$1 = G__5435__1;
    G__5435.cljs$core$IFn$_invoke$arity$2 = G__5435__2;
    G__5435.cljs$core$IFn$_invoke$arity$3 = G__5435__3;
    G__5435.cljs$core$IFn$_invoke$arity$variadic = G__5435__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__5435;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = function(f, arg1, arg2) {
  return function() {
    var G__5441 = null;
    var G__5441__0 = function() {
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1, arg2) : f.call(null, arg1, arg2);
    };
    var G__5441__1 = function(x) {
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1, arg2, x) : f.call(null, arg1, arg2, x);
    };
    var G__5441__2 = function(x, y) {
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1, arg2, x, y) : f.call(null, arg1, arg2, x, y);
    };
    var G__5441__3 = function(x, y, z) {
      return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1, arg2, x, y, z) : f.call(null, arg1, arg2, x, y, z);
    };
    var G__5441__4 = function() {
      var G__5442__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, arg2, x, y, cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([z, args], 0));
      };
      var G__5442 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__5443__i = 0, G__5443__a = new Array(arguments.length - 3);
          while (G__5443__i < G__5443__a.length) {
            G__5443__a[G__5443__i] = arguments[G__5443__i + 3];
            ++G__5443__i;
          }
          args = new cljs.core.IndexedSeq(G__5443__a, 0, null);
        }
        return G__5442__delegate.call(this, x, y, z, args);
      };
      G__5442.cljs$lang$maxFixedArity = 3;
      G__5442.cljs$lang$applyTo = function(arglist__5444) {
        var x = cljs.core.first(arglist__5444);
        arglist__5444 = cljs.core.next(arglist__5444);
        var y = cljs.core.first(arglist__5444);
        arglist__5444 = cljs.core.next(arglist__5444);
        var z = cljs.core.first(arglist__5444);
        var args = cljs.core.rest(arglist__5444);
        return G__5442__delegate(x, y, z, args);
      };
      G__5442.cljs$core$IFn$_invoke$arity$variadic = G__5442__delegate;
      return G__5442;
    }();
    G__5441 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__5441__0.call(this);
        case 1:
          return G__5441__1.call(this, x);
        case 2:
          return G__5441__2.call(this, x, y);
        case 3:
          return G__5441__3.call(this, x, y, z);
        default:
          var G__5445 = null;
          if (arguments.length > 3) {
            var G__5446__i = 0, G__5446__a = new Array(arguments.length - 3);
            while (G__5446__i < G__5446__a.length) {
              G__5446__a[G__5446__i] = arguments[G__5446__i + 3];
              ++G__5446__i;
            }
            G__5445 = new cljs.core.IndexedSeq(G__5446__a, 0, null);
          }
          return G__5441__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__5445);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    G__5441.cljs$lang$maxFixedArity = 3;
    G__5441.cljs$lang$applyTo = G__5441__4.cljs$lang$applyTo;
    G__5441.cljs$core$IFn$_invoke$arity$0 = G__5441__0;
    G__5441.cljs$core$IFn$_invoke$arity$1 = G__5441__1;
    G__5441.cljs$core$IFn$_invoke$arity$2 = G__5441__2;
    G__5441.cljs$core$IFn$_invoke$arity$3 = G__5441__3;
    G__5441.cljs$core$IFn$_invoke$arity$variadic = G__5441__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__5441;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = function(f, arg1, arg2, arg3) {
  return function() {
    var G__5447 = null;
    var G__5447__0 = function() {
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1, arg2, arg3) : f.call(null, arg1, arg2, arg3);
    };
    var G__5447__1 = function(x) {
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1, arg2, arg3, x) : f.call(null, arg1, arg2, arg3, x);
    };
    var G__5447__2 = function(x, y) {
      return f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1, arg2, arg3, x, y) : f.call(null, arg1, arg2, arg3, x, y);
    };
    var G__5447__3 = function(x, y, z) {
      return f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(arg1, arg2, arg3, x, y, z) : f.call(null, arg1, arg2, arg3, x, y, z);
    };
    var G__5447__4 = function() {
      var G__5448__delegate = function(x, y, z, args) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, arg1, arg2, arg3, x, cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([y, z, args], 0));
      };
      var G__5448 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__5449__i = 0, G__5449__a = new Array(arguments.length - 3);
          while (G__5449__i < G__5449__a.length) {
            G__5449__a[G__5449__i] = arguments[G__5449__i + 3];
            ++G__5449__i;
          }
          args = new cljs.core.IndexedSeq(G__5449__a, 0, null);
        }
        return G__5448__delegate.call(this, x, y, z, args);
      };
      G__5448.cljs$lang$maxFixedArity = 3;
      G__5448.cljs$lang$applyTo = function(arglist__5450) {
        var x = cljs.core.first(arglist__5450);
        arglist__5450 = cljs.core.next(arglist__5450);
        var y = cljs.core.first(arglist__5450);
        arglist__5450 = cljs.core.next(arglist__5450);
        var z = cljs.core.first(arglist__5450);
        var args = cljs.core.rest(arglist__5450);
        return G__5448__delegate(x, y, z, args);
      };
      G__5448.cljs$core$IFn$_invoke$arity$variadic = G__5448__delegate;
      return G__5448;
    }();
    G__5447 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return G__5447__0.call(this);
        case 1:
          return G__5447__1.call(this, x);
        case 2:
          return G__5447__2.call(this, x, y);
        case 3:
          return G__5447__3.call(this, x, y, z);
        default:
          var G__5451 = null;
          if (arguments.length > 3) {
            var G__5452__i = 0, G__5452__a = new Array(arguments.length - 3);
            while (G__5452__i < G__5452__a.length) {
              G__5452__a[G__5452__i] = arguments[G__5452__i + 3];
              ++G__5452__i;
            }
            G__5451 = new cljs.core.IndexedSeq(G__5452__a, 0, null);
          }
          return G__5447__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__5451);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    G__5447.cljs$lang$maxFixedArity = 3;
    G__5447.cljs$lang$applyTo = G__5447__4.cljs$lang$applyTo;
    G__5447.cljs$core$IFn$_invoke$arity$0 = G__5447__0;
    G__5447.cljs$core$IFn$_invoke$arity$1 = G__5447__1;
    G__5447.cljs$core$IFn$_invoke$arity$2 = G__5447__2;
    G__5447.cljs$core$IFn$_invoke$arity$3 = G__5447__3;
    G__5447.cljs$core$IFn$_invoke$arity$variadic = G__5447__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__5447;
  }();
};
cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = function(f, arg1, arg2, arg3, more) {
  return function() {
    var G__5453__delegate = function(args) {
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, arg1, arg2, arg3, cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more, args));
    };
    var G__5453 = function(var_args) {
      var args = null;
      if (arguments.length > 0) {
        var G__5454__i = 0, G__5454__a = new Array(arguments.length - 0);
        while (G__5454__i < G__5454__a.length) {
          G__5454__a[G__5454__i] = arguments[G__5454__i + 0];
          ++G__5454__i;
        }
        args = new cljs.core.IndexedSeq(G__5454__a, 0, null);
      }
      return G__5453__delegate.call(this, args);
    };
    G__5453.cljs$lang$maxFixedArity = 0;
    G__5453.cljs$lang$applyTo = function(arglist__5455) {
      var args = cljs.core.seq(arglist__5455);
      return G__5453__delegate(args);
    };
    G__5453.cljs$core$IFn$_invoke$arity$variadic = G__5453__delegate;
    return G__5453;
  }();
};
cljs.core.partial.cljs$lang$applyTo = function(seq5425) {
  var G__5426 = cljs.core.first(seq5425);
  var seq5425__$1 = cljs.core.next(seq5425);
  var G__5427 = cljs.core.first(seq5425__$1);
  var seq5425__$2 = cljs.core.next(seq5425__$1);
  var G__5428 = cljs.core.first(seq5425__$2);
  var seq5425__$3 = cljs.core.next(seq5425__$2);
  var G__5429 = cljs.core.first(seq5425__$3);
  var seq5425__$4 = cljs.core.next(seq5425__$3);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5426, G__5427, G__5428, G__5429, seq5425__$4);
};
cljs.core.partial.cljs$lang$maxFixedArity = 4;
cljs.core.fnil = function cljs$core$fnil(var_args) {
  var G__5457 = arguments.length;
  switch(G__5457) {
    case 2:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = function(f, x) {
  return function() {
    var G__5475 = null;
    var G__5475__1 = function(a) {
      var G__5458 = a == null ? x : a;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__5458) : f.call(null, G__5458);
    };
    var G__5475__2 = function(a, b) {
      var G__5459 = a == null ? x : a;
      var G__5460 = b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5459, G__5460) : f.call(null, G__5459, G__5460);
    };
    var G__5475__3 = function(a, b, c) {
      var G__5461 = a == null ? x : a;
      var G__5462 = b;
      var G__5463 = c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__5461, G__5462, G__5463) : f.call(null, G__5461, G__5462, G__5463);
    };
    var G__5475__4 = function() {
      var G__5476__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b, c, ds);
      };
      var G__5476 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__5477__i = 0, G__5477__a = new Array(arguments.length - 3);
          while (G__5477__i < G__5477__a.length) {
            G__5477__a[G__5477__i] = arguments[G__5477__i + 3];
            ++G__5477__i;
          }
          ds = new cljs.core.IndexedSeq(G__5477__a, 0, null);
        }
        return G__5476__delegate.call(this, a, b, c, ds);
      };
      G__5476.cljs$lang$maxFixedArity = 3;
      G__5476.cljs$lang$applyTo = function(arglist__5478) {
        var a = cljs.core.first(arglist__5478);
        arglist__5478 = cljs.core.next(arglist__5478);
        var b = cljs.core.first(arglist__5478);
        arglist__5478 = cljs.core.next(arglist__5478);
        var c = cljs.core.first(arglist__5478);
        var ds = cljs.core.rest(arglist__5478);
        return G__5476__delegate(a, b, c, ds);
      };
      G__5476.cljs$core$IFn$_invoke$arity$variadic = G__5476__delegate;
      return G__5476;
    }();
    G__5475 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 1:
          return G__5475__1.call(this, a);
        case 2:
          return G__5475__2.call(this, a, b);
        case 3:
          return G__5475__3.call(this, a, b, c);
        default:
          var G__5479 = null;
          if (arguments.length > 3) {
            var G__5480__i = 0, G__5480__a = new Array(arguments.length - 3);
            while (G__5480__i < G__5480__a.length) {
              G__5480__a[G__5480__i] = arguments[G__5480__i + 3];
              ++G__5480__i;
            }
            G__5479 = new cljs.core.IndexedSeq(G__5480__a, 0, null);
          }
          return G__5475__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__5479);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    G__5475.cljs$lang$maxFixedArity = 3;
    G__5475.cljs$lang$applyTo = G__5475__4.cljs$lang$applyTo;
    G__5475.cljs$core$IFn$_invoke$arity$1 = G__5475__1;
    G__5475.cljs$core$IFn$_invoke$arity$2 = G__5475__2;
    G__5475.cljs$core$IFn$_invoke$arity$3 = G__5475__3;
    G__5475.cljs$core$IFn$_invoke$arity$variadic = G__5475__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__5475;
  }();
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = function(f, x, y) {
  return function() {
    var G__5481 = null;
    var G__5481__2 = function(a, b) {
      var G__5464 = a == null ? x : a;
      var G__5465 = b == null ? y : b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5464, G__5465) : f.call(null, G__5464, G__5465);
    };
    var G__5481__3 = function(a, b, c) {
      var G__5466 = a == null ? x : a;
      var G__5467 = b == null ? y : b;
      var G__5468 = c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__5466, G__5467, G__5468) : f.call(null, G__5466, G__5467, G__5468);
    };
    var G__5481__4 = function() {
      var G__5482__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b == null ? y : b, c, ds);
      };
      var G__5482 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__5483__i = 0, G__5483__a = new Array(arguments.length - 3);
          while (G__5483__i < G__5483__a.length) {
            G__5483__a[G__5483__i] = arguments[G__5483__i + 3];
            ++G__5483__i;
          }
          ds = new cljs.core.IndexedSeq(G__5483__a, 0, null);
        }
        return G__5482__delegate.call(this, a, b, c, ds);
      };
      G__5482.cljs$lang$maxFixedArity = 3;
      G__5482.cljs$lang$applyTo = function(arglist__5484) {
        var a = cljs.core.first(arglist__5484);
        arglist__5484 = cljs.core.next(arglist__5484);
        var b = cljs.core.first(arglist__5484);
        arglist__5484 = cljs.core.next(arglist__5484);
        var c = cljs.core.first(arglist__5484);
        var ds = cljs.core.rest(arglist__5484);
        return G__5482__delegate(a, b, c, ds);
      };
      G__5482.cljs$core$IFn$_invoke$arity$variadic = G__5482__delegate;
      return G__5482;
    }();
    G__5481 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 2:
          return G__5481__2.call(this, a, b);
        case 3:
          return G__5481__3.call(this, a, b, c);
        default:
          var G__5485 = null;
          if (arguments.length > 3) {
            var G__5486__i = 0, G__5486__a = new Array(arguments.length - 3);
            while (G__5486__i < G__5486__a.length) {
              G__5486__a[G__5486__i] = arguments[G__5486__i + 3];
              ++G__5486__i;
            }
            G__5485 = new cljs.core.IndexedSeq(G__5486__a, 0, null);
          }
          return G__5481__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__5485);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    G__5481.cljs$lang$maxFixedArity = 3;
    G__5481.cljs$lang$applyTo = G__5481__4.cljs$lang$applyTo;
    G__5481.cljs$core$IFn$_invoke$arity$2 = G__5481__2;
    G__5481.cljs$core$IFn$_invoke$arity$3 = G__5481__3;
    G__5481.cljs$core$IFn$_invoke$arity$variadic = G__5481__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__5481;
  }();
};
cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = function(f, x, y, z) {
  return function() {
    var G__5487 = null;
    var G__5487__2 = function(a, b) {
      var G__5469 = a == null ? x : a;
      var G__5470 = b == null ? y : b;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5469, G__5470) : f.call(null, G__5469, G__5470);
    };
    var G__5487__3 = function(a, b, c) {
      var G__5471 = a == null ? x : a;
      var G__5472 = b == null ? y : b;
      var G__5473 = c == null ? z : c;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__5471, G__5472, G__5473) : f.call(null, G__5471, G__5472, G__5473);
    };
    var G__5487__4 = function() {
      var G__5488__delegate = function(a, b, c, ds) {
        return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a == null ? x : a, b == null ? y : b, c == null ? z : c, ds);
      };
      var G__5488 = function(a, b, c, var_args) {
        var ds = null;
        if (arguments.length > 3) {
          var G__5489__i = 0, G__5489__a = new Array(arguments.length - 3);
          while (G__5489__i < G__5489__a.length) {
            G__5489__a[G__5489__i] = arguments[G__5489__i + 3];
            ++G__5489__i;
          }
          ds = new cljs.core.IndexedSeq(G__5489__a, 0, null);
        }
        return G__5488__delegate.call(this, a, b, c, ds);
      };
      G__5488.cljs$lang$maxFixedArity = 3;
      G__5488.cljs$lang$applyTo = function(arglist__5490) {
        var a = cljs.core.first(arglist__5490);
        arglist__5490 = cljs.core.next(arglist__5490);
        var b = cljs.core.first(arglist__5490);
        arglist__5490 = cljs.core.next(arglist__5490);
        var c = cljs.core.first(arglist__5490);
        var ds = cljs.core.rest(arglist__5490);
        return G__5488__delegate(a, b, c, ds);
      };
      G__5488.cljs$core$IFn$_invoke$arity$variadic = G__5488__delegate;
      return G__5488;
    }();
    G__5487 = function(a, b, c, var_args) {
      var ds = var_args;
      switch(arguments.length) {
        case 2:
          return G__5487__2.call(this, a, b);
        case 3:
          return G__5487__3.call(this, a, b, c);
        default:
          var G__5491 = null;
          if (arguments.length > 3) {
            var G__5492__i = 0, G__5492__a = new Array(arguments.length - 3);
            while (G__5492__i < G__5492__a.length) {
              G__5492__a[G__5492__i] = arguments[G__5492__i + 3];
              ++G__5492__i;
            }
            G__5491 = new cljs.core.IndexedSeq(G__5492__a, 0, null);
          }
          return G__5487__4.cljs$core$IFn$_invoke$arity$variadic(a, b, c, G__5491);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    G__5487.cljs$lang$maxFixedArity = 3;
    G__5487.cljs$lang$applyTo = G__5487__4.cljs$lang$applyTo;
    G__5487.cljs$core$IFn$_invoke$arity$2 = G__5487__2;
    G__5487.cljs$core$IFn$_invoke$arity$3 = G__5487__3;
    G__5487.cljs$core$IFn$_invoke$arity$variadic = G__5487__4.cljs$core$IFn$_invoke$arity$variadic;
    return G__5487;
  }();
};
cljs.core.fnil.cljs$lang$maxFixedArity = 4;
cljs.core.map_indexed = function cljs$core$map_indexed(var_args) {
  var G__5494 = arguments.length;
  switch(G__5494) {
    case 1:
      return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    var i = cljs.core.volatile_BANG_(-1);
    return function(i) {
      return function() {
        var G__5508 = null;
        var G__5508__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__5508__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__5508__2 = function(result, input) {
          var G__5495 = result;
          var G__5496 = function() {
            var G__5497 = cljs.core._vreset_BANG_(i, cljs.core._deref(i) + 1);
            var G__5498 = input;
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5497, G__5498) : f.call(null, G__5497, G__5498);
          }();
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__5495, G__5496) : rf.call(null, G__5495, G__5496);
        };
        G__5508 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__5508__0.call(this);
            case 1:
              return G__5508__1.call(this, result);
            case 2:
              return G__5508__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + (arguments.length - 1));
        };
        G__5508.cljs$core$IFn$_invoke$arity$0 = G__5508__0;
        G__5508.cljs$core$IFn$_invoke$arity$1 = G__5508__1;
        G__5508.cljs$core$IFn$_invoke$arity$2 = G__5508__2;
        return G__5508;
      }();
    }(i);
  };
};
cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var mapi = function cljs$core$mapi(idx, coll__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__5457__auto__ = cljs.core.seq(coll__$1);
      if (temp__5457__auto__) {
        var s = temp__5457__auto__;
        if (cljs.core.chunked_seq_QMARK_(s)) {
          var c = cljs.core.chunk_first(s);
          var size = cljs.core.count(c);
          var b = cljs.core.chunk_buffer(size);
          var n__4376__auto___5509 = size;
          var i_5510 = 0;
          while (true) {
            if (i_5510 < n__4376__auto___5509) {
              cljs.core.chunk_append(b, function() {
                var G__5503 = idx + i_5510;
                var G__5504 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_5510);
                return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5503, G__5504) : f.call(null, G__5503, G__5504);
              }());
              var G__5511 = i_5510 + 1;
              i_5510 = G__5511;
              continue;
            } else {
            }
            break;
          }
          return cljs.core.chunk_cons(cljs.core.chunk(b), cljs$core$mapi(idx + size, cljs.core.chunk_rest(s)));
        } else {
          return cljs.core.cons(function() {
            var G__5505 = idx;
            var G__5506 = cljs.core.first(s);
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5505, G__5506) : f.call(null, G__5505, G__5506);
          }(), cljs$core$mapi(idx + 1, cljs.core.rest(s)));
        }
      } else {
        return null;
      }
    }, null, null);
  };
  return mapi(0, coll);
};
cljs.core.map_indexed.cljs$lang$maxFixedArity = 2;
cljs.core.keep = function cljs$core$keep(var_args) {
  var G__5513 = arguments.length;
  switch(G__5513) {
    case 1:
      return cljs.core.keep.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    return function() {
      var G__5517 = null;
      var G__5517__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__5517__1 = function(result) {
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
      };
      var G__5517__2 = function(result, input) {
        var v = f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null, input);
        if (v == null) {
          return result;
        } else {
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, v) : rf.call(null, result, v);
        }
      };
      G__5517 = function(result, input) {
        switch(arguments.length) {
          case 0:
            return G__5517__0.call(this);
          case 1:
            return G__5517__1.call(this, result);
          case 2:
            return G__5517__2.call(this, result, input);
        }
        throw new Error("Invalid arity: " + (arguments.length - 1));
      };
      G__5517.cljs$core$IFn$_invoke$arity$0 = G__5517__0;
      G__5517.cljs$core$IFn$_invoke$arity$1 = G__5517__1;
      G__5517.cljs$core$IFn$_invoke$arity$2 = G__5517__2;
      return G__5517;
    }();
  };
};
cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__5457__auto__ = cljs.core.seq(coll);
    if (temp__5457__auto__) {
      var s = temp__5457__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__4376__auto___5518 = size;
        var i_5519 = 0;
        while (true) {
          if (i_5519 < n__4376__auto___5518) {
            var x_5520 = function() {
              var G__5514 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_5519);
              return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__5514) : f.call(null, G__5514);
            }();
            if (x_5520 == null) {
            } else {
              cljs.core.chunk_append(b, x_5520);
            }
            var G__5521 = i_5519 + 1;
            i_5519 = G__5521;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.chunk_rest(s)));
      } else {
        var x = function() {
          var G__5515 = cljs.core.first(s);
          return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__5515) : f.call(null, G__5515);
        }();
        if (x == null) {
          return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s));
        } else {
          return cljs.core.cons(x, cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s)));
        }
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.keep.cljs$lang$maxFixedArity = 2;
cljs.core.Atom = function(state, meta, validator, watches) {
  this.state = state;
  this.meta = meta;
  this.validator = validator;
  this.watches = watches;
  this.cljs$lang$protocol_mask$partition1$ = 16386;
  this.cljs$lang$protocol_mask$partition0$ = 6455296;
};
cljs.core.Atom.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var self__ = this;
  var o__$1 = this;
  return o__$1 === other;
};
cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.state;
};
cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.meta;
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = function(this$, oldval, newval) {
  var self__ = this;
  var this$__$1 = this;
  var seq__5522 = cljs.core.seq(self__.watches);
  var chunk__5523 = null;
  var count__5524 = 0;
  var i__5525 = 0;
  while (true) {
    if (i__5525 < count__5524) {
      var vec__5526 = chunk__5523.cljs$core$IIndexed$_nth$arity$2(null, i__5525);
      var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5526, 0, null);
      var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5526, 1, null);
      f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key, this$__$1, oldval, newval) : f.call(null, key, this$__$1, oldval, newval);
      var G__5532 = seq__5522;
      var G__5533 = chunk__5523;
      var G__5534 = count__5524;
      var G__5535 = i__5525 + 1;
      seq__5522 = G__5532;
      chunk__5523 = G__5533;
      count__5524 = G__5534;
      i__5525 = G__5535;
      continue;
    } else {
      var temp__5457__auto__ = cljs.core.seq(seq__5522);
      if (temp__5457__auto__) {
        var seq__5522__$1 = temp__5457__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__5522__$1)) {
          var c__4319__auto__ = cljs.core.chunk_first(seq__5522__$1);
          var G__5536 = cljs.core.chunk_rest(seq__5522__$1);
          var G__5537 = c__4319__auto__;
          var G__5538 = cljs.core.count(c__4319__auto__);
          var G__5539 = 0;
          seq__5522 = G__5536;
          chunk__5523 = G__5537;
          count__5524 = G__5538;
          i__5525 = G__5539;
          continue;
        } else {
          var vec__5529 = cljs.core.first(seq__5522__$1);
          var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5529, 0, null);
          var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5529, 1, null);
          f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key, this$__$1, oldval, newval) : f.call(null, key, this$__$1, oldval, newval);
          var G__5540 = cljs.core.next(seq__5522__$1);
          var G__5541 = null;
          var G__5542 = 0;
          var G__5543 = 0;
          seq__5522 = G__5540;
          chunk__5523 = G__5541;
          count__5524 = G__5542;
          i__5525 = G__5543;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = function(this$, key, f) {
  var self__ = this;
  var this$__$1 = this;
  this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches, key, f);
  return this$__$1;
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = function(this$, key) {
  var self__ = this;
  var this$__$1 = this;
  return this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches, key);
};
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return goog.getUid(this$__$1);
};
cljs.core.Atom.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "state", "state", -348086572, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "validator", "validator", -325659154, null), new cljs.core.Symbol(null, "watches", "watches", 1367433992, null)], null);
};
cljs.core.Atom.cljs$lang$type = true;
cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom";
cljs.core.Atom.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/Atom");
};
cljs.core.__GT_Atom = function cljs$core$__GT_Atom(state, meta, validator, watches) {
  return new cljs.core.Atom(state, meta, validator, watches);
};
cljs.core.atom = function cljs$core$atom(var_args) {
  var G__5547 = arguments.length;
  switch(G__5547) {
    case 1:
      return cljs.core.atom.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5552 = arguments.length;
      var i__4500__auto___5553 = 0;
      while (true) {
        if (i__4500__auto___5553 < len__4499__auto___5552) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5553]);
          var G__5554 = i__4500__auto___5553 + 1;
          i__4500__auto___5553 = G__5554;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(1), 0, null);
      return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__4515__auto__);
  }
};
cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.Atom(x, null, null, null);
};
cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = function(x, p__5548) {
  var map__5549 = p__5548;
  var map__5549__$1 = (!(map__5549 == null) ? map__5549.cljs$lang$protocol_mask$partition0$ & 64 || cljs.core.PROTOCOL_SENTINEL === map__5549.cljs$core$ISeq$ ? true : false : false) ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map, map__5549) : map__5549;
  var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5549__$1, new cljs.core.Keyword(null, "meta", "meta", 1499536964));
  var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5549__$1, new cljs.core.Keyword(null, "validator", "validator", -1966190681));
  return new cljs.core.Atom(x, meta, validator, null);
};
cljs.core.atom.cljs$lang$applyTo = function(seq5545) {
  var G__5546 = cljs.core.first(seq5545);
  var seq5545__$1 = cljs.core.next(seq5545);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5546, seq5545__$1);
};
cljs.core.atom.cljs$lang$maxFixedArity = 1;
cljs.core.reset_BANG_ = function cljs$core$reset_BANG_(a, new_value) {
  if (a instanceof cljs.core.Atom) {
    var validate = a.validator;
    if (validate == null) {
    } else {
      if (cljs.core.truth_(validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null, new_value))) {
      } else {
        throw new Error("Validator rejected reference state");
      }
    }
    var old_value = a.state;
    a.state = new_value;
    if (a.watches == null) {
    } else {
      cljs.core._notify_watches(a, old_value, new_value);
    }
    return new_value;
  } else {
    return cljs.core._reset_BANG_(a, new_value);
  }
};
cljs.core.reset_vals_BANG_ = function cljs$core$reset_vals_BANG_(a, new_value) {
  var validate = a.validator;
  if (validate == null) {
  } else {
    if (cljs.core.truth_(validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null, new_value))) {
    } else {
      throw new Error("Validator rejected reference state");
    }
  }
  var old_value = a.state;
  a.state = new_value;
  if (a.watches == null) {
  } else {
    cljs.core._notify_watches(a, old_value, new_value);
  }
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_value, new_value], null);
};
cljs.core.swap_BANG_ = function cljs$core$swap_BANG_(var_args) {
  var G__5561 = arguments.length;
  switch(G__5561) {
    case 2:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5569 = arguments.length;
      var i__4500__auto___5570 = 0;
      while (true) {
        if (i__4500__auto___5570 < len__4499__auto___5569) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5570]);
          var G__5571 = i__4500__auto___5570 + 1;
          i__4500__auto___5570 = G__5571;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(4), 0, null);
      return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__4515__auto__);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = function(a, f) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__5562 = a.state;
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__5562) : f.call(null, G__5562);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a, f);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = function(a, f, x) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__5563 = a.state;
      var G__5564 = x;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5563, G__5564) : f.call(null, G__5563, G__5564);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a, f, x);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = function(a, f, x, y) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, function() {
      var G__5565 = a.state;
      var G__5566 = x;
      var G__5567 = y;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__5565, G__5566, G__5567) : f.call(null, G__5565, G__5566, G__5567);
    }());
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a, f, x, y);
  }
};
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(a, f, x, y, more) {
  if (a instanceof cljs.core.Atom) {
    return cljs.core.reset_BANG_(a, cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a.state, x, y, more));
  } else {
    return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a, f, x, y, more);
  }
};
cljs.core.swap_BANG_.cljs$lang$applyTo = function(seq5556) {
  var G__5557 = cljs.core.first(seq5556);
  var seq5556__$1 = cljs.core.next(seq5556);
  var G__5558 = cljs.core.first(seq5556__$1);
  var seq5556__$2 = cljs.core.next(seq5556__$1);
  var G__5559 = cljs.core.first(seq5556__$2);
  var seq5556__$3 = cljs.core.next(seq5556__$2);
  var G__5560 = cljs.core.first(seq5556__$3);
  var seq5556__$4 = cljs.core.next(seq5556__$3);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5557, G__5558, G__5559, G__5560, seq5556__$4);
};
cljs.core.swap_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.swap_vals_BANG_ = function cljs$core$swap_vals_BANG_(var_args) {
  var G__5578 = arguments.length;
  switch(G__5578) {
    case 2:
      return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5586 = arguments.length;
      var i__4500__auto___5587 = 0;
      while (true) {
        if (i__4500__auto___5587 < len__4499__auto___5586) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5587]);
          var G__5588 = i__4500__auto___5587 + 1;
          i__4500__auto___5587 = G__5588;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(4), 0, null);
      return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__4515__auto__);
  }
};
cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$2 = function(a, f) {
  return cljs.core.reset_vals_BANG_(a, function() {
    var G__5579 = a.state;
    return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__5579) : f.call(null, G__5579);
  }());
};
cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$3 = function(a, f, x) {
  return cljs.core.reset_vals_BANG_(a, function() {
    var G__5580 = a.state;
    var G__5581 = x;
    return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5580, G__5581) : f.call(null, G__5580, G__5581);
  }());
};
cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$4 = function(a, f, x, y) {
  return cljs.core.reset_vals_BANG_(a, function() {
    var G__5582 = a.state;
    var G__5583 = x;
    var G__5584 = y;
    return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__5582, G__5583, G__5584) : f.call(null, G__5582, G__5583, G__5584);
  }());
};
cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$variadic = function(a, f, x, y, more) {
  return cljs.core.reset_vals_BANG_(a, cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f, a.state, x, y, more));
};
cljs.core.swap_vals_BANG_.cljs$lang$applyTo = function(seq5573) {
  var G__5574 = cljs.core.first(seq5573);
  var seq5573__$1 = cljs.core.next(seq5573);
  var G__5575 = cljs.core.first(seq5573__$1);
  var seq5573__$2 = cljs.core.next(seq5573__$1);
  var G__5576 = cljs.core.first(seq5573__$2);
  var seq5573__$3 = cljs.core.next(seq5573__$2);
  var G__5577 = cljs.core.first(seq5573__$3);
  var seq5573__$4 = cljs.core.next(seq5573__$3);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5574, G__5575, G__5576, G__5577, seq5573__$4);
};
cljs.core.swap_vals_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.compare_and_set_BANG_ = function cljs$core$compare_and_set_BANG_(a, oldval, newval) {
  if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null), oldval)) {
    cljs.core.reset_BANG_(a, newval);
    return true;
  } else {
    return false;
  }
};
cljs.core.set_validator_BANG_ = function cljs$core$set_validator_BANG_(iref, val) {
  if (!(val == null) && cljs.core.not(function() {
    var G__5590 = cljs.core._deref(iref);
    return val.cljs$core$IFn$_invoke$arity$1 ? val.cljs$core$IFn$_invoke$arity$1(G__5590) : val.call(null, G__5590);
  }())) {
    throw new Error("Validator rejected reference state");
  } else {
  }
  return iref.validator = val;
};
cljs.core.get_validator = function cljs$core$get_validator(iref) {
  return iref.validator;
};
cljs.core.Volatile = function(state) {
  this.state = state;
  this.cljs$lang$protocol_mask$partition0$ = 32768;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.Volatile.prototype.cljs$core$IVolatile$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = function(_, new_state) {
  var self__ = this;
  var ___$1 = this;
  return self__.state = new_state;
};
cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return self__.state;
};
cljs.core.Volatile.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "state", "state", -348086572, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.Volatile.cljs$lang$type = true;
cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile";
cljs.core.Volatile.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/Volatile");
};
cljs.core.__GT_Volatile = function cljs$core$__GT_Volatile(state) {
  return new cljs.core.Volatile(state);
};
cljs.core.volatile_BANG_ = function cljs$core$volatile_BANG_(val) {
  return new cljs.core.Volatile(val);
};
cljs.core.volatile_QMARK_ = function cljs$core$volatile_QMARK_(x) {
  return x instanceof cljs.core.Volatile;
};
cljs.core.vreset_BANG_ = function cljs$core$vreset_BANG_(vol, newval) {
  return cljs.core._vreset_BANG_(vol, newval);
};
cljs.core.keep_indexed = function cljs$core$keep_indexed(var_args) {
  var G__5592 = arguments.length;
  switch(G__5592) {
    case 1:
      return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    var ia = cljs.core.volatile_BANG_(-1);
    return function(ia) {
      return function() {
        var G__5602 = null;
        var G__5602__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__5602__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__5602__2 = function(result, input) {
          var i = cljs.core._vreset_BANG_(ia, cljs.core._deref(ia) + 1);
          var v = f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(i, input) : f.call(null, i, input);
          if (v == null) {
            return result;
          } else {
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, v) : rf.call(null, result, v);
          }
        };
        G__5602 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__5602__0.call(this);
            case 1:
              return G__5602__1.call(this, result);
            case 2:
              return G__5602__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + (arguments.length - 1));
        };
        G__5602.cljs$core$IFn$_invoke$arity$0 = G__5602__0;
        G__5602.cljs$core$IFn$_invoke$arity$1 = G__5602__1;
        G__5602.cljs$core$IFn$_invoke$arity$2 = G__5602__2;
        return G__5602;
      }();
    }(ia);
  };
};
cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  var keepi = function cljs$core$keepi(idx, coll__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__5457__auto__ = cljs.core.seq(coll__$1);
      if (temp__5457__auto__) {
        var s = temp__5457__auto__;
        if (cljs.core.chunked_seq_QMARK_(s)) {
          var c = cljs.core.chunk_first(s);
          var size = cljs.core.count(c);
          var b = cljs.core.chunk_buffer(size);
          var n__4376__auto___5603 = size;
          var i_5604 = 0;
          while (true) {
            if (i_5604 < n__4376__auto___5603) {
              var x_5605 = function() {
                var G__5597 = idx + i_5604;
                var G__5598 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_5604);
                return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5597, G__5598) : f.call(null, G__5597, G__5598);
              }();
              if (x_5605 == null) {
              } else {
                cljs.core.chunk_append(b, x_5605);
              }
              var G__5606 = i_5604 + 1;
              i_5604 = G__5606;
              continue;
            } else {
            }
            break;
          }
          return cljs.core.chunk_cons(cljs.core.chunk(b), cljs$core$keepi(idx + size, cljs.core.chunk_rest(s)));
        } else {
          var x = function() {
            var G__5599 = idx;
            var G__5600 = cljs.core.first(s);
            return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5599, G__5600) : f.call(null, G__5599, G__5600);
          }();
          if (x == null) {
            return cljs$core$keepi(idx + 1, cljs.core.rest(s));
          } else {
            return cljs.core.cons(x, cljs$core$keepi(idx + 1, cljs.core.rest(s)));
          }
        }
      } else {
        return null;
      }
    }, null, null);
  };
  return keepi(0, coll);
};
cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2;
cljs.core.every_pred = function cljs$core$every_pred(var_args) {
  var G__5618 = arguments.length;
  switch(G__5618) {
    case 1:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5620 = arguments.length;
      var i__4500__auto___5621 = 0;
      while (true) {
        if (i__4500__auto___5621 < len__4499__auto___5620) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5621]);
          var G__5622 = i__4500__auto___5621 + 1;
          i__4500__auto___5621 = G__5622;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(3), 0, null);
      return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__4515__auto__);
  }
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = function(p) {
  return function() {
    var cljs$core$ep1 = null;
    var cljs$core$ep1__0 = function() {
      return true;
    };
    var cljs$core$ep1__1 = function(x) {
      return cljs.core.boolean$(p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x));
    };
    var cljs$core$ep1__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__3911__auto__ = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x);
        if (cljs.core.truth_(and__3911__auto__)) {
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null, y);
        } else {
          return and__3911__auto__;
        }
      }());
    };
    var cljs$core$ep1__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__3911__auto__ = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x);
        if (cljs.core.truth_(and__3911__auto__)) {
          var and__3911__auto____$1 = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null, y);
          if (cljs.core.truth_(and__3911__auto____$1)) {
            return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null, z);
          } else {
            return and__3911__auto____$1;
          }
        } else {
          return and__3911__auto__;
        }
      }());
    };
    var cljs$core$ep1__4 = function() {
      var G__5623__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__3911__auto__ = cljs$core$ep1.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__3911__auto__)) {
            return cljs.core.every_QMARK_(p, args);
          } else {
            return and__3911__auto__;
          }
        }());
      };
      var G__5623 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__5624__i = 0, G__5624__a = new Array(arguments.length - 3);
          while (G__5624__i < G__5624__a.length) {
            G__5624__a[G__5624__i] = arguments[G__5624__i + 3];
            ++G__5624__i;
          }
          args = new cljs.core.IndexedSeq(G__5624__a, 0, null);
        }
        return G__5623__delegate.call(this, x, y, z, args);
      };
      G__5623.cljs$lang$maxFixedArity = 3;
      G__5623.cljs$lang$applyTo = function(arglist__5625) {
        var x = cljs.core.first(arglist__5625);
        arglist__5625 = cljs.core.next(arglist__5625);
        var y = cljs.core.first(arglist__5625);
        arglist__5625 = cljs.core.next(arglist__5625);
        var z = cljs.core.first(arglist__5625);
        var args = cljs.core.rest(arglist__5625);
        return G__5623__delegate(x, y, z, args);
      };
      G__5623.cljs$core$IFn$_invoke$arity$variadic = G__5623__delegate;
      return G__5623;
    }();
    cljs$core$ep1 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep1__0.call(this);
        case 1:
          return cljs$core$ep1__1.call(this, x);
        case 2:
          return cljs$core$ep1__2.call(this, x, y);
        case 3:
          return cljs$core$ep1__3.call(this, x, y, z);
        default:
          var G__5626 = null;
          if (arguments.length > 3) {
            var G__5627__i = 0, G__5627__a = new Array(arguments.length - 3);
            while (G__5627__i < G__5627__a.length) {
              G__5627__a[G__5627__i] = arguments[G__5627__i + 3];
              ++G__5627__i;
            }
            G__5626 = new cljs.core.IndexedSeq(G__5627__a, 0, null);
          }
          return cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__5626);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    cljs$core$ep1.cljs$lang$maxFixedArity = 3;
    cljs$core$ep1.cljs$lang$applyTo = cljs$core$ep1__4.cljs$lang$applyTo;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep1__0;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep1__1;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep1__2;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep1__3;
    cljs$core$ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep1;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = function(p1, p2) {
  return function() {
    var cljs$core$ep2 = null;
    var cljs$core$ep2__0 = function() {
      return true;
    };
    var cljs$core$ep2__1 = function(x) {
      return cljs.core.boolean$(function() {
        var and__3911__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__3911__auto__)) {
          return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
        } else {
          return and__3911__auto__;
        }
      }());
    };
    var cljs$core$ep2__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__3911__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__3911__auto__)) {
          var and__3911__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
          if (cljs.core.truth_(and__3911__auto____$1)) {
            var and__3911__auto____$2 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
            if (cljs.core.truth_(and__3911__auto____$2)) {
              return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
            } else {
              return and__3911__auto____$2;
            }
          } else {
            return and__3911__auto____$1;
          }
        } else {
          return and__3911__auto__;
        }
      }());
    };
    var cljs$core$ep2__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__3911__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__3911__auto__)) {
          var and__3911__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
          if (cljs.core.truth_(and__3911__auto____$1)) {
            var and__3911__auto____$2 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null, z);
            if (cljs.core.truth_(and__3911__auto____$2)) {
              var and__3911__auto____$3 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
              if (cljs.core.truth_(and__3911__auto____$3)) {
                var and__3911__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
                if (cljs.core.truth_(and__3911__auto____$4)) {
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null, z);
                } else {
                  return and__3911__auto____$4;
                }
              } else {
                return and__3911__auto____$3;
              }
            } else {
              return and__3911__auto____$2;
            }
          } else {
            return and__3911__auto____$1;
          }
        } else {
          return and__3911__auto__;
        }
      }());
    };
    var cljs$core$ep2__4 = function() {
      var G__5628__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__3911__auto__ = cljs$core$ep2.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__3911__auto__)) {
            return cljs.core.every_QMARK_(function(and__3911__auto__) {
              return function(p1__5607_SHARP_) {
                var and__3911__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__5607_SHARP_) : p1.call(null, p1__5607_SHARP_);
                if (cljs.core.truth_(and__3911__auto____$1)) {
                  return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__5607_SHARP_) : p2.call(null, p1__5607_SHARP_);
                } else {
                  return and__3911__auto____$1;
                }
              };
            }(and__3911__auto__), args);
          } else {
            return and__3911__auto__;
          }
        }());
      };
      var G__5628 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__5629__i = 0, G__5629__a = new Array(arguments.length - 3);
          while (G__5629__i < G__5629__a.length) {
            G__5629__a[G__5629__i] = arguments[G__5629__i + 3];
            ++G__5629__i;
          }
          args = new cljs.core.IndexedSeq(G__5629__a, 0, null);
        }
        return G__5628__delegate.call(this, x, y, z, args);
      };
      G__5628.cljs$lang$maxFixedArity = 3;
      G__5628.cljs$lang$applyTo = function(arglist__5630) {
        var x = cljs.core.first(arglist__5630);
        arglist__5630 = cljs.core.next(arglist__5630);
        var y = cljs.core.first(arglist__5630);
        arglist__5630 = cljs.core.next(arglist__5630);
        var z = cljs.core.first(arglist__5630);
        var args = cljs.core.rest(arglist__5630);
        return G__5628__delegate(x, y, z, args);
      };
      G__5628.cljs$core$IFn$_invoke$arity$variadic = G__5628__delegate;
      return G__5628;
    }();
    cljs$core$ep2 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep2__0.call(this);
        case 1:
          return cljs$core$ep2__1.call(this, x);
        case 2:
          return cljs$core$ep2__2.call(this, x, y);
        case 3:
          return cljs$core$ep2__3.call(this, x, y, z);
        default:
          var G__5631 = null;
          if (arguments.length > 3) {
            var G__5632__i = 0, G__5632__a = new Array(arguments.length - 3);
            while (G__5632__i < G__5632__a.length) {
              G__5632__a[G__5632__i] = arguments[G__5632__i + 3];
              ++G__5632__i;
            }
            G__5631 = new cljs.core.IndexedSeq(G__5632__a, 0, null);
          }
          return cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__5631);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    cljs$core$ep2.cljs$lang$maxFixedArity = 3;
    cljs$core$ep2.cljs$lang$applyTo = cljs$core$ep2__4.cljs$lang$applyTo;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep2__0;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep2__1;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep2__2;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep2__3;
    cljs$core$ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep2;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = function(p1, p2, p3) {
  return function() {
    var cljs$core$ep3 = null;
    var cljs$core$ep3__0 = function() {
      return true;
    };
    var cljs$core$ep3__1 = function(x) {
      return cljs.core.boolean$(function() {
        var and__3911__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__3911__auto__)) {
          var and__3911__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
          if (cljs.core.truth_(and__3911__auto____$1)) {
            return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
          } else {
            return and__3911__auto____$1;
          }
        } else {
          return and__3911__auto__;
        }
      }());
    };
    var cljs$core$ep3__2 = function(x, y) {
      return cljs.core.boolean$(function() {
        var and__3911__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__3911__auto__)) {
          var and__3911__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
          if (cljs.core.truth_(and__3911__auto____$1)) {
            var and__3911__auto____$2 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
            if (cljs.core.truth_(and__3911__auto____$2)) {
              var and__3911__auto____$3 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
              if (cljs.core.truth_(and__3911__auto____$3)) {
                var and__3911__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
                if (cljs.core.truth_(and__3911__auto____$4)) {
                  return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null, y);
                } else {
                  return and__3911__auto____$4;
                }
              } else {
                return and__3911__auto____$3;
              }
            } else {
              return and__3911__auto____$2;
            }
          } else {
            return and__3911__auto____$1;
          }
        } else {
          return and__3911__auto__;
        }
      }());
    };
    var cljs$core$ep3__3 = function(x, y, z) {
      return cljs.core.boolean$(function() {
        var and__3911__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
        if (cljs.core.truth_(and__3911__auto__)) {
          var and__3911__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
          if (cljs.core.truth_(and__3911__auto____$1)) {
            var and__3911__auto____$2 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
            if (cljs.core.truth_(and__3911__auto____$2)) {
              var and__3911__auto____$3 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
              if (cljs.core.truth_(and__3911__auto____$3)) {
                var and__3911__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
                if (cljs.core.truth_(and__3911__auto____$4)) {
                  var and__3911__auto____$5 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null, y);
                  if (cljs.core.truth_(and__3911__auto____$5)) {
                    var and__3911__auto____$6 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null, z);
                    if (cljs.core.truth_(and__3911__auto____$6)) {
                      var and__3911__auto____$7 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null, z);
                      if (cljs.core.truth_(and__3911__auto____$7)) {
                        return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null, z);
                      } else {
                        return and__3911__auto____$7;
                      }
                    } else {
                      return and__3911__auto____$6;
                    }
                  } else {
                    return and__3911__auto____$5;
                  }
                } else {
                  return and__3911__auto____$4;
                }
              } else {
                return and__3911__auto____$3;
              }
            } else {
              return and__3911__auto____$2;
            }
          } else {
            return and__3911__auto____$1;
          }
        } else {
          return and__3911__auto__;
        }
      }());
    };
    var cljs$core$ep3__4 = function() {
      var G__5633__delegate = function(x, y, z, args) {
        return cljs.core.boolean$(function() {
          var and__3911__auto__ = cljs$core$ep3.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(and__3911__auto__)) {
            return cljs.core.every_QMARK_(function(and__3911__auto__) {
              return function(p1__5608_SHARP_) {
                var and__3911__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__5608_SHARP_) : p1.call(null, p1__5608_SHARP_);
                if (cljs.core.truth_(and__3911__auto____$1)) {
                  var and__3911__auto____$2 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__5608_SHARP_) : p2.call(null, p1__5608_SHARP_);
                  if (cljs.core.truth_(and__3911__auto____$2)) {
                    return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__5608_SHARP_) : p3.call(null, p1__5608_SHARP_);
                  } else {
                    return and__3911__auto____$2;
                  }
                } else {
                  return and__3911__auto____$1;
                }
              };
            }(and__3911__auto__), args);
          } else {
            return and__3911__auto__;
          }
        }());
      };
      var G__5633 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__5634__i = 0, G__5634__a = new Array(arguments.length - 3);
          while (G__5634__i < G__5634__a.length) {
            G__5634__a[G__5634__i] = arguments[G__5634__i + 3];
            ++G__5634__i;
          }
          args = new cljs.core.IndexedSeq(G__5634__a, 0, null);
        }
        return G__5633__delegate.call(this, x, y, z, args);
      };
      G__5633.cljs$lang$maxFixedArity = 3;
      G__5633.cljs$lang$applyTo = function(arglist__5635) {
        var x = cljs.core.first(arglist__5635);
        arglist__5635 = cljs.core.next(arglist__5635);
        var y = cljs.core.first(arglist__5635);
        arglist__5635 = cljs.core.next(arglist__5635);
        var z = cljs.core.first(arglist__5635);
        var args = cljs.core.rest(arglist__5635);
        return G__5633__delegate(x, y, z, args);
      };
      G__5633.cljs$core$IFn$_invoke$arity$variadic = G__5633__delegate;
      return G__5633;
    }();
    cljs$core$ep3 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$ep3__0.call(this);
        case 1:
          return cljs$core$ep3__1.call(this, x);
        case 2:
          return cljs$core$ep3__2.call(this, x, y);
        case 3:
          return cljs$core$ep3__3.call(this, x, y, z);
        default:
          var G__5636 = null;
          if (arguments.length > 3) {
            var G__5637__i = 0, G__5637__a = new Array(arguments.length - 3);
            while (G__5637__i < G__5637__a.length) {
              G__5637__a[G__5637__i] = arguments[G__5637__i + 3];
              ++G__5637__i;
            }
            G__5636 = new cljs.core.IndexedSeq(G__5637__a, 0, null);
          }
          return cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__5636);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    cljs$core$ep3.cljs$lang$maxFixedArity = 3;
    cljs$core$ep3.cljs$lang$applyTo = cljs$core$ep3__4.cljs$lang$applyTo;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep3__0;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep3__1;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep3__2;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep3__3;
    cljs$core$ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$ep3;
  }();
};
cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = function(p1, p2, p3, ps) {
  var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1, p2, p3, ps);
  return function(ps__$1) {
    return function() {
      var cljs$core$epn = null;
      var cljs$core$epn__0 = function() {
        return true;
      };
      var cljs$core$epn__1 = function(x) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__5609_SHARP_) {
            return p1__5609_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__5609_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__5609_SHARP_.call(null, x);
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__2 = function(x, y) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__5610_SHARP_) {
            var and__3911__auto__ = p1__5610_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__5610_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__5610_SHARP_.call(null, x);
            if (cljs.core.truth_(and__3911__auto__)) {
              return p1__5610_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__5610_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__5610_SHARP_.call(null, y);
            } else {
              return and__3911__auto__;
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__3 = function(x, y, z) {
        return cljs.core.every_QMARK_(function(ps__$1) {
          return function(p1__5611_SHARP_) {
            var and__3911__auto__ = p1__5611_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__5611_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__5611_SHARP_.call(null, x);
            if (cljs.core.truth_(and__3911__auto__)) {
              var and__3911__auto____$1 = p1__5611_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__5611_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__5611_SHARP_.call(null, y);
              if (cljs.core.truth_(and__3911__auto____$1)) {
                return p1__5611_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__5611_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__5611_SHARP_.call(null, z);
              } else {
                return and__3911__auto____$1;
              }
            } else {
              return and__3911__auto__;
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$epn__4 = function() {
        var G__5638__delegate = function(x, y, z, args) {
          return cljs.core.boolean$(function() {
            var and__3911__auto__ = cljs$core$epn.cljs$core$IFn$_invoke$arity$3(x, y, z);
            if (cljs.core.truth_(and__3911__auto__)) {
              return cljs.core.every_QMARK_(function(and__3911__auto__, ps__$1) {
                return function(p1__5612_SHARP_) {
                  return cljs.core.every_QMARK_(p1__5612_SHARP_, args);
                };
              }(and__3911__auto__, ps__$1), ps__$1);
            } else {
              return and__3911__auto__;
            }
          }());
        };
        var G__5638 = function(x, y, z, var_args) {
          var args = null;
          if (arguments.length > 3) {
            var G__5639__i = 0, G__5639__a = new Array(arguments.length - 3);
            while (G__5639__i < G__5639__a.length) {
              G__5639__a[G__5639__i] = arguments[G__5639__i + 3];
              ++G__5639__i;
            }
            args = new cljs.core.IndexedSeq(G__5639__a, 0, null);
          }
          return G__5638__delegate.call(this, x, y, z, args);
        };
        G__5638.cljs$lang$maxFixedArity = 3;
        G__5638.cljs$lang$applyTo = function(arglist__5640) {
          var x = cljs.core.first(arglist__5640);
          arglist__5640 = cljs.core.next(arglist__5640);
          var y = cljs.core.first(arglist__5640);
          arglist__5640 = cljs.core.next(arglist__5640);
          var z = cljs.core.first(arglist__5640);
          var args = cljs.core.rest(arglist__5640);
          return G__5638__delegate(x, y, z, args);
        };
        G__5638.cljs$core$IFn$_invoke$arity$variadic = G__5638__delegate;
        return G__5638;
      }();
      cljs$core$epn = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return cljs$core$epn__0.call(this);
          case 1:
            return cljs$core$epn__1.call(this, x);
          case 2:
            return cljs$core$epn__2.call(this, x, y);
          case 3:
            return cljs$core$epn__3.call(this, x, y, z);
          default:
            var G__5641 = null;
            if (arguments.length > 3) {
              var G__5642__i = 0, G__5642__a = new Array(arguments.length - 3);
              while (G__5642__i < G__5642__a.length) {
                G__5642__a[G__5642__i] = arguments[G__5642__i + 3];
                ++G__5642__i;
              }
              G__5641 = new cljs.core.IndexedSeq(G__5642__a, 0, null);
            }
            return cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__5641);
        }
        throw new Error("Invalid arity: " + (arguments.length - 1));
      };
      cljs$core$epn.cljs$lang$maxFixedArity = 3;
      cljs$core$epn.cljs$lang$applyTo = cljs$core$epn__4.cljs$lang$applyTo;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$epn__0;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$epn__1;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$epn__2;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$epn__3;
      cljs$core$epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic;
      return cljs$core$epn;
    }();
  }(ps__$1);
};
cljs.core.every_pred.cljs$lang$applyTo = function(seq5614) {
  var G__5615 = cljs.core.first(seq5614);
  var seq5614__$1 = cljs.core.next(seq5614);
  var G__5616 = cljs.core.first(seq5614__$1);
  var seq5614__$2 = cljs.core.next(seq5614__$1);
  var G__5617 = cljs.core.first(seq5614__$2);
  var seq5614__$3 = cljs.core.next(seq5614__$2);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5615, G__5616, G__5617, seq5614__$3);
};
cljs.core.every_pred.cljs$lang$maxFixedArity = 3;
cljs.core.some_fn = function cljs$core$some_fn(var_args) {
  var G__5654 = arguments.length;
  switch(G__5654) {
    case 1:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5656 = arguments.length;
      var i__4500__auto___5657 = 0;
      while (true) {
        if (i__4500__auto___5657 < len__4499__auto___5656) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5657]);
          var G__5658 = i__4500__auto___5657 + 1;
          i__4500__auto___5657 = G__5658;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(3), 0, null);
      return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], argseq__4515__auto__);
  }
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = function(p) {
  return function() {
    var cljs$core$sp1 = null;
    var cljs$core$sp1__0 = function() {
      return null;
    };
    var cljs$core$sp1__1 = function(x) {
      return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x);
    };
    var cljs$core$sp1__2 = function(x, y) {
      var or__3922__auto__ = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x);
      if (cljs.core.truth_(or__3922__auto__)) {
        return or__3922__auto__;
      } else {
        return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null, y);
      }
    };
    var cljs$core$sp1__3 = function(x, y, z) {
      var or__3922__auto__ = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null, x);
      if (cljs.core.truth_(or__3922__auto__)) {
        return or__3922__auto__;
      } else {
        var or__3922__auto____$1 = p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null, y);
        if (cljs.core.truth_(or__3922__auto____$1)) {
          return or__3922__auto____$1;
        } else {
          return p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null, z);
        }
      }
    };
    var cljs$core$sp1__4 = function() {
      var G__5659__delegate = function(x, y, z, args) {
        var or__3922__auto__ = cljs$core$sp1.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__3922__auto__)) {
          return or__3922__auto__;
        } else {
          return cljs.core.some(p, args);
        }
      };
      var G__5659 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__5660__i = 0, G__5660__a = new Array(arguments.length - 3);
          while (G__5660__i < G__5660__a.length) {
            G__5660__a[G__5660__i] = arguments[G__5660__i + 3];
            ++G__5660__i;
          }
          args = new cljs.core.IndexedSeq(G__5660__a, 0, null);
        }
        return G__5659__delegate.call(this, x, y, z, args);
      };
      G__5659.cljs$lang$maxFixedArity = 3;
      G__5659.cljs$lang$applyTo = function(arglist__5661) {
        var x = cljs.core.first(arglist__5661);
        arglist__5661 = cljs.core.next(arglist__5661);
        var y = cljs.core.first(arglist__5661);
        arglist__5661 = cljs.core.next(arglist__5661);
        var z = cljs.core.first(arglist__5661);
        var args = cljs.core.rest(arglist__5661);
        return G__5659__delegate(x, y, z, args);
      };
      G__5659.cljs$core$IFn$_invoke$arity$variadic = G__5659__delegate;
      return G__5659;
    }();
    cljs$core$sp1 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp1__0.call(this);
        case 1:
          return cljs$core$sp1__1.call(this, x);
        case 2:
          return cljs$core$sp1__2.call(this, x, y);
        case 3:
          return cljs$core$sp1__3.call(this, x, y, z);
        default:
          var G__5662 = null;
          if (arguments.length > 3) {
            var G__5663__i = 0, G__5663__a = new Array(arguments.length - 3);
            while (G__5663__i < G__5663__a.length) {
              G__5663__a[G__5663__i] = arguments[G__5663__i + 3];
              ++G__5663__i;
            }
            G__5662 = new cljs.core.IndexedSeq(G__5663__a, 0, null);
          }
          return cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__5662);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    cljs$core$sp1.cljs$lang$maxFixedArity = 3;
    cljs$core$sp1.cljs$lang$applyTo = cljs$core$sp1__4.cljs$lang$applyTo;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp1__0;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp1__1;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp1__2;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp1__3;
    cljs$core$sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp1;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = function(p1, p2) {
  return function() {
    var cljs$core$sp2 = null;
    var cljs$core$sp2__0 = function() {
      return null;
    };
    var cljs$core$sp2__1 = function(x) {
      var or__3922__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__3922__auto__)) {
        return or__3922__auto__;
      } else {
        return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
      }
    };
    var cljs$core$sp2__2 = function(x, y) {
      var or__3922__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__3922__auto__)) {
        return or__3922__auto__;
      } else {
        var or__3922__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
        if (cljs.core.truth_(or__3922__auto____$1)) {
          return or__3922__auto____$1;
        } else {
          var or__3922__auto____$2 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
          if (cljs.core.truth_(or__3922__auto____$2)) {
            return or__3922__auto____$2;
          } else {
            return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
          }
        }
      }
    };
    var cljs$core$sp2__3 = function(x, y, z) {
      var or__3922__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__3922__auto__)) {
        return or__3922__auto__;
      } else {
        var or__3922__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
        if (cljs.core.truth_(or__3922__auto____$1)) {
          return or__3922__auto____$1;
        } else {
          var or__3922__auto____$2 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null, z);
          if (cljs.core.truth_(or__3922__auto____$2)) {
            return or__3922__auto____$2;
          } else {
            var or__3922__auto____$3 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
            if (cljs.core.truth_(or__3922__auto____$3)) {
              return or__3922__auto____$3;
            } else {
              var or__3922__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
              if (cljs.core.truth_(or__3922__auto____$4)) {
                return or__3922__auto____$4;
              } else {
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null, z);
              }
            }
          }
        }
      }
    };
    var cljs$core$sp2__4 = function() {
      var G__5664__delegate = function(x, y, z, args) {
        var or__3922__auto__ = cljs$core$sp2.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__3922__auto__)) {
          return or__3922__auto__;
        } else {
          return cljs.core.some(function(or__3922__auto__) {
            return function(p1__5643_SHARP_) {
              var or__3922__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__5643_SHARP_) : p1.call(null, p1__5643_SHARP_);
              if (cljs.core.truth_(or__3922__auto____$1)) {
                return or__3922__auto____$1;
              } else {
                return p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__5643_SHARP_) : p2.call(null, p1__5643_SHARP_);
              }
            };
          }(or__3922__auto__), args);
        }
      };
      var G__5664 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__5665__i = 0, G__5665__a = new Array(arguments.length - 3);
          while (G__5665__i < G__5665__a.length) {
            G__5665__a[G__5665__i] = arguments[G__5665__i + 3];
            ++G__5665__i;
          }
          args = new cljs.core.IndexedSeq(G__5665__a, 0, null);
        }
        return G__5664__delegate.call(this, x, y, z, args);
      };
      G__5664.cljs$lang$maxFixedArity = 3;
      G__5664.cljs$lang$applyTo = function(arglist__5666) {
        var x = cljs.core.first(arglist__5666);
        arglist__5666 = cljs.core.next(arglist__5666);
        var y = cljs.core.first(arglist__5666);
        arglist__5666 = cljs.core.next(arglist__5666);
        var z = cljs.core.first(arglist__5666);
        var args = cljs.core.rest(arglist__5666);
        return G__5664__delegate(x, y, z, args);
      };
      G__5664.cljs$core$IFn$_invoke$arity$variadic = G__5664__delegate;
      return G__5664;
    }();
    cljs$core$sp2 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp2__0.call(this);
        case 1:
          return cljs$core$sp2__1.call(this, x);
        case 2:
          return cljs$core$sp2__2.call(this, x, y);
        case 3:
          return cljs$core$sp2__3.call(this, x, y, z);
        default:
          var G__5667 = null;
          if (arguments.length > 3) {
            var G__5668__i = 0, G__5668__a = new Array(arguments.length - 3);
            while (G__5668__i < G__5668__a.length) {
              G__5668__a[G__5668__i] = arguments[G__5668__i + 3];
              ++G__5668__i;
            }
            G__5667 = new cljs.core.IndexedSeq(G__5668__a, 0, null);
          }
          return cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__5667);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    cljs$core$sp2.cljs$lang$maxFixedArity = 3;
    cljs$core$sp2.cljs$lang$applyTo = cljs$core$sp2__4.cljs$lang$applyTo;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp2__0;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp2__1;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp2__2;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp2__3;
    cljs$core$sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp2;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = function(p1, p2, p3) {
  return function() {
    var cljs$core$sp3 = null;
    var cljs$core$sp3__0 = function() {
      return null;
    };
    var cljs$core$sp3__1 = function(x) {
      var or__3922__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__3922__auto__)) {
        return or__3922__auto__;
      } else {
        var or__3922__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
        if (cljs.core.truth_(or__3922__auto____$1)) {
          return or__3922__auto____$1;
        } else {
          return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
        }
      }
    };
    var cljs$core$sp3__2 = function(x, y) {
      var or__3922__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__3922__auto__)) {
        return or__3922__auto__;
      } else {
        var or__3922__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
        if (cljs.core.truth_(or__3922__auto____$1)) {
          return or__3922__auto____$1;
        } else {
          var or__3922__auto____$2 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
          if (cljs.core.truth_(or__3922__auto____$2)) {
            return or__3922__auto____$2;
          } else {
            var or__3922__auto____$3 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
            if (cljs.core.truth_(or__3922__auto____$3)) {
              return or__3922__auto____$3;
            } else {
              var or__3922__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
              if (cljs.core.truth_(or__3922__auto____$4)) {
                return or__3922__auto____$4;
              } else {
                return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null, y);
              }
            }
          }
        }
      }
    };
    var cljs$core$sp3__3 = function(x, y, z) {
      var or__3922__auto__ = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null, x);
      if (cljs.core.truth_(or__3922__auto__)) {
        return or__3922__auto__;
      } else {
        var or__3922__auto____$1 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null, x);
        if (cljs.core.truth_(or__3922__auto____$1)) {
          return or__3922__auto____$1;
        } else {
          var or__3922__auto____$2 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null, x);
          if (cljs.core.truth_(or__3922__auto____$2)) {
            return or__3922__auto____$2;
          } else {
            var or__3922__auto____$3 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null, y);
            if (cljs.core.truth_(or__3922__auto____$3)) {
              return or__3922__auto____$3;
            } else {
              var or__3922__auto____$4 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null, y);
              if (cljs.core.truth_(or__3922__auto____$4)) {
                return or__3922__auto____$4;
              } else {
                var or__3922__auto____$5 = p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null, y);
                if (cljs.core.truth_(or__3922__auto____$5)) {
                  return or__3922__auto____$5;
                } else {
                  var or__3922__auto____$6 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null, z);
                  if (cljs.core.truth_(or__3922__auto____$6)) {
                    return or__3922__auto____$6;
                  } else {
                    var or__3922__auto____$7 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null, z);
                    if (cljs.core.truth_(or__3922__auto____$7)) {
                      return or__3922__auto____$7;
                    } else {
                      return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null, z);
                    }
                  }
                }
              }
            }
          }
        }
      }
    };
    var cljs$core$sp3__4 = function() {
      var G__5669__delegate = function(x, y, z, args) {
        var or__3922__auto__ = cljs$core$sp3.cljs$core$IFn$_invoke$arity$3(x, y, z);
        if (cljs.core.truth_(or__3922__auto__)) {
          return or__3922__auto__;
        } else {
          return cljs.core.some(function(or__3922__auto__) {
            return function(p1__5644_SHARP_) {
              var or__3922__auto____$1 = p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__5644_SHARP_) : p1.call(null, p1__5644_SHARP_);
              if (cljs.core.truth_(or__3922__auto____$1)) {
                return or__3922__auto____$1;
              } else {
                var or__3922__auto____$2 = p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__5644_SHARP_) : p2.call(null, p1__5644_SHARP_);
                if (cljs.core.truth_(or__3922__auto____$2)) {
                  return or__3922__auto____$2;
                } else {
                  return p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__5644_SHARP_) : p3.call(null, p1__5644_SHARP_);
                }
              }
            };
          }(or__3922__auto__), args);
        }
      };
      var G__5669 = function(x, y, z, var_args) {
        var args = null;
        if (arguments.length > 3) {
          var G__5670__i = 0, G__5670__a = new Array(arguments.length - 3);
          while (G__5670__i < G__5670__a.length) {
            G__5670__a[G__5670__i] = arguments[G__5670__i + 3];
            ++G__5670__i;
          }
          args = new cljs.core.IndexedSeq(G__5670__a, 0, null);
        }
        return G__5669__delegate.call(this, x, y, z, args);
      };
      G__5669.cljs$lang$maxFixedArity = 3;
      G__5669.cljs$lang$applyTo = function(arglist__5671) {
        var x = cljs.core.first(arglist__5671);
        arglist__5671 = cljs.core.next(arglist__5671);
        var y = cljs.core.first(arglist__5671);
        arglist__5671 = cljs.core.next(arglist__5671);
        var z = cljs.core.first(arglist__5671);
        var args = cljs.core.rest(arglist__5671);
        return G__5669__delegate(x, y, z, args);
      };
      G__5669.cljs$core$IFn$_invoke$arity$variadic = G__5669__delegate;
      return G__5669;
    }();
    cljs$core$sp3 = function(x, y, z, var_args) {
      var args = var_args;
      switch(arguments.length) {
        case 0:
          return cljs$core$sp3__0.call(this);
        case 1:
          return cljs$core$sp3__1.call(this, x);
        case 2:
          return cljs$core$sp3__2.call(this, x, y);
        case 3:
          return cljs$core$sp3__3.call(this, x, y, z);
        default:
          var G__5672 = null;
          if (arguments.length > 3) {
            var G__5673__i = 0, G__5673__a = new Array(arguments.length - 3);
            while (G__5673__i < G__5673__a.length) {
              G__5673__a[G__5673__i] = arguments[G__5673__i + 3];
              ++G__5673__i;
            }
            G__5672 = new cljs.core.IndexedSeq(G__5673__a, 0, null);
          }
          return cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__5672);
      }
      throw new Error("Invalid arity: " + (arguments.length - 1));
    };
    cljs$core$sp3.cljs$lang$maxFixedArity = 3;
    cljs$core$sp3.cljs$lang$applyTo = cljs$core$sp3__4.cljs$lang$applyTo;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp3__0;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp3__1;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp3__2;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp3__3;
    cljs$core$sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic;
    return cljs$core$sp3;
  }();
};
cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = function(p1, p2, p3, ps) {
  var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1, p2, p3, ps);
  return function(ps__$1) {
    return function() {
      var cljs$core$spn = null;
      var cljs$core$spn__0 = function() {
        return null;
      };
      var cljs$core$spn__1 = function(x) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__5645_SHARP_) {
            return p1__5645_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__5645_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__5645_SHARP_.call(null, x);
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__2 = function(x, y) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__5646_SHARP_) {
            var or__3922__auto__ = p1__5646_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__5646_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__5646_SHARP_.call(null, x);
            if (cljs.core.truth_(or__3922__auto__)) {
              return or__3922__auto__;
            } else {
              return p1__5646_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__5646_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__5646_SHARP_.call(null, y);
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__3 = function(x, y, z) {
        return cljs.core.some(function(ps__$1) {
          return function(p1__5647_SHARP_) {
            var or__3922__auto__ = p1__5647_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__5647_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__5647_SHARP_.call(null, x);
            if (cljs.core.truth_(or__3922__auto__)) {
              return or__3922__auto__;
            } else {
              var or__3922__auto____$1 = p1__5647_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__5647_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__5647_SHARP_.call(null, y);
              if (cljs.core.truth_(or__3922__auto____$1)) {
                return or__3922__auto____$1;
              } else {
                return p1__5647_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__5647_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__5647_SHARP_.call(null, z);
              }
            }
          };
        }(ps__$1), ps__$1);
      };
      var cljs$core$spn__4 = function() {
        var G__5674__delegate = function(x, y, z, args) {
          var or__3922__auto__ = cljs$core$spn.cljs$core$IFn$_invoke$arity$3(x, y, z);
          if (cljs.core.truth_(or__3922__auto__)) {
            return or__3922__auto__;
          } else {
            return cljs.core.some(function(or__3922__auto__, ps__$1) {
              return function(p1__5648_SHARP_) {
                return cljs.core.some(p1__5648_SHARP_, args);
              };
            }(or__3922__auto__, ps__$1), ps__$1);
          }
        };
        var G__5674 = function(x, y, z, var_args) {
          var args = null;
          if (arguments.length > 3) {
            var G__5675__i = 0, G__5675__a = new Array(arguments.length - 3);
            while (G__5675__i < G__5675__a.length) {
              G__5675__a[G__5675__i] = arguments[G__5675__i + 3];
              ++G__5675__i;
            }
            args = new cljs.core.IndexedSeq(G__5675__a, 0, null);
          }
          return G__5674__delegate.call(this, x, y, z, args);
        };
        G__5674.cljs$lang$maxFixedArity = 3;
        G__5674.cljs$lang$applyTo = function(arglist__5676) {
          var x = cljs.core.first(arglist__5676);
          arglist__5676 = cljs.core.next(arglist__5676);
          var y = cljs.core.first(arglist__5676);
          arglist__5676 = cljs.core.next(arglist__5676);
          var z = cljs.core.first(arglist__5676);
          var args = cljs.core.rest(arglist__5676);
          return G__5674__delegate(x, y, z, args);
        };
        G__5674.cljs$core$IFn$_invoke$arity$variadic = G__5674__delegate;
        return G__5674;
      }();
      cljs$core$spn = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return cljs$core$spn__0.call(this);
          case 1:
            return cljs$core$spn__1.call(this, x);
          case 2:
            return cljs$core$spn__2.call(this, x, y);
          case 3:
            return cljs$core$spn__3.call(this, x, y, z);
          default:
            var G__5677 = null;
            if (arguments.length > 3) {
              var G__5678__i = 0, G__5678__a = new Array(arguments.length - 3);
              while (G__5678__i < G__5678__a.length) {
                G__5678__a[G__5678__i] = arguments[G__5678__i + 3];
                ++G__5678__i;
              }
              G__5677 = new cljs.core.IndexedSeq(G__5678__a, 0, null);
            }
            return cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic(x, y, z, G__5677);
        }
        throw new Error("Invalid arity: " + (arguments.length - 1));
      };
      cljs$core$spn.cljs$lang$maxFixedArity = 3;
      cljs$core$spn.cljs$lang$applyTo = cljs$core$spn__4.cljs$lang$applyTo;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$spn__0;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$spn__1;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$spn__2;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$spn__3;
      cljs$core$spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic;
      return cljs$core$spn;
    }();
  }(ps__$1);
};
cljs.core.some_fn.cljs$lang$applyTo = function(seq5650) {
  var G__5651 = cljs.core.first(seq5650);
  var seq5650__$1 = cljs.core.next(seq5650);
  var G__5652 = cljs.core.first(seq5650__$1);
  var seq5650__$2 = cljs.core.next(seq5650__$1);
  var G__5653 = cljs.core.first(seq5650__$2);
  var seq5650__$3 = cljs.core.next(seq5650__$2);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5651, G__5652, G__5653, seq5650__$3);
};
cljs.core.some_fn.cljs$lang$maxFixedArity = 3;
cljs.core.map = function cljs$core$map(var_args) {
  var G__5686 = arguments.length;
  switch(G__5686) {
    case 1:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.map.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5699 = arguments.length;
      var i__4500__auto___5700 = 0;
      while (true) {
        if (i__4500__auto___5700 < len__4499__auto___5699) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5700]);
          var G__5701 = i__4500__auto___5700 + 1;
          i__4500__auto___5700 = G__5701;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(4), 0, null);
      return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__4515__auto__);
  }
};
cljs.core.map.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return function(rf) {
    return function() {
      var G__5702 = null;
      var G__5702__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__5702__1 = function(result) {
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
      };
      var G__5702__2 = function(result, input) {
        var G__5687 = result;
        var G__5688 = f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null, input);
        return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__5687, G__5688) : rf.call(null, G__5687, G__5688);
      };
      var G__5702__3 = function() {
        var G__5703__delegate = function(result, input, inputs) {
          var G__5689 = result;
          var G__5690 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f, input, inputs);
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__5689, G__5690) : rf.call(null, G__5689, G__5690);
        };
        var G__5703 = function(result, input, var_args) {
          var inputs = null;
          if (arguments.length > 2) {
            var G__5704__i = 0, G__5704__a = new Array(arguments.length - 2);
            while (G__5704__i < G__5704__a.length) {
              G__5704__a[G__5704__i] = arguments[G__5704__i + 2];
              ++G__5704__i;
            }
            inputs = new cljs.core.IndexedSeq(G__5704__a, 0, null);
          }
          return G__5703__delegate.call(this, result, input, inputs);
        };
        G__5703.cljs$lang$maxFixedArity = 2;
        G__5703.cljs$lang$applyTo = function(arglist__5705) {
          var result = cljs.core.first(arglist__5705);
          arglist__5705 = cljs.core.next(arglist__5705);
          var input = cljs.core.first(arglist__5705);
          var inputs = cljs.core.rest(arglist__5705);
          return G__5703__delegate(result, input, inputs);
        };
        G__5703.cljs$core$IFn$_invoke$arity$variadic = G__5703__delegate;
        return G__5703;
      }();
      G__5702 = function(result, input, var_args) {
        var inputs = var_args;
        switch(arguments.length) {
          case 0:
            return G__5702__0.call(this);
          case 1:
            return G__5702__1.call(this, result);
          case 2:
            return G__5702__2.call(this, result, input);
          default:
            var G__5706 = null;
            if (arguments.length > 2) {
              var G__5707__i = 0, G__5707__a = new Array(arguments.length - 2);
              while (G__5707__i < G__5707__a.length) {
                G__5707__a[G__5707__i] = arguments[G__5707__i + 2];
                ++G__5707__i;
              }
              G__5706 = new cljs.core.IndexedSeq(G__5707__a, 0, null);
            }
            return G__5702__3.cljs$core$IFn$_invoke$arity$variadic(result, input, G__5706);
        }
        throw new Error("Invalid arity: " + (arguments.length - 1));
      };
      G__5702.cljs$lang$maxFixedArity = 2;
      G__5702.cljs$lang$applyTo = G__5702__3.cljs$lang$applyTo;
      G__5702.cljs$core$IFn$_invoke$arity$0 = G__5702__0;
      G__5702.cljs$core$IFn$_invoke$arity$1 = G__5702__1;
      G__5702.cljs$core$IFn$_invoke$arity$2 = G__5702__2;
      G__5702.cljs$core$IFn$_invoke$arity$variadic = G__5702__3.cljs$core$IFn$_invoke$arity$variadic;
      return G__5702;
    }();
  };
};
cljs.core.map.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__5457__auto__ = cljs.core.seq(coll);
    if (temp__5457__auto__) {
      var s = temp__5457__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__4376__auto___5708 = size;
        var i_5709 = 0;
        while (true) {
          if (i_5709 < n__4376__auto___5708) {
            cljs.core.chunk_append(b, function() {
              var G__5691 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_5709);
              return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__5691) : f.call(null, G__5691);
            }());
            var G__5710 = i_5709 + 1;
            i_5709 = G__5710;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.map.cljs$core$IFn$_invoke$arity$2(f, cljs.core.chunk_rest(s)));
      } else {
        return cljs.core.cons(function() {
          var G__5692 = cljs.core.first(s);
          return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__5692) : f.call(null, G__5692);
        }(), cljs.core.map.cljs$core$IFn$_invoke$arity$2(f, cljs.core.rest(s)));
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$3 = function(f, c1, c2) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    if (s1 && s2) {
      return cljs.core.cons(function() {
        var G__5693 = cljs.core.first(s1);
        var G__5694 = cljs.core.first(s2);
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5693, G__5694) : f.call(null, G__5693, G__5694);
      }(), cljs.core.map.cljs$core$IFn$_invoke$arity$3(f, cljs.core.rest(s1), cljs.core.rest(s2)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$4 = function(f, c1, c2, c3) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    var s3 = cljs.core.seq(c3);
    if (s1 && s2 && s3) {
      return cljs.core.cons(function() {
        var G__5695 = cljs.core.first(s1);
        var G__5696 = cljs.core.first(s2);
        var G__5697 = cljs.core.first(s3);
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__5695, G__5696, G__5697) : f.call(null, G__5695, G__5696, G__5697);
      }(), cljs.core.map.cljs$core$IFn$_invoke$arity$4(f, cljs.core.rest(s1), cljs.core.rest(s2), cljs.core.rest(s3)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = function(f, c1, c2, c3, colls) {
  var step = function cljs$core$step(cs) {
    return new cljs.core.LazySeq(null, function() {
      var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq, cs);
      if (cljs.core.every_QMARK_(cljs.core.identity, ss)) {
        return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first, ss), cljs$core$step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest, ss)));
      } else {
        return null;
      }
    }, null, null);
  };
  return cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(step) {
    return function(p1__5679_SHARP_) {
      return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f, p1__5679_SHARP_);
    };
  }(step), step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls, c3, cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c2, c1], 0))));
};
cljs.core.map.cljs$lang$applyTo = function(seq5681) {
  var G__5682 = cljs.core.first(seq5681);
  var seq5681__$1 = cljs.core.next(seq5681);
  var G__5683 = cljs.core.first(seq5681__$1);
  var seq5681__$2 = cljs.core.next(seq5681__$1);
  var G__5684 = cljs.core.first(seq5681__$2);
  var seq5681__$3 = cljs.core.next(seq5681__$2);
  var G__5685 = cljs.core.first(seq5681__$3);
  var seq5681__$4 = cljs.core.next(seq5681__$3);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5682, G__5683, G__5684, G__5685, seq5681__$4);
};
cljs.core.map.cljs$lang$maxFixedArity = 4;
cljs.core.take = function cljs$core$take(var_args) {
  var G__5712 = arguments.length;
  switch(G__5712) {
    case 1:
      return cljs.core.take.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.take.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.take.cljs$core$IFn$_invoke$arity$1 = function(n) {
  if (typeof n === "number") {
  } else {
    throw new Error("Assert failed: (number? n)");
  }
  return function(rf) {
    var na = cljs.core.volatile_BANG_(n);
    return function(na) {
      return function() {
        var G__5714 = null;
        var G__5714__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__5714__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__5714__2 = function(result, input) {
          var n__$1 = cljs.core.deref(na);
          var nn = cljs.core._vreset_BANG_(na, cljs.core._deref(na) - 1);
          var result__$1 = n__$1 > 0 ? rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, input) : rf.call(null, result, input) : result;
          if (!(nn > 0)) {
            return cljs.core.ensure_reduced(result__$1);
          } else {
            return result__$1;
          }
        };
        G__5714 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__5714__0.call(this);
            case 1:
              return G__5714__1.call(this, result);
            case 2:
              return G__5714__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + (arguments.length - 1));
        };
        G__5714.cljs$core$IFn$_invoke$arity$0 = G__5714__0;
        G__5714.cljs$core$IFn$_invoke$arity$1 = G__5714__1;
        G__5714.cljs$core$IFn$_invoke$arity$2 = G__5714__2;
        return G__5714;
      }();
    }(na);
  };
};
cljs.core.take.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  if (typeof n === "number") {
  } else {
    throw new Error("Assert failed: (number? n)");
  }
  return new cljs.core.LazySeq(null, function() {
    if (n > 0) {
      var temp__5457__auto__ = cljs.core.seq(coll);
      if (temp__5457__auto__) {
        var s = temp__5457__auto__;
        return cljs.core.cons(cljs.core.first(s), cljs.core.take.cljs$core$IFn$_invoke$arity$2(n - 1, cljs.core.rest(s)));
      } else {
        return null;
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.take.cljs$lang$maxFixedArity = 2;
cljs.core.drop = function cljs$core$drop(var_args) {
  var G__5716 = arguments.length;
  switch(G__5716) {
    case 1:
      return cljs.core.drop.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = function(n) {
  if (typeof n === "number") {
  } else {
    throw new Error("Assert failed: (number? n)");
  }
  return function(rf) {
    var na = cljs.core.volatile_BANG_(n);
    return function(na) {
      return function() {
        var G__5718 = null;
        var G__5718__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__5718__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__5718__2 = function(result, input) {
          var n__$1 = cljs.core.deref(na);
          cljs.core._vreset_BANG_(na, cljs.core._deref(na) - 1);
          if (n__$1 > 0) {
            return result;
          } else {
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, input) : rf.call(null, result, input);
          }
        };
        G__5718 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__5718__0.call(this);
            case 1:
              return G__5718__1.call(this, result);
            case 2:
              return G__5718__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + (arguments.length - 1));
        };
        G__5718.cljs$core$IFn$_invoke$arity$0 = G__5718__0;
        G__5718.cljs$core$IFn$_invoke$arity$1 = G__5718__1;
        G__5718.cljs$core$IFn$_invoke$arity$2 = G__5718__2;
        return G__5718;
      }();
    }(na);
  };
};
cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  if (typeof n === "number") {
  } else {
    throw new Error("Assert failed: (number? n)");
  }
  var step = function(n__$1, coll__$1) {
    while (true) {
      var s = cljs.core.seq(coll__$1);
      if (n__$1 > 0 && s) {
        var G__5719 = n__$1 - 1;
        var G__5720 = cljs.core.rest(s);
        n__$1 = G__5719;
        coll__$1 = G__5720;
        continue;
      } else {
        return s;
      }
      break;
    }
  };
  return new cljs.core.LazySeq(null, function(step) {
    return function() {
      return step(n, coll);
    };
  }(step), null, null);
};
cljs.core.drop.cljs$lang$maxFixedArity = 2;
cljs.core.drop_last = function cljs$core$drop_last(var_args) {
  var G__5722 = arguments.length;
  switch(G__5722) {
    case 1:
      return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = function(s) {
  return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2(1, s);
};
cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = function(n, s) {
  return cljs.core.map.cljs$core$IFn$_invoke$arity$3(function(x, _) {
    return x;
  }, s, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, s));
};
cljs.core.drop_last.cljs$lang$maxFixedArity = 2;
cljs.core.take_last = function cljs$core$take_last(n, coll) {
  var s = cljs.core.seq(coll);
  var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, coll));
  while (true) {
    if (lead) {
      var G__5724 = cljs.core.next(s);
      var G__5725 = cljs.core.next(lead);
      s = G__5724;
      lead = G__5725;
      continue;
    } else {
      return s;
    }
    break;
  }
};
cljs.core.drop_while = function cljs$core$drop_while(var_args) {
  var G__5727 = arguments.length;
  switch(G__5727) {
    case 1:
      return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return function(rf) {
    var da = cljs.core.volatile_BANG_(true);
    return function(da) {
      return function() {
        var G__5731 = null;
        var G__5731__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__5731__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__5731__2 = function(result, input) {
          var drop_QMARK_ = cljs.core.deref(da);
          if (cljs.core.truth_(function() {
            var and__3911__auto__ = drop_QMARK_;
            if (cljs.core.truth_(and__3911__auto__)) {
              return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null, input);
            } else {
              return and__3911__auto__;
            }
          }())) {
            return result;
          } else {
            cljs.core.vreset_BANG_(da, null);
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, input) : rf.call(null, result, input);
          }
        };
        G__5731 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__5731__0.call(this);
            case 1:
              return G__5731__1.call(this, result);
            case 2:
              return G__5731__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + (arguments.length - 1));
        };
        G__5731.cljs$core$IFn$_invoke$arity$0 = G__5731__0;
        G__5731.cljs$core$IFn$_invoke$arity$1 = G__5731__1;
        G__5731.cljs$core$IFn$_invoke$arity$2 = G__5731__2;
        return G__5731;
      }();
    }(da);
  };
};
cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  var step = function(pred__$1, coll__$1) {
    while (true) {
      var s = cljs.core.seq(coll__$1);
      if (cljs.core.truth_(function() {
        var and__3911__auto__ = s;
        if (and__3911__auto__) {
          var G__5729 = cljs.core.first(s);
          return pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__5729) : pred__$1.call(null, G__5729);
        } else {
          return and__3911__auto__;
        }
      }())) {
        var G__5732 = pred__$1;
        var G__5733 = cljs.core.rest(s);
        pred__$1 = G__5732;
        coll__$1 = G__5733;
        continue;
      } else {
        return s;
      }
      break;
    }
  };
  return new cljs.core.LazySeq(null, function(step) {
    return function() {
      return step(pred, coll);
    };
  }(step), null, null);
};
cljs.core.drop_while.cljs$lang$maxFixedArity = 2;
cljs.core.Cycle = function(meta, all, prev, current, _next) {
  this.meta = meta;
  this.all = all;
  this.prev = prev;
  this.current = current;
  this._next = _next;
  this.cljs$lang$protocol_mask$partition0$ = 26083532;
  this.cljs$lang$protocol_mask$partition1$ = 1;
};
cljs.core.Cycle.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.Cycle.prototype.currentval = function() {
  var self__ = this;
  var coll = this;
  if (self__.current) {
  } else {
    var temp__5455__auto___5738 = cljs.core.next(self__.prev);
    if (temp__5455__auto___5738) {
      var c_5739 = temp__5455__auto___5738;
      self__.current = c_5739;
    } else {
      self__.current = self__.all;
    }
  }
  return self__.current;
};
cljs.core.Cycle.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.Cycle.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
};
cljs.core.Cycle.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.Cycle.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return !(self__.current == null);
};
cljs.core.Cycle.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  var s = coll__$1.currentval();
  var ret = cljs.core.first(s);
  while (true) {
    var s__$1 = function() {
      var or__3922__auto__ = cljs.core.next(s);
      if (or__3922__auto__) {
        return or__3922__auto__;
      } else {
        return self__.all;
      }
    }();
    var ret__$1 = function() {
      var G__5734 = ret;
      var G__5735 = cljs.core.first(s__$1);
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5734, G__5735) : f.call(null, G__5734, G__5735);
    }();
    if (cljs.core.reduced_QMARK_(ret__$1)) {
      return cljs.core.deref(ret__$1);
    } else {
      var G__5740 = s__$1;
      var G__5741 = ret__$1;
      s = G__5740;
      ret = G__5741;
      continue;
    }
    break;
  }
};
cljs.core.Cycle.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  var s = coll__$1.currentval();
  var ret = start;
  while (true) {
    var ret__$1 = function() {
      var G__5736 = ret;
      var G__5737 = cljs.core.first(s);
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5736, G__5737) : f.call(null, G__5736, G__5737);
    }();
    if (cljs.core.reduced_QMARK_(ret__$1)) {
      return cljs.core.deref(ret__$1);
    } else {
      var G__5742 = function() {
        var or__3922__auto__ = cljs.core.next(s);
        if (or__3922__auto__) {
          return or__3922__auto__;
        } else {
          return self__.all;
        }
      }();
      var G__5743 = ret__$1;
      s = G__5742;
      ret = G__5743;
      continue;
    }
    break;
  }
};
cljs.core.Cycle.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(coll__$1.currentval());
};
cljs.core.Cycle.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__._next == null) {
    self__._next = new cljs.core.Cycle(null, self__.all, coll__$1.currentval(), null, null);
  } else {
  }
  return self__._next;
};
cljs.core.Cycle.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.Cycle.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.Cycle(meta__$1, self__.all, self__.prev, self__.current, self__._next);
};
cljs.core.Cycle.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.Cycle.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "all", "all", -1762306027, null), new cljs.core.Symbol(null, "prev", "prev", 43462301, null), cljs.core.with_meta(new cljs.core.Symbol(null, "current", "current", 552492924, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, 
  "_next", "_next", 101877036, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.Cycle.cljs$lang$type = true;
cljs.core.Cycle.cljs$lang$ctorStr = "cljs.core/Cycle";
cljs.core.Cycle.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/Cycle");
};
cljs.core.__GT_Cycle = function cljs$core$__GT_Cycle(meta, all, prev, current, _next) {
  return new cljs.core.Cycle(meta, all, prev, current, _next);
};
cljs.core.cycle = function cljs$core$cycle(coll) {
  var temp__5455__auto__ = cljs.core.seq(coll);
  if (temp__5455__auto__) {
    var vals = temp__5455__auto__;
    return new cljs.core.Cycle(null, vals, null, vals, null);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.split_at = function cljs$core$split_at(n, coll) {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, coll), cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n, coll)], null);
};
cljs.core.Repeat = function(meta, count, val, next, __hash) {
  this.meta = meta;
  this.count = count;
  this.val = val;
  this.next = next;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32374988;
  this.cljs$lang$protocol_mask$partition1$ = 1;
};
cljs.core.Repeat.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.Repeat.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Repeat.prototype.indexOf = function() {
  var G__5744 = null;
  var G__5744__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__5744__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__5744 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__5744__1.call(this, x);
      case 2:
        return G__5744__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__5744.cljs$core$IFn$_invoke$arity$1 = G__5744__1;
  G__5744.cljs$core$IFn$_invoke$arity$2 = G__5744__2;
  return G__5744;
}();
cljs.core.Repeat.prototype.lastIndexOf = function() {
  var G__5745 = null;
  var G__5745__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, self__.count);
  };
  var G__5745__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__5745 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__5745__1.call(this, x);
      case 2:
        return G__5745__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__5745.cljs$core$IFn$_invoke$arity$1 = G__5745__1;
  G__5745.cljs$core$IFn$_invoke$arity$2 = G__5745__2;
  return G__5745;
}();
cljs.core.Repeat.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.Repeat.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.next == null) {
    if (self__.count > 1) {
      self__.next = new cljs.core.Repeat(null, self__.count - 1, self__.val, null, null);
      return self__.next;
    } else {
      if (-1 === self__.count) {
        return coll__$1;
      } else {
        return null;
      }
    }
  } else {
    return self__.next;
  }
};
cljs.core.Repeat.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4030__auto__ = self__.__hash;
  if (!(h__4030__auto__ == null)) {
    return h__4030__auto__;
  } else {
    var h__4030__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4030__auto____$1;
    return h__4030__auto____$1;
  }
};
cljs.core.Repeat.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.Repeat.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.Repeat.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return false;
};
cljs.core.Repeat.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.count === -1) {
    var ret = f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(self__.val, self__.val) : f.call(null, self__.val, self__.val);
    while (true) {
      if (cljs.core.reduced_QMARK_(ret)) {
        return cljs.core.deref(ret);
      } else {
        var G__5746 = f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret, self__.val) : f.call(null, ret, self__.val);
        ret = G__5746;
        continue;
      }
      break;
    }
  } else {
    var i = 1;
    var ret = self__.val;
    while (true) {
      if (i < self__.count) {
        var ret__$1 = f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret, self__.val) : f.call(null, ret, self__.val);
        if (cljs.core.reduced_QMARK_(ret__$1)) {
          return cljs.core.deref(ret__$1);
        } else {
          var G__5747 = i + 1;
          var G__5748 = ret__$1;
          i = G__5747;
          ret = G__5748;
          continue;
        }
      } else {
        return ret;
      }
      break;
    }
  }
};
cljs.core.Repeat.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.count === -1) {
    var ret = f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(start, self__.val) : f.call(null, start, self__.val);
    while (true) {
      if (cljs.core.reduced_QMARK_(ret)) {
        return cljs.core.deref(ret);
      } else {
        var G__5749 = f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret, self__.val) : f.call(null, ret, self__.val);
        ret = G__5749;
        continue;
      }
      break;
    }
  } else {
    var i = 0;
    var ret = start;
    while (true) {
      if (i < self__.count) {
        var ret__$1 = f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret, self__.val) : f.call(null, ret, self__.val);
        if (cljs.core.reduced_QMARK_(ret__$1)) {
          return cljs.core.deref(ret__$1);
        } else {
          var G__5750 = i + 1;
          var G__5751 = ret__$1;
          i = G__5750;
          ret = G__5751;
          continue;
        }
      } else {
        return ret;
      }
      break;
    }
  }
};
cljs.core.Repeat.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.val;
};
cljs.core.Repeat.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.next == null) {
    if (self__.count > 1) {
      self__.next = new cljs.core.Repeat(null, self__.count - 1, self__.val, null, null);
      return self__.next;
    } else {
      if (-1 === self__.count) {
        return coll__$1;
      } else {
        return cljs.core.List.EMPTY;
      }
    }
  } else {
    return self__.next;
  }
};
cljs.core.Repeat.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.Repeat.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.Repeat(meta__$1, self__.count, self__.val, self__.next, null);
};
cljs.core.Repeat.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.Repeat.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "count", "count", -514511684, null), new cljs.core.Symbol(null, "val", "val", 1769233139, null), cljs.core.with_meta(new cljs.core.Symbol(null, "next", "next", 1522830042, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, 
  "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.Repeat.cljs$lang$type = true;
cljs.core.Repeat.cljs$lang$ctorStr = "cljs.core/Repeat";
cljs.core.Repeat.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/Repeat");
};
cljs.core.__GT_Repeat = function cljs$core$__GT_Repeat(meta, count, val, next, __hash) {
  return new cljs.core.Repeat(meta, count, val, next, __hash);
};
cljs.core.repeat = function cljs$core$repeat(var_args) {
  var G__5753 = arguments.length;
  switch(G__5753) {
    case 1:
      return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = function(x) {
  return new cljs.core.Repeat(null, -1, x, null, null);
};
cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = function(n, x) {
  if (n > 0) {
    return new cljs.core.Repeat(null, n, x, null, null);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.repeat.cljs$lang$maxFixedArity = 2;
cljs.core.replicate = function cljs$core$replicate(n, x) {
  return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
};
cljs.core.repeatedly = function cljs$core$repeatedly(var_args) {
  var G__5756 = arguments.length;
  switch(G__5756) {
    case 1:
      return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return new cljs.core.LazySeq(null, function() {
    return cljs.core.cons(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null), cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
  }, null, null);
};
cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = function(n, f) {
  return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
};
cljs.core.repeatedly.cljs$lang$maxFixedArity = 2;
cljs.core.UNREALIZED_SEED = {};
cljs.core.Iterate = function(meta, f, prev_seed, seed, next) {
  this.meta = meta;
  this.f = f;
  this.prev_seed = prev_seed;
  this.seed = seed;
  this.next = next;
  this.cljs$lang$protocol_mask$partition0$ = 26083532;
  this.cljs$lang$protocol_mask$partition1$ = 1;
};
cljs.core.Iterate.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.Iterate.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.Iterate.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
};
cljs.core.Iterate.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.Iterate.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return !(self__.seed === cljs.core.UNREALIZED_SEED);
};
cljs.core.Iterate.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, rf) {
  var self__ = this;
  var coll__$1 = this;
  var first = coll__$1.cljs$core$ISeq$_first$arity$1(null);
  var v = self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(first) : self__.f.call(null, first);
  var ret = rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(first, v) : rf.call(null, first, v);
  var v__$1 = v;
  while (true) {
    if (cljs.core.reduced_QMARK_(ret)) {
      return cljs.core.deref(ret);
    } else {
      var v__$2 = self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(v__$1) : self__.f.call(null, v__$1);
      var G__5758 = rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(ret, v__$2) : rf.call(null, ret, v__$2);
      var G__5759 = v__$2;
      ret = G__5758;
      v__$1 = G__5759;
      continue;
    }
    break;
  }
};
cljs.core.Iterate.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, rf, start) {
  var self__ = this;
  var coll__$1 = this;
  var v = coll__$1.cljs$core$ISeq$_first$arity$1(null);
  var ret = rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(start, v) : rf.call(null, start, v);
  var v__$1 = v;
  while (true) {
    if (cljs.core.reduced_QMARK_(ret)) {
      return cljs.core.deref(ret);
    } else {
      var v__$2 = self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(v__$1) : self__.f.call(null, v__$1);
      var G__5760 = rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(ret, v__$2) : rf.call(null, ret, v__$2);
      var G__5761 = v__$2;
      ret = G__5760;
      v__$1 = G__5761;
      continue;
    }
    break;
  }
};
cljs.core.Iterate.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.UNREALIZED_SEED === self__.seed) {
    self__.seed = self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(self__.prev_seed) : self__.f.call(null, self__.prev_seed);
  } else {
  }
  return self__.seed;
};
cljs.core.Iterate.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.next == null) {
    self__.next = new cljs.core.Iterate(null, self__.f, coll__$1.cljs$core$ISeq$_first$arity$1(null), cljs.core.UNREALIZED_SEED, null);
  } else {
  }
  return self__.next;
};
cljs.core.Iterate.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.Iterate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.Iterate(meta__$1, self__.f, self__.prev_seed, self__.seed, self__.next);
};
cljs.core.Iterate.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.Iterate.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "f", "f", 43394975, null), new cljs.core.Symbol(null, "prev-seed", "prev-seed", 2126381367, null), cljs.core.with_meta(new cljs.core.Symbol(null, "seed", "seed", 1709144854, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, 
  "next", "next", 1522830042, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.Iterate.cljs$lang$type = true;
cljs.core.Iterate.cljs$lang$ctorStr = "cljs.core/Iterate";
cljs.core.Iterate.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/Iterate");
};
cljs.core.__GT_Iterate = function cljs$core$__GT_Iterate(meta, f, prev_seed, seed, next) {
  return new cljs.core.Iterate(meta, f, prev_seed, seed, next);
};
cljs.core.iterate = function cljs$core$iterate(f, x) {
  return new cljs.core.Iterate(null, f, null, x, null);
};
cljs.core.interleave = function cljs$core$interleave(var_args) {
  var G__5766 = arguments.length;
  switch(G__5766) {
    case 0:
      return cljs.core.interleave.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.interleave.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5768 = arguments.length;
      var i__4500__auto___5769 = 0;
      while (true) {
        if (i__4500__auto___5769 < len__4499__auto___5768) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5769]);
          var G__5770 = i__4500__auto___5769 + 1;
          i__4500__auto___5769 = G__5770;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(2), 0, null);
      return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], argseq__4515__auto__);
  }
};
cljs.core.interleave.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.List.EMPTY;
};
cljs.core.interleave.cljs$core$IFn$_invoke$arity$1 = function(c1) {
  return new cljs.core.LazySeq(null, function() {
    return c1;
  }, null, null);
};
cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = function(c1, c2) {
  return new cljs.core.LazySeq(null, function() {
    var s1 = cljs.core.seq(c1);
    var s2 = cljs.core.seq(c2);
    if (s1 && s2) {
      return cljs.core.cons(cljs.core.first(s1), cljs.core.cons(cljs.core.first(s2), cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1), cljs.core.rest(s2))));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = function(c1, c2, colls) {
  return new cljs.core.LazySeq(null, function() {
    var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq, cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls, c2, cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c1], 0)));
    if (cljs.core.every_QMARK_(cljs.core.identity, ss)) {
      return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first, ss), cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave, cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest, ss)));
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.interleave.cljs$lang$applyTo = function(seq5763) {
  var G__5764 = cljs.core.first(seq5763);
  var seq5763__$1 = cljs.core.next(seq5763);
  var G__5765 = cljs.core.first(seq5763__$1);
  var seq5763__$2 = cljs.core.next(seq5763__$1);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5764, G__5765, seq5763__$2);
};
cljs.core.interleave.cljs$lang$maxFixedArity = 2;
cljs.core.interpose = function cljs$core$interpose(var_args) {
  var G__5772 = arguments.length;
  switch(G__5772) {
    case 1:
      return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = function(sep) {
  return function(rf) {
    var started = cljs.core.volatile_BANG_(false);
    return function(started) {
      return function() {
        var G__5774 = null;
        var G__5774__0 = function() {
          return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
        };
        var G__5774__1 = function(result) {
          return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
        };
        var G__5774__2 = function(result, input) {
          if (cljs.core.truth_(cljs.core.deref(started))) {
            var sepr = rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, sep) : rf.call(null, result, sep);
            if (cljs.core.reduced_QMARK_(sepr)) {
              return sepr;
            } else {
              return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(sepr, input) : rf.call(null, sepr, input);
            }
          } else {
            cljs.core.vreset_BANG_(started, true);
            return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, input) : rf.call(null, result, input);
          }
        };
        G__5774 = function(result, input) {
          switch(arguments.length) {
            case 0:
              return G__5774__0.call(this);
            case 1:
              return G__5774__1.call(this, result);
            case 2:
              return G__5774__2.call(this, result, input);
          }
          throw new Error("Invalid arity: " + (arguments.length - 1));
        };
        G__5774.cljs$core$IFn$_invoke$arity$0 = G__5774__0;
        G__5774.cljs$core$IFn$_invoke$arity$1 = G__5774__1;
        G__5774.cljs$core$IFn$_invoke$arity$2 = G__5774__2;
        return G__5774;
      }();
    }(started);
  };
};
cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = function(sep, coll) {
  return cljs.core.drop.cljs$core$IFn$_invoke$arity$2(1, cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep), coll));
};
cljs.core.interpose.cljs$lang$maxFixedArity = 2;
cljs.core.flatten1 = function cljs$core$flatten1(colls) {
  var cat = function cljs$core$flatten1_$_cat(coll, colls__$1) {
    return new cljs.core.LazySeq(null, function() {
      var temp__5455__auto__ = cljs.core.seq(coll);
      if (temp__5455__auto__) {
        var coll__$1 = temp__5455__auto__;
        return cljs.core.cons(cljs.core.first(coll__$1), cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1), colls__$1));
      } else {
        if (cljs.core.seq(colls__$1)) {
          return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1), cljs.core.rest(colls__$1));
        } else {
          return null;
        }
      }
    }, null, null);
  };
  return cat(null, colls);
};
cljs.core.mapcat = function cljs$core$mapcat(var_args) {
  var G__5778 = arguments.length;
  switch(G__5778) {
    case 1:
      return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5780 = arguments.length;
      var i__4500__auto___5781 = 0;
      while (true) {
        if (i__4500__auto___5781 < len__4499__auto___5780) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5781]);
          var G__5782 = i__4500__auto___5781 + 1;
          i__4500__auto___5781 = G__5782;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(1), 0, null);
      return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(arguments[0], argseq__4515__auto__);
  }
};
cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = function(f) {
  return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f), cljs.core.cat);
};
cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = function(f, colls) {
  return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat, cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map, f, colls));
};
cljs.core.mapcat.cljs$lang$applyTo = function(seq5776) {
  var G__5777 = cljs.core.first(seq5776);
  var seq5776__$1 = cljs.core.next(seq5776);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5777, seq5776__$1);
};
cljs.core.mapcat.cljs$lang$maxFixedArity = 1;
cljs.core.filter = function cljs$core$filter(var_args) {
  var G__5784 = arguments.length;
  switch(G__5784) {
    case 1:
      return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return function(rf) {
    return function() {
      var G__5787 = null;
      var G__5787__0 = function() {
        return rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null);
      };
      var G__5787__1 = function(result) {
        return rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null, result);
      };
      var G__5787__2 = function(result, input) {
        if (cljs.core.truth_(pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null, input))) {
          return rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result, input) : rf.call(null, result, input);
        } else {
          return result;
        }
      };
      G__5787 = function(result, input) {
        switch(arguments.length) {
          case 0:
            return G__5787__0.call(this);
          case 1:
            return G__5787__1.call(this, result);
          case 2:
            return G__5787__2.call(this, result, input);
        }
        throw new Error("Invalid arity: " + (arguments.length - 1));
      };
      G__5787.cljs$core$IFn$_invoke$arity$0 = G__5787__0;
      G__5787.cljs$core$IFn$_invoke$arity$1 = G__5787__1;
      G__5787.cljs$core$IFn$_invoke$arity$2 = G__5787__2;
      return G__5787;
    }();
  };
};
cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__5457__auto__ = cljs.core.seq(coll);
    if (temp__5457__auto__) {
      var s = temp__5457__auto__;
      if (cljs.core.chunked_seq_QMARK_(s)) {
        var c = cljs.core.chunk_first(s);
        var size = cljs.core.count(c);
        var b = cljs.core.chunk_buffer(size);
        var n__4376__auto___5788 = size;
        var i_5789 = 0;
        while (true) {
          if (i_5789 < n__4376__auto___5788) {
            if (cljs.core.truth_(function() {
              var G__5785 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_5789);
              return pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__5785) : pred.call(null, G__5785);
            }())) {
              cljs.core.chunk_append(b, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c, i_5789));
            } else {
            }
            var G__5790 = i_5789 + 1;
            i_5789 = G__5790;
            continue;
          } else {
          }
          break;
        }
        return cljs.core.chunk_cons(cljs.core.chunk(b), cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, cljs.core.chunk_rest(s)));
      } else {
        var f = cljs.core.first(s);
        var r = cljs.core.rest(s);
        if (cljs.core.truth_(pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(f) : pred.call(null, f))) {
          return cljs.core.cons(f, cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, r));
        } else {
          return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred, r);
        }
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.filter.cljs$lang$maxFixedArity = 2;
cljs.core.remove = function cljs$core$remove(var_args) {
  var G__5792 = arguments.length;
  switch(G__5792) {
    case 1:
      return cljs.core.remove.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = function(pred) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
};
cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = function(pred, coll) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred), coll);
};
cljs.core.remove.cljs$lang$maxFixedArity = 2;
cljs.core.tree_seq = function cljs$core$tree_seq(branch_QMARK_, children, root) {
  var walk = function cljs$core$tree_seq_$_walk(node) {
    return new cljs.core.LazySeq(null, function() {
      return cljs.core.cons(node, cljs.core.truth_(branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(node) : branch_QMARK_.call(null, node)) ? cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk, cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(node) : children.call(null, node)], 0)) : null);
    }, null, null);
  };
  return walk(root);
};
cljs.core.flatten = function cljs$core$flatten(x) {
  return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(function(p1__5794_SHARP_) {
    return !cljs.core.sequential_QMARK_(p1__5794_SHARP_);
  }, cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_, cljs.core.seq, x)));
};
cljs.core.into = function cljs$core$into(var_args) {
  var G__5796 = arguments.length;
  switch(G__5796) {
    case 0:
      return cljs.core.into.cljs$core$IFn$_invoke$arity$0();
      break;
    case 1:
      return cljs.core.into.cljs$core$IFn$_invoke$arity$1(arguments[0]);
      break;
    case 2:
      return cljs.core.into.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.into.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.into.cljs$core$IFn$_invoke$arity$0 = function() {
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.into.cljs$core$IFn$_invoke$arity$1 = function(to) {
  return to;
};
cljs.core.into.cljs$core$IFn$_invoke$arity$2 = function(to, from) {
  if (!(to == null)) {
    if (!(to == null) ? to.cljs$lang$protocol_mask$partition1$ & 4 || cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$ ? true : false : false) {
      return cljs.core._with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_, cljs.core.transient$(to), from)), cljs.core.meta(to));
    } else {
      return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj, to, from);
    }
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj, cljs.core.List.EMPTY, from);
  }
};
cljs.core.into.cljs$core$IFn$_invoke$arity$3 = function(to, xform, from) {
  if (!(to == null) ? to.cljs$lang$protocol_mask$partition1$ & 4 || cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$ ? true : false : false) {
    return cljs.core._with_meta(cljs.core.persistent_BANG_(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, cljs.core.conj_BANG_, cljs.core.transient$(to), from)), cljs.core.meta(to));
  } else {
    return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform, cljs.core.conj, to, from);
  }
};
cljs.core.into.cljs$lang$maxFixedArity = 3;
cljs.core.mapv = function cljs$core$mapv(var_args) {
  var G__5806 = arguments.length;
  switch(G__5806) {
    case 2:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5808 = arguments.length;
      var i__4500__auto___5809 = 0;
      while (true) {
        if (i__4500__auto___5809 < len__4499__auto___5808) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5809]);
          var G__5810 = i__4500__auto___5809 + 1;
          i__4500__auto___5809 = G__5810;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(4), 0, null);
      return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], argseq__4515__auto__);
  }
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = function(f, coll) {
  return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(v, o) {
    return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v, f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(o) : f.call(null, o));
  }, cljs.core.transient$(cljs.core.PersistentVector.EMPTY), coll));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = function(f, c1, c2) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.map.cljs$core$IFn$_invoke$arity$3(f, c1, c2));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = function(f, c1, c2, c3) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.map.cljs$core$IFn$_invoke$arity$4(f, c1, c2, c3));
};
cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = function(f, c1, c2, c3, colls) {
  return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map, f, c1, c2, c3, cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([colls], 0)));
};
cljs.core.mapv.cljs$lang$applyTo = function(seq5801) {
  var G__5802 = cljs.core.first(seq5801);
  var seq5801__$1 = cljs.core.next(seq5801);
  var G__5803 = cljs.core.first(seq5801__$1);
  var seq5801__$2 = cljs.core.next(seq5801__$1);
  var G__5804 = cljs.core.first(seq5801__$2);
  var seq5801__$3 = cljs.core.next(seq5801__$2);
  var G__5805 = cljs.core.first(seq5801__$3);
  var seq5801__$4 = cljs.core.next(seq5801__$3);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5802, G__5803, G__5804, G__5805, seq5801__$4);
};
cljs.core.mapv.cljs$lang$maxFixedArity = 4;
cljs.core.filterv = function cljs$core$filterv(pred, coll) {
  return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(function(v, o) {
    if (cljs.core.truth_(pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(o) : pred.call(null, o))) {
      return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v, o);
    } else {
      return v;
    }
  }, cljs.core.transient$(cljs.core.PersistentVector.EMPTY), coll));
};
cljs.core.partition = function cljs$core$partition(var_args) {
  var G__5812 = arguments.length;
  switch(G__5812) {
    case 2:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.partition.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = function(n, coll) {
  return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n, n, coll);
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = function(n, step, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__5457__auto__ = cljs.core.seq(coll);
    if (temp__5457__auto__) {
      var s = temp__5457__auto__;
      var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, s);
      if (n === cljs.core.count(p)) {
        return cljs.core.cons(p, cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n, step, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step, s)));
      } else {
        return null;
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = function(n, step, pad, coll) {
  return new cljs.core.LazySeq(null, function() {
    var temp__5457__auto__ = cljs.core.seq(coll);
    if (temp__5457__auto__) {
      var s = temp__5457__auto__;
      var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, s);
      if (n === cljs.core.count(p)) {
        return cljs.core.cons(p, cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n, step, pad, cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step, s)));
      } else {
        return new cljs.core.List(null, cljs.core.take.cljs$core$IFn$_invoke$arity$2(n, cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p, pad)), null, 1, null);
      }
    } else {
      return null;
    }
  }, null, null);
};
cljs.core.partition.cljs$lang$maxFixedArity = 4;
cljs.core.get_in = function cljs$core$get_in(var_args) {
  var G__5815 = arguments.length;
  switch(G__5815) {
    case 2:
      return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = function(m, ks) {
  return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.get, m, ks);
};
cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = function(m, ks, not_found) {
  var sentinel = cljs.core.lookup_sentinel;
  var m__$1 = m;
  var ks__$1 = cljs.core.seq(ks);
  while (true) {
    if (!(ks__$1 == null)) {
      var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1, cljs.core.first(ks__$1), sentinel);
      if (sentinel === m__$2) {
        return not_found;
      } else {
        var G__5817 = sentinel;
        var G__5818 = m__$2;
        var G__5819 = cljs.core.next(ks__$1);
        sentinel = G__5817;
        m__$1 = G__5818;
        ks__$1 = G__5819;
        continue;
      }
    } else {
      return m__$1;
    }
    break;
  }
};
cljs.core.get_in.cljs$lang$maxFixedArity = 3;
cljs.core.assoc_in = function cljs$core$assoc_in(m, p__5820, v) {
  var vec__5821 = p__5820;
  var seq__5822 = cljs.core.seq(vec__5821);
  var first__5823 = cljs.core.first(seq__5822);
  var seq__5822__$1 = cljs.core.next(seq__5822);
  var k = first__5823;
  var ks = seq__5822__$1;
  if (ks) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__5824 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__5825 = ks;
      var G__5826 = v;
      return cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3 ? cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3(G__5824, G__5825, G__5826) : cljs.core.assoc_in.call(null, G__5824, G__5825, G__5826);
    }());
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, v);
  }
};
cljs.core.update_in = function cljs$core$update_in(var_args) {
  var G__5835 = arguments.length;
  switch(G__5835) {
    case 3:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5867 = arguments.length;
      var i__4500__auto___5868 = 0;
      while (true) {
        if (i__4500__auto___5868 < len__4499__auto___5867) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5868]);
          var G__5869 = i__4500__auto___5868 + 1;
          i__4500__auto___5868 = G__5869;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(6), 0, null);
      return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__4515__auto__);
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = function(m, p__5836, f) {
  var vec__5837 = p__5836;
  var seq__5838 = cljs.core.seq(vec__5837);
  var first__5839 = cljs.core.first(seq__5838);
  var seq__5838__$1 = cljs.core.next(seq__5838);
  var k = first__5839;
  var ks = seq__5838__$1;
  if (ks) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__5840 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__5840) : f.call(null, G__5840);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = function(m, p__5841, f, a) {
  var vec__5842 = p__5841;
  var seq__5843 = cljs.core.seq(vec__5842);
  var first__5844 = cljs.core.first(seq__5843);
  var seq__5843__$1 = cljs.core.next(seq__5843);
  var k = first__5844;
  var ks = seq__5843__$1;
  if (ks) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__5845 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__5846 = a;
      return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5845, G__5846) : f.call(null, G__5845, G__5846);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = function(m, p__5847, f, a, b) {
  var vec__5848 = p__5847;
  var seq__5849 = cljs.core.seq(vec__5848);
  var first__5850 = cljs.core.first(seq__5849);
  var seq__5849__$1 = cljs.core.next(seq__5849);
  var k = first__5850;
  var ks = seq__5849__$1;
  if (ks) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, b));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__5851 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__5852 = a;
      var G__5853 = b;
      return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__5851, G__5852, G__5853) : f.call(null, G__5851, G__5852, G__5853);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = function(m, p__5854, f, a, b, c) {
  var vec__5855 = p__5854;
  var seq__5856 = cljs.core.seq(vec__5855);
  var first__5857 = cljs.core.first(seq__5856);
  var seq__5856__$1 = cljs.core.next(seq__5856);
  var k = first__5857;
  var ks = seq__5856__$1;
  if (ks) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, b, c));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
      var G__5858 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
      var G__5859 = a;
      var G__5860 = b;
      var G__5861 = c;
      return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__5858, G__5859, G__5860, G__5861) : f.call(null, G__5858, G__5859, G__5860, G__5861);
    }());
  }
};
cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = function(m, p__5862, f, a, b, c, args) {
  var vec__5863 = p__5862;
  var seq__5864 = cljs.core.seq(vec__5863);
  var first__5865 = cljs.core.first(seq__5864);
  var seq__5864__$1 = cljs.core.next(seq__5864);
  var k = first__5865;
  var ks = seq__5864__$1;
  if (ks) {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), ks, f, a, cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([b, c, args], 0)));
  } else {
    return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), a, b, c, cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0)));
  }
};
cljs.core.update_in.cljs$lang$applyTo = function(seq5828) {
  var G__5829 = cljs.core.first(seq5828);
  var seq5828__$1 = cljs.core.next(seq5828);
  var G__5830 = cljs.core.first(seq5828__$1);
  var seq5828__$2 = cljs.core.next(seq5828__$1);
  var G__5831 = cljs.core.first(seq5828__$2);
  var seq5828__$3 = cljs.core.next(seq5828__$2);
  var G__5832 = cljs.core.first(seq5828__$3);
  var seq5828__$4 = cljs.core.next(seq5828__$3);
  var G__5833 = cljs.core.first(seq5828__$4);
  var seq5828__$5 = cljs.core.next(seq5828__$4);
  var G__5834 = cljs.core.first(seq5828__$5);
  var seq5828__$6 = cljs.core.next(seq5828__$5);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5829, G__5830, G__5831, G__5832, G__5833, G__5834, seq5828__$6);
};
cljs.core.update_in.cljs$lang$maxFixedArity = 6;
cljs.core.update = function cljs$core$update(var_args) {
  var G__5878 = arguments.length;
  switch(G__5878) {
    case 3:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    case 6:
      return cljs.core.update.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      var args_arr__4514__auto__ = [];
      var len__4499__auto___5890 = arguments.length;
      var i__4500__auto___5891 = 0;
      while (true) {
        if (i__4500__auto___5891 < len__4499__auto___5890) {
          args_arr__4514__auto__.push(arguments[i__4500__auto___5891]);
          var G__5892 = i__4500__auto___5891 + 1;
          i__4500__auto___5891 = G__5892;
          continue;
        } else {
        }
        break;
      }
      var argseq__4515__auto__ = new cljs.core.IndexedSeq(args_arr__4514__auto__.slice(6), 0, null);
      return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], argseq__4515__auto__);
  }
};
cljs.core.update.cljs$core$IFn$_invoke$arity$3 = function(m, k, f) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__5879 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    return f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__5879) : f.call(null, G__5879);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$4 = function(m, k, f, x) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__5880 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__5881 = x;
    return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5880, G__5881) : f.call(null, G__5880, G__5881);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$5 = function(m, k, f, x, y) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__5882 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__5883 = x;
    var G__5884 = y;
    return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__5882, G__5883, G__5884) : f.call(null, G__5882, G__5883, G__5884);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$6 = function(m, k, f, x, y, z) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, function() {
    var G__5885 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k);
    var G__5886 = x;
    var G__5887 = y;
    var G__5888 = z;
    return f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__5885, G__5886, G__5887, G__5888) : f.call(null, G__5885, G__5886, G__5887, G__5888);
  }());
};
cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = function(m, k, f, x, y, z, more) {
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m, k, cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f, cljs.core.get.cljs$core$IFn$_invoke$arity$2(m, k), x, y, z, cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([more], 0)));
};
cljs.core.update.cljs$lang$applyTo = function(seq5871) {
  var G__5872 = cljs.core.first(seq5871);
  var seq5871__$1 = cljs.core.next(seq5871);
  var G__5873 = cljs.core.first(seq5871__$1);
  var seq5871__$2 = cljs.core.next(seq5871__$1);
  var G__5874 = cljs.core.first(seq5871__$2);
  var seq5871__$3 = cljs.core.next(seq5871__$2);
  var G__5875 = cljs.core.first(seq5871__$3);
  var seq5871__$4 = cljs.core.next(seq5871__$3);
  var G__5876 = cljs.core.first(seq5871__$4);
  var seq5871__$5 = cljs.core.next(seq5871__$4);
  var G__5877 = cljs.core.first(seq5871__$5);
  var seq5871__$6 = cljs.core.next(seq5871__$5);
  var self__4486__auto__ = this;
  return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5872, G__5873, G__5874, G__5875, G__5876, G__5877, seq5871__$6);
};
cljs.core.update.cljs$lang$maxFixedArity = 6;
cljs.core.VectorNode = function(edit, arr) {
  this.edit = edit;
  this.arr = arr;
};
cljs.core.VectorNode.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "edit", "edit", -1302639, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.VectorNode.cljs$lang$type = true;
cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode";
cljs.core.VectorNode.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/VectorNode");
};
cljs.core.__GT_VectorNode = function cljs$core$__GT_VectorNode(edit, arr) {
  return new cljs.core.VectorNode(edit, arr);
};
cljs.core.pv_fresh_node = function cljs$core$pv_fresh_node(edit) {
  return new cljs.core.VectorNode(edit, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
};
cljs.core.pv_aget = function cljs$core$pv_aget(node, idx) {
  return node.arr[idx];
};
cljs.core.pv_aset = function cljs$core$pv_aset(node, idx, val) {
  return node.arr[idx] = val;
};
cljs.core.pv_clone_node = function cljs$core$pv_clone_node(node) {
  return new cljs.core.VectorNode(node.edit, cljs.core.aclone(node.arr));
};
cljs.core.tail_off = function cljs$core$tail_off(pv) {
  var cnt = pv.cnt;
  if (cnt < 32) {
    return 0;
  } else {
    return cnt - 1 >>> 5 << 5;
  }
};
cljs.core.new_path = function cljs$core$new_path(edit, level, node) {
  var ll = level;
  var ret = node;
  while (true) {
    if (ll === 0) {
      return ret;
    } else {
      var embed = ret;
      var r = cljs.core.pv_fresh_node(edit);
      var _ = cljs.core.pv_aset(r, 0, embed);
      var G__5893 = ll - 5;
      var G__5894 = r;
      ll = G__5893;
      ret = G__5894;
      continue;
    }
    break;
  }
};
cljs.core.push_tail = function cljs$core$push_tail(pv, level, parent, tailnode) {
  var ret = cljs.core.pv_clone_node(parent);
  var subidx = pv.cnt - 1 >>> level & 31;
  if (5 === level) {
    cljs.core.pv_aset(ret, subidx, tailnode);
    return ret;
  } else {
    var child = cljs.core.pv_aget(parent, subidx);
    if (!(child == null)) {
      var node_to_insert = function() {
        var G__5895 = pv;
        var G__5896 = level - 5;
        var G__5897 = child;
        var G__5898 = tailnode;
        return cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4(G__5895, G__5896, G__5897, G__5898) : cljs.core.push_tail.call(null, G__5895, G__5896, G__5897, G__5898);
      }();
      cljs.core.pv_aset(ret, subidx, node_to_insert);
      return ret;
    } else {
      var node_to_insert = cljs.core.new_path(null, level - 5, tailnode);
      cljs.core.pv_aset(ret, subidx, node_to_insert);
      return ret;
    }
  }
};
cljs.core.vector_index_out_of_bounds = function cljs$core$vector_index_out_of_bounds(i, cnt) {
  throw new Error(["No item ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(i), " in vector of length ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(cnt)].join(""));
};
cljs.core.first_array_for_longvec = function cljs$core$first_array_for_longvec(pv) {
  var node = pv.root;
  var level = pv.shift;
  while (true) {
    if (level > 0) {
      var G__5899 = cljs.core.pv_aget(node, 0);
      var G__5900 = level - 5;
      node = G__5899;
      level = G__5900;
      continue;
    } else {
      return node.arr;
    }
    break;
  }
};
cljs.core.unchecked_array_for = function cljs$core$unchecked_array_for(pv, i) {
  if (i >= cljs.core.tail_off(pv)) {
    return pv.tail;
  } else {
    var node = pv.root;
    var level = pv.shift;
    while (true) {
      if (level > 0) {
        var G__5901 = cljs.core.pv_aget(node, i >>> level & 31);
        var G__5902 = level - 5;
        node = G__5901;
        level = G__5902;
        continue;
      } else {
        return node.arr;
      }
      break;
    }
  }
};
cljs.core.array_for = function cljs$core$array_for(pv, i) {
  if (0 <= i && i < pv.cnt) {
    return cljs.core.unchecked_array_for(pv, i);
  } else {
    return cljs.core.vector_index_out_of_bounds(i, pv.cnt);
  }
};
cljs.core.do_assoc = function cljs$core$do_assoc(pv, level, node, i, val) {
  var ret = cljs.core.pv_clone_node(node);
  if (level === 0) {
    cljs.core.pv_aset(ret, i & 31, val);
    return ret;
  } else {
    var subidx = i >>> level & 31;
    cljs.core.pv_aset(ret, subidx, function() {
      var G__5903 = pv;
      var G__5904 = level - 5;
      var G__5905 = cljs.core.pv_aget(node, subidx);
      var G__5906 = i;
      var G__5907 = val;
      return cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5 ? cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5(G__5903, G__5904, G__5905, G__5906, G__5907) : cljs.core.do_assoc.call(null, G__5903, G__5904, G__5905, G__5906, G__5907);
    }());
    return ret;
  }
};
cljs.core.pop_tail = function cljs$core$pop_tail(pv, level, node) {
  var subidx = pv.cnt - 2 >>> level & 31;
  if (level > 5) {
    var new_child = function() {
      var G__5908 = pv;
      var G__5909 = level - 5;
      var G__5910 = cljs.core.pv_aget(node, subidx);
      return cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3(G__5908, G__5909, G__5910) : cljs.core.pop_tail.call(null, G__5908, G__5909, G__5910);
    }();
    if (new_child == null && subidx === 0) {
      return null;
    } else {
      var ret = cljs.core.pv_clone_node(node);
      cljs.core.pv_aset(ret, subidx, new_child);
      return ret;
    }
  } else {
    if (subidx === 0) {
      return null;
    } else {
      var ret = cljs.core.pv_clone_node(node);
      cljs.core.pv_aset(ret, subidx, null);
      return ret;
    }
  }
};
cljs.core.RangedIterator = function(i, base, arr, v, start, end) {
  this.i = i;
  this.base = base;
  this.arr = arr;
  this.v = v;
  this.start = start;
  this.end = end;
};
cljs.core.RangedIterator.prototype.hasNext = function() {
  var self__ = this;
  var this$ = this;
  return self__.i < self__.end;
};
cljs.core.RangedIterator.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (self__.i - self__.base === 32) {
    self__.arr = cljs.core.unchecked_array_for(self__.v, self__.i);
    self__.base = self__.base + 32;
  } else {
  }
  var ret = self__.arr[self__.i & 31];
  self__.i = self__.i + 1;
  return ret;
};
cljs.core.RangedIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "base", "base", 1825810849, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, 
  "arr", "arr", 2115492975, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, "v", "v", 1661996586, null), new cljs.core.Symbol(null, "start", "start", 1285322546, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null)], null);
};
cljs.core.RangedIterator.cljs$lang$type = true;
cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator";
cljs.core.RangedIterator.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/RangedIterator");
};
cljs.core.__GT_RangedIterator = function cljs$core$__GT_RangedIterator(i, base, arr, v, start, end) {
  return new cljs.core.RangedIterator(i, base, arr, v, start, end);
};
cljs.core.ranged_iterator = function cljs$core$ranged_iterator(v, start, end) {
  var i = start;
  return new cljs.core.RangedIterator(i, i - i % 32, start < cljs.core.count(v) ? cljs.core.unchecked_array_for(v, i) : null, v, start, end);
};
cljs.core.pv_reduce = function cljs$core$pv_reduce(var_args) {
  var G__5912 = arguments.length;
  switch(G__5912) {
    case 4:
      return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4 = function(pv, f, start, end) {
  if (start < end) {
    return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(pv, f, cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pv, start), start + 1, end);
  } else {
    return f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null);
  }
};
cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5 = function(pv, f, init, start, end) {
  var acc = init;
  var i = start;
  var arr = cljs.core.unchecked_array_for(pv, start);
  while (true) {
    if (i < end) {
      var j = i & 31;
      var arr__$1 = j === 0 ? cljs.core.unchecked_array_for(pv, i) : arr;
      var nacc = function() {
        var G__5913 = acc;
        var G__5914 = arr__$1[j];
        return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5913, G__5914) : f.call(null, G__5913, G__5914);
      }();
      if (cljs.core.reduced_QMARK_(nacc)) {
        return cljs.core.deref(nacc);
      } else {
        var G__5916 = nacc;
        var G__5917 = i + 1;
        var G__5918 = arr__$1;
        acc = G__5916;
        i = G__5917;
        arr = G__5918;
        continue;
      }
    } else {
      return acc;
    }
    break;
  }
};
cljs.core.pv_reduce.cljs$lang$maxFixedArity = 5;
cljs.core.APersistentVector = function() {
};
cljs.core.PersistentVector = function(meta, cnt, shift, root, tail, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 167666463;
  this.cljs$lang$protocol_mask$partition1$ = 139268;
};
cljs.core.PersistentVector.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.PersistentVector.prototype.cljs$core$IFind$_find$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    return new cljs.core.MapEntry(n, cljs.core.unchecked_array_for(coll__$1, n)[n & 31], null);
  } else {
    return null;
  }
};
cljs.core.PersistentVector.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentVector.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentVector.prototype.indexOf = function() {
  var G__5925 = null;
  var G__5925__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__5925__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__5925 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__5925__1.call(this, x);
      case 2:
        return G__5925__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__5925.cljs$core$IFn$_invoke$arity$1 = G__5925__1;
  G__5925.cljs$core$IFn$_invoke$arity$2 = G__5925__2;
  return G__5925;
}();
cljs.core.PersistentVector.prototype.lastIndexOf = function() {
  var G__5926 = null;
  var G__5926__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__5926__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__5926 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__5926__1.call(this, x);
      case 2:
        return G__5926__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__5926.cljs$core$IFn$_invoke$arity$1 = G__5926__1;
  G__5926.cljs$core$IFn$_invoke$arity$2 = G__5926__2;
  return G__5926;
}();
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1.cljs$core$ILookup$_lookup$arity$3(null, k, null);
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return coll__$1.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(v, f, init) {
  var self__ = this;
  var v__$1 = this;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.cnt) {
      var arr = cljs.core.unchecked_array_for(v__$1, i);
      var len = arr.length;
      var init__$2 = function() {
        var j = 0;
        var init__$2 = init__$1;
        while (true) {
          if (j < len) {
            var init__$3 = function() {
              var G__5920 = init__$2;
              var G__5921 = j + i;
              var G__5922 = arr[j];
              return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__5920, G__5921, G__5922) : f.call(null, G__5920, G__5921, G__5922);
            }();
            if (cljs.core.reduced_QMARK_(init__$3)) {
              return init__$3;
            } else {
              var G__5927 = j + 1;
              var G__5928 = init__$3;
              j = G__5927;
              init__$2 = G__5928;
              continue;
            }
          } else {
            return init__$2;
          }
          break;
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref(init__$2);
      } else {
        var G__5929 = i + len;
        var G__5930 = init__$2;
        i = G__5929;
        init__$1 = G__5930;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$APersistentVector$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_for(coll__$1, n)[n & 31];
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    return cljs.core.unchecked_array_for(coll__$1, n)[n & 31];
  } else {
    return not_found;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    if (cljs.core.tail_off(coll__$1) <= n) {
      var new_tail = cljs.core.aclone(self__.tail);
      new_tail[n & 31] = val;
      return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, self__.root, new_tail, null);
    } else {
      return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, cljs.core.do_assoc(coll__$1, self__.shift, self__.root, n, val), self__.tail, null);
    }
  } else {
    if (n === self__.cnt) {
      return coll__$1.cljs$core$ICollection$_conj$arity$2(null, val);
    } else {
      throw new Error(["Index ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(n), " out of bounds  [0,", cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt), "]"].join(""));
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return cljs.core.ranged_iterator(this$__$1, 0, self__.cnt);
};
cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentVector(self__.meta, self__.cnt, self__.shift, self__.root, self__.tail, self__.__hash);
};
cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return coll__$1.cljs$core$IIndexed$_nth$arity$2(null, self__.cnt - 1);
  } else {
    return null;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt === 0) {
    throw new Error("Can't pop empty vector");
  } else {
    if (1 === self__.cnt) {
      return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
    } else {
      if (1 < self__.cnt - cljs.core.tail_off(coll__$1)) {
        return new cljs.core.PersistentVector(self__.meta, self__.cnt - 1, self__.shift, self__.root, self__.tail.slice(0, -1), null);
      } else {
        var new_tail = cljs.core.unchecked_array_for(coll__$1, self__.cnt - 2);
        var nr = cljs.core.pop_tail(coll__$1, self__.shift, self__.root);
        var new_root = nr == null ? cljs.core.PersistentVector.EMPTY_NODE : nr;
        var cnt_1 = self__.cnt - 1;
        if (5 < self__.shift && cljs.core.pv_aget(new_root, 1) == null) {
          return new cljs.core.PersistentVector(self__.meta, cnt_1, self__.shift - 5, cljs.core.pv_aget(new_root, 0), new_tail, null);
        } else {
          return new cljs.core.PersistentVector(self__.meta, cnt_1, self__.shift, new_root, new_tail, null);
        }
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt > 0) {
    return new cljs.core.RSeq(coll__$1, self__.cnt - 1, null);
  } else {
    return null;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4030__auto__ = self__.__hash;
  if (!(h__4030__auto__ == null)) {
    return h__4030__auto__;
  } else {
    var h__4030__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4030__auto____$1;
    return h__4030__auto____$1;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  if (other instanceof cljs.core.PersistentVector) {
    if (self__.cnt === cljs.core.count(other)) {
      var me_iter = coll__$1.cljs$core$IIterable$_iterator$arity$1(null);
      var you_iter = cljs.core._iterator(other);
      while (true) {
        if (me_iter.hasNext()) {
          var x = me_iter.next();
          var y = you_iter.next();
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x, y)) {
            continue;
          } else {
            return false;
          }
        } else {
          return true;
        }
        break;
      }
    } else {
      return false;
    }
  } else {
    return cljs.core.equiv_sequential(coll__$1, other);
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientVector(self__.cnt, self__.shift, cljs.core.tv_editable_root(self__.root), cljs.core.tv_editable_tail(self__.tail));
};
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var self__ = this;
  var v__$1 = this;
  return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(v__$1, f, 0, self__.cnt);
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, init) {
  var self__ = this;
  var v__$1 = this;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.cnt) {
      var arr = cljs.core.unchecked_array_for(v__$1, i);
      var len = arr.length;
      var init__$2 = function() {
        var j = 0;
        var init__$2 = init__$1;
        while (true) {
          if (j < len) {
            var init__$3 = function() {
              var G__5923 = init__$2;
              var G__5924 = arr[j];
              return f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5923, G__5924) : f.call(null, G__5923, G__5924);
            }();
            if (cljs.core.reduced_QMARK_(init__$3)) {
              return init__$3;
            } else {
              var G__5931 = j + 1;
              var G__5932 = init__$3;
              j = G__5931;
              init__$2 = G__5932;
              continue;
            }
          } else {
            return init__$2;
          }
          break;
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref(init__$2);
      } else {
        var G__5933 = i + len;
        var G__5934 = init__$2;
        i = G__5933;
        init__$1 = G__5934;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return coll__$1.cljs$core$IVector$_assoc_n$arity$3(null, k, v);
  } else {
    throw new Error("Vector's key for assoc must be a number.");
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.integer_QMARK_(k)) {
    return 0 <= k && k < self__.cnt;
  } else {
    return false;
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt === 0) {
    return null;
  } else {
    if (self__.cnt <= 32) {
      return new cljs.core.IndexedSeq(self__.tail, 0, null);
    } else {
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(coll__$1, cljs.core.first_array_for_longvec(coll__$1), 0, 0);
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentVector(meta__$1, self__.cnt, self__.shift, self__.root, self__.tail, self__.__hash);
};
cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.cnt - cljs.core.tail_off(coll__$1) < 32) {
    var len = self__.tail.length;
    var new_tail = new Array(len + 1);
    var n__4376__auto___5935 = len;
    var i_5936 = 0;
    while (true) {
      if (i_5936 < n__4376__auto___5935) {
        new_tail[i_5936] = self__.tail[i_5936];
        var G__5937 = i_5936 + 1;
        i_5936 = G__5937;
        continue;
      } else {
      }
      break;
    }
    new_tail[len] = o;
    return new cljs.core.PersistentVector(self__.meta, self__.cnt + 1, self__.shift, self__.root, new_tail, null);
  } else {
    var root_overflow_QMARK_ = self__.cnt >>> 5 > 1 << self__.shift;
    var new_shift = root_overflow_QMARK_ ? self__.shift + 5 : self__.shift;
    var new_root = root_overflow_QMARK_ ? function() {
      var n_r = cljs.core.pv_fresh_node(null);
      cljs.core.pv_aset(n_r, 0, self__.root);
      cljs.core.pv_aset(n_r, 1, cljs.core.new_path(null, self__.shift, new cljs.core.VectorNode(null, self__.tail)));
      return n_r;
    }() : cljs.core.push_tail(coll__$1, self__.shift, self__.root, new cljs.core.VectorNode(null, self__.tail));
    return new cljs.core.PersistentVector(self__.meta, self__.cnt + 1, new_shift, new_root, [o], null);
  }
};
cljs.core.PersistentVector.prototype.call = function() {
  var G__5938 = null;
  var G__5938__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
  };
  var G__5938__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
  };
  G__5938 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5938__2.call(this, self__, k);
      case 3:
        return G__5938__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__5938.cljs$core$IFn$_invoke$arity$2 = G__5938__2;
  G__5938.cljs$core$IFn$_invoke$arity$3 = G__5938__3;
  return G__5938;
}();
cljs.core.PersistentVector.prototype.apply = function(self__, args5919) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args5919)));
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
};
cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
};
cljs.core.PersistentVector.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "shift", "shift", -1657295705, null), new cljs.core.Symbol(null, "root", "root", 1191874074, null), new cljs.core.Symbol(null, "tail", "tail", 494507963, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 
  1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentVector.cljs$lang$type = true;
cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector";
cljs.core.PersistentVector.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/PersistentVector");
};
cljs.core.__GT_PersistentVector = function cljs$core$__GT_PersistentVector(meta, cnt, shift, root, tail, __hash) {
  return new cljs.core.PersistentVector(meta, cnt, shift, root, tail, __hash);
};
cljs.core.PersistentVector.EMPTY_NODE = new cljs.core.VectorNode(null, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
cljs.core.PersistentVector.EMPTY = new cljs.core.PersistentVector(null, 0, 5, cljs.core.PersistentVector.EMPTY_NODE, [], cljs.core.empty_ordered_hash);
cljs.core.PersistentVector.fromArray = function(xs, no_clone) {
  var l = xs.length;
  var xs__$1 = no_clone ? xs : cljs.core.aclone(xs);
  if (l < 32) {
    return new cljs.core.PersistentVector(null, l, 5, cljs.core.PersistentVector.EMPTY_NODE, xs__$1, null);
  } else {
    var node = xs__$1.slice(0, 32);
    var v = new cljs.core.PersistentVector(null, 32, 5, cljs.core.PersistentVector.EMPTY_NODE, node, null);
    var i = 32;
    var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
    while (true) {
      if (i < l) {
        var G__5939 = i + 1;
        var G__5940 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out, xs__$1[i]);
        i = G__5939;
        out = G__5940;
        continue;
      } else {
        return cljs.core.persistent_BANG_(out);
      }
      break;
    }
  }
};
var G__5941_5944 = cljs.core.PersistentVector.prototype;
var G__5942_5945 = cljs.core.ITER_SYMBOL;
var G__5943_5946 = function(G__5941_5944, G__5942_5945) {
  return function() {
    var this__4438__auto__ = this;
    return cljs.core.es6_iterator(this__4438__auto__);
  };
}(G__5941_5944, G__5942_5945);
goog.object.set(G__5941_5944, G__5942_5945, G__5943_5946);
cljs.core.vec = function cljs$core$vec(coll) {
  if (cljs.core.array_QMARK_(coll)) {
    return cljs.core.PersistentVector.fromArray(coll, true);
  } else {
    return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_, cljs.core._as_transient(cljs.core.PersistentVector.EMPTY), coll));
  }
};
cljs.core.vector = function cljs$core$vector(var_args) {
  var args__4502__auto__ = [];
  var len__4499__auto___5948 = arguments.length;
  var i__4500__auto___5949 = 0;
  while (true) {
    if (i__4500__auto___5949 < len__4499__auto___5948) {
      args__4502__auto__.push(arguments[i__4500__auto___5949]);
      var G__5950 = i__4500__auto___5949 + 1;
      i__4500__auto___5949 = G__5950;
      continue;
    } else {
    }
    break;
  }
  var argseq__4503__auto__ = 0 < args__4502__auto__.length ? new cljs.core.IndexedSeq(args__4502__auto__.slice(0), 0, null) : null;
  return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__4503__auto__);
};
cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = function(args) {
  if (args instanceof cljs.core.IndexedSeq && args.i === 0) {
    return cljs.core.PersistentVector.fromArray(args.arr, true);
  } else {
    return cljs.core.vec(args);
  }
};
cljs.core.vector.cljs$lang$maxFixedArity = 0;
cljs.core.vector.cljs$lang$applyTo = function(seq5947) {
  var self__4487__auto__ = this;
  return self__4487__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq5947));
};
cljs.core.ChunkedSeq = function(vec, node, i, off, meta, __hash) {
  this.vec = vec;
  this.node = node;
  this.i = i;
  this.off = off;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 32375020;
  this.cljs$lang$protocol_mask$partition1$ = 1536;
};
cljs.core.ChunkedSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ChunkedSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ChunkedSeq.prototype.indexOf = function() {
  var G__5951 = null;
  var G__5951__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__5951__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__5951 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__5951__1.call(this, x);
      case 2:
        return G__5951__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__5951.cljs$core$IFn$_invoke$arity$1 = G__5951__1;
  G__5951.cljs$core$IFn$_invoke$arity$2 = G__5951__2;
  return G__5951;
}();
cljs.core.ChunkedSeq.prototype.lastIndexOf = function() {
  var G__5952 = null;
  var G__5952__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__5952__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__5952 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__5952__1.call(this, x);
      case 2:
        return G__5952__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__5952.cljs$core$IFn$_invoke$arity$1 = G__5952__1;
  G__5952.cljs$core$IFn$_invoke$arity$2 = G__5952__2;
  return G__5952;
}();
cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off + 1 < self__.node.length) {
    var s = cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec, self__.node, self__.i, self__.off + 1);
    if (s == null) {
      return null;
    } else {
      return s;
    }
  } else {
    return coll__$1.cljs$core$IChunkedNext$_chunked_next$arity$1(null);
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4030__auto__ = self__.__hash;
  if (!(h__4030__auto__ == null)) {
    return h__4030__auto__;
  } else {
    var h__4030__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4030__auto____$1;
    return h__4030__auto____$1;
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.List.EMPTY;
};
cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(self__.vec, f, self__.i + self__.off, cljs.core.count(self__.vec));
};
cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(self__.vec, f, start, self__.i + self__.off, cljs.core.count(self__.vec));
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.node[self__.off];
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.off + 1 < self__.node.length) {
    var s = cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec, self__.node, self__.i, self__.off + 1);
    if (s == null) {
      return cljs.core.List.EMPTY;
    } else {
      return s;
    }
  } else {
    return coll__$1.cljs$core$IChunkedSeq$_chunked_rest$arity$1(null);
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node, self__.off);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var end = self__.i + self__.node.length;
  if (end < cljs.core._count(self__.vec)) {
    return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec, cljs.core.unchecked_array_for(self__.vec, end), end, 0);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, m) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(self__.vec, self__.node, self__.i, self__.off, m);
};
cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var end = self__.i + self__.node.length;
  if (end < cljs.core._count(self__.vec)) {
    return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec, cljs.core.unchecked_array_for(self__.vec, end), end, 0);
  } else {
    return null;
  }
};
cljs.core.ChunkedSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "vec", "vec", 982683596, null), new cljs.core.Symbol(null, "node", "node", -2073234571, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "off", "off", -2047994980, null), new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 
  1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ChunkedSeq.cljs$lang$type = true;
cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq";
cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/ChunkedSeq");
};
cljs.core.__GT_ChunkedSeq = function cljs$core$__GT_ChunkedSeq(vec, node, i, off, meta, __hash) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, meta, __hash);
};
var G__5953_5956 = cljs.core.ChunkedSeq.prototype;
var G__5954_5957 = cljs.core.ITER_SYMBOL;
var G__5955_5958 = function(G__5953_5956, G__5954_5957) {
  return function() {
    var this__4438__auto__ = this;
    return cljs.core.es6_iterator(this__4438__auto__);
  };
}(G__5953_5956, G__5954_5957);
goog.object.set(G__5953_5956, G__5954_5957, G__5955_5958);
cljs.core.chunked_seq = function cljs$core$chunked_seq(var_args) {
  var G__5960 = arguments.length;
  switch(G__5960) {
    case 3:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 4:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 5:
      return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = function(vec, i, off) {
  return new cljs.core.ChunkedSeq(vec, cljs.core.array_for(vec, i), i, off, null, null);
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = function(vec, node, i, off) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, null, null);
};
cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = function(vec, node, i, off, meta) {
  return new cljs.core.ChunkedSeq(vec, node, i, off, meta, null);
};
cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5;
cljs.core.Subvec = function(meta, v, start, end, __hash) {
  this.meta = meta;
  this.v = v;
  this.start = start;
  this.end = end;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 167666463;
  this.cljs$lang$protocol_mask$partition1$ = 139264;
};
cljs.core.Subvec.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.Subvec.prototype.cljs$core$IFind$_find$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  if (n < 0) {
    return null;
  } else {
    var idx = self__.start + n;
    if (idx < self__.end) {
      return new cljs.core.MapEntry(n, cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.v, idx), null);
    } else {
      return null;
    }
  }
};
cljs.core.Subvec.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.Subvec.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.Subvec.prototype.indexOf = function() {
  var G__5969 = null;
  var G__5969__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__5969__2 = function(x, start__$1) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start__$1);
  };
  G__5969 = function(x, start__$1) {
    switch(arguments.length) {
      case 1:
        return G__5969__1.call(this, x);
      case 2:
        return G__5969__2.call(this, x, start__$1);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__5969.cljs$core$IFn$_invoke$arity$1 = G__5969__1;
  G__5969.cljs$core$IFn$_invoke$arity$2 = G__5969__2;
  return G__5969;
}();
cljs.core.Subvec.prototype.lastIndexOf = function() {
  var G__5970 = null;
  var G__5970__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__5970__2 = function(x, start__$1) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start__$1);
  };
  G__5970 = function(x, start__$1) {
    switch(arguments.length) {
      case 1:
        return G__5970__1.call(this, x);
      case 2:
        return G__5970__2.call(this, x, start__$1);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__5970.cljs$core$IFn$_invoke$arity$1 = G__5970__1;
  G__5970.cljs$core$IFn$_invoke$arity$2 = G__5970__2;
  return G__5970;
}();
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1.cljs$core$ILookup$_lookup$arity$3(null, k, null);
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return coll__$1.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var i = self__.start;
  var j = 0;
  var init__$1 = init;
  while (true) {
    if (i < self__.end) {
      var init__$2 = function() {
        var G__5963 = init__$1;
        var G__5964 = j;
        var G__5965 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, i);
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__5963, G__5964, G__5965) : f.call(null, G__5963, G__5964, G__5965);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref(init__$2);
      } else {
        var G__5971 = i + 1;
        var G__5972 = j + 1;
        var G__5973 = init__$2;
        i = G__5971;
        j = G__5972;
        init__$1 = G__5973;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  if (n < 0 || self__.end <= self__.start + n) {
    return cljs.core.vector_index_out_of_bounds(n, self__.end - self__.start);
  } else {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, self__.start + n);
  }
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (n < 0 || self__.end <= self__.start + n) {
    return not_found;
  } else {
    return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v, self__.start + n, not_found);
  }
};
cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var self__ = this;
  var coll__$1 = this;
  var v_pos = self__.start + n;
  if (n < 0 || self__.end + 1 <= v_pos) {
    throw new Error(["Index ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(n), " out of bounds [0,", cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll__$1.cljs$core$ICounted$_count$arity$1(null)), "]"].join(""));
  } else {
    return cljs.core.build_subvec(self__.meta, cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v, v_pos, val), self__.start, function() {
      var x__4006__auto__ = self__.end;
      var y__4007__auto__ = v_pos + 1;
      return x__4006__auto__ > y__4007__auto__ ? x__4006__auto__ : y__4007__auto__;
    }(), null);
  }
};
cljs.core.Subvec.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (!(self__.v == null) ? false || cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$ ? true : false : false) {
    return cljs.core.ranged_iterator(self__.v, self__.start, self__.end);
  } else {
    return cljs.core.seq_iter(coll__$1);
  }
};
cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.Subvec(self__.meta, self__.v, self__.start, self__.end, self__.__hash);
};
cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.end - self__.start;
};
cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, self__.end - 1);
};
cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.start === self__.end) {
    throw new Error("Can't pop empty vector");
  } else {
    return cljs.core.build_subvec(self__.meta, self__.v, self__.start, self__.end - 1, null);
  }
};
cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (!(self__.start === self__.end)) {
    return new cljs.core.RSeq(coll__$1, self__.end - self__.start - 1, null);
  } else {
    return null;
  }
};
cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4030__auto__ = self__.__hash;
  if (!(h__4030__auto__ == null)) {
    return h__4030__auto__;
  } else {
    var h__4030__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4030__auto____$1;
    return h__4030__auto____$1;
  }
};
cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY, self__.meta);
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  if (!(self__.v == null) ? false || cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$ ? true : false : false) {
    return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(self__.v, f, self__.start, self__.end);
  } else {
    return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1, f);
  }
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  if (!(self__.v == null) ? false || cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$ ? true : false : false) {
    return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(self__.v, f, init, self__.start, self__.end);
  } else {
    return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1, f, init);
  }
};
cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, key, val) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof key === "number") {
    return coll__$1.cljs$core$IVector$_assoc_n$arity$3(null, key, val);
  } else {
    throw new Error("Subvec's key for assoc must be a number.");
  }
};
cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var subvec_seq = function(coll__$1) {
    return function cljs$core$subvec_seq(i) {
      if (i === self__.end) {
        return null;
      } else {
        return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v, i), new cljs.core.LazySeq(null, function(coll__$1) {
          return function() {
            return cljs$core$subvec_seq(i + 1);
          };
        }(coll__$1), null, null));
      }
    };
  }(coll__$1);
  return subvec_seq(self__.start);
};
cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.build_subvec(meta__$1, self__.v, self__.start, self__.end, self__.__hash);
};
cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.build_subvec(self__.meta, cljs.core._assoc_n(self__.v, self__.end, o), self__.start, self__.end + 1, null);
};
cljs.core.Subvec.prototype.call = function() {
  var G__5974 = null;
  var G__5974__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
  };
  var G__5974__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
  };
  G__5974 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__5974__2.call(this, self__, k);
      case 3:
        return G__5974__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__5974.cljs$core$IFn$_invoke$arity$2 = G__5974__2;
  G__5974.cljs$core$IFn$_invoke$arity$3 = G__5974__3;
  return G__5974;
}();
cljs.core.Subvec.prototype.apply = function(self__, args5962) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args5962)));
};
cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$2(null, k);
};
cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
};
cljs.core.Subvec.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "v", "v", 1661996586, null), new cljs.core.Symbol(null, "start", "start", 1285322546, null), new cljs.core.Symbol(null, "end", "end", 1372345569, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", 
  "mutable", 875778266), true], null))], null);
};
cljs.core.Subvec.cljs$lang$type = true;
cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec";
cljs.core.Subvec.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/Subvec");
};
cljs.core.__GT_Subvec = function cljs$core$__GT_Subvec(meta, v, start, end, __hash) {
  return new cljs.core.Subvec(meta, v, start, end, __hash);
};
var G__5975_5978 = cljs.core.Subvec.prototype;
var G__5976_5979 = cljs.core.ITER_SYMBOL;
var G__5977_5980 = function(G__5975_5978, G__5976_5979) {
  return function() {
    var this__4438__auto__ = this;
    return cljs.core.es6_iterator(this__4438__auto__);
  };
}(G__5975_5978, G__5976_5979);
goog.object.set(G__5975_5978, G__5976_5979, G__5977_5980);
cljs.core.build_subvec = function cljs$core$build_subvec(meta, v, start, end, __hash) {
  while (true) {
    if (v instanceof cljs.core.Subvec) {
      var G__5981 = meta;
      var G__5982 = v.v;
      var G__5983 = v.start + start;
      var G__5984 = v.start + end;
      var G__5985 = __hash;
      meta = G__5981;
      v = G__5982;
      start = G__5983;
      end = G__5984;
      __hash = G__5985;
      continue;
    } else {
      if (cljs.core.vector_QMARK_(v)) {
      } else {
        throw new Error("v must satisfy IVector");
      }
      var c_5986 = cljs.core.count(v);
      if (start < 0 || end < 0 || start > c_5986 || end > c_5986) {
        throw new Error("Index out of bounds");
      } else {
      }
      return new cljs.core.Subvec(meta, v, start, end, __hash);
    }
    break;
  }
};
cljs.core.subvec = function cljs$core$subvec(var_args) {
  var G__5988 = arguments.length;
  switch(G__5988) {
    case 2:
      return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2(arguments[0], arguments[1]);
      break;
    case 3:
      return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = function(v, start) {
  return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v, start, cljs.core.count(v));
};
cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = function(v, start, end) {
  if (!(start == null) && !(end == null)) {
  } else {
    throw new Error("Assert failed: (and (not (nil? start)) (not (nil? end)))");
  }
  return cljs.core.build_subvec(null, v, start | 0, end | 0, null);
};
cljs.core.subvec.cljs$lang$maxFixedArity = 3;
cljs.core.tv_ensure_editable = function cljs$core$tv_ensure_editable(edit, node) {
  if (edit === node.edit) {
    return node;
  } else {
    return new cljs.core.VectorNode(edit, cljs.core.aclone(node.arr));
  }
};
cljs.core.tv_editable_root = function cljs$core$tv_editable_root(node) {
  return new cljs.core.VectorNode({}, cljs.core.aclone(node.arr));
};
cljs.core.tv_editable_tail = function cljs$core$tv_editable_tail(tl) {
  var ret = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
  cljs.core.array_copy(tl, 0, ret, 0, tl.length);
  return ret;
};
cljs.core.tv_push_tail = function cljs$core$tv_push_tail(tv, level, parent, tail_node) {
  var ret = cljs.core.tv_ensure_editable(tv.root.edit, parent);
  var subidx = tv.cnt - 1 >>> level & 31;
  cljs.core.pv_aset(ret, subidx, level === 5 ? tail_node : function() {
    var child = cljs.core.pv_aget(ret, subidx);
    if (!(child == null)) {
      var G__5992 = tv;
      var G__5993 = level - 5;
      var G__5994 = child;
      var G__5995 = tail_node;
      return cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4(G__5992, G__5993, G__5994, G__5995) : cljs.core.tv_push_tail.call(null, G__5992, G__5993, G__5994, G__5995);
    } else {
      return cljs.core.new_path(tv.root.edit, level - 5, tail_node);
    }
  }());
  return ret;
};
cljs.core.tv_pop_tail = function cljs$core$tv_pop_tail(tv, level, node) {
  var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit, node);
  var subidx = tv.cnt - 2 >>> level & 31;
  if (level > 5) {
    var new_child = function() {
      var G__5996 = tv;
      var G__5997 = level - 5;
      var G__5998 = cljs.core.pv_aget(node__$1, subidx);
      return cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3(G__5996, G__5997, G__5998) : cljs.core.tv_pop_tail.call(null, G__5996, G__5997, G__5998);
    }();
    if (new_child == null && subidx === 0) {
      return null;
    } else {
      cljs.core.pv_aset(node__$1, subidx, new_child);
      return node__$1;
    }
  } else {
    if (subidx === 0) {
      return null;
    } else {
      cljs.core.pv_aset(node__$1, subidx, null);
      return node__$1;
    }
  }
};
cljs.core.unchecked_editable_array_for = function cljs$core$unchecked_editable_array_for(tv, i) {
  if (i >= cljs.core.tail_off(tv)) {
    return tv.tail;
  } else {
    var root = tv.root;
    var node = root;
    var level = tv.shift;
    while (true) {
      if (level > 0) {
        var G__5999 = cljs.core.tv_ensure_editable(root.edit, cljs.core.pv_aget(node, i >>> level & 31));
        var G__6000 = level - 5;
        node = G__5999;
        level = G__6000;
        continue;
      } else {
        return node.arr;
      }
      break;
    }
  }
};
cljs.core.TransientVector = function(cnt, shift, root, tail) {
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.cljs$lang$protocol_mask$partition1$ = 88;
  this.cljs$lang$protocol_mask$partition0$ = 275;
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (self__.cnt - cljs.core.tail_off(tcoll__$1) < 32) {
      self__.tail[self__.cnt & 31] = o;
      self__.cnt = self__.cnt + 1;
      return tcoll__$1;
    } else {
      var tail_node = new cljs.core.VectorNode(self__.root.edit, self__.tail);
      var new_tail = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
      new_tail[0] = o;
      self__.tail = new_tail;
      if (self__.cnt >>> 5 > 1 << self__.shift) {
        var new_root_array = [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null];
        var new_shift = self__.shift + 5;
        new_root_array[0] = self__.root;
        new_root_array[1] = cljs.core.new_path(self__.root.edit, self__.shift, tail_node);
        self__.root = new cljs.core.VectorNode(self__.root.edit, new_root_array);
        self__.shift = new_shift;
        self__.cnt = self__.cnt + 1;
        return tcoll__$1;
      } else {
        var new_root = cljs.core.tv_push_tail(tcoll__$1, self__.shift, self__.root, tail_node);
        self__.root = new_root;
        self__.cnt = self__.cnt + 1;
        return tcoll__$1;
      }
    }
  } else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    self__.root.edit = null;
    var len = self__.cnt - cljs.core.tail_off(tcoll__$1);
    var trimmed_tail = new Array(len);
    cljs.core.array_copy(self__.tail, 0, trimmed_tail, 0, len);
    return new cljs.core.PersistentVector(null, self__.cnt, self__.shift, self__.root, trimmed_tail, null);
  } else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (typeof key === "number") {
    return tcoll__$1.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(null, key, val);
  } else {
    throw new Error("TransientVector's key for assoc! must be a number.");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = function(tcoll, n, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (0 <= n && n < self__.cnt) {
      if (cljs.core.tail_off(tcoll__$1) <= n) {
        self__.tail[n & 31] = val;
        return tcoll__$1;
      } else {
        var new_root = function() {
          var fexpr__6002 = function(tcoll__$1) {
            return function cljs$core$go(level, node) {
              var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit, node);
              if (level === 0) {
                cljs.core.pv_aset(node__$1, n & 31, val);
                return node__$1;
              } else {
                var subidx = n >>> level & 31;
                cljs.core.pv_aset(node__$1, subidx, cljs$core$go(level - 5, cljs.core.pv_aget(node__$1, subidx)));
                return node__$1;
              }
            };
          }(tcoll__$1);
          return fexpr__6002(self__.shift, self__.root);
        }();
        self__.root = new_root;
        return tcoll__$1;
      }
    } else {
      if (n === self__.cnt) {
        return tcoll__$1.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null, val);
      } else {
        throw new Error(["Index ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(n), " out of bounds for TransientVector of length", cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt)].join(""));
      }
    }
  } else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (self__.root.edit) {
    if (self__.cnt === 0) {
      throw new Error("Can't pop empty vector");
    } else {
      if (1 === self__.cnt) {
        self__.cnt = 0;
        return tcoll__$1;
      } else {
        if ((self__.cnt - 1 & 31) > 0) {
          self__.cnt = self__.cnt - 1;
          return tcoll__$1;
        } else {
          var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1, self__.cnt - 2);
          var new_root = function() {
            var nr = cljs.core.tv_pop_tail(tcoll__$1, self__.shift, self__.root);
            if (!(nr == null)) {
              return nr;
            } else {
              return new cljs.core.VectorNode(self__.root.edit, [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null]);
            }
          }();
          if (5 < self__.shift && cljs.core.pv_aget(new_root, 1) == null) {
            var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit, cljs.core.pv_aget(new_root, 0));
            self__.root = new_root__$1;
            self__.shift = self__.shift - 5;
            self__.cnt = self__.cnt - 1;
            self__.tail = new_tail;
            return tcoll__$1;
          } else {
            self__.root = new_root;
            self__.cnt = self__.cnt - 1;
            self__.tail = new_tail;
            return tcoll__$1;
          }
        }
      }
    }
  } else {
    throw new Error("pop! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.root.edit) {
    return self__.cnt;
  } else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.root.edit) {
    return cljs.core.array_for(coll__$1, n)[n & 31];
  } else {
    throw new Error("nth after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (0 <= n && n < self__.cnt) {
    return coll__$1.cljs$core$IIndexed$_nth$arity$2(null, n);
  } else {
    return not_found;
  }
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1.cljs$core$ILookup$_lookup$arity$3(null, k, null);
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (typeof k === "number") {
    return coll__$1.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
  } else {
    return not_found;
  }
};
cljs.core.TransientVector.prototype.call = function() {
  var G__6003 = null;
  var G__6003__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__6003__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__6003 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6003__2.call(this, self__, k);
      case 3:
        return G__6003__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__6003.cljs$core$IFn$_invoke$arity$2 = G__6003__2;
  G__6003.cljs$core$IFn$_invoke$arity$3 = G__6003__3;
  return G__6003;
}();
cljs.core.TransientVector.prototype.apply = function(self__, args6001) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args6001)));
};
cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.TransientVector.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "shift", "shift", -1657295705, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, 
  "root", "root", 1191874074, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "tail", "tail", 494507963, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.TransientVector.cljs$lang$type = true;
cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector";
cljs.core.TransientVector.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/TransientVector");
};
cljs.core.__GT_TransientVector = function cljs$core$__GT_TransientVector(cnt, shift, root, tail) {
  return new cljs.core.TransientVector(cnt, shift, root, tail);
};
cljs.core.PersistentQueueIter = function(fseq, riter) {
  this.fseq = fseq;
  this.riter = riter;
};
cljs.core.PersistentQueueIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  var or__3922__auto__ = !(self__.fseq == null) && cljs.core.seq(self__.fseq);
  if (or__3922__auto__) {
    return or__3922__auto__;
  } else {
    var and__3911__auto__ = !(self__.riter == null);
    if (and__3911__auto__) {
      return self__.riter.hasNext();
    } else {
      return and__3911__auto__;
    }
  }
};
cljs.core.PersistentQueueIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.fseq == null)) {
    var ret = cljs.core.first(self__.fseq);
    self__.fseq = cljs.core.next(self__.fseq);
    return ret;
  } else {
    if (!(self__.riter == null) && self__.riter.hasNext()) {
      return self__.riter.next();
    } else {
      throw new Error("No such element");
    }
  }
};
cljs.core.PersistentQueueIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.PersistentQueueIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "fseq", "fseq", -1466412450, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, "riter", "riter", -237834262, null)], null);
};
cljs.core.PersistentQueueIter.cljs$lang$type = true;
cljs.core.PersistentQueueIter.cljs$lang$ctorStr = "cljs.core/PersistentQueueIter";
cljs.core.PersistentQueueIter.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/PersistentQueueIter");
};
cljs.core.__GT_PersistentQueueIter = function cljs$core$__GT_PersistentQueueIter(fseq, riter) {
  return new cljs.core.PersistentQueueIter(fseq, riter);
};
cljs.core.PersistentQueueSeq = function(meta, front, rear, __hash) {
  this.meta = meta;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 31850700;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.PersistentQueueSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentQueueSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentQueueSeq.prototype.indexOf = function() {
  var G__6004 = null;
  var G__6004__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__6004__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__6004 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__6004__1.call(this, x);
      case 2:
        return G__6004__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__6004.cljs$core$IFn$_invoke$arity$1 = G__6004__1;
  G__6004.cljs$core$IFn$_invoke$arity$2 = G__6004__2;
  return G__6004;
}();
cljs.core.PersistentQueueSeq.prototype.lastIndexOf = function() {
  var G__6005 = null;
  var G__6005__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__6005__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__6005 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__6005__1.call(this, x);
      case 2:
        return G__6005__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__6005.cljs$core$IFn$_invoke$arity$1 = G__6005__1;
  G__6005.cljs$core$IFn$_invoke$arity$2 = G__6005__2;
  return G__6005;
}();
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var temp__5455__auto__ = cljs.core.next(self__.front);
  if (temp__5455__auto__) {
    var f1 = temp__5455__auto__;
    return new cljs.core.PersistentQueueSeq(self__.meta, f1, self__.rear, null);
  } else {
    if (!(self__.rear == null)) {
      return new cljs.core.PersistentQueueSeq(self__.meta, self__.rear, null, null);
    } else {
      return null;
    }
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4030__auto__ = self__.__hash;
  if (!(h__4030__auto__ == null)) {
    return h__4030__auto__;
  } else {
    var h__4030__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4030__auto____$1;
    return h__4030__auto____$1;
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.List.EMPTY, self__.meta);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var temp__5455__auto__ = cljs.core.next(self__.front);
  if (temp__5455__auto__) {
    var f1 = temp__5455__auto__;
    return new cljs.core.PersistentQueueSeq(self__.meta, f1, self__.rear, null);
  } else {
    if (self__.rear == null) {
      return coll__$1.cljs$core$IEmptyableCollection$_empty$arity$1(null);
    } else {
      return new cljs.core.PersistentQueueSeq(self__.meta, self__.rear, null, null);
    }
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueueSeq(meta__$1, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.PersistentQueueSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "front", "front", 117022539, null), new cljs.core.Symbol(null, "rear", "rear", -900164830, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentQueueSeq.cljs$lang$type = true;
cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq";
cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/PersistentQueueSeq");
};
cljs.core.__GT_PersistentQueueSeq = function cljs$core$__GT_PersistentQueueSeq(meta, front, rear, __hash) {
  return new cljs.core.PersistentQueueSeq(meta, front, rear, __hash);
};
var G__6006_6009 = cljs.core.PersistentQueueSeq.prototype;
var G__6007_6010 = cljs.core.ITER_SYMBOL;
var G__6008_6011 = function(G__6006_6009, G__6007_6010) {
  return function() {
    var this__4438__auto__ = this;
    return cljs.core.es6_iterator(this__4438__auto__);
  };
}(G__6006_6009, G__6007_6010);
goog.object.set(G__6006_6009, G__6007_6010, G__6008_6011);
cljs.core.PersistentQueue = function(meta, count, front, rear, __hash) {
  this.meta = meta;
  this.count = count;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 139264;
  this.cljs$lang$protocol_mask$partition0$ = 31858766;
};
cljs.core.PersistentQueue.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentQueue.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentQueue.prototype.indexOf = function() {
  var G__6012 = null;
  var G__6012__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__6012__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__6012 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__6012__1.call(this, x);
      case 2:
        return G__6012__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__6012.cljs$core$IFn$_invoke$arity$1 = G__6012__1;
  G__6012.cljs$core$IFn$_invoke$arity$2 = G__6012__2;
  return G__6012;
}();
cljs.core.PersistentQueue.prototype.lastIndexOf = function() {
  var G__6013 = null;
  var G__6013__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, self__.count.cljs$core$IFn$_invoke$arity$1 ? self__.count.cljs$core$IFn$_invoke$arity$1(coll) : self__.count.call(null, coll));
  };
  var G__6013__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__6013 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__6013__1.call(this, x);
      case 2:
        return G__6013__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__6013.cljs$core$IFn$_invoke$arity$1 = G__6013__1;
  G__6013.cljs$core$IFn$_invoke$arity$2 = G__6013__2;
  return G__6013;
}();
cljs.core.PersistentQueue.prototype.cljs$core$IIterable$_iterator$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueueIter(self__.front, cljs.core._iterator(self__.rear));
};
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueue(self__.meta, self__.count, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.count;
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(self__.front)) {
    var temp__5455__auto__ = cljs.core.next(self__.front);
    if (temp__5455__auto__) {
      var f1 = temp__5455__auto__;
      return new cljs.core.PersistentQueue(self__.meta, self__.count - 1, f1, self__.rear, null);
    } else {
      return new cljs.core.PersistentQueue(self__.meta, self__.count - 1, cljs.core.seq(self__.rear), cljs.core.PersistentVector.EMPTY, null);
    }
  } else {
    return coll__$1;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4030__auto__ = self__.__hash;
  if (!(h__4030__auto__ == null)) {
    return h__4030__auto__;
  } else {
    var h__4030__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4030__auto____$1;
    return h__4030__auto____$1;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.PersistentQueue.EMPTY, self__.meta);
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.first(self__.front);
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.rest(cljs.core.seq(coll__$1));
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var rear__$1 = cljs.core.seq(self__.rear);
  if (cljs.core.truth_(function() {
    var or__3922__auto__ = self__.front;
    if (cljs.core.truth_(or__3922__auto__)) {
      return or__3922__auto__;
    } else {
      return rear__$1;
    }
  }())) {
    return new cljs.core.PersistentQueueSeq(null, self__.front, cljs.core.seq(rear__$1), null);
  } else {
    return null;
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentQueue(meta__$1, self__.count, self__.front, self__.rear, self__.__hash);
};
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.truth_(self__.front)) {
    return new cljs.core.PersistentQueue(self__.meta, self__.count + 1, self__.front, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(function() {
      var or__3922__auto__ = self__.rear;
      if (cljs.core.truth_(or__3922__auto__)) {
        return or__3922__auto__;
      } else {
        return cljs.core.PersistentVector.EMPTY;
      }
    }(), o), null);
  } else {
    return new cljs.core.PersistentQueue(self__.meta, self__.count + 1, cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front, o), cljs.core.PersistentVector.EMPTY, null);
  }
};
cljs.core.PersistentQueue.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "count", "count", -514511684, null), new cljs.core.Symbol(null, "front", "front", 117022539, null), new cljs.core.Symbol(null, "rear", "rear", -900164830, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentQueue.cljs$lang$type = true;
cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue";
cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/PersistentQueue");
};
cljs.core.__GT_PersistentQueue = function cljs$core$__GT_PersistentQueue(meta, count, front, rear, __hash) {
  return new cljs.core.PersistentQueue(meta, count, front, rear, __hash);
};
cljs.core.PersistentQueue.EMPTY = new cljs.core.PersistentQueue(null, 0, null, cljs.core.PersistentVector.EMPTY, cljs.core.empty_ordered_hash);
var G__6014_6017 = cljs.core.PersistentQueue.prototype;
var G__6015_6018 = cljs.core.ITER_SYMBOL;
var G__6016_6019 = function(G__6014_6017, G__6015_6018) {
  return function() {
    var this__4438__auto__ = this;
    return cljs.core.es6_iterator(this__4438__auto__);
  };
}(G__6014_6017, G__6015_6018);
goog.object.set(G__6014_6017, G__6015_6018, G__6016_6019);
cljs.core.NeverEquiv = function() {
  this.cljs$lang$protocol_mask$partition0$ = 2097152;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.NeverEquiv.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var self__ = this;
  var o__$1 = this;
  return false;
};
cljs.core.NeverEquiv.getBasis = function() {
  return cljs.core.PersistentVector.EMPTY;
};
cljs.core.NeverEquiv.cljs$lang$type = true;
cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv";
cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/NeverEquiv");
};
cljs.core.__GT_NeverEquiv = function cljs$core$__GT_NeverEquiv() {
  return new cljs.core.NeverEquiv;
};
cljs.core.never_equiv = new cljs.core.NeverEquiv;
cljs.core.equiv_map = function cljs$core$equiv_map(x, y) {
  return cljs.core.boolean$(cljs.core.map_QMARK_(y) && !cljs.core.record_QMARK_(y) ? cljs.core.count(x) === cljs.core.count(y) ? (!(x == null) ? x.cljs$lang$protocol_mask$partition0$ & 1048576 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IKVReduce$ ? true : !x.cljs$lang$protocol_mask$partition0$ ? cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce, x) : false : cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce, x)) ? cljs.core.reduce_kv(function(_, k, v) {
    if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y, k, cljs.core.never_equiv), v)) {
      return true;
    } else {
      return cljs.core.reduced(false);
    }
  }, true, x) : cljs.core.every_QMARK_(function(xkv) {
    return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y, cljs.core.first(xkv), cljs.core.never_equiv), cljs.core.second(xkv));
  }, x) : null : null);
};
cljs.core.scan_array = function cljs$core$scan_array(incr, k, array) {
  var len = array.length;
  var i = 0;
  while (true) {
    if (i < len) {
      if (k === array[i]) {
        return i;
      } else {
        var G__6021 = i + incr;
        i = G__6021;
        continue;
      }
    } else {
      return null;
    }
    break;
  }
};
cljs.core.obj_map_compare_keys = function cljs$core$obj_map_compare_keys(a, b) {
  var a__$1 = cljs.core.hash(a);
  var b__$1 = cljs.core.hash(b);
  if (a__$1 < b__$1) {
    return -1;
  } else {
    if (a__$1 > b__$1) {
      return 1;
    } else {
      return 0;
    }
  }
};
cljs.core.obj_map__GT_hash_map = function cljs$core$obj_map__GT_hash_map(m, k, v) {
  var ks = m.keys;
  var len = ks.length;
  var so = m.strobj;
  var mm = cljs.core.meta(m);
  var i = 0;
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  while (true) {
    if (i < len) {
      var k__$1 = ks[i];
      var G__6022 = i + 1;
      var G__6023 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, k__$1, goog.object.get(so, k__$1));
      i = G__6022;
      out = G__6023;
      continue;
    } else {
      return cljs.core._with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, k, v)), mm);
    }
    break;
  }
};
cljs.core.obj_clone = function cljs$core$obj_clone(obj, ks) {
  var new_obj = {};
  var l = ks.length;
  var i_6029 = 0;
  while (true) {
    if (i_6029 < l) {
      var k_6030 = ks[i_6029];
      var G__6026_6031 = new_obj;
      var G__6027_6032 = k_6030;
      var G__6028_6033 = goog.object.get(obj, k_6030);
      goog.object.set(G__6026_6031, G__6027_6032, G__6028_6033);
      var G__6034 = i_6029 + 1;
      i_6029 = G__6034;
      continue;
    } else {
    }
    break;
  }
  return new_obj;
};
cljs.core.ObjMap = function(meta, keys, strobj, update_count, __hash) {
  this.meta = meta;
  this.keys = keys;
  this.strobj = strobj;
  this.update_count = update_count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 16123663;
  this.cljs$lang$protocol_mask$partition1$ = 4;
};
cljs.core.ObjMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.ObjMap.prototype.cljs$core$IFind$_find$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (goog.isString(k) && !(cljs.core.scan_array(1, k, self__.keys) == null)) {
    return new cljs.core.MapEntry(k, self__.strobj[k], null);
  } else {
    return null;
  }
};
cljs.core.ObjMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.ObjMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1.cljs$core$ILookup$_lookup$arity$3(null, k, null);
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  if (goog.isString(k) && !(cljs.core.scan_array(1, k, self__.keys) == null)) {
    return self__.strobj[k];
  } else {
    return not_found;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var len = self__.keys.length;
  var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
  var init__$1 = init;
  while (true) {
    if (cljs.core.seq(keys__$1)) {
      var k = cljs.core.first(keys__$1);
      var init__$2 = function() {
        var G__6037 = init__$1;
        var G__6038 = k;
        var G__6039 = self__.strobj[k];
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__6037, G__6038, G__6039) : f.call(null, G__6037, G__6038, G__6039);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref(init__$2);
      } else {
        var G__6040 = cljs.core.rest(keys__$1);
        var G__6041 = init__$2;
        keys__$1 = G__6040;
        init__$1 = G__6041;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.keys.length;
};
cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4030__auto__ = self__.__hash;
  if (!(h__4030__auto__ == null)) {
    return h__4030__auto__;
  } else {
    var h__4030__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__4030__auto____$1;
    return h__4030__auto____$1;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_map(coll__$1, other);
};
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY, coll__$1));
};
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.ObjMap.EMPTY, self__.meta);
};
cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (goog.isString(k) && !(cljs.core.scan_array(1, k, self__.keys) == null)) {
    var new_keys = cljs.core.aclone(self__.keys);
    var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
    new_keys.splice(cljs.core.scan_array(1, k, new_keys), 1);
    delete new_strobj[k];
    return new cljs.core.ObjMap(self__.meta, new_keys, new_strobj, self__.update_count + 1, null);
  } else {
    return coll__$1;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  if (goog.isString(k)) {
    if (self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD || self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD) {
      return cljs.core.obj_map__GT_hash_map(coll__$1, k, v);
    } else {
      if (!(cljs.core.scan_array(1, k, self__.keys) == null)) {
        var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
        goog.object.set(new_strobj, k, v);
        return new cljs.core.ObjMap(self__.meta, self__.keys, new_strobj, self__.update_count + 1, null);
      } else {
        var new_strobj = cljs.core.obj_clone(self__.strobj, self__.keys);
        var new_keys = cljs.core.aclone(self__.keys);
        goog.object.set(new_strobj, k, v);
        new_keys.push(k);
        return new cljs.core.ObjMap(self__.meta, new_keys, new_strobj, self__.update_count + 1, null);
      }
    }
  } else {
    return cljs.core.obj_map__GT_hash_map(coll__$1, k, v);
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  if (goog.isString(k) && !(cljs.core.scan_array(1, k, self__.keys) == null)) {
    return true;
  } else {
    return false;
  }
};
cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.keys.length > 0) {
    return cljs.core.map.cljs$core$IFn$_invoke$arity$2(function(coll__$1) {
      return function(p1__6035_SHARP_) {
        return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__6035_SHARP_, self__.strobj[p1__6035_SHARP_]], null);
      };
    }(coll__$1), self__.keys.sort(cljs.core.obj_map_compare_keys));
  } else {
    return null;
  }
};
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.ObjMap(meta__$1, self__.keys, self__.strobj, self__.update_count, self__.__hash);
};
cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj, coll__$1, entry);
  }
};
cljs.core.ObjMap.prototype.call = function() {
  var G__6042 = null;
  var G__6042__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__6042__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__6042 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6042__2.call(this, self__, k);
      case 3:
        return G__6042__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__6042.cljs$core$IFn$_invoke$arity$2 = G__6042__2;
  G__6042.cljs$core$IFn$_invoke$arity$3 = G__6042__3;
  return G__6042;
}();
cljs.core.ObjMap.prototype.apply = function(self__, args6036) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args6036)));
};
cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.ObjMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "keys", "keys", -1586012071, null), new cljs.core.Symbol(null, "strobj", "strobj", 1088091283, null), new cljs.core.Symbol(null, "update-count", "update-count", -411982269, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ObjMap.cljs$lang$type = true;
cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap";
cljs.core.ObjMap.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/ObjMap");
};
cljs.core.__GT_ObjMap = function cljs$core$__GT_ObjMap(meta, keys, strobj, update_count, __hash) {
  return new cljs.core.ObjMap(meta, keys, strobj, update_count, __hash);
};
cljs.core.ObjMap.EMPTY = new cljs.core.ObjMap(null, [], {}, 0, cljs.core.empty_unordered_hash);
cljs.core.ObjMap.HASHMAP_THRESHOLD = 8;
cljs.core.ObjMap.fromObject = function(ks, obj) {
  return new cljs.core.ObjMap(null, ks, obj, 0, null);
};
cljs.core.RecordIter = function(i, record, base_count, fields, ext_map_iter) {
  this.i = i;
  this.record = record;
  this.base_count = base_count;
  this.fields = fields;
  this.ext_map_iter = ext_map_iter;
};
cljs.core.RecordIter.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  var or__3922__auto__ = self__.i < self__.base_count;
  if (or__3922__auto__) {
    return or__3922__auto__;
  } else {
    return self__.ext_map_iter.hasNext();
  }
};
cljs.core.RecordIter.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (self__.i < self__.base_count) {
    var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.fields, self__.i);
    self__.i = self__.i + 1;
    return new cljs.core.MapEntry(k, cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.record, k), null);
  } else {
    return self__.ext_map_iter.next();
  }
};
cljs.core.RecordIter.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.RecordIter.getBasis = function() {
  return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, "record", "record", 861424668, null), new cljs.core.Symbol(null, "base-count", "base-count", -1180647182, null), new cljs.core.Symbol(null, "fields", "fields", -291534703, null), new cljs.core.Symbol(null, 
  "ext-map-iter", "ext-map-iter", -1215982757, null)], null);
};
cljs.core.RecordIter.cljs$lang$type = true;
cljs.core.RecordIter.cljs$lang$ctorStr = "cljs.core/RecordIter";
cljs.core.RecordIter.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/RecordIter");
};
cljs.core.__GT_RecordIter = function cljs$core$__GT_RecordIter(i, record, base_count, fields, ext_map_iter) {
  return new cljs.core.RecordIter(i, record, base_count, fields, ext_map_iter);
};
cljs.core.ES6EntriesIterator = function(s) {
  this.s = s;
};
cljs.core.ES6EntriesIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var vec__6045 = cljs.core.first(self__.s);
    var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6045, 0, null);
    var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6045, 1, null);
    self__.s = cljs.core.next(self__.s);
    return {"value":[k, v], "done":false};
  } else {
    return {"value":null, "done":true};
  }
};
cljs.core.ES6EntriesIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ES6EntriesIterator.cljs$lang$type = true;
cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator";
cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/ES6EntriesIterator");
};
cljs.core.__GT_ES6EntriesIterator = function cljs$core$__GT_ES6EntriesIterator(s) {
  return new cljs.core.ES6EntriesIterator(s);
};
cljs.core.es6_entries_iterator = function cljs$core$es6_entries_iterator(coll) {
  return new cljs.core.ES6EntriesIterator(cljs.core.seq(coll));
};
cljs.core.ES6SetEntriesIterator = function(s) {
  this.s = s;
};
cljs.core.ES6SetEntriesIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  if (!(self__.s == null)) {
    var x = cljs.core.first(self__.s);
    self__.s = cljs.core.next(self__.s);
    return {"value":[x, x], "done":false};
  } else {
    return {"value":null, "done":true};
  }
};
cljs.core.ES6SetEntriesIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "s", "s", -948495851, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.ES6SetEntriesIterator.cljs$lang$type = true;
cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator";
cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/ES6SetEntriesIterator");
};
cljs.core.__GT_ES6SetEntriesIterator = function cljs$core$__GT_ES6SetEntriesIterator(s) {
  return new cljs.core.ES6SetEntriesIterator(s);
};
cljs.core.es6_set_entries_iterator = function cljs$core$es6_set_entries_iterator(coll) {
  return new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll));
};
cljs.core.array_index_of_nil_QMARK_ = function cljs$core$array_index_of_nil_QMARK_(arr) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (arr[i] == null) {
        return i;
      } else {
        var G__6048 = i + 2;
        i = G__6048;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_keyword_QMARK_ = function cljs$core$array_index_of_keyword_QMARK_(arr, k) {
  var len = arr.length;
  var kstr = k.fqn;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (arr[i] instanceof cljs.core.Keyword && kstr === arr[i].fqn) {
        return i;
      } else {
        var G__6049 = i + 2;
        i = G__6049;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_symbol_QMARK_ = function cljs$core$array_index_of_symbol_QMARK_(arr, k) {
  var len = arr.length;
  var kstr = k.str;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (arr[i] instanceof cljs.core.Symbol && kstr === arr[i].str) {
        return i;
      } else {
        var G__6050 = i + 2;
        i = G__6050;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_identical_QMARK_ = function cljs$core$array_index_of_identical_QMARK_(arr, k) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (k === arr[i]) {
        return i;
      } else {
        var G__6051 = i + 2;
        i = G__6051;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of_equiv_QMARK_ = function cljs$core$array_index_of_equiv_QMARK_(arr, k) {
  var len = arr.length;
  var i = 0;
  while (true) {
    if (len <= i) {
      return -1;
    } else {
      if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k, arr[i])) {
        return i;
      } else {
        var G__6052 = i + 2;
        i = G__6052;
        continue;
      }
    }
    break;
  }
};
cljs.core.array_index_of = function cljs$core$array_index_of(arr, k) {
  if (k instanceof cljs.core.Keyword) {
    return cljs.core.array_index_of_keyword_QMARK_(arr, k);
  } else {
    if (goog.isString(k) || typeof k === "number") {
      return cljs.core.array_index_of_identical_QMARK_(arr, k);
    } else {
      if (k instanceof cljs.core.Symbol) {
        return cljs.core.array_index_of_symbol_QMARK_(arr, k);
      } else {
        if (k == null) {
          return cljs.core.array_index_of_nil_QMARK_(arr);
        } else {
          return cljs.core.array_index_of_equiv_QMARK_(arr, k);
        }
      }
    }
  }
};
cljs.core.array_map_index_of = function cljs$core$array_map_index_of(m, k) {
  return cljs.core.array_index_of(m.arr, k);
};
cljs.core.array_extend_kv = function cljs$core$array_extend_kv(arr, k, v) {
  var l = arr.length;
  var narr = new Array(l + 2);
  var i_6053 = 0;
  while (true) {
    if (i_6053 < l) {
      narr[i_6053] = arr[i_6053];
      var G__6054 = i_6053 + 1;
      i_6053 = G__6054;
      continue;
    } else {
    }
    break;
  }
  narr[l] = k;
  narr[l + 1] = v;
  return narr;
};
cljs.core.array_map_extend_kv = function cljs$core$array_map_extend_kv(m, k, v) {
  return cljs.core.array_extend_kv(m.arr, k, v);
};
cljs.core.MapEntry = function(key, val, __hash) {
  this.key = key;
  this.val = val;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 166619935;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.MapEntry.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.MapEntry.prototype.cljs$core$IFind$_find$arity$2 = function(node, k) {
  var self__ = this;
  var node__$1 = this;
  var G__6056 = k;
  switch(G__6056) {
    case 0:
      return new cljs.core.MapEntry(0, self__.key, null);
      break;
    case 1:
      return new cljs.core.MapEntry(1, self__.val, null);
      break;
    default:
      return null;
  }
};
cljs.core.MapEntry.prototype.indexOf = function() {
  var G__6058 = null;
  var G__6058__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__6058__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__6058 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__6058__1.call(this, x);
      case 2:
        return G__6058__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__6058.cljs$core$IFn$_invoke$arity$1 = G__6058__1;
  G__6058.cljs$core$IFn$_invoke$arity$2 = G__6058__2;
  return G__6058;
}();
cljs.core.MapEntry.prototype.lastIndexOf = function() {
  var G__6059 = null;
  var G__6059__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__6059__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__6059 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__6059__1.call(this, x);
      case 2:
        return G__6059__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__6059.cljs$core$IFn$_invoke$arity$1 = G__6059__1;
  G__6059.cljs$core$IFn$_invoke$arity$2 = G__6059__2;
  return G__6059;
}();
cljs.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var self__ = this;
  var node__$1 = this;
  return node__$1.cljs$core$IIndexed$_nth$arity$3(null, k, null);
};
cljs.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var self__ = this;
  var node__$1 = this;
  return node__$1.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
};
cljs.core.MapEntry.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      throw new Error("Index out of bounds");
    }
  }
};
cljs.core.MapEntry.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var self__ = this;
  var node__$1 = this;
  if (n === 0) {
    return self__.key;
  } else {
    if (n === 1) {
      return self__.val;
    } else {
      return not_found;
    }
  }
};
cljs.core.MapEntry.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var self__ = this;
  var node__$1 = this;
  return (new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null)).cljs$core$IVector$_assoc_n$arity$3(null, n, v);
};
cljs.core.MapEntry.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return null;
};
cljs.core.MapEntry.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return 2;
};
cljs.core.MapEntry.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.key;
};
cljs.core.MapEntry.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.MapEntry.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return self__.val;
};
cljs.core.MapEntry.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
};
cljs.core.MapEntry.prototype.cljs$core$IReversible$_rseq$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.IndexedSeq([self__.val, self__.key], 0, null);
};
cljs.core.MapEntry.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4030__auto__ = self__.__hash;
  if (!(h__4030__auto__ == null)) {
    return h__4030__auto__;
  } else {
    var h__4030__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
    self__.__hash = h__4030__auto____$1;
    return h__4030__auto____$1;
  }
};
cljs.core.MapEntry.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.MapEntry.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return null;
};
cljs.core.MapEntry.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1, f);
};
cljs.core.MapEntry.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1, f, start);
};
cljs.core.MapEntry.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), k, v);
};
cljs.core.MapEntry.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(node, k) {
  var self__ = this;
  var node__$1 = this;
  return k === 0 || k === 1;
};
cljs.core.MapEntry.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.IndexedSeq([self__.key, self__.val], 0, null);
};
cljs.core.MapEntry.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var self__ = this;
  var node__$1 = this;
  return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val], null), meta);
};
cljs.core.MapEntry.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var self__ = this;
  var node__$1 = this;
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key, self__.val, o], null);
};
cljs.core.MapEntry.prototype.call = function() {
  var G__6060 = null;
  var G__6060__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$IIndexed$_nth$arity$2(null, k);
  };
  var G__6060__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var node = self____$1;
    return node.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
  };
  G__6060 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6060__2.call(this, self__, k);
      case 3:
        return G__6060__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__6060.cljs$core$IFn$_invoke$arity$2 = G__6060__2;
  G__6060.cljs$core$IFn$_invoke$arity$3 = G__6060__3;
  return G__6060;
}();
cljs.core.MapEntry.prototype.apply = function(self__, args6055) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args6055)));
};
cljs.core.MapEntry.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var node = this;
  return node.cljs$core$IIndexed$_nth$arity$2(null, k);
};
cljs.core.MapEntry.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var node = this;
  return node.cljs$core$IIndexed$_nth$arity$3(null, k, not_found);
};
cljs.core.MapEntry.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "key", "key", 124488940, null), new cljs.core.Symbol(null, "val", "val", 1769233139, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.MapEntry.cljs$lang$type = true;
cljs.core.MapEntry.cljs$lang$ctorStr = "cljs.core/MapEntry";
cljs.core.MapEntry.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/MapEntry");
};
cljs.core.__GT_MapEntry = function cljs$core$__GT_MapEntry(key, val, __hash) {
  return new cljs.core.MapEntry(key, val, __hash);
};
cljs.core.map_entry_QMARK_ = function cljs$core$map_entry_QMARK_(x) {
  if (!(x == null)) {
    if (x.cljs$lang$protocol_mask$partition0$ & 2048 || cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMapEntry$) {
      return true;
    } else {
      return false;
    }
  } else {
    return false;
  }
};
cljs.core.PersistentArrayMapSeq = function(arr, i, _meta) {
  this.arr = arr;
  this.i = i;
  this._meta = _meta;
  this.cljs$lang$protocol_mask$partition0$ = 32374990;
  this.cljs$lang$protocol_mask$partition1$ = 0;
};
cljs.core.PersistentArrayMapSeq.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentArrayMapSeq.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentArrayMapSeq.prototype.indexOf = function() {
  var G__6062 = null;
  var G__6062__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, 0);
  };
  var G__6062__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__6062 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__6062__1.call(this, x);
      case 2:
        return G__6062__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__6062.cljs$core$IFn$_invoke$arity$1 = G__6062__1;
  G__6062.cljs$core$IFn$_invoke$arity$2 = G__6062__2;
  return G__6062;
}();
cljs.core.PersistentArrayMapSeq.prototype.lastIndexOf = function() {
  var G__6063 = null;
  var G__6063__1 = function(x) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, cljs.core.count(coll));
  };
  var G__6063__2 = function(x, start) {
    var self__ = this;
    var coll = this;
    return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll, x, start);
  };
  G__6063 = function(x, start) {
    switch(arguments.length) {
      case 1:
        return G__6063__1.call(this, x);
      case 2:
        return G__6063__2.call(this, x, start);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__6063.cljs$core$IFn$_invoke$arity$1 = G__6063__1;
  G__6063.cljs$core$IFn$_invoke$arity$2 = G__6063__2;
  return G__6063;
}();
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__._meta;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i < self__.arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i + 2, self__._meta);
  } else {
    return null;
  }
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return (self__.arr.length - self__.i) / 2;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.hash_ordered_coll(coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.equiv_sequential(coll__$1, other);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.List.EMPTY, self__._meta);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f, coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f, start, coll__$1);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.MapEntry(self__.arr[self__.i], self__.arr[self__.i + 1], null);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  if (self__.i < self__.arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i + 2, self__._meta);
  } else {
    return cljs.core.List.EMPTY;
  }
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1;
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentArrayMapSeq(self__.arr, self__.i, new_meta);
};
cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.cons(o, coll__$1);
};
cljs.core.PersistentArrayMapSeq.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.Symbol(null, "_meta", "_meta", -1716892533, null)], null);
};
cljs.core.PersistentArrayMapSeq.cljs$lang$type = true;
cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq";
cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/PersistentArrayMapSeq");
};
cljs.core.__GT_PersistentArrayMapSeq = function cljs$core$__GT_PersistentArrayMapSeq(arr, i, _meta) {
  return new cljs.core.PersistentArrayMapSeq(arr, i, _meta);
};
var G__6064_6067 = cljs.core.PersistentArrayMapSeq.prototype;
var G__6065_6068 = cljs.core.ITER_SYMBOL;
var G__6066_6069 = function(G__6064_6067, G__6065_6068) {
  return function() {
    var this__4438__auto__ = this;
    return cljs.core.es6_iterator(this__4438__auto__);
  };
}(G__6064_6067, G__6065_6068);
goog.object.set(G__6064_6067, G__6065_6068, G__6066_6069);
cljs.core.persistent_array_map_seq = function cljs$core$persistent_array_map_seq(arr, i, _meta) {
  if (i <= arr.length - 2) {
    return new cljs.core.PersistentArrayMapSeq(arr, i, _meta);
  } else {
    return null;
  }
};
cljs.core.PersistentArrayMapIterator = function(arr, i, cnt) {
  this.arr = arr;
  this.i = i;
  this.cnt = cnt;
};
cljs.core.PersistentArrayMapIterator.prototype.hasNext = function() {
  var self__ = this;
  var _ = this;
  return self__.i < self__.cnt;
};
cljs.core.PersistentArrayMapIterator.prototype.next = function() {
  var self__ = this;
  var _ = this;
  var ret = new cljs.core.MapEntry(self__.arr[self__.i], self__.arr[self__.i + 1], null);
  self__.i = self__.i + 2;
  return ret;
};
cljs.core.PersistentArrayMapIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null)], null);
};
cljs.core.PersistentArrayMapIterator.cljs$lang$type = true;
cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator";
cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/PersistentArrayMapIterator");
};
cljs.core.__GT_PersistentArrayMapIterator = function cljs$core$__GT_PersistentArrayMapIterator(arr, i, cnt) {
  return new cljs.core.PersistentArrayMapIterator(arr, i, cnt);
};
cljs.core.PersistentArrayMap = function(meta, cnt, arr, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.arr = arr;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition0$ = 16647951;
  this.cljs$lang$protocol_mask$partition1$ = 139268;
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;
cljs.core.PersistentArrayMap.prototype.cljs$core$IFind$_find$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx === -1) {
    return null;
  } else {
    return new cljs.core.MapEntry(self__.arr[idx], self__.arr[idx + 1], null);
  }
};
cljs.core.PersistentArrayMap.prototype.toString = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.pr_str_STAR_(coll);
};
cljs.core.PersistentArrayMap.prototype.equiv = function(other) {
  var self__ = this;
  var this$ = this;
  return this$.cljs$core$IEquiv$_equiv$arity$2(null, other);
};
cljs.core.PersistentArrayMap.prototype.keys = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.keys(coll));
};
cljs.core.PersistentArrayMap.prototype.entries = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
};
cljs.core.PersistentArrayMap.prototype.values = function() {
  var self__ = this;
  var coll = this;
  return cljs.core.es6_iterator(cljs.core.vals(coll));
};
cljs.core.PersistentArrayMap.prototype.has = function(k) {
  var self__ = this;
  var coll = this;
  return cljs.core.contains_QMARK_(coll, k);
};
cljs.core.PersistentArrayMap.prototype.get = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentArrayMap.prototype.forEach = function(f) {
  var self__ = this;
  var coll = this;
  var seq__6071 = cljs.core.seq(coll);
  var chunk__6072 = null;
  var count__6073 = 0;
  var i__6074 = 0;
  while (true) {
    if (i__6074 < count__6073) {
      var vec__6075 = chunk__6072.cljs$core$IIndexed$_nth$arity$2(null, i__6074);
      var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6075, 0, null);
      var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6075, 1, null);
      f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v, k) : f.call(null, v, k);
      var G__6087 = seq__6071;
      var G__6088 = chunk__6072;
      var G__6089 = count__6073;
      var G__6090 = i__6074 + 1;
      seq__6071 = G__6087;
      chunk__6072 = G__6088;
      count__6073 = G__6089;
      i__6074 = G__6090;
      continue;
    } else {
      var temp__5457__auto__ = cljs.core.seq(seq__6071);
      if (temp__5457__auto__) {
        var seq__6071__$1 = temp__5457__auto__;
        if (cljs.core.chunked_seq_QMARK_(seq__6071__$1)) {
          var c__4319__auto__ = cljs.core.chunk_first(seq__6071__$1);
          var G__6091 = cljs.core.chunk_rest(seq__6071__$1);
          var G__6092 = c__4319__auto__;
          var G__6093 = cljs.core.count(c__4319__auto__);
          var G__6094 = 0;
          seq__6071 = G__6091;
          chunk__6072 = G__6092;
          count__6073 = G__6093;
          i__6074 = G__6094;
          continue;
        } else {
          var vec__6078 = cljs.core.first(seq__6071__$1);
          var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6078, 0, null);
          var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6078, 1, null);
          f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v, k) : f.call(null, v, k);
          var G__6095 = cljs.core.next(seq__6071__$1);
          var G__6096 = null;
          var G__6097 = 0;
          var G__6098 = 0;
          seq__6071 = G__6095;
          chunk__6072 = G__6096;
          count__6073 = G__6097;
          i__6074 = G__6098;
          continue;
        }
      } else {
        return null;
      }
    }
    break;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return coll__$1.cljs$core$ILookup$_lookup$arity$3(null, k, null);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx === -1) {
    return not_found;
  } else {
    return self__.arr[idx + 1];
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var self__ = this;
  var coll__$1 = this;
  var len = self__.arr.length;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < len) {
      var init__$2 = function() {
        var G__6081 = init__$1;
        var G__6082 = self__.arr[i];
        var G__6083 = self__.arr[i + 1];
        return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__6081, G__6082, G__6083) : f.call(null, G__6081, G__6082, G__6083);
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return cljs.core.deref(init__$2);
      } else {
        var G__6099 = i + 2;
        var G__6100 = init__$2;
        i = G__6099;
        init__$1 = G__6100;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = function(this$) {
  var self__ = this;
  var this$__$1 = this;
  return new cljs.core.PersistentArrayMapIterator(self__.arr, 0, self__.cnt * 2);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.meta;
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = function(_) {
  var self__ = this;
  var ___$1 = this;
  return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt, self__.arr, self__.__hash);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return self__.cnt;
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  var h__4030__auto__ = self__.__hash;
  if (!(h__4030__auto__ == null)) {
    return h__4030__auto__;
  } else {
    var h__4030__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
    self__.__hash = h__4030__auto____$1;
    return h__4030__auto____$1;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.map_QMARK_(other) && !cljs.core.record_QMARK_(other)) {
    var alen = self__.arr.length;
    var other__$1 = other;
    if (self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null)) {
      var i = 0;
      while (true) {
        if (i < alen) {
          var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null, self__.arr[i], cljs.core.lookup_sentinel);
          if (!(v === cljs.core.lookup_sentinel)) {
            if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(self__.arr[i + 1], v)) {
              var G__6101 = i + 2;
              i = G__6101;
              continue;
            } else {
              return false;
            }
          } else {
            return false;
          }
        } else {
          return true;
        }
        break;
      }
    } else {
      return false;
    }
  } else {
    return false;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.TransientArrayMap({}, self__.arr.length, cljs.core.aclone(self__.arr));
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY, self__.meta);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1, f);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1, f, start);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx >= 0) {
    var len = self__.arr.length;
    var new_len = len - 2;
    if (new_len === 0) {
      return coll__$1.cljs$core$IEmptyableCollection$_empty$arity$1(null);
    } else {
      var new_arr = new Array(new_len);
      var s = 0;
      var d = 0;
      while (true) {
        if (s >= len) {
          return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt - 1, new_arr, null);
        } else {
          if (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k, self__.arr[s])) {
            var G__6102 = s + 2;
            var G__6103 = d;
            s = G__6102;
            d = G__6103;
            continue;
          } else {
            new_arr[d] = self__.arr[s];
            new_arr[d + 1] = self__.arr[s + 1];
            var G__6104 = s + 2;
            var G__6105 = d + 2;
            s = G__6104;
            d = G__6105;
            continue;
          }
        }
        break;
      }
    }
  } else {
    return coll__$1;
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var self__ = this;
  var coll__$1 = this;
  var idx = cljs.core.array_map_index_of(coll__$1, k);
  if (idx === -1) {
    if (self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
      var arr__$1 = cljs.core.array_map_extend_kv(coll__$1, k, v);
      return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt + 1, arr__$1, null);
    } else {
      return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY, coll__$1), k, v), self__.meta);
    }
  } else {
    if (v === self__.arr[idx + 1]) {
      return coll__$1;
    } else {
      var arr__$1 = function() {
        var G__6086 = cljs.core.aclone(self__.arr);
        G__6086[idx + 1] = v;
        return G__6086;
      }();
      return new cljs.core.PersistentArrayMap(self__.meta, self__.cnt, arr__$1, null);
    }
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var self__ = this;
  var coll__$1 = this;
  return !(cljs.core.array_map_index_of(coll__$1, k) === -1);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var self__ = this;
  var coll__$1 = this;
  return cljs.core.persistent_array_map_seq(self__.arr, 0, null);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta__$1) {
  var self__ = this;
  var coll__$1 = this;
  return new cljs.core.PersistentArrayMap(meta__$1, self__.cnt, self__.arr, self__.__hash);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var self__ = this;
  var coll__$1 = this;
  if (cljs.core.vector_QMARK_(entry)) {
    return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry, 1));
  } else {
    var ret = coll__$1;
    var es = cljs.core.seq(entry);
    while (true) {
      if (es == null) {
        return ret;
      } else {
        var e = cljs.core.first(es);
        if (cljs.core.vector_QMARK_(e)) {
          var G__6106 = ret.cljs$core$IAssociative$_assoc$arity$3(null, cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 0), cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e, 1));
          var G__6107 = cljs.core.next(es);
          ret = G__6106;
          es = G__6107;
          continue;
        } else {
          throw new Error("conj on a map takes map entries or seqables of map entries");
        }
      }
      break;
    }
  }
};
cljs.core.PersistentArrayMap.prototype.call = function() {
  var G__6108 = null;
  var G__6108__2 = function(self__, k) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
  };
  var G__6108__3 = function(self__, k, not_found) {
    var self__ = this;
    var self____$1 = this;
    var coll = self____$1;
    return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
  };
  G__6108 = function(self__, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6108__2.call(this, self__, k);
      case 3:
        return G__6108__3.call(this, self__, k, not_found);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__6108.cljs$core$IFn$_invoke$arity$2 = G__6108__2;
  G__6108.cljs$core$IFn$_invoke$arity$3 = G__6108__3;
  return G__6108;
}();
cljs.core.PersistentArrayMap.prototype.apply = function(self__, args6070) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args6070)));
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(k) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$2(null, k);
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(k, not_found) {
  var self__ = this;
  var coll = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(null, k, not_found);
};
cljs.core.PersistentArrayMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "meta", "meta", -1154898805, null), new cljs.core.Symbol(null, "cnt", "cnt", 1924510325, null), new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "__hash", "__hash", -1328796629, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.PersistentArrayMap.cljs$lang$type = true;
cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap";
cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/PersistentArrayMap");
};
cljs.core.__GT_PersistentArrayMap = function cljs$core$__GT_PersistentArrayMap(meta, cnt, arr, __hash) {
  return new cljs.core.PersistentArrayMap(meta, cnt, arr, __hash);
};
cljs.core.PersistentArrayMap.EMPTY = new cljs.core.PersistentArrayMap(null, 0, [], cljs.core.empty_unordered_hash);
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = 8;
cljs.core.PersistentArrayMap.fromArray = function(arr, no_clone, no_check) {
  var arr__$1 = no_clone ? arr : cljs.core.aclone(arr);
  var arr__$2 = no_check ? arr__$1 : function() {
    var ret = [];
    var i_6109 = 0;
    while (true) {
      if (i_6109 < arr__$1.length) {
        var k_6110 = arr__$1[i_6109];
        var v_6111 = arr__$1[i_6109 + 1];
        var idx_6112 = cljs.core.array_index_of(ret, k_6110);
        if (idx_6112 === -1) {
          ret.push(k_6110);
          ret.push(v_6111);
        } else {
        }
        var G__6113 = i_6109 + 2;
        i_6109 = G__6113;
        continue;
      } else {
      }
      break;
    }
    return ret;
  }();
  var cnt = arr__$2.length / 2;
  return new cljs.core.PersistentArrayMap(null, cnt, arr__$2, null);
};
cljs.core.PersistentArrayMap.createWithCheck = function(arr) {
  var ret = [];
  var i_6115 = 0;
  while (true) {
    if (i_6115 < arr.length) {
      var k_6116 = arr[i_6115];
      var v_6117 = arr[i_6115 + 1];
      var idx_6118 = cljs.core.array_index_of(ret, k_6116);
      if (idx_6118 === -1) {
        var G__6114_6119 = ret;
        G__6114_6119.push(k_6116);
        G__6114_6119.push(v_6117);
      } else {
        throw new Error(["Duplicate key: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(k_6116)].join(""));
      }
      var G__6120 = i_6115 + 2;
      i_6115 = G__6120;
      continue;
    } else {
    }
    break;
  }
  var cnt = arr.length / 2;
  return new cljs.core.PersistentArrayMap(null, cnt, arr, null);
};
cljs.core.PersistentArrayMap.createAsIfByAssoc = function(arr) {
  var ret = [];
  var i_6122 = 0;
  while (true) {
    if (i_6122 < arr.length) {
      var k_6123 = arr[i_6122];
      var v_6124 = arr[i_6122 + 1];
      var idx_6125 = cljs.core.array_index_of(ret, k_6123);
      if (idx_6125 === -1) {
        var G__6121_6126 = ret;
        G__6121_6126.push(k_6123);
        G__6121_6126.push(v_6124);
      } else {
        ret[idx_6125 + 1] = v_6124;
      }
      var G__6127 = i_6122 + 2;
      i_6122 = G__6127;
      continue;
    } else {
    }
    break;
  }
  return new cljs.core.PersistentArrayMap(null, ret.length / 2, ret, null);
};
var G__6128_6131 = cljs.core.PersistentArrayMap.prototype;
var G__6129_6132 = cljs.core.ITER_SYMBOL;
var G__6130_6133 = function(G__6128_6131, G__6129_6132) {
  return function() {
    var this__4438__auto__ = this;
    return cljs.core.es6_iterator(this__4438__auto__);
  };
}(G__6128_6131, G__6129_6132);
goog.object.set(G__6128_6131, G__6129_6132, G__6130_6133);
cljs.core.TransientArrayMap = function(editable_QMARK_, len, arr) {
  this.editable_QMARK_ = editable_QMARK_;
  this.len = len;
  this.arr = arr;
  this.cljs$lang$protocol_mask$partition0$ = 259;
  this.cljs$lang$protocol_mask$partition1$ = 56;
};
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    return cljs.core.quot(self__.len, 2);
  } else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var self__ = this;
  var tcoll__$1 = this;
  return tcoll__$1.cljs$core$ILookup$_lookup$arity$3(null, k, null);
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, k);
    if (idx === -1) {
      return not_found;
    } else {
      return self__.arr[idx + 1];
    }
  } else {
    throw new Error("lookup after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    if (cljs.core.map_entry_QMARK_(o)) {
      return tcoll__$1.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null, cljs.core.key(o), cljs.core.val(o));
    } else {
      if (cljs.core.vector_QMARK_(o)) {
        return tcoll__$1.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null, o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1(0) : o.call(null, 0), o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1(1) : o.call(null, 1));
      } else {
        var es = cljs.core.seq(o);
        var tcoll__$2 = tcoll__$1;
        while (true) {
          var temp__5455__auto__ = cljs.core.first(es);
          if (cljs.core.truth_(temp__5455__auto__)) {
            var e = temp__5455__auto__;
            var G__6136 = cljs.core.next(es);
            var G__6137 = tcoll__$2.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null, cljs.core.key(e), cljs.core.val(e));
            es = G__6136;
            tcoll__$2 = G__6137;
            continue;
          } else {
            return tcoll__$2;
          }
          break;
        }
      }
    }
  } else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    self__.editable_QMARK_ = false;
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot(self__.len, 2), self__.arr, null);
  } else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, key);
    if (idx === -1) {
      if (self__.len + 2 <= 2 * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
        self__.len = self__.len + 2;
        self__.arr.push(key);
        self__.arr.push(val);
        return tcoll__$1;
      } else {
        return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.array__GT_transient_hash_map(self__.len, self__.arr), key, val);
      }
    } else {
      if (val === self__.arr[idx + 1]) {
        return tcoll__$1;
      } else {
        self__.arr[idx + 1] = val;
        return tcoll__$1;
      }
    }
  } else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var self__ = this;
  var tcoll__$1 = this;
  if (cljs.core.truth_(self__.editable_QMARK_)) {
    var idx = cljs.core.array_map_index_of(tcoll__$1, key);
    if (idx >= 0) {
      self__.arr[idx] = self__.arr[self__.len - 2];
      self__.arr[idx + 1] = self__.arr[self__.len - 1];
      var G__6135_6138 = self__.arr;
      G__6135_6138.pop();
      G__6135_6138.pop();
      self__.len = self__.len - 2;
    } else {
    }
    return tcoll__$1;
  } else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.call = function() {
  var G__6139 = null;
  var G__6139__2 = function(self__, key) {
    var self__ = this;
    var self____$1 = this;
    var tcoll = self____$1;
    return tcoll.cljs$core$ILookup$_lookup$arity$3(null, key, null);
  };
  var G__6139__3 = function(self__, key, not_found) {
    var self__ = this;
    var self____$1 = this;
    var tcoll = self____$1;
    return tcoll.cljs$core$ILookup$_lookup$arity$3(null, key, not_found);
  };
  G__6139 = function(self__, key, not_found) {
    switch(arguments.length) {
      case 2:
        return G__6139__2.call(this, self__, key);
      case 3:
        return G__6139__3.call(this, self__, key, not_found);
    }
    throw new Error("Invalid arity: " + (arguments.length - 1));
  };
  G__6139.cljs$core$IFn$_invoke$arity$2 = G__6139__2;
  G__6139.cljs$core$IFn$_invoke$arity$3 = G__6139__3;
  return G__6139;
}();
cljs.core.TransientArrayMap.prototype.apply = function(self__, args6134) {
  var self__ = this;
  var self____$1 = this;
  return self____$1.call.apply(self____$1, [self____$1].concat(cljs.core.aclone(args6134)));
};
cljs.core.TransientArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = function(key) {
  var self__ = this;
  var tcoll = this;
  return tcoll.cljs$core$ILookup$_lookup$arity$3(null, key, null);
};
cljs.core.TransientArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = function(key, not_found) {
  var self__ = this;
  var tcoll = this;
  return tcoll.cljs$core$ILookup$_lookup$arity$3(null, key, not_found);
};
cljs.core.TransientArrayMap.getBasis = function() {
  return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "editable?", "editable?", -164945806, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "len", "len", -1230778691, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), 
  new cljs.core.Symbol(null, "arr", "arr", 2115492975, null)], null);
};
cljs.core.TransientArrayMap.cljs$lang$type = true;
cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap";
cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/TransientArrayMap");
};
cljs.core.__GT_TransientArrayMap = function cljs$core$__GT_TransientArrayMap(editable_QMARK_, len, arr) {
  return new cljs.core.TransientArrayMap(editable_QMARK_, len, arr);
};
cljs.core.array__GT_transient_hash_map = function cljs$core$array__GT_transient_hash_map(len, arr) {
  var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
  var i = 0;
  while (true) {
    if (i < len) {
      var G__6140 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out, arr[i], arr[i + 1]);
      var G__6141 = i + 2;
      out = G__6140;
      i = G__6141;
      continue;
    } else {
      return out;
    }
    break;
  }
};
cljs.core.Box = function(val) {
  this.val = val;
};
cljs.core.Box.getBasis = function() {
  return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null, "val", "val", 1769233139, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.Box.cljs$lang$type = true;
cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box";
cljs.core.Box.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/Box");
};
cljs.core.__GT_Box = function cljs$core$__GT_Box(val) {
  return new cljs.core.Box(val);
};
cljs.core.key_test = function cljs$core$key_test(key, other) {
  if (key === other) {
    return true;
  } else {
    if (cljs.core.keyword_identical_QMARK_(key, other)) {
      return true;
    } else {
      return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key, other);
    }
  }
};
cljs.core.mask = function cljs$core$mask(hash, shift) {
  return hash >>> shift & 31;
};
cljs.core.clone_and_set = function cljs$core$clone_and_set(var_args) {
  var G__6143 = arguments.length;
  switch(G__6143) {
    case 3:
      return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(arguments[0], arguments[1], arguments[2]);
      break;
    case 5:
      return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = function(arr, i, a) {
  var G__6144 = cljs.core.aclone(arr);
  G__6144[i] = a;
  return G__6144;
};
cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = function(arr, i, a, j, b) {
  var G__6145 = cljs.core.aclone(arr);
  G__6145[i] = a;
  G__6145[j] = b;
  return G__6145;
};
cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5;
cljs.core.remove_pair = function cljs$core$remove_pair(arr, i) {
  var new_arr = new Array(arr.length - 2);
  cljs.core.array_copy(arr, 0, new_arr, 0, 2 * i);
  cljs.core.array_copy(arr, 2 * (i + 1), new_arr, 2 * i, new_arr.length - 2 * i);
  return new_arr;
};
cljs.core.bitmap_indexed_node_index = function cljs$core$bitmap_indexed_node_index(bitmap, bit) {
  return cljs.core.bit_count(bitmap & bit - 1);
};
cljs.core.bitpos = function cljs$core$bitpos(hash, shift) {
  return 1 << (hash >>> shift & 31);
};
cljs.core.edit_and_set = function cljs$core$edit_and_set(var_args) {
  var G__6148 = arguments.length;
  switch(G__6148) {
    case 4:
      return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(arguments[0], arguments[1], arguments[2], arguments[3]);
      break;
    case 6:
      return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
      break;
    default:
      throw new Error(["Invalid arity: ", cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join(""));
  }
};
cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = function(inode, edit, i, a) {
  var editable = inode.ensure_editable(edit);
  editable.arr[i] = a;
  return editable;
};
cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = function(inode, edit, i, a, j, b) {
  var editable = inode.ensure_editable(edit);
  editable.arr[i] = a;
  editable.arr[j] = b;
  return editable;
};
cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6;
cljs.core.inode_kv_reduce = function cljs$core$inode_kv_reduce(arr, f, init) {
  var len = arr.length;
  var i = 0;
  var init__$1 = init;
  while (true) {
    if (i < len) {
      var init__$2 = function() {
        var k = arr[i];
        if (!(k == null)) {
          var G__6150 = init__$1;
          var G__6151 = k;
          var G__6152 = arr[i + 1];
          return f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__6150, G__6151, G__6152) : f.call(null, G__6150, G__6151, G__6152);
        } else {
          var node = arr[i + 1];
          if (!(node == null)) {
            return node.kv_reduce(f, init__$1);
          } else {
            return init__$1;
          }
        }
      }();
      if (cljs.core.reduced_QMARK_(init__$2)) {
        return init__$2;
      } else {
        var G__6153 = i + 2;
        var G__6154 = init__$2;
        i = G__6153;
        init__$1 = G__6154;
        continue;
      }
    } else {
      return init__$1;
    }
    break;
  }
};
cljs.core.NodeIterator = function(arr, i, next_entry, next_iter) {
  this.arr = arr;
  this.i = i;
  this.next_entry = next_entry;
  this.next_iter = next_iter;
};
cljs.core.NodeIterator.prototype.advance = function() {
  var self__ = this;
  var this$ = this;
  var len = self__.arr.length;
  while (true) {
    if (self__.i < len) {
      var key = self__.arr[self__.i];
      var node_or_val = self__.arr[self__.i + 1];
      var found = !(key == null) ? self__.next_entry = new cljs.core.MapEntry(key, node_or_val, null) : !(node_or_val == null) ? function() {
        var new_iter = cljs.core._iterator(node_or_val);
        if (new_iter.hasNext()) {
          return self__.next_iter = new_iter;
        } else {
          return false;
        }
      }() : false;
      self__.i = self__.i + 2;
      if (found) {
        return true;
      } else {
        continue;
      }
    } else {
      return false;
    }
    break;
  }
};
cljs.core.NodeIterator.prototype.hasNext = function() {
  var self__ = this;
  var this$ = this;
  var or__3922__auto__ = !(self__.next_entry == null);
  if (or__3922__auto__) {
    return or__3922__auto__;
  } else {
    var or__3922__auto____$1 = !(self__.next_iter == null);
    if (or__3922__auto____$1) {
      return or__3922__auto____$1;
    } else {
      return this$.advance();
    }
  }
};
cljs.core.NodeIterator.prototype.next = function() {
  var self__ = this;
  var this$ = this;
  if (!(self__.next_entry == null)) {
    var ret = self__.next_entry;
    self__.next_entry = null;
    return ret;
  } else {
    if (!(self__.next_iter == null)) {
      var ret = self__.next_iter.next();
      if (self__.next_iter.hasNext()) {
      } else {
        self__.next_iter = null;
      }
      return ret;
    } else {
      if (this$.advance()) {
        return this$.next();
      } else {
        throw new Error("No such element");
      }
    }
  }
};
cljs.core.NodeIterator.prototype.remove = function() {
  var self__ = this;
  var _ = this;
  return new Error("Unsupported operation");
};
cljs.core.NodeIterator.getBasis = function() {
  return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null, "arr", "arr", 2115492975, null), cljs.core.with_meta(new cljs.core.Symbol(null, "i", "i", 253690212, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "next-entry", "next-entry", 1091342476, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, 
  "mutable", "mutable", 875778266), true], null)), cljs.core.with_meta(new cljs.core.Symbol(null, "next-iter", "next-iter", 1526626239, null), new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null, "mutable", "mutable", 875778266), true], null))], null);
};
cljs.core.NodeIterator.cljs$lang$type = true;
cljs.core.NodeIterator.cljs$lang$ctorStr = "cljs.core/NodeIterator";
cljs.core.NodeIterator.cljs$lang$ctorPrWriter = function(this__4161__auto__, writer__4162__auto__, opt__4163__auto__) {
  return cljs.core._write(writer__4162__auto__, "cljs.core/NodeIterator");
};
cljs.core.__GT_NodeIterator = function cljs$core$__GT_NodeIterator(arr, i, next_entry, next_iter) {
  return new cljs.core.NodeIterator(arr, i, next_entry, next_iter);
};
cljs.core.BitmapIndexedNode = function(edit, bitmap, arr) {
  this.edit = edit;
  this.bitmap = bitmap;
  this.arr = arr;
  this.cljs$lang$protocol_mask$partition1$ = 131072;
  this.cljs$lang$protocol_mask$partition0$ = 0;
};
cljs.core.BitmapIndexedNode.prototype.ensure_editable = function(e) {
  var self__ = this;
  var inode = this;
  if (e === self__.edit) {
    return inode;
  } else {
    var n = cljs.core.bit_count(self__.bitmap);
    var new_arr = new Array(n < 0 ? 4 : 2 * (n + 1));
    cljs.core.array_copy(self__.arr, 0, new_arr, 0, 2 * n);
    return new cljs.core.BitmapIndexedNode(e, self__.bitmap, new_arr);
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = function(edit__$1, shift, hash, key, removed_leaf_QMARK_) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitmap & bit) === 0) {
    return inode;
  } else {
    var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap, bit);
    var key_or_nil = self__.arr[2 * idx];
    var val_or_node = self__.arr[2 * idx + 1];
    if (key_or_nil == null) {
      var n = val_or_node.inode_without_BANG_(edit__$1, shift + 5, hash, key, removed_leaf_QMARK_);
      if (n === val_or_node) {
        return inode;
      } else {
        if (!(n == null)) {
          return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode, edit__$1, 2 * idx + 1, n);
        } else {
          if (self__.bitmap === bit) {
            return null;
          } else {
            return inode.edit_and_remove_pair(edit__$1, bit, idx);
          }
        }
      }
    } else {
      if (cljs.core.key_test(key, key_or_nil)) {
        removed_leaf_QMARK_.val = true;
        return inode.edit_and_remove_pair(edit__$1, bit, idx);
      } else {
        return inode;
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = function(e, bit, i) {
  var self__ = this;
  var inode = this;
  if (self__.bitmap === bit) {
    return null;
  } else {
    var editable = inode.ensure_editable(e);
    var earr = editable.arr;
    var len = earr.length;
    editable.bitmap = bit ^ editable.bitmap;
    cljs.core.array_copy(earr, 2 * (i + 1), earr, 2 * i, len - 2 * (i + 1));
    earr[len - 2] = null;
    earr[len - 1] = null;
    return editable;
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_seq = function() {
  var self__ = this;
  var inode = this;
  return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr);
};
cljs.core.BitmapIndexedNode.prototype.kv_reduce = function(f, init) {
  var self__ = this;
  var inode = this;
  return cljs.core.inode_kv_reduce(self__.arr, f, init);
};
cljs.core.BitmapIndexedNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var self__ = this;
  var inode = this;
  var bit = 1 << (hash >>> shift & 31);
  if ((self__.bitma