// Compiled by ClojureScript 1.10.238 {}
goog.provide('ensorcel.conjure');
goog.require('cljs.core');
goog.require('cljs_http.client');
goog.require('cljs.core.async');
goog.require('cljs.spec.alpha');
goog.require('spec_tools.core');
goog.require('clojure.string');
goog.require('ensorcel.spellbook');
ensorcel.conjure.assemble_call = (function ensorcel$conjure$assemble_call(path_fn,body_fn,method){
return (function() { 
var G__11947__delegate = function (params){
var params__$1 = ((cljs.core.seq.call(null,params))?cljs.core.first.call(null,params):cljs.core.PersistentArrayMap.EMPTY);
var body = body_fn.call(null,params__$1);
var opts = (function (){var G__11945 = cljs.core.PersistentArrayMap.EMPTY;
if(cljs.core.map_QMARK_.call(null,body)){
return cljs.core.assoc.call(null,G__11945,new cljs.core.Keyword(null,"json-params","json-params",-1112693596),body);
} else {
return G__11945;
}
})();
return (function (){var G__11946 = method;
var G__11946__$1 = (((G__11946 instanceof cljs.core.Keyword))?G__11946.fqn:null);
switch (G__11946__$1) {
case "GET":
return cljs_http.client.get;

break;
case "POST":
return cljs_http.client.post;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__11946__$1)].join('')));

}
})().call(null,path_fn.call(null,params__$1),opts);
};
var G__11947 = function (var_args){
var params = null;
if (arguments.length > 0) {
var G__11949__i = 0, G__11949__a = new Array(arguments.length -  0);
while (G__11949__i < G__11949__a.length) {G__11949__a[G__11949__i] = arguments[G__11949__i + 0]; ++G__11949__i;}
  params = new cljs.core.IndexedSeq(G__11949__a,0,null);
} 
return G__11947__delegate.call(this,params);};
G__11947.cljs$lang$maxFixedArity = 0;
G__11947.cljs$lang$applyTo = (function (arglist__11950){
var params = cljs.core.seq(arglist__11950);
return G__11947__delegate(params);
});
G__11947.cljs$core$IFn$_invoke$arity$variadic = G__11947__delegate;
return G__11947;
})()
;
});
ensorcel.conjure.format_path = (function ensorcel$conjure$format_path(values,p__11951){
var vec__11952 = p__11951;
var seq__11953 = cljs.core.seq.call(null,vec__11952);
var first__11954 = cljs.core.first.call(null,seq__11953);
var seq__11953__$1 = cljs.core.next.call(null,seq__11953);
var f = first__11954;
var fragments = seq__11953__$1;
if((f == null)){
return cljs.core.PersistentVector.EMPTY;
} else {
return cljs.core.cons.call(null,((typeof f === 'string')?f:(function (){var temp__5455__auto__ = values.call(null,f);
if(cljs.core.truth_(temp__5455__auto__)){
var sub = temp__5455__auto__;
return sub;
} else {
throw cljs.core.ex_info.call(null,"Params do not conform to spec",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"params","params",710516235),values,new cljs.core.Keyword(null,"missing","missing",362507769),f], null));
}
})()),ensorcel.conjure.format_path.call(null,values,fragments));
}
});
ensorcel.conjure.path_fn = (function ensorcel$conjure$path_fn(base_path,path){
if(cljs.core.vector_QMARK_.call(null,path)){
return (function (p1__11955_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_path),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.apply.call(null,cljs.core.str,ensorcel.conjure.format_path.call(null,p1__11955_SHARP_,path)))].join('');
});
} else {
return cljs.core.constantly.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_path),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
}
});
ensorcel.conjure.body_fn = (function ensorcel$conjure$body_fn(params){
if(cljs.core.not.call(null,params)){
return cljs.core.constantly.call(null,null);
} else {
return (function (body){
var conform = spec_tools.core.conform.call(null,params,body,spec_tools.core.strip_extra_keys_transformer);
if(cljs.core.truth_(cljs.spec.alpha.invalid_QMARK_.call(null,conform))){
throw cljs.core.ex_info.call(null,"Params do not conform to spec",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"spec","spec",347520401),params,new cljs.core.Keyword(null,"params","params",710516235),body], null));
} else {
return conform;
}
});
}
});
ensorcel.conjure.endpoint = (function ensorcel$conjure$endpoint(base_url,p__11956){
var map__11957 = p__11956;
var map__11957__$1 = ((((!((map__11957 == null)))?(((((map__11957.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11957.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11957):map__11957);
var spec = map__11957__$1;
var path = cljs.core.get.call(null,map__11957__$1,new cljs.core.Keyword(null,"path","path",-188191168));
var method = cljs.core.get.call(null,map__11957__$1,new cljs.core.Keyword(null,"method","method",55703592));
var params = cljs.core.get.call(null,map__11957__$1,new cljs.core.Keyword(null,"params","params",710516235));
return ensorcel.conjure.assemble_call.call(null,ensorcel.conjure.path_fn.call(null,base_url,path),ensorcel.conjure.body_fn.call(null,params),method);
});
ensorcel.conjure.wrap = (function ensorcel$conjure$wrap(endpoints){
return (function() { 
var G__11959__delegate = function (endpoint,args){
if(cljs.core.seq.call(null,args)){
return (function (){
return endpoints.call(null,endpoint).call(null,cljs.core.first.call(null,args));
});
} else {
return endpoints.call(null,endpoint);
}
};
var G__11959 = function (endpoint,var_args){
var args = null;
if (arguments.length > 1) {
var G__11960__i = 0, G__11960__a = new Array(arguments.length -  1);
while (G__11960__i < G__11960__a.length) {G__11960__a[G__11960__i] = arguments[G__11960__i + 1]; ++G__11960__i;}
  args = new cljs.core.IndexedSeq(G__11960__a,0,null);
} 
return G__11959__delegate.call(this,endpoint,args);};
G__11959.cljs$lang$maxFixedArity = 1;
G__11959.cljs$lang$applyTo = (function (arglist__11961){
var endpoint = cljs.core.first(arglist__11961);
var args = cljs.core.rest(arglist__11961);
return G__11959__delegate(endpoint,args);
});
G__11959.cljs$core$IFn$_invoke$arity$variadic = G__11959__delegate;
return G__11959;
})()
;
});
ensorcel.conjure.client = (function ensorcel$conjure$client(spellbook,service_name){
if(cljs.core.truth_(ensorcel.spellbook.validate.call(null,spellbook))){
} else {
throw cljs.core.ex_info.call(null,"Provided spellbook is invalid",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"provided","provided",-1493091365),spellbook], null));
}

var map__11962 = spellbook.call(null,service_name);
var map__11962__$1 = ((((!((map__11962 == null)))?(((((map__11962.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11962.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11962):map__11962);
var service = map__11962__$1;
var path = cljs.core.get.call(null,map__11962__$1,new cljs.core.Keyword(null,"path","path",-188191168));
var endpoints = cljs.core.get.call(null,map__11962__$1,new cljs.core.Keyword(null,"endpoints","endpoints",274088209));
var base_url = ["http://localhost:3000/api/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join('');
return ensorcel.conjure.wrap.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,((function (map__11962,map__11962__$1,service,path,endpoints,base_url){
return (function (p__11964){
var vec__11965 = p__11964;
var k = cljs.core.nth.call(null,vec__11965,(0),null);
var v = cljs.core.nth.call(null,vec__11965,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,ensorcel.conjure.endpoint.call(null,base_url,v)], null);
});})(map__11962,map__11962__$1,service,path,endpoints,base_url))
,endpoints)));
});
ensorcel.conjure.call__GT_ = (function ensorcel$conjure$call__GT_(var_args){
var args__4502__auto__ = [];
var len__4499__auto___11983 = arguments.length;
var i__4500__auto___11984 = (0);
while(true){
if((i__4500__auto___11984 < len__4499__auto___11983)){
args__4502__auto__.push((arguments[i__4500__auto___11984]));

var G__11985 = (i__4500__auto___11984 + (1));
i__4500__auto___11984 = G__11985;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((1) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((1)),(0),null)):null);
return ensorcel.conjure.call__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4503__auto__);
});

ensorcel.conjure.call__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (call,thens){
var c__8564__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8564__auto__){
return (function (){
var f__8565__auto__ = (function (){var switch__8474__auto__ = ((function (c__8564__auto__){
return (function (state_11977){
var state_val_11978 = (state_11977[(1)]);
if((state_val_11978 === (1))){
var inst_11970 = call.call(null);
var state_11977__$1 = state_11977;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11977__$1,(2),inst_11970);
} else {
if((state_val_11978 === (2))){
var inst_11972 = (state_11977[(2)]);
var inst_11973 = new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(inst_11972);
var inst_11974 = (function (){var response = inst_11973;
return ((function (response,inst_11972,inst_11973,state_val_11978,c__8564__auto__){
return (function (acc,f){
return f.call(null,acc);
});
;})(response,inst_11972,inst_11973,state_val_11978,c__8564__auto__))
})();
var inst_11975 = cljs.core.reduce.call(null,inst_11974,inst_11973,thens);
var state_11977__$1 = state_11977;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11977__$1,inst_11975);
} else {
return null;
}
}
});})(c__8564__auto__))
;
return ((function (switch__8474__auto__,c__8564__auto__){
return (function() {
var ensorcel$conjure$state_machine__8475__auto__ = null;
var ensorcel$conjure$state_machine__8475__auto____0 = (function (){
var statearr_11979 = [null,null,null,null,null,null,null];
(statearr_11979[(0)] = ensorcel$conjure$state_machine__8475__auto__);

(statearr_11979[(1)] = (1));

return statearr_11979;
});
var ensorcel$conjure$state_machine__8475__auto____1 = (function (state_11977){
while(true){
var ret_value__8476__auto__ = (function (){try{while(true){
var result__8477__auto__ = switch__8474__auto__.call(null,state_11977);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8477__auto__;
}
break;
}
}catch (e11980){if((e11980 instanceof Object)){
var ex__8478__auto__ = e11980;
var statearr_11981_11986 = state_11977;
(statearr_11981_11986[(5)] = ex__8478__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11977);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11980;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8476__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11987 = state_11977;
state_11977 = G__11987;
continue;
} else {
return ret_value__8476__auto__;
}
break;
}
});
ensorcel$conjure$state_machine__8475__auto__ = function(state_11977){
switch(arguments.length){
case 0:
return ensorcel$conjure$state_machine__8475__auto____0.call(this);
case 1:
return ensorcel$conjure$state_machine__8475__auto____1.call(this,state_11977);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
ensorcel$conjure$state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$0 = ensorcel$conjure$state_machine__8475__auto____0;
ensorcel$conjure$state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$1 = ensorcel$conjure$state_machine__8475__auto____1;
return ensorcel$conjure$state_machine__8475__auto__;
})()
;})(switch__8474__auto__,c__8564__auto__))
})();
var state__8566__auto__ = (function (){var statearr_11982 = f__8565__auto__.call(null);
(statearr_11982[(6)] = c__8564__auto__);

return statearr_11982;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8566__auto__);
});})(c__8564__auto__))
);

return c__8564__auto__;
});

ensorcel.conjure.call__GT_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
ensorcel.conjure.call__GT_.cljs$lang$applyTo = (function (seq11968){
var G__11969 = cljs.core.first.call(null,seq11968);
var seq11968__$1 = cljs.core.next.call(null,seq11968);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11969,seq11968__$1);
});


//# sourceMappingURL=conjure.js.map?rel=1530627897006
