// Compiled by ClojureScript 1.10.238 {}
goog.provide('spec_tools.core');
goog.require('cljs.core');
goog.require('spec_tools.impl');
goog.require('spec_tools.parse');
goog.require('spec_tools.form');
goog.require('clojure.set');
goog.require('spec_tools.transform');
goog.require('cljs.spec.alpha');
goog.require('goog.date.UtcDateTime');
goog.require('cljs.reader');
goog.require('clojure.test.check.generators');
goog.require('cljs.spec.gen.alpha');
spec_tools.core.registry = (function spec_tools$core$registry(var_args){
var G__11868 = arguments.length;
switch (G__11868) {
case 0:
return spec_tools.core.registry.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return spec_tools.core.registry.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

spec_tools.core.registry.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.spec.alpha.registry.call(null);
});

spec_tools.core.registry.cljs$core$IFn$_invoke$arity$1 = (function (re){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.call(null,(function (p1__11866_SHARP_){
return cljs.core.re_matches.call(null,re,cljs.core.subs.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,p1__11866_SHARP_))].join(''),(1)));
}),cljs.spec.alpha.registry.call(null)));
});

spec_tools.core.registry.cljs$lang$maxFixedArity = 1;

/**
 * Finds recursively a spec implementation from the registry
 */
spec_tools.core.get_spec = (function spec_tools$core$get_spec(name){
var temp__5455__auto__ = cljs.core.get.call(null,cljs.spec.alpha.registry.call(null),name);
if(cljs.core.truth_(temp__5455__auto__)){
var spec = temp__5455__auto__;
if((spec instanceof cljs.core.Keyword)){
return spec_tools.core.get_spec.call(null,spec);
} else {
return spec;
}
} else {
return null;
}
});
/**
 * Returns a spec from a spec name or spec. Throwns exception
 *   if no spec was found.
 */
spec_tools.core.coerce_spec = (function spec_tools$core$coerce_spec(name_or_spec){
var or__3922__auto__ = (function (){var and__3911__auto__ = spec_tools.core.spec_QMARK_.call(null,name_or_spec);
if(cljs.core.truth_(and__3911__auto__)){
return name_or_spec;
} else {
return and__3911__auto__;
}
})();
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
var or__3922__auto____$1 = spec_tools.core.get_spec.call(null,name_or_spec);
if(cljs.core.truth_(or__3922__auto____$1)){
return or__3922__auto____$1;
} else {
throw cljs.core.ex_info.call(null,["can't coerce to spec: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name_or_spec)].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name-or-spec","name-or-spec",-1287260145),name_or_spec], null));
}
}
});
/**
 * Writes specs into a string that can be read by the reader.
 *   TODO: Should optionally write the realated Registry entries.
 */
spec_tools.core.serialize = (function spec_tools$core$serialize(spec){
return cljs.core.pr_str.call(null,cljs.spec.alpha.form.call(null,spec));
});
/**
 * Reads specs from a string.
 *   TODO: Should optionally read the realated Registry entries.
 */
spec_tools.core.deserialize = (function spec_tools$core$deserialize(s){
return cljs.reader.read_string.call(null,s);
});
spec_tools.core._PLUS_invalid_PLUS_ = new cljs.core.Keyword("cljs.spec.alpha","invalid","cljs.spec.alpha/invalid",-1220295119);
spec_tools.core._PLUS_problems_PLUS_ = new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814);
spec_tools.core._STAR_transformer_STAR_ = null;
spec_tools.core._STAR_encode_QMARK__STAR_ = null;

/**
 * @interface
 */
spec_tools.core.Transformer = function(){};

spec_tools.core._name = (function spec_tools$core$_name(this$){
if(((!((this$ == null))) && (!((this$.spec_tools$core$Transformer$_name$arity$1 == null))))){
return this$.spec_tools$core$Transformer$_name$arity$1(this$);
} else {
var x__4211__auto__ = (((this$ == null))?null:this$);
var m__4212__auto__ = (spec_tools.core._name[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,this$);
} else {
var m__4212__auto____$1 = (spec_tools.core._name["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"Transformer.-name",this$);
}
}
}
});

spec_tools.core._encoder = (function spec_tools$core$_encoder(this$,spec,value){
if(((!((this$ == null))) && (!((this$.spec_tools$core$Transformer$_encoder$arity$3 == null))))){
return this$.spec_tools$core$Transformer$_encoder$arity$3(this$,spec,value);
} else {
var x__4211__auto__ = (((this$ == null))?null:this$);
var m__4212__auto__ = (spec_tools.core._encoder[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,this$,spec,value);
} else {
var m__4212__auto____$1 = (spec_tools.core._encoder["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,this$,spec,value);
} else {
throw cljs.core.missing_protocol.call(null,"Transformer.-encoder",this$);
}
}
}
});

spec_tools.core._decoder = (function spec_tools$core$_decoder(this$,spec,value){
if(((!((this$ == null))) && (!((this$.spec_tools$core$Transformer$_decoder$arity$3 == null))))){
return this$.spec_tools$core$Transformer$_decoder$arity$3(this$,spec,value);
} else {
var x__4211__auto__ = (((this$ == null))?null:this$);
var m__4212__auto__ = (spec_tools.core._decoder[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,this$,spec,value);
} else {
var m__4212__auto____$1 = (spec_tools.core._decoder["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,this$,spec,value);
} else {
throw cljs.core.missing_protocol.call(null,"Transformer.-decoder",this$);
}
}
}
});

spec_tools.core.type_transformer = (function spec_tools$core$type_transformer(p__11870){
var map__11871 = p__11870;
var map__11871__$1 = ((((!((map__11871 == null)))?(((((map__11871.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11871.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11871):map__11871);
var transformer_name = cljs.core.get.call(null,map__11871__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var encoders = cljs.core.get.call(null,map__11871__$1,new cljs.core.Keyword(null,"encoders","encoders",-111722908));
var decoders = cljs.core.get.call(null,map__11871__$1,new cljs.core.Keyword(null,"decoders","decoders",1132818244));
var default_encoder = cljs.core.get.call(null,map__11871__$1,new cljs.core.Keyword(null,"default-encoder","default-encoder",117541207));
var default_decoder = cljs.core.get.call(null,map__11871__$1,new cljs.core.Keyword(null,"default-decoder","default-decoder",808357161));
var encode_key = (function (){var G__11873 = transformer_name;
var G__11873__$1 = (((G__11873 == null))?null:cljs.core.name.call(null,G__11873));
var G__11873__$2 = (((G__11873__$1 == null))?null:["encode/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__11873__$1)].join(''));
if((G__11873__$2 == null)){
return null;
} else {
return cljs.core.keyword.call(null,G__11873__$2);
}
})();
var decode_key = (function (){var G__11874 = transformer_name;
var G__11874__$1 = (((G__11874 == null))?null:cljs.core.name.call(null,G__11874));
var G__11874__$2 = (((G__11874__$1 == null))?null:["decode/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__11874__$1)].join(''));
if((G__11874__$2 == null)){
return null;
} else {
return cljs.core.keyword.call(null,G__11874__$2);
}
})();
if(typeof spec_tools.core.t_spec_tools$core11875 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {spec_tools.core.Transformer}
 * @implements {cljs.core.IWithMeta}
*/
spec_tools.core.t_spec_tools$core11875 = (function (p__11870,map__11871,transformer_name,encoders,decoders,default_encoder,default_decoder,encode_key,decode_key,meta11876){
this.p__11870 = p__11870;
this.map__11871 = map__11871;
this.transformer_name = transformer_name;
this.encoders = encoders;
this.decoders = decoders;
this.default_encoder = default_encoder;
this.default_decoder = default_decoder;
this.encode_key = encode_key;
this.decode_key = decode_key;
this.meta11876 = meta11876;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
spec_tools.core.t_spec_tools$core11875.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (encode_key,decode_key,map__11871,map__11871__$1,transformer_name,encoders,decoders,default_encoder,default_decoder){
return (function (_11877,meta11876__$1){
var self__ = this;
var _11877__$1 = this;
return (new spec_tools.core.t_spec_tools$core11875(self__.p__11870,self__.map__11871,self__.transformer_name,self__.encoders,self__.decoders,self__.default_encoder,self__.default_decoder,self__.encode_key,self__.decode_key,meta11876__$1));
});})(encode_key,decode_key,map__11871,map__11871__$1,transformer_name,encoders,decoders,default_encoder,default_decoder))
;

spec_tools.core.t_spec_tools$core11875.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (encode_key,decode_key,map__11871,map__11871__$1,transformer_name,encoders,decoders,default_encoder,default_decoder){
return (function (_11877){
var self__ = this;
var _11877__$1 = this;
return self__.meta11876;
});})(encode_key,decode_key,map__11871,map__11871__$1,transformer_name,encoders,decoders,default_encoder,default_decoder))
;

spec_tools.core.t_spec_tools$core11875.prototype.spec_tools$core$Transformer$ = cljs.core.PROTOCOL_SENTINEL;

spec_tools.core.t_spec_tools$core11875.prototype.spec_tools$core$Transformer$_name$arity$1 = ((function (encode_key,decode_key,map__11871,map__11871__$1,transformer_name,encoders,decoders,default_encoder,default_decoder){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.transformer_name;
});})(encode_key,decode_key,map__11871,map__11871__$1,transformer_name,encoders,decoders,default_encoder,default_decoder))
;

spec_tools.core.t_spec_tools$core11875.prototype.spec_tools$core$Transformer$_encoder$arity$3 = ((function (encode_key,decode_key,map__11871,map__11871__$1,transformer_name,encoders,decoders,default_encoder,default_decoder){
return (function (_,spec,___$1){
var self__ = this;
var ___$2 = this;
var or__3922__auto__ = cljs.core.get.call(null,spec,self__.encode_key);
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
var or__3922__auto____$1 = cljs.core.get.call(null,self__.encoders,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(spec));
if(cljs.core.truth_(or__3922__auto____$1)){
return or__3922__auto____$1;
} else {
return self__.default_encoder;
}
}
});})(encode_key,decode_key,map__11871,map__11871__$1,transformer_name,encoders,decoders,default_encoder,default_decoder))
;

spec_tools.core.t_spec_tools$core11875.prototype.spec_tools$core$Transformer$_decoder$arity$3 = ((function (encode_key,decode_key,map__11871,map__11871__$1,transformer_name,encoders,decoders,default_encoder,default_decoder){
return (function (_,spec,___$1){
var self__ = this;
var ___$2 = this;
var or__3922__auto__ = cljs.core.get.call(null,spec,self__.decode_key);
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
var or__3922__auto____$1 = cljs.core.get.call(null,self__.decoders,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(spec));
if(cljs.core.truth_(or__3922__auto____$1)){
return or__3922__auto____$1;
} else {
return self__.default_decoder;
}
}
});})(encode_key,decode_key,map__11871,map__11871__$1,transformer_name,encoders,decoders,default_encoder,default_decoder))
;

spec_tools.core.t_spec_tools$core11875.getBasis = ((function (encode_key,decode_key,map__11871,map__11871__$1,transformer_name,encoders,decoders,default_encoder,default_decoder){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p__11870","p__11870",-865398836,null),new cljs.core.Symbol(null,"map__11871","map__11871",513101767,null),new cljs.core.Symbol(null,"transformer-name","transformer-name",1500736595,null),new cljs.core.Symbol(null,"encoders","encoders",1528808619,null),new cljs.core.Symbol(null,"decoders","decoders",-1521617525,null),new cljs.core.Symbol(null,"default-encoder","default-encoder",1758072734,null),new cljs.core.Symbol(null,"default-decoder","default-decoder",-1846078608,null),new cljs.core.Symbol(null,"encode-key","encode-key",61285653,null),new cljs.core.Symbol(null,"decode-key","decode-key",-1250072619,null),new cljs.core.Symbol(null,"meta11876","meta11876",999704939,null)], null);
});})(encode_key,decode_key,map__11871,map__11871__$1,transformer_name,encoders,decoders,default_encoder,default_decoder))
;

spec_tools.core.t_spec_tools$core11875.cljs$lang$type = true;

spec_tools.core.t_spec_tools$core11875.cljs$lang$ctorStr = "spec-tools.core/t_spec_tools$core11875";

spec_tools.core.t_spec_tools$core11875.cljs$lang$ctorPrWriter = ((function (encode_key,decode_key,map__11871,map__11871__$1,transformer_name,encoders,decoders,default_encoder,default_decoder){
return (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"spec-tools.core/t_spec_tools$core11875");
});})(encode_key,decode_key,map__11871,map__11871__$1,transformer_name,encoders,decoders,default_encoder,default_decoder))
;

/**
 * Positional factory function for spec-tools.core/t_spec_tools$core11875.
 */
spec_tools.core.__GT_t_spec_tools$core11875 = ((function (encode_key,decode_key,map__11871,map__11871__$1,transformer_name,encoders,decoders,default_encoder,default_decoder){
return (function spec_tools$core$type_transformer_$___GT_t_spec_tools$core11875(p__11870__$1,map__11871__$2,transformer_name__$1,encoders__$1,decoders__$1,default_encoder__$1,default_decoder__$1,encode_key__$1,decode_key__$1,meta11876){
return (new spec_tools.core.t_spec_tools$core11875(p__11870__$1,map__11871__$2,transformer_name__$1,encoders__$1,decoders__$1,default_encoder__$1,default_decoder__$1,encode_key__$1,decode_key__$1,meta11876));
});})(encode_key,decode_key,map__11871,map__11871__$1,transformer_name,encoders,decoders,default_encoder,default_decoder))
;

}

return (new spec_tools.core.t_spec_tools$core11875(p__11870,map__11871__$1,transformer_name,encoders,decoders,default_encoder,default_decoder,encode_key,decode_key,cljs.core.PersistentArrayMap.EMPTY));
});
spec_tools.core.json_transformer = spec_tools.core.type_transformer.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"decoders","decoders",1132818244),spec_tools.transform.json_type_decoders,new cljs.core.Keyword(null,"encoders","encoders",-111722908),spec_tools.transform.json_type_encoders,new cljs.core.Keyword(null,"default-encoder","default-encoder",117541207),spec_tools.transform.any__GT_any], null));
spec_tools.core.string_transformer = spec_tools.core.type_transformer.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"decoders","decoders",1132818244),spec_tools.transform.string_type_decoders,new cljs.core.Keyword(null,"encoders","encoders",-111722908),spec_tools.transform.string_type_encoders,new cljs.core.Keyword(null,"default-encoder","default-encoder",117541207),spec_tools.transform.any__GT_any], null));
spec_tools.core.strip_extra_keys_transformer = spec_tools.core.type_transformer.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword("spec-tools.core","strip-extra-keys","spec-tools.core/strip-extra-keys",-1640458075),new cljs.core.Keyword(null,"decoders","decoders",1132818244),spec_tools.transform.strip_extra_keys_type_decoders], null));
spec_tools.core.fail_on_extra_keys_transformer = spec_tools.core.type_transformer.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword("spec-tools.core","fail-on-extra-keys","spec-tools.core/fail-on-extra-keys",-434971052),new cljs.core.Keyword(null,"decoders","decoders",1132818244),spec_tools.transform.fail_on_extra_keys_type_decoders], null));
spec_tools.core.explain = (function spec_tools$core$explain(var_args){
var G__11879 = arguments.length;
switch (G__11879) {
case 2:
return spec_tools.core.explain.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return spec_tools.core.explain.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

spec_tools.core.explain.cljs$core$IFn$_invoke$arity$2 = (function (spec,value){
return spec_tools.core.explain.call(null,spec,value,null);
});

spec_tools.core.explain.cljs$core$IFn$_invoke$arity$3 = (function (spec,value,transformer){
var _STAR_transformer_STAR_11880 = spec_tools.core._STAR_transformer_STAR_;
var _STAR_encode_QMARK__STAR_11881 = spec_tools.core._STAR_encode_QMARK__STAR_;
spec_tools.core._STAR_transformer_STAR_ = transformer;

spec_tools.core._STAR_encode_QMARK__STAR_ = false;

try{return cljs.spec.alpha.explain.call(null,spec_tools.core.into_spec.call(null,spec),value);
}finally {spec_tools.core._STAR_encode_QMARK__STAR_ = _STAR_encode_QMARK__STAR_11881;

spec_tools.core._STAR_transformer_STAR_ = _STAR_transformer_STAR_11880;
}});

spec_tools.core.explain.cljs$lang$maxFixedArity = 3;

spec_tools.core.explain_data = (function spec_tools$core$explain_data(var_args){
var G__11884 = arguments.length;
switch (G__11884) {
case 2:
return spec_tools.core.explain_data.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return spec_tools.core.explain_data.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

spec_tools.core.explain_data.cljs$core$IFn$_invoke$arity$2 = (function (spec,value){
return spec_tools.core.explain_data.call(null,spec,value,null);
});

spec_tools.core.explain_data.cljs$core$IFn$_invoke$arity$3 = (function (spec,value,transformer){
var _STAR_transformer_STAR_11885 = spec_tools.core._STAR_transformer_STAR_;
var _STAR_encode_QMARK__STAR_11886 = spec_tools.core._STAR_encode_QMARK__STAR_;
spec_tools.core._STAR_transformer_STAR_ = transformer;

spec_tools.core._STAR_encode_QMARK__STAR_ = false;

try{return cljs.spec.alpha.explain_data.call(null,spec_tools.core.into_spec.call(null,spec),value);
}finally {spec_tools.core._STAR_encode_QMARK__STAR_ = _STAR_encode_QMARK__STAR_11886;

spec_tools.core._STAR_transformer_STAR_ = _STAR_transformer_STAR_11885;
}});

spec_tools.core.explain_data.cljs$lang$maxFixedArity = 3;

/**
 * Given a spec and a value, returns the possibly destructured value
 * or ::s/invalid
 */
spec_tools.core.conform = (function spec_tools$core$conform(var_args){
var G__11889 = arguments.length;
switch (G__11889) {
case 2:
return spec_tools.core.conform.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return spec_tools.core.conform.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

spec_tools.core.conform.cljs$core$IFn$_invoke$arity$2 = (function (spec,value){
return spec_tools.core.conform.call(null,spec,value,null);
});

spec_tools.core.conform.cljs$core$IFn$_invoke$arity$3 = (function (spec,value,transformer){
var _STAR_transformer_STAR_11890 = spec_tools.core._STAR_transformer_STAR_;
var _STAR_encode_QMARK__STAR_11891 = spec_tools.core._STAR_encode_QMARK__STAR_;
spec_tools.core._STAR_transformer_STAR_ = transformer;

spec_tools.core._STAR_encode_QMARK__STAR_ = false;

try{return cljs.spec.alpha.conform.call(null,spec_tools.core.into_spec.call(null,spec),value);
}finally {spec_tools.core._STAR_encode_QMARK__STAR_ = _STAR_encode_QMARK__STAR_11891;

spec_tools.core._STAR_transformer_STAR_ = _STAR_transformer_STAR_11890;
}});

spec_tools.core.conform.cljs$lang$maxFixedArity = 3;

/**
 * Given a spec and a value, returns the possibly destructured value
 * or fails with ex-info with :type of ::conform. ex-data also contains
 * :problems, :spec and :value. call s/unform on the result to get the
 * actual conformed value.
 */
spec_tools.core.conform_BANG_ = (function spec_tools$core$conform_BANG_(var_args){
var G__11894 = arguments.length;
switch (G__11894) {
case 2:
return spec_tools.core.conform_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return spec_tools.core.conform_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

spec_tools.core.conform_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (spec,value){
return spec_tools.core.conform_BANG_.call(null,spec,value,null);
});

spec_tools.core.conform_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (spec,value,transformer){
var _STAR_transformer_STAR_11895 = spec_tools.core._STAR_transformer_STAR_;
var _STAR_encode_QMARK__STAR_11896 = spec_tools.core._STAR_encode_QMARK__STAR_;
spec_tools.core._STAR_transformer_STAR_ = transformer;

spec_tools.core._STAR_encode_QMARK__STAR_ = false;

try{var spec_SINGLEQUOTE_ = spec_tools.core.into_spec.call(null,spec);
var conformed = cljs.spec.alpha.conform.call(null,spec_SINGLEQUOTE_,value);
if(!(cljs.core._EQ_.call(null,conformed,spec_tools.core._PLUS_invalid_PLUS_))){
return conformed;
} else {
var problems = cljs.spec.alpha.explain_data.call(null,spec_SINGLEQUOTE_,value);
var data = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("spec-tools.core","conform","spec-tools.core/conform",-97557480),new cljs.core.Keyword(null,"problems","problems",2097327077),spec_tools.core._PLUS_problems_PLUS_.cljs$core$IFn$_invoke$arity$1(problems),new cljs.core.Keyword(null,"spec","spec",347520401),spec,new cljs.core.Keyword(null,"value","value",305978217),value], null);
throw cljs.core.ex_info.call(null,["Spec conform error: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(data)].join(''),data);
}
}finally {spec_tools.core._STAR_encode_QMARK__STAR_ = _STAR_encode_QMARK__STAR_11896;

spec_tools.core._STAR_transformer_STAR_ = _STAR_transformer_STAR_11895;
}});

spec_tools.core.conform_BANG_.cljs$lang$maxFixedArity = 3;

/**
 * Transforms and validates a value (using a [[Transformer]]) from external
 *   format into a value defined by the spec. On error, returns `::s/invalid`.
 */
spec_tools.core.decode = (function spec_tools$core$decode(var_args){
var G__11899 = arguments.length;
switch (G__11899) {
case 2:
return spec_tools.core.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return spec_tools.core.decode.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

spec_tools.core.decode.cljs$core$IFn$_invoke$arity$2 = (function (spec,value){
return spec_tools.core.decode.call(null,spec,value,null);
});

spec_tools.core.decode.cljs$core$IFn$_invoke$arity$3 = (function (spec,value,transformer){
var _STAR_transformer_STAR_11900 = spec_tools.core._STAR_transformer_STAR_;
var _STAR_encode_QMARK__STAR_11901 = spec_tools.core._STAR_encode_QMARK__STAR_;
spec_tools.core._STAR_transformer_STAR_ = transformer;

spec_tools.core._STAR_encode_QMARK__STAR_ = false;

try{var spec__$1 = spec_tools.core.into_spec.call(null,spec);
var conformed = cljs.spec.alpha.conform.call(null,spec__$1,value);
if(cljs.core._EQ_.call(null,conformed,spec_tools.core._PLUS_invalid_PLUS_)){
return spec_tools.core._PLUS_invalid_PLUS_;
} else {
return cljs.spec.alpha.unform.call(null,spec__$1,conformed);
}
}finally {spec_tools.core._STAR_encode_QMARK__STAR_ = _STAR_encode_QMARK__STAR_11901;

spec_tools.core._STAR_transformer_STAR_ = _STAR_transformer_STAR_11900;
}});

spec_tools.core.decode.cljs$lang$maxFixedArity = 3;

/**
 * Transforms a value (using a [[Transformer]]) from external
 *   format into a value defined by the spec. On error, returns `::s/invalid`.
 */
spec_tools.core.encode = (function spec_tools$core$encode(spec,value,transformer){
var _STAR_transformer_STAR_11903 = spec_tools.core._STAR_transformer_STAR_;
var _STAR_encode_QMARK__STAR_11904 = spec_tools.core._STAR_encode_QMARK__STAR_;
spec_tools.core._STAR_transformer_STAR_ = transformer;

spec_tools.core._STAR_encode_QMARK__STAR_ = true;

try{var spec__$1 = spec_tools.core.into_spec.call(null,spec);
var conformed = cljs.spec.alpha.conform.call(null,spec__$1,value);
if(cljs.core._EQ_.call(null,conformed,spec_tools.core._PLUS_invalid_PLUS_)){
return spec_tools.core._PLUS_invalid_PLUS_;
} else {
return cljs.spec.alpha.unform.call(null,spec__$1,conformed);
}
}finally {spec_tools.core._STAR_encode_QMARK__STAR_ = _STAR_encode_QMARK__STAR_11904;

spec_tools.core._STAR_transformer_STAR_ = _STAR_transformer_STAR_11903;
}});
/**
 * Drops all extra keys out of a Keys spec value. To use this recursively,
 *   wrap all child Keys Specs into Spec Records. See CLJ-2116 for details.
 */
spec_tools.core.select_spec = (function spec_tools$core$select_spec(spec,value){
return spec_tools.core.decode.call(null,spec,value,spec_tools.core.strip_extra_keys_transformer);
});
spec_tools.core.extra_spec_map = (function spec_tools$core$extra_spec_map(t){
return cljs.core.dissoc.call(null,t,new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.Keyword(null,"spec","spec",347520401));
});
spec_tools.core.fail_on_invoke = (function spec_tools$core$fail_on_invoke(spec){
throw cljs.core.ex_info.call(null,["Can't invoke spec with a non-function predicate: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(spec)].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"spec","spec",347520401),spec], null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.spec.alpha.Spec}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
spec_tools.core.Spec = (function (spec,form,type,__meta,__extmap,__hash){
this.spec = spec;
this.form = form;
this.type = type;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667595;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
spec_tools.core.Spec.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4172__auto__,k__4173__auto__){
var self__ = this;
var this__4172__auto____$1 = this;
return this__4172__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4173__auto__,null);
});

spec_tools.core.Spec.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4174__auto__,k11906,else__4175__auto__){
var self__ = this;
var this__4174__auto____$1 = this;
var G__11911 = k11906;
var G__11911__$1 = (((G__11911 instanceof cljs.core.Keyword))?G__11911.fqn:null);
switch (G__11911__$1) {
case "spec":
return self__.spec;

break;
case "form":
return self__.form;

break;
case "type":
return self__.type;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k11906,else__4175__auto__);

}
});

spec_tools.core.Spec.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4186__auto__,writer__4187__auto__,opts__4188__auto__){
var self__ = this;
var this__4186__auto____$1 = this;
var pr_pair__4189__auto__ = ((function (this__4186__auto____$1){
return (function (keyval__4190__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4187__auto__,cljs.core.pr_writer,""," ","",opts__4188__auto__,keyval__4190__auto__);
});})(this__4186__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__4187__auto__,pr_pair__4189__auto__,"#spec-tools.core.Spec{",", ","}",opts__4188__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spec","spec",347520401),self__.spec],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"form","form",-1624062471),self__.form],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"type","type",1174270348),self__.type],null))], null),self__.__extmap));
});

spec_tools.core.Spec.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__11905){
var self__ = this;
var G__11905__$1 = this;
return (new cljs.core.RecordIter((0),G__11905__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.Keyword(null,"type","type",1174270348)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

spec_tools.core.Spec.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4170__auto__){
var self__ = this;
var this__4170__auto____$1 = this;
return self__.__meta;
});

spec_tools.core.Spec.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4167__auto__){
var self__ = this;
var this__4167__auto____$1 = this;
return (new spec_tools.core.Spec(self__.spec,self__.form,self__.type,self__.__meta,self__.__extmap,self__.__hash));
});

spec_tools.core.Spec.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4176__auto__){
var self__ = this;
var this__4176__auto____$1 = this;
return (3 + cljs.core.count.call(null,self__.__extmap));
});

spec_tools.core.Spec.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4168__auto__){
var self__ = this;
var this__4168__auto____$1 = this;
var h__4030__auto__ = self__.__hash;
if(!((h__4030__auto__ == null))){
return h__4030__auto__;
} else {
var h__4030__auto____$1 = ((function (h__4030__auto__,this__4168__auto____$1){
return (function (coll__4169__auto__){
return (344961240 ^ cljs.core.hash_unordered_coll.call(null,coll__4169__auto__));
});})(h__4030__auto__,this__4168__auto____$1))
.call(null,this__4168__auto____$1);
self__.__hash = h__4030__auto____$1;

return h__4030__auto____$1;
}
});

spec_tools.core.Spec.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this11907,other11908){
var self__ = this;
var this11907__$1 = this;
return ((!((other11908 == null))) && ((this11907__$1.constructor === other11908.constructor)) && (cljs.core._EQ_.call(null,this11907__$1.spec,other11908.spec)) && (cljs.core._EQ_.call(null,this11907__$1.form,other11908.form)) && (cljs.core._EQ_.call(null,this11907__$1.type,other11908.type)) && (cljs.core._EQ_.call(null,this11907__$1.__extmap,other11908.__extmap)));
});

spec_tools.core.Spec.prototype.cljs$spec$alpha$Spec$ = cljs.core.PROTOCOL_SENTINEL;

spec_tools.core.Spec.prototype.cljs$spec$alpha$Spec$conform_STAR_$arity$2 = (function (this$,x){
var self__ = this;
var this$__$1 = this;
var transformer = spec_tools.core._STAR_transformer_STAR_;
var encode_QMARK_ = spec_tools.core._STAR_encode_QMARK__STAR_;
var temp__5455__auto__ = (cljs.core.truth_(transformer)?(cljs.core.truth_(encode_QMARK_)?spec_tools.core._encoder:spec_tools.core._decoder).call(null,transformer,this$__$1,x):null);
if(cljs.core.truth_(temp__5455__auto__)){
var transform = temp__5455__auto__;
var transformed = transform.call(null,this$__$1,x);
var or__3922__auto__ = (function (){var and__3911__auto__ = cljs.core._EQ_.call(null,spec_tools.core._PLUS_invalid_PLUS_,transformed);
if(and__3911__auto__){
return transformed;
} else {
return and__3911__auto__;
}
})();
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
var conformed = cljs.spec.alpha.conform.call(null,self__.spec,transformed);
var or__3922__auto____$1 = (function (){var and__3911__auto__ = encode_QMARK_;
if(cljs.core.truth_(and__3911__auto__)){
var and__3911__auto____$1 = cljs.core._EQ_.call(null,spec_tools.core._PLUS_invalid_PLUS_,conformed);
if(and__3911__auto____$1){
return transformed;
} else {
return and__3911__auto____$1;
}
} else {
return and__3911__auto__;
}
})();
if(cljs.core.truth_(or__3922__auto____$1)){
return or__3922__auto____$1;
} else {
return conformed;
}
}
} else {
return cljs.spec.alpha.conform.call(null,self__.spec,x);
}
});

spec_tools.core.Spec.prototype.cljs$spec$alpha$Spec$unform_STAR_$arity$2 = (function (_,x){
var self__ = this;
var ___$1 = this;
return cljs.spec.alpha.unform.call(null,self__.spec,x);
});

spec_tools.core.Spec.prototype.cljs$spec$alpha$Spec$explain_STAR_$arity$5 = (function (this$,path,via,in$,x){
var self__ = this;
var this$__$1 = this;
var problems = (cljs.core.truth_((function (){var or__3922__auto__ = cljs.spec.alpha.spec_QMARK_.call(null,self__.spec);
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return cljs.spec.alpha.regex_QMARK_.call(null,self__.spec);
}
})())?(function (){var conformed = this$__$1.cljs$spec$alpha$Spec$conform_STAR_$arity$2(null,x);
var vec__11912 = ((cljs.core._EQ_.call(null,conformed,spec_tools.core._PLUS_invalid_PLUS_))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._EQ_.call(null,spec_tools.core.conform.call(null,this$__$1,x),spec_tools.core._PLUS_invalid_PLUS_),x], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.spec.alpha.unform.call(null,self__.spec,conformed)], null));
var explain_QMARK_ = cljs.core.nth.call(null,vec__11912,(0),null);
var val = cljs.core.nth.call(null,vec__11912,(1),null);
if(cljs.core.truth_(explain_QMARK_)){
return cljs.spec.alpha.explain_STAR_.call(null,cljs.spec.alpha.specize_STAR_.call(null,self__.spec),path,via,in$,val);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"path","path",-188191168),path,new cljs.core.Keyword(null,"pred","pred",1927423397),self__.form,new cljs.core.Keyword(null,"val","val",128701612),val,new cljs.core.Keyword(null,"via","via",-1904457336),via,new cljs.core.Keyword(null,"in","in",-1531184865),in$], null)], null);
}
})():((cljs.core._EQ_.call(null,spec_tools.core._PLUS_invalid_PLUS_,this$__$1.cljs$spec$alpha$Spec$conform_STAR_$arity$2(null,x)))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"path","path",-188191168),path,new cljs.core.Keyword(null,"pred","pred",1927423397),self__.form,new cljs.core.Keyword(null,"val","val",128701612),x,new cljs.core.Keyword(null,"via","via",-1904457336),via,new cljs.core.Keyword(null,"in","in",-1531184865),in$], null)], null):null));
var spec_reason = new cljs.core.Keyword(null,"reason","reason",-2070751759).cljs$core$IFn$_invoke$arity$1(this$__$1);
var with_reason = ((function (problems,spec_reason,this$__$1){
return (function (problem){
var G__11915 = problem;
if(cljs.core.truth_(spec_reason)){
return cljs.core.assoc.call(null,G__11915,new cljs.core.Keyword(null,"reason","reason",-2070751759),spec_reason);
} else {
return G__11915;
}
});})(problems,spec_reason,this$__$1))
;
if(cljs.core.truth_(problems)){
return cljs.core.map.call(null,with_reason,problems);
} else {
return null;
}
});

spec_tools.core.Spec.prototype.cljs$spec$alpha$Spec$gen_STAR_$arity$4 = (function (this$,overrides,path,rmap){
var self__ = this;
var this$__$1 = this;
var temp__5455__auto__ = new cljs.core.Keyword(null,"gen","gen",142575302).cljs$core$IFn$_invoke$arity$1(this$__$1);
if(cljs.core.truth_(temp__5455__auto__)){
var gen = temp__5455__auto__;
return gen.call(null);
} else {
var or__3922__auto__ = cljs.spec.gen.alpha.gen_for_pred.call(null,self__.spec);
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return cljs.spec.alpha.gen_STAR_.call(null,self__.spec,overrides,path,rmap);
}
}
});

spec_tools.core.Spec.prototype.cljs$spec$alpha$Spec$with_gen_STAR_$arity$2 = (function (this$,gfn){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.call(null,this$__$1,new cljs.core.Keyword(null,"gen","gen",142575302),gfn);
});

spec_tools.core.Spec.prototype.cljs$spec$alpha$Spec$describe_STAR_$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var data = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"spec","spec",347520401),self__.form], null),spec_tools.core.extra_spec_map.call(null,this$__$1));
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("spec-tools.core","spec","spec-tools.core/spec",-497332036,null),null,(1),null)),(new cljs.core.List(null,data,null,(1),null)))));
});

spec_tools.core.Spec.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4181__auto__,k__4182__auto__){
var self__ = this;
var this__4181__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"form","form",-1624062471),null], null), null),k__4182__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4181__auto____$1),self__.__meta),k__4182__auto__);
} else {
return (new spec_tools.core.Spec(self__.spec,self__.form,self__.type,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4182__auto__)),null));
}
});

spec_tools.core.Spec.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4179__auto__,k__4180__auto__,G__11905){
var self__ = this;
var this__4179__auto____$1 = this;
var pred__11916 = cljs.core.keyword_identical_QMARK_;
var expr__11917 = k__4180__auto__;
if(cljs.core.truth_(pred__11916.call(null,new cljs.core.Keyword(null,"spec","spec",347520401),expr__11917))){
return (new spec_tools.core.Spec(G__11905,self__.form,self__.type,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__11916.call(null,new cljs.core.Keyword(null,"form","form",-1624062471),expr__11917))){
return (new spec_tools.core.Spec(self__.spec,G__11905,self__.type,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__11916.call(null,new cljs.core.Keyword(null,"type","type",1174270348),expr__11917))){
return (new spec_tools.core.Spec(self__.spec,self__.form,G__11905,self__.__meta,self__.__extmap,null));
} else {
return (new spec_tools.core.Spec(self__.spec,self__.form,self__.type,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4180__auto__,G__11905),null));
}
}
}
});

spec_tools.core.Spec.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4184__auto__){
var self__ = this;
var this__4184__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spec","spec",347520401),self__.spec,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"form","form",-1624062471),self__.form,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"type","type",1174270348),self__.type,null))], null),self__.__extmap));
});

spec_tools.core.Spec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4171__auto__,G__11905){
var self__ = this;
var this__4171__auto____$1 = this;
return (new spec_tools.core.Spec(self__.spec,self__.form,self__.type,G__11905,self__.__extmap,self__.__hash));
});

spec_tools.core.Spec.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4177__auto__,entry__4178__auto__){
var self__ = this;
var this__4177__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4178__auto__)){
return this__4177__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4178__auto__,(0)),cljs.core._nth.call(null,entry__4178__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4177__auto____$1,entry__4178__auto__);
}
});

spec_tools.core.Spec.prototype.call = (function (self__,x){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
if(cljs.core.ifn_QMARK_.call(null,self__.spec)){
return self__.spec.call(null,x);
} else {
return spec_tools.core.fail_on_invoke.call(null,this$);
}
});

spec_tools.core.Spec.prototype.apply = (function (self__,args11910){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args11910)));
});

spec_tools.core.Spec.prototype.cljs$core$IFn$_invoke$arity$1 = (function (x){
var self__ = this;
var this$ = this;
if(cljs.core.ifn_QMARK_.call(null,self__.spec)){
return self__.spec.call(null,x);
} else {
return spec_tools.core.fail_on_invoke.call(null,this$);
}
});

spec_tools.core.Spec.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"spec","spec",1988051928,null),new cljs.core.Symbol(null,"form","form",16469056,null),new cljs.core.Symbol(null,"type","type",-1480165421,null)], null);
});

spec_tools.core.Spec.cljs$lang$type = true;

spec_tools.core.Spec.cljs$lang$ctorPrSeq = (function (this__4208__auto__){
return (new cljs.core.List(null,"spec-tools.core/Spec",null,(1),null));
});

spec_tools.core.Spec.cljs$lang$ctorPrWriter = (function (this__4208__auto__,writer__4209__auto__){
return cljs.core._write.call(null,writer__4209__auto__,"spec-tools.core/Spec");
});

/**
 * Positional factory function for spec-tools.core/Spec.
 */
spec_tools.core.__GT_Spec = (function spec_tools$core$__GT_Spec(spec,form,type){
return (new spec_tools.core.Spec(spec,form,type,null,null,null));
});

/**
 * Factory function for spec-tools.core/Spec, taking a map of keywords to field values.
 */
spec_tools.core.map__GT_Spec = (function spec_tools$core$map__GT_Spec(G__11909){
return (new spec_tools.core.Spec(new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(G__11909),new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(G__11909),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(G__11909),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__11909,new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.Keyword(null,"type","type",1174270348))),null));
});

spec_tools.core.spec_QMARK_ = (function spec_tools$core$spec_QMARK_(x){
if((x instanceof spec_tools.core.Spec)){
return x;
} else {
return null;
}
});
/**
 * Returns a spec name. Like the private clojure.spec.alpha/spec-name
 */
spec_tools.core.spec_name = (function spec_tools$core$spec_name(spec){
if(cljs.core.ident_QMARK_.call(null,spec)){
return spec;
} else {
if(cljs.core.truth_(cljs.spec.alpha.regex_QMARK_.call(null,spec))){
return new cljs.core.Keyword("cljs.spec.alpha","name","cljs.spec.alpha/name",205233570).cljs$core$IFn$_invoke$arity$1(spec);
} else {
if(cljs.core.truth_((function (){var and__3911__auto__ = spec_tools.core.spec_QMARK_.call(null,spec);
if(cljs.core.truth_(and__3911__auto__)){
return new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__3911__auto__;
}
})())){
return new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(spec);
} else {
if(((!((spec == null)))?(((((spec.cljs$lang$protocol_mask$partition0$ & (131072))) || ((cljs.core.PROTOCOL_SENTINEL === spec.cljs$core$IMeta$))))?true:false):false)){
return new cljs.core.Keyword("cljs.spec.alpha","name","cljs.spec.alpha/name",205233570).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,spec));
} else {
return null;

}
}
}
}
});
/**
 * Returns a spec description.
 */
spec_tools.core.spec_description = (function spec_tools$core$spec_description(spec){
if(cljs.core.truth_((function (){var and__3911__auto__ = spec_tools.core.spec_QMARK_.call(null,spec);
if(cljs.core.truth_(and__3911__auto__)){
return new cljs.core.Keyword(null,"description","description",-1428560544).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__3911__auto__;
}
})())){
return new cljs.core.Keyword(null,"description","description",-1428560544).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return null;

}
});
/**
 * Creates a Spec intance from a map containing the following keys:
 * 
 *         :spec  the wrapped spec predicate (mandatory)
 *         :form  source code of the spec predicate, if :spec is a spec,
 *                :form is read with `s/form` out of it. For non-spec
 *                preds, spec-tools.forms/resolve-form is called, if still
 *                not available, spec-creation will fail.
 *         :type  optional type for the spec. if not set, will be auto-
 *                resolved via spec-tools.forms/resolve-type (optional)
 *       :reason  reason to be added to problems with s/explain (optional)
 *          :gen  generator function for the spec (optional)
 *         :name  name of the spec (optional)
 *  :description  description of the spec (optional)
 *        :xx/yy  any qualified keys can be added (optional)
 */
spec_tools.core.create_spec = (function spec_tools$core$create_spec(p__11921){
var map__11922 = p__11921;
var map__11922__$1 = ((((!((map__11922 == null)))?(((((map__11922.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11922.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11922):map__11922);
var m = map__11922__$1;
var spec = cljs.core.get.call(null,map__11922__$1,new cljs.core.Keyword(null,"spec","spec",347520401));
var type = cljs.core.get.call(null,map__11922__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var form = cljs.core.get.call(null,map__11922__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
if(cljs.core.truth_(spec)){
} else {
throw (new Error(["Assert failed: ","missing spec predicate","\n","spec"].join('')));
}

if(cljs.core.qualified_keyword_QMARK_.call(null,spec)){
if(cljs.core.truth_(spec_tools.core.get_spec.call(null,spec))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1([" Unable to resolve spec: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m))].join('')),"\n","(get-spec spec)"].join('')));
}
} else {
}

var spec__$1 = ((cljs.core.qualified_keyword_QMARK_.call(null,spec))?spec_tools.core.get_spec.call(null,spec):spec);
var form__$1 = (function (){var or__3922__auto__ = ((cljs.core.qualified_keyword_QMARK_.call(null,form))?cljs.spec.alpha.form.call(null,form):null);
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
var or__3922__auto____$1 = form;
if(cljs.core.truth_(or__3922__auto____$1)){
return or__3922__auto____$1;
} else {
var or__3922__auto____$2 = (function (){var form__$1 = cljs.spec.alpha.form.call(null,spec__$1);
if(!(cljs.core._EQ_.call(null,form__$1,new cljs.core.Keyword("cljs.spec.alpha","unknown","cljs.spec.alpha/unknown",651034818)))){
return form__$1;
} else {
return null;
}
})();
if(cljs.core.truth_(or__3922__auto____$2)){
return or__3922__auto____$2;
} else {
var or__3922__auto____$3 = spec_tools.form.resolve_form.call(null,spec__$1);
if(cljs.core.truth_(or__3922__auto____$3)){
return or__3922__auto____$3;
} else {
return new cljs.core.Keyword("cljs.spec.alpha","unknown","cljs.spec.alpha/unknown",651034818);
}
}
}
}
})();
var info = spec_tools.parse.parse_spec.call(null,form__$1);
var type__$1 = ((cljs.core.contains_QMARK_.call(null,m,new cljs.core.Keyword(null,"type","type",1174270348)))?type:new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(info));
var name = new cljs.core.Keyword("cljs.spec.alpha","name","cljs.spec.alpha/name",205233570).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,spec__$1));
var record = spec_tools.core.map__GT_Spec.call(null,cljs.core.merge.call(null,m,info,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"spec","spec",347520401),spec__$1,new cljs.core.Keyword(null,"form","form",-1624062471),form__$1,new cljs.core.Keyword(null,"type","type",1174270348),type__$1], null)));
var G__11924 = record;
if(cljs.core.truth_(name)){
return cljs.core.with_meta.call(null,G__11924,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.spec.alpha","name","cljs.spec.alpha/name",205233570),name], null));
} else {
return G__11924;
}
});
spec_tools.core.into_spec = (function spec_tools$core$into_spec(x){
if(cljs.core.truth_(spec_tools.core.spec_QMARK_.call(null,x))){
return x;
} else {
return spec_tools.core.create_spec.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"spec","spec",347520401),x], null));
}
});
spec_tools.core.map_spec_keys = (function spec_tools$core$map_spec_keys(spec){
var spec__$1 = (function (){var or__3922__auto__ = ((cljs.core.qualified_keyword_QMARK_.call(null,spec))?cljs.spec.alpha.form.call(null,spec):null);
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return spec;
}
})();
var info = spec_tools.parse.parse_spec.call(null,spec__$1);
return cljs.core.select_keys.call(null,info,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.Keyword("keys","req","keys/req",-320602811),new cljs.core.Keyword("keys","opt","keys/opt",-789566357)], null));
});
spec_tools.core.merge_impl = (function spec_tools$core$merge_impl(forms,spec_form,merge_spec){
var form_keys = cljs.core.map.call(null,spec_tools.core.map_spec_keys,forms);
var spec = (function (){
if(typeof spec_tools.core.t_spec_tools$core11930 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.spec.alpha.Spec}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
spec_tools.core.t_spec_tools$core11930 = (function (forms,spec_form,merge_spec,form_keys,meta11931){
this.forms = forms;
this.spec_form = spec_form;
this.merge_spec = merge_spec;
this.form_keys = form_keys;
this.meta11931 = meta11931;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
spec_tools.core.t_spec_tools$core11930.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (form_keys){
return (function (_11932,meta11931__$1){
var self__ = this;
var _11932__$1 = this;
return (new spec_tools.core.t_spec_tools$core11930(self__.forms,self__.spec_form,self__.merge_spec,self__.form_keys,meta11931__$1));
});})(form_keys))
;

spec_tools.core.t_spec_tools$core11930.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (form_keys){
return (function (_11932){
var self__ = this;
var _11932__$1 = this;
return self__.meta11931;
});})(form_keys))
;

spec_tools.core.t_spec_tools$core11930.prototype.cljs$spec$alpha$Spec$ = cljs.core.PROTOCOL_SENTINEL;

spec_tools.core.t_spec_tools$core11930.prototype.cljs$spec$alpha$Spec$conform_STAR_$arity$2 = ((function (form_keys){
return (function (_,x){
var self__ = this;
var ___$1 = this;
var conformed_vals = cljs.core.map.call(null,((function (___$1,form_keys){
return (function (p1__11927_SHARP_){
return cljs.spec.alpha.conform.call(null,p1__11927_SHARP_,x);
});})(___$1,form_keys))
,self__.forms);
if(cljs.core.truth_(cljs.core.some.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("cljs.spec.alpha","invalid","cljs.spec.alpha/invalid",-1220295119),null], null), null),conformed_vals))){
return new cljs.core.Keyword("cljs.spec.alpha","invalid","cljs.spec.alpha/invalid",-1220295119);
} else {
return cljs.core.apply.call(null,cljs.core.merge,x,cljs.core.map.call(null,((function (conformed_vals,___$1,form_keys){
return (function (p1__11928_SHARP_,p2__11929_SHARP_){
return cljs.core.select_keys.call(null,p1__11928_SHARP_,p2__11929_SHARP_);
});})(conformed_vals,___$1,form_keys))
,conformed_vals,cljs.core.map.call(null,new cljs.core.Keyword(null,"keys","keys",1068423698),self__.form_keys)));
}
});})(form_keys))
;

spec_tools.core.t_spec_tools$core11930.prototype.cljs$spec$alpha$Spec$unform_STAR_$arity$2 = ((function (form_keys){
return (function (_,x){
var self__ = this;
var ___$1 = this;
return cljs.spec.alpha.unform_STAR_.call(null,self__.merge_spec,x);
});})(form_keys))
;

spec_tools.core.t_spec_tools$core11930.prototype.cljs$spec$alpha$Spec$explain_STAR_$arity$5 = ((function (form_keys){
return (function (_,path,via,in$,x){
var self__ = this;
var ___$1 = this;
return cljs.spec.alpha.explain_STAR_.call(null,self__.merge_spec,path,via,in$,x);
});})(form_keys))
;

spec_tools.core.t_spec_tools$core11930.prototype.cljs$spec$alpha$Spec$gen_STAR_$arity$4 = ((function (form_keys){
return (function (_,overrides,path,rmap){
var self__ = this;
var ___$1 = this;
return cljs.spec.alpha.gen_STAR_.call(null,self__.merge_spec,overrides,path,rmap);
});})(form_keys))
;

spec_tools.core.t_spec_tools$core11930.getBasis = ((function (form_keys){
return (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"forms","forms",-608443419,null),new cljs.core.Symbol(null,"spec-form","spec-form",-871386429,null),new cljs.core.Symbol(null,"merge-spec","merge-spec",-1220518501,null),new cljs.core.Symbol(null,"form-keys","form-keys",1839414472,null),new cljs.core.Symbol(null,"meta11931","meta11931",-962315448,null)], null);
});})(form_keys))
;

spec_tools.core.t_spec_tools$core11930.cljs$lang$type = true;

spec_tools.core.t_spec_tools$core11930.cljs$lang$ctorStr = "spec-tools.core/t_spec_tools$core11930";

spec_tools.core.t_spec_tools$core11930.cljs$lang$ctorPrWriter = ((function (form_keys){
return (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"spec-tools.core/t_spec_tools$core11930");
});})(form_keys))
;

/**
 * Positional factory function for spec-tools.core/t_spec_tools$core11930.
 */
spec_tools.core.__GT_t_spec_tools$core11930 = ((function (form_keys){
return (function spec_tools$core$merge_impl_$___GT_t_spec_tools$core11930(forms__$1,spec_form__$1,merge_spec__$1,form_keys__$1,meta11931){
return (new spec_tools.core.t_spec_tools$core11930(forms__$1,spec_form__$1,merge_spec__$1,form_keys__$1,meta11931));
});})(form_keys))
;

}

return (new spec_tools.core.t_spec_tools$core11930(forms,spec_form,merge_spec,form_keys,cljs.core.PersistentArrayMap.EMPTY));
})()
;
return spec_tools.core.create_spec.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"spec","spec",347520401),spec,new cljs.core.Keyword(null,"form","form",-1624062471),spec_form,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"map","map",1371690461)], null),cljs.core.apply.call(null,cljs.core.merge_with,clojure.set.union,form_keys)));
});

//# sourceMappingURL=core.js.map?rel=1530627896844
