// Compiled by ClojureScript 1.10.238 {}
goog.provide('ensorcel.conjure');
goog.require('cljs.core');
goog.require('cljs_http.client');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('schema.core');
goog.require('schema.coerce');
goog.require('ensorcel.spellbook');
ensorcel.conjure.assemble_call = (function ensorcel$conjure$assemble_call(path_fn,body_fn,method){
return (function() { 
var G__17939__delegate = function (params){
var params__$1 = ((cljs.core.seq.call(null,params))?cljs.core.first.call(null,params):cljs.core.PersistentArrayMap.EMPTY);
var body = body_fn.call(null,params__$1);
var opts = (function (){var G__17937 = cljs.core.PersistentArrayMap.EMPTY;
if(cljs.core.map_QMARK_.call(null,body)){
return cljs.core.assoc.call(null,G__17937,new cljs.core.Keyword(null,"json-params","json-params",-1112693596),body);
} else {
return G__17937;
}
})();
return (function (){var G__17938 = method;
var G__17938__$1 = (((G__17938 instanceof cljs.core.Keyword))?G__17938.fqn:null);
switch (G__17938__$1) {
case "GET":
return cljs_http.client.get;

break;
case "POST":
return cljs_http.client.post;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17938__$1)].join('')));

}
})().call(null,path_fn.call(null,params__$1),opts);
};
var G__17939 = function (var_args){
var params = null;
if (arguments.length > 0) {
var G__17941__i = 0, G__17941__a = new Array(arguments.length -  0);
while (G__17941__i < G__17941__a.length) {G__17941__a[G__17941__i] = arguments[G__17941__i + 0]; ++G__17941__i;}
  params = new cljs.core.IndexedSeq(G__17941__a,0,null);
} 
return G__17939__delegate.call(this,params);};
G__17939.cljs$lang$maxFixedArity = 0;
G__17939.cljs$lang$applyTo = (function (arglist__17942){
var params = cljs.core.seq(arglist__17942);
return G__17939__delegate(params);
});
G__17939.cljs$core$IFn$_invoke$arity$variadic = G__17939__delegate;
return G__17939;
})()
;
});
ensorcel.conjure.urlify = (function ensorcel$conjure$urlify(value){
if((value instanceof cljs.core.Keyword)){
return cljs.core.name.call(null,value);
} else {
return value;

}
});
ensorcel.conjure.format_path = (function ensorcel$conjure$format_path(values,p__17943){
var vec__17944 = p__17943;
var seq__17945 = cljs.core.seq.call(null,vec__17944);
var first__17946 = cljs.core.first.call(null,seq__17945);
var seq__17945__$1 = cljs.core.next.call(null,seq__17945);
var f = first__17946;
var fragments = seq__17945__$1;
if((f == null)){
return cljs.core.PersistentVector.EMPTY;
} else {
return cljs.core.cons.call(null,((typeof f === 'string')?f:(function (){var temp__5455__auto__ = values.call(null,f);
if(cljs.core.truth_(temp__5455__auto__)){
var sub = temp__5455__auto__;
return ensorcel.conjure.urlify.call(null,sub);
} else {
throw cljs.core.ex_info.call(null,"Params do not conform to spec",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"params","params",710516235),values,new cljs.core.Keyword(null,"missing","missing",362507769),f], null));
}
})()),ensorcel.conjure.format_path.call(null,values,fragments));
}
});
ensorcel.conjure.path_fn = (function ensorcel$conjure$path_fn(base_path,path){
if(cljs.core.vector_QMARK_.call(null,path)){
return (function (p1__17947_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_path),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.apply.call(null,cljs.core.str,ensorcel.conjure.format_path.call(null,p1__17947_SHARP_,path)))].join('');
});
} else {
return cljs.core.constantly.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_path),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
}
});
ensorcel.conjure.body_fn = (function ensorcel$conjure$body_fn(args){
if(cljs.core.not.call(null,args)){
return cljs.core.constantly.call(null,null);
} else {
return (function (body){
var temp__5455__auto__ = schema.core.check.call(null,args,body);
if(cljs.core.truth_(temp__5455__auto__)){
var err = temp__5455__auto__;
throw cljs.core.ex_info.call(null,"Params do not conform to schema",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"schema","schema",-1582001791),args,new cljs.core.Keyword(null,"params","params",710516235),body,new cljs.core.Keyword(null,"err","err",-2089457205),err], null));
} else {
return body;
}
});
}
});
ensorcel.conjure.endpoint = (function ensorcel$conjure$endpoint(base_url,p__17948){
var map__17949 = p__17948;
var map__17949__$1 = ((((!((map__17949 == null)))?(((((map__17949.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17949.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17949):map__17949);
var spec = map__17949__$1;
var path = cljs.core.get.call(null,map__17949__$1,new cljs.core.Keyword(null,"path","path",-188191168));
var method = cljs.core.get.call(null,map__17949__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.call(null,map__17949__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var returns = cljs.core.get.call(null,map__17949__$1,new cljs.core.Keyword(null,"returns","returns",-615452578));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),returns,new cljs.core.Keyword(null,"call","call",-519999866),ensorcel.conjure.assemble_call.call(null,ensorcel.conjure.path_fn.call(null,base_url,ensorcel.spellbook.correct_path.call(null,path)),ensorcel.conjure.body_fn.call(null,args),method)], null);
});
ensorcel.conjure.wrap = (function ensorcel$conjure$wrap(endpoints){
return (function() { 
var G__17953__delegate = function (endpoint,args){
var map__17951 = endpoints.call(null,endpoint);
var map__17951__$1 = ((((!((map__17951 == null)))?(((((map__17951.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17951.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17951):map__17951);
var call = cljs.core.get.call(null,map__17951__$1,new cljs.core.Keyword(null,"call","call",-519999866));
var schema__$1 = cljs.core.get.call(null,map__17951__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),schema__$1,new cljs.core.Keyword(null,"call","call",-519999866),((cljs.core.seq.call(null,args))?((function (map__17951,map__17951__$1,call,schema__$1){
return (function (){
return call.call(null,cljs.core.first.call(null,args));
});})(map__17951,map__17951__$1,call,schema__$1))
:call)], null);
};
var G__17953 = function (endpoint,var_args){
var args = null;
if (arguments.length > 1) {
var G__17954__i = 0, G__17954__a = new Array(arguments.length -  1);
while (G__17954__i < G__17954__a.length) {G__17954__a[G__17954__i] = arguments[G__17954__i + 1]; ++G__17954__i;}
  args = new cljs.core.IndexedSeq(G__17954__a,0,null);
} 
return G__17953__delegate.call(this,endpoint,args);};
G__17953.cljs$lang$maxFixedArity = 1;
G__17953.cljs$lang$applyTo = (function (arglist__17955){
var endpoint = cljs.core.first(arglist__17955);
var args = cljs.core.rest(arglist__17955);
return G__17953__delegate(endpoint,args);
});
G__17953.cljs$core$IFn$_invoke$arity$variadic = G__17953__delegate;
return G__17953;
})()
;
});
/**
 * Create a REST client for a particular service from a spellbook
 */
ensorcel.conjure.client = (function ensorcel$conjure$client(var_args){
var args__4502__auto__ = [];
var len__4499__auto___17970 = arguments.length;
var i__4500__auto___17971 = (0);
while(true){
if((i__4500__auto___17971 < len__4499__auto___17970)){
args__4502__auto__.push((arguments[i__4500__auto___17971]));

var G__17972 = (i__4500__auto___17971 + (1));
i__4500__auto___17971 = G__17972;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((2) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((2)),(0),null)):null);
return ensorcel.conjure.client.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4503__auto__);
});

ensorcel.conjure.client.cljs$core$IFn$_invoke$arity$variadic = (function (p__17959,service_name,opts){
var map__17960 = p__17959;
var map__17960__$1 = ((((!((map__17960 == null)))?(((((map__17960.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17960.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17960):map__17960);
var spellbook = map__17960__$1;
var services = cljs.core.get.call(null,map__17960__$1,new cljs.core.Keyword(null,"services","services",970478783));
ensorcel.spellbook.validate_BANG_.call(null,spellbook);

if(cljs.core.truth_(services.call(null,service_name))){
} else {
throw cljs.core.ex_info.call(null,"Service does not exist in spellbook",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"service","service",-1963054559),service_name,new cljs.core.Keyword(null,"listed-services","listed-services",-333939815),cljs.core.keys.call(null,services)], null));
}

var map__17962 = cljs.core.apply.call(null,cljs.core.hash_map,opts);
var map__17962__$1 = ((((!((map__17962 == null)))?(((((map__17962.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17962.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17962):map__17962);
var host = cljs.core.get.call(null,map__17962__$1,new cljs.core.Keyword(null,"host","host",-1558485167),"localhost");
var port = cljs.core.get.call(null,map__17962__$1,new cljs.core.Keyword(null,"port","port",1534937262),(8080));
var map__17963 = services.call(null,service_name);
var map__17963__$1 = ((((!((map__17963 == null)))?(((((map__17963.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17963.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17963):map__17963);
var service = map__17963__$1;
var path = cljs.core.get.call(null,map__17963__$1,new cljs.core.Keyword(null,"path","path",-188191168));
var endpoints = cljs.core.get.call(null,map__17963__$1,new cljs.core.Keyword(null,"endpoints","endpoints",274088209));
var base_url = ["http://",cljs.core.str.cljs$core$IFn$_invoke$arity$1(host),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(port),"/api/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join('');
return ensorcel.conjure.wrap.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,((function (map__17962,map__17962__$1,host,port,map__17963,map__17963__$1,service,path,endpoints,base_url,map__17960,map__17960__$1,spellbook,services){
return (function (p__17966){
var vec__17967 = p__17966;
var k = cljs.core.nth.call(null,vec__17967,(0),null);
var v = cljs.core.nth.call(null,vec__17967,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,ensorcel.conjure.endpoint.call(null,base_url,v)], null);
});})(map__17962,map__17962__$1,host,port,map__17963,map__17963__$1,service,path,endpoints,base_url,map__17960,map__17960__$1,spellbook,services))
,endpoints)));
});

ensorcel.conjure.client.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
ensorcel.conjure.client.cljs$lang$applyTo = (function (seq17956){
var G__17957 = cljs.core.first.call(null,seq17956);
var seq17956__$1 = cljs.core.next.call(null,seq17956);
var G__17958 = cljs.core.first.call(null,seq17956__$1);
var seq17956__$2 = cljs.core.next.call(null,seq17956__$1);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__17957,G__17958,seq17956__$2);
});

ensorcel.conjure.coercions = cljs.core.PersistentArrayMap.createAsIfByAssoc([schema.core.Keyword,cljs.core.keyword,schema.core.Bool,(function (p1__17973_SHARP_){
return cljs.core._EQ_.call(null,"true",clojure.string.lower_case.call(null,p1__17973_SHARP_));
}),schema.core.Int,(function (p1__17974_SHARP_){
return parseInt(p1__17974_SHARP_);
})]);
ensorcel.conjure.parse = (function ensorcel$conjure$parse(schema__$1,result){
return (function (){var or__3922__auto__ = ensorcel.conjure.coercions.call(null,schema__$1);
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return cljs.core.identity;
}
})().call(null,result);
});
ensorcel.conjure.coerce = (function ensorcel$conjure$coerce(schema__$1,result){
if(cljs.core.coll_QMARK_.call(null,result)){
var coercer = schema.coerce.coercer.call(null,schema__$1,schema.coerce.json_coercion_matcher);
var G__17975 = result;
if(!((schema__$1 == null))){
return coercer.call(null,G__17975);
} else {
return G__17975;
}
} else {
return ensorcel.conjure.parse.call(null,schema__$1,result);
}
});
/**
 * Calls the endpoint, and if the response is successful, passes the parsed
 *   response through to the supplied functions one after the other
 */
ensorcel.conjure.call__GT_ = (function ensorcel$conjure$call__GT_(var_args){
var args__4502__auto__ = [];
var len__4499__auto___18007 = arguments.length;
var i__4500__auto___18008 = (0);
while(true){
if((i__4500__auto___18008 < len__4499__auto___18007)){
args__4502__auto__.push((arguments[i__4500__auto___18008]));

var G__18009 = (i__4500__auto___18008 + (1));
i__4500__auto___18008 = G__18009;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((1) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((1)),(0),null)):null);
return ensorcel.conjure.call__GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4503__auto__);
});

ensorcel.conjure.call__GT_.cljs$core$IFn$_invoke$arity$variadic = (function (p__17978,thens){
var map__17979 = p__17978;
var map__17979__$1 = ((((!((map__17979 == null)))?(((((map__17979.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17979.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17979):map__17979);
var call = cljs.core.get.call(null,map__17979__$1,new cljs.core.Keyword(null,"call","call",-519999866));
var schema__$1 = cljs.core.get.call(null,map__17979__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
var c__8346__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8346__auto__,map__17979,map__17979__$1,call,schema__$1){
return (function (){
var f__8347__auto__ = (function (){var switch__8323__auto__ = ((function (c__8346__auto__,map__17979,map__17979__$1,call,schema__$1){
return (function (state_17996){
var state_val_17997 = (state_17996[(1)]);
if((state_val_17997 === (1))){
var inst_17981 = call.call(null);
var state_17996__$1 = state_17996;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17996__$1,(2),inst_17981);
} else {
if((state_val_17997 === (2))){
var inst_17983 = (state_17996[(7)]);
var inst_17983__$1 = (state_17996[(2)]);
var inst_17984 = new cljs.core.Keyword(null,"success","success",1890645906).cljs$core$IFn$_invoke$arity$1(inst_17983__$1);
var state_17996__$1 = (function (){var statearr_17998 = state_17996;
(statearr_17998[(7)] = inst_17983__$1);

return statearr_17998;
})();
if(cljs.core.truth_(inst_17984)){
var statearr_17999_18010 = state_17996__$1;
(statearr_17999_18010[(1)] = (3));

} else {
var statearr_18000_18011 = state_17996__$1;
(statearr_18000_18011[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17997 === (3))){
var inst_17983 = (state_17996[(7)]);
var inst_17986 = (function (){var response = inst_17983;
return ((function (response,inst_17983,state_val_17997,c__8346__auto__,map__17979,map__17979__$1,call,schema__$1){
return (function (acc,f){
return f.call(null,acc);
});
;})(response,inst_17983,state_val_17997,c__8346__auto__,map__17979,map__17979__$1,call,schema__$1))
})();
var inst_17987 = new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(inst_17983);
var inst_17988 = ensorcel.conjure.coerce.call(null,schema__$1,inst_17987);
var inst_17989 = cljs.core.reduce.call(null,inst_17986,inst_17988,thens);
var state_17996__$1 = state_17996;
var statearr_18001_18012 = state_17996__$1;
(statearr_18001_18012[(2)] = inst_17989);

(statearr_18001_18012[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17997 === (4))){
var inst_17983 = (state_17996[(7)]);
var inst_17991 = cljs.core.ex_info.call(null,"Uncaught exception in call",inst_17983);
var inst_17992 = (function(){throw inst_17991})();
var state_17996__$1 = state_17996;
var statearr_18002_18013 = state_17996__$1;
(statearr_18002_18013[(2)] = inst_17992);

(statearr_18002_18013[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17997 === (5))){
var inst_17994 = (state_17996[(2)]);
var state_17996__$1 = state_17996;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17996__$1,inst_17994);
} else {
return null;
}
}
}
}
}
});})(c__8346__auto__,map__17979,map__17979__$1,call,schema__$1))
;
return ((function (switch__8323__auto__,c__8346__auto__,map__17979,map__17979__$1,call,schema__$1){
return (function() {
var ensorcel$conjure$state_machine__8324__auto__ = null;
var ensorcel$conjure$state_machine__8324__auto____0 = (function (){
var statearr_18003 = [null,null,null,null,null,null,null,null];
(statearr_18003[(0)] = ensorcel$conjure$state_machine__8324__auto__);

(statearr_18003[(1)] = (1));

return statearr_18003;
});
var ensorcel$conjure$state_machine__8324__auto____1 = (function (state_17996){
while(true){
var ret_value__8325__auto__ = (function (){try{while(true){
var result__8326__auto__ = switch__8323__auto__.call(null,state_17996);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8326__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8326__auto__;
}
break;
}
}catch (e18004){if((e18004 instanceof Object)){
var ex__8327__auto__ = e18004;
var statearr_18005_18014 = state_17996;
(statearr_18005_18014[(5)] = ex__8327__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17996);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18004;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8325__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18015 = state_17996;
state_17996 = G__18015;
continue;
} else {
return ret_value__8325__auto__;
}
break;
}
});
ensorcel$conjure$state_machine__8324__auto__ = function(state_17996){
switch(arguments.length){
case 0:
return ensorcel$conjure$state_machine__8324__auto____0.call(this);
case 1:
return ensorcel$conjure$state_machine__8324__auto____1.call(this,state_17996);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
ensorcel$conjure$state_machine__8324__auto__.cljs$core$IFn$_invoke$arity$0 = ensorcel$conjure$state_machine__8324__auto____0;
ensorcel$conjure$state_machine__8324__auto__.cljs$core$IFn$_invoke$arity$1 = ensorcel$conjure$state_machine__8324__auto____1;
return ensorcel$conjure$state_machine__8324__auto__;
})()
;})(switch__8323__auto__,c__8346__auto__,map__17979,map__17979__$1,call,schema__$1))
})();
var state__8348__auto__ = (function (){var statearr_18006 = f__8347__auto__.call(null);
(statearr_18006[(6)] = c__8346__auto__);

return statearr_18006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8348__auto__);
});})(c__8346__auto__,map__17979,map__17979__$1,call,schema__$1))
);

return c__8346__auto__;
});

ensorcel.conjure.call__GT_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
ensorcel.conjure.call__GT_.cljs$lang$applyTo = (function (seq17976){
var G__17977 = cljs.core.first.call(null,seq17976);
var seq17976__$1 = cljs.core.next.call(null,seq17976);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__17977,seq17976__$1);
});


//# sourceMappingURL=conjure.js.map?rel=1531077845196
