/*
 * Decompiled with CFR 0.152.
 */
package com.cartodb.impl;

import com.cartodb.CartoDBClientIF;
import com.cartodb.CartoDBException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.commons.io.IOUtils;

public class ApiKeyCartoDBClient
extends CartoDBClientIF {
    private static final String DEFAULT_API_VERSION = "1";
    private static final String ENCODING = "UTF-8";
    private static final String SQL_API_BASE_URL = "https://%s.cartodb.com/api/v%s/sql/";
    private String user;
    private String apiVersion = "1";
    private String apiURL = null;
    private String apiKey;

    public ApiKeyCartoDBClient() {
    }

    public ApiKeyCartoDBClient(String user, String apiKey) throws CartoDBException {
        this.user = user;
        this.apiKey = apiKey;
        if (this.apiKey == null || this.apiKey.length() == 0) {
            throw new CartoDBException("provided API key is not valid");
        }
        this.init();
    }

    public void init() {
        this.apiURL = String.format(SQL_API_BASE_URL, this.user, this.apiVersion);
    }

    @Override
    public String executeQuery(String sqlQuery) throws CartoDBException {
        String json = null;
        if (this.apiURL == null) {
            System.out.println("Error : uninitialized " + this.getClass().getName());
            return null;
        }
        boolean doPost = CartoDBClientIF.isWriteQuery(sqlQuery) || sqlQuery.length() >= this.MAX_SQL_GET_LENGTH;
        try {
            sqlQuery = URLEncoder.encode(sqlQuery, ENCODING);
            String params = "q=" + sqlQuery + "&api_key=" + this.apiKey;
            if (doPost) {
                URL url = new URL(this.apiURL);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setRequestMethod("POST");
                OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
                wr.write(params);
                wr.flush();
                wr.close();
                json = IOUtils.toString(conn.getInputStream(), ENCODING);
            } else {
                json = IOUtils.toString(new URL(this.apiURL + "?" + params), ENCODING);
            }
        }
        catch (MalformedURLException e) {
            throw new CartoDBException("Could not get URL " + this.apiURL + sqlQuery);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CartoDBException("Could not execute " + sqlQuery + " on CartoDB : ");
        }
        return json;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }
}

