/*
 * Decompiled with CFR 0.152.
 */
package com.cartodb.impl;

import com.cartodb.CartoDBClientIF;
import com.cartodb.CartoDBException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.commons.io.IOUtils;

public class CartoDBClient
extends CartoDBClientIF {
    private static final String DEFAULT_API_VERSION = "1";
    private static final String ENCODING = "UTF-8";
    private static final String SQL_API_BASE_URL = "http://%s.cartodb.com/api/v%s/sql/?q=";
    private String user;
    private String apiVersion = "1";
    private String apiURL = null;

    public CartoDBClient() {
    }

    public CartoDBClient(String user) {
        this.user = user;
        this.init();
    }

    public CartoDBClient(String user, String apiVersion) {
        this.user = user;
        this.apiVersion = apiVersion;
        this.init();
    }

    public void init() {
        this.apiURL = String.format(SQL_API_BASE_URL, this.user, this.apiVersion);
    }

    @Override
    public String executeQuery(String sqlQuery) throws CartoDBException {
        String json = null;
        if (this.apiURL == null) {
            System.out.println("Error : uninitialized " + this.getClass().getName());
            return null;
        }
        try {
            sqlQuery = URLEncoder.encode(sqlQuery, ENCODING);
            json = IOUtils.toString(new URL(this.apiURL + sqlQuery), ENCODING);
        }
        catch (MalformedURLException e) {
            System.out.println("Could not get URL " + this.apiURL + sqlQuery);
            throw new CartoDBException(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            throw new CartoDBException(e.getMessage());
        }
        catch (IOException e) {
            System.out.println("Could not execute " + sqlQuery + " on CartoDB : ");
            throw new CartoDBException(e.getMessage());
        }
        return json;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }
}

