/*
 * Decompiled with CFR 0.152.
 */
package com.cartodb.impl;

import com.cartodb.CartoDBAPI;
import com.cartodb.CartoDBClientIF;
import com.cartodb.CartoDBException;
import org.scribe.builder.ServiceBuilder;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.oauth.OAuthService;

public class SecuredCartoDBClient
extends CartoDBClientIF {
    private static final String DEFAULT_API_VERSION = "1";
    private static final String SQL_API_BASE_URL = "https://%s.cartodb.com/api/v%s/sql";
    private OAuthService oAuthService = null;
    private Token accessToken = null;
    private String apiVersion = "1";
    private String securedApiUrl = null;
    private String user;
    private String password;
    private String consumerKey;
    private String consumerSecret;

    public SecuredCartoDBClient() {
    }

    public SecuredCartoDBClient(String user, String password, String consumerKey, String consumerSecret) {
        this.user = user;
        this.password = password;
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.init();
    }

    public void init() {
        this.oAuthService = new ServiceBuilder().provider(new CartoDBAPI.SSL(this.user, this.password)).apiKey(this.consumerKey).apiSecret(this.consumerSecret).build();
        this.accessToken = this.oAuthService.getAccessToken(null, null);
        this.securedApiUrl = String.format(SQL_API_BASE_URL, this.user, this.apiVersion);
    }

    @Override
    public String executeQuery(String sqlQuery) throws CartoDBException {
        String json = null;
        if (this.oAuthService == null) {
            System.out.println("Error : uninitialized " + this.getClass().getName());
            return null;
        }
        OAuthRequest request = new OAuthRequest(Verb.POST, this.securedApiUrl);
        request.addBodyParameter("q", sqlQuery);
        this.oAuthService.signRequest(this.accessToken, request);
        Response response = request.send();
        if (!response.isSuccessful()) {
            throw new CartoDBException("The query " + sqlQuery + " failed. Response code : " + response.getCode());
        }
        json = response.getBody();
        return json;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }
}

