/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.services;

import org.scribe.exceptions.OAuthSignatureException;
import org.scribe.services.SignatureService;
import org.scribe.utils.Preconditions;
import org.scribe.utils.URLUtils;

public class PlaintextSignatureService
implements SignatureService {
    private static final String METHOD = "plaintext";

    public String getSignature(String baseString, String apiSecret, String tokenSecret) {
        try {
            Preconditions.checkEmptyString(apiSecret, "Api secret cant be null or empty string");
            return URLUtils.percentEncode(apiSecret) + '&' + URLUtils.percentEncode(tokenSecret);
        }
        catch (Exception e) {
            throw new OAuthSignatureException(baseString, e);
        }
    }

    public String getSignatureMethod() {
        return METHOD;
    }
}

