# clj-arnoldc

[![Build Status](https://travis-ci.org/elahti/clj-arnoldc.svg?branch=master)](https://travis-ci.org/elahti/clj-arnoldc)
[![Dependencies Status](http://jarkeeper.com/elahti/clj-arnoldc/status.svg)](http://jarkeeper.com/elahti/clj-arnoldc)

clj-arnoldc is a Clojure variant for the inspirational [ArnoldC programming language](https://github.com/lhartikk/ArnoldC). One can now write all Clojure code in the ArnoldC dialect.

# Latest version

[![Clojars Project](http://clojars.org/elahti/clj-arnoldc/latest-version.svg)](http://clojars.org/elahti/clj-arnoldc)

# CODING CONVENTIONS

All clj-arnoldc code should be written in capital letters.

# Sample application

Just like with the original ArnoldC language's main method, all clj-arnoldc programs must start with a main macro.

```clojure
(ns stop.whining
  (:require [arnoldc.showtime :refer :all]))

(ITS-SHOWTIME
 (TALK-TO-THE-HAND "YOU" "HAVE" "BEEN TERMINATED"))

=> "YOU HAVE BEEN TERMINATED"
```

If you try to talk to the hand outside `ITS-SHOWTIME` main macro

```clojure
(ns ill.be.back
  (:require [arnoldc.showtime :refer :all]))

(TALK-TO-THE-HAND "IF IT CAN BLEED" "WE CAN KILL IT")

=> Unable to resolve symbol: TALK-TO-THE-HAND in this context
```

# Documentation

The clj-arnoldc tries to mimic the original [ArnoldC programming language](https://github.com/lhartikk/ArnoldC) whenever possible.

## Printing

`(TALK-TO-THE-HAND & args)`

Prints args to `STDOUT`.

```clojure
(TALK-TO-THE-HAND "GET" "DAOWWWN")

=> "GET DAOWWWN"
```

## Defining variables

To declare variables use `HEY-CHRISTMAS-TREE` to define the symbol and `YOU-SET-US-UP` for the actual variable declaration.

```clojure
(HEY-CHRISTMAS-TREE sym
  (YOU-SET-US-UP value))
```

