(ns elasticsearch.cat
  (:refer-clojure :exclude [count])
  (:require [clojure.string :as str]
            [elasticsearch.common :refer [fmt-uri request]]))

(defn aliases [conn {:keys [name] :as req}]
  (request conn :get (fmt-uri "_cat" "aliases" name) req))

(defn allocation [conn & [{:keys [node_id] :as req}]]
  (request conn :get (fmt-uri "_cat" "allocation" node_id) req))

(defn count [conn & [{:keys [index] :as req}]]
  (request conn :get (fmt-uri "_cat" "count" index) req))

(defn fielddata [conn & [{:keys [fields] :as req}]]
  (request conn :get (fmt-uri "_cat" "fielddata" fields) req))

(defn health [conn & [req]]
  (request conn :get (fmt-uri "_cat" "health") req))

(defn indices [conn & [{:keys [index] :as req}]]
  (request conn :get (fmt-uri "_cat" "indices" index) req))

(defn master [conn & [req]]
  (request conn :get (fmt-uri "_cat" "master") req))

(defn nodeattrs [conn & [req]]
  (request conn :get (fmt-uri "_cat" "nodeattrs") req))

(defn nodes [conn & [req]]
  (request conn :get (fmt-uri "_cat" "nodes") req))

(defn pending-tasks [conn & [req]]
  (request conn :get (fmt-uri "_cat" "pending_tasks") req))

(defn plugins [conn & [req]]
  (request conn :get (fmt-uri "_cat" "plugins") req))

(defn recovery [conn & [req]]
  (request conn :get (fmt-uri "_cat" "recovery") req))

(defn repositories [conn & [req]]
  (request conn :get (fmt-uri "_cat" "repositories") req))

(defn thread-pool [conn & [req]]
  (request conn :get (fmt-uri "_cat" "thread_pool") req))

(defn shards [conn & [{:keys [index] :as req}]]
  (request conn :get (fmt-uri "_cat" "shards" index) req))

(defn segments [conn & [{:keys [index] :as req}]]
  (request conn :get (fmt-uri "_cat" "segments" index) req))

(defn snapshots [conn {:keys [repository] :as req}]
  (request conn :get (fmt-uri "_cat" "snapshots" repository) req))

(defn tasks [conn & [req]]
  (request conn :get (fmt-uri "_cat" "tasks") req))
