(ns elasticsearch.nodes
  (:require [clojure.string :as str]
            [elasticsearch.common :refer [fmt-uri request]]
            [elasticsearch.connection :as conn]
            [slingshot.slingshot :refer [try+]]))

(defn info [conn {:keys [node metric] :as req}]
  (request conn :get (fmt-uri "_nodes" node metric) req))

(defn stats [conn {:keys [node metric] :as req}]
  (request conn :get (fmt-uri "_nodes" node "stats" metric) req))
