(defproject elastic/elasticsearch-clojure "0.99.5-SNAPSHOT"
  :description "A low-level HTTP client for Elasticsearch"
  :url "https://github.com/elastic/elasticsearch-clojure"
  :license {:name "Apache License, Version 2.0"
            :url "https://www.apache.org/licenses/LICENSE-2.0"}
  :deploy-repositories [["snapshots" :clojars]
                        ["releases" :clojars]]
  :release-tasks [["vcs" "assert-committed"]
                  ["change" "version"
                   "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag"]
                  ["with-profile" "package" "deploy" "clojars"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]
                  ["vcs" "push"]]
  :global-vars {*warn-on-reflection* false}
  :min-lein-version "2.0.0"
  :dependencies [[cheshire "5.6.1"]
                 [circleci/clj-yaml "0.5.5"
                  :exclusions [[org.clojure/clojure]]]
                 [clj-http "3.4.1"
                  :exclusions [slingshot]]
                 [clj-time "0.12.2"]
                 [org.clojure/core.async "0.2.395"
                  :exclusions [org.clojure/tools.analyzer
                               org.clojure/tools.analyzer.jvm]]
                 [org.clojure/tools.analyzer "0.6.9"]
                 [org.clojure/tools.analyzer.jvm "0.6.9"]
                 [robert/bruce "0.8.0"]
                 [ring/ring-codec "1.0.1"]
                 [slingshot "0.12.2"]
                 [io.forward/yaml "1.0.3"]]
  :profiles {:dev {:dependencies [[org.clojure/clojure "1.9.0-alpha14"]]}
             :1.6 {:dependencies [[org.clojure/clojure "1.6.0"]]}
             :1.7 {:dependencies [[org.clojure/clojure "1.7.0"]]}
             :package {:dependencies [[org.clojure/clojure "1.9.0-alpha14"]]
                       :aot :all}}
  :plugins []
  :aot :all
  :main elasticsearch.codegen
  :aliases {"all" ["with-profile" "dev,1.6:dev,1.7:dev"]
            "codegen" ["run" "-m" "elasticsearch.codegen"]}
  :test-selectors {:default #(not (:integration %))
                   :integration :integration
                   :all (constantly true)})
