/*
 * Decompiled with CFR 0.152.
 */
package clojure.data;

import clojure.data.priority_map$apply_keyfn;
import clojure.data.priority_map$fn__5714;
import clojure.data.priority_map$fn__5717;
import clojure.data.priority_map$loading__7732__auto____5712;
import clojure.data.priority_map$pm_empty_by;
import clojure.data.priority_map$pm_empty_keyfn;
import clojure.data.priority_map$priority_map;
import clojure.data.priority_map$priority_map_by;
import clojure.data.priority_map$priority_map_keyfn;
import clojure.data.priority_map$priority_map_keyfn_by;
import clojure.data.priority_map.PersistentPriorityMap;
import clojure.lang.AFn;
import clojure.lang.AReference;
import clojure.lang.Compiler;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.LockingTransaction;
import clojure.lang.Namespace;
import clojure.lang.PersistentArrayMap;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Tuple;
import clojure.lang.Var;
import java.util.Arrays;
import java.util.concurrent.Callable;

public class priority_map__init {
    public static final Var const__0;
    public static final AFn const__1;
    public static final AFn const__4;
    public static final AFn const__5;
    public static final Var const__6;
    public static final AFn const__13;
    public static final Var const__14;
    public static final AFn const__18;
    public static final AFn const__21;
    public static final Var const__22;
    public static final Var const__23;
    public static final AFn const__26;
    public static final Var const__27;
    public static final AFn const__30;
    public static final Var const__31;
    public static final AFn const__34;
    public static final Var const__35;
    public static final AFn const__38;
    public static final Var const__39;
    public static final AFn const__42;
    public static final Var const__43;
    public static final AFn const__46;

    public static void load() {
        Object v3;
        Object object = ((IFn)const__0.getRawRoot()).invoke((Object)const__1);
        IPersistentMap iPersistentMap = ((AReference)Namespace.find((Symbol)((Symbol)const__1))).resetMeta((IPersistentMap)const__4);
        Object object2 = ((IFn)new priority_map$loading__7732__auto____5712()).invoke();
        if (((Symbol)const__1).equals((Object)const__5)) {
            v3 = null;
        } else {
            LockingTransaction.runInTransaction((Callable)((Callable)((Object)new priority_map$fn__5714())));
            v3 = null;
        }
        Var var = const__6;
        Var var2 = var;
        var.setMeta((IPersistentMap)const__13);
        Var var3 = const__14;
        var3.setMeta((IPersistentMap)const__18);
        Var var4 = var3;
        var3.bindRoot((Object)new priority_map$apply_keyfn());
        const__14.setMacro();
        Object v8 = null;
        Var var5 = const__14;
        Object object3 = ((IFn)new priority_map$fn__5717()).invoke();
        Var var6 = const__6;
        var6.setMeta((IPersistentMap)const__21);
        Var var7 = var6;
        var6.bindRoot((Object)new PersistentPriorityMap(((IFn)const__22.getRawRoot()).invoke(), PersistentArrayMap.EMPTY, PersistentArrayMap.EMPTY, null));
        Var var8 = const__23;
        var8.setMeta((IPersistentMap)const__26);
        Var var9 = var8;
        var8.bindRoot((Object)new priority_map$pm_empty_by());
        Var var10 = const__27;
        var10.setMeta((IPersistentMap)const__30);
        Var var11 = var10;
        var10.bindRoot((Object)new priority_map$pm_empty_keyfn());
        Var var12 = const__31;
        var12.setMeta((IPersistentMap)const__34);
        Var var13 = var12;
        var12.bindRoot((Object)new priority_map$priority_map());
        Var var14 = const__35;
        var14.setMeta((IPersistentMap)const__38);
        Var var15 = var14;
        var14.bindRoot((Object)new priority_map$priority_map_by());
        Var var16 = const__39;
        var16.setMeta((IPersistentMap)const__42);
        Var var17 = var16;
        var16.bindRoot((Object)new priority_map$priority_map_keyfn());
        Var var18 = const__43;
        var18.setMeta((IPersistentMap)const__46);
        Var var19 = var18;
        var18.bindRoot((Object)new priority_map$priority_map_keyfn_by());
    }

    public static void __init0() {
        const__0 = RT.var((String)"clojure.core", (String)"in-ns");
        const__1 = (AFn)((IObj)Symbol.intern(null, (String)"clojure.data.priority-map")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"author"), "Mark Engelberg", RT.keyword(null, (String)"doc"), "A priority map is very similar to a sorted map, but whereas a sorted map produces a\nsequence of the entries sorted by key, a priority map produces the entries sorted by value.\nIn addition to supporting all the functions a sorted map supports, a priority map\ncan also be thought of as a queue of [item priority] pairs.  To support usage as\na versatile priority queue, priority maps also support conj/peek/pop operations.\n\nThe standard way to construct a priority map is with priority-map:\nuser=> (def p (priority-map :a 2 :b 1 :c 3 :d 5 :e 4 :f 3))\n#'user/p\nuser=> p\n{:b 1, :a 2, :c 3, :f 3, :e 4, :d 5}\n\nSo :b has priority 1, :a has priority 2, and so on.\nNotice how the priority map prints in an order sorted by its priorities (i.e., the map's values)\n\nWe can use assoc to assign a priority to a new item:\nuser=> (assoc p :g 1)\n{:b 1, :g 1, :a 2, :c 3, :f 3, :e 4, :d 5}\n\nor to assign a new priority to an extant item:\nuser=> (assoc p :c 4)\n{:b 1, :a 2, :f 3, :c 4, :e 4, :d 5}\n\nWe can remove an item from the priority map:\nuser=> (dissoc p :e)\n{:b 1, :a 2, :c 3, :f 3, :d 5}\n\nAn alternative way to add to the priority map is to conj a [item priority] pair:\nuser=> (conj p [:g 0])\n{:g 0, :b 1, :a 2, :c 3, :f 3, :e 4, :d 5}\n\nor use into:\nuser=> (into p [[:g 0] [:h 1] [:i 2]])\n{:g 0, :b 1, :h 1, :a 2, :i 2, :c 3, :f 3, :e 4, :d 5}\n\nPriority maps are countable:\nuser=> (count p)\n6\n\nLike other maps, equivalence is based not on type, but on contents.\nIn other words, just as a sorted-map can be equal to a hash-map,\nso can a priority-map.\nuser=> (= p {:b 1, :a 2, :c 3, :f 3, :e 4, :d 5})\ntrue\n\nYou can test them for emptiness:\nuser=> (empty? (priority-map))\ntrue\nuser=> (empty? p)\nfalse\n\nYou can test whether an item is in the priority map:\nuser=> (contains? p :a)\ntrue\nuser=> (contains? p :g)\nfalse\n\nIt is easy to look up the priority of a given item, using any of the standard map mechanisms:\nuser=> (get p :a)\n2\nuser=> (get p :g 10)\n10\nuser=> (p :a)\n2\nuser=> (:a p)\n2\n\nPriority maps derive much of their utility by providing priority-based seq.\nNote that no guarantees are made about the order in which items of the same priority appear.\nuser=> (seq p)\n([:b 1] [:a 2] [:c 3] [:f 3] [:e 4] [:d 5])\nBecause no guarantees are made about the order of same-priority items, note that\nrseq might not be an exact reverse of the seq.  It is only guaranteed to be in\ndescending order.\nuser=> (rseq p)\n([:d 5] [:e 4] [:c 3] [:f 3] [:a 2] [:b 1])\n\nThis means first/rest/next/for/map/etc. all operate in priority order.\nuser=> (first p)\n[:b 1]\nuser=> (rest p)\n([:a 2] [:c 3] [:f 3] [:e 4] [:d 5])\n\nPriority maps support metadata:\nuser=> (meta (with-meta p {:extra :info}))\n{:extra :info}\n\nBut perhaps most importantly, priority maps can also function as priority queues.\npeek, like first, gives you the first [item priority] pair in the collection.\npop removes the first [item priority] from the collection.\n(Note that unlike rest, which returns a seq, pop returns a priority map).\n\nuser=> (peek p)\n[:b 1]\nuser=> (pop p)\n{:a 2, :c 3, :f 3, :e 4, :d 5}\n\nIt is also possible to use a custom comparator:\nuser=> (priority-map-by > :a 1 :b 2 :c 3)\n{:c 3, :b 2, :a 1}\n\nSometimes, it is desirable to have a map where the values contain more information\nthan just the priority.  For example, let's say you want a map like:\n{:a [2 :apple], :b [1 :banana], :c [3 :carrot]}\nand you want to sort the map by the numeric priority found in the pair.\n\nA common mistake is to try to solve this with a custom comparator:\n(priority-map \n  (fn [[priority1 _] [priority2 _]] (< priority1 priority2))\n  :a [2 :apple], :b [1 :banana], :c [3 :carrot])\n\nThis will not work!  In Clojure, like Java, all comparators must be total orders,\nmeaning that you can't have a tie unless the objects you are comparing are\nin fact equal.  The above comparator breaks that rule because\n[2 :apple] and [2 :apricot] tie, but are not equal.\n\nThe correct way to construct such a priority map is by specifying a keyfn, which is used\nto extract the true priority from the priority map's vals.  (Note: It might seem a little odd\nthat the priority-extraction function is called a *key*fn, even though it is applied to the\nmap's values.  This terminology is based on the docstring of clojure.core/sort-by, which\nuses `keyfn` for the function which extracts the sort order.) \n\nIn the above example,\n\nuser=> (priority-map-keyfn first :a [2 :apple], :b [1 :banana], :c [3 :carrot])\n{:b [1 :banana], :a [2 :apple], :c [3 :carrot]}\n\nYou can also combine a keyfn with a comparator that operates on the extracted priorities:\n\nuser=> (priority-map-keyfn-by \n          first >\n          :a [2 :apple], :b [1 :banana], :c [3 :carrot])\n{:c [3 :carrot], :a [2 :apple], :b [1 :banana]}\n\n \n\nAll of these operations are efficient.  Generally speaking, most operations\nare O(log n) where n is the number of distinct priorities.  Some operations\n(for example, straightforward lookup of an item's priority, or testing\nwhether a given item is in the priority map) are as efficient\nas Clojure's built-in map.\n\nThe key to this efficiency is that internally, not only does the priority map store\nan ordinary hash map of items to priority, but it also stores a sorted map that\nmaps priorities to sets of items with that priority.\n\nA typical textbook priority queue data structure supports at the ability to add\na [item priority] pair to the queue, and to pop/peek the next [item priority] pair.\nBut many real-world applications of priority queues require more features, such\nas the ability to test whether something is already in the queue, or to reassign\na priority.  For example, a standard formulation of Dijkstra's algorithm requires the\nability to reduce the priority number associated with a given item.  Once you\nthrow persistence into the mix with the desire to adjust priorities, the traditional\nstructures just don't work that well.\n\nThis particular blend of Clojure's built-in hash sets, hash maps, and sorted maps\nproved to be a great way to implement an especially flexible persistent priority queue.\n\nConnoisseurs of algorithms will note that this structure's peek operation is not O(1) as\nit would be if based upon a heap data structure, but I feel this is a small concession for\nthe blend of persistence, priority reassignment, and priority-sorted seq, which can be\nquite expensive to achieve with a heap (I did actually try this for comparison).  Furthermore,\nthis peek's logarithmic behavior is quite good (on my computer I can do a million\npeeks at a priority map with a million items in 750ms).  Also, consider that peek and pop\nusually follow one another, and even with a heap, pop is logarithmic.  So the net combination\nof peek and pop is not much different between this versatile formulation of a priority map and\na more limited heap-based one.  In a nutshell, peek, although not O(1), is unlikely to be the\nbottleneck in your program.\n\nAll in all, I hope you will find priority maps to be an easy-to-use and useful addition\nto Clojure's assortment of built-in maps (hash-map and sorted-map).\n"}));
        const__4 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"author"), "Mark Engelberg", RT.keyword(null, (String)"doc"), "A priority map is very similar to a sorted map, but whereas a sorted map produces a\nsequence of the entries sorted by key, a priority map produces the entries sorted by value.\nIn addition to supporting all the functions a sorted map supports, a priority map\ncan also be thought of as a queue of [item priority] pairs.  To support usage as\na versatile priority queue, priority maps also support conj/peek/pop operations.\n\nThe standard way to construct a priority map is with priority-map:\nuser=> (def p (priority-map :a 2 :b 1 :c 3 :d 5 :e 4 :f 3))\n#'user/p\nuser=> p\n{:b 1, :a 2, :c 3, :f 3, :e 4, :d 5}\n\nSo :b has priority 1, :a has priority 2, and so on.\nNotice how the priority map prints in an order sorted by its priorities (i.e., the map's values)\n\nWe can use assoc to assign a priority to a new item:\nuser=> (assoc p :g 1)\n{:b 1, :g 1, :a 2, :c 3, :f 3, :e 4, :d 5}\n\nor to assign a new priority to an extant item:\nuser=> (assoc p :c 4)\n{:b 1, :a 2, :f 3, :c 4, :e 4, :d 5}\n\nWe can remove an item from the priority map:\nuser=> (dissoc p :e)\n{:b 1, :a 2, :c 3, :f 3, :d 5}\n\nAn alternative way to add to the priority map is to conj a [item priority] pair:\nuser=> (conj p [:g 0])\n{:g 0, :b 1, :a 2, :c 3, :f 3, :e 4, :d 5}\n\nor use into:\nuser=> (into p [[:g 0] [:h 1] [:i 2]])\n{:g 0, :b 1, :h 1, :a 2, :i 2, :c 3, :f 3, :e 4, :d 5}\n\nPriority maps are countable:\nuser=> (count p)\n6\n\nLike other maps, equivalence is based not on type, but on contents.\nIn other words, just as a sorted-map can be equal to a hash-map,\nso can a priority-map.\nuser=> (= p {:b 1, :a 2, :c 3, :f 3, :e 4, :d 5})\ntrue\n\nYou can test them for emptiness:\nuser=> (empty? (priority-map))\ntrue\nuser=> (empty? p)\nfalse\n\nYou can test whether an item is in the priority map:\nuser=> (contains? p :a)\ntrue\nuser=> (contains? p :g)\nfalse\n\nIt is easy to look up the priority of a given item, using any of the standard map mechanisms:\nuser=> (get p :a)\n2\nuser=> (get p :g 10)\n10\nuser=> (p :a)\n2\nuser=> (:a p)\n2\n\nPriority maps derive much of their utility by providing priority-based seq.\nNote that no guarantees are made about the order in which items of the same priority appear.\nuser=> (seq p)\n([:b 1] [:a 2] [:c 3] [:f 3] [:e 4] [:d 5])\nBecause no guarantees are made about the order of same-priority items, note that\nrseq might not be an exact reverse of the seq.  It is only guaranteed to be in\ndescending order.\nuser=> (rseq p)\n([:d 5] [:e 4] [:c 3] [:f 3] [:a 2] [:b 1])\n\nThis means first/rest/next/for/map/etc. all operate in priority order.\nuser=> (first p)\n[:b 1]\nuser=> (rest p)\n([:a 2] [:c 3] [:f 3] [:e 4] [:d 5])\n\nPriority maps support metadata:\nuser=> (meta (with-meta p {:extra :info}))\n{:extra :info}\n\nBut perhaps most importantly, priority maps can also function as priority queues.\npeek, like first, gives you the first [item priority] pair in the collection.\npop removes the first [item priority] from the collection.\n(Note that unlike rest, which returns a seq, pop returns a priority map).\n\nuser=> (peek p)\n[:b 1]\nuser=> (pop p)\n{:a 2, :c 3, :f 3, :e 4, :d 5}\n\nIt is also possible to use a custom comparator:\nuser=> (priority-map-by > :a 1 :b 2 :c 3)\n{:c 3, :b 2, :a 1}\n\nSometimes, it is desirable to have a map where the values contain more information\nthan just the priority.  For example, let's say you want a map like:\n{:a [2 :apple], :b [1 :banana], :c [3 :carrot]}\nand you want to sort the map by the numeric priority found in the pair.\n\nA common mistake is to try to solve this with a custom comparator:\n(priority-map \n  (fn [[priority1 _] [priority2 _]] (< priority1 priority2))\n  :a [2 :apple], :b [1 :banana], :c [3 :carrot])\n\nThis will not work!  In Clojure, like Java, all comparators must be total orders,\nmeaning that you can't have a tie unless the objects you are comparing are\nin fact equal.  The above comparator breaks that rule because\n[2 :apple] and [2 :apricot] tie, but are not equal.\n\nThe correct way to construct such a priority map is by specifying a keyfn, which is used\nto extract the true priority from the priority map's vals.  (Note: It might seem a little odd\nthat the priority-extraction function is called a *key*fn, even though it is applied to the\nmap's values.  This terminology is based on the docstring of clojure.core/sort-by, which\nuses `keyfn` for the function which extracts the sort order.) \n\nIn the above example,\n\nuser=> (priority-map-keyfn first :a [2 :apple], :b [1 :banana], :c [3 :carrot])\n{:b [1 :banana], :a [2 :apple], :c [3 :carrot]}\n\nYou can also combine a keyfn with a comparator that operates on the extracted priorities:\n\nuser=> (priority-map-keyfn-by \n          first >\n          :a [2 :apple], :b [1 :banana], :c [3 :carrot])\n{:c [3 :carrot], :a [2 :apple], :b [1 :banana]}\n\n \n\nAll of these operations are efficient.  Generally speaking, most operations\nare O(log n) where n is the number of distinct priorities.  Some operations\n(for example, straightforward lookup of an item's priority, or testing\nwhether a given item is in the priority map) are as efficient\nas Clojure's built-in map.\n\nThe key to this efficiency is that internally, not only does the priority map store\nan ordinary hash map of items to priority, but it also stores a sorted map that\nmaps priorities to sets of items with that priority.\n\nA typical textbook priority queue data structure supports at the ability to add\na [item priority] pair to the queue, and to pop/peek the next [item priority] pair.\nBut many real-world applications of priority queues require more features, such\nas the ability to test whether something is already in the queue, or to reassign\na priority.  For example, a standard formulation of Dijkstra's algorithm requires the\nability to reduce the priority number associated with a given item.  Once you\nthrow persistence into the mix with the desire to adjust priorities, the traditional\nstructures just don't work that well.\n\nThis particular blend of Clojure's built-in hash sets, hash maps, and sorted maps\nproved to be a great way to implement an especially flexible persistent priority queue.\n\nConnoisseurs of algorithms will note that this structure's peek operation is not O(1) as\nit would be if based upon a heap data structure, but I feel this is a small concession for\nthe blend of persistence, priority reassignment, and priority-sorted seq, which can be\nquite expensive to achieve with a heap (I did actually try this for comparison).  Furthermore,\nthis peek's logarithmic behavior is quite good (on my computer I can do a million\npeeks at a priority map with a million items in 750ms).  Also, consider that peek and pop\nusually follow one another, and even with a heap, pop is logarithmic.  So the net combination\nof peek and pop is not much different between this versatile formulation of a priority map and\na more limited heap-based one.  In a nutshell, peek, although not O(1), is unlikely to be the\nbottleneck in your program.\n\nAll in all, I hope you will find priority maps to be an easy-to-use and useful addition\nto Clojure's assortment of built-in maps (hash-map and sorted-map).\n"});
        const__5 = (AFn)Symbol.intern(null, (String)"clojure.core");
        const__6 = RT.var((String)"clojure.data.priority-map", (String)"pm-empty");
        const__13 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"declared"), Boolean.TRUE, RT.keyword(null, (String)"line"), 192, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "clojure/data/priority_map.clj"});
        const__14 = RT.var((String)"clojure.data.priority-map", (String)"apply-keyfn");
        const__18 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"x")))), RT.keyword(null, (String)"line"), 194, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "clojure/data/priority_map.clj"});
        const__21 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"line"), 381, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "clojure/data/priority_map.clj"});
        const__22 = RT.var((String)"clojure.core", (String)"sorted-map");
        const__23 = RT.var((String)"clojure.data.priority-map", (String)"pm-empty-by");
        const__26 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"comparator")))), RT.keyword(null, (String)"line"), 382, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "clojure/data/priority_map.clj"});
        const__27 = RT.var((String)"clojure.data.priority-map", (String)"pm-empty-keyfn");
        const__30 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"private"), Boolean.TRUE, RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(Tuple.create((Object)Symbol.intern(null, (String)"keyfn")), Tuple.create((Object)Symbol.intern(null, (String)"keyfn"), (Object)Symbol.intern(null, (String)"comparator")))), RT.keyword(null, (String)"line"), 383, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "clojure/data/priority_map.clj"});
        const__31 = RT.var((String)"clojure.data.priority-map", (String)"priority-map");
        const__34 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(((IObj)Tuple.create((Object)Symbol.intern(null, (String)"&"), (Object)Symbol.intern(null, (String)"keyvals"))).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"pre"), Tuple.create((Object)((IObj)PersistentList.create(Arrays.asList(Symbol.intern(null, (String)"even?"), ((IObj)PersistentList.create(Arrays.asList(Symbol.intern(null, (String)"count"), Symbol.intern(null, (String)"keyvals")))).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"line"), 394, RT.keyword(null, (String)"column"), 17}))))).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"line"), 394, RT.keyword(null, (String)"column"), 10})))})))), RT.keyword(null, (String)"doc"), "Usage: (priority-map key val key val ...)\nReturns a new priority map with optional supplied mappings.\n(priority-map) returns an empty priority map.", RT.keyword(null, (String)"line"), 389, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "clojure/data/priority_map.clj"});
        const__35 = RT.var((String)"clojure.data.priority-map", (String)"priority-map-by");
        const__38 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(((IObj)Tuple.create((Object)Symbol.intern(null, (String)"comparator"), (Object)Symbol.intern(null, (String)"&"), (Object)Symbol.intern(null, (String)"keyvals"))).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"pre"), Tuple.create((Object)((IObj)PersistentList.create(Arrays.asList(Symbol.intern(null, (String)"even?"), ((IObj)PersistentList.create(Arrays.asList(Symbol.intern(null, (String)"count"), Symbol.intern(null, (String)"keyvals")))).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"line"), 402, RT.keyword(null, (String)"column"), 17}))))).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"line"), 402, RT.keyword(null, (String)"column"), 10})))})))), RT.keyword(null, (String)"doc"), "Usage: (priority-map comparator key val key val ...)\nReturns a new priority map with custom comparator and optional supplied mappings.\n(priority-map-by comparator) yields an empty priority map with custom comparator.", RT.keyword(null, (String)"line"), 397, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "clojure/data/priority_map.clj"});
        const__39 = RT.var((String)"clojure.data.priority-map", (String)"priority-map-keyfn");
        const__42 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(((IObj)Tuple.create((Object)Symbol.intern(null, (String)"keyfn"), (Object)Symbol.intern(null, (String)"&"), (Object)Symbol.intern(null, (String)"keyvals"))).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"pre"), Tuple.create((Object)((IObj)PersistentList.create(Arrays.asList(Symbol.intern(null, (String)"even?"), ((IObj)PersistentList.create(Arrays.asList(Symbol.intern(null, (String)"count"), Symbol.intern(null, (String)"keyvals")))).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"line"), 411, RT.keyword(null, (String)"column"), 17}))))).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"line"), 411, RT.keyword(null, (String)"column"), 10})))})))), RT.keyword(null, (String)"doc"), "Usage: (priority-map-keyfn keyfn key val key val ...)\nReturns a new priority map with custom keyfn and optional supplied mappings.\nThe priority is determined by comparing (keyfn val). \n(priority-map-keyfn keyfn) yields an empty priority map with custom keyfn.", RT.keyword(null, (String)"line"), 405, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "clojure/data/priority_map.clj"});
        const__43 = RT.var((String)"clojure.data.priority-map", (String)"priority-map-keyfn-by");
        const__46 = (AFn)RT.map((Object[])new Object[]{RT.keyword(null, (String)"arglists"), PersistentList.create(Arrays.asList(((IObj)Tuple.create((Object)Symbol.intern(null, (String)"keyfn"), (Object)Symbol.intern(null, (String)"comparator"), (Object)Symbol.intern(null, (String)"&"), (Object)Symbol.intern(null, (String)"keyvals"))).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"pre"), Tuple.create((Object)((IObj)PersistentList.create(Arrays.asList(Symbol.intern(null, (String)"even?"), ((IObj)PersistentList.create(Arrays.asList(Symbol.intern(null, (String)"count"), Symbol.intern(null, (String)"keyvals")))).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"line"), 420, RT.keyword(null, (String)"column"), 17}))))).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"line"), 420, RT.keyword(null, (String)"column"), 10})))})))), RT.keyword(null, (String)"doc"), "Usage: (priority-map-keyfn-by keyfn comparator key val key val ...)\nReturns a new priority map with custom keyfn, custom comparator, and optional supplied mappings.\nThe priority is determined by comparing (keyfn val).\n(priority-map-keyfn-by keyfn comparator) yields an empty priority map with custom keyfn and comparator.", RT.keyword(null, (String)"line"), 414, RT.keyword(null, (String)"column"), 1, RT.keyword(null, (String)"file"), "clojure/data/priority_map.clj"});
    }

    static {
        priority_map__init.__init0();
        Compiler.pushNSandLoader((ClassLoader)RT.classForName((String)"clojure.data.priority_map__init").getClassLoader());
        try {
            priority_map__init.load();
        }
        catch (Throwable throwable) {
            Var.popThreadBindings();
            throw throwable;
        }
        Var.popThreadBindings();
    }
}

