(ns elasticsearch.common
  (:require [clojure.string :as str]
            [clojure.spec :as s]
            [elasticsearch.connection :as conn]
            [elasticsearch.connection.http :as http]
            [ring.util.codec :refer [url-encode]]))

(defn coerce [x]
  (cond  (coll? x) (str/join "," x)
         (string? x) (str/replace x #" " "")
         :else (str x)))

(defn fmt-uri [& parts]
  (->> parts
       (filter identity)
       (map coerce)
       (map url-encode)
       (str/join "/")
       (format "/%s")))

(defn sanitize-params [req]
  (let [params (dissoc req :index :type :id :body :ignore :uri)]
    (locking #'clojure.pprint/pprint
      (clojure.pprint/pprint params))
    (reduce-kv (fn [acc k v]
                 (let [v (if (coll? v)
                           (str/join "," v)
                           v)]
                   (assoc acc k v)))
               {}
               params)))

(defn query-params [req]
  (sanitize-params req))

(s/fdef request
        :args
        (s/alt
         :no-opts
         (s/cat :conn ::http/connection
                :method keyword?
                :uri string?
                :req (s/nilable map?))
         :with-opts
         (s/cat :conn ::http/connection
                :method keyword?
                :uri string?
                :req (s/nilable map?)
                :opts sequential?)))
(defn request [conn method uri req & [opts]]
  (let [req (assoc req :uri uri)]
    (conn/request conn method (merge req opts))))
