(ns elasticsearch.ingest
  (:refer-clojure :exclude [get])
  (:require [clojure.string :as str]
            [elasticsearch.common :refer [fmt-uri request]]
            [elasticsearch.connection :as conn]
            [slingshot.slingshot :refer [try+]]))

(defn put-pipeline [conn {:keys [id] :as req}]
  (request conn :put (fmt-uri "_ingest" "pipeline" id) req))

(defn get-pipeline [conn {:keys [id] :as req}]
  (request conn :get (fmt-uri "_ingest" "pipeline" id) req))

(defn delete-pipeline [conn {:keys [id] :as req}]
  (request conn :delete (fmt-uri "_ingest" "pipeline" id) req))

(defn simulate-pipeline [conn {:keys [id] :as req}]
  (request conn :post (fmt-uri "_ingest" "pipeline" id "_simulate") req))
