(ns elasticsearch.snapshot
  (:refer-clojure :exclude [get])
  (:require [clojure.string :as str]
            [elasticsearch.common :refer [fmt-uri request]]
            [elasticsearch.connection :as conn]
            [slingshot.slingshot :refer [try+]]))

(defn create-repository [conn {:keys [repository] :as req}]
  (request conn :put (fmt-uri "_snapshot" repository) req))

(defn verify-repository [conn {:keys [repository] :as req}]
  (request conn :post (fmt-uri "_snapshot" repository "_verify") req))

(defn get-repository [conn {:keys [repository] :as req}]
  (request conn :get (fmt-uri "_snapshot" repository) req))

(defn delete-repository [conn {:keys [repository] :as req}]
  (request conn :delete (fmt-uri "_snapshot" repository) req))

(defn create [conn {:keys [repository snapshot] :as req}]
  (request conn :put (fmt-uri "_snapshot" repository snapshot) req))

(defn get [conn {:keys [repository snapshot] :as req}]
  (request conn :get (fmt-uri "_snapshot" repository snapshot) req))

(defn restore [conn {:keys [repository snapshot] :as req}]
  (request conn :post (fmt-uri "_snapshot" repository snapshot "_restore") req))

(defn delete [conn {:keys [repository snapshot] :as req}]
  (request conn :delete (fmt-uri "_snapshot" repository snapshot) req))

(defn delete-all-snapshots [conn]
  (let [repos (map name (keys (get-repository conn {:repository "*"})))]
    (doseq [repo repos
            :let [snaps (:snapshots
                         (get conn {:repository repo
                                    :throw-exceptions false}))]
            :when (seq snaps)]
      (doseq [snap (map :snapshot snaps)]
        (delete conn {:repository repo
                      :snapshot snap})))))
