(defproject elastic/elasticsearch-clojure "0.99.5"
  :description "A low-level HTTP client for Elasticsearch"
  :url "https://github.com/elastic/elasticsearch-clojure"
  :license {:name "Apache License, Version 2.0"
            :url "https://www.apache.org/licenses/LICENSE-2.0"}
  :deploy-repositories [["snapshots" :clojars]
                        ["releases" :clojars]]
  :release-tasks [["vcs" "assert-committed"]
                  ["change" "version"
                   "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag"]
                  ["with-profile" "package" "deploy" "clojars"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]
                  ["vcs" "push"]]
  :global-vars {*warn-on-reflection* false}
  :min-lein-version "2.0.0"
  :exclusions [org.clojure/clojure]
  :dependencies [[cheshire "5.7.1"]
                 [circleci/clj-yaml "0.5.5"]
                 [clj-http "3.5.0"
                  :exclusions [slingshot]]
                 [clj-time "0.13.0"]
                 [org.clojure/core.async "0.3.442"
                  :exclusions [org.clojure/tools.analyzer
                               org.clojure/tools.analyzer.jvm]]
                 [org.clojure/tools.analyzer "0.6.9"]
                 [org.clojure/tools.analyzer.jvm "0.7.0"]
                 [robert/bruce "0.8.0"]
                 [ring/ring-codec "1.0.1"]
                 [slingshot "0.12.2"]
                 [io.forward/yaml "1.0.6"]]
  :profiles {:dev {:dependencies [[org.clojure/clojure "1.9.0-alpha16"]]}
             :1.8 {:dependencies [[org.clojure/clojure "1.8.0"]
                                  [clojure-future-spec "1.9.0-alpha16-1"]]}
             :package {:dependencies [[org.clojure/clojure "1.9.0-alpha16"]]
                       :aot :all}}
  :plugins []
  :aot :all
  :main elasticsearch.codegen
  :aliases {"all" ["with-profile" "dev,1.8:dev"]
            "codegen" ["run" "-m" "elasticsearch.codegen"]}
  :test-selectors {:default #(not (:integration %))
                   :integration :integration
                   :all (constantly true)})
