(ns elasticsearch.snapshot
  (:refer-clojure :exclude [count get])
  (:require [clojure.string :as str]
            [elasticsearch.common :refer [format-uri request]]))

;; Begin generated code. Everything above will be kept and anything below will be regenerated.

(defn create
  ([conn repository snapshot] (create conn repository snapshot nil))
  ([conn repository snapshot req]
    (request
      conn
      :put
      (format-uri "_snapshot" repository snapshot)
      req)))

(defn create-repository
  ([conn repository req]
    (request conn :put (format-uri "_snapshot" repository) req)))

(defn delete
  ([conn repository snapshot] (delete conn repository snapshot nil))
  ([conn repository snapshot req]
    (request
      conn
      :delete
      (format-uri "_snapshot" repository snapshot)
      req)))

(defn delete-repository
  ([conn repository] (delete-repository conn repository nil))
  ([conn repository req]
    (request conn :delete (format-uri "_snapshot" repository) req)))

(defn get
  ([conn repository snapshot] (get conn repository snapshot nil))
  ([conn repository snapshot req]
    (request
      conn
      :get
      (format-uri "_snapshot" repository snapshot)
      req)))

(defmulti get-repository (fn [_ & args] (map? (last args))))

(defmethod
 get-repository
 true
 ([conn req] (get-repository conn nil req))
 ([conn repository req]
  (request conn :get (format-uri "_snapshot" repository) req)))

(defmethod
 get-repository
 false
 ([conn] (get-repository conn nil))
 ([conn repository]
  (request conn :get (format-uri "_snapshot" repository) {})))

(defn restore
  ([conn repository snapshot] (restore conn repository snapshot nil))
  ([conn repository snapshot req]
    (request
      conn
      :post
      (format-uri "_snapshot" repository snapshot "_restore")
      req)))

(defmulti status (fn [_ & args] (map? (last args))))

(defmethod
 status
 true
 ([conn req] (status conn nil req))
 ([conn repository req] (status conn repository nil req))
 ([conn repository snapshot req]
  (request
   conn
   :get
   (format-uri "_snapshot" repository snapshot "_status")
   req)))

(defmethod
 status
 false
 ([conn] (status conn nil))
 ([conn repository] (status conn repository nil))
 ([conn repository snapshot]
  (request
   conn
   :get
   (format-uri "_snapshot" repository snapshot "_status")
   {})))

(defn verify-repository
  ([conn repository] (verify-repository conn repository nil))
  ([conn repository req]
    (request
      conn
      :post
      (format-uri "_snapshot" repository "_verify")
      req)))
