(ns elasticsearch.ingest
  (:refer-clojure :exclude [count])
  (:require [clojure.string :as str]
            [elasticsearch.common :refer [format-uri request]]))

;; Begin generated code. Everything above will be kept and anything below will be regenerated.

(defn delete-pipeline
  ([conn id] (delete-pipeline conn id nil))
  ([conn id req]
    (request conn :delete (format-uri "_ingest" "pipeline" id) req)))

(defmulti get-pipeline (fn [_ & args] (map? (last args))))

(defmethod
 get-pipeline
 true
 ([conn req] (get-pipeline conn nil req))
 ([conn id req]
  (request conn :get (format-uri "_ingest" "pipeline" id) req)))

(defmethod
 get-pipeline
 false
 ([conn] (get-pipeline conn nil))
 ([conn id]
  (request conn :get (format-uri "_ingest" "pipeline" id) {})))

(defn put-pipeline
  ([conn id req]
    (request conn :put (format-uri "_ingest" "pipeline" id) req)))

(defn simulate
  ([conn req] (simulate conn nil req))
  ([conn id req]
    (request
      conn
      :post
      (format-uri "_ingest" "pipeline" id "_simulate")
      req)))

(defn processor
  ([conn] (processor conn nil))
  ([conn req]
    (request conn :get (format-uri "_ingest" "processor" "grok") req)))
