(ns elasticsearch.nodes
  (:refer-clojure :exclude [count])
  (:require [clojure.string :as str]
            [elasticsearch.common :refer [format-uri request]]))

;; Begin generated code. Everything above will be kept and anything below will be regenerated.

(defmulti hot-threads (fn [_ & args] (map? (last args))))

(defmethod
 hot-threads
 true
 ([conn req] (hot-threads conn nil req))
 ([conn node-id req]
  (request conn :get (format-uri "_nodes" node-id "hotthreads") req)))

(defmethod
 hot-threads
 false
 ([conn] (hot-threads conn nil))
 ([conn node-id]
  (request conn :get (format-uri "_nodes" node-id "hotthreads") {})))

(defmulti info (fn [_ & args] (map? (last args))))

(defmethod
 info
 true
 ([conn req] (info conn nil req))
 ([conn node-id req] (info conn node-id nil req))
 ([conn node-id metric req]
  (request conn :get (format-uri "_nodes" node-id metric) req)))

(defmethod
 info
 false
 ([conn] (info conn nil))
 ([conn node-id] (info conn node-id nil))
 ([conn node-id metric]
  (request conn :get (format-uri "_nodes" node-id metric) {})))

(defmulti stats (fn [_ & args] (map? (last args))))

(defmethod
 stats
 true
 ([conn req] (stats conn nil req))
 ([conn metric req] (stats conn metric nil req))
 ([conn metric index-metric req]
  (stats conn metric index-metric nil req))
 ([conn metric index-metric node-id req]
  (request
   conn
   :get
   (format-uri "_nodes" node-id "stats" metric index-metric)
   req)))

(defmethod
 stats
 false
 ([conn] (stats conn nil))
 ([conn metric] (stats conn metric nil))
 ([conn metric index-metric] (stats conn metric index-metric nil))
 ([conn metric index-metric node-id]
  (request
   conn
   :get
   (format-uri "_nodes" node-id "stats" metric index-metric)
   {})))
