(ns elasticsearch.tasks
  (:refer-clojure :exclude [get list])
  (:require [clojure.string :as str]
            [elasticsearch.common :refer [format-uri request]]))

;; Begin generated code. Everything above will be kept and anything below will be regenerated.

(defmulti cancel (fn [_ & args] (map? (last args))))

(defmethod
 cancel
 true
 ([conn req] (cancel conn nil req))
 ([conn task-id req]
  (request conn :post (format-uri "_tasks" task-id "_cancel") req)))

(defmethod
 cancel
 false
 ([conn] (cancel conn nil))
 ([conn task-id]
  (request conn :post (format-uri "_tasks" task-id "_cancel") {})))

(defmulti get (fn [_ & args] (map? (last args))))

(defmethod
 get
 true
 ([conn req] (get conn nil req))
 ([conn task-id req]
  (request conn :get (format-uri "_tasks" task-id) req)))

(defmethod
 get
 false
 ([conn] (get conn nil))
 ([conn task-id] (request conn :get (format-uri "_tasks" task-id) {})))

(defn list
  ([conn] (list conn nil))
  ([conn req] (request conn :get (format-uri "_tasks") req)))
