(ns elasticsearch.cat
  (:refer-clojure :exclude [count])
  (:require [clojure.string :as str]
            [elasticsearch.common :refer [format-uri request]]))

;; Begin generated code. Everything above will be kept and anything below will be regenerated.

(defmulti aliases (fn [_ & args] (map? (last args))))

(defmethod
 aliases
 true
 ([conn req] (aliases conn nil req))
 ([conn name req]
  (request conn :get (format-uri "_cat" "aliases" name) req)))

(defmethod
 aliases
 false
 ([conn] (aliases conn nil))
 ([conn name]
  (request conn :get (format-uri "_cat" "aliases" name) {})))

(defmulti allocation (fn [_ & args] (map? (last args))))

(defmethod
 allocation
 true
 ([conn req] (allocation conn nil req))
 ([conn node-id req]
  (request conn :get (format-uri "_cat" "allocation" node-id) req)))

(defmethod
 allocation
 false
 ([conn] (allocation conn nil))
 ([conn node-id]
  (request conn :get (format-uri "_cat" "allocation" node-id) {})))

(defmulti count (fn [_ & args] (map? (last args))))

(defmethod
 count
 true
 ([conn req] (count conn nil req))
 ([conn index req]
  (request conn :get (format-uri "_cat" "count" index) req)))

(defmethod
 count
 false
 ([conn] (count conn nil))
 ([conn index]
  (request conn :get (format-uri "_cat" "count" index) {})))

(defmulti fielddata (fn [_ & args] (map? (last args))))

(defmethod
 fielddata
 true
 ([conn req] (fielddata conn nil req))
 ([conn fields req]
  (request conn :get (format-uri "_cat" "fielddata" fields) req)))

(defmethod
 fielddata
 false
 ([conn] (fielddata conn nil))
 ([conn fields]
  (request conn :get (format-uri "_cat" "fielddata" fields) {})))

(defn health
  ([conn] (health conn nil))
  ([conn req] (request conn :get (format-uri "_cat" "health") req)))

(defn help
  ([conn] (help conn nil))
  ([conn req] (request conn :get (format-uri "_cat") req)))

(defmulti indices (fn [_ & args] (map? (last args))))

(defmethod
 indices
 true
 ([conn req] (indices conn nil req))
 ([conn index req]
  (request conn :get (format-uri "_cat" "indices" index) req)))

(defmethod
 indices
 false
 ([conn] (indices conn nil))
 ([conn index]
  (request conn :get (format-uri "_cat" "indices" index) {})))

(defn master
  ([conn] (master conn nil))
  ([conn req] (request conn :get (format-uri "_cat" "master") req)))

(defn nodeattrs
  ([conn] (nodeattrs conn nil))
  ([conn req] (request conn :get (format-uri "_cat" "nodeattrs") req)))

(defn nodes
  ([conn] (nodes conn nil))
  ([conn req] (request conn :get (format-uri "_cat" "nodes") req)))

(defn pending-tasks
  ([conn] (pending-tasks conn nil))
  ([conn req]
    (request conn :get (format-uri "_cat" "pending_tasks") req)))

(defn plugins
  ([conn] (plugins conn nil))
  ([conn req] (request conn :get (format-uri "_cat" "plugins") req)))

(defmulti recovery (fn [_ & args] (map? (last args))))

(defmethod
 recovery
 true
 ([conn req] (recovery conn nil req))
 ([conn index req]
  (request conn :get (format-uri "_cat" "recovery" index) req)))

(defmethod
 recovery
 false
 ([conn] (recovery conn nil))
 ([conn index]
  (request conn :get (format-uri "_cat" "recovery" index) {})))

(defn repositories
  ([conn] (repositories conn nil))
  ([conn req]
    (request conn :get (format-uri "_cat" "repositories") req)))

(defmulti segments (fn [_ & args] (map? (last args))))

(defmethod
 segments
 true
 ([conn req] (segments conn nil req))
 ([conn index req]
  (request conn :get (format-uri "_cat" "segments" index) req)))

(defmethod
 segments
 false
 ([conn] (segments conn nil))
 ([conn index]
  (request conn :get (format-uri "_cat" "segments" index) {})))

(defmulti shards (fn [_ & args] (map? (last args))))

(defmethod
 shards
 true
 ([conn req] (shards conn nil req))
 ([conn index req]
  (request conn :get (format-uri "_cat" "shards" index) req)))

(defmethod
 shards
 false
 ([conn] (shards conn nil))
 ([conn index]
  (request conn :get (format-uri "_cat" "shards" index) {})))

(defn snapshots
  ([conn repository] (snapshots conn repository nil))
  ([conn repository req]
    (request conn :get (format-uri "_cat" "snapshots" repository) req)))

(defn tasks
  ([conn] (tasks conn nil))
  ([conn req] (request conn :get (format-uri "_cat" "tasks") req)))

(defmulti templates (fn [_ & args] (map? (last args))))

(defmethod
 templates
 true
 ([conn req] (templates conn nil req))
 ([conn name req]
  (request conn :get (format-uri "_cat" "templates" name) req)))

(defmethod
 templates
 false
 ([conn] (templates conn nil))
 ([conn name]
  (request conn :get (format-uri "_cat" "templates" name) {})))

(defmulti thread-pool (fn [_ & args] (map? (last args))))

(defmethod
 thread-pool
 true
 ([conn req] (thread-pool conn nil req))
 ([conn thread-pool-patterns req]
  (request
   conn
   :get
   (format-uri "_cat" "thread_pool" thread-pool-patterns)
   req)))

(defmethod
 thread-pool
 false
 ([conn] (thread-pool conn nil))
 ([conn thread-pool-patterns]
  (request
   conn
   :get
   (format-uri "_cat" "thread_pool" thread-pool-patterns)
   {})))
