(ns elasticsearch.data-stream
  (:refer-clojure :exclude [get delete ensure list])
  (:require [elasticsearch.common :refer [format-uri request]]
            [slingshot.slingshot :refer [throw+ try+]]))

(defn create [conn data-stream]
  (request conn :put (format-uri "_data_stream" data-stream) {}))

(defn ensure [& args]
  (try+
   (apply create args)
   (catch [:status 400] e
     (case (-> e :body :error :type)
       "resource_already_exists_exception" true
       (throw+ e)))))

(defn delete [conn data-stream]
  (request conn :delete (format-uri "_data_stream" data-stream) {}))

(defn list [conn]
  (request conn :get (format-uri "_data_stream") {}))

(defn get [conn data-stream]
  (request conn :get (format-uri "_data_stream" data-stream) {}))

(defn exists? [conn data-stream]
  (try+
   (get conn data-stream)
   true
   (catch [:status 404] _
     false)))
