(defproject {{project-name}} "0.1.0-SNAPSHOT"
  :description "FIXME: write description"
  :url "https://www.elbenwald.de"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}

  :repositories [["releases" {:url "s3p://ew-tools/releases"
                              :creds :gpg}]]

  :plugins [[s3-wagon-private "1.3.1"
             :exclusions [commons-logging]]]

  :dependencies [; common
                 [clj-time "0.15.1"]
                 [com.taoensso/encore "2.109.0"]
                 [cprop "0.1.13"]
                 [me.raynes/fs "1.4.6"]
                 [medley "1.1.0"]
                 [org.clojure/clojure "1.10.0"]
                 [org.clojure/algo.monads "0.1.6"]
                 [org.clojure/core.async "0.4.490"]
                 [org.clojure/tools.logging "0.4.1"]
                 [prismatic/schema "1.1.10"]
                 [prismatic/plumbing "0.5.5"]
                 [proto-repl "0.3.1"]
                 [slingshot "0.12.2"]
                 [uncomplicate/fluokitten "0.9.1"]

                 ; libs
                 [org.clojure/tools.cli "0.4.2"]
                 [de.elbenwald/common "0.10.1"]

                 ; conflicts
                 [org.clojure/tools.macro "0.1.5"]
                 [org.clojure/tools.namespace "0.3.0-alpha4"]]

  :min-lein-version "2.0.0"

  :jvm-opts []

  :source-paths ["src"]
  :test-paths ["test"]
  :resource-paths ["resources"]
  :target-path "target/%s/"

  :profiles
  {:provided {:dependencies [[ch.qos.logback/logback-classic "1.2.3"]]}

   :dev           [:project/dev]
   :test          [:project/dev :project/test]
   :midje         [:project/dev :project/test :project/midje]

   :project/dev  {:dependencies [[midje "1.9.8"]]
                  :jvm-opts ["-Dconf=dev-config.edn"]
                  :plugins [[lein-midje "3.2.1"
                             :exclusions [org.clojure/clojure]]]
                  :repl-options {:init-ns user}
                  :resource-paths ["env/dev/resources"]
                  :source-paths ["env/dev/clj"]}
   :project/test {:jvm-opts ["-Dconf=test-config.edn"]
                  :resource-paths ["env/test/resources"]
                  :source-paths ["env/test/clj"]}
   :project/midje {}

   :release {:release-tasks [["vcs" "assert-committed"]
                             ["change" "version" "leiningen.release/bump-version" "release"]
                             ["vcs" "commit"]]}
   :deploy {:release-tasks [["vcs" "assert-committed"]
                            ["vcs" "tag"]
                            ["deploy"]]}
                            ;["vcs" "push"] ; FIXME store ssh password
   :snapshot {:release-tasks [["vcs" "assert-committed"]
                              ["change" "version" "leiningen.release/bump-version"]
                              ["vcs" "commit"]]}}

  :release-tasks []
  :deploy-branches ["master"]

  :main {{name}}.core
  :aot [{{name}}.core])
